/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.string;

import docking.DialogComponentProvider;
import docking.action.DockingActionIf;
import docking.action.MenuData;
import ghidra.app.context.NavigatableActionContext;
import ghidra.app.context.NavigatableContextAction;
import ghidra.app.plugin.ProgramPlugin;
import ghidra.app.plugin.core.string.SearchStringDialog;
import ghidra.app.plugin.core.string.StringTableOptions;
import ghidra.app.plugin.core.string.StringTableProvider;
import ghidra.app.services.GoToService;
import ghidra.framework.plugintool.PluginInfo;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.util.PluginStatus;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeIterator;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.Program;
import ghidra.program.util.ProgramSelection;
import ghidra.util.HelpLocation;
import java.util.ArrayList;
import java.util.List;

@PluginInfo(status=PluginStatus.RELEASED, packageName="Ghidra Core", category="Common", shortDescription="Strings Table", description="Displays Strings in a program.", servicesRequired={GoToService.class})
public class StringTablePlugin
extends ProgramPlugin {
    static final String SEARCH_ACTION_NAME = "Search for Strings";
    private List<StringTableProvider> transientProviders = new ArrayList<StringTableProvider>();

    public StringTablePlugin(PluginTool tool) {
        super(tool);
    }

    protected void init() {
        super.init();
        this.createActions();
    }

    private void createActions() {
        NavigatableContextAction stringSearchAction = new NavigatableContextAction(SEARCH_ACTION_NAME, this.getName()){

            @Override
            public void actionPerformed(NavigatableActionContext context) {
                StringTablePlugin.this.showSearchDialog(context.getSelection());
            }
        };
        stringSearchAction.setHelpLocation(new HelpLocation("Search", SEARCH_ACTION_NAME));
        stringSearchAction.setMenuBarData(new MenuData(new String[]{"&Search", "For &Strings..."}, null, "search for", -1, "Strings1"));
        stringSearchAction.setDescription(this.getPluginDescription().getDescription());
        stringSearchAction.addToWindowWhen(NavigatableActionContext.class);
        this.tool.addAction((DockingActionIf)stringSearchAction);
    }

    protected void showSearchDialog(ProgramSelection selection) {
        AddressSet view = new AddressSet();
        AddressRangeIterator iter = selection.getAddressRanges();
        while (iter.hasNext()) {
            AddressRange range = (AddressRange)iter.next();
            view.addRange(range.getMinAddress(), range.getMaxAddress());
        }
        SearchStringDialog searchStringDialog = new SearchStringDialog(this, (AddressSetView)view);
        this.tool.showDialog((DialogComponentProvider)searchStringDialog);
    }

    public void dispose() {
        ArrayList<StringTableProvider> list = new ArrayList<StringTableProvider>(this.transientProviders);
        for (StringTableProvider stringTableProvider : list) {
            stringTableProvider.closeComponent();
            stringTableProvider.dispose();
        }
        super.dispose();
    }

    @Override
    protected void programClosed(Program program) {
        if (this.transientProviders.isEmpty()) {
            return;
        }
        ArrayList<StringTableProvider> list = new ArrayList<StringTableProvider>(this.transientProviders);
        for (StringTableProvider stringTableProvider : list) {
            stringTableProvider.programClosed(program);
        }
    }

    public void createStringsProvider(StringTableOptions options) {
        StringTableProvider transientProvider = new StringTableProvider(this, options, true);
        this.transientProviders.add(transientProvider);
        transientProvider.setProgram(this.currentProgram);
        transientProvider.setVisible(true);
    }

    public void removeTransientProvider(StringTableProvider stringTableProvider) {
        this.transientProviders.remove((Object)stringTableProvider);
    }
}

