/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.main.projectdata.actions;

import docking.widgets.OptionDialog;
import ghidra.framework.client.ClientUtil;
import ghidra.framework.client.NotConnectedException;
import ghidra.framework.client.RepositoryAdapter;
import ghidra.framework.main.datatable.DomainFileContext;
import ghidra.framework.main.datatable.DomainFileProviderContextAction;
import ghidra.framework.model.DomainFile;
import ghidra.framework.model.Project;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.store.FileSystemSynchronizer;
import ghidra.util.HelpLocation;
import java.awt.Component;
import java.io.IOException;
import java.util.List;

public abstract class VersionControlAction
extends DomainFileProviderContextAction {
    protected static final String GROUP = "Repository";
    protected PluginTool tool;
    protected RepositoryAdapter repository;

    public VersionControlAction(String name, String owner, PluginTool tool) {
        super(name, owner);
        this.tool = tool;
        this.setHelpLocation(new HelpLocation("VersionControl", name));
        this.checkRepository();
    }

    @Override
    public boolean isAddToPopup(DomainFileContext context) {
        if (!context.isInActiveProject()) {
            return false;
        }
        this.checkRepository();
        List<DomainFile> domainFiles = context.getSelectedFiles();
        for (DomainFile domainFile : domainFiles) {
            if (domainFile.getVersion() <= 0) continue;
            return true;
        }
        return false;
    }

    private void checkRepository() {
        Project project = this.tool.getProject();
        if (project != null) {
            this.repository = project.getRepository();
        } else if (this.repository != null) {
            this.repository = null;
        }
    }

    protected boolean isFileSystemBusy() {
        return FileSystemSynchronizer.isSynchronizing();
    }

    protected boolean checkRepositoryConnected() {
        this.checkRepository();
        if (this.repository == null) {
            return true;
        }
        if (this.repository.verifyConnection()) {
            return true;
        }
        if (OptionDialog.showYesNoDialog((Component)this.tool.getToolFrame(), (String)"Lost Connection to Server", (String)"The connection to the Ghidra Server has been lost.\nDo you want to reconnect now?") == 1) {
            try {
                this.repository.connect();
                return true;
            }
            catch (NotConnectedException e) {
                return false;
            }
            catch (IOException e) {
                ClientUtil.handleException((RepositoryAdapter)this.repository, (Exception)e, (String)"Repository Connection", (Component)this.tool.getToolFrame());
                return false;
            }
        }
        return false;
    }

    boolean canCloseDomainFile(DomainFile df) {
        PluginTool[] tools;
        Project project = this.tool.getProject();
        for (PluginTool t : tools = project.getToolManager().getRunningTools()) {
            DomainFile[] files;
            for (DomainFile domainFile : files = t.getDomainFiles()) {
                if (df != domainFile) continue;
                return t.canCloseDomainFile(df);
            }
        }
        return true;
    }
}

