/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.emulation;

import ghidra.pcode.emulate.Emulate;
import ghidra.pcode.emulate.EmulateInstructionStateModifier;
import ghidra.pcode.emulate.callother.OpBehaviorOther;
import ghidra.pcode.error.LowlevelError;
import ghidra.pcode.memstate.MemoryState;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.lang.Register;
import ghidra.program.model.pcode.Varnode;
import java.math.BigInteger;

public class TRICOREEmulateInstructionStateModifier
extends EmulateInstructionStateModifier {
    Register FCX;
    Register PCXI;
    Register LCX;
    Register PSW;
    Register a10;
    Register a11;
    Register d8;
    Register a12;
    Register d12;

    public TRICOREEmulateInstructionStateModifier(Emulate emu) {
        super(emu);
        this.registerPcodeOpBehavior("saveCallerState", new tricore_SaveCallerState());
        this.registerPcodeOpBehavior("restoreCallerState", new tricore_RestoreCallerState());
        this.cacheRegisters(emu);
    }

    private int copyRegisterToArray(Register reg, int len, MemoryState memoryState, byte[] outBytes, int i) {
        byte[] vBytes = new byte[len];
        int nread = memoryState.getChunk(vBytes, reg.getAddressSpace(), (long)reg.getOffset(), len, false);
        System.arraycopy(vBytes, 0, outBytes, i, len);
        return nread;
    }

    private int copyArrayToRegister(Register reg, int len, MemoryState memoryState, byte[] inBytes, int i) {
        byte[] vBytes = new byte[len];
        AddressSpace spc = reg.getAddressSpace();
        System.arraycopy(inBytes, i, vBytes, 0, vBytes.length);
        memoryState.setChunk(vBytes, spc, (long)reg.getOffset(), vBytes.length);
        return len;
    }

    private void cacheRegisters(Emulate emu) {
        this.FCX = emu.getLanguage().getRegister("FCX");
        this.LCX = emu.getLanguage().getRegister("LCX");
        this.PCXI = emu.getLanguage().getRegister("PCXI");
        this.PSW = emu.getLanguage().getRegister("PSW");
        this.a10 = emu.getLanguage().getRegister("a10");
        this.d8 = emu.getLanguage().getRegister("d8");
        this.a12 = emu.getLanguage().getRegister("a12");
        this.d12 = emu.getLanguage().getRegister("d12");
    }

    private class tricore_SaveCallerState
    implements OpBehaviorOther {
        private tricore_SaveCallerState() {
        }

        public void evaluate(Emulate emu, Varnode outputVarnode, Varnode[] inputs) {
            int numArgs = inputs.length;
            if (numArgs != 3) {
                throw new LowlevelError(this.getClass().getName() + ": requires 3 inputs (FCX, LCX, PCXI), got " + numArgs);
            }
            MemoryState memoryState = emu.getMemoryState();
            BigInteger FCXvalue = memoryState.getBigInteger(TRICOREEmulateInstructionStateModifier.this.FCX);
            long ea = FCXvalue.longValue();
            ea = (ea & 0xFFFFFFFFFFFF0000L) << 12 | (ea & 0xFFFFL) << 6;
            Address EA_addr = emu.getExecuteAddress().getNewAddress(ea);
            AddressSpace addressSpace = emu.getExecuteAddress().getAddressSpace();
            BigInteger new_FCXvalue = memoryState.getBigInteger(addressSpace, ea, 4, false);
            if (new_FCXvalue.equals(BigInteger.ZERO)) {
                new_FCXvalue = FCXvalue.add(BigInteger.ONE);
            }
            byte[] outBytes = new byte[64];
            int index = 0;
            index += TRICOREEmulateInstructionStateModifier.this.copyRegisterToArray(TRICOREEmulateInstructionStateModifier.this.PCXI, TRICOREEmulateInstructionStateModifier.this.PCXI.getBitLength() / 8, memoryState, outBytes, index);
            index += TRICOREEmulateInstructionStateModifier.this.copyRegisterToArray(TRICOREEmulateInstructionStateModifier.this.PSW, TRICOREEmulateInstructionStateModifier.this.PSW.getBitLength() / 8, memoryState, outBytes, index);
            index += TRICOREEmulateInstructionStateModifier.this.copyRegisterToArray(TRICOREEmulateInstructionStateModifier.this.a10, 2 * TRICOREEmulateInstructionStateModifier.this.a10.getBitLength() / 8, memoryState, outBytes, index);
            index += TRICOREEmulateInstructionStateModifier.this.copyRegisterToArray(TRICOREEmulateInstructionStateModifier.this.d8, 4 * TRICOREEmulateInstructionStateModifier.this.d8.getBitLength() / 8, memoryState, outBytes, index);
            index += TRICOREEmulateInstructionStateModifier.this.copyRegisterToArray(TRICOREEmulateInstructionStateModifier.this.a12, 4 * TRICOREEmulateInstructionStateModifier.this.a12.getBitLength() / 8, memoryState, outBytes, index);
            index += TRICOREEmulateInstructionStateModifier.this.copyRegisterToArray(TRICOREEmulateInstructionStateModifier.this.d12, 4 * TRICOREEmulateInstructionStateModifier.this.d12.getBitLength() / 8, memoryState, outBytes, index);
            memoryState.setChunk(outBytes, EA_addr.getAddressSpace(), EA_addr.getOffset(), 64);
            BigInteger PCXIvalue = memoryState.getBigInteger(TRICOREEmulateInstructionStateModifier.this.PCXI);
            PCXIvalue = PCXIvalue.andNot(BigInteger.valueOf(1048575L)).or(FCXvalue.and(BigInteger.valueOf(1048575L)));
            memoryState.setValue(TRICOREEmulateInstructionStateModifier.this.PCXI, PCXIvalue);
            FCXvalue = FCXvalue.andNot(BigInteger.valueOf(1048575L)).or(new_FCXvalue.and(BigInteger.valueOf(1048575L)));
            memoryState.setValue(TRICOREEmulateInstructionStateModifier.this.FCX, FCXvalue);
            BigInteger LCXvalue = memoryState.getBigInteger(TRICOREEmulateInstructionStateModifier.this.LCX);
        }
    }

    private class tricore_RestoreCallerState
    implements OpBehaviorOther {
        private tricore_RestoreCallerState() {
        }

        public void evaluate(Emulate emu, Varnode outputVarnode, Varnode[] inputs) {
            int numArgs = inputs.length;
            if (numArgs != 3) {
                throw new LowlevelError(this.getClass().getName() + ": requires 3 inputs (FCX, LCX, PCXI), got " + numArgs);
            }
            MemoryState memoryState = emu.getMemoryState();
            BigInteger FCXvalue = memoryState.getBigInteger(TRICOREEmulateInstructionStateModifier.this.FCX);
            BigInteger PCXIvalue = memoryState.getBigInteger(TRICOREEmulateInstructionStateModifier.this.PCXI);
            long ea = PCXIvalue.longValue();
            ea = (ea & 0xFFFFFFFFFFFF0000L) << 12 | (ea & 0xFFFFL) << 6;
            Address EA_addr = emu.getExecuteAddress().getNewAddress(ea);
            AddressSpace addressSpace = emu.getExecuteAddress().getAddressSpace();
            byte[] inBytes = new byte[64];
            memoryState.getChunk(inBytes, addressSpace, EA_addr.getOffset(), 64, true);
            int index = 0;
            index += TRICOREEmulateInstructionStateModifier.this.copyArrayToRegister(TRICOREEmulateInstructionStateModifier.this.PCXI, TRICOREEmulateInstructionStateModifier.this.PCXI.getBitLength() / 8, memoryState, inBytes, index);
            index += TRICOREEmulateInstructionStateModifier.this.copyArrayToRegister(TRICOREEmulateInstructionStateModifier.this.PSW, TRICOREEmulateInstructionStateModifier.this.PSW.getBitLength() / 8, memoryState, inBytes, index);
            index += TRICOREEmulateInstructionStateModifier.this.copyArrayToRegister(TRICOREEmulateInstructionStateModifier.this.a10, 2 * TRICOREEmulateInstructionStateModifier.this.a10.getBitLength() / 8, memoryState, inBytes, index);
            index += TRICOREEmulateInstructionStateModifier.this.copyArrayToRegister(TRICOREEmulateInstructionStateModifier.this.d8, 4 * TRICOREEmulateInstructionStateModifier.this.d8.getBitLength() / 8, memoryState, inBytes, index);
            index += TRICOREEmulateInstructionStateModifier.this.copyArrayToRegister(TRICOREEmulateInstructionStateModifier.this.a12, 4 * TRICOREEmulateInstructionStateModifier.this.a12.getBitLength() / 8, memoryState, inBytes, index);
            index += TRICOREEmulateInstructionStateModifier.this.copyArrayToRegister(TRICOREEmulateInstructionStateModifier.this.d12, 4 * TRICOREEmulateInstructionStateModifier.this.d12.getBitLength() / 8, memoryState, inBytes, index);
            memoryState.setValue(EA_addr.getAddressSpace(), EA_addr.getOffset(), 4, FCXvalue);
            FCXvalue = FCXvalue.andNot(BigInteger.valueOf(1048575L)).or(PCXIvalue.and(BigInteger.valueOf(1048575L)));
            memoryState.setValue(TRICOREEmulateInstructionStateModifier.this.FCX, FCXvalue);
        }
    }
}

