/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.references;

import ghidra.program.database.references.MemReferenceDB;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.OffsetReference;
import ghidra.program.model.symbol.RefType;
import ghidra.program.model.symbol.SourceType;
import ghidra.util.NumericUtilities;

class OffsetReferenceDB
extends MemReferenceDB
implements OffsetReference {
    public OffsetReferenceDB(Program program, Address from, Address to, RefType refType, byte opIndex, SourceType sourceType, boolean isPrimary, long symbolID, long offset) {
        super(program, from, to, refType, opIndex, sourceType, isPrimary, symbolID, true, false, offset);
    }

    @Override
    public long getOffset() {
        return this.offsetOrShift;
    }

    @Override
    public Address getBaseAddress() {
        if (this.isExternalBlockReference()) {
            return this.toAddr;
        }
        return this.toAddr.subtractWrap(this.offsetOrShift);
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof OffsetReference)) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        OffsetReference ref = (OffsetReference)obj;
        return this.offsetOrShift == ref.getOffset();
    }

    @Override
    public String toString() {
        String offsetStr = NumericUtilities.toSignedHexString((long)this.offsetOrShift);
        return super.toString() + " Offset: " + offsetStr;
    }
}

