/*
 * Copyright 2010-2022 JetBrains s.r.o. and Kotlin Programming Language contributors.
 * Use of this source code is governed by the Apache 2.0 license that can be found in the license/LICENSE.txt file.
 */

package kotlin.reflect.jvm.internal.impl.types.error

import kotlin.reflect.jvm.internal.impl.descriptors.*
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.Annotations
import kotlin.reflect.jvm.internal.impl.descriptors.impl.PropertyDescriptorImpl
import kotlin.reflect.jvm.internal.impl.name.Name

class ErrorPropertyDescriptor : PropertyDescriptor by (
        PropertyDescriptorImpl.create(
            ErrorUtils.errorClass, Annotations.EMPTY, Modality.OPEN,
            DescriptorVisibilities.PUBLIC, true, Name.special(ErrorEntity.ERROR_PROPERTY.debugText),
            CallableMemberDescriptor.Kind.DECLARATION, SourceElement.NO_SOURCE,
            false, false, false, false, false, false
        ).apply {
            setType(ErrorUtils.errorPropertyType, emptyList(), null, null, emptyList())
        }
    )
