/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.intentions.style;

import com.intellij.codeInsight.generation.OverrideImplementExploreUtil;
import com.intellij.modcommand.ActionContext;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.infos.CandidateInfo;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.config.GroovyConfigUtils;
import org.jetbrains.plugins.groovy.intentions.base.GrPsiUpdateIntention;
import org.jetbrains.plugins.groovy.intentions.base.PsiElementPredicate;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrOpenBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrNewExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrAnonymousClassDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinitionBody;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrCodeReferenceElement;

public final class ReplaceAbstractClassInstanceByMapIntention
extends GrPsiUpdateIntention {
    @Override
    @NotNull
    protected PsiElementPredicate getElementPredicate() {
        return new MyPredicate();
    }

    @Override
    protected void processIntention(@NotNull PsiElement psiElement, @NotNull ActionContext context, @NotNull ModPsiUpdater updater) {
        if (psiElement == null) {
            ReplaceAbstractClassInstanceByMapIntention.$$$reportNull$$$0(0);
        }
        if (context == null) {
            ReplaceAbstractClassInstanceByMapIntention.$$$reportNull$$$0(1);
        }
        if (updater == null) {
            ReplaceAbstractClassInstanceByMapIntention.$$$reportNull$$$0(2);
        }
        GrCodeReferenceElement ref2 = (GrCodeReferenceElement)psiElement;
        GrAnonymousClassDefinition anonymous = (GrAnonymousClassDefinition)ref2.getParent();
        GrNewExpression newExpr = (GrNewExpression)anonymous.getParent();
        PsiElement resolved = ref2.resolve();
        assert (resolved instanceof PsiClass);
        GrTypeDefinitionBody body = anonymous.getBody();
        assert (body != null);
        ArrayList<Pair> methods = new ArrayList<Pair>();
        for (GrMethod method : body.getMethods()) {
            methods.add(new Pair((Object)method, (Object)method.getBlock()));
        }
        PsiClass iface = (PsiClass)resolved;
        Collection collection = OverrideImplementExploreUtil.getMethodsToOverrideImplement((PsiClass)anonymous, (boolean)true);
        for (CandidateInfo info : collection) {
            methods.add(new Pair((Object)((PsiMethod)info.getElement()), null));
        }
        StringBuilder buffer = new StringBuilder();
        if (methods.size() == 1) {
            Pair pair = (Pair)methods.get(0);
            ReplaceAbstractClassInstanceByMapIntention.appendClosureTextByMethod((PsiMethod)pair.getFirst(), buffer, (GrOpenBlock)pair.getSecond(), newExpr);
            if (!GroovyConfigUtils.getInstance().isVersionAtLeast(psiElement, "2.2")) {
                buffer.append(" as ").append(iface.getQualifiedName());
            }
        } else {
            buffer.append("[");
            buffer.append("\n");
            for (Pair pair : methods) {
                PsiMethod method = (PsiMethod)pair.getFirst();
                GrOpenBlock block = (GrOpenBlock)pair.getSecond();
                buffer.append(method.getName()).append(": ");
                ReplaceAbstractClassInstanceByMapIntention.appendClosureTextByMethod(method, buffer, block, newExpr);
                buffer.append(",\n");
            }
            if (!methods.isEmpty()) {
                buffer.delete(buffer.length() - 2, buffer.length());
                buffer.append('\n');
            }
            buffer.append("]");
            buffer.append(" as ").append(iface.getQualifiedName());
        }
        ReplaceAbstractClassInstanceByMapIntention.createAndAdjustNewExpression(context.project(), newExpr, buffer);
    }

    private static void createAndAdjustNewExpression(Project project, GrNewExpression newExpression, StringBuilder buffer) throws IncorrectOperationException {
        GrExpression expr = GroovyPsiElementFactory.getInstance(project).createExpressionFromText(buffer.toString());
        GrExpression safeTypeExpr = newExpression.replaceWithExpression(expr, false);
        JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences((PsiElement)safeTypeExpr);
    }

    private static void appendClosureTextByMethod(PsiMethod method, StringBuilder buffer, @Nullable GrOpenBlock block, GroovyPsiElement context) {
        PsiParameterList list = method.getParameterList();
        buffer.append("{ ");
        PsiParameter[] parameters = list.getParameters();
        HashSet<String> generatedNames = new HashSet<String>();
        if (parameters.length > 0) {
            PsiParameter first = parameters[0];
            PsiType type = first.getType();
            buffer.append(type.getCanonicalText()).append(" ");
            buffer.append(ReplaceAbstractClassInstanceByMapIntention.createName(generatedNames, first, type, context));
        }
        for (int i2 = 1; i2 < parameters.length; ++i2) {
            buffer.append(", ");
            PsiParameter param = parameters[i2];
            PsiType type = param.getType();
            buffer.append(type.getCanonicalText()).append(" ");
            String name = ReplaceAbstractClassInstanceByMapIntention.createName(generatedNames, param, type, context);
            buffer.append(name);
        }
        if (parameters.length > 0) {
            buffer.append(" ->");
        }
        if (block != null) {
            PsiElement child;
            PsiElement lBrace = block.getLBrace();
            PsiElement rBrace = block.getRBrace();
            PsiElement psiElement = child = lBrace != null ? lBrace.getNextSibling() : block.getFirstChild();
            while (child != null && child != rBrace) {
                buffer.append(child.getText());
                child = child.getNextSibling();
            }
        }
        buffer.append(" }");
    }

    private static String createName(Set<String> generatedNames, PsiParameter param, PsiType type, GroovyPsiElement context) {
        String name = param.getName();
        generatedNames.add(name);
        return name;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "psiElement";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "context";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "updater";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/plugins/groovy/intentions/style/ReplaceAbstractClassInstanceByMapIntention";
        objectArray[2] = "processIntention";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    static class MyPredicate
    implements PsiElementPredicate {
        MyPredicate() {
        }

        @Override
        public boolean satisfiedBy(@NotNull PsiElement element) {
            GrAnonymousClassDefinition anonymous;
            PsiElement psiElement;
            if (element == null) {
                MyPredicate.$$$reportNull$$$0(0);
            }
            return element instanceof GrCodeReferenceElement && (psiElement = element.getParent()) instanceof GrAnonymousClassDefinition && (anonymous = (GrAnonymousClassDefinition)psiElement).getFields().length == 0;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/groovy/intentions/style/ReplaceAbstractClassInstanceByMapIntention$MyPredicate", "satisfiedBy"));
        }
    }
}

