\name{FFTConvolutionImageFilter}
\alias{FFTConvolutionImageFilter}
\title{FFTConvolutionImageFilter}
\Rdversion{1.1}
\docType{class}
\description{
Convolve a given image with an arbitrary image kernel using
multiplication in the Fourier domain.
FFTConvolutionImageFilter}
\details{
This filter produces output equivalent to the output of the ConvolutionImageFilter . However, it takes advantage of the convolution theorem to
accelerate the convolution computation when the kernel is large.
WARNING:
This filter ignores the spacing, origin, and orientation of the kernel
image and treats them as identical to those in the input image.
 This code was adapted from the Insight Journal contribution:
"FFT Based Convolution" by Gaetan Lehmann https://www.insight-journal.org/browse/publication/717
See:
ConvolutionImageFilter
InverseDeconvolutionImageFilter
IterativeDeconvolutionImageFilter
FFTConvolution for the procedural interface
itk::FFTConvolutionImageFilter for the Doxygen on the original ITK class.
FFTConvolutionImageFilter}
%C++ includes: sitkFFTConvolutionImageFilter.h
\section{Methods}{
\describe{
\item{Image Execute(const Image &image, const Image &kernelImage):}{
Execute the filter on the input image
}
\item{ FFTConvolutionImageFilter():}{
Default Constructor that takes no arguments and initializes default
parameters
}
\item{BoundaryConditionType GetBoundaryCondition() const:}{}
\item{std::string GetName() const:}{
Name of this class
}
\item{bool GetNormalize() const:}{}
\item{OutputRegionModeType GetOutputRegionMode() const:}{}
\item{Self NormalizeOff():}{}
\item{Self NormalizeOn():}{
Set the value of Normalize to true or false respectfully.
}
\item{Self SetBoundaryCondition(BoundaryConditionType BoundaryCondition):}{}
\item{Self SetNormalize(bool Normalize):}{
Normalize the output image by the sum of the kernel components
}
\item{Self SetOutputRegionMode(OutputRegionModeType OutputRegionMode):}{}
\item{std::string ToString() const:}{
Print ourselves out
}
\item{ ~FFTConvolutionImageFilter():}{
Destructor
}
}
}
