/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSTimelineRangeOffset.h"

#include "JSCSSNumericValue.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMGlobalObject.h"
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/ObjectConstructor.h>



namespace WebCore {
using namespace JSC;

template<> ConversionResult<IDLDictionary<TimelineRangeOffset>> convertDictionary<TimelineRangeOffset>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (!isNullOrUndefined && !object) [[unlikely]] {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return ConversionResultException { };
    }
    TimelineRangeOffset result;
    JSValue offsetValue;
    if (isNullOrUndefined)
        offsetValue = jsUndefined();
    else {
        offsetValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "offset"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!offsetValue.isUndefined()) {
        auto offsetConversionResult = convert<IDLInterface<CSSNumericValue>>(lexicalGlobalObject, offsetValue);
        if (offsetConversionResult.hasException(throwScope)) [[unlikely]]
            return ConversionResultException { };
        result.offset = offsetConversionResult.releaseReturnValue();
    }
    JSValue rangeNameValue;
    if (isNullOrUndefined)
        rangeNameValue = jsUndefined();
    else {
        rangeNameValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "rangeName"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!rangeNameValue.isUndefined()) {
        auto rangeNameConversionResult = convert<IDLDOMString>(lexicalGlobalObject, rangeNameValue);
        if (rangeNameConversionResult.hasException(throwScope)) [[unlikely]]
            return ConversionResultException { };
        result.rangeName = rangeNameConversionResult.releaseReturnValue();
    }
    return result;
}

JSC::JSObject* convertDictionaryToJS(JSC::JSGlobalObject& lexicalGlobalObject, JSDOMGlobalObject& globalObject, const TimelineRangeOffset& dictionary)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);

    auto result = constructEmptyObject(&lexicalGlobalObject, globalObject.objectPrototype());

    if (!IDLInterface<CSSNumericValue>::isNullValue(dictionary.offset)) {
        auto offsetValue = toJS<IDLInterface<CSSNumericValue>>(lexicalGlobalObject, globalObject, throwScope, IDLInterface<CSSNumericValue>::extractValueFromNullable(dictionary.offset));
        RETURN_IF_EXCEPTION(throwScope, { });
        result->putDirect(vm, JSC::Identifier::fromString(vm, "offset"_s), offsetValue);
    }
    if (!IDLDOMString::isNullValue(dictionary.rangeName)) {
        auto rangeNameValue = toJS<IDLDOMString>(lexicalGlobalObject, throwScope, IDLDOMString::extractValueFromNullable(dictionary.rangeName));
        RETURN_IF_EXCEPTION(throwScope, { });
        result->putDirect(vm, JSC::Identifier::fromString(vm, "rangeName"_s), rangeNameValue);
    }
    return result;
}

} // namespace WebCore

