/** @file
 * VirtualBox API class wrapper code for IHostAudioDevice.
 *
 * DO NOT EDIT! This is a generated file.
 * Generated from: src/VBox/Main/idl/VirtualBox.xidl
 * Generator: src/VBox/Main/idl/apiwrap-server.xsl
 */

/*
 * Copyright (C) 2010-2026 Oracle and/or its affiliates.
 *
 * This file is part of VirtualBox base platform packages, as
 * available from https://www.virtualbox.org.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation, in version 3 of the
 * License.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <https://www.gnu.org/licenses>.
 *
 * SPDX-License-Identifier: GPL-3.0-only
 */

#define LOG_GROUP LOG_GROUP_MAIN_HOSTAUDIODEVICE

#include "HostAudioDeviceWrap.h"
#include "LoggingNew.h"
#ifdef VBOX_WITH_DTRACE_R3_MAIN
# include "dtrace/VBoxAPI.h"
#endif

DEFINE_EMPTY_CTOR_DTOR(HostAudioDeviceWrap)

//
// IHostAudioDevice properties
//

STDMETHODIMP HostAudioDeviceWrap::COMGETTER(Id)(BSTR *aId)
{
    LogRelFlow(("{%p} %s: enter aId=%p\n", this, "HostAudioDevice::getId", aId));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aId);
        UuidOutConverter TmpId(aId);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTAUDIODEVICE_GET_ID_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getId(TmpId.uuid());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTAUDIODEVICE_GET_ID_RETURN(this, hrc, 0 /*normal*/,TmpId.uuid().toStringCurly().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTAUDIODEVICE_GET_ID_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTAUDIODEVICE_GET_ID_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aId=%ls hrc=%Rhrc\n", this, "HostAudioDevice::getId", *aId, hrc));
    return hrc;
}

STDMETHODIMP HostAudioDeviceWrap::COMGETTER(Name)(BSTR *aName)
{
    LogRelFlow(("{%p} %s: enter aName=%p\n", this, "HostAudioDevice::getName", aName));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aName);
        BSTROutConverter TmpName(aName);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTAUDIODEVICE_GET_NAME_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getName(TmpName.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTAUDIODEVICE_GET_NAME_RETURN(this, hrc, 0 /*normal*/,TmpName.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTAUDIODEVICE_GET_NAME_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTAUDIODEVICE_GET_NAME_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aName=%ls hrc=%Rhrc\n", this, "HostAudioDevice::getName", *aName, hrc));
    return hrc;
}

STDMETHODIMP HostAudioDeviceWrap::COMSETTER(Name)(IN_BSTR aName)
{
    LogRelFlow(("{%p} %s: enter aName=%ls\n", this, "HostAudioDevice::setName", aName));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        BSTRInConverter TmpName(aName);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTAUDIODEVICE_SET_NAME_ENTER(this, TmpName.str().c_str());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = setName(TmpName.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTAUDIODEVICE_SET_NAME_RETURN(this, hrc, 0 /*normal*/,TmpName.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTAUDIODEVICE_SET_NAME_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTAUDIODEVICE_SET_NAME_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "HostAudioDevice::setName", hrc));
    return hrc;
}

STDMETHODIMP HostAudioDeviceWrap::COMGETTER(Type)(AudioDeviceType_T *aType)
{
    LogRelFlow(("{%p} %s: enter aType=%p\n", this, "HostAudioDevice::getType", aType));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aType);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTAUDIODEVICE_GET_TYPE_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getType(aType);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTAUDIODEVICE_GET_TYPE_RETURN(this, hrc, 0 /*normal*/,*aType);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTAUDIODEVICE_GET_TYPE_RETURN(this, hrc, 1 /*hrc exception*/,*aType);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTAUDIODEVICE_GET_TYPE_RETURN(this, hrc, 9 /*unhandled exception*/,*aType);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aType=%RU32 hrc=%Rhrc\n", this, "HostAudioDevice::getType", *aType, hrc));
    return hrc;
}

STDMETHODIMP HostAudioDeviceWrap::COMSETTER(Type)(AudioDeviceType_T aType)
{
    LogRelFlow(("{%p} %s: enter aType=%RU32\n", this, "HostAudioDevice::setType", aType));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTAUDIODEVICE_SET_TYPE_ENTER(this, aType);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = setType(aType);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTAUDIODEVICE_SET_TYPE_RETURN(this, hrc, 0 /*normal*/,aType);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTAUDIODEVICE_SET_TYPE_RETURN(this, hrc, 1 /*hrc exception*/,aType);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTAUDIODEVICE_SET_TYPE_RETURN(this, hrc, 9 /*unhandled exception*/,aType);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "HostAudioDevice::setType", hrc));
    return hrc;
}

STDMETHODIMP HostAudioDeviceWrap::COMGETTER(Usage)(AudioDirection_T *aUsage)
{
    LogRelFlow(("{%p} %s: enter aUsage=%p\n", this, "HostAudioDevice::getUsage", aUsage));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aUsage);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTAUDIODEVICE_GET_USAGE_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getUsage(aUsage);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTAUDIODEVICE_GET_USAGE_RETURN(this, hrc, 0 /*normal*/,*aUsage);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTAUDIODEVICE_GET_USAGE_RETURN(this, hrc, 1 /*hrc exception*/,*aUsage);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTAUDIODEVICE_GET_USAGE_RETURN(this, hrc, 9 /*unhandled exception*/,*aUsage);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aUsage=%RU32 hrc=%Rhrc\n", this, "HostAudioDevice::getUsage", *aUsage, hrc));
    return hrc;
}

STDMETHODIMP HostAudioDeviceWrap::COMSETTER(Usage)(AudioDirection_T aUsage)
{
    LogRelFlow(("{%p} %s: enter aUsage=%RU32\n", this, "HostAudioDevice::setUsage", aUsage));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTAUDIODEVICE_SET_USAGE_ENTER(this, aUsage);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = setUsage(aUsage);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTAUDIODEVICE_SET_USAGE_RETURN(this, hrc, 0 /*normal*/,aUsage);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTAUDIODEVICE_SET_USAGE_RETURN(this, hrc, 1 /*hrc exception*/,aUsage);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTAUDIODEVICE_SET_USAGE_RETURN(this, hrc, 9 /*unhandled exception*/,aUsage);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "HostAudioDevice::setUsage", hrc));
    return hrc;
}

STDMETHODIMP HostAudioDeviceWrap::COMGETTER(DefaultIn)(BOOL *aDefaultIn)
{
    LogRelFlow(("{%p} %s: enter aDefaultIn=%p\n", this, "HostAudioDevice::getDefaultIn", aDefaultIn));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aDefaultIn);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTAUDIODEVICE_GET_DEFAULTIN_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getDefaultIn(aDefaultIn);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTAUDIODEVICE_GET_DEFAULTIN_RETURN(this, hrc, 0 /*normal*/,*aDefaultIn != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTAUDIODEVICE_GET_DEFAULTIN_RETURN(this, hrc, 1 /*hrc exception*/,*aDefaultIn != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTAUDIODEVICE_GET_DEFAULTIN_RETURN(this, hrc, 9 /*unhandled exception*/,*aDefaultIn != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aDefaultIn=%RTbool hrc=%Rhrc\n", this, "HostAudioDevice::getDefaultIn", *aDefaultIn, hrc));
    return hrc;
}

STDMETHODIMP HostAudioDeviceWrap::COMSETTER(DefaultIn)(BOOL aDefaultIn)
{
    LogRelFlow(("{%p} %s: enter aDefaultIn=%RTbool\n", this, "HostAudioDevice::setDefaultIn", aDefaultIn));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTAUDIODEVICE_SET_DEFAULTIN_ENTER(this, aDefaultIn != FALSE);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = setDefaultIn(aDefaultIn != FALSE);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTAUDIODEVICE_SET_DEFAULTIN_RETURN(this, hrc, 0 /*normal*/,aDefaultIn != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTAUDIODEVICE_SET_DEFAULTIN_RETURN(this, hrc, 1 /*hrc exception*/,aDefaultIn != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTAUDIODEVICE_SET_DEFAULTIN_RETURN(this, hrc, 9 /*unhandled exception*/,aDefaultIn != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "HostAudioDevice::setDefaultIn", hrc));
    return hrc;
}

STDMETHODIMP HostAudioDeviceWrap::COMGETTER(DefaultOut)(BOOL *aDefaultOut)
{
    LogRelFlow(("{%p} %s: enter aDefaultOut=%p\n", this, "HostAudioDevice::getDefaultOut", aDefaultOut));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aDefaultOut);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTAUDIODEVICE_GET_DEFAULTOUT_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getDefaultOut(aDefaultOut);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTAUDIODEVICE_GET_DEFAULTOUT_RETURN(this, hrc, 0 /*normal*/,*aDefaultOut != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTAUDIODEVICE_GET_DEFAULTOUT_RETURN(this, hrc, 1 /*hrc exception*/,*aDefaultOut != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTAUDIODEVICE_GET_DEFAULTOUT_RETURN(this, hrc, 9 /*unhandled exception*/,*aDefaultOut != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aDefaultOut=%RTbool hrc=%Rhrc\n", this, "HostAudioDevice::getDefaultOut", *aDefaultOut, hrc));
    return hrc;
}

STDMETHODIMP HostAudioDeviceWrap::COMSETTER(DefaultOut)(BOOL aDefaultOut)
{
    LogRelFlow(("{%p} %s: enter aDefaultOut=%RTbool\n", this, "HostAudioDevice::setDefaultOut", aDefaultOut));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTAUDIODEVICE_SET_DEFAULTOUT_ENTER(this, aDefaultOut != FALSE);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = setDefaultOut(aDefaultOut != FALSE);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTAUDIODEVICE_SET_DEFAULTOUT_RETURN(this, hrc, 0 /*normal*/,aDefaultOut != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTAUDIODEVICE_SET_DEFAULTOUT_RETURN(this, hrc, 1 /*hrc exception*/,aDefaultOut != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTAUDIODEVICE_SET_DEFAULTOUT_RETURN(this, hrc, 9 /*unhandled exception*/,aDefaultOut != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "HostAudioDevice::setDefaultOut", hrc));
    return hrc;
}

STDMETHODIMP HostAudioDeviceWrap::COMGETTER(IsHotPlug)(BOOL *aIsHotPlug)
{
    LogRelFlow(("{%p} %s: enter aIsHotPlug=%p\n", this, "HostAudioDevice::getIsHotPlug", aIsHotPlug));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aIsHotPlug);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTAUDIODEVICE_GET_ISHOTPLUG_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getIsHotPlug(aIsHotPlug);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTAUDIODEVICE_GET_ISHOTPLUG_RETURN(this, hrc, 0 /*normal*/,*aIsHotPlug != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTAUDIODEVICE_GET_ISHOTPLUG_RETURN(this, hrc, 1 /*hrc exception*/,*aIsHotPlug != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTAUDIODEVICE_GET_ISHOTPLUG_RETURN(this, hrc, 9 /*unhandled exception*/,*aIsHotPlug != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aIsHotPlug=%RTbool hrc=%Rhrc\n", this, "HostAudioDevice::getIsHotPlug", *aIsHotPlug, hrc));
    return hrc;
}

STDMETHODIMP HostAudioDeviceWrap::COMSETTER(IsHotPlug)(BOOL aIsHotPlug)
{
    LogRelFlow(("{%p} %s: enter aIsHotPlug=%RTbool\n", this, "HostAudioDevice::setIsHotPlug", aIsHotPlug));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTAUDIODEVICE_SET_ISHOTPLUG_ENTER(this, aIsHotPlug != FALSE);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = setIsHotPlug(aIsHotPlug != FALSE);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTAUDIODEVICE_SET_ISHOTPLUG_RETURN(this, hrc, 0 /*normal*/,aIsHotPlug != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTAUDIODEVICE_SET_ISHOTPLUG_RETURN(this, hrc, 1 /*hrc exception*/,aIsHotPlug != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTAUDIODEVICE_SET_ISHOTPLUG_RETURN(this, hrc, 9 /*unhandled exception*/,aIsHotPlug != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "HostAudioDevice::setIsHotPlug", hrc));
    return hrc;
}

STDMETHODIMP HostAudioDeviceWrap::COMGETTER(State)(AudioDeviceState_T *aState)
{
    LogRelFlow(("{%p} %s: enter aState=%p\n", this, "HostAudioDevice::getState", aState));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aState);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTAUDIODEVICE_GET_STATE_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getState(aState);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTAUDIODEVICE_GET_STATE_RETURN(this, hrc, 0 /*normal*/,*aState);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTAUDIODEVICE_GET_STATE_RETURN(this, hrc, 1 /*hrc exception*/,*aState);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTAUDIODEVICE_GET_STATE_RETURN(this, hrc, 9 /*unhandled exception*/,*aState);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aState=%RU32 hrc=%Rhrc\n", this, "HostAudioDevice::getState", *aState, hrc));
    return hrc;
}

STDMETHODIMP HostAudioDeviceWrap::COMSETTER(State)(AudioDeviceState_T aState)
{
    LogRelFlow(("{%p} %s: enter aState=%RU32\n", this, "HostAudioDevice::setState", aState));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTAUDIODEVICE_SET_STATE_ENTER(this, aState);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = setState(aState);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTAUDIODEVICE_SET_STATE_RETURN(this, hrc, 0 /*normal*/,aState);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTAUDIODEVICE_SET_STATE_RETURN(this, hrc, 1 /*hrc exception*/,aState);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTAUDIODEVICE_SET_STATE_RETURN(this, hrc, 9 /*unhandled exception*/,aState);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "HostAudioDevice::setState", hrc));
    return hrc;
}

STDMETHODIMP HostAudioDeviceWrap::COMGETTER(InternalAndReservedAttribute1IHostAudioDevice)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP HostAudioDeviceWrap::COMGETTER(InternalAndReservedAttribute2IHostAudioDevice)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP HostAudioDeviceWrap::COMGETTER(InternalAndReservedAttribute3IHostAudioDevice)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP HostAudioDeviceWrap::COMGETTER(InternalAndReservedAttribute4IHostAudioDevice)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP HostAudioDeviceWrap::COMGETTER(InternalAndReservedAttribute5IHostAudioDevice)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP HostAudioDeviceWrap::COMGETTER(InternalAndReservedAttribute6IHostAudioDevice)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP HostAudioDeviceWrap::COMGETTER(InternalAndReservedAttribute7IHostAudioDevice)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP HostAudioDeviceWrap::COMGETTER(InternalAndReservedAttribute8IHostAudioDevice)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}


//
// IHostAudioDevice methods
//

STDMETHODIMP HostAudioDeviceWrap::GetProperty(IN_BSTR aKey,
                                              BSTR *aValue)
{
    LogRelFlow(("{%p} %s: enter aKey=%ls aValue=%p\n", this, "HostAudioDevice::getProperty", aKey, aValue));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aValue);


        BSTRInConverter TmpKey(aKey);
        BSTROutConverter TmpValue(aValue);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTAUDIODEVICE_GETPROPERTY_ENTER(this, TmpKey.str().c_str());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getProperty(TmpKey.str(),
                              TmpValue.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTAUDIODEVICE_GETPROPERTY_RETURN(this, hrc, 0 /*normal*/, TmpKey.str().c_str(), TmpValue.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTAUDIODEVICE_GETPROPERTY_RETURN(this, hrc, 1 /*hrc exception*/, 0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOSTAUDIODEVICE_GETPROPERTY_RETURN(this, hrc, 9 /*unhandled exception*/, 0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave aValue=%ls hrc=%Rhrc\n", this, "HostAudioDevice::getProperty", *aValue, hrc));
    return hrc;
}

STDMETHODIMP HostAudioDeviceWrap::InternalAndReservedMethod1IHostAudioDevice()
{
    return E_NOTIMPL;
}

STDMETHODIMP HostAudioDeviceWrap::InternalAndReservedMethod2IHostAudioDevice()
{
    return E_NOTIMPL;
}

STDMETHODIMP HostAudioDeviceWrap::InternalAndReservedMethod3IHostAudioDevice()
{
    return E_NOTIMPL;
}

STDMETHODIMP HostAudioDeviceWrap::InternalAndReservedMethod4IHostAudioDevice()
{
    return E_NOTIMPL;
}

#ifdef VBOX_WITH_XPCOM
NS_DECL_CLASSINFO(HostAudioDeviceWrap)
NS_IMPL_THREADSAFE_ISUPPORTS1_CI(HostAudioDeviceWrap, IHostAudioDevice)
#endif // VBOX_WITH_XPCOM
