// Code generated by go-swagger; DO NOT EDIT.

package iam_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/hashicorp/hcp-sdk-go/clients/cloud-iam/stable/2019-12-10/models"
	cloud "github.com/hashicorp/hcp-sdk-go/clients/cloud-shared/v1/models"
)

// IamServiceSearchPrincipalsReader is a Reader for the IamServiceSearchPrincipals structure.
type IamServiceSearchPrincipalsReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *IamServiceSearchPrincipalsReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewIamServiceSearchPrincipalsOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewIamServiceSearchPrincipalsDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewIamServiceSearchPrincipalsOK creates a IamServiceSearchPrincipalsOK with default headers values
func NewIamServiceSearchPrincipalsOK() *IamServiceSearchPrincipalsOK {
	return &IamServiceSearchPrincipalsOK{}
}

/*
IamServiceSearchPrincipalsOK describes a response with status code 200, with default header values.

A successful response.
*/
type IamServiceSearchPrincipalsOK struct {
	Payload *models.HashicorpCloudIamSearchPrincipalsResponse
}

// IsSuccess returns true when this iam service search principals o k response has a 2xx status code
func (o *IamServiceSearchPrincipalsOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this iam service search principals o k response has a 3xx status code
func (o *IamServiceSearchPrincipalsOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this iam service search principals o k response has a 4xx status code
func (o *IamServiceSearchPrincipalsOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this iam service search principals o k response has a 5xx status code
func (o *IamServiceSearchPrincipalsOK) IsServerError() bool {
	return false
}

// IsCode returns true when this iam service search principals o k response a status code equal to that given
func (o *IamServiceSearchPrincipalsOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the iam service search principals o k response
func (o *IamServiceSearchPrincipalsOK) Code() int {
	return 200
}

func (o *IamServiceSearchPrincipalsOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /iam/2019-12-10/organizations/{organization_id}/principals/search][%d] iamServiceSearchPrincipalsOK %s", 200, payload)
}

func (o *IamServiceSearchPrincipalsOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /iam/2019-12-10/organizations/{organization_id}/principals/search][%d] iamServiceSearchPrincipalsOK %s", 200, payload)
}

func (o *IamServiceSearchPrincipalsOK) GetPayload() *models.HashicorpCloudIamSearchPrincipalsResponse {
	return o.Payload
}

func (o *IamServiceSearchPrincipalsOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.HashicorpCloudIamSearchPrincipalsResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewIamServiceSearchPrincipalsDefault creates a IamServiceSearchPrincipalsDefault with default headers values
func NewIamServiceSearchPrincipalsDefault(code int) *IamServiceSearchPrincipalsDefault {
	return &IamServiceSearchPrincipalsDefault{
		_statusCode: code,
	}
}

/*
IamServiceSearchPrincipalsDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type IamServiceSearchPrincipalsDefault struct {
	_statusCode int

	Payload *cloud.GoogleRPCStatus
}

// IsSuccess returns true when this iam service search principals default response has a 2xx status code
func (o *IamServiceSearchPrincipalsDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this iam service search principals default response has a 3xx status code
func (o *IamServiceSearchPrincipalsDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this iam service search principals default response has a 4xx status code
func (o *IamServiceSearchPrincipalsDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this iam service search principals default response has a 5xx status code
func (o *IamServiceSearchPrincipalsDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this iam service search principals default response a status code equal to that given
func (o *IamServiceSearchPrincipalsDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the iam service search principals default response
func (o *IamServiceSearchPrincipalsDefault) Code() int {
	return o._statusCode
}

func (o *IamServiceSearchPrincipalsDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /iam/2019-12-10/organizations/{organization_id}/principals/search][%d] IamService_SearchPrincipals default %s", o._statusCode, payload)
}

func (o *IamServiceSearchPrincipalsDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /iam/2019-12-10/organizations/{organization_id}/principals/search][%d] IamService_SearchPrincipals default %s", o._statusCode, payload)
}

func (o *IamServiceSearchPrincipalsDefault) GetPayload() *cloud.GoogleRPCStatus {
	return o.Payload
}

func (o *IamServiceSearchPrincipalsDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(cloud.GoogleRPCStatus)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
IamServiceSearchPrincipalsBody SearchPrincipalsRequest is the request to the SearchPrincipals rpc.
swagger:model IamServiceSearchPrincipalsBody
*/
type IamServiceSearchPrincipalsBody struct {

	// filter contains optional fields to filter the search results down.
	Filter *models.HashicorpCloudIamSearchPrincipalsFilter `json:"filter,omitempty"`

	// pagination contains page data.
	Pagination *cloud.HashicorpCloudCommonPaginationRequest `json:"pagination,omitempty"`
}

// Validate validates this iam service search principals body
func (o *IamServiceSearchPrincipalsBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateFilter(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validatePagination(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *IamServiceSearchPrincipalsBody) validateFilter(formats strfmt.Registry) error {
	if swag.IsZero(o.Filter) { // not required
		return nil
	}

	if o.Filter != nil {
		if err := o.Filter.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("body" + "." + "filter")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("body" + "." + "filter")
			}
			return err
		}
	}

	return nil
}

func (o *IamServiceSearchPrincipalsBody) validatePagination(formats strfmt.Registry) error {
	if swag.IsZero(o.Pagination) { // not required
		return nil
	}

	if o.Pagination != nil {
		if err := o.Pagination.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("body" + "." + "pagination")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("body" + "." + "pagination")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this iam service search principals body based on the context it is used
func (o *IamServiceSearchPrincipalsBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateFilter(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidatePagination(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *IamServiceSearchPrincipalsBody) contextValidateFilter(ctx context.Context, formats strfmt.Registry) error {

	if o.Filter != nil {

		if swag.IsZero(o.Filter) { // not required
			return nil
		}

		if err := o.Filter.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("body" + "." + "filter")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("body" + "." + "filter")
			}
			return err
		}
	}

	return nil
}

func (o *IamServiceSearchPrincipalsBody) contextValidatePagination(ctx context.Context, formats strfmt.Registry) error {

	if o.Pagination != nil {

		if swag.IsZero(o.Pagination) { // not required
			return nil
		}

		if err := o.Pagination.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("body" + "." + "pagination")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("body" + "." + "pagination")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *IamServiceSearchPrincipalsBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *IamServiceSearchPrincipalsBody) UnmarshalBinary(b []byte) error {
	var res IamServiceSearchPrincipalsBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
