/*=========================================================================
*
*  Copyright NumFOCUS
*
*  Licensed under the Apache License, Version 2.0 (the "License");
*  you may not use this file except in compliance with the License.
*  You may obtain a copy of the License at
*
*         http://www.apache.org/licenses/LICENSE-2.0.txt
*
*  Unless required by applicable law or agreed to in writing, software
*  distributed under the License is distributed on an "AS IS" BASIS,
*  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
*  See the License for the specific language governing permissions and
*  limitations under the License.
*
*=========================================================================*/
/*
 * WARNING: DO NOT EDIT THIS FILE!
 * THIS FILE IS AUTOMATICALLY GENERATED BY THE SIMPLEITK BUILD PROCESS.
 * Please look at sitkImageFilterTemplate.cxx.in to make changes.
 */

#include "itkImage.h"
#include "itkVectorImage.h"
#include "itkLabelMap.h"
#include "itkLabelObject.h"
#include "itkNumericTraits.h"
#include "itkNumericTraitsVariableLengthVectorPixel.h"
#include "itkVectorIndexSelectionCastImageFilter.h"
#include "itkComposeImageFilter.h"

#include "sitkScalarChanAndVeseDenseLevelSetImageFilter.h"
#include "itkScalarChanAndVeseDenseLevelSetImageFilter.h"

// Additional include files
#include "itkAtanRegularizedHeavisideStepFunction.h"
#include "itkSinRegularizedHeavisideStepFunction.h"
#include "itkHeavisideStepFunction.h"
// Done with additional include files

namespace itk::simple {

//-----------------------------------------------------------------------------

//
// Default constructor that initializes parameters
//
ScalarChanAndVeseDenseLevelSetImageFilter::ScalarChanAndVeseDenseLevelSetImageFilter ()
{
  this->m_MemberFactory =  std::make_unique<detail::MemberFunctionFactory<MemberFunctionType>>( this );

  this->m_MemberFactory->RegisterMemberFunctions< PixelIDTypeList, 2, 3 > ();



}

//
// Destructor
//
ScalarChanAndVeseDenseLevelSetImageFilter::~ScalarChanAndVeseDenseLevelSetImageFilter() = default;



//
// ToString
//
std::string ScalarChanAndVeseDenseLevelSetImageFilter::ToString() const
{
  std::ostringstream out;
  out << "itk::simple::ScalarChanAndVeseDenseLevelSetImageFilter\n";
  out << "  MaximumRMSError: ";
  this->ToStringHelper(out, this->m_MaximumRMSError);
  out << std::endl;
  out << "  NumberOfIterations: ";
  this->ToStringHelper(out, this->m_NumberOfIterations);
  out << std::endl;
  out << "  Lambda1: ";
  this->ToStringHelper(out, this->m_Lambda1);
  out << std::endl;
  out << "  Lambda2: ";
  this->ToStringHelper(out, this->m_Lambda2);
  out << std::endl;
  out << "  Epsilon: ";
  this->ToStringHelper(out, this->m_Epsilon);
  out << std::endl;
  out << "  CurvatureWeight: ";
  this->ToStringHelper(out, this->m_CurvatureWeight);
  out << std::endl;
  out << "  AreaWeight: ";
  this->ToStringHelper(out, this->m_AreaWeight);
  out << std::endl;
  out << "  ReinitializationSmoothingWeight: ";
  this->ToStringHelper(out, this->m_ReinitializationSmoothingWeight);
  out << std::endl;
  out << "  Volume: ";
  this->ToStringHelper(out, this->m_Volume);
  out << std::endl;
  out << "  VolumeMatchingWeight: ";
  this->ToStringHelper(out, this->m_VolumeMatchingWeight);
  out << std::endl;
  out << "  HeavisideStepFunction: ";
  this->ToStringHelper(out, this->m_HeavisideStepFunction);
  out << std::endl;
  out << "  UseImageSpacing: ";
  this->ToStringHelper(out, this->m_UseImageSpacing);
  out << std::endl;
  out << "  ElapsedIterations: " << this->m_ElapsedIterations << std::endl;
  out << "  RMSChange: " << this->m_RMSChange << std::endl;

  out << ProcessObject::ToString();
  return out.str();
}

//
// Execute
//
Image ScalarChanAndVeseDenseLevelSetImageFilter::Execute ( const Image & initialImage, const Image & featureImage )
{
  const PixelIDValueEnum type = initialImage.GetPixelID();
  const unsigned int dimension = initialImage.GetDimension();
  CheckImageMatchingDimension(  initialImage, featureImage, "featureImage" );
  CheckImageMatchingSize(  initialImage, featureImage, "featureImage" );

  return this->m_MemberFactory->GetMemberFunction( type, dimension )( &initialImage, &featureImage );
}



//-----------------------------------------------------------------------------

sitkClangDiagnosticPush();
sitkClangWarningIgnore("-Wunused-local-typedef");

//
// ExecuteInternal
//
template <class TImageType>
Image ScalarChanAndVeseDenseLevelSetImageFilter::ExecuteInternal ( const Image * inInitialImage, const Image * inFeatureImage )
{
  // Define the input and output image types
  using InputImageType = TImageType;


  using OutputImageType = InputImageType;



  using FilterType = itk::ScalarChanAndVeseDenseLevelSetImageFilter<InputImageType, InputImageType, InputImageType, itk::ScalarChanAndVeseLevelSetFunction< InputImageType, InputImageType > >;
  // Set up the ITK filter
  typename FilterType::Pointer filter = FilterType::New();


  assert( inInitialImage != nullptr );
  filter->SetFunctionCount( 1 ); filter->SetLevelSet(0, this->CastImageToITK<typename FilterType::InputImageType>(*inInitialImage));
  assert( inFeatureImage != nullptr );
  filter->SetInput(this->CastImageToITK<typename FilterType::FeatureImageType>(*inFeatureImage));


  filter->SetMaximumRMSError ( this->m_MaximumRMSError );
  filter->SetNumberOfIterations ( this->m_NumberOfIterations );
  filter->GetDifferenceFunction(0)->SetLambda1(m_Lambda1);
  filter->GetDifferenceFunction(0)->SetLambda2(m_Lambda2);
  
  filter->GetDifferenceFunction(0)->SetCurvatureWeight(m_CurvatureWeight);
  filter->GetDifferenceFunction(0)->SetAreaWeight(m_AreaWeight);
  filter->GetDifferenceFunction(0)->SetReinitializationSmoothingWeight(m_ReinitializationSmoothingWeight);
  filter->GetDifferenceFunction(0)->SetVolume(m_Volume);
  filter->GetDifferenceFunction(0)->SetVolumeMatchingWeight(m_VolumeMatchingWeight);
  if (m_HeavisideStepFunction == AtanRegularizedHeaviside) {
    using DomainFunctionType =  itk::AtanRegularizedHeavisideStepFunction< typename InputImageType::PixelType, typename InputImageType::PixelType >;
    typename DomainFunctionType::Pointer domainFunction = DomainFunctionType::New();
    domainFunction->SetEpsilon(m_Epsilon);
    filter->GetDifferenceFunction(0)->SetDomainFunction( domainFunction );
  } else if ( m_HeavisideStepFunction == SinRegularizedHeaviside ) {
    using DomainFunctionType = itk::SinRegularizedHeavisideStepFunction< typename InputImageType::PixelType, typename InputImageType::PixelType >;
    typename DomainFunctionType::Pointer domainFunction = DomainFunctionType::New();
    domainFunction->SetEpsilon(m_Epsilon);
    filter->GetDifferenceFunction(0)->SetDomainFunction( domainFunction );
  } else {
    using DomainFunctionType = itk::HeavisideStepFunction< typename InputImageType::PixelType, typename InputImageType::PixelType >;
    typename DomainFunctionType::Pointer domainFunction = DomainFunctionType::New();
    filter->GetDifferenceFunction(0)->SetDomainFunction( domainFunction );
  }
  filter->SetUseImageSpacing ( this->m_UseImageSpacing );




  this->PreUpdate( filter.GetPointer() );



  // Run the ITK filter and return the output as a SimpleITK image
  filter->Update();

  this->m_ElapsedIterations = filter->GetElapsedIterations();
  this->m_RMSChange = filter->GetRMSChange();


  typename FilterType::OutputImageType::Pointer itkOutImage{ filter->GetOutput()};
  filter = nullptr;
  this->FixNonZeroIndex( itkOutImage.GetPointer() );
  return Image{ this->CastITKToImage( itkOutImage.GetPointer() ) };

}

sitkClangDiagnosticPop();

//-----------------------------------------------------------------------------


//
// Function to run the Execute method of this filter
//
Image ScalarChanAndVeseDenseLevelSet ( const Image & initialImage, const Image & featureImage, double maximumRMSError, uint32_t numberOfIterations, double lambda1, double lambda2, double epsilon, double curvatureWeight, double areaWeight, double reinitializationSmoothingWeight, double volume, double volumeMatchingWeight, ScalarChanAndVeseDenseLevelSetImageFilter::HeavisideStepFunctionType heavisideStepFunction, bool useImageSpacing )
{
  ScalarChanAndVeseDenseLevelSetImageFilter filter;
  filter.SetMaximumRMSError( maximumRMSError );  filter.SetNumberOfIterations( numberOfIterations );  filter.SetLambda1( lambda1 );  filter.SetLambda2( lambda2 );  filter.SetEpsilon( epsilon );  filter.SetCurvatureWeight( curvatureWeight );  filter.SetAreaWeight( areaWeight );  filter.SetReinitializationSmoothingWeight( reinitializationSmoothingWeight );  filter.SetVolume( volume );  filter.SetVolumeMatchingWeight( volumeMatchingWeight );  filter.SetHeavisideStepFunction( heavisideStepFunction );  filter.SetUseImageSpacing( useImageSpacing );
  return filter.Execute ( initialImage, featureImage );
}


}
