/*
 * MOTIS API
 *
 * This is the MOTIS routing API.  Overview of MOTIS API versions:  MOTIS 0.x - deprecated/discontinued  MOTIS 2.x - current, providing:  * /api/v5/{plan,trip,stoptimes,map/trips} renamed METRO mode to SUBURBAN, AREAL_LIFT to AERIAL_LIFT; since MOTIS 2.5.0 * /api/v4/{plan,trip,stoptimes,map/trips} new displayName property, routeShortName only contains actual route short name from source; since MOTIS 2.2.0 * /api/v3/plan with correct maxTransfers API parameter (transfers actually corresponding to number of changes between transit legs (and not to number of transit legs), i.e. maxTransfers=0 returns direct public transit connections, as expected); since MOTIS 2.0.84  * /api/v2/{plan,trip} returns Google polylines with precision=6; since MOTIS 2.0.60 * /api/v1/{plan,trip} returns Google polylines with precision=7 (not defined for |longitude|>107) * /api/v1/_* all other endpoints  If you use the JS client lib https://www.npmjs.com/package/@motis-project/motis-client, endpoint versions will be taken into account automatically (i.e. the newest one available will be used). 
 *
 * The version of the OpenAPI document: v5
 * Contact: felix@triptix.tech
 * Generated by: https://openapi-generator.tech
 */

use crate::models;
use serde::{Deserialize, Serialize};

/// TimeRange : A time interval. The interval is considered active at time t if t is greater than or equal to the start time and less than the end time. 
#[derive(Clone, Default, Debug, PartialEq, Serialize, Deserialize)]
pub struct TimeRange {
    /// If missing, the interval starts at minus infinity. If a TimeRange is provided, either start or end must be provided - both fields cannot be empty. 
    #[serde(rename = "start")]
    pub start: String,
    /// If missing, the interval ends at plus infinity. If a TimeRange is provided, either start or end must be provided - both fields cannot be empty. 
    #[serde(rename = "end")]
    pub end: String,
}

impl TimeRange {
    /// A time interval. The interval is considered active at time t if t is greater than or equal to the start time and less than the end time. 
    pub fn new(start: String, end: String) -> TimeRange {
        TimeRange {
            start,
            end,
        }
    }
}

