// services/viz/public/mojom/compositing/layer_context.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_LAYER_CONTEXT_MOJOM_H_
#define SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_LAYER_CONTEXT_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>

#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/viz/public/mojom/compositing/layer_context.mojom-features.h"  // IWYU pragma: export
#include "services/viz/public/mojom/compositing/layer_context.mojom-shared.h"  // IWYU pragma: export
#include "services/viz/public/mojom/compositing/layer_context.mojom-forward.h"  // IWYU pragma: export
#include "services/viz/public/mojom/compositing/animation.mojom.h"
#include "services/viz/public/mojom/compositing/begin_frame_args.mojom.h"
#include "services/viz/public/mojom/compositing/layer.mojom.h"
#include "services/viz/public/mojom/compositing/local_surface_id.mojom.h"
#include "services/viz/public/mojom/compositing/tiling.mojom.h"
#include "skia/public/mojom/skcolor4f.mojom.h"
#include "ui/gfx/geometry/mojom/geometry.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"






namespace viz::mojom {

class LayerContextProxy;

template <typename ImplRefTraits>
class LayerContextStub;

class LayerContextRequestValidator;


class LayerContext
    : public LayerContextInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();

  static const char Name_[];
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = LayerContextInterfaceBase;
  using Proxy_ = LayerContextProxy;

  template <typename ImplRefTraits>
  using Stub_ = LayerContextStub<ImplRefTraits>;

  using RequestValidator_ = LayerContextRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kSetVisibleMinVersion = 0,
    kUpdateDisplayTreeMinVersion = 0,
    kUpdateDisplayTilingMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct SetVisible_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct UpdateDisplayTree_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct UpdateDisplayTiling_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~LayerContext() = default;

  
  virtual void SetVisible(bool visible) = 0;

  
  virtual void UpdateDisplayTree(LayerTreeUpdatePtr update) = 0;

  
  virtual void UpdateDisplayTiling(::viz::mojom::TilingPtr tiling) = 0;
};

class LayerContextClientProxy;

template <typename ImplRefTraits>
class LayerContextClientStub;

class LayerContextClientRequestValidator;


class LayerContextClient
    : public LayerContextClientInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();

  static const char Name_[];
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = LayerContextClientInterfaceBase;
  using Proxy_ = LayerContextClientProxy;

  template <typename ImplRefTraits>
  using Stub_ = LayerContextClientStub<ImplRefTraits>;

  using RequestValidator_ = LayerContextClientRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kOnRequestCommitForFrameMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct OnRequestCommitForFrame_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~LayerContextClient() = default;

  
  virtual void OnRequestCommitForFrame(const ::viz::BeginFrameArgs& args) = 0;
};



class  LayerContextProxy
    : public LayerContext {
 public:
  using InterfaceType = LayerContext;

  explicit LayerContextProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void SetVisible(bool visible) final;
  
  void UpdateDisplayTree(LayerTreeUpdatePtr update) final;
  
  void UpdateDisplayTiling(::viz::mojom::TilingPtr tiling) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  LayerContextClientProxy
    : public LayerContextClient {
 public:
  using InterfaceType = LayerContextClient;

  explicit LayerContextClientProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void OnRequestCommitForFrame(const ::viz::BeginFrameArgs& args) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  LayerContextStubDispatch {
 public:
  static bool Accept(LayerContext* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      LayerContext* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<LayerContext>>
class LayerContextStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  LayerContextStub() = default;
  ~LayerContextStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return LayerContextStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return LayerContextStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  LayerContextClientStubDispatch {
 public:
  static bool Accept(LayerContextClient* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      LayerContextClient* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<LayerContextClient>>
class LayerContextClientStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  LayerContextClientStub() = default;
  ~LayerContextClientStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return LayerContextClientStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return LayerContextClientStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  LayerContextRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  LayerContextClientRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};









class  LayerTreeUpdate {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<LayerTreeUpdate, T>::value>;
  using DataView = LayerTreeUpdateDataView;
  using Data_ = internal::LayerTreeUpdate_Data;

  template <typename... Args>
  static LayerTreeUpdatePtr New(Args&&... args) {
    return LayerTreeUpdatePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static LayerTreeUpdatePtr From(const U& u) {
    return mojo::TypeConverter<LayerTreeUpdatePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, LayerTreeUpdate>::Convert(*this);
  }


  LayerTreeUpdate();

  LayerTreeUpdate(
      int32_t source_frame_number,
      uint64_t trace_id,
      const ::gfx::Rect& device_viewport,
      float device_scale_factor,
      float painted_device_scale_factor,
      const std::optional<::viz::LocalSurfaceId>& local_surface_id_from_parent,
      const ::SkColor4f& background_color,
      int32_t overscroll_elasticity_transform,
      int32_t page_scale_transform,
      int32_t inner_scroll,
      int32_t outer_clip,
      int32_t outer_scroll,
      std::vector<::viz::mojom::LayerPtr> layers,
      std::optional<std::vector<int32_t>> layer_order,
      ::viz::mojom::TransformTreeUpdatePtr transform_tree_update,
      std::vector<::viz::mojom::TransformNodePtr> transform_nodes,
      std::vector<::viz::mojom::ClipNodePtr> clip_nodes,
      std::vector<::viz::mojom::EffectNodePtr> effect_nodes,
      std::vector<::viz::mojom::ScrollNodePtr> scroll_nodes,
      uint32_t num_transform_nodes,
      uint32_t num_clip_nodes,
      uint32_t num_effect_nodes,
      uint32_t num_scroll_nodes,
      std::vector<::viz::mojom::TilingPtr> tilings,
      std::optional<std::vector<::viz::mojom::AnimationTimelinePtr>> animation_timelines,
      std::optional<std::vector<int32_t>> removed_animation_timelines);

LayerTreeUpdate(const LayerTreeUpdate&) = delete;
LayerTreeUpdate& operator=(const LayerTreeUpdate&) = delete;

  ~LayerTreeUpdate();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = LayerTreeUpdatePtr>
  LayerTreeUpdatePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, LayerTreeUpdate::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, LayerTreeUpdate::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, LayerTreeUpdate::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        LayerTreeUpdate::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        LayerTreeUpdate::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::LayerTreeUpdate_UnserializedMessageContext<
            UserType, LayerTreeUpdate::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<LayerTreeUpdate::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return LayerTreeUpdate::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::LayerTreeUpdate_UnserializedMessageContext<
            UserType, LayerTreeUpdate::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<LayerTreeUpdate::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  int32_t source_frame_number;
  
  uint64_t trace_id;
  
  ::gfx::Rect device_viewport;
  
  float device_scale_factor;
  
  float painted_device_scale_factor;
  
  std::optional<::viz::LocalSurfaceId> local_surface_id_from_parent;
  
  ::SkColor4f background_color;
  
  int32_t overscroll_elasticity_transform;
  
  int32_t page_scale_transform;
  
  int32_t inner_scroll;
  
  int32_t outer_clip;
  
  int32_t outer_scroll;
  
  std::vector<::viz::mojom::LayerPtr> layers;
  
  std::optional<std::vector<int32_t>> layer_order;
  
  ::viz::mojom::TransformTreeUpdatePtr transform_tree_update;
  
  std::vector<::viz::mojom::TransformNodePtr> transform_nodes;
  
  std::vector<::viz::mojom::ClipNodePtr> clip_nodes;
  
  std::vector<::viz::mojom::EffectNodePtr> effect_nodes;
  
  std::vector<::viz::mojom::ScrollNodePtr> scroll_nodes;
  
  uint32_t num_transform_nodes;
  
  uint32_t num_clip_nodes;
  
  uint32_t num_effect_nodes;
  
  uint32_t num_scroll_nodes;
  
  std::vector<::viz::mojom::TilingPtr> tilings;
  
  std::optional<std::vector<::viz::mojom::AnimationTimelinePtr>> animation_timelines;
  
  std::optional<std::vector<int32_t>> removed_animation_timelines;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, LayerTreeUpdate::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, LayerTreeUpdate::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, LayerTreeUpdate::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, LayerTreeUpdate::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  PendingLayerContext {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<PendingLayerContext, T>::value>;
  using DataView = PendingLayerContextDataView;
  using Data_ = internal::PendingLayerContext_Data;

  template <typename... Args>
  static PendingLayerContextPtr New(Args&&... args) {
    return PendingLayerContextPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static PendingLayerContextPtr From(const U& u) {
    return mojo::TypeConverter<PendingLayerContextPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, PendingLayerContext>::Convert(*this);
  }


  PendingLayerContext();

  PendingLayerContext(
      ::mojo::PendingAssociatedReceiver<LayerContext> receiver,
      ::mojo::PendingAssociatedRemote<LayerContextClient> client);

PendingLayerContext(const PendingLayerContext&) = delete;
PendingLayerContext& operator=(const PendingLayerContext&) = delete;

  ~PendingLayerContext();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = PendingLayerContextPtr>
  PendingLayerContextPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, PendingLayerContext::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, PendingLayerContext::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, PendingLayerContext::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        PendingLayerContext::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::PendingLayerContext_UnserializedMessageContext<
            UserType, PendingLayerContext::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<PendingLayerContext::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return PendingLayerContext::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::PendingLayerContext_UnserializedMessageContext<
            UserType, PendingLayerContext::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<PendingLayerContext::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::mojo::PendingAssociatedReceiver<LayerContext> receiver;
  
  ::mojo::PendingAssociatedRemote<LayerContextClient> client;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, PendingLayerContext::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, PendingLayerContext::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, PendingLayerContext::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, PendingLayerContext::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
LayerTreeUpdatePtr LayerTreeUpdate::Clone() const {
  return New(
      mojo::Clone(source_frame_number),
      mojo::Clone(trace_id),
      mojo::Clone(device_viewport),
      mojo::Clone(device_scale_factor),
      mojo::Clone(painted_device_scale_factor),
      mojo::Clone(local_surface_id_from_parent),
      mojo::Clone(background_color),
      mojo::Clone(overscroll_elasticity_transform),
      mojo::Clone(page_scale_transform),
      mojo::Clone(inner_scroll),
      mojo::Clone(outer_clip),
      mojo::Clone(outer_scroll),
      mojo::Clone(layers),
      mojo::Clone(layer_order),
      mojo::Clone(transform_tree_update),
      mojo::Clone(transform_nodes),
      mojo::Clone(clip_nodes),
      mojo::Clone(effect_nodes),
      mojo::Clone(scroll_nodes),
      mojo::Clone(num_transform_nodes),
      mojo::Clone(num_clip_nodes),
      mojo::Clone(num_effect_nodes),
      mojo::Clone(num_scroll_nodes),
      mojo::Clone(tilings),
      mojo::Clone(animation_timelines),
      mojo::Clone(removed_animation_timelines)
  );
}

template <typename T, LayerTreeUpdate::EnableIfSame<T>*>
bool LayerTreeUpdate::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->source_frame_number, other_struct.source_frame_number))
    return false;
  if (!mojo::Equals(this->trace_id, other_struct.trace_id))
    return false;
  if (!mojo::Equals(this->device_viewport, other_struct.device_viewport))
    return false;
  if (!mojo::Equals(this->device_scale_factor, other_struct.device_scale_factor))
    return false;
  if (!mojo::Equals(this->painted_device_scale_factor, other_struct.painted_device_scale_factor))
    return false;
  if (!mojo::Equals(this->local_surface_id_from_parent, other_struct.local_surface_id_from_parent))
    return false;
  if (!mojo::Equals(this->background_color, other_struct.background_color))
    return false;
  if (!mojo::Equals(this->overscroll_elasticity_transform, other_struct.overscroll_elasticity_transform))
    return false;
  if (!mojo::Equals(this->page_scale_transform, other_struct.page_scale_transform))
    return false;
  if (!mojo::Equals(this->inner_scroll, other_struct.inner_scroll))
    return false;
  if (!mojo::Equals(this->outer_clip, other_struct.outer_clip))
    return false;
  if (!mojo::Equals(this->outer_scroll, other_struct.outer_scroll))
    return false;
  if (!mojo::Equals(this->layers, other_struct.layers))
    return false;
  if (!mojo::Equals(this->layer_order, other_struct.layer_order))
    return false;
  if (!mojo::Equals(this->transform_tree_update, other_struct.transform_tree_update))
    return false;
  if (!mojo::Equals(this->transform_nodes, other_struct.transform_nodes))
    return false;
  if (!mojo::Equals(this->clip_nodes, other_struct.clip_nodes))
    return false;
  if (!mojo::Equals(this->effect_nodes, other_struct.effect_nodes))
    return false;
  if (!mojo::Equals(this->scroll_nodes, other_struct.scroll_nodes))
    return false;
  if (!mojo::Equals(this->num_transform_nodes, other_struct.num_transform_nodes))
    return false;
  if (!mojo::Equals(this->num_clip_nodes, other_struct.num_clip_nodes))
    return false;
  if (!mojo::Equals(this->num_effect_nodes, other_struct.num_effect_nodes))
    return false;
  if (!mojo::Equals(this->num_scroll_nodes, other_struct.num_scroll_nodes))
    return false;
  if (!mojo::Equals(this->tilings, other_struct.tilings))
    return false;
  if (!mojo::Equals(this->animation_timelines, other_struct.animation_timelines))
    return false;
  if (!mojo::Equals(this->removed_animation_timelines, other_struct.removed_animation_timelines))
    return false;
  return true;
}

template <typename T, LayerTreeUpdate::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.source_frame_number < rhs.source_frame_number)
    return true;
  if (rhs.source_frame_number < lhs.source_frame_number)
    return false;
  if (lhs.trace_id < rhs.trace_id)
    return true;
  if (rhs.trace_id < lhs.trace_id)
    return false;
  if (lhs.device_viewport < rhs.device_viewport)
    return true;
  if (rhs.device_viewport < lhs.device_viewport)
    return false;
  if (lhs.device_scale_factor < rhs.device_scale_factor)
    return true;
  if (rhs.device_scale_factor < lhs.device_scale_factor)
    return false;
  if (lhs.painted_device_scale_factor < rhs.painted_device_scale_factor)
    return true;
  if (rhs.painted_device_scale_factor < lhs.painted_device_scale_factor)
    return false;
  if (lhs.local_surface_id_from_parent < rhs.local_surface_id_from_parent)
    return true;
  if (rhs.local_surface_id_from_parent < lhs.local_surface_id_from_parent)
    return false;
  if (lhs.background_color < rhs.background_color)
    return true;
  if (rhs.background_color < lhs.background_color)
    return false;
  if (lhs.overscroll_elasticity_transform < rhs.overscroll_elasticity_transform)
    return true;
  if (rhs.overscroll_elasticity_transform < lhs.overscroll_elasticity_transform)
    return false;
  if (lhs.page_scale_transform < rhs.page_scale_transform)
    return true;
  if (rhs.page_scale_transform < lhs.page_scale_transform)
    return false;
  if (lhs.inner_scroll < rhs.inner_scroll)
    return true;
  if (rhs.inner_scroll < lhs.inner_scroll)
    return false;
  if (lhs.outer_clip < rhs.outer_clip)
    return true;
  if (rhs.outer_clip < lhs.outer_clip)
    return false;
  if (lhs.outer_scroll < rhs.outer_scroll)
    return true;
  if (rhs.outer_scroll < lhs.outer_scroll)
    return false;
  if (lhs.layers < rhs.layers)
    return true;
  if (rhs.layers < lhs.layers)
    return false;
  if (lhs.layer_order < rhs.layer_order)
    return true;
  if (rhs.layer_order < lhs.layer_order)
    return false;
  if (lhs.transform_tree_update < rhs.transform_tree_update)
    return true;
  if (rhs.transform_tree_update < lhs.transform_tree_update)
    return false;
  if (lhs.transform_nodes < rhs.transform_nodes)
    return true;
  if (rhs.transform_nodes < lhs.transform_nodes)
    return false;
  if (lhs.clip_nodes < rhs.clip_nodes)
    return true;
  if (rhs.clip_nodes < lhs.clip_nodes)
    return false;
  if (lhs.effect_nodes < rhs.effect_nodes)
    return true;
  if (rhs.effect_nodes < lhs.effect_nodes)
    return false;
  if (lhs.scroll_nodes < rhs.scroll_nodes)
    return true;
  if (rhs.scroll_nodes < lhs.scroll_nodes)
    return false;
  if (lhs.num_transform_nodes < rhs.num_transform_nodes)
    return true;
  if (rhs.num_transform_nodes < lhs.num_transform_nodes)
    return false;
  if (lhs.num_clip_nodes < rhs.num_clip_nodes)
    return true;
  if (rhs.num_clip_nodes < lhs.num_clip_nodes)
    return false;
  if (lhs.num_effect_nodes < rhs.num_effect_nodes)
    return true;
  if (rhs.num_effect_nodes < lhs.num_effect_nodes)
    return false;
  if (lhs.num_scroll_nodes < rhs.num_scroll_nodes)
    return true;
  if (rhs.num_scroll_nodes < lhs.num_scroll_nodes)
    return false;
  if (lhs.tilings < rhs.tilings)
    return true;
  if (rhs.tilings < lhs.tilings)
    return false;
  if (lhs.animation_timelines < rhs.animation_timelines)
    return true;
  if (rhs.animation_timelines < lhs.animation_timelines)
    return false;
  if (lhs.removed_animation_timelines < rhs.removed_animation_timelines)
    return true;
  if (rhs.removed_animation_timelines < lhs.removed_animation_timelines)
    return false;
  return false;
}
template <typename StructPtrType>
PendingLayerContextPtr PendingLayerContext::Clone() const {
  return New(
      mojo::Clone(receiver),
      mojo::Clone(client)
  );
}

template <typename T, PendingLayerContext::EnableIfSame<T>*>
bool PendingLayerContext::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->receiver, other_struct.receiver))
    return false;
  if (!mojo::Equals(this->client, other_struct.client))
    return false;
  return true;
}

template <typename T, PendingLayerContext::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.receiver < rhs.receiver)
    return true;
  if (rhs.receiver < lhs.receiver)
    return false;
  if (lhs.client < rhs.client)
    return true;
  if (rhs.client < lhs.client)
    return false;
  return false;
}


}  // viz::mojom

namespace mojo {


template <>
struct  StructTraits<::viz::mojom::LayerTreeUpdate::DataView,
                                         ::viz::mojom::LayerTreeUpdatePtr> {
  static bool IsNull(const ::viz::mojom::LayerTreeUpdatePtr& input) { return !input; }
  static void SetToNull(::viz::mojom::LayerTreeUpdatePtr* output) { output->reset(); }

  static decltype(::viz::mojom::LayerTreeUpdate::source_frame_number) source_frame_number(
      const ::viz::mojom::LayerTreeUpdatePtr& input) {
    return input->source_frame_number;
  }

  static decltype(::viz::mojom::LayerTreeUpdate::trace_id) trace_id(
      const ::viz::mojom::LayerTreeUpdatePtr& input) {
    return input->trace_id;
  }

  static const decltype(::viz::mojom::LayerTreeUpdate::device_viewport)& device_viewport(
      const ::viz::mojom::LayerTreeUpdatePtr& input) {
    return input->device_viewport;
  }

  static decltype(::viz::mojom::LayerTreeUpdate::device_scale_factor) device_scale_factor(
      const ::viz::mojom::LayerTreeUpdatePtr& input) {
    return input->device_scale_factor;
  }

  static decltype(::viz::mojom::LayerTreeUpdate::painted_device_scale_factor) painted_device_scale_factor(
      const ::viz::mojom::LayerTreeUpdatePtr& input) {
    return input->painted_device_scale_factor;
  }

  static const decltype(::viz::mojom::LayerTreeUpdate::local_surface_id_from_parent)& local_surface_id_from_parent(
      const ::viz::mojom::LayerTreeUpdatePtr& input) {
    return input->local_surface_id_from_parent;
  }

  static const decltype(::viz::mojom::LayerTreeUpdate::background_color)& background_color(
      const ::viz::mojom::LayerTreeUpdatePtr& input) {
    return input->background_color;
  }

  static decltype(::viz::mojom::LayerTreeUpdate::overscroll_elasticity_transform) overscroll_elasticity_transform(
      const ::viz::mojom::LayerTreeUpdatePtr& input) {
    return input->overscroll_elasticity_transform;
  }

  static decltype(::viz::mojom::LayerTreeUpdate::page_scale_transform) page_scale_transform(
      const ::viz::mojom::LayerTreeUpdatePtr& input) {
    return input->page_scale_transform;
  }

  static decltype(::viz::mojom::LayerTreeUpdate::inner_scroll) inner_scroll(
      const ::viz::mojom::LayerTreeUpdatePtr& input) {
    return input->inner_scroll;
  }

  static decltype(::viz::mojom::LayerTreeUpdate::outer_clip) outer_clip(
      const ::viz::mojom::LayerTreeUpdatePtr& input) {
    return input->outer_clip;
  }

  static decltype(::viz::mojom::LayerTreeUpdate::outer_scroll) outer_scroll(
      const ::viz::mojom::LayerTreeUpdatePtr& input) {
    return input->outer_scroll;
  }

  static const decltype(::viz::mojom::LayerTreeUpdate::layers)& layers(
      const ::viz::mojom::LayerTreeUpdatePtr& input) {
    return input->layers;
  }

  static const decltype(::viz::mojom::LayerTreeUpdate::layer_order)& layer_order(
      const ::viz::mojom::LayerTreeUpdatePtr& input) {
    return input->layer_order;
  }

  static const decltype(::viz::mojom::LayerTreeUpdate::transform_tree_update)& transform_tree_update(
      const ::viz::mojom::LayerTreeUpdatePtr& input) {
    return input->transform_tree_update;
  }

  static const decltype(::viz::mojom::LayerTreeUpdate::transform_nodes)& transform_nodes(
      const ::viz::mojom::LayerTreeUpdatePtr& input) {
    return input->transform_nodes;
  }

  static const decltype(::viz::mojom::LayerTreeUpdate::clip_nodes)& clip_nodes(
      const ::viz::mojom::LayerTreeUpdatePtr& input) {
    return input->clip_nodes;
  }

  static const decltype(::viz::mojom::LayerTreeUpdate::effect_nodes)& effect_nodes(
      const ::viz::mojom::LayerTreeUpdatePtr& input) {
    return input->effect_nodes;
  }

  static const decltype(::viz::mojom::LayerTreeUpdate::scroll_nodes)& scroll_nodes(
      const ::viz::mojom::LayerTreeUpdatePtr& input) {
    return input->scroll_nodes;
  }

  static decltype(::viz::mojom::LayerTreeUpdate::num_transform_nodes) num_transform_nodes(
      const ::viz::mojom::LayerTreeUpdatePtr& input) {
    return input->num_transform_nodes;
  }

  static decltype(::viz::mojom::LayerTreeUpdate::num_clip_nodes) num_clip_nodes(
      const ::viz::mojom::LayerTreeUpdatePtr& input) {
    return input->num_clip_nodes;
  }

  static decltype(::viz::mojom::LayerTreeUpdate::num_effect_nodes) num_effect_nodes(
      const ::viz::mojom::LayerTreeUpdatePtr& input) {
    return input->num_effect_nodes;
  }

  static decltype(::viz::mojom::LayerTreeUpdate::num_scroll_nodes) num_scroll_nodes(
      const ::viz::mojom::LayerTreeUpdatePtr& input) {
    return input->num_scroll_nodes;
  }

  static const decltype(::viz::mojom::LayerTreeUpdate::tilings)& tilings(
      const ::viz::mojom::LayerTreeUpdatePtr& input) {
    return input->tilings;
  }

  static const decltype(::viz::mojom::LayerTreeUpdate::animation_timelines)& animation_timelines(
      const ::viz::mojom::LayerTreeUpdatePtr& input) {
    return input->animation_timelines;
  }

  static const decltype(::viz::mojom::LayerTreeUpdate::removed_animation_timelines)& removed_animation_timelines(
      const ::viz::mojom::LayerTreeUpdatePtr& input) {
    return input->removed_animation_timelines;
  }

  static bool Read(::viz::mojom::LayerTreeUpdate::DataView input, ::viz::mojom::LayerTreeUpdatePtr* output);
};


template <>
struct  StructTraits<::viz::mojom::PendingLayerContext::DataView,
                                         ::viz::mojom::PendingLayerContextPtr> {
  static bool IsNull(const ::viz::mojom::PendingLayerContextPtr& input) { return !input; }
  static void SetToNull(::viz::mojom::PendingLayerContextPtr* output) { output->reset(); }

  static  decltype(::viz::mojom::PendingLayerContext::receiver)& receiver(
       ::viz::mojom::PendingLayerContextPtr& input) {
    return input->receiver;
  }

  static  decltype(::viz::mojom::PendingLayerContext::client)& client(
       ::viz::mojom::PendingLayerContextPtr& input) {
    return input->client;
  }

  static bool Read(::viz::mojom::PendingLayerContext::DataView input, ::viz::mojom::PendingLayerContextPtr* output);
};

}  // namespace mojo

#endif  // SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_LAYER_CONTEXT_MOJOM_H_