/**
 * Copyright (c) 2014-present, The osquery authors
 *
 * This source code is licensed as defined by the LICENSE file found in the
 * root directory of this source tree.
 *
 * SPDX-License-Identifier: (Apache-2.0 OR GPL-2.0-only)
 */

/*
** This file is generated. Do not modify it manually!
*/

#include <osquery/events/eventsubscriber.h>
#include <osquery/logger/logger.h>
#include <osquery/sql/dynamic_table_row.h>
#include <osquery/core/tables.h>
#include <osquery/registry/registry_factory.h>

namespace osquery {

void registerForeignTables() {


  class accountPolicyDataTablePlugin : public TablePlugin {
   private:
    TableColumns columns() const override {
      return {
        std::make_tuple("uid", BIGINT_TYPE, ColumnOptions::DEFAULT),
        std::make_tuple("creation_time", DOUBLE_TYPE, ColumnOptions::DEFAULT),
        std::make_tuple("failed_login_count", BIGINT_TYPE, ColumnOptions::DEFAULT),
        std::make_tuple("failed_login_timestamp", DOUBLE_TYPE, ColumnOptions::DEFAULT),
        std::make_tuple("password_last_set_time", DOUBLE_TYPE, ColumnOptions::DEFAULT),
      };
    }


    TableRows generate(QueryContext& request) override { return TableRows(); }
  };

  {
    auto registry = RegistryFactory::get().registry("table");
    registry->add("account_policy_data",
      std::make_shared<accountPolicyDataTablePlugin>(), false);
  }


}

}
