#pragma once

#ifndef RAINBOW_INTENSITY_H
#define RAINBOW_INTENSITY_H
// Scattering Intensity from water droplet for each wavelength
// and scattering angle
// Numerical computation is done with MiePlot by Philip Laven
// Parameters
// - Droplet radius : 0.2mm with dispersion (Normal distribution with 30% std
// dev.)
// - Sphere : Water [IAPWS 5C Complex]
// - Medium : Air [5C, 101325 Pa]
// - Spectrum : Constant (1.0)
// Variables
// - Scattering angle : [core] 120-150 degrees, every 0.1 degrees [wide] 90-180
// degrees, every 1 degree
// - Wavelength of light : 380-710 nm, every 10nm

static double rainbow_core_data[301][34] = {
    {7.53703E-10, 5.99059E-10, 6.21818E-10, 7.16047E-10, 6.81808E-10,
     5.81629E-10, 5.70477E-10, 6.33344E-10, 6.91537E-10, 5.39410E-10,
     5.97890E-10, 5.34078E-10, 5.73758E-10, 5.27641E-10, 5.75378E-10,
     5.30732E-10, 5.80132E-10, 6.37982E-10, 5.54494E-10, 5.43699E-10,
     5.02345E-10, 5.49687E-10, 5.28215E-10, 5.00259E-10, 5.29764E-10,
     5.38405E-10, 4.58416E-10, 4.98222E-10, 5.24476E-10, 5.61160E-10,
     5.18381E-10, 4.43256E-10, 4.47562E-10, 4.62786E-10},
    {7.03107E-10, 7.67893E-10, 7.68397E-10, 6.19667E-10, 6.90107E-10,
     6.81216E-10, 6.67726E-10, 6.30433E-10, 5.65225E-10, 6.20012E-10,
     5.84144E-10, 6.60860E-10, 5.74177E-10, 6.13956E-10, 5.25999E-10,
     5.85404E-10, 5.33942E-10, 5.41513E-10, 5.65076E-10, 5.72768E-10,
     5.74904E-10, 5.36466E-10, 4.87805E-10, 5.43123E-10, 5.19893E-10,
     5.35561E-10, 4.78201E-10, 5.16441E-10, 5.52878E-10, 5.22198E-10,
     5.25113E-10, 4.98905E-10, 4.79888E-10, 4.58519E-10},
    {7.89050E-10, 7.42024E-10, 6.30145E-10, 7.85734E-10, 6.41082E-10,
     6.67997E-10, 6.58616E-10, 6.06219E-10, 6.11343E-10, 6.16212E-10,
     6.08331E-10, 5.88368E-10, 5.78044E-10, 5.68421E-10, 5.59017E-10,
     5.50394E-10, 5.68627E-10, 5.15377E-10, 5.82827E-10, 5.04569E-10,
     5.37255E-10, 5.24402E-10, 5.01502E-10, 5.38158E-10, 4.94781E-10,
     4.74148E-10, 5.36035E-10, 5.21650E-10, 4.81225E-10, 4.69298E-10,
     4.77533E-10, 5.86993E-10, 5.40327E-10, 4.81369E-10},
    {7.08111E-10, 6.65878E-10, 7.55250E-10, 6.43077E-10, 7.19511E-10,
     6.30935E-10, 6.30678E-10, 6.44811E-10, 6.43111E-10, 5.69096E-10,
     5.86997E-10, 5.45224E-10, 5.79726E-10, 5.67934E-10, 5.69521E-10,
     5.57964E-10, 5.55842E-10, 5.36143E-10, 5.17805E-10, 5.61264E-10,
     4.93513E-10, 5.33483E-10, 5.78197E-10, 4.94405E-10, 5.40422E-10,
     4.89786E-10, 5.64111E-10, 5.05775E-10, 4.64181E-10, 5.20233E-10,
     5.18524E-10, 4.80418E-10, 4.99229E-10, 5.32606E-10},
    {7.96408E-10, 7.91364E-10, 7.18961E-10, 6.80917E-10, 6.50871E-10,
     6.67557E-10, 6.53589E-10, 6.57992E-10, 6.08551E-10, 6.65108E-10,
     5.98140E-10, 6.47692E-10, 5.50778E-10, 5.63819E-10, 6.19184E-10,
     5.52636E-10, 5.53930E-10, 5.91856E-10, 5.12676E-10, 5.50243E-10,
     5.40762E-10, 5.33560E-10, 5.44495E-10, 5.04115E-10, 5.27113E-10,
     5.46552E-10, 5.22742E-10, 5.04435E-10, 5.66317E-10, 5.54229E-10,
     5.21856E-10, 4.58068E-10, 4.55747E-10, 5.32999E-10},
    {7.29485E-10, 7.79135E-10, 7.16553E-10, 7.52443E-10, 6.90569E-10,
     7.18486E-10, 6.96252E-10, 6.26753E-10, 6.69833E-10, 6.65653E-10,
     6.45899E-10, 5.88728E-10, 6.35122E-10, 5.77057E-10, 5.24987E-10,
     5.91834E-10, 5.74831E-10, 5.89614E-10, 6.04753E-10, 5.39796E-10,
     5.94633E-10, 5.60685E-10, 5.11496E-10, 5.86820E-10, 5.39838E-10,
     5.48743E-10, 5.21738E-10, 5.22667E-10, 5.76149E-10, 5.33083E-10,
     5.01819E-10, 5.47937E-10, 5.27175E-10, 4.94776E-10},
    {7.82609E-10, 7.04178E-10, 7.45385E-10, 6.91510E-10, 6.94579E-10,
     6.15166E-10, 6.60688E-10, 6.80369E-10, 6.45976E-10, 5.66879E-10,
     6.03719E-10, 5.88178E-10, 6.18598E-10, 6.56844E-10, 5.65509E-10,
     6.18682E-10, 5.89120E-10, 5.30525E-10, 5.64665E-10, 6.02978E-10,
     5.61161E-10, 5.68319E-10, 5.51486E-10, 5.78535E-10, 5.29109E-10,
     5.37870E-10, 4.97934E-10, 5.65405E-10, 4.95187E-10, 5.12499E-10,
     5.50803E-10, 5.39018E-10, 5.72339E-10, 4.99528E-10},
    {7.71899E-10, 7.80361E-10, 6.91836E-10, 7.84770E-10, 7.14978E-10,
     7.58848E-10, 6.85340E-10, 6.14325E-10, 6.13332E-10, 6.65990E-10,
     6.55795E-10, 6.61438E-10, 5.90531E-10, 6.17617E-10, 6.48719E-10,
     5.21831E-10, 5.83948E-10, 5.86993E-10, 5.76295E-10, 5.81378E-10,
     5.57512E-10, 5.65788E-10, 5.49559E-10, 5.36869E-10, 5.61433E-10,
     5.41931E-10, 5.45019E-10, 5.38472E-10, 5.52557E-10, 5.11837E-10,
     5.61223E-10, 5.27796E-10, 5.37547E-10, 5.08767E-10},
    {8.35592E-10, 8.22175E-10, 7.86507E-10, 7.12875E-10, 7.18358E-10,
     6.32861E-10, 6.84454E-10, 6.49738E-10, 6.95702E-10, 6.82240E-10,
     6.41493E-10, 6.57888E-10, 6.27580E-10, 5.60365E-10, 5.91635E-10,
     6.60774E-10, 6.08377E-10, 6.23317E-10, 6.11048E-10, 5.08064E-10,
     5.53115E-10, 5.67845E-10, 6.06203E-10, 5.35153E-10, 5.83771E-10,
     5.74163E-10, 5.81570E-10, 5.03729E-10, 5.78669E-10, 5.50636E-10,
     5.13761E-10, 5.49110E-10, 4.76164E-10, 4.89592E-10},
    {7.23511E-10, 7.28795E-10, 7.10853E-10, 6.92290E-10, 6.53623E-10,
     7.83213E-10, 7.17477E-10, 7.29804E-10, 6.15449E-10, 5.75946E-10,
     6.29474E-10, 5.55812E-10, 6.06170E-10, 6.52503E-10, 5.73425E-10,
     5.58414E-10, 5.82568E-10, 5.56555E-10, 5.47531E-10, 6.19147E-10,
     5.88844E-10, 5.71942E-10, 5.67366E-10, 6.06589E-10, 5.19951E-10,
     5.59452E-10, 5.48584E-10, 5.64964E-10, 5.62987E-10, 5.58251E-10,
     5.10933E-10, 5.48959E-10, 5.23566E-10, 5.30235E-10},
    {8.54952E-10, 8.06637E-10, 7.64932E-10, 7.69104E-10, 7.95178E-10,
     6.28759E-10, 7.01654E-10, 6.59224E-10, 6.80857E-10, 7.27852E-10,
     6.20897E-10, 6.51931E-10, 5.96698E-10, 5.98672E-10, 6.09980E-10,
     5.70340E-10, 5.94486E-10, 6.10457E-10, 6.13080E-10, 5.98938E-10,
     5.55266E-10, 5.66584E-10, 5.34212E-10, 5.74600E-10, 5.42718E-10,
     5.24004E-10, 5.43902E-10, 5.67700E-10, 5.14631E-10, 5.20660E-10,
     5.39691E-10, 5.05057E-10, 5.57009E-10, 5.80932E-10},
    {8.10480E-10, 8.11231E-10, 8.16803E-10, 7.81107E-10, 6.96353E-10,
     7.62965E-10, 7.14654E-10, 7.02525E-10, 7.09365E-10, 6.44411E-10,
     7.09931E-10, 6.64390E-10, 6.69883E-10, 6.43673E-10, 6.10770E-10,
     6.50006E-10, 5.75006E-10, 6.15419E-10, 5.64843E-10, 5.54360E-10,
     5.79429E-10, 5.63267E-10, 5.61032E-10, 4.81723E-10, 5.87510E-10,
     5.56762E-10, 5.34632E-10, 5.28166E-10, 5.30729E-10, 5.43831E-10,
     5.25756E-10, 5.59799E-10, 5.85984E-10, 5.42104E-10},
    {8.53710E-10, 7.90718E-10, 7.09088E-10, 7.10782E-10, 7.00212E-10,
     6.70503E-10, 6.67593E-10, 7.13147E-10, 6.15786E-10, 6.19529E-10,
     6.55942E-10, 6.28366E-10, 6.80472E-10, 6.24859E-10, 6.12696E-10,
     6.25383E-10, 6.27939E-10, 5.98568E-10, 5.93292E-10, 5.97394E-10,
     6.14390E-10, 6.22971E-10, 5.94992E-10, 5.50908E-10, 5.72759E-10,
     6.02021E-10, 5.64945E-10, 5.55851E-10, 5.92201E-10, 6.23883E-10,
     6.13772E-10, 6.19159E-10, 5.87884E-10, 5.10667E-10},
    {8.33960E-10, 8.37697E-10, 7.83386E-10, 8.38641E-10, 8.13728E-10,
     7.68252E-10, 7.09194E-10, 6.75474E-10, 7.55950E-10, 7.60053E-10,
     6.55821E-10, 7.24148E-10, 5.70897E-10, 6.59169E-10, 6.28272E-10,
     6.10927E-10, 6.69865E-10, 6.40187E-10, 6.25393E-10, 5.88452E-10,
     6.19154E-10, 5.70680E-10, 6.19811E-10, 6.81332E-10, 5.43025E-10,
     5.86652E-10, 6.12916E-10, 5.96630E-10, 6.06467E-10, 5.66166E-10,
     6.18369E-10, 5.41830E-10, 5.36024E-10, 5.45088E-10},
    {8.54613E-10, 8.24447E-10, 7.97262E-10, 6.92045E-10, 7.76745E-10,
     7.07463E-10, 7.85198E-10, 7.01348E-10, 6.33218E-10, 6.33030E-10,
     6.84216E-10, 6.06697E-10, 6.96210E-10, 6.66417E-10, 6.78549E-10,
     6.50715E-10, 5.85162E-10, 6.17046E-10, 6.30736E-10, 6.60911E-10,
     5.71952E-10, 6.35335E-10, 6.29643E-10, 6.25961E-10, 5.85820E-10,
     6.11786E-10, 5.48624E-10, 5.64112E-10, 5.74896E-10, 5.07590E-10,
     5.36756E-10, 5.36951E-10, 5.35650E-10, 5.66172E-10},
    {9.12978E-10, 8.31414E-10, 7.97226E-10, 8.87174E-10, 7.12867E-10,
     7.70691E-10, 6.82081E-10, 7.35290E-10, 6.98460E-10, 6.93513E-10,
     6.59120E-10, 6.99153E-10, 6.49799E-10, 6.27718E-10, 6.16609E-10,
     6.33518E-10, 6.52436E-10, 6.20667E-10, 6.10517E-10, 5.91386E-10,
     6.25888E-10, 6.02319E-10, 5.69284E-10, 5.66221E-10, 6.17766E-10,
     5.71363E-10, 5.45389E-10, 5.46677E-10, 5.16806E-10, 5.51546E-10,
     5.05380E-10, 5.79672E-10, 5.58131E-10, 5.42363E-10},
    {7.99979E-10, 8.99482E-10, 8.29027E-10, 7.27470E-10, 7.85051E-10,
     7.38426E-10, 7.31321E-10, 7.63198E-10, 7.40363E-10, 7.12082E-10,
     7.02948E-10, 6.82191E-10, 6.67814E-10, 6.74483E-10, 5.93702E-10,
     6.30428E-10, 6.36446E-10, 6.96638E-10, 6.00973E-10, 5.82205E-10,
     6.24406E-10, 5.78629E-10, 5.79345E-10, 5.54300E-10, 6.16890E-10,
     5.49884E-10, 6.22860E-10, 6.11641E-10, 6.10335E-10, 6.37951E-10,
     5.63273E-10, 6.13880E-10, 5.96397E-10, 5.23032E-10},
    {9.48189E-10, 7.96034E-10, 8.14682E-10, 7.93523E-10, 7.96273E-10,
     7.74162E-10, 8.21115E-10, 6.89773E-10, 7.62417E-10, 7.19721E-10,
     6.85220E-10, 6.46987E-10, 6.33617E-10, 6.44374E-10, 6.82517E-10,
     6.52587E-10, 6.18321E-10, 5.82871E-10, 6.88276E-10, 6.75478E-10,
     5.74016E-10, 5.84145E-10, 6.56129E-10, 6.02881E-10, 5.64798E-10,
     6.29941E-10, 6.33084E-10, 5.98005E-10, 6.49715E-10, 5.60816E-10,
     6.24143E-10, 5.59937E-10, 5.51607E-10, 6.00418E-10},
    {8.62681E-10, 9.51440E-10, 8.37564E-10, 9.10698E-10, 7.74391E-10,
     7.52984E-10, 6.96157E-10, 7.66989E-10, 6.82977E-10, 7.10717E-10,
     7.42822E-10, 7.11472E-10, 6.59023E-10, 7.39975E-10, 6.88845E-10,
     6.43325E-10, 6.71818E-10, 6.36446E-10, 6.57558E-10, 6.20358E-10,
     6.38069E-10, 6.38255E-10, 6.02601E-10, 6.47455E-10, 5.55875E-10,
     6.67808E-10, 5.10097E-10, 5.64230E-10, 5.16313E-10, 5.49890E-10,
     5.69131E-10, 5.57693E-10, 5.84505E-10, 6.13816E-10},
    {9.93378E-10, 8.07653E-10, 8.09432E-10, 7.57492E-10, 8.64796E-10,
     7.93014E-10, 7.51704E-10, 7.43764E-10, 7.80107E-10, 7.06051E-10,
     6.93406E-10, 7.03010E-10, 8.30468E-10, 7.07091E-10, 6.45841E-10,
     6.87996E-10, 6.34284E-10, 7.12719E-10, 5.76920E-10, 5.96708E-10,
     6.21805E-10, 6.57628E-10, 5.80377E-10, 6.18975E-10, 6.20234E-10,
     6.30230E-10, 5.68102E-10, 6.19065E-10, 5.81752E-10, 6.77903E-10,
     5.78099E-10, 6.06007E-10, 6.17822E-10, 5.27909E-10},
    {8.29922E-10, 9.85380E-10, 8.83360E-10, 8.68866E-10, 8.09978E-10,
     8.08904E-10, 8.15376E-10, 7.53826E-10, 6.80519E-10, 7.43133E-10,
     7.29504E-10, 7.38807E-10, 6.01873E-10, 6.43068E-10, 7.07405E-10,
     7.41989E-10, 7.04531E-10, 6.61945E-10, 6.90467E-10, 6.87636E-10,
     6.45882E-10, 6.49404E-10, 7.39061E-10, 6.14499E-10, 6.89294E-10,
     5.39909E-10, 6.72590E-10, 6.66153E-10, 6.56194E-10, 6.08192E-10,
     6.03093E-10, 6.51811E-10, 5.83882E-10, 5.74091E-10},
    {1.00405E-09, 8.07067E-10, 8.11068E-10, 7.78962E-10, 8.10905E-10,
     8.15708E-10, 8.20953E-10, 8.12921E-10, 8.11383E-10, 7.24933E-10,
     7.13488E-10, 6.27971E-10, 6.73604E-10, 6.98729E-10, 6.63200E-10,
     6.15312E-10, 6.49168E-10, 6.42644E-10, 6.98624E-10, 6.54772E-10,
     6.76666E-10, 5.92922E-10, 6.60989E-10, 6.96776E-10, 6.12060E-10,
     6.41268E-10, 6.23892E-10, 5.80658E-10, 6.47059E-10, 6.07858E-10,
     6.25269E-10, 6.39550E-10, 6.20965E-10, 6.60892E-10},
    {8.99240E-10, 1.03050E-09, 9.09227E-10, 9.31775E-10, 8.32011E-10,
     8.06462E-10, 7.36743E-10, 7.56113E-10, 7.64025E-10, 7.41660E-10,
     7.30367E-10, 7.89539E-10, 7.25902E-10, 7.63861E-10, 6.78150E-10,
     6.89661E-10, 6.68822E-10, 7.41173E-10, 6.50499E-10, 6.37030E-10,
     6.08076E-10, 6.77758E-10, 5.58351E-10, 6.30829E-10, 6.10394E-10,
     6.45958E-10, 5.92445E-10, 5.95410E-10, 6.41481E-10, 6.37487E-10,
     5.91750E-10, 5.65843E-10, 5.69012E-10, 6.25623E-10},
    {9.80862E-10, 8.55259E-10, 9.13290E-10, 7.75959E-10, 8.23971E-10,
     7.67957E-10, 8.59857E-10, 7.73639E-10, 7.65704E-10, 7.78576E-10,
     7.86173E-10, 7.14957E-10, 7.46622E-10, 6.59465E-10, 6.99002E-10,
     7.03304E-10, 7.33670E-10, 6.26121E-10, 6.61316E-10, 6.60835E-10,
     6.76782E-10, 6.47820E-10, 6.62591E-10, 5.81294E-10, 6.25232E-10,
     6.66526E-10, 6.28349E-10, 6.24833E-10, 5.87909E-10, 6.12658E-10,
     5.95759E-10, 6.13044E-10, 6.28426E-10, 5.34964E-10},
    {9.41828E-10, 9.04723E-10, 8.73251E-10, 9.95807E-10, 8.90010E-10,
     8.68429E-10, 7.61946E-10, 8.20803E-10, 7.48563E-10, 7.74038E-10,
     7.06412E-10, 7.39497E-10, 6.77218E-10, 7.04523E-10, 6.67453E-10,
     7.26677E-10, 6.53924E-10, 6.46348E-10, 7.09134E-10, 6.91225E-10,
     6.72177E-10, 6.23382E-10, 6.69015E-10, 6.93292E-10, 6.28754E-10,
     6.54159E-10, 6.58290E-10, 6.09654E-10, 6.28965E-10, 6.31234E-10,
     6.56529E-10, 6.30704E-10, 6.31290E-10, 5.66543E-10},
    {1.12600E-09, 1.08172E-09, 9.23463E-10, 8.04248E-10, 8.42557E-10,
     8.29554E-10, 8.89366E-10, 7.58071E-10, 8.50019E-10, 7.63632E-10,
     7.89122E-10, 7.69116E-10, 7.54982E-10, 7.53415E-10, 7.64180E-10,
     6.89245E-10, 7.35200E-10, 7.23144E-10, 6.63262E-10, 6.41164E-10,
     6.52354E-10, 6.90490E-10, 6.43233E-10, 6.43561E-10, 6.92679E-10,
     5.76587E-10, 5.99228E-10, 6.68947E-10, 6.31572E-10, 6.51164E-10,
     6.44119E-10, 6.03423E-10, 5.95187E-10, 6.57108E-10},
    {8.97826E-10, 8.37685E-10, 8.28211E-10, 9.13448E-10, 9.25596E-10,
     9.26330E-10, 7.91150E-10, 8.31747E-10, 7.36122E-10, 7.89310E-10,
     8.02352E-10, 7.21600E-10, 7.61044E-10, 7.45745E-10, 7.10565E-10,
     6.73500E-10, 7.10255E-10, 6.98668E-10, 6.57351E-10, 6.72929E-10,
     6.87059E-10, 6.93382E-10, 6.87392E-10, 6.41010E-10, 6.48691E-10,
     6.71338E-10, 6.48096E-10, 6.59109E-10, 6.58370E-10, 6.18469E-10,
     6.02902E-10, 6.24386E-10, 6.30710E-10, 6.63619E-10},
    {1.08939E-09, 1.03143E-09, 1.11070E-09, 9.32843E-10, 8.34622E-10,
     8.33480E-10, 8.41288E-10, 7.59038E-10, 7.91225E-10, 7.76027E-10,
     7.23677E-10, 7.53219E-10, 7.48748E-10, 7.42411E-10, 7.21856E-10,
     7.91026E-10, 7.23384E-10, 7.22329E-10, 7.52407E-10, 7.49564E-10,
     6.72302E-10, 6.61268E-10, 6.94293E-10, 7.56786E-10, 5.94394E-10,
     7.50213E-10, 6.80956E-10, 6.11343E-10, 6.85785E-10, 6.96582E-10,
     6.48963E-10, 7.17972E-10, 6.61435E-10, 6.19577E-10},
    {9.26922E-10, 9.78117E-10, 8.31351E-10, 8.54971E-10, 9.34286E-10,
     8.94196E-10, 9.04073E-10, 9.02882E-10, 8.29407E-10, 7.82570E-10,
     8.14576E-10, 7.68754E-10, 7.44657E-10, 7.39553E-10, 7.94573E-10,
     7.72558E-10, 7.03777E-10, 7.50094E-10, 7.70864E-10, 6.96351E-10,
     7.74484E-10, 6.97662E-10, 6.94644E-10, 6.31480E-10, 7.30408E-10,
     6.53787E-10, 6.53557E-10, 6.81970E-10, 6.72230E-10, 6.54849E-10,
     7.28186E-10, 6.34534E-10, 6.64759E-10, 6.16111E-10},
    {1.10565E-09, 1.02347E-09, 9.95377E-10, 1.00961E-09, 9.07746E-10,
     8.53900E-10, 8.00560E-10, 8.06885E-10, 8.46363E-10, 8.60285E-10,
     7.82683E-10, 7.41570E-10, 7.71029E-10, 7.70735E-10, 6.73695E-10,
     6.63354E-10, 7.80346E-10, 6.91838E-10, 6.72937E-10, 7.29349E-10,
     6.53743E-10, 6.94740E-10, 7.10478E-10, 6.74970E-10, 6.92284E-10,
     6.91400E-10, 6.49101E-10, 6.93602E-10, 6.35767E-10, 6.34759E-10,
     6.25578E-10, 5.45548E-10, 6.09119E-10, 6.96717E-10},
    {1.07549E-09, 9.56084E-10, 9.79119E-10, 8.69789E-10, 9.08256E-10,
     8.89464E-10, 9.12712E-10, 8.51642E-10, 8.35454E-10, 8.21076E-10,
     7.96480E-10, 8.88444E-10, 7.51972E-10, 7.20796E-10, 7.50396E-10,
     7.62056E-10, 7.28340E-10, 7.47023E-10, 6.62667E-10, 6.85923E-10,
     7.17395E-10, 7.29821E-10, 7.12532E-10, 7.43143E-10, 6.74668E-10,
     7.31830E-10, 7.23234E-10, 6.55142E-10, 6.75906E-10, 7.38319E-10,
     6.09160E-10, 7.21150E-10, 6.74615E-10, 6.58195E-10},
    {1.05907E-09, 1.05049E-09, 1.06781E-09, 1.06246E-09, 1.01312E-09,
     9.45296E-10, 8.36401E-10, 8.87807E-10, 8.51895E-10, 8.36687E-10,
     8.82615E-10, 7.45097E-10, 8.24941E-10, 8.57912E-10, 7.73142E-10,
     7.62659E-10, 6.91358E-10, 7.13579E-10, 7.91096E-10, 7.29019E-10,
     7.45741E-10, 7.01986E-10, 6.94930E-10, 6.56214E-10, 7.07778E-10,
     7.11735E-10, 6.54163E-10, 6.55032E-10, 6.99467E-10, 6.60504E-10,
     6.87311E-10, 7.28418E-10, 6.61535E-10, 6.11879E-10},
    {1.15748E-09, 9.87826E-10, 8.78369E-10, 9.27933E-10, 9.53207E-10,
     8.50184E-10, 8.94039E-10, 8.06000E-10, 8.46746E-10, 8.37219E-10,
     7.91516E-10, 8.17763E-10, 7.74570E-10, 7.46083E-10, 7.97977E-10,
     7.44915E-10, 7.86322E-10, 7.81830E-10, 7.49586E-10, 7.47596E-10,
     6.78917E-10, 7.06944E-10, 7.21441E-10, 7.03869E-10, 6.72882E-10,
     6.25192E-10, 7.01541E-10, 7.39560E-10, 6.55684E-10, 6.32505E-10,
     6.59540E-10, 6.20788E-10, 6.36533E-10, 6.56582E-10},
    {1.21081E-09, 1.11646E-09, 1.17539E-09, 1.01199E-09, 9.22737E-10,
     1.00419E-09, 9.55283E-10, 9.13911E-10, 8.62826E-10, 7.89486E-10,
     8.73111E-10, 8.50223E-10, 8.07051E-10, 8.38183E-10, 7.57772E-10,
     8.23250E-10, 7.93560E-10, 7.17837E-10, 7.14787E-10, 7.37202E-10,
     7.41345E-10, 7.79350E-10, 6.91427E-10, 7.50202E-10, 6.98714E-10,
     6.77522E-10, 6.81843E-10, 6.98911E-10, 7.14512E-10, 6.91434E-10,
     6.70904E-10, 7.04670E-10, 6.98697E-10, 6.61651E-10},
    {1.28402E-09, 1.10413E-09, 9.24792E-10, 9.90188E-10, 1.03492E-09,
     9.77613E-10, 9.05427E-10, 9.10660E-10, 8.94764E-10, 9.14379E-10,
     8.25396E-10, 8.03883E-10, 8.67910E-10, 8.02238E-10, 8.59335E-10,
     8.43152E-10, 7.64472E-10, 8.09294E-10, 8.13444E-10, 7.42087E-10,
     8.05606E-10, 7.03014E-10, 7.58369E-10, 6.57290E-10, 7.45543E-10,
     7.92694E-10, 6.68381E-10, 6.42442E-10, 7.26679E-10, 7.08007E-10,
     7.22015E-10, 7.45055E-10, 7.30209E-10, 7.31182E-10},
    {1.30020E-09, 1.10560E-09, 1.12726E-09, 1.01406E-09, 9.59854E-10,
     9.34264E-10, 9.49019E-10, 9.17874E-10, 8.78904E-10, 8.44218E-10,
     8.59904E-10, 8.47696E-10, 7.60084E-10, 8.05279E-10, 7.40835E-10,
     6.80594E-10, 8.10602E-10, 8.04093E-10, 7.62401E-10, 7.41899E-10,
     7.35149E-10, 7.73526E-10, 7.29293E-10, 7.44698E-10, 7.23357E-10,
     8.13447E-10, 7.48322E-10, 7.48761E-10, 6.86665E-10, 7.17088E-10,
     7.00804E-10, 6.63236E-10, 6.69280E-10, 7.14027E-10},
    {1.27323E-09, 1.23087E-09, 1.07830E-09, 9.97673E-10, 9.97345E-10,
     9.52858E-10, 9.49104E-10, 9.46501E-10, 9.54124E-10, 9.10182E-10,
     8.67795E-10, 8.52310E-10, 8.53515E-10, 8.44770E-10, 8.30342E-10,
     8.65821E-10, 7.75499E-10, 7.15992E-10, 7.28903E-10, 8.64645E-10,
     7.82948E-10, 7.69935E-10, 7.80753E-10, 7.61584E-10, 7.30842E-10,
     6.64060E-10, 7.57141E-10, 7.43929E-10, 7.12321E-10, 7.17898E-10,
     7.55734E-10, 7.28930E-10, 6.94955E-10, 6.96333E-10},
    {1.31759E-09, 1.26595E-09, 1.11112E-09, 1.12531E-09, 1.00057E-09,
     1.01274E-09, 9.39179E-10, 9.27829E-10, 9.07805E-10, 9.06650E-10,
     9.30137E-10, 8.36735E-10, 8.41453E-10, 7.84313E-10, 8.40729E-10,
     8.10241E-10, 8.08723E-10, 8.24810E-10, 8.74278E-10, 7.74642E-10,
     8.29288E-10, 7.54918E-10, 7.37747E-10, 7.54342E-10, 7.30729E-10,
     7.45106E-10, 7.02424E-10, 7.15736E-10, 7.86425E-10, 6.87873E-10,
     7.43953E-10, 7.32244E-10, 7.58103E-10, 6.57506E-10},
    {1.17828E-09, 1.28874E-09, 1.20902E-09, 1.03978E-09, 1.01611E-09,
     9.74812E-10, 9.58473E-10, 9.43490E-10, 9.46009E-10, 8.60488E-10,
     8.24737E-10, 9.12858E-10, 8.80228E-10, 9.07106E-10, 7.97177E-10,
     8.43338E-10, 8.18525E-10, 8.48441E-10, 7.72487E-10, 6.86320E-10,
     6.99377E-10, 7.71306E-10, 7.67277E-10, 7.07362E-10, 7.58879E-10,
     7.89765E-10, 6.86377E-10, 7.30861E-10, 7.14337E-10, 7.35069E-10,
     6.65886E-10, 7.17571E-10, 6.96715E-10, 6.66106E-10},
    {1.12151E-09, 1.31970E-09, 1.27373E-09, 1.14339E-09, 1.08333E-09,
     1.00242E-09, 9.74481E-10, 9.58621E-10, 9.22420E-10, 1.06014E-09,
     9.85491E-10, 9.12277E-10, 8.87702E-10, 8.20398E-10, 8.76565E-10,
     7.42717E-10, 7.54775E-10, 7.80617E-10, 7.97835E-10, 8.56185E-10,
     7.77877E-10, 7.46309E-10, 7.54507E-10, 8.43832E-10, 7.42143E-10,
     7.97078E-10, 7.89438E-10, 7.78284E-10, 7.17060E-10, 7.54663E-10,
     7.15039E-10, 7.15311E-10, 6.64637E-10, 7.62079E-10},
    {9.59254E-10, 1.17360E-09, 1.31587E-09, 1.20980E-09, 1.05657E-09,
     1.11652E-09, 9.70849E-10, 9.09520E-10, 9.75141E-10, 8.13678E-10,
     8.94641E-10, 9.11705E-10, 9.17072E-10, 9.12691E-10, 8.42249E-10,
     9.10008E-10, 8.88289E-10, 7.65813E-10, 8.51719E-10, 8.31097E-10,
     8.36580E-10, 8.29969E-10, 7.68787E-10, 7.21886E-10, 7.48683E-10,
     7.61442E-10, 7.86354E-10, 7.11729E-10, 8.07637E-10, 6.91830E-10,
     7.64928E-10, 7.56352E-10, 7.77751E-10, 7.95521E-10},
    {8.33605E-10, 1.15908E-09, 1.25019E-09, 1.21618E-09, 1.21419E-09,
     1.02485E-09, 1.06177E-09, 1.06677E-09, 9.44302E-10, 1.00447E-09,
     9.48911E-10, 8.90215E-10, 8.59174E-10, 8.83314E-10, 8.66037E-10,
     8.96617E-10, 9.06683E-10, 8.80730E-10, 7.95791E-10, 7.71023E-10,
     8.21555E-10, 7.87588E-10, 8.02671E-10, 7.21372E-10, 7.63037E-10,
     7.44187E-10, 7.59252E-10, 7.83943E-10, 8.05734E-10, 7.12336E-10,
     7.74408E-10, 7.97111E-10, 7.93990E-10, 7.36790E-10},
    {8.22516E-10, 1.00592E-09, 1.25447E-09, 1.30721E-09, 1.10698E-09,
     1.12464E-09, 9.90648E-10, 9.36892E-10, 9.91517E-10, 8.80864E-10,
     8.81009E-10, 9.43096E-10, 9.48916E-10, 8.76929E-10, 9.53068E-10,
     8.08524E-10, 7.88496E-10, 8.19608E-10, 8.53871E-10, 8.54951E-10,
     8.13458E-10, 7.82937E-10, 8.01143E-10, 8.31271E-10, 8.05386E-10,
     8.01685E-10, 7.62364E-10, 7.92347E-10, 7.00941E-10, 8.60518E-10,
     7.17563E-10, 7.22237E-10, 7.08681E-10, 7.01969E-10},
    {1.07475E-09, 9.03944E-10, 1.19636E-09, 1.25629E-09, 1.33892E-09,
     1.14828E-09, 1.10424E-09, 1.05686E-09, 9.74923E-10, 1.03811E-09,
     9.88446E-10, 9.00912E-10, 8.83837E-10, 9.08986E-10, 9.01508E-10,
     9.52213E-10, 8.77493E-10, 8.39969E-10, 8.32158E-10, 8.55470E-10,
     8.04022E-10, 9.22568E-10, 8.01902E-10, 8.10511E-10, 7.84095E-10,
     8.49772E-10, 7.58841E-10, 7.33535E-10, 7.49997E-10, 7.92394E-10,
     7.87587E-10, 7.94482E-10, 7.55854E-10, 7.30453E-10},
    {1.21789E-09, 8.33989E-10, 9.84705E-10, 1.22016E-09, 1.15755E-09,
     1.30630E-09, 1.12003E-09, 1.06694E-09, 1.08586E-09, 9.01184E-10,
     9.00456E-10, 9.54512E-10, 9.19792E-10, 8.97902E-10, 8.75218E-10,
     8.41763E-10, 8.81676E-10, 9.49459E-10, 9.21883E-10, 8.20176E-10,
     8.73646E-10, 7.70925E-10, 8.48471E-10, 8.27820E-10, 8.38822E-10,
     7.76886E-10, 8.68398E-10, 7.78511E-10, 7.99962E-10, 6.91429E-10,
     7.78630E-10, 7.89608E-10, 7.62211E-10, 7.88885E-10},
    {1.67389E-09, 8.89852E-10, 8.66059E-10, 1.19678E-09, 1.33026E-09,
     1.15854E-09, 1.17884E-09, 1.04780E-09, 1.00281E-09, 1.07132E-09,
     9.98698E-10, 9.11165E-10, 9.20519E-10, 9.20828E-10, 9.39378E-10,
     8.75766E-10, 8.81121E-10, 7.90024E-10, 8.16699E-10, 8.28379E-10,
     8.92763E-10, 8.76922E-10, 8.26892E-10, 8.40662E-10, 8.68591E-10,
     8.47580E-10, 7.50754E-10, 8.61198E-10, 8.64050E-10, 8.06218E-10,
     7.96986E-10, 8.03712E-10, 7.92531E-10, 8.10750E-10},
    {1.95147E-09, 1.14001E-09, 8.37283E-10, 9.47791E-10, 1.19998E-09,
     1.35309E-09, 1.21859E-09, 1.23014E-09, 1.10140E-09, 9.82251E-10,
     9.91186E-10, 9.98548E-10, 9.93977E-10, 9.12163E-10, 8.92359E-10,
     9.48953E-10, 8.87303E-10, 9.70877E-10, 9.29364E-10, 9.31464E-10,
     7.88522E-10, 8.30925E-10, 8.30104E-10, 8.52690E-10, 8.40354E-10,
     8.86332E-10, 8.07877E-10, 8.26458E-10, 7.58552E-10, 8.25476E-10,
     8.34757E-10, 8.21531E-10, 8.67961E-10, 7.24828E-10},
    {2.41683E-09, 1.40418E-09, 9.26652E-10, 8.83147E-10, 1.05928E-09,
     1.29034E-09, 1.26441E-09, 1.12603E-09, 1.15862E-09, 1.09899E-09,
     1.01369E-09, 1.00308E-09, 9.21232E-10, 9.54954E-10, 9.62781E-10,
     8.34963E-10, 8.28367E-10, 8.26581E-10, 8.30392E-10, 8.30048E-10,
     8.32409E-10, 7.92436E-10, 8.55566E-10, 8.01525E-10, 8.01896E-10,
     8.18755E-10, 9.10160E-10, 8.10064E-10, 7.80982E-10, 8.32706E-10,
     7.75456E-10, 7.64777E-10, 7.55194E-10, 8.43723E-10},
    {2.94268E-09, 1.83274E-09, 1.03470E-09, 8.48547E-10, 9.85835E-10,
     1.06952E-09, 1.23491E-09, 1.30329E-09, 1.12754E-09, 1.08924E-09,
     1.10953E-09, 1.01855E-09, 1.02647E-09, 1.02160E-09, 9.50949E-10,
     9.69544E-10, 1.01074E-09, 8.32398E-10, 8.98845E-10, 7.91451E-10,
     9.65950E-10, 9.17804E-10, 8.25974E-10, 8.89515E-10, 8.83855E-10,
     8.23844E-10, 7.94228E-10, 8.90840E-10, 9.12284E-10, 7.58796E-10,
     8.15624E-10, 8.56685E-10, 7.85836E-10, 8.91782E-10},
    {2.83156E-09, 2.16767E-09, 1.28937E-09, 8.90061E-10, 9.06514E-10,
     1.16867E-09, 1.23072E-09, 1.20512E-09, 1.30387E-09, 1.19622E-09,
     1.03113E-09, 1.04174E-09, 1.01449E-09, 8.91094E-10, 9.46200E-10,
     9.18096E-10, 8.61473E-10, 1.03135E-09, 9.10887E-10, 9.48332E-10,
     8.86757E-10, 9.13595E-10, 8.25258E-10, 8.38929E-10, 7.99017E-10,
     8.37871E-10, 7.77340E-10, 8.19068E-10, 7.64504E-10, 8.67070E-10,
     8.48098E-10, 8.50248E-10, 8.05603E-10, 7.87898E-10},
    {3.32485E-09, 2.58363E-09, 1.66464E-09, 9.68886E-10, 7.95365E-10,
     8.60587E-10, 1.08232E-09, 1.27756E-09, 1.16758E-09, 1.14453E-09,
     1.18707E-09, 1.12858E-09, 1.09058E-09, 1.07891E-09, 9.61823E-10,
     9.52558E-10, 1.00513E-09, 8.90908E-10, 9.17201E-10, 9.44696E-10,
     8.78162E-10, 8.24116E-10, 9.27840E-10, 8.07246E-10, 8.41975E-10,
     9.21709E-10, 9.18187E-10, 7.95478E-10, 7.97002E-10, 8.22806E-10,
     8.88318E-10, 8.27835E-10, 9.03624E-10, 7.81794E-10},
    {3.04627E-09, 3.08517E-09, 2.16279E-09, 1.29370E-09, 8.71411E-10,
     9.49545E-10, 9.62703E-10, 1.07321E-09, 1.26225E-09, 1.27465E-09,
     1.19817E-09, 1.11247E-09, 1.05533E-09, 1.11507E-09, 1.11873E-09,
     1.01949E-09, 9.48421E-10, 8.88890E-10, 9.54298E-10, 8.98694E-10,
     7.99215E-10, 9.60835E-10, 8.85304E-10, 9.35718E-10, 9.59318E-10,
     8.60145E-10, 8.58660E-10, 9.13109E-10, 9.43202E-10, 7.74707E-10,
     8.19649E-10, 8.49541E-10, 8.99819E-10, 8.58261E-10},
    {3.07482E-09, 2.86297E-09, 2.36719E-09, 1.60218E-09, 1.08117E-09,
     7.22736E-10, 9.66048E-10, 1.10358E-09, 1.18085E-09, 1.18693E-09,
     1.19521E-09, 1.22376E-09, 1.21478E-09, 9.82475E-10, 9.96365E-10,
     1.01194E-09, 9.52630E-10, 9.55324E-10, 9.45239E-10, 8.56901E-10,
     1.09219E-09, 8.87573E-10, 8.74090E-10, 9.12521E-10, 8.33163E-10,
     8.23483E-10, 8.58437E-10, 8.70012E-10, 7.79060E-10, 8.78517E-10,
     8.42797E-10, 8.65654E-10, 7.45097E-10, 8.22800E-10},
    {2.85432E-09, 3.36454E-09, 2.89476E-09, 2.09009E-09, 1.13462E-09,
     9.37025E-10, 7.31626E-10, 8.63777E-10, 1.02568E-09, 1.16217E-09,
     1.23755E-09, 1.19198E-09, 1.15606E-09, 1.21825E-09, 1.14938E-09,
     1.06509E-09, 1.07377E-09, 1.11016E-09, 1.03007E-09, 1.02766E-09,
     9.46020E-10, 9.57229E-10, 9.29066E-10, 8.59854E-10, 9.36398E-10,
     9.32335E-10, 9.46229E-10, 8.13039E-10, 9.16083E-10, 8.63606E-10,
     9.07471E-10, 8.26231E-10, 7.96419E-10, 7.82914E-10},
    {2.61777E-09, 3.09217E-09, 2.94844E-09, 2.33636E-09, 1.78571E-09,
     1.06046E-09, 8.30656E-10, 8.29799E-10, 9.74487E-10, 1.06817E-09,
     1.13597E-09, 1.25531E-09, 1.20907E-09, 1.16901E-09, 1.14000E-09,
     1.13277E-09, 1.11661E-09, 9.54063E-10, 1.00889E-09, 1.01086E-09,
     9.03720E-10, 9.86219E-10, 9.15031E-10, 9.43255E-10, 1.03043E-09,
     9.23892E-10, 8.77494E-10, 9.29829E-10, 9.11870E-10, 9.17725E-10,
     8.51673E-10, 9.17958E-10, 8.55079E-10, 8.93270E-10},
    {2.20082E-09, 2.96019E-09, 3.12248E-09, 2.72152E-09, 1.80832E-09,
     1.40765E-09, 9.61794E-10, 8.52528E-10, 8.24002E-10, 9.57139E-10,
     1.08853E-09, 1.09516E-09, 1.20502E-09, 1.18471E-09, 1.16973E-09,
     1.11072E-09, 1.00260E-09, 1.04635E-09, 1.03706E-09, 9.84835E-10,
     1.04951E-09, 9.79595E-10, 1.02372E-09, 9.76364E-10, 8.66613E-10,
     9.60740E-10, 9.62040E-10, 9.36463E-10, 8.47057E-10, 8.84288E-10,
     8.48670E-10, 9.19902E-10, 9.16463E-10, 8.60085E-10},
    {2.00994E-09, 2.84249E-09, 3.26893E-09, 2.99423E-09, 2.47854E-09,
     1.60041E-09, 1.13456E-09, 8.49215E-10, 8.76296E-10, 8.93539E-10,
     9.03405E-10, 1.12565E-09, 1.15949E-09, 1.13016E-09, 1.20670E-09,
     1.20070E-09, 1.27799E-09, 1.19355E-09, 1.08865E-09, 1.10758E-09,
     1.07731E-09, 1.03510E-09, 9.42926E-10, 1.03179E-09, 9.63235E-10,
     9.11706E-10, 9.51710E-10, 8.49132E-10, 9.36827E-10, 9.24385E-10,
     9.08001E-10, 9.36588E-10, 9.50177E-10, 9.71415E-10},
    {1.65239E-09, 2.41975E-09, 2.89763E-09, 3.15542E-09, 2.56695E-09,
     2.09712E-09, 1.51425E-09, 1.01314E-09, 7.82591E-10, 7.68363E-10,
     9.89835E-10, 9.84755E-10, 1.04934E-09, 1.24649E-09, 1.11985E-09,
     1.23452E-09, 1.04598E-09, 1.12856E-09, 1.20336E-09, 1.10667E-09,
     1.02395E-09, 1.05190E-09, 1.09909E-09, 9.97239E-10, 1.03110E-09,
     1.01080E-09, 9.56867E-10, 8.36994E-10, 8.98231E-10, 9.24770E-10,
     9.67672E-10, 8.71735E-10, 9.58580E-10, 9.78635E-10},
    {1.57071E-09, 2.11345E-09, 2.84732E-09, 3.00898E-09, 3.07189E-09,
     2.39290E-09, 1.59735E-09, 1.25809E-09, 9.18736E-10, 8.02338E-10,
     7.26274E-10, 8.49855E-10, 9.77224E-10, 1.00149E-09, 1.22273E-09,
     1.07211E-09, 1.20631E-09, 1.10009E-09, 1.06008E-09, 1.10872E-09,
     1.19192E-09, 1.12334E-09, 1.04942E-09, 1.03213E-09, 1.14050E-09,
     1.09039E-09, 9.32843E-10, 1.06176E-09, 9.91790E-10, 9.56869E-10,
     9.69359E-10, 9.26113E-10, 9.46971E-10, 9.31464E-10},
    {1.05308E-09, 1.99285E-09, 2.61052E-09, 3.14027E-09, 2.91620E-09,
     2.77115E-09, 2.38783E-09, 1.64191E-09, 1.21503E-09, 9.41363E-10,
     8.01341E-10, 8.23352E-10, 9.13986E-10, 1.00144E-09, 9.58997E-10,
     1.18920E-09, 1.11946E-09, 1.22950E-09, 1.22934E-09, 1.20452E-09,
     1.11272E-09, 1.19033E-09, 1.06977E-09, 1.12093E-09, 9.36851E-10,
     1.12433E-09, 1.05908E-09, 1.07380E-09, 1.01727E-09, 9.95383E-10,
     9.02510E-10, 1.07602E-09, 1.04495E-09, 1.02144E-09},
    {1.03202E-09, 1.60289E-09, 2.34935E-09, 2.71813E-09, 3.19628E-09,
     2.75428E-09, 2.30176E-09, 1.89957E-09, 1.43248E-09, 1.07328E-09,
     8.74565E-10, 7.76578E-10, 7.84878E-10, 8.07341E-10, 9.32872E-10,
     8.96979E-10, 1.04590E-09, 1.05652E-09, 1.08864E-09, 1.09765E-09,
     1.15961E-09, 1.08398E-09, 1.18125E-09, 1.10828E-09, 1.12638E-09,
     1.09552E-09, 1.11576E-09, 9.88642E-10, 1.04800E-09, 1.09921E-09,
     1.04354E-09, 1.07471E-09, 9.77453E-10, 1.00414E-09},
    {8.26977E-10, 1.29745E-09, 1.93040E-09, 2.77564E-09, 3.04094E-09,
     3.16564E-09, 2.90323E-09, 2.30444E-09, 1.71487E-09, 1.30582E-09,
     1.01798E-09, 8.77144E-10, 8.15595E-10, 8.51662E-10, 8.57678E-10,
     1.01091E-09, 9.91988E-10, 1.07353E-09, 1.07060E-09, 1.17678E-09,
     1.15555E-09, 1.14027E-09, 1.09328E-09, 1.08962E-09, 1.25110E-09,
     1.06810E-09, 1.13930E-09, 1.16841E-09, 1.05174E-09, 1.15714E-09,
     1.13413E-09, 1.00723E-09, 1.00811E-09, 1.11585E-09},
    {6.93269E-10, 1.15070E-09, 1.75828E-09, 2.26398E-09, 2.81067E-09,
     2.98748E-09, 2.86983E-09, 2.59048E-09, 2.18542E-09, 1.65863E-09,
     1.28781E-09, 1.02526E-09, 8.06794E-10, 7.70469E-10, 8.16903E-10,
     7.76932E-10, 8.69323E-10, 9.14981E-10, 1.04045E-09, 1.06519E-09,
     1.01661E-09, 1.11990E-09, 1.16322E-09, 1.12825E-09, 9.78545E-10,
     1.20078E-09, 1.14050E-09, 1.07580E-09, 1.19250E-09, 1.05552E-09,
     1.02565E-09, 1.11678E-09, 1.14405E-09, 1.10825E-09},
    {5.84428E-10, 9.41454E-10, 1.45998E-09, 2.06960E-09, 2.55728E-09,
     2.91357E-09, 3.11021E-09, 2.89710E-09, 2.39747E-09, 2.01480E-09,
     1.51914E-09, 1.22632E-09, 1.00150E-09, 8.65580E-10, 7.47843E-10,
     8.47988E-10, 8.33075E-10, 8.85065E-10, 8.65096E-10, 8.59986E-10,
     1.04906E-09, 1.02389E-09, 1.18592E-09, 1.11387E-09, 1.13945E-09,
     1.13769E-09, 1.18726E-09, 1.12839E-09, 1.18442E-09, 1.07574E-09,
     1.06071E-09, 1.15125E-09, 1.07818E-09, 1.11674E-09},
    {4.42342E-10, 7.99860E-10, 1.27469E-09, 1.94224E-09, 2.64765E-09,
     2.85677E-09, 3.05220E-09, 2.91753E-09, 2.65756E-09, 2.25456E-09,
     1.90289E-09, 1.48492E-09, 1.25358E-09, 1.00697E-09, 8.67562E-10,
     7.32385E-10, 7.49059E-10, 7.72682E-10, 8.85546E-10, 9.59604E-10,
     9.08689E-10, 1.01690E-09, 8.29756E-10, 1.09750E-09, 1.16919E-09,
     9.45319E-10, 1.00565E-09, 1.11532E-09, 1.10910E-09, 1.05361E-09,
     1.18748E-09, 1.06583E-09, 1.06618E-09, 1.18518E-09},
    {4.46254E-10, 6.42725E-10, 8.84209E-10, 1.44681E-09, 1.80627E-09,
     2.60514E-09, 2.92070E-09, 3.04717E-09, 2.91751E-09, 2.69250E-09,
     2.14423E-09, 1.87833E-09, 1.41368E-09, 1.17671E-09, 1.06965E-09,
     9.15696E-10, 7.95193E-10, 7.93617E-10, 7.39363E-10, 7.33059E-10,
     8.41985E-10, 8.55167E-10, 1.01982E-09, 8.57116E-10, 9.53190E-10,
     1.17697E-09, 1.11009E-09, 1.11076E-09, 1.06799E-09, 1.14599E-09,
     1.03998E-09, 1.13934E-09, 1.14991E-09, 1.06814E-09},
    {3.68581E-10, 5.46710E-10, 9.55268E-10, 1.26843E-09, 2.00448E-09,
     2.29567E-09, 2.83680E-09, 3.14107E-09, 3.00047E-09, 2.77275E-09,
     2.67616E-09, 2.07368E-09, 1.81577E-09, 1.41313E-09, 1.14086E-09,
     1.00528E-09, 9.06059E-10, 7.93317E-10, 8.29726E-10, 8.36731E-10,
     7.30824E-10, 8.22358E-10, 8.27239E-10, 9.69237E-10, 9.09934E-10,
     7.87299E-10, 1.02084E-09, 1.01137E-09, 1.01241E-09, 9.98332E-10,
     9.99929E-10, 1.04567E-09, 1.10406E-09, 1.05842E-09},
    {3.30489E-10, 4.84400E-10, 6.54586E-10, 1.20352E-09, 1.55223E-09,
     2.12517E-09, 2.46194E-09, 2.68957E-09, 2.85067E-09, 2.95699E-09,
     2.56146E-09, 2.53360E-09, 2.03394E-09, 1.89406E-09, 1.49344E-09,
     1.21097E-09, 1.02182E-09, 9.54017E-10, 8.16645E-10, 7.05446E-10,
     7.96417E-10, 7.57601E-10, 8.13108E-10, 7.78722E-10, 8.84335E-10,
     9.33800E-10, 9.18426E-10, 8.59075E-10, 9.87024E-10, 9.46723E-10,
     9.74689E-10, 1.06424E-09, 1.06233E-09, 1.00252E-09},
    {3.15236E-10, 4.53445E-10, 6.12849E-10, 8.80661E-10, 1.29814E-09,
     1.83641E-09, 2.40809E-09, 2.84615E-09, 3.07830E-09, 3.06231E-09,
     3.02246E-09, 2.66317E-09, 2.45676E-09, 1.95837E-09, 1.75328E-09,
     1.51604E-09, 1.22919E-09, 1.08640E-09, 9.21142E-10, 9.14218E-10,
     7.88230E-10, 7.85290E-10, 7.70486E-10, 7.79057E-10, 7.66519E-10,
     8.93753E-10, 8.51927E-10, 9.11440E-10, 9.43173E-10, 9.76836E-10,
     1.03951E-09, 1.00428E-09, 9.00005E-10, 1.09773E-09},
    {2.94350E-10, 3.30673E-10, 5.14953E-10, 7.92361E-10, 1.09619E-09,
     1.54332E-09, 1.98010E-09, 2.43360E-09, 2.51901E-09, 2.89803E-09,
     2.92177E-09, 2.77013E-09, 2.60506E-09, 2.32751E-09, 2.08595E-09,
     1.70397E-09, 1.56794E-09, 1.32208E-09, 1.17802E-09, 1.05402E-09,
     9.06307E-10, 7.99624E-10, 7.42279E-10, 8.36660E-10, 8.00187E-10,
     7.60514E-10, 7.97608E-10, 8.38712E-10, 7.87295E-10, 8.24090E-10,
     9.52168E-10, 8.72726E-10, 9.80545E-10, 8.98433E-10},
    {2.71640E-10, 3.69277E-10, 4.08691E-10, 6.49086E-10, 9.75487E-10,
     1.32475E-09, 1.75031E-09, 2.18655E-09, 2.81225E-09, 2.88373E-09,
     3.00335E-09, 3.07205E-09, 2.78168E-09, 2.66746E-09, 2.35149E-09,
     2.21970E-09, 1.79642E-09, 1.56945E-09, 1.38233E-09, 1.15101E-09,
     1.08029E-09, 1.02728E-09, 9.20218E-10, 8.99322E-10, 8.44540E-10,
     7.82575E-10, 7.34401E-10, 7.62355E-10, 7.84198E-10, 8.34766E-10,
     7.53880E-10, 9.30411E-10, 7.97927E-10, 8.36549E-10},
    {2.67608E-10, 2.90246E-10, 4.26964E-10, 5.68480E-10, 7.25875E-10,
     1.14203E-09, 1.59533E-09, 1.98895E-09, 2.20298E-09, 2.73026E-09,
     2.88020E-09, 2.81677E-09, 2.83460E-09, 2.71577E-09, 2.50951E-09,
     2.29565E-09, 2.07982E-09, 1.84516E-09, 1.53127E-09, 1.44353E-09,
     1.32754E-09, 1.13701E-09, 9.84939E-10, 8.22831E-10, 8.82977E-10,
     8.58682E-10, 8.79561E-10, 8.24592E-10, 8.06855E-10, 8.19643E-10,
     7.91474E-10, 7.53336E-10, 8.26063E-10, 8.72056E-10},
    {2.76004E-10, 2.97848E-10, 3.69205E-10, 4.96156E-10, 6.70935E-10,
     9.85469E-10, 1.24946E-09, 1.69166E-09, 2.14889E-09, 2.25690E-09,
     2.66576E-09, 2.96308E-09, 3.01145E-09, 2.95100E-09, 2.79355E-09,
     2.56377E-09, 2.34815E-09, 2.23102E-09, 1.95989E-09, 1.68627E-09,
     1.53930E-09, 1.34761E-09, 1.09362E-09, 1.00787E-09, 1.03854E-09,
     9.24723E-10, 9.03981E-10, 9.38968E-10, 8.94900E-10, 8.05729E-10,
     8.08084E-10, 8.49896E-10, 8.52862E-10, 8.07341E-10},
    {2.56819E-10, 2.92117E-10, 2.84113E-10, 3.96933E-10, 5.36043E-10,
     7.44681E-10, 1.06722E-09, 1.43341E-09, 1.81100E-09, 2.43160E-09,
     2.61236E-09, 2.68949E-09, 2.72487E-09, 2.80718E-09, 2.78805E-09,
     2.75860E-09, 2.48446E-09, 2.48756E-09, 2.30664E-09, 1.94435E-09,
     1.79734E-09, 1.64660E-09, 1.51869E-09, 1.47596E-09, 1.25904E-09,
     9.88140E-10, 1.05975E-09, 9.44509E-10, 9.42660E-10, 8.52739E-10,
     8.99587E-10, 8.45836E-10, 8.07983E-10, 8.10073E-10},
    {2.68217E-10, 2.59533E-10, 3.24403E-10, 3.76349E-10, 4.92645E-10,
     7.37921E-10, 9.77341E-10, 1.23555E-09, 1.61183E-09, 1.81314E-09,
     2.17913E-09, 2.65205E-09, 2.93697E-09, 2.99129E-09, 3.00624E-09,
     2.84543E-09, 3.01798E-09, 2.53116E-09, 2.32740E-09, 2.33560E-09,
     2.14637E-09, 1.87810E-09, 1.79357E-09, 1.57354E-09, 1.44080E-09,
     1.39370E-09, 1.25080E-09, 1.03062E-09, 1.09373E-09, 9.44424E-10,
     9.69174E-10, 1.01173E-09, 8.30608E-10, 9.03310E-10},
    {2.53207E-10, 2.66823E-10, 2.81852E-10, 3.52605E-10, 4.07866E-10,
     5.45875E-10, 7.51003E-10, 1.13063E-09, 1.39539E-09, 1.75753E-09,
     2.10816E-09, 2.26655E-09, 2.42349E-09, 2.71147E-09, 2.78465E-09,
     2.90637E-09, 2.62953E-09, 2.78618E-09, 2.56300E-09, 2.24793E-09,
     2.27097E-09, 2.12163E-09, 1.89441E-09, 1.76714E-09, 1.69306E-09,
     1.76245E-09, 1.45822E-09, 1.33393E-09, 1.19024E-09, 1.08078E-09,
     1.07823E-09, 1.02602E-09, 1.03038E-09, 9.05749E-10},
    {2.54769E-10, 2.67563E-10, 2.72278E-10, 3.09167E-10, 3.87321E-10,
     4.94292E-10, 6.55215E-10, 7.89070E-10, 1.13511E-09, 1.46747E-09,
     1.71261E-09, 2.30814E-09, 2.50861E-09, 2.57222E-09, 2.79158E-09,
     2.78278E-09, 2.93348E-09, 2.91560E-09, 2.97274E-09, 2.70806E-09,
     2.51396E-09, 2.31157E-09, 2.09556E-09, 2.12984E-09, 1.97509E-09,
     1.64617E-09, 1.69549E-09, 1.72849E-09, 1.35765E-09, 1.32675E-09,
     1.30464E-09, 1.20930E-09, 1.13482E-09, 1.09305E-09},
    {2.52798E-10, 2.54011E-10, 2.72558E-10, 2.79948E-10, 3.33317E-10,
     4.24668E-10, 5.67261E-10, 7.91061E-10, 1.03697E-09, 1.27120E-09,
     1.71368E-09, 1.65662E-09, 2.13103E-09, 2.47838E-09, 2.59608E-09,
     2.79421E-09, 2.85227E-09, 2.72190E-09, 2.66529E-09, 2.72047E-09,
     2.70172E-09, 2.61996E-09, 2.46670E-09, 2.34715E-09, 2.06482E-09,
     1.98835E-09, 1.88596E-09, 1.70227E-09, 1.67377E-09, 1.55031E-09,
     1.56446E-09, 1.43837E-09, 1.18448E-09, 1.23883E-09},
    {2.47662E-10, 2.51919E-10, 2.71440E-10, 2.82234E-10, 3.05747E-10,
     3.97097E-10, 4.77670E-10, 6.34707E-10, 8.34109E-10, 1.05954E-09,
     1.20584E-09, 1.85291E-09, 1.96559E-09, 2.12200E-09, 2.40233E-09,
     2.62803E-09, 2.64126E-09, 2.94110E-09, 2.86334E-09, 2.70199E-09,
     2.93067E-09, 2.67043E-09, 2.51119E-09, 2.43790E-09, 2.47801E-09,
     2.47424E-09, 2.15774E-09, 1.83655E-09, 2.09257E-09, 1.91681E-09,
     1.65046E-09, 1.53039E-09, 1.59789E-09, 1.31246E-09},
    {2.50243E-10, 2.60356E-10, 2.49817E-10, 2.69364E-10, 3.19850E-10,
     3.31813E-10, 4.27812E-10, 5.49170E-10, 7.15630E-10, 9.45648E-10,
     1.30221E-09, 1.34867E-09, 1.64411E-09, 2.10848E-09, 2.33563E-09,
     2.36602E-09, 2.53963E-09, 2.60545E-09, 2.79634E-09, 2.98918E-09,
     2.85106E-09, 2.84525E-09, 2.90129E-09, 2.92964E-09, 2.44081E-09,
     2.33399E-09, 2.33628E-09, 2.29646E-09, 1.93045E-09, 1.93356E-09,
     1.80611E-09, 1.78937E-09, 1.99274E-09, 1.53096E-09},
    {2.50326E-10, 2.53094E-10, 2.68118E-10, 2.74745E-10, 2.71128E-10,
     3.20044E-10, 3.83590E-10, 4.64719E-10, 6.44239E-10, 7.50905E-10,
     8.84616E-10, 1.24062E-09, 1.56991E-09, 1.58733E-09, 1.88488E-09,
     2.24423E-09, 2.57952E-09, 2.70237E-09, 2.78033E-09, 2.63199E-09,
     2.81563E-09, 2.88171E-09, 2.73484E-09, 2.62242E-09, 2.51868E-09,
     2.68249E-09, 2.66286E-09, 2.61076E-09, 2.19834E-09, 2.32756E-09,
     2.25216E-09, 2.07967E-09, 1.95901E-09, 1.81803E-09},
    {2.52136E-10, 2.48065E-10, 2.45656E-10, 2.40491E-10, 2.67451E-10,
     3.11868E-10, 3.36063E-10, 4.45874E-10, 5.28989E-10, 6.98556E-10,
     9.55687E-10, 1.13192E-09, 1.22401E-09, 1.63388E-09, 1.90773E-09,
     1.97271E-09, 2.17300E-09, 2.32484E-09, 2.55808E-09, 2.79915E-09,
     2.74160E-09, 2.75915E-09, 2.75283E-09, 2.95652E-09, 3.04638E-09,
     2.63593E-09, 2.59315E-09, 2.59281E-09, 2.63693E-09, 2.56707E-09,
     2.38621E-09, 2.10749E-09, 2.25293E-09, 1.97036E-09},
    {2.54811E-10, 2.46553E-10, 2.56802E-10, 2.63730E-10, 2.74254E-10,
     2.80196E-10, 3.46073E-10, 3.59900E-10, 4.55797E-10, 5.68329E-10,
     6.72224E-10, 8.19415E-10, 1.19630E-09, 1.15719E-09, 1.51939E-09,
     1.81050E-09, 1.97949E-09, 2.25209E-09, 2.45483E-09, 2.49646E-09,
     2.75316E-09, 2.89870E-09, 3.00448E-09, 2.80118E-09, 2.58958E-09,
     2.87174E-09, 2.58121E-09, 2.74889E-09, 2.42190E-09, 2.47753E-09,
     2.48645E-09, 2.38708E-09, 2.46588E-09, 2.29244E-09},
    {2.50758E-10, 2.58326E-10, 2.46427E-10, 2.47681E-10, 2.48296E-10,
     2.72273E-10, 2.71674E-10, 3.50220E-10, 4.42224E-10, 5.12097E-10,
     6.42321E-10, 8.23974E-10, 9.29283E-10, 1.32906E-09, 1.44713E-09,
     1.58223E-09, 1.78259E-09, 2.05861E-09, 2.20544E-09, 2.35657E-09,
     2.35758E-09, 2.52486E-09, 2.57222E-09, 2.72018E-09, 2.99534E-09,
     2.97592E-09, 3.05014E-09, 2.75170E-09, 2.84222E-09, 2.82051E-09,
     2.70486E-09, 2.43053E-09, 2.21726E-09, 2.67884E-09},
    {2.55778E-10, 2.49411E-10, 2.48785E-10, 2.57783E-10, 2.78442E-10,
     2.71710E-10, 3.08420E-10, 3.21959E-10, 3.51831E-10, 4.45113E-10,
     5.49813E-10, 6.67440E-10, 8.12408E-10, 9.02516E-10, 1.08329E-09,
     1.32953E-09, 1.54241E-09, 1.80389E-09, 1.90890E-09, 2.16655E-09,
     2.44113E-09, 2.33078E-09, 2.58680E-09, 2.42855E-09, 2.41438E-09,
     2.48708E-09, 2.86715E-09, 2.95763E-09, 2.59557E-09, 2.78135E-09,
     2.60394E-09, 2.76642E-09, 2.60305E-09, 2.46156E-09},
    {2.53186E-10, 2.46935E-10, 2.49860E-10, 2.45992E-10, 2.45068E-10,
     2.63936E-10, 2.67545E-10, 2.99554E-10, 3.47481E-10, 4.09533E-10,
     4.67071E-10, 5.59642E-10, 7.30996E-10, 8.94659E-10, 1.08675E-09,
     1.27595E-09, 1.41104E-09, 1.72844E-09, 1.88526E-09, 1.91715E-09,
     2.03350E-09, 2.49755E-09, 2.39216E-09, 2.63457E-09, 2.54743E-09,
     2.95797E-09, 2.94107E-09, 2.73733E-09, 2.90854E-09, 2.94499E-09,
     2.49764E-09, 2.61526E-09, 2.80409E-09, 2.81107E-09},
    {2.45878E-10, 2.55167E-10, 2.59164E-10, 2.56299E-10, 2.53271E-10,
     2.60379E-10, 2.76558E-10, 2.76002E-10, 3.23980E-10, 3.68658E-10,
     4.38886E-10, 5.34310E-10, 5.91375E-10, 7.19265E-10, 8.97850E-10,
     1.00653E-09, 1.17459E-09, 1.44047E-09, 1.56320E-09, 1.87007E-09,
     2.05984E-09, 2.12346E-09, 2.41454E-09, 2.42024E-09, 2.43256E-09,
     2.50096E-09, 2.52320E-09, 2.66774E-09, 2.91815E-09, 2.76483E-09,
     2.82121E-09, 2.66899E-09, 2.76864E-09, 2.60703E-09},
    {2.52289E-10, 2.49160E-10, 2.48234E-10, 2.47094E-10, 2.56207E-10,
     2.45910E-10, 2.55750E-10, 2.76218E-10, 2.99756E-10, 3.23608E-10,
     3.85394E-10, 4.31942E-10, 5.33544E-10, 6.22262E-10, 7.22444E-10,
     9.73027E-10, 1.12419E-09, 1.20324E-09, 1.56314E-09, 1.62197E-09,
     1.64721E-09, 1.76671E-09, 1.78421E-09, 1.81727E-09, 2.14893E-09,
     2.23430E-09, 2.56473E-09, 2.37533E-09, 2.68630E-09, 2.76021E-09,
     2.85927E-09, 2.64976E-09, 2.61525E-09, 2.67874E-09},
    {2.47388E-10, 2.43494E-10, 2.52856E-10, 2.41326E-10, 2.48817E-10,
     2.60063E-10, 2.56001E-10, 2.59832E-10, 2.67330E-10, 3.25218E-10,
     3.39660E-10, 4.01511E-10, 4.91382E-10, 5.51341E-10, 7.73743E-10,
     7.68015E-10, 9.11843E-10, 1.10418E-09, 1.21004E-09, 1.37908E-09,
     1.43163E-09, 1.75528E-09, 1.74972E-09, 2.23683E-09, 2.13113E-09,
     2.60286E-09, 2.28420E-09, 2.43418E-09, 2.43395E-09, 2.78029E-09,
     2.84950E-09, 2.71962E-09, 2.78272E-09, 2.82019E-09},
    {2.55641E-10, 2.49076E-10, 2.47437E-10, 2.51513E-10, 2.35098E-10,
     2.32002E-10, 2.50381E-10, 2.67770E-10, 2.93169E-10, 2.69084E-10,
     3.22997E-10, 3.50495E-10, 4.27075E-10, 4.79549E-10, 5.97318E-10,
     6.39584E-10, 7.22696E-10, 9.45393E-10, 1.03601E-09, 1.26887E-09,
     1.53873E-09, 1.47300E-09, 1.74885E-09, 1.92097E-09, 2.04951E-09,
     2.16084E-09, 2.07807E-09, 2.37969E-09, 2.11135E-09, 2.48431E-09,
     2.09288E-09, 2.14636E-09, 2.54845E-09, 2.47195E-09},
    {2.38369E-10, 2.38385E-10, 2.54165E-10, 2.46575E-10, 2.48697E-10,
     2.52966E-10, 2.47022E-10, 2.57779E-10, 2.56304E-10, 2.87556E-10,
     3.06895E-10, 3.38503E-10, 3.85337E-10, 4.76767E-10, 4.98399E-10,
     5.68825E-10, 7.29926E-10, 7.78670E-10, 8.87084E-10, 1.08410E-09,
     1.24274E-09, 1.36452E-09, 1.40719E-09, 1.50772E-09, 1.73019E-09,
     1.82531E-09, 2.05629E-09, 2.16509E-09, 2.41075E-09, 2.20514E-09,
     2.48255E-09, 2.66912E-09, 2.53011E-09, 2.49723E-09},
    {2.56444E-10, 2.46894E-10, 2.42801E-10, 2.40116E-10, 2.48993E-10,
     2.49367E-10, 2.53211E-10, 2.51594E-10, 2.49336E-10, 2.76752E-10,
     2.90840E-10, 3.37651E-10, 3.42407E-10, 4.30563E-10, 4.73529E-10,
     5.34305E-10, 6.45535E-10, 8.12571E-10, 9.26950E-10, 1.03828E-09,
     1.12940E-09, 1.17386E-09, 1.34361E-09, 1.51875E-09, 1.48236E-09,
     1.79923E-09, 1.92056E-09, 1.92704E-09, 2.12810E-09, 2.06394E-09,
     2.35083E-09, 1.97886E-09, 2.43739E-09, 2.60215E-09},
    {2.51517E-10, 2.47756E-10, 2.42641E-10, 2.46464E-10, 2.49898E-10,
     2.48808E-10, 2.41029E-10, 2.47982E-10, 2.62917E-10, 2.83384E-10,
     2.97469E-10, 2.95605E-10, 3.45928E-10, 4.01344E-10, 4.15393E-10,
     4.99759E-10, 5.22237E-10, 6.87602E-10, 7.38360E-10, 7.55063E-10,
     9.75848E-10, 1.28015E-09, 1.24494E-09, 1.25486E-09, 1.45255E-09,
     1.49701E-09, 1.26863E-09, 1.65019E-09, 1.74075E-09, 2.05684E-09,
     2.08220E-09, 1.95669E-09, 2.08420E-09, 1.96806E-09},
    {2.52415E-10, 2.52781E-10, 2.54729E-10, 2.38275E-10, 2.40527E-10,
     2.42204E-10, 2.51832E-10, 2.49734E-10, 2.48858E-10, 2.65964E-10,
     2.77653E-10, 2.88246E-10, 2.99862E-10, 3.50800E-10, 4.15242E-10,
     4.43015E-10, 5.25384E-10, 6.20428E-10, 7.16144E-10, 7.25320E-10,
     7.32742E-10, 7.90066E-10, 1.03692E-09, 1.14297E-09, 1.18938E-09,
     1.46599E-09, 1.42003E-09, 1.54798E-09, 1.63728E-09, 1.79061E-09,
     1.94904E-09, 2.49033E-09, 2.22790E-09, 2.27789E-09},
    {2.56018E-10, 2.50079E-10, 2.42492E-10, 2.49290E-10, 2.46642E-10,
     2.44382E-10, 2.41773E-10, 2.48545E-10, 2.41593E-10, 2.53655E-10,
     2.75673E-10, 3.07985E-10, 3.00982E-10, 3.67455E-10, 3.85018E-10,
     4.60583E-10, 5.11175E-10, 5.21792E-10, 6.47649E-10, 6.70026E-10,
     8.80152E-10, 8.46277E-10, 9.06407E-10, 9.53508E-10, 1.24335E-09,
     1.32422E-09, 1.26975E-09, 1.43695E-09, 1.69215E-09, 1.56513E-09,
     1.79934E-09, 1.74498E-09, 1.80110E-09, 1.94153E-09},
    {2.43420E-10, 2.48713E-10, 2.50236E-10, 2.46341E-10, 2.47425E-10,
     2.53170E-10, 2.38452E-10, 2.47520E-10, 2.51086E-10, 2.67423E-10,
     2.66919E-10, 2.82416E-10, 3.25948E-10, 3.39030E-10, 3.41836E-10,
     3.73734E-10, 4.24751E-10, 4.45365E-10, 5.32441E-10, 5.86011E-10,
     6.44098E-10, 7.33318E-10, 9.80493E-10, 9.08036E-10, 8.92461E-10,
     1.14121E-09, 1.28168E-09, 1.40914E-09, 1.27372E-09, 1.66865E-09,
     1.59537E-09, 1.76124E-09, 1.88241E-09, 1.90433E-09},
    {2.63806E-10, 2.43932E-10, 2.55284E-10, 2.47117E-10, 2.56790E-10,
     2.45420E-10, 2.41893E-10, 2.52913E-10, 2.53240E-10, 2.53826E-10,
     2.51760E-10, 2.81095E-10, 2.69150E-10, 3.07148E-10, 3.14413E-10,
     3.53845E-10, 4.04780E-10, 4.88728E-10, 5.10531E-10, 5.40811E-10,
     5.82478E-10, 7.52078E-10, 7.94690E-10, 8.19652E-10, 8.96958E-10,
     9.86132E-10, 1.00664E-09, 1.06537E-09, 1.32222E-09, 1.18088E-09,
     1.12422E-09, 1.51979E-09, 1.56323E-09, 1.78348E-09},
    {2.42105E-10, 2.48938E-10, 2.31266E-10, 2.52072E-10, 2.38304E-10,
     2.51677E-10, 2.47345E-10, 2.43668E-10, 2.53330E-10, 2.55429E-10,
     2.71828E-10, 2.61253E-10, 2.93363E-10, 3.10415E-10, 3.83612E-10,
     3.75969E-10, 4.04960E-10, 4.84726E-10, 4.69473E-10, 5.31259E-10,
     6.10546E-10, 6.00087E-10, 6.67604E-10, 7.98719E-10, 8.62379E-10,
     8.46732E-10, 1.03390E-09, 9.73142E-10, 9.94333E-10, 1.25724E-09,
     1.30347E-09, 1.34935E-09, 1.17160E-09, 1.34383E-09},
    {2.49974E-10, 2.60961E-10, 2.53039E-10, 2.42603E-10, 2.39416E-10,
     2.51199E-10, 2.37682E-10, 2.48515E-10, 2.50846E-10, 2.62235E-10,
     2.62903E-10, 2.88593E-10, 3.16612E-10, 3.11073E-10, 2.73533E-10,
     3.62549E-10, 3.64813E-10, 3.63691E-10, 4.47957E-10, 4.05290E-10,
     5.68595E-10, 4.83778E-10, 6.04790E-10, 5.47902E-10, 7.22659E-10,
     8.37727E-10, 7.73909E-10, 9.15485E-10, 9.26622E-10, 1.10265E-09,
     9.27669E-10, 1.13401E-09, 1.18038E-09, 1.28634E-09},
    {2.53631E-10, 2.49000E-10, 2.40768E-10, 2.45224E-10, 2.49786E-10,
     2.44535E-10, 2.48846E-10, 2.41610E-10, 2.54707E-10, 2.38868E-10,
     2.74028E-10, 2.62087E-10, 2.62048E-10, 3.18410E-10, 3.29475E-10,
     3.70042E-10, 3.89491E-10, 4.02302E-10, 3.99026E-10, 4.46134E-10,
     4.41317E-10, 5.23496E-10, 6.51041E-10, 6.67070E-10, 6.11793E-10,
     7.48140E-10, 8.78111E-10, 7.55585E-10, 9.22412E-10, 9.15734E-10,
     9.84719E-10, 9.31572E-10, 1.23720E-09, 1.25275E-09},
    {2.57218E-10, 2.51372E-10, 2.55654E-10, 2.49380E-10, 2.50266E-10,
     2.50135E-10, 2.56369E-10, 2.45893E-10, 2.68547E-10, 2.51136E-10,
     2.44637E-10, 2.81089E-10, 2.97897E-10, 3.18041E-10, 3.19274E-10,
     3.18116E-10, 3.70621E-10, 3.96197E-10, 3.63440E-10, 4.32165E-10,
     4.86015E-10, 5.37115E-10, 4.81606E-10, 5.67634E-10, 6.02519E-10,
     6.34006E-10, 7.43270E-10, 7.52203E-10, 8.12977E-10, 9.46625E-10,
     9.47281E-10, 1.03670E-09, 7.56571E-10, 9.07722E-10},
    {2.54595E-10, 2.48908E-10, 2.46566E-10, 2.43576E-10, 2.47633E-10,
     2.48666E-10, 2.39800E-10, 2.44660E-10, 2.54305E-10, 2.43440E-10,
     2.59303E-10, 2.79536E-10, 2.87898E-10, 3.10530E-10, 3.34327E-10,
     3.51501E-10, 3.60456E-10, 3.84942E-10, 3.59607E-10, 4.83905E-10,
     4.01121E-10, 4.70105E-10, 5.00837E-10, 5.97030E-10, 4.39239E-10,
     6.27933E-10, 4.98290E-10, 6.29069E-10, 7.02135E-10, 7.21280E-10,
     6.75490E-10, 8.38614E-10, 9.72933E-10, 1.06534E-09},
    {2.57559E-10, 2.44769E-10, 2.52279E-10, 2.51432E-10, 2.52475E-10,
     2.59231E-10, 2.47164E-10, 2.67108E-10, 2.62533E-10, 2.50549E-10,
     2.85878E-10, 2.76166E-10, 2.85271E-10, 3.04353E-10, 3.11443E-10,
     3.32675E-10, 3.33555E-10, 3.42908E-10, 3.74563E-10, 3.77019E-10,
     5.08264E-10, 4.24935E-10, 5.54993E-10, 5.30514E-10, 4.85256E-10,
     5.70371E-10, 6.77137E-10, 5.97616E-10, 6.19710E-10, 6.70169E-10,
     7.78733E-10, 7.45103E-10, 8.46297E-10, 9.78324E-10},
    {2.56606E-10, 2.51861E-10, 2.48154E-10, 2.43781E-10, 2.47066E-10,
     2.45552E-10, 2.39746E-10, 2.38914E-10, 2.64801E-10, 2.66948E-10,
     2.59754E-10, 3.02660E-10, 3.12369E-10, 3.30554E-10, 3.32282E-10,
     3.03905E-10, 3.76526E-10, 3.38766E-10, 4.26784E-10, 4.36076E-10,
     3.99450E-10, 3.65859E-10, 4.47140E-10, 4.14101E-10, 5.21598E-10,
     4.84300E-10, 5.87291E-10, 5.92669E-10, 5.45666E-10, 6.77083E-10,
     6.75410E-10, 6.90343E-10, 6.23257E-10, 8.61994E-10},
    {2.54176E-10, 2.49469E-10, 2.45351E-10, 2.48464E-10, 2.43574E-10,
     2.47906E-10, 2.54182E-10, 2.82489E-10, 2.70531E-10, 2.65627E-10,
     2.91695E-10, 2.92008E-10, 2.92402E-10, 3.12113E-10, 3.32130E-10,
     3.41278E-10, 3.66503E-10, 3.34304E-10, 4.14062E-10, 3.63950E-10,
     4.84597E-10, 4.17494E-10, 4.51947E-10, 4.10923E-10, 4.31600E-10,
     5.13396E-10, 4.85963E-10, 4.80199E-10, 5.46883E-10, 5.88761E-10,
     7.03597E-10, 6.64720E-10, 6.82503E-10, 7.23030E-10},
    {2.49477E-10, 2.59382E-10, 2.54698E-10, 2.38030E-10, 2.39936E-10,
     2.49124E-10, 2.60101E-10, 2.75667E-10, 2.62741E-10, 2.68656E-10,
     2.56532E-10, 3.07798E-10, 2.88010E-10, 3.45180E-10, 3.27682E-10,
     3.11122E-10, 3.38979E-10, 3.53826E-10, 3.60016E-10, 3.54827E-10,
     4.48602E-10, 4.18563E-10, 3.85422E-10, 4.78835E-10, 4.42912E-10,
     4.11883E-10, 4.47011E-10, 4.70613E-10, 5.68565E-10, 5.37497E-10,
     4.95663E-10, 5.78841E-10, 6.17311E-10, 6.92761E-10},
    {2.53598E-10, 2.46479E-10, 2.50373E-10, 2.57332E-10, 2.45707E-10,
     2.47218E-10, 2.56361E-10, 2.58412E-10, 2.67545E-10, 2.83197E-10,
     2.90960E-10, 3.36913E-10, 3.00175E-10, 3.18079E-10, 3.60795E-10,
     3.81531E-10, 3.67421E-10, 3.74602E-10, 3.76606E-10, 3.78484E-10,
     3.64704E-10, 3.81573E-10, 3.66015E-10, 4.18042E-10, 3.42634E-10,
     3.59969E-10, 4.10640E-10, 4.17218E-10, 5.16006E-10, 5.40622E-10,
     5.11386E-10, 4.78418E-10, 5.48661E-10, 5.25483E-10},
    {2.52401E-10, 2.49449E-10, 2.47483E-10, 2.40555E-10, 2.62858E-10,
     2.53986E-10, 2.54307E-10, 2.64395E-10, 2.64325E-10, 2.70832E-10,
     2.95345E-10, 2.88455E-10, 3.15238E-10, 2.65348E-10, 3.63453E-10,
     3.81305E-10, 3.60944E-10, 3.50975E-10, 3.80220E-10, 3.79675E-10,
     3.57284E-10, 3.90746E-10, 3.84172E-10, 3.79170E-10, 4.01098E-10,
     4.62155E-10, 4.46054E-10, 4.19135E-10, 4.48224E-10, 4.95535E-10,
     4.38270E-10, 4.57796E-10, 4.80603E-10, 4.75973E-10},
    {2.53712E-10, 2.50563E-10, 2.49466E-10, 2.59408E-10, 2.48370E-10,
     2.46613E-10, 2.45300E-10, 2.51674E-10, 2.72257E-10, 3.04716E-10,
     3.12751E-10, 3.09160E-10, 3.26553E-10, 3.58494E-10, 3.59824E-10,
     3.77350E-10, 3.54843E-10, 3.81426E-10, 3.25103E-10, 3.97229E-10,
     3.66321E-10, 3.88514E-10, 3.78749E-10, 3.75002E-10, 3.88857E-10,
     4.07786E-10, 4.06120E-10, 4.04871E-10, 4.25736E-10, 3.80374E-10,
     4.34152E-10, 4.47645E-10, 4.76025E-10, 5.07456E-10},
    {2.49680E-10, 2.49290E-10, 2.55244E-10, 2.52962E-10, 2.53659E-10,
     2.54976E-10, 2.46900E-10, 2.67832E-10, 2.87205E-10, 2.87431E-10,
     3.24050E-10, 3.01860E-10, 3.51160E-10, 3.68827E-10, 3.72519E-10,
     3.58531E-10, 3.77172E-10, 3.73221E-10, 3.65114E-10, 3.86012E-10,
     3.67021E-10, 4.48333E-10, 3.66702E-10, 3.74709E-10, 3.60373E-10,
     3.87140E-10, 3.58241E-10, 3.55686E-10, 3.86524E-10, 3.99988E-10,
     4.34776E-10, 4.17995E-10, 3.86225E-10, 4.10470E-10},
    {2.46495E-10, 2.57158E-10, 2.55002E-10, 2.46784E-10, 2.37489E-10,
     2.47844E-10, 2.73978E-10, 2.59631E-10, 2.53421E-10, 2.72125E-10,
     3.29734E-10, 3.58676E-10, 3.45747E-10, 3.42996E-10, 3.46039E-10,
     3.41152E-10, 3.50140E-10, 3.46083E-10, 3.94465E-10, 3.92346E-10,
     3.62426E-10, 3.98499E-10, 3.73425E-10, 3.62454E-10, 3.39445E-10,
     3.42215E-10, 3.75216E-10, 3.41080E-10, 3.48804E-10, 3.64784E-10,
     3.45338E-10, 3.82674E-10, 4.20317E-10, 4.17825E-10},
    {2.61142E-10, 2.53809E-10, 2.51022E-10, 2.51623E-10, 2.53936E-10,
     2.64138E-10, 2.44124E-10, 2.77716E-10, 2.62374E-10, 3.05066E-10,
     3.07825E-10, 3.16990E-10, 3.60695E-10, 3.39674E-10, 4.01382E-10,
     3.74876E-10, 3.96200E-10, 3.61183E-10, 4.03483E-10, 4.06235E-10,
     3.85568E-10, 3.55819E-10, 3.61177E-10, 3.70488E-10, 3.43919E-10,
     3.48759E-10, 3.52045E-10, 3.66280E-10, 3.43284E-10, 3.21389E-10,
     3.52736E-10, 3.74312E-10, 3.87074E-10, 4.05271E-10},
    {2.48288E-10, 2.50566E-10, 2.53199E-10, 2.45563E-10, 2.48551E-10,
     2.46219E-10, 2.50947E-10, 2.89011E-10, 2.70953E-10, 3.38242E-10,
     3.21905E-10, 3.28466E-10, 3.45751E-10, 3.83146E-10, 3.51078E-10,
     3.63596E-10, 3.66190E-10, 3.75394E-10, 3.61933E-10, 3.79267E-10,
     3.43338E-10, 3.61359E-10, 3.34987E-10, 3.41410E-10, 3.47037E-10,
     3.17270E-10, 3.44511E-10, 3.55014E-10, 3.63906E-10, 3.15837E-10,
     4.07448E-10, 3.67070E-10, 3.68994E-10, 3.38480E-10},
    {2.61165E-10, 2.40589E-10, 2.51198E-10, 2.45563E-10, 2.55953E-10,
     2.55700E-10, 2.66993E-10, 2.84273E-10, 2.89406E-10, 2.83510E-10,
     3.05936E-10, 3.45219E-10, 3.44317E-10, 3.57275E-10, 3.74027E-10,
     3.40050E-10, 3.78643E-10, 3.57453E-10, 3.56389E-10, 3.61077E-10,
     3.48082E-10, 3.29925E-10, 3.47062E-10, 3.21761E-10, 3.27079E-10,
     3.44865E-10, 3.36988E-10, 3.35824E-10, 3.22650E-10, 3.39161E-10,
     3.28631E-10, 3.21356E-10, 3.60341E-10, 3.48658E-10},
    {2.54214E-10, 2.59290E-10, 2.47454E-10, 2.53295E-10, 2.50724E-10,
     2.67028E-10, 2.79959E-10, 2.65588E-10, 3.03208E-10, 3.22651E-10,
     3.32138E-10, 3.37867E-10, 3.32523E-10, 4.02624E-10, 3.67530E-10,
     3.72085E-10, 3.53276E-10, 3.91081E-10, 3.36419E-10, 3.82616E-10,
     3.59360E-10, 3.26030E-10, 3.41517E-10, 3.07308E-10, 3.39551E-10,
     3.28052E-10, 3.11851E-10, 3.11751E-10, 3.06892E-10, 3.22257E-10,
     3.04298E-10, 3.17756E-10, 3.31357E-10, 3.21436E-10},
    {2.56353E-10, 2.56991E-10, 2.54553E-10, 2.54549E-10, 2.48976E-10,
     2.45328E-10, 2.50764E-10, 2.96405E-10, 2.62702E-10, 3.44377E-10,
     3.35760E-10, 2.97078E-10, 3.70065E-10, 3.65757E-10, 3.68815E-10,
     3.50737E-10, 3.92584E-10, 3.81617E-10, 3.40477E-10, 3.76570E-10,
     3.26481E-10, 3.43975E-10, 3.46301E-10, 3.05572E-10, 3.18643E-10,
     3.06129E-10, 3.17510E-10, 3.10969E-10, 3.08417E-10, 3.02304E-10,
     3.05390E-10, 3.11774E-10, 3.08456E-10, 2.98156E-10},
    {2.57938E-10, 2.56389E-10, 2.51132E-10, 2.66649E-10, 2.58851E-10,
     2.78710E-10, 3.00764E-10, 2.86935E-10, 3.13531E-10, 3.18008E-10,
     3.03565E-10, 3.83037E-10, 3.64298E-10, 3.80932E-10, 3.83857E-10,
     3.79391E-10, 3.93257E-10, 3.99084E-10, 3.26806E-10, 3.67499E-10,
     3.41897E-10, 3.41656E-10, 3.24558E-10, 3.09142E-10, 3.04337E-10,
     3.04670E-10, 3.13192E-10, 2.90872E-10, 2.95796E-10, 2.87862E-10,
     2.83598E-10, 2.98271E-10, 3.00482E-10, 2.99272E-10},
    {2.68387E-10, 2.44737E-10, 2.55989E-10, 2.58730E-10, 2.65183E-10,
     2.65684E-10, 2.83067E-10, 2.77343E-10, 3.03004E-10, 3.49475E-10,
     3.56275E-10, 3.41669E-10, 4.19261E-10, 3.83704E-10, 3.65061E-10,
     4.08845E-10, 3.87076E-10, 3.38376E-10, 3.67482E-10, 3.34738E-10,
     3.22850E-10, 3.33987E-10, 3.00518E-10, 3.01171E-10, 3.03895E-10,
     3.12162E-10, 2.95794E-10, 3.02380E-10, 2.91804E-10, 3.16326E-10,
     2.92342E-10, 2.96280E-10, 2.90379E-10, 2.93552E-10},
    {2.56035E-10, 2.64791E-10, 2.52386E-10, 2.63604E-10, 2.66728E-10,
     2.90390E-10, 2.89063E-10, 2.88735E-10, 3.25525E-10, 3.24042E-10,
     3.56545E-10, 3.32050E-10, 3.49664E-10, 3.94671E-10, 4.07331E-10,
     3.96035E-10, 3.80850E-10, 3.48349E-10, 3.53591E-10, 3.49217E-10,
     3.32984E-10, 3.17335E-10, 2.85350E-10, 3.15802E-10, 2.78304E-10,
     2.86733E-10, 2.95474E-10, 2.70022E-10, 2.73941E-10, 2.91315E-10,
     2.79835E-10, 3.01391E-10, 2.77783E-10, 3.02084E-10},
    {2.58844E-10, 2.43158E-10, 2.52879E-10, 2.58503E-10, 2.63378E-10,
     2.91383E-10, 2.94948E-10, 3.24503E-10, 3.36424E-10, 3.41649E-10,
     3.55034E-10, 3.56340E-10, 3.93657E-10, 3.80419E-10, 3.77923E-10,
     3.90397E-10, 3.55561E-10, 3.47083E-10, 3.17329E-10, 3.37855E-10,
     3.21660E-10, 3.21127E-10, 3.03285E-10, 3.13970E-10, 2.91779E-10,
     2.95708E-10, 2.93833E-10, 2.86966E-10, 2.83999E-10, 2.80883E-10,
     2.67809E-10, 2.96463E-10, 2.70703E-10, 2.75855E-10},
    {2.58495E-10, 2.52538E-10, 2.55936E-10, 2.49743E-10, 2.63800E-10,
     2.68632E-10, 2.59526E-10, 3.14057E-10, 3.31433E-10, 3.24325E-10,
     3.34252E-10, 3.77638E-10, 3.73841E-10, 3.93756E-10, 3.53855E-10,
     3.62389E-10, 3.86978E-10, 3.58422E-10, 3.26495E-10, 3.29187E-10,
     3.19425E-10, 3.22117E-10, 3.10603E-10, 2.91316E-10, 2.72778E-10,
     2.80638E-10, 2.80675E-10, 2.75909E-10, 2.78184E-10, 2.88372E-10,
     2.63197E-10, 2.73922E-10, 2.42169E-10, 2.44480E-10},
    {2.64065E-10, 2.65267E-10, 2.74799E-10, 2.52399E-10, 2.82593E-10,
     2.92006E-10, 2.93310E-10, 3.31187E-10, 3.69066E-10, 3.47777E-10,
     3.81252E-10, 3.47097E-10, 3.57105E-10, 3.96886E-10, 4.03581E-10,
     3.56156E-10, 3.52085E-10, 3.46677E-10, 3.43949E-10, 3.37786E-10,
     2.95421E-10, 2.99429E-10, 3.02461E-10, 2.96576E-10, 2.71432E-10,
     2.74156E-10, 2.69905E-10, 2.65979E-10, 2.80612E-10, 2.77350E-10,
     2.82782E-10, 2.68368E-10, 2.62947E-10, 2.68964E-10},
    {2.55880E-10, 2.54477E-10, 2.58364E-10, 2.69401E-10, 2.68007E-10,
     2.69315E-10, 2.70843E-10, 3.28088E-10, 3.24369E-10, 3.56370E-10,
     3.87850E-10, 3.66815E-10, 4.01533E-10, 3.77715E-10, 3.47462E-10,
     3.57037E-10, 3.49069E-10, 3.30483E-10, 3.20197E-10, 3.16239E-10,
     2.97105E-10, 3.03182E-10, 2.82840E-10, 3.01680E-10, 2.80407E-10,
     2.69252E-10, 2.79085E-10, 2.80396E-10, 2.75670E-10, 2.77868E-10,
     2.68094E-10, 2.68842E-10, 2.69335E-10, 2.80456E-10},
    {2.66871E-10, 2.58717E-10, 2.54591E-10, 2.74756E-10, 2.67893E-10,
     2.81067E-10, 3.08177E-10, 3.36230E-10, 3.54625E-10, 3.37988E-10,
     3.49651E-10, 4.09847E-10, 3.75019E-10, 3.73516E-10, 3.68395E-10,
     3.49386E-10, 3.48523E-10, 3.24241E-10, 3.14465E-10, 3.16943E-10,
     3.06154E-10, 3.15598E-10, 2.91260E-10, 2.89114E-10, 2.75973E-10,
     2.82346E-10, 2.83503E-10, 2.69520E-10, 2.66484E-10, 2.67946E-10,
     2.58906E-10, 2.75525E-10, 2.85049E-10, 2.54669E-10},
    {2.64873E-10, 2.63186E-10, 2.55574E-10, 2.78426E-10, 2.64372E-10,
     2.75704E-10, 3.21823E-10, 3.34482E-10, 3.72010E-10, 3.84888E-10,
     3.92715E-10, 4.00566E-10, 3.81794E-10, 3.79466E-10, 3.49950E-10,
     3.72216E-10, 3.39358E-10, 3.31755E-10, 2.99763E-10, 3.13840E-10,
     2.99658E-10, 2.93808E-10, 2.84907E-10, 2.67419E-10, 2.87896E-10,
     2.79799E-10, 2.76319E-10, 2.71102E-10, 2.57862E-10, 2.76862E-10,
     2.73513E-10, 2.72579E-10, 2.71040E-10, 2.68611E-10},
    {2.56255E-10, 2.54705E-10, 2.47685E-10, 2.74119E-10, 2.99843E-10,
     2.91086E-10, 3.59859E-10, 3.44905E-10, 3.62833E-10, 3.53651E-10,
     4.01242E-10, 3.45267E-10, 3.99478E-10, 3.50364E-10, 2.82997E-10,
     3.41645E-10, 3.51602E-10, 2.83322E-10, 3.02473E-10, 2.99372E-10,
     2.94087E-10, 2.88992E-10, 2.72981E-10, 2.77269E-10, 2.73422E-10,
     2.69471E-10, 2.77543E-10, 2.64105E-10, 2.59170E-10, 2.63956E-10,
     2.57717E-10, 2.65875E-10, 2.61554E-10, 2.78333E-10},
    {2.63635E-10, 2.48623E-10, 2.64333E-10, 2.89073E-10, 2.85222E-10,
     2.85792E-10, 2.95830E-10, 3.71532E-10, 3.72669E-10, 4.35570E-10,
     3.62171E-10, 4.00796E-10, 3.75679E-10, 3.56042E-10, 3.59866E-10,
     3.27427E-10, 3.48107E-10, 3.18399E-10, 3.14291E-10, 3.02730E-10,
     3.02832E-10, 2.94095E-10, 2.93404E-10, 2.71084E-10, 2.78052E-10,
     2.71150E-10, 2.75883E-10, 2.58104E-10, 2.81456E-10, 2.43734E-10,
     2.53119E-10, 2.67469E-10, 2.51898E-10, 2.60268E-10},
    {2.66769E-10, 2.65106E-10, 2.72895E-10, 2.72268E-10, 2.68504E-10,
     3.18115E-10, 3.54763E-10, 3.34726E-10, 3.56238E-10, 4.10293E-10,
     4.07895E-10, 3.76104E-10, 3.84273E-10, 3.36074E-10, 3.61957E-10,
     3.40925E-10, 2.98585E-10, 3.10906E-10, 3.19821E-10, 3.08497E-10,
     2.97505E-10, 2.84315E-10, 2.66614E-10, 2.78488E-10, 2.71689E-10,
     2.98096E-10, 2.67173E-10, 2.62323E-10, 2.90557E-10, 2.51899E-10,
     2.41525E-10, 2.72377E-10, 2.68759E-10, 2.55243E-10},
    {2.49077E-10, 2.66249E-10, 2.62753E-10, 2.79687E-10, 2.96645E-10,
     3.38409E-10, 3.43733E-10, 3.82951E-10, 4.07257E-10, 4.24403E-10,
     3.60250E-10, 3.65288E-10, 3.68892E-10, 3.53777E-10, 3.66788E-10,
     3.20258E-10, 3.19987E-10, 3.12829E-10, 2.92236E-10, 2.91815E-10,
     2.84231E-10, 2.85740E-10, 2.66758E-10, 2.73416E-10, 2.88642E-10,
     2.78546E-10, 2.74747E-10, 2.39296E-10, 2.75233E-10, 2.66330E-10,
     2.27936E-10, 2.81370E-10, 2.78269E-10, 2.57035E-10},
    {2.68971E-10, 2.73874E-10, 2.71299E-10, 2.88229E-10, 2.92961E-10,
     2.93420E-10, 3.26370E-10, 3.46987E-10, 3.93097E-10, 3.76345E-10,
     4.29506E-10, 3.73804E-10, 3.89585E-10, 3.40357E-10, 3.24443E-10,
     3.29052E-10, 3.27303E-10, 2.96327E-10, 2.89817E-10, 2.86075E-10,
     2.64087E-10, 2.77478E-10, 2.74944E-10, 2.72995E-10, 2.71529E-10,
     2.82348E-10, 2.71637E-10, 2.48348E-10, 2.62036E-10, 2.64250E-10,
     2.63596E-10, 2.82061E-10, 2.69609E-10, 2.52188E-10},
    {2.63834E-10, 2.74028E-10, 2.82642E-10, 2.99477E-10, 3.51074E-10,
     3.43677E-10, 3.44732E-10, 3.55603E-10, 3.92940E-10, 3.93191E-10,
     3.99561E-10, 4.02167E-10, 3.64962E-10, 3.45576E-10, 3.28759E-10,
     3.14492E-10, 3.03894E-10, 3.02681E-10, 2.88552E-10, 2.80674E-10,
     2.64560E-10, 2.72179E-10, 2.62605E-10, 2.56365E-10, 2.82682E-10,
     2.70779E-10, 2.78151E-10, 2.55983E-10, 2.60257E-10, 2.62642E-10,
     2.59753E-10, 2.76654E-10, 2.69687E-10, 2.55705E-10},
    {2.59452E-10, 2.48778E-10, 2.71635E-10, 2.91849E-10, 3.33965E-10,
     3.65860E-10, 3.33813E-10, 3.84669E-10, 3.83093E-10, 3.87526E-10,
     3.71030E-10, 3.46481E-10, 3.27772E-10, 3.29690E-10, 3.21198E-10,
     3.16900E-10, 3.03971E-10, 2.96413E-10, 2.66742E-10, 2.78443E-10,
     2.77372E-10, 2.67471E-10, 2.63496E-10, 2.54705E-10, 2.69351E-10,
     2.72591E-10, 2.71103E-10, 2.60617E-10, 2.64017E-10, 2.55533E-10,
     2.68208E-10, 2.61909E-10, 2.56241E-10, 2.60163E-10},
    {2.68277E-10, 2.52500E-10, 2.96455E-10, 3.09489E-10, 3.03946E-10,
     3.50495E-10, 3.60028E-10, 4.04237E-10, 3.42918E-10, 3.90109E-10,
     3.70842E-10, 3.95124E-10, 3.22631E-10, 3.37586E-10, 3.24927E-10,
     3.06546E-10, 2.92714E-10, 2.75920E-10, 2.67988E-10, 2.77880E-10,
     2.67932E-10, 2.65721E-10, 2.65729E-10, 2.49235E-10, 2.71081E-10,
     2.67749E-10, 2.69094E-10, 2.70535E-10, 2.52645E-10, 2.66091E-10,
     2.76296E-10, 2.61508E-10, 2.55428E-10, 2.67206E-10},
    {2.71112E-10, 2.67482E-10, 2.84316E-10, 3.09146E-10, 3.22025E-10,
     3.44271E-10, 3.81909E-10, 3.92956E-10, 3.99032E-10, 3.95957E-10,
     4.03822E-10, 3.70030E-10, 3.38782E-10, 3.35100E-10, 3.12976E-10,
     3.07515E-10, 2.97001E-10, 2.98005E-10, 2.71289E-10, 2.71291E-10,
     2.77605E-10, 2.81516E-10, 2.49735E-10, 2.63947E-10, 2.72275E-10,
     2.83479E-10, 2.72673E-10, 2.50300E-10, 2.63930E-10, 2.71131E-10,
     2.53831E-10, 2.65611E-10, 2.63392E-10, 2.79558E-10},
    {2.66785E-10, 2.81290E-10, 2.77453E-10, 3.05844E-10, 3.68125E-10,
     3.70801E-10, 3.99001E-10, 3.77164E-10, 3.74593E-10, 3.84310E-10,
     3.88641E-10, 3.50018E-10, 3.48217E-10, 3.22475E-10, 3.06933E-10,
     2.95155E-10, 2.86331E-10, 2.87530E-10, 2.65572E-10, 2.76298E-10,
     2.71562E-10, 2.65710E-10, 2.70534E-10, 2.72071E-10, 2.73893E-10,
     2.63514E-10, 2.70573E-10, 2.61943E-10, 2.67491E-10, 2.60664E-10,
     2.66638E-10, 2.55184E-10, 2.64112E-10, 2.61320E-10},
    {2.84302E-10, 3.02033E-10, 2.74023E-10, 3.05244E-10, 3.39002E-10,
     3.88993E-10, 3.38231E-10, 3.97308E-10, 4.31066E-10, 3.97497E-10,
     3.42118E-10, 3.65987E-10, 3.28309E-10, 3.34172E-10, 3.12953E-10,
     2.90125E-10, 2.65448E-10, 2.80850E-10, 2.87295E-10, 2.64454E-10,
     2.62259E-10, 2.84975E-10, 2.62731E-10, 2.72190E-10, 2.75337E-10,
     2.63843E-10, 2.67055E-10, 2.55068E-10, 2.68682E-10, 2.46429E-10,
     2.67552E-10, 2.59040E-10, 2.75895E-10, 2.48137E-10},
    {2.66873E-10, 2.75785E-10, 2.86877E-10, 3.24315E-10, 3.54559E-10,
     3.86278E-10, 4.37789E-10, 3.74030E-10, 3.71371E-10, 3.96301E-10,
     3.76735E-10, 3.55831E-10, 3.38622E-10, 3.06582E-10, 2.94842E-10,
     3.01827E-10, 2.91448E-10, 2.71574E-10, 2.67608E-10, 2.54297E-10,
     2.62697E-10, 2.60977E-10, 2.68951E-10, 2.73537E-10, 2.86430E-10,
     2.64064E-10, 2.66818E-10, 2.66651E-10, 2.76967E-10, 2.63857E-10,
     2.55511E-10, 2.60029E-10, 2.62036E-10, 2.58528E-10},
    {2.71106E-10, 2.77643E-10, 3.03820E-10, 3.46203E-10, 3.47971E-10,
     3.61379E-10, 3.80089E-10, 4.22050E-10, 3.84632E-10, 3.72179E-10,
     3.46506E-10, 3.46470E-10, 3.16099E-10, 3.06439E-10, 2.97987E-10,
     2.74135E-10, 2.81839E-10, 2.43622E-10, 2.69759E-10, 2.55105E-10,
     2.72080E-10, 2.84748E-10, 2.66019E-10, 2.82745E-10, 2.89791E-10,
     2.71342E-10, 2.75082E-10, 2.72418E-10, 2.89944E-10, 2.71524E-10,
     2.60940E-10, 2.74284E-10, 2.56979E-10, 2.68002E-10},
    {2.85022E-10, 3.03981E-10, 3.12784E-10, 3.25274E-10, 3.38668E-10,
     3.49272E-10, 3.92958E-10, 4.13832E-10, 3.64759E-10, 3.57744E-10,
     3.41994E-10, 3.03000E-10, 3.31905E-10, 2.76073E-10, 2.77009E-10,
     2.82647E-10, 2.75153E-10, 2.82303E-10, 2.58036E-10, 2.68392E-10,
     2.81273E-10, 2.88469E-10, 2.68656E-10, 2.75713E-10, 2.65914E-10,
     2.76365E-10, 2.74449E-10, 2.71656E-10, 2.90797E-10, 2.65502E-10,
     2.37295E-10, 2.70758E-10, 2.69641E-10, 2.57380E-10},
    {2.69214E-10, 2.86926E-10, 2.99917E-10, 3.32312E-10, 3.71820E-10,
     3.89722E-10, 3.99708E-10, 4.09681E-10, 3.75971E-10, 3.89809E-10,
     3.40614E-10, 3.20509E-10, 2.93429E-10, 2.92395E-10, 2.88482E-10,
     2.86186E-10, 2.61775E-10, 2.79031E-10, 2.76119E-10, 2.73581E-10,
     2.66367E-10, 2.83950E-10, 2.66599E-10, 2.69078E-10, 2.86334E-10,
     2.74668E-10, 2.78342E-10, 2.76063E-10, 2.76396E-10, 2.50280E-10,
     2.57892E-10, 2.60942E-10, 2.54511E-10, 2.55198E-10},
    {2.78405E-10, 2.96843E-10, 3.35056E-10, 3.71369E-10, 3.35800E-10,
     3.86913E-10, 3.94067E-10, 3.68234E-10, 3.77412E-10, 3.61826E-10,
     3.04909E-10, 3.15497E-10, 3.08413E-10, 2.83973E-10, 2.74642E-10,
     2.70135E-10, 2.60743E-10, 2.67633E-10, 2.51530E-10, 2.64429E-10,
     2.81432E-10, 2.71998E-10, 2.78325E-10, 2.67287E-10, 3.00782E-10,
     2.75379E-10, 2.74105E-10, 2.79055E-10, 2.73318E-10, 2.53227E-10,
     2.68623E-10, 2.61598E-10, 2.63980E-10, 2.60809E-10},
    {2.77038E-10, 3.00240E-10, 3.44915E-10, 3.27971E-10, 3.95442E-10,
     4.17253E-10, 3.71801E-10, 3.64669E-10, 3.40491E-10, 3.54972E-10,
     3.31744E-10, 3.26884E-10, 2.96076E-10, 2.76918E-10, 2.79787E-10,
     2.78500E-10, 2.69122E-10, 2.82903E-10, 2.67980E-10, 2.58925E-10,
     2.76068E-10, 2.87803E-10, 2.86193E-10, 2.66873E-10, 2.81505E-10,
     2.81627E-10, 2.74743E-10, 2.74278E-10, 2.71157E-10, 2.62083E-10,
     2.72226E-10, 2.72954E-10, 2.62913E-10, 2.56655E-10},
    {2.87612E-10, 3.02915E-10, 3.60404E-10, 3.82710E-10, 3.75356E-10,
     4.00390E-10, 3.66542E-10, 4.07882E-10, 3.59166E-10, 3.34278E-10,
     3.18584E-10, 3.23850E-10, 3.02589E-10, 2.76619E-10, 2.91802E-10,
     2.77531E-10, 2.72992E-10, 2.64503E-10, 2.74289E-10, 2.60066E-10,
     2.70620E-10, 2.70542E-10, 2.79849E-10, 2.54812E-10, 2.76704E-10,
     2.72341E-10, 2.74002E-10, 2.66597E-10, 2.72615E-10, 2.62320E-10,
     2.67078E-10, 2.66857E-10, 2.71324E-10, 2.65423E-10},
    {2.88175E-10, 3.13142E-10, 3.45278E-10, 3.72905E-10, 3.40626E-10,
     4.11922E-10, 3.90508E-10, 3.46288E-10, 3.49380E-10, 3.48399E-10,
     3.26736E-10, 2.81396E-10, 3.05790E-10, 2.85047E-10, 2.66217E-10,
     2.62913E-10, 2.64372E-10, 2.85151E-10, 2.81296E-10, 2.68381E-10,
     2.72091E-10, 2.86316E-10, 2.83414E-10, 2.65129E-10, 2.81659E-10,
     2.53043E-10, 2.83997E-10, 2.73623E-10, 2.82636E-10, 2.69437E-10,
     2.75913E-10, 2.64553E-10, 2.55461E-10, 2.69091E-10},
    {2.92754E-10, 2.97878E-10, 3.63060E-10, 4.34143E-10, 3.98806E-10,
     4.36776E-10, 3.95574E-10, 3.99909E-10, 3.59803E-10, 3.53425E-10,
     3.20889E-10, 3.07130E-10, 2.78647E-10, 2.91042E-10, 2.78863E-10,
     2.88714E-10, 2.78976E-10, 2.80578E-10, 2.94932E-10, 2.85430E-10,
     2.55504E-10, 2.70447E-10, 2.64898E-10, 2.64430E-10, 2.81055E-10,
     2.82201E-10, 2.54486E-10, 2.81014E-10, 2.71884E-10, 2.58723E-10,
     2.65174E-10, 2.81694E-10, 2.54468E-10, 2.47155E-10},
    {2.79383E-10, 3.35704E-10, 3.26270E-10, 3.69774E-10, 4.01558E-10,
     4.01910E-10, 3.61843E-10, 3.64874E-10, 3.46458E-10, 3.23999E-10,
     3.06934E-10, 2.98402E-10, 2.75983E-10, 2.66719E-10, 2.72856E-10,
     2.67913E-10, 2.65942E-10, 2.70451E-10, 2.78894E-10, 2.72299E-10,
     2.85417E-10, 2.79684E-10, 2.59063E-10, 2.79859E-10, 2.77747E-10,
     2.67293E-10, 2.79310E-10, 2.66596E-10, 2.65459E-10, 2.55420E-10,
     2.65996E-10, 2.56149E-10, 2.58317E-10, 2.49137E-10},
    {2.84303E-10, 3.41640E-10, 3.73990E-10, 3.88744E-10, 3.72609E-10,
     4.25514E-10, 3.39541E-10, 3.63254E-10, 3.22670E-10, 3.13567E-10,
     2.76425E-10, 2.92346E-10, 2.73577E-10, 2.90990E-10, 2.71422E-10,
     2.78796E-10, 2.68371E-10, 2.81486E-10, 2.84542E-10, 2.89889E-10,
     2.88442E-10, 2.75760E-10, 2.84493E-10, 2.71439E-10, 2.76976E-10,
     2.73526E-10, 2.76582E-10, 2.58467E-10, 2.70521E-10, 2.69503E-10,
     2.61666E-10, 2.57982E-10, 2.65957E-10, 2.53853E-10},
    {2.96243E-10, 3.21971E-10, 3.65797E-10, 3.82638E-10, 4.37509E-10,
     4.29293E-10, 4.15716E-10, 3.38161E-10, 3.39321E-10, 3.07565E-10,
     2.88722E-10, 2.84226E-10, 2.90251E-10, 2.76035E-10, 2.76140E-10,
     2.75172E-10, 2.62035E-10, 2.87011E-10, 2.67334E-10, 2.83624E-10,
     2.85751E-10, 2.64790E-10, 3.02798E-10, 2.75677E-10, 2.56561E-10,
     2.54560E-10, 2.61912E-10, 2.70228E-10, 2.70787E-10, 2.64125E-10,
     2.63615E-10, 2.63907E-10, 2.54511E-10, 2.54021E-10},
    {3.28944E-10, 3.44385E-10, 4.21078E-10, 4.13945E-10, 4.08711E-10,
     3.97193E-10, 3.78907E-10, 3.72890E-10, 3.27565E-10, 3.29378E-10,
     2.90584E-10, 2.74313E-10, 2.83030E-10, 2.70998E-10, 2.58357E-10,
     2.77545E-10, 2.92411E-10, 2.85015E-10, 2.80832E-10, 2.81111E-10,
     2.93646E-10, 2.59825E-10, 2.60635E-10, 2.53413E-10, 2.68318E-10,
     2.77775E-10, 2.50823E-10, 2.60450E-10, 2.71523E-10, 2.66017E-10,
     2.66159E-10, 2.64453E-10, 2.70881E-10, 2.58168E-10},
    {3.13692E-10, 3.70880E-10, 3.46584E-10, 3.72536E-10, 4.15932E-10,
     3.96859E-10, 3.77609E-10, 3.17201E-10, 3.19639E-10, 3.15569E-10,
     2.81760E-10, 2.91040E-10, 2.75774E-10, 2.85473E-10, 2.89503E-10,
     2.90464E-10, 2.71826E-10, 2.87850E-10, 2.76039E-10, 2.76775E-10,
     2.80984E-10, 2.71494E-10, 2.56547E-10, 2.62224E-10, 2.67322E-10,
     2.67025E-10, 2.65466E-10, 2.57976E-10, 2.63712E-10, 2.68881E-10,
     2.56598E-10, 2.59504E-10, 2.59109E-10, 2.41243E-10},
    {3.39396E-10, 3.43980E-10, 3.65576E-10, 4.33559E-10, 4.18282E-10,
     4.04420E-10, 3.89881E-10, 3.31230E-10, 3.19594E-10, 2.94618E-10,
     2.74799E-10, 2.81176E-10, 2.81976E-10, 2.79892E-10, 2.57734E-10,
     2.75883E-10, 2.82928E-10, 2.65584E-10, 2.90633E-10, 2.92041E-10,
     2.83964E-10, 2.69594E-10, 2.57968E-10, 2.76320E-10, 2.58243E-10,
     2.69847E-10, 2.68060E-10, 2.61713E-10, 2.50726E-10, 2.62328E-10,
     2.51705E-10, 2.49900E-10, 2.52507E-10, 2.61026E-10},
    {2.74923E-10, 4.12991E-10, 3.89003E-10, 4.17262E-10, 4.57440E-10,
     4.15178E-10, 3.46657E-10, 3.45868E-10, 3.12715E-10, 3.13233E-10,
     2.92139E-10, 2.74408E-10, 2.87869E-10, 2.78520E-10, 2.69177E-10,
     2.86887E-10, 2.84576E-10, 2.99671E-10, 2.86442E-10, 2.83582E-10,
     2.67181E-10, 2.65032E-10, 2.59063E-10, 2.83748E-10, 2.81362E-10,
     2.55224E-10, 2.71255E-10, 2.51611E-10, 2.70239E-10, 2.63792E-10,
     2.49006E-10, 2.62895E-10, 2.64589E-10, 2.53232E-10},
    {3.42414E-10, 3.39122E-10, 3.92064E-10, 4.04021E-10, 3.96242E-10,
     4.28696E-10, 3.61317E-10, 3.27748E-10, 2.90418E-10, 2.91420E-10,
     2.83156E-10, 2.97910E-10, 2.76813E-10, 2.85038E-10, 2.99149E-10,
     2.75123E-10, 2.80783E-10, 2.88790E-10, 2.95023E-10, 2.75805E-10,
     2.71378E-10, 2.75920E-10, 2.73317E-10, 2.69330E-10, 2.79175E-10,
     2.62622E-10, 2.61187E-10, 2.56822E-10, 2.69668E-10, 2.62858E-10,
     2.63279E-10, 2.84265E-10, 2.50573E-10, 2.51230E-10},
    {3.47878E-10, 4.52204E-10, 4.20483E-10, 4.31978E-10, 3.76512E-10,
     3.74392E-10, 3.57892E-10, 3.23407E-10, 2.89375E-10, 2.83008E-10,
     2.84716E-10, 2.95381E-10, 2.77989E-10, 2.66499E-10, 2.91869E-10,
     2.87573E-10, 2.75297E-10, 2.65747E-10, 2.82713E-10, 2.66185E-10,
     2.67390E-10, 2.78678E-10, 2.55382E-10, 2.61268E-10, 2.76143E-10,
     2.85736E-10, 2.76765E-10, 2.61559E-10, 2.70751E-10, 2.72068E-10,
     2.62337E-10, 2.67695E-10, 2.47892E-10, 2.50927E-10},
    {3.48782E-10, 3.98408E-10, 3.59881E-10, 4.35161E-10, 4.41204E-10,
     3.46919E-10, 3.44438E-10, 3.01752E-10, 2.94700E-10, 2.76012E-10,
     2.94727E-10, 2.73862E-10, 2.90314E-10, 2.53882E-10, 3.03872E-10,
     2.99711E-10, 2.84882E-10, 2.69802E-10, 2.79917E-10, 2.76134E-10,
     2.52446E-10, 2.68006E-10, 2.68439E-10, 2.68446E-10, 2.68963E-10,
     2.42148E-10, 2.74953E-10, 2.49145E-10, 2.63115E-10, 2.64455E-10,
     2.53494E-10, 2.77929E-10, 2.75030E-10, 2.56633E-10},
    {3.53228E-10, 4.06515E-10, 4.17299E-10, 3.81581E-10, 4.35533E-10,
     3.96888E-10, 3.42104E-10, 2.93960E-10, 2.92022E-10, 2.96309E-10,
     2.84655E-10, 2.89850E-10, 2.85262E-10, 2.80046E-10, 3.02260E-10,
     2.78954E-10, 2.85325E-10, 2.75182E-10, 2.55999E-10, 2.70106E-10,
     2.77510E-10, 2.74496E-10, 2.72016E-10, 2.67403E-10, 2.69236E-10,
     2.56686E-10, 2.65479E-10, 2.55587E-10, 2.58963E-10, 2.58788E-10,
     2.62189E-10, 2.46333E-10, 2.60495E-10, 2.58516E-10},
    {3.60058E-10, 4.16402E-10, 4.09066E-10, 4.30821E-10, 4.05762E-10,
     3.68511E-10, 3.18969E-10, 3.05236E-10, 2.91189E-10, 2.75785E-10,
     2.68301E-10, 2.93325E-10, 2.63346E-10, 2.94710E-10, 2.77362E-10,
     2.84698E-10, 2.72935E-10, 2.95014E-10, 2.59470E-10, 2.53969E-10,
     2.57761E-10, 2.76665E-10, 2.61478E-10, 2.63844E-10, 2.73053E-10,
     2.71809E-10, 2.76643E-10, 2.46484E-10, 2.60871E-10, 2.61837E-10,
     2.56256E-10, 2.75835E-10, 2.60352E-10, 2.59408E-10},
    {3.99906E-10, 4.19191E-10, 4.37444E-10, 4.21192E-10, 3.95565E-10,
     3.73130E-10, 3.17164E-10, 2.99530E-10, 2.96703E-10, 2.90266E-10,
     2.91174E-10, 2.89548E-10, 2.89824E-10, 2.87301E-10, 2.75649E-10,
     2.81678E-10, 2.67301E-10, 2.84294E-10, 2.81220E-10, 2.71737E-10,
     2.83463E-10, 2.77052E-10, 2.66929E-10, 2.56731E-10, 2.88400E-10,
     2.70224E-10, 2.46467E-10, 2.56236E-10, 2.48881E-10, 2.67879E-10,
     2.68723E-10, 2.66574E-10, 2.55395E-10, 2.50678E-10},
    {3.69455E-10, 4.18847E-10, 4.20722E-10, 4.36693E-10, 3.77263E-10,
     3.51706E-10, 3.17563E-10, 2.83140E-10, 2.76274E-10, 2.83048E-10,
     3.01399E-10, 2.91373E-10, 2.62417E-10, 2.87774E-10, 2.68098E-10,
     2.90674E-10, 2.67091E-10, 2.83687E-10, 2.97073E-10, 2.70388E-10,
     2.66691E-10, 2.86378E-10, 2.56449E-10, 2.59877E-10, 2.62860E-10,
     2.59677E-10, 2.39115E-10, 2.59717E-10, 2.64921E-10, 2.68721E-10,
     2.68424E-10, 2.64526E-10, 2.70392E-10, 2.68573E-10},
    {4.07832E-10, 3.62454E-10, 4.10626E-10, 4.19146E-10, 3.94134E-10,
     3.55212E-10, 3.10115E-10, 2.96167E-10, 3.20126E-10, 2.88156E-10,
     2.84056E-10, 2.81849E-10, 3.01271E-10, 2.96776E-10, 2.85302E-10,
     2.84465E-10, 2.89913E-10, 2.90579E-10, 2.79338E-10, 2.75482E-10,
     2.79531E-10, 2.60798E-10, 2.65622E-10, 2.67272E-10, 2.64916E-10,
     2.80193E-10, 2.50096E-10, 2.45716E-10, 2.68174E-10, 2.69355E-10,
     2.70915E-10, 2.75067E-10, 2.64236E-10, 2.56852E-10},
    {4.26705E-10, 4.37379E-10, 4.45864E-10, 4.02138E-10, 3.69453E-10,
     3.34511E-10, 3.20483E-10, 2.95984E-10, 2.70195E-10, 3.12779E-10,
     3.01879E-10, 3.01430E-10, 2.95631E-10, 2.65251E-10, 2.82013E-10,
     2.76271E-10, 3.09762E-10, 2.67767E-10, 2.72407E-10, 2.82152E-10,
     2.71780E-10, 2.67413E-10, 2.69721E-10, 2.57071E-10, 2.56776E-10,
     2.73354E-10, 2.68033E-10, 2.61185E-10, 2.82964E-10, 2.80056E-10,
     2.86726E-10, 2.69515E-10, 2.97307E-10, 2.80698E-10},
    {4.57297E-10, 4.15214E-10, 4.17386E-10, 4.02519E-10, 3.58140E-10,
     3.24476E-10, 3.04993E-10, 3.04438E-10, 2.65473E-10, 2.88958E-10,
     3.05405E-10, 2.82092E-10, 2.79877E-10, 2.92789E-10, 2.89279E-10,
     2.74903E-10, 2.70725E-10, 2.51564E-10, 2.86213E-10, 2.71825E-10,
     2.73653E-10, 2.72350E-10, 2.66790E-10, 2.71083E-10, 2.70336E-10,
     2.85348E-10, 2.66348E-10, 2.85521E-10, 2.63833E-10, 2.69810E-10,
     2.73022E-10, 2.82908E-10, 2.82622E-10, 2.95572E-10},
    {4.19256E-10, 4.90045E-10, 4.05903E-10, 4.19743E-10, 3.50130E-10,
     3.42709E-10, 3.01585E-10, 2.99750E-10, 2.97585E-10, 2.80474E-10,
     2.93850E-10, 2.96684E-10, 2.88819E-10, 3.10915E-10, 2.91600E-10,
     2.60387E-10, 2.71747E-10, 2.69805E-10, 2.68596E-10, 2.62504E-10,
     2.81514E-10, 2.64398E-10, 2.74414E-10, 2.63806E-10, 2.66430E-10,
     2.62157E-10, 2.68676E-10, 2.65130E-10, 2.74002E-10, 2.87976E-10,
     3.09848E-10, 3.09216E-10, 3.15441E-10, 2.93005E-10},
    {4.51527E-10, 4.42100E-10, 4.05186E-10, 3.89095E-10, 3.37133E-10,
     3.02987E-10, 2.99054E-10, 2.87417E-10, 2.88449E-10, 2.76171E-10,
     2.99330E-10, 2.97913E-10, 3.03107E-10, 2.87750E-10, 2.83043E-10,
     2.86762E-10, 2.69840E-10, 2.64089E-10, 2.82884E-10, 2.67079E-10,
     2.64687E-10, 2.77826E-10, 2.82905E-10, 2.81736E-10, 2.70704E-10,
     2.81043E-10, 2.66999E-10, 2.82721E-10, 2.94287E-10, 3.00243E-10,
     3.20139E-10, 3.22109E-10, 3.43838E-10, 3.55387E-10},
    {4.64364E-10, 4.06571E-10, 4.26683E-10, 3.67387E-10, 3.63712E-10,
     3.06383E-10, 2.92469E-10, 2.94081E-10, 2.95865E-10, 3.25262E-10,
     3.20816E-10, 2.79012E-10, 2.88515E-10, 2.98717E-10, 2.89329E-10,
     2.81740E-10, 2.58007E-10, 2.66457E-10, 2.75381E-10, 2.77664E-10,
     2.76460E-10, 2.65548E-10, 2.68445E-10, 2.67089E-10, 2.90727E-10,
     2.93926E-10, 3.08853E-10, 3.09297E-10, 3.00805E-10, 3.37928E-10,
     3.24656E-10, 3.67849E-10, 3.53253E-10, 3.88069E-10},
    {5.15705E-10, 4.51704E-10, 4.13761E-10, 3.62273E-10, 3.05393E-10,
     3.01356E-10, 3.21335E-10, 3.05330E-10, 3.04279E-10, 2.77772E-10,
     2.86697E-10, 2.96786E-10, 2.92284E-10, 2.77859E-10, 2.79367E-10,
     2.90859E-10, 2.77612E-10, 2.79206E-10, 2.80951E-10, 2.68131E-10,
     2.81892E-10, 2.83857E-10, 3.15469E-10, 2.82275E-10, 2.70688E-10,
     3.00686E-10, 3.30868E-10, 2.93969E-10, 3.22950E-10, 3.52919E-10,
     3.60576E-10, 4.42495E-10, 4.85494E-10, 4.42285E-10},
    {4.60879E-10, 4.68513E-10, 4.21662E-10, 3.49207E-10, 3.15383E-10,
     3.12315E-10, 2.64006E-10, 2.99856E-10, 3.00631E-10, 2.98272E-10,
     3.03918E-10, 2.76883E-10, 2.92147E-10, 2.91485E-10, 2.74967E-10,
     2.83726E-10, 2.70259E-10, 2.58928E-10, 2.85131E-10, 2.75418E-10,
     3.01794E-10, 2.77379E-10, 3.24985E-10, 2.60763E-10, 3.11597E-10,
     3.19018E-10, 3.76646E-10, 3.49791E-10, 3.91650E-10, 4.17016E-10,
     4.20373E-10, 4.40401E-10, 5.43053E-10, 5.28561E-10},
    {5.18108E-10, 4.44888E-10, 4.32655E-10, 3.51388E-10, 3.18701E-10,
     3.00812E-10, 3.18142E-10, 3.02047E-10, 2.85180E-10, 3.16652E-10,
     3.13967E-10, 2.83432E-10, 2.92056E-10, 2.66491E-10, 2.57820E-10,
     2.84111E-10, 2.71876E-10, 2.92300E-10, 2.98301E-10, 3.16659E-10,
     3.03574E-10, 3.11588E-10, 3.18132E-10, 3.38391E-10, 3.78667E-10,
     3.67301E-10, 4.16529E-10, 4.03383E-10, 4.50303E-10, 5.47809E-10,
     5.05743E-10, 5.82122E-10, 6.55656E-10, 6.74802E-10},
    {5.10079E-10, 4.30776E-10, 3.96137E-10, 3.22230E-10, 3.06855E-10,
     2.89320E-10, 2.90411E-10, 2.69759E-10, 2.95911E-10, 3.12094E-10,
     2.83512E-10, 3.05553E-10, 3.07928E-10, 2.82940E-10, 3.03362E-10,
     2.77254E-10, 2.99622E-10, 2.92234E-10, 2.96503E-10, 3.11615E-10,
     3.08725E-10, 3.50643E-10, 3.28170E-10, 3.73051E-10, 3.78299E-10,
     4.36509E-10, 4.67595E-10, 4.35402E-10, 5.10350E-10, 5.37929E-10,
     7.82883E-10, 7.12849E-10, 8.88265E-10, 1.09059E-09},
    {4.93683E-10, 4.53271E-10, 3.78393E-10, 3.01364E-10, 2.89126E-10,
     3.14058E-10, 3.02577E-10, 3.10758E-10, 3.07568E-10, 2.94400E-10,
     3.20818E-10, 3.10655E-10, 3.00233E-10, 2.75109E-10, 2.85347E-10,
     3.08045E-10, 3.10770E-10, 3.15310E-10, 2.98232E-10, 3.31881E-10,
     3.49422E-10, 3.82406E-10, 4.13125E-10, 3.63198E-10, 4.10703E-10,
     4.70340E-10, 5.77432E-10, 6.38174E-10, 7.28141E-10, 7.46595E-10,
     8.63378E-10, 9.95731E-10, 1.10013E-09, 1.22731E-09},
    {4.55496E-10, 4.56807E-10, 3.59314E-10, 3.21148E-10, 3.03257E-10,
     2.87184E-10, 3.25562E-10, 3.08160E-10, 3.02232E-10, 2.91889E-10,
     2.94956E-10, 2.92384E-10, 2.92016E-10, 2.77421E-10, 2.87200E-10,
     3.53100E-10, 3.09915E-10, 3.50614E-10, 3.23915E-10, 3.64100E-10,
     4.07215E-10, 4.60236E-10, 4.70318E-10, 4.93464E-10, 6.02819E-10,
     6.32048E-10, 6.95965E-10, 8.65359E-10, 9.42288E-10, 1.01582E-09,
     1.24594E-09, 1.32622E-09, 1.40715E-09, 1.59415E-09},
    {5.14077E-10, 4.50336E-10, 3.96150E-10, 3.33016E-10, 2.82945E-10,
     3.11885E-10, 3.25992E-10, 3.14836E-10, 3.03125E-10, 3.10998E-10,
     2.95584E-10, 3.12427E-10, 2.94530E-10, 2.98448E-10, 3.22095E-10,
     2.97732E-10, 3.35728E-10, 3.74244E-10, 3.75090E-10, 3.85828E-10,
     4.68816E-10, 4.96985E-10, 5.43772E-10, 6.63938E-10, 7.80888E-10,
     8.41996E-10, 9.26178E-10, 1.11000E-09, 1.19209E-09, 1.36709E-09,
     1.67626E-09, 1.74610E-09, 1.96964E-09, 2.17382E-09},
    {5.01365E-10, 4.60684E-10, 3.70689E-10, 3.14833E-10, 3.08308E-10,
     2.89749E-10, 3.08570E-10, 3.06063E-10, 3.03921E-10, 2.83952E-10,
     3.01494E-10, 3.06580E-10, 3.10672E-10, 3.30734E-10, 3.23921E-10,
     3.34305E-10, 3.76298E-10, 4.19777E-10, 4.31178E-10, 4.97291E-10,
     5.65174E-10, 6.55243E-10, 7.53830E-10, 9.58914E-10, 1.14254E-09,
     1.11653E-09, 1.25258E-09, 1.63956E-09, 1.80347E-09, 1.79930E-09,
     2.22842E-09, 2.32438E-09, 2.79789E-09, 3.10617E-09},
    {4.75691E-10, 4.61691E-10, 3.44527E-10, 3.27331E-10, 3.12988E-10,
     3.29903E-10, 3.08523E-10, 3.12184E-10, 2.88675E-10, 3.28234E-10,
     3.08580E-10, 3.05668E-10, 3.12468E-10, 3.57568E-10, 3.75759E-10,
     3.98802E-10, 4.30128E-10, 4.81944E-10, 5.61389E-10, 6.31867E-10,
     6.81689E-10, 8.15281E-10, 1.09035E-09, 1.34540E-09, 1.44522E-09,
     1.61638E-09, 1.80291E-09, 2.23842E-09, 2.55295E-09, 2.46544E-09,
     2.88246E-09, 3.40855E-09, 3.43970E-09, 4.10802E-09},
    {4.28320E-10, 3.70012E-10, 3.43871E-10, 3.06643E-10, 3.13827E-10,
     2.91888E-10, 3.19562E-10, 3.18264E-10, 3.13086E-10, 3.08107E-10,
     3.03063E-10, 3.34001E-10, 3.49651E-10, 3.49516E-10, 4.10433E-10,
     4.56810E-10, 5.52516E-10, 5.98046E-10, 6.76995E-10, 7.97607E-10,
     9.78093E-10, 1.14943E-09, 1.38416E-09, 1.67809E-09, 1.96814E-09,
     2.30014E-09, 2.60417E-09, 2.95958E-09, 3.62089E-09, 3.68229E-09,
     3.93395E-09, 4.61215E-09, 4.90093E-09, 5.22418E-09},
    {4.88587E-10, 4.13117E-10, 3.55210E-10, 3.16341E-10, 2.98168E-10,
     3.08211E-10, 3.22539E-10, 3.09292E-10, 3.25218E-10, 3.25733E-10,
     3.42626E-10, 3.24394E-10, 3.75026E-10, 4.58889E-10, 4.35865E-10,
     5.27667E-10, 6.39593E-10, 7.98266E-10, 9.79530E-10, 1.17891E-09,
     1.36865E-09, 1.76533E-09, 1.97137E-09, 2.37032E-09, 2.90070E-09,
     3.13778E-09, 3.36778E-09, 3.98663E-09, 4.31615E-09, 5.07365E-09,
     5.39983E-09, 5.97831E-09, 6.60402E-09, 6.77003E-09},
    {4.27465E-10, 4.32799E-10, 3.38655E-10, 3.19866E-10, 2.97931E-10,
     3.15319E-10, 3.13500E-10, 3.13744E-10, 3.16788E-10, 3.42876E-10,
     3.53154E-10, 3.90907E-10, 4.22903E-10, 5.60889E-10, 5.74962E-10,
     7.13207E-10, 7.68654E-10, 1.15249E-09, 1.36655E-09, 1.60563E-09,
     1.89447E-09, 2.43721E-09, 2.65341E-09, 3.42006E-09, 3.92273E-09,
     4.35601E-09, 4.68498E-09, 5.39594E-09, 6.16548E-09, 6.68420E-09,
     7.47469E-09, 7.73395E-09, 8.63365E-09, 8.86217E-09},
    {5.39256E-10, 4.33359E-10, 3.55176E-10, 3.37082E-10, 3.09467E-10,
     3.06298E-10, 3.19508E-10, 3.27459E-10, 3.50757E-10, 3.64649E-10,
     4.14848E-10, 4.53361E-10, 5.75536E-10, 7.03746E-10, 6.88953E-10,
     1.05273E-09, 1.22679E-09, 1.62839E-09, 1.84694E-09, 2.36705E-09,
     2.73899E-09, 3.65557E-09, 3.81307E-09, 4.71216E-09, 5.39347E-09,
     6.01029E-09, 6.25414E-09, 7.07211E-09, 8.10229E-09, 8.61205E-09,
     9.15368E-09, 1.06444E-08, 1.08149E-08, 1.05561E-08},
    {4.72490E-10, 4.23789E-10, 3.53419E-10, 3.19408E-10, 3.10158E-10,
     3.31401E-10, 3.53913E-10, 3.35520E-10, 3.98740E-10, 3.98539E-10,
     4.96882E-10, 5.66726E-10, 7.22716E-10, 8.50594E-10, 1.08365E-09,
     1.57260E-09, 1.61853E-09, 2.44355E-09, 2.70582E-09, 3.26443E-09,
     4.01547E-09, 4.67152E-09, 5.04848E-09, 6.42761E-09, 6.81681E-09,
     7.47079E-09, 8.30949E-09, 9.81557E-09, 9.96700E-09, 1.08898E-08,
     1.16813E-08, 1.24031E-08, 1.30024E-08, 1.37123E-08},
    {4.98073E-10, 3.64078E-10, 3.32241E-10, 3.32248E-10, 3.53520E-10,
     3.18900E-10, 3.60427E-10, 3.54535E-10, 4.08900E-10, 5.00408E-10,
     6.21636E-10, 7.38922E-10, 1.01619E-09, 1.25361E-09, 1.54116E-09,
     2.05061E-09, 2.40160E-09, 3.28219E-09, 3.94321E-09, 4.73381E-09,
     6.00660E-09, 6.53770E-09, 7.05056E-09, 8.81511E-09, 8.98830E-09,
     1.00468E-08, 1.06980E-08, 1.22748E-08, 1.22322E-08, 1.35222E-08,
     1.43272E-08, 1.49096E-08, 1.51500E-08, 1.61881E-08},
    {4.36359E-10, 4.16802E-10, 3.39797E-10, 3.41563E-10, 3.34522E-10,
     3.54694E-10, 3.50035E-10, 4.36450E-10, 4.76634E-10, 6.11427E-10,
     8.98177E-10, 1.04916E-09, 1.44298E-09, 1.79539E-09, 2.34707E-09,
     2.95204E-09, 3.93330E-09, 4.66237E-09, 5.50233E-09, 6.58148E-09,
     7.60916E-09, 8.97075E-09, 9.92664E-09, 1.10893E-08, 1.15960E-08,
     1.25643E-08, 1.34208E-08, 1.47667E-08, 1.52043E-08, 1.59599E-08,
     1.64652E-08, 1.71194E-08, 1.73814E-08, 1.81328E-08},
    {4.20264E-10, 3.82939E-10, 3.60829E-10, 3.51479E-10, 3.71439E-10,
     3.72266E-10, 4.18849E-10, 5.35550E-10, 5.72854E-10, 7.48007E-10,
     1.08938E-09, 1.54800E-09, 2.01393E-09, 2.44061E-09, 3.54645E-09,
     4.62064E-09, 5.60488E-09, 6.66123E-09, 7.44260E-09, 9.07756E-09,
     1.04024E-08, 1.17571E-08, 1.23421E-08, 1.38180E-08, 1.43632E-08,
     1.56564E-08, 1.64398E-08, 1.70123E-08, 1.77400E-08, 1.79331E-08,
     1.83621E-08, 1.88378E-08, 1.92096E-08, 1.92829E-08},
    {4.01360E-10, 3.91308E-10, 3.43764E-10, 3.50795E-10, 3.80590E-10,
     3.67658E-10, 4.56269E-10, 5.97915E-10, 8.14993E-10, 1.25169E-09,
     1.59672E-09, 2.27134E-09, 3.00199E-09, 3.99475E-09, 4.79191E-09,
     6.11625E-09, 7.57054E-09, 9.10415E-09, 1.04674E-08, 1.16222E-08,
     1.34301E-08, 1.39385E-08, 1.48891E-08, 1.62159E-08, 1.72668E-08,
     1.82086E-08, 1.82657E-08, 1.84721E-08, 1.96356E-08, 1.90359E-08,
     1.95867E-08, 2.02311E-08, 1.94211E-08, 1.93909E-08},
    {4.13086E-10, 3.59416E-10, 4.14938E-10, 4.15090E-10, 4.12030E-10,
     4.62864E-10, 6.41693E-10, 7.42629E-10, 1.20975E-09, 1.68751E-09,
     2.50233E-09, 3.42569E-09, 4.45755E-09, 5.65508E-09, 7.14360E-09,
     8.51261E-09, 1.00858E-08, 1.21803E-08, 1.31702E-08, 1.45872E-08,
     1.64382E-08, 1.67593E-08, 1.84841E-08, 1.86550E-08, 1.99330E-08,
     1.94531E-08, 1.96746E-08, 1.94269E-08, 1.97798E-08, 2.00379E-08,
     2.00367E-08, 1.97857E-08, 1.88761E-08, 1.84662E-08},
    {4.21708E-10, 3.78846E-10, 3.73850E-10, 4.60457E-10, 5.40171E-10,
     5.26500E-10, 7.93952E-10, 1.14063E-09, 1.83194E-09, 2.76999E-09,
     3.86662E-09, 4.96473E-09, 6.44618E-09, 7.72529E-09, 1.01072E-08,
     1.16591E-08, 1.29910E-08, 1.55117E-08, 1.57106E-08, 1.73909E-08,
     1.86055E-08, 1.94378E-08, 2.05020E-08, 2.07841E-08, 2.07825E-08,
     2.06437E-08, 2.00933E-08, 2.00532E-08, 1.92880E-08, 1.95010E-08,
     1.94936E-08, 1.81928E-08, 1.77208E-08, 1.73102E-08},
    {4.00834E-10, 3.85767E-10, 4.45303E-10, 4.23044E-10, 6.03391E-10,
     7.58648E-10, 1.17887E-09, 1.94444E-09, 2.92445E-09, 3.90154E-09,
     5.49654E-09, 7.35279E-09, 8.84661E-09, 1.08292E-08, 1.36048E-08,
     1.49667E-08, 1.67723E-08, 1.79722E-08, 1.84233E-08, 1.94059E-08,
     2.06973E-08, 2.09697E-08, 2.16629E-08, 2.08157E-08, 2.06821E-08,
     2.01026E-08, 1.95120E-08, 1.87678E-08, 1.83848E-08, 1.82314E-08,
     1.70924E-08, 1.57240E-08, 1.52170E-08, 1.47121E-08},
    {3.67096E-10, 4.13105E-10, 5.11165E-10, 5.20323E-10, 7.86853E-10,
     1.19635E-09, 1.87950E-09, 2.75253E-09, 4.21479E-09, 5.80039E-09,
     7.90424E-09, 1.00618E-08, 1.27245E-08, 1.43351E-08, 1.63722E-08,
     1.79151E-08, 1.97092E-08, 1.97531E-08, 2.07435E-08, 2.09118E-08,
     2.14872E-08, 2.11804E-08, 2.10185E-08, 1.97402E-08, 1.89475E-08,
     1.78486E-08, 1.74767E-08, 1.63998E-08, 1.55647E-08, 1.44037E-08,
     1.39124E-08, 1.31892E-08, 1.20874E-08, 1.15088E-08},
    {3.80245E-10, 4.98136E-10, 5.80932E-10, 7.08375E-10, 9.13532E-10,
     1.80085E-09, 2.80031E-09, 4.21177E-09, 6.47069E-09, 8.71362E-09,
     1.14295E-08, 1.36845E-08, 1.57623E-08, 1.77768E-08, 1.86585E-08,
     2.06057E-08, 2.11223E-08, 2.06362E-08, 2.10509E-08, 2.13829E-08,
     2.03825E-08, 1.92448E-08, 1.88542E-08, 1.71517E-08, 1.63623E-08,
     1.55511E-08, 1.42824E-08, 1.26347E-08, 1.21673E-08, 1.08469E-08,
     1.05308E-08, 9.80400E-09, 8.96245E-09, 8.01737E-09},
    {4.15487E-10, 5.68736E-10, 7.15889E-10, 1.04995E-09, 1.90319E-09,
     2.88583E-09, 4.48148E-09, 6.38357E-09, 9.10192E-09, 1.19036E-08,
     1.49334E-08, 1.76531E-08, 1.88836E-08, 2.02478E-08, 2.11636E-08,
     2.21994E-08, 2.15509E-08, 2.07983E-08, 2.04623E-08, 1.98757E-08,
     1.80789E-08, 1.67151E-08, 1.53016E-08, 1.38096E-08, 1.29553E-08,
     1.19546E-08, 1.05364E-08, 9.97743E-09, 8.82226E-09, 7.86315E-09,
     7.27831E-09, 6.66393E-09, 6.49867E-09, 5.86608E-09},
    {4.82743E-10, 6.02627E-10, 9.15855E-10, 1.53419E-09, 2.77272E-09,
     4.56521E-09, 6.60002E-09, 9.15784E-09, 1.25464E-08, 1.51446E-08,
     1.81070E-08, 2.00016E-08, 2.21873E-08, 2.18085E-08, 2.23170E-08,
     2.24034E-08, 2.08695E-08, 1.92309E-08, 1.80840E-08, 1.57829E-08,
     1.46755E-08, 1.33464E-08, 1.15039E-08, 1.02226E-08, 9.46975E-09,
     8.26795E-09, 7.57333E-09, 6.82127E-09, 6.11772E-09, 5.87246E-09,
     5.45614E-09, 5.00082E-09, 4.60165E-09, 4.61364E-09},
    {5.44551E-10, 9.07059E-10, 1.38372E-09, 2.40977E-09, 4.16826E-09,
     6.60576E-09, 9.47194E-09, 1.29145E-08, 1.67309E-08, 1.86646E-08,
     2.16086E-08, 2.24142E-08, 2.34085E-08, 2.21944E-08, 2.10846E-08,
     1.91808E-08, 1.76435E-08, 1.61110E-08, 1.41889E-08, 1.20416E-08,
     1.12347E-08, 9.32950E-09, 7.66612E-09, 7.23792E-09, 6.32417E-09,
     5.99227E-09, 5.41733E-09, 4.99666E-09, 4.93274E-09, 4.46083E-09,
     4.49826E-09, 4.53885E-09, 4.36552E-09, 4.37964E-09},
    {6.38489E-10, 1.15603E-09, 2.07930E-09, 3.93435E-09, 6.46579E-09,
     9.09983E-09, 1.34179E-08, 1.68053E-08, 2.00411E-08, 2.17560E-08,
     2.30046E-08, 2.35838E-08, 2.20080E-08, 1.99522E-08, 1.83406E-08,
     1.58228E-08, 1.34596E-08, 1.15680E-08, 1.01995E-08, 8.45844E-09,
     7.09191E-09, 6.29988E-09, 5.51562E-09, 5.20676E-09, 4.82549E-09,
     4.67507E-09, 4.61372E-09, 4.71632E-09, 4.68408E-09, 4.50501E-09,
     4.75999E-09, 5.02956E-09, 4.93281E-09, 5.32863E-09},
    {8.72917E-10, 1.73050E-09, 3.61535E-09, 5.55946E-09, 9.20541E-09,
     1.35496E-08, 1.74104E-08, 1.99850E-08, 2.24524E-08, 2.36424E-08,
     2.23629E-08, 2.13840E-08, 1.89559E-08, 1.69719E-08, 1.39434E-08,
     1.15848E-08, 8.72111E-09, 7.98250E-09, 6.53034E-09, 5.65417E-09,
     4.95761E-09, 4.77862E-09, 4.47843E-09, 4.61509E-09, 4.70104E-09,
     4.73136E-09, 4.98421E-09, 5.22452E-09, 5.50930E-09, 5.59350E-09,
     5.92460E-09, 6.07124E-09, 5.89974E-09, 6.24363E-09},
    {1.29844E-09, 2.97054E-09, 5.57057E-09, 8.18909E-09, 1.33865E-08,
     1.76018E-08, 2.16614E-08, 2.29423E-08, 2.28164E-08, 2.25268E-08,
     1.98603E-08, 1.77908E-08, 1.50298E-08, 1.19194E-08, 9.44516E-09,
     7.71953E-09, 6.13525E-09, 5.59455E-09, 4.60518E-09, 4.91542E-09,
     4.80990E-09, 4.90708E-09, 5.08186E-09, 5.44866E-09, 5.72045E-09,
     5.88821E-09, 6.44122E-09, 6.65118E-09, 6.74817E-09, 6.80045E-09,
     7.02793E-09, 7.16617E-09, 6.93703E-09, 7.12681E-09},
    {1.97449E-09, 4.17757E-09, 7.64423E-09, 1.22438E-08, 1.73225E-08,
     2.17911E-08, 2.36546E-08, 2.35670E-08, 2.18058E-08, 1.92573E-08,
     1.60215E-08, 1.28762E-08, 9.85429E-09, 7.63515E-09, 6.05519E-09,
     5.01796E-09, 4.80670E-09, 4.67952E-09, 5.26784E-09, 5.39089E-09,
     5.43298E-09, 5.90464E-09, 6.14108E-09, 6.52452E-09, 6.93916E-09,
     7.02539E-09, 7.46887E-09, 7.68357E-09, 7.58317E-09, 7.77133E-09,
     7.78596E-09, 7.82867E-09, 7.33436E-09, 7.87650E-09},
    {3.59455E-09, 6.75201E-09, 1.14145E-08, 1.70439E-08, 2.21241E-08,
     2.36797E-08, 2.35082E-08, 2.21530E-08, 1.86564E-08, 1.44541E-08,
     1.11589E-08, 8.25653E-09, 6.26098E-09, 5.62757E-09, 4.99164E-09,
     4.79041E-09, 5.10795E-09, 5.85253E-09, 6.19725E-09, 6.81534E-09,
     6.74831E-09, 7.24929E-09, 7.52799E-09, 7.75838E-09, 7.87887E-09,
     8.20847E-09, 8.02094E-09, 7.95896E-09, 8.05930E-09, 8.03324E-09,
     7.93764E-09, 8.12724E-09, 7.71514E-09, 7.85538E-09},
    {5.33250E-09, 9.39590E-09, 1.54688E-08, 2.07946E-08, 2.42617E-08,
     2.45430E-08, 2.19259E-08, 1.79654E-08, 1.37063E-08, 9.83820E-09,
     7.10009E-09, 5.41167E-09, 4.61909E-09, 5.14417E-09, 5.45291E-09,
     6.02270E-09, 6.56611E-09, 7.08265E-09, 7.08077E-09, 7.96062E-09,
     7.96719E-09, 8.45643E-09, 8.58656E-09, 8.57120E-09, 8.49090E-09,
     8.34977E-09, 8.29493E-09, 7.72466E-09, 8.44864E-09, 7.74492E-09,
     7.52565E-09, 7.10786E-09, 7.56868E-09, 7.46622E-09},
    {8.52161E-09, 1.44143E-08, 2.00592E-08, 2.42399E-08, 2.48096E-08,
     2.15659E-08, 1.72310E-08, 1.23509E-08, 8.61996E-09, 6.28505E-09,
     5.17898E-09, 4.82864E-09, 5.83237E-09, 6.20838E-09, 7.27871E-09,
     7.63554E-09, 8.00886E-09, 8.45504E-09, 8.16069E-09, 8.41717E-09,
     8.52877E-09, 8.56864E-09, 8.46164E-09, 8.01197E-09, 8.21789E-09,
     7.87238E-09, 7.72214E-09, 7.64639E-09, 7.26040E-09, 7.34781E-09,
     7.31535E-09, 7.13654E-09, 6.83043E-09, 7.06427E-09},
    {1.19555E-08, 1.87836E-08, 2.38759E-08, 2.52690E-08, 2.15635E-08,
     1.74342E-08, 1.14738E-08, 7.57165E-09, 5.53193E-09, 5.19099E-09,
     5.14252E-09, 6.62405E-09, 7.43361E-09, 8.29383E-09, 8.95996E-09,
     8.43984E-09, 8.26983E-09, 8.74767E-09, 8.41305E-09, 8.44031E-09,
     8.19561E-09, 8.00335E-09, 7.73391E-09, 7.34278E-09, 7.13948E-09,
     7.08888E-09, 7.05003E-09, 6.96122E-09, 7.01614E-09, 6.84016E-09,
     6.93206E-09, 6.71286E-09, 6.64642E-09, 6.52255E-09},
    {1.65875E-08, 2.30249E-08, 2.47899E-08, 2.31492E-08, 1.73623E-08,
     1.11910E-08, 7.17698E-09, 5.45418E-09, 5.29252E-09, 5.89534E-09,
     6.81564E-09, 7.84110E-09, 8.50520E-09, 9.10565E-09, 8.91032E-09,
     8.67059E-09, 8.45280E-09, 8.38741E-09, 7.50268E-09, 7.85656E-09,
     7.72782E-09, 7.33923E-09, 7.11081E-09, 6.77279E-09, 6.66520E-09,
     6.47476E-09, 6.82832E-09, 6.73212E-09, 6.75884E-09, 6.74430E-09,
     6.55071E-09, 6.37888E-09, 6.38552E-09, 6.63807E-09},
    {2.18100E-08, 2.57031E-08, 2.42889E-08, 1.80022E-08, 1.12176E-08,
     6.82462E-09, 5.20552E-09, 5.41789E-09, 6.60177E-09, 7.75777E-09,
     8.46386E-09, 8.83168E-09, 9.25372E-09, 8.73351E-09, 8.53330E-09,
     8.34561E-09, 7.80391E-09, 7.76370E-09, 7.58854E-09, 7.28010E-09,
     7.05268E-09, 6.88015E-09, 6.71986E-09, 6.79214E-09, 6.67338E-09,
     6.43044E-09, 6.70316E-09, 6.47441E-09, 6.28188E-09, 6.49488E-09,
     6.39939E-09, 6.59619E-09, 6.37340E-09, 5.97935E-09},
    {2.49827E-08, 2.59466E-08, 1.90361E-08, 1.18682E-08, 6.86654E-09,
     5.24248E-09, 5.93325E-09, 7.74603E-09, 8.35164E-09, 9.31150E-09,
     9.09253E-09, 8.84376E-09, 8.50527E-09, 7.99676E-09, 7.75759E-09,
     7.61162E-09, 7.32945E-09, 7.33080E-09, 7.18036E-09, 6.77807E-09,
     6.31974E-09, 6.63425E-09, 6.96949E-09, 6.54395E-09, 6.40125E-09,
     6.37348E-09, 6.25412E-09, 6.22399E-09, 6.27829E-09, 6.13511E-09,
     6.40949E-09, 6.24057E-09, 5.78596E-09, 5.91973E-09},
    {2.64796E-08, 2.11426E-08, 1.29162E-08, 7.33860E-09, 5.31529E-09,
     6.13881E-09, 7.73394E-09, 8.68892E-09, 9.14096E-09, 8.96428E-09,
     9.10843E-09, 8.16543E-09, 7.94505E-09, 7.42737E-09, 7.55916E-09,
     7.08079E-09, 7.11266E-09, 6.79046E-09, 6.57896E-09, 6.61811E-09,
     6.37015E-09, 6.48280E-09, 6.53529E-09, 6.47771E-09, 6.01252E-09,
     6.05493E-09, 6.00962E-09, 5.87617E-09, 5.75012E-09, 6.13203E-09,
     5.90901E-09, 6.17310E-09, 5.72861E-09, 5.69591E-09},
    {2.35252E-08, 1.49353E-08, 7.70686E-09, 5.49664E-09, 6.07118E-09,
     8.51863E-09, 9.63683E-09, 9.22401E-09, 8.35955E-09, 8.45389E-09,
     8.78196E-09, 7.80499E-09, 7.42537E-09, 7.06144E-09, 7.25187E-09,
     6.70611E-09, 6.99103E-09, 6.64993E-09, 6.48079E-09, 6.28124E-09,
     6.32496E-09, 6.48673E-09, 6.34729E-09, 6.35468E-09, 6.08043E-09,
     6.05505E-09, 6.17581E-09, 6.20444E-09, 5.90603E-09, 5.84881E-09,
     5.84396E-09, 5.62652E-09, 5.92123E-09, 5.95090E-09},
    {1.80341E-08, 8.96489E-09, 5.39648E-09, 6.33568E-09, 8.40907E-09,
     9.57531E-09, 9.73293E-09, 8.59793E-09, 7.84251E-09, 7.42539E-09,
     7.96127E-09, 7.40772E-09, 6.78862E-09, 6.88313E-09, 6.80660E-09,
     6.47832E-09, 6.93797E-09, 6.67577E-09, 6.26666E-09, 6.11293E-09,
     5.91180E-09, 6.43254E-09, 6.34208E-09, 6.27130E-09, 6.26730E-09,
     6.00051E-09, 6.37593E-09, 6.28013E-09, 5.92877E-09, 6.01927E-09,
     5.71762E-09, 6.06316E-09, 5.98658E-09, 5.74859E-09},
    {1.10838E-08, 5.68166E-09, 5.90168E-09, 8.58766E-09, 9.77481E-09,
     9.61547E-09, 9.23898E-09, 8.61342E-09, 7.98367E-09, 7.49431E-09,
     7.35082E-09, 7.24939E-09, 6.85931E-09, 6.73587E-09, 6.63250E-09,
     6.76489E-09, 6.74916E-09, 6.49004E-09, 6.44519E-09, 6.26963E-09,
     5.82468E-09, 6.32103E-09, 6.23746E-09, 6.22058E-09, 6.41300E-09,
     6.22835E-09, 6.12526E-09, 6.14228E-09, 6.22831E-09, 5.92141E-09,
     6.43075E-09, 5.88968E-09, 5.62947E-09, 5.62420E-09},
    {6.76664E-09, 5.94188E-09, 8.98219E-09, 1.00245E-08, 9.24921E-09,
     8.51916E-09, 8.13576E-09, 7.30778E-09, 7.30090E-09, 7.63251E-09,
     7.02490E-09, 7.02618E-09, 6.84290E-09, 6.70578E-09, 6.69594E-09,
     6.56922E-09, 6.58928E-09, 6.56981E-09, 6.60762E-09, 6.29554E-09,
     6.06611E-09, 6.15525E-09, 5.92667E-09, 5.87380E-09, 5.84580E-09,
     6.21587E-09, 5.89031E-09, 5.98117E-09, 6.10200E-09, 5.90627E-09,
     5.92266E-09, 5.88145E-09, 5.52338E-09, 5.78588E-09},
    {5.53094E-09, 8.10922E-09, 1.01447E-08, 9.37018E-09, 8.62063E-09,
     8.81686E-09, 8.62386E-09, 7.18569E-09, 7.07505E-09, 7.39421E-09,
     6.87888E-09, 7.22204E-09, 6.98495E-09, 6.40057E-09, 6.67871E-09,
     6.71938E-09, 6.39085E-09, 6.42352E-09, 6.16382E-09, 6.02226E-09,
     6.18082E-09, 5.88953E-09, 5.63040E-09, 5.87014E-09, 6.00164E-09,
     5.85918E-09, 5.70083E-09, 5.89210E-09, 5.72890E-09, 5.61438E-09,
     5.47857E-09, 5.55859E-09, 5.47019E-09, 5.44689E-09},
    {7.57221E-09, 9.88828E-09, 9.77166E-09, 9.10707E-09, 7.97798E-09,
     6.91125E-09, 7.62016E-09, 7.38243E-09, 6.75825E-09, 7.27910E-09,
     7.33309E-09, 6.99495E-09, 6.88564E-09, 6.52563E-09, 6.24759E-09,
     6.71457E-09, 6.01487E-09, 6.42040E-09, 5.83342E-09, 5.93831E-09,
     6.20074E-09, 5.91874E-09, 5.78515E-09, 5.65600E-09, 6.01913E-09,
     5.66223E-09, 5.49071E-09, 5.58170E-09, 5.72099E-09, 5.46644E-09,
     5.42511E-09, 5.33519E-09, 5.31782E-09, 5.53385E-09},
    {9.23222E-09, 1.02344E-08, 8.50901E-09, 7.92888E-09, 7.78419E-09,
     7.74463E-09, 7.36614E-09, 7.60280E-09, 7.14301E-09, 6.59614E-09,
     6.95019E-09, 6.67589E-09, 6.62073E-09, 6.46392E-09, 6.23433E-09,
     6.44616E-09, 6.07695E-09, 6.08169E-09, 5.87119E-09, 5.78799E-09,
     5.59805E-09, 5.66500E-09, 5.74711E-09, 5.48013E-09, 5.81834E-09,
     5.65288E-09, 5.63814E-09, 5.58402E-09, 5.69397E-09, 5.52235E-09,
     5.30788E-09, 5.50470E-09, 5.44409E-09, 5.60205E-09},
    {1.01695E-08, 8.94326E-09, 8.06145E-09, 7.78801E-09, 7.21433E-09,
     7.42551E-09, 7.15936E-09, 7.31987E-09, 6.90451E-09, 6.71795E-09,
     6.57535E-09, 6.78637E-09, 6.16969E-09, 6.21162E-09, 6.11878E-09,
     6.10041E-09, 6.09751E-09, 5.93123E-09, 5.99619E-09, 5.71848E-09,
     5.65612E-09, 5.93265E-09, 5.65081E-09, 5.69275E-09, 6.16505E-09,
     5.57741E-09, 5.58328E-09, 5.75233E-09, 5.96873E-09, 5.66767E-09,
     5.62549E-09, 5.59169E-09, 5.49902E-09, 5.44874E-09},
    {9.73379E-09, 8.10477E-09, 7.94764E-09, 7.61072E-09, 7.42683E-09,
     7.09581E-09, 7.03379E-09, 7.10036E-09, 6.85405E-09, 6.65087E-09,
     6.54104E-09, 6.21833E-09, 6.27423E-09, 6.06211E-09, 6.29567E-09,
     5.85369E-09, 6.47512E-09, 6.13511E-09, 5.83143E-09, 5.60343E-09,
     5.51437E-09, 5.60456E-09, 5.73804E-09, 5.84256E-09, 5.63109E-09,
     5.61971E-09, 5.66914E-09, 5.54199E-09, 5.39513E-09, 5.55723E-09,
     5.59534E-09, 5.48430E-09, 5.23385E-09, 5.28389E-09},
    {9.37776E-09, 8.08400E-09, 7.08620E-09, 7.28936E-09, 7.04550E-09,
     7.12569E-09, 7.10869E-09, 6.69453E-09, 6.55258E-09, 6.49428E-09,
     6.32586E-09, 6.19736E-09, 6.22631E-09, 6.02127E-09, 6.21546E-09,
     6.22190E-09, 6.22262E-09, 5.98183E-09, 5.67755E-09, 5.81893E-09,
     5.47010E-09, 5.42281E-09, 5.66354E-09, 5.65137E-09, 5.46975E-09,
     5.69439E-09, 5.38992E-09, 5.30712E-09, 5.16435E-09, 5.46917E-09,
     5.16174E-09, 5.18788E-09, 5.43539E-09, 5.18603E-09},
    {8.48547E-09, 7.72531E-09, 7.36482E-09, 7.20565E-09, 7.05473E-09,
     6.97260E-09, 6.61012E-09, 6.31270E-09, 6.25313E-09, 6.37584E-09,
     6.34801E-09, 6.16787E-09, 6.13821E-09, 6.00012E-09, 5.52590E-09,
     5.96300E-09, 5.95017E-09, 5.74943E-09, 5.72158E-09, 5.60851E-09,
     5.43432E-09, 5.60699E-09, 5.14654E-09, 5.66854E-09, 5.65278E-09,
     5.22373E-09, 5.10410E-09, 5.12048E-09, 5.19197E-09, 4.73301E-09,
     5.10069E-09, 5.17795E-09, 4.87747E-09, 5.13365E-09},
    {8.32680E-09, 7.40163E-09, 7.64139E-09, 7.09860E-09, 7.07698E-09,
     6.51072E-09, 6.61072E-09, 6.72822E-09, 6.33051E-09, 6.04104E-09,
     6.02773E-09, 5.91903E-09, 6.14163E-09, 5.92330E-09, 5.46654E-09,
     5.31967E-09, 5.75739E-09, 5.69028E-09, 5.91148E-09, 5.67632E-09,
     5.52299E-09, 5.45642E-09, 5.32907E-09, 5.34527E-09, 5.88615E-09,
     5.43694E-09, 5.16239E-09, 5.18934E-09, 5.50383E-09, 5.54602E-09,
     5.16295E-09, 4.94545E-09, 5.48748E-09, 5.16027E-09},
    {7.55092E-09, 7.51332E-09, 7.31636E-09, 6.98812E-09, 7.17663E-09,
     7.20277E-09, 6.66726E-09, 6.54123E-09, 6.63750E-09, 6.43990E-09,
     5.80530E-09, 6.14836E-09, 5.83288E-09, 5.83605E-09, 6.05030E-09,
     5.59699E-09, 5.67116E-09, 5.80657E-09, 5.71475E-09, 5.95539E-09,
     5.74664E-09, 5.38969E-09, 5.33465E-09, 5.29517E-09, 5.62841E-09,
     5.27588E-09, 5.52422E-09, 5.43445E-09, 5.35635E-09, 5.24791E-09,
     5.40276E-09, 5.27405E-09, 5.22598E-09, 5.10460E-09},
    {7.74361E-09, 7.33102E-09, 7.21896E-09, 6.97731E-09, 6.66724E-09,
     6.51301E-09, 6.09681E-09, 6.25012E-09, 6.18166E-09, 5.99783E-09,
     5.84761E-09, 5.84289E-09, 5.90497E-09, 6.17375E-09, 5.93616E-09,
     5.39000E-09, 5.59485E-09, 5.54779E-09, 5.44187E-09, 5.61891E-09,
     5.31441E-09, 4.94665E-09, 5.53212E-09, 5.15860E-09, 5.58119E-09,
     5.34975E-09, 5.34582E-09, 5.31509E-09, 5.00830E-09, 5.51759E-09,
     5.19789E-09, 4.83057E-09, 4.92622E-09, 5.14179E-09},
    {7.12746E-09, 6.98682E-09, 7.09989E-09, 6.87762E-09, 6.85341E-09,
     6.27112E-09, 6.17269E-09, 6.00080E-09, 6.42307E-09, 6.33919E-09,
     5.94097E-09, 5.96600E-09, 5.73991E-09, 5.77478E-09, 5.68244E-09,
     5.59763E-09, 5.55361E-09, 5.17886E-09, 5.09190E-09, 5.30716E-09,
     5.15668E-09, 5.22323E-09, 5.03540E-09, 4.93299E-09, 4.95955E-09,
     5.14927E-09, 5.02466E-09, 4.67177E-09, 5.30761E-09, 5.06276E-09,
     5.14670E-09, 4.94730E-09, 4.91065E-09, 4.88321E-09},
    {6.96017E-09, 6.91126E-09, 6.77222E-09, 6.55732E-09, 6.39617E-09,
     6.14173E-09, 6.62524E-09, 6.31014E-09, 6.14099E-09, 6.04772E-09,
     5.32708E-09, 5.22527E-09, 5.40752E-09, 5.34864E-09, 5.75116E-09,
     5.34927E-09, 5.55883E-09, 5.25990E-09, 5.30448E-09, 5.53258E-09,
     5.21882E-09, 5.29107E-09, 5.26327E-09, 5.06678E-09, 5.10712E-09,
     5.25176E-09, 5.07216E-09, 4.77688E-09, 4.79144E-09, 4.83451E-09,
     4.68191E-09, 4.84171E-09, 4.87495E-09, 4.90472E-09},
    {6.91967E-09, 6.79164E-09, 6.73483E-09, 6.67290E-09, 6.12989E-09,
     6.47836E-09, 5.97787E-09, 6.08024E-09, 6.07484E-09, 6.08071E-09,
     5.55753E-09, 5.44271E-09, 5.67671E-09, 5.53133E-09, 5.77549E-09,
     5.56194E-09, 5.54672E-09, 5.46797E-09, 5.31880E-09, 5.23624E-09,
     5.34242E-09, 5.19915E-09, 5.38182E-09, 5.43531E-09, 5.30844E-09,
     5.02624E-09, 5.32610E-09, 4.98572E-09, 5.06218E-09, 5.08463E-09,
     4.88347E-09, 4.96528E-09, 4.86826E-09, 4.73297E-09},
    {7.03498E-09, 6.19562E-09, 6.44971E-09, 6.43163E-09, 6.06871E-09,
     6.13402E-09, 5.62367E-09, 5.75335E-09, 5.71311E-09, 6.40891E-09,
     5.83348E-09, 6.20544E-09, 5.78251E-09, 5.69534E-09, 6.02929E-09,
     5.58617E-09, 5.27219E-09, 5.21124E-09, 5.10468E-09, 5.13360E-09,
     4.97121E-09, 5.08977E-09, 5.27657E-09, 5.09018E-09, 5.20316E-09,
     5.10599E-09, 4.94295E-09, 4.95465E-09, 4.99481E-09, 5.03419E-09,
     4.86110E-09, 4.92689E-09, 5.00087E-09, 4.85332E-09},
    {6.73746E-09, 6.25040E-09, 6.54428E-09, 5.93191E-09, 5.86425E-09,
     5.87354E-09, 6.04971E-09, 5.49638E-09, 5.88622E-09, 5.63985E-09,
     5.87106E-09, 5.80877E-09, 5.35675E-09, 5.23908E-09, 5.20341E-09,
     5.36698E-09, 5.26236E-09, 5.19145E-09, 5.10219E-09, 5.07638E-09,
     4.74011E-09, 4.87605E-09, 4.86360E-09, 4.73168E-09, 4.85134E-09,
     4.77149E-09, 4.94405E-09, 4.76103E-09, 4.86290E-09, 4.67420E-09,
     4.47027E-09, 4.69630E-09, 4.81184E-09, 4.73231E-09},
    {6.50429E-09, 7.01593E-09, 6.17846E-09, 6.38634E-09, 6.19688E-09,
     5.86985E-09, 6.44833E-09, 5.97680E-09, 5.83823E-09, 5.54781E-09,
     5.35076E-09, 5.68131E-09, 5.12738E-09, 5.22410E-09, 5.31298E-09,
     4.95870E-09, 5.32079E-09, 5.24896E-09, 5.19289E-09, 5.21632E-09,
     4.83451E-09, 5.37408E-09, 5.15144E-09, 4.66727E-09, 4.69916E-09,
     4.88929E-09, 5.10999E-09, 4.68274E-09, 4.76095E-09, 4.84827E-09,
     4.76479E-09, 4.38410E-09, 4.47761E-09, 4.54489E-09},
    {6.65970E-09, 6.74363E-09, 5.66052E-09, 6.07395E-09, 6.01438E-09,
     5.76640E-09, 5.81258E-09, 5.33937E-09, 5.81459E-09, 5.39788E-09,
     5.52321E-09, 5.60166E-09, 5.18580E-09, 5.75291E-09, 5.58164E-09,
     5.00997E-09, 5.33826E-09, 5.09899E-09, 5.16472E-09, 5.14214E-09,
     5.10057E-09, 5.00320E-09, 5.21295E-09, 5.06540E-09, 4.93295E-09,
     4.94245E-09, 4.90349E-09, 4.97247E-09, 5.17217E-09, 5.12118E-09,
     5.04024E-09, 4.72254E-09, 4.79345E-09, 4.58339E-09},
    {6.53942E-09, 6.15860E-09, 5.96326E-09, 6.09839E-09, 5.70052E-09,
     5.63845E-09, 5.36955E-09, 5.61137E-09, 5.56877E-09, 5.60936E-09,
     6.07328E-09, 5.16714E-09, 5.43382E-09, 5.25071E-09, 5.54826E-09,
     4.82474E-09, 4.86659E-09, 5.22127E-09, 4.94252E-09, 4.89117E-09,
     4.87348E-09, 4.93595E-09, 5.03458E-09, 4.64388E-09, 4.96339E-09,
     4.86952E-09, 4.91561E-09, 4.54571E-09, 5.03455E-09, 4.75742E-09,
     4.69810E-09, 4.84481E-09, 4.65506E-09, 4.90068E-09},
    {6.35968E-09, 6.49681E-09, 6.26494E-09, 5.62000E-09, 5.66708E-09,
     5.56366E-09, 6.13851E-09, 5.69966E-09, 5.60972E-09, 5.27004E-09,
     5.01984E-09, 5.29959E-09, 5.35556E-09, 4.76683E-09, 5.01270E-09,
     4.86990E-09, 4.93392E-09, 4.96092E-09, 4.89755E-09, 4.78643E-09,
     4.76585E-09, 5.10887E-09, 4.79085E-09, 4.79678E-09, 4.70561E-09,
     4.60578E-09, 4.72482E-09, 4.58187E-09, 4.62344E-09, 4.76144E-09,
     4.67434E-09, 4.71677E-09, 4.47711E-09, 4.81370E-09},
    {6.22736E-09, 6.14202E-09, 6.03402E-09, 5.83860E-09, 5.55587E-09,
     5.52965E-09, 5.33758E-09, 5.33231E-09, 5.53417E-09, 5.40538E-09,
     4.96891E-09, 5.39395E-09, 5.70889E-09, 5.10055E-09, 5.37702E-09,
     5.25893E-09, 5.03405E-09, 5.20070E-09, 5.08826E-09, 5.07819E-09,
     4.75953E-09, 4.96808E-09, 4.83271E-09, 4.42128E-09, 4.63585E-09,
     4.48891E-09, 4.71246E-09, 4.57155E-09, 4.47037E-09, 4.43256E-09,
     4.64001E-09, 4.42069E-09, 4.60202E-09, 4.35583E-09},
    {6.11312E-09, 5.88315E-09, 5.90772E-09, 5.98076E-09, 5.75076E-09,
     4.87691E-09, 5.34574E-09, 5.52606E-09, 5.53180E-09, 5.28400E-09,
     5.65409E-09, 5.32683E-09, 5.36731E-09, 5.10986E-09, 5.14068E-09,
     5.08336E-09, 4.65686E-09, 4.87073E-09, 4.91522E-09, 5.17034E-09,
     4.53967E-09, 4.85580E-09, 5.21304E-09, 4.71364E-09, 5.02899E-09,
     4.88428E-09, 4.71085E-09, 4.84242E-09, 4.59206E-09, 4.56509E-09,
     4.35613E-09, 4.58842E-09, 4.29961E-09, 4.24001E-09},
    {5.97640E-09, 6.33344E-09, 5.68985E-09, 5.77801E-09, 5.54749E-09,
     5.27973E-09, 6.02342E-09, 5.33122E-09, 5.27788E-09, 4.98315E-09,
     5.41894E-09, 4.97495E-09, 5.20842E-09, 4.67984E-09, 4.76523E-09,
     4.67148E-09, 4.75460E-09, 5.30275E-09, 4.71324E-09, 4.70356E-09,
     4.64780E-09, 4.57027E-09, 4.73834E-09, 4.95307E-09, 4.64026E-09,
     4.79187E-09, 4.50934E-09, 4.71600E-09, 4.33520E-09, 4.70263E-09,
     4.53444E-09, 4.66350E-09, 4.57369E-09, 4.82666E-09},
    {6.09232E-09, 5.91423E-09, 5.70968E-09, 5.94059E-09, 5.92187E-09,
     5.30875E-09, 5.19491E-09, 5.54291E-09, 5.40571E-09, 4.96804E-09,
     4.61316E-09, 4.91052E-09, 5.00698E-09, 5.01760E-09, 4.96561E-09,
     4.68558E-09, 4.76094E-09, 5.07413E-09, 4.80522E-09, 4.46095E-09,
     4.65697E-09, 4.45851E-09, 4.50530E-09, 4.60123E-09, 4.39909E-09,
     4.29952E-09, 4.50835E-09, 4.53545E-09, 4.68037E-09, 4.50610E-09,
     4.55402E-09, 4.50214E-09, 4.73727E-09, 4.50130E-09},
    {5.70284E-09, 5.49060E-09, 6.03429E-09, 5.72192E-09, 5.38607E-09,
     5.31193E-09, 4.93998E-09, 5.53538E-09, 5.24603E-09, 5.44191E-09,
     5.03605E-09, 4.91780E-09, 5.58473E-09, 5.29771E-09, 5.12244E-09,
     4.85379E-09, 5.13444E-09, 5.13206E-09, 4.86476E-09, 5.05242E-09,
     4.80585E-09, 4.89912E-09, 4.64457E-09, 4.53317E-09, 4.57344E-09,
     4.56952E-09, 4.35686E-09, 4.54060E-09, 4.21375E-09, 4.33181E-09,
     4.14562E-09, 4.35684E-09, 4.29193E-09, 4.57889E-09},
    {6.07428E-09, 5.88873E-09, 5.50240E-09, 5.47577E-09, 5.38115E-09,
     5.45583E-09, 5.61432E-09, 5.40518E-09, 5.28575E-09, 5.05162E-09,
     5.20976E-09, 5.11518E-09, 5.04550E-09, 4.89731E-09, 4.58748E-09,
     4.76040E-09, 4.82563E-09, 4.69412E-09, 5.03123E-09, 4.51557E-09,
     4.69599E-09, 4.78113E-09, 4.76508E-09, 4.45371E-09, 4.52986E-09,
     4.65355E-09, 4.68454E-09, 4.78003E-09, 4.34958E-09, 4.53655E-09,
     4.40075E-09, 4.37164E-09, 4.23648E-09, 4.29878E-09},
    {5.97737E-09, 5.61349E-09, 5.29292E-09, 5.93967E-09, 5.60217E-09,
     5.31717E-09, 4.96991E-09, 5.21102E-09, 5.31339E-09, 4.83923E-09,
     4.85121E-09, 4.93359E-09, 4.74954E-09, 5.02374E-09, 4.90590E-09,
     5.04306E-09, 4.73160E-09, 4.64747E-09, 4.37651E-09, 4.63977E-09,
     4.69569E-09, 4.53002E-09, 4.40875E-09, 4.47461E-09, 4.42149E-09,
     4.44838E-09, 4.42035E-09, 4.37328E-09, 4.62644E-09, 4.70781E-09,
     4.50387E-09, 4.53072E-09, 4.37384E-09, 4.32973E-09},
    {5.67338E-09, 5.65085E-09, 5.53515E-09, 5.38629E-09, 5.20359E-09,
     5.00433E-09, 5.07041E-09, 5.15386E-09, 5.11833E-09, 4.87610E-09,
     5.03675E-09, 5.23588E-09, 5.27267E-09, 5.30460E-09, 5.41299E-09,
     5.03263E-09, 4.82304E-09, 4.74310E-09, 4.75242E-09, 4.57946E-09,
     4.36106E-09, 4.53770E-09, 4.73853E-09, 4.45675E-09, 4.53377E-09,
     4.28297E-09, 4.25450E-09, 4.17195E-09, 4.43558E-09, 4.47500E-09,
     4.46126E-09, 4.53989E-09, 4.24981E-09, 4.30340E-09},
    {5.52151E-09, 5.63045E-09, 5.48263E-09, 5.24035E-09, 5.34214E-09,
     5.17945E-09, 5.56602E-09, 5.25403E-09, 4.86662E-09, 5.13811E-09,
     4.72206E-09, 5.04282E-09, 5.13037E-09, 4.92635E-09, 4.88923E-09,
     4.56350E-09, 4.76580E-09, 4.43281E-09, 4.70527E-09, 4.67711E-09,
     4.66175E-09, 4.69113E-09, 4.75984E-09, 4.42669E-09, 4.68754E-09,
     4.46927E-09, 4.28624E-09, 4.57526E-09, 4.34635E-09, 4.23721E-09,
     4.26719E-09, 4.30182E-09, 4.28308E-09, 4.32550E-09},
    {5.64525E-09, 5.01200E-09, 5.70620E-09, 5.87797E-09, 5.04177E-09,
     5.18888E-09, 5.16118E-09, 4.87165E-09, 4.63004E-09, 4.76136E-09,
     4.58175E-09, 4.41601E-09, 4.35693E-09, 4.54957E-09, 4.54213E-09,
     4.63567E-09, 4.60879E-09, 4.32745E-09, 4.34088E-09, 4.44891E-09,
     4.29839E-09, 4.34066E-09, 4.58616E-09, 4.31250E-09, 4.31498E-09,
     4.45861E-09, 4.54693E-09, 4.48044E-09, 4.55030E-09, 4.25273E-09,
     4.35585E-09, 4.10665E-09, 4.28584E-09, 4.06243E-09},
    {5.28815E-09, 5.41313E-09, 5.67618E-09, 5.21116E-09, 4.84849E-09,
     4.87172E-09, 5.07384E-09, 5.31286E-09, 5.01571E-09, 4.94540E-09,
     5.10328E-09, 5.20037E-09, 4.99183E-09, 4.64973E-09, 4.58029E-09,
     4.95446E-09, 4.77395E-09, 4.58201E-09, 3.97020E-09, 4.67728E-09,
     4.52856E-09, 4.19468E-09, 4.05080E-09, 4.35944E-09, 4.16186E-09,
     4.26102E-09, 4.28375E-09, 4.43418E-09, 4.45250E-09, 4.47182E-09,
     4.23095E-09, 4.27356E-09, 4.15633E-09, 4.21072E-09},
    {5.65550E-09, 5.49326E-09, 5.03924E-09, 5.17301E-09, 4.77424E-09,
     5.16239E-09, 5.07672E-09, 5.27491E-09, 4.85609E-09, 4.81328E-09,
     4.69347E-09, 4.89503E-09, 4.41860E-09, 4.71267E-09, 4.72373E-09,
     5.00985E-09, 4.64330E-09, 4.66268E-09, 4.83834E-09, 4.47175E-09,
     4.83104E-09, 5.14856E-09, 4.43010E-09, 4.38234E-09, 4.25919E-09,
     4.35785E-09, 4.23513E-09, 4.33802E-09, 3.80564E-09, 3.88929E-09,
     4.07332E-09, 4.18659E-09, 4.36606E-09, 4.33693E-09},
    {5.30724E-09, 5.10627E-09, 5.50628E-09, 5.47355E-09, 4.85094E-09,
     4.72263E-09, 4.42286E-09, 4.75504E-09, 4.45159E-09, 4.65733E-09,
     4.47133E-09, 4.70603E-09, 4.45210E-09, 4.55973E-09, 4.56708E-09,
     4.31918E-09, 4.46598E-09, 4.36335E-09, 4.31879E-09, 4.23865E-09,
     4.35797E-09, 4.31865E-09, 4.40167E-09, 4.52342E-09, 4.67533E-09,
     4.40323E-09, 4.40865E-09, 4.24787E-09, 4.40799E-09, 4.31503E-09,
     4.09842E-09, 4.15954E-09, 4.02329E-09, 3.97116E-09},
    {5.61319E-09, 5.58634E-09, 5.39580E-09, 5.28553E-09, 4.69281E-09,
     4.68583E-09, 4.78445E-09, 4.95030E-09, 4.76371E-09, 4.87051E-09,
     4.72837E-09, 5.17270E-09, 4.91633E-09, 4.96311E-09, 4.76048E-09,
     4.30590E-09, 4.75281E-09, 4.44782E-09, 4.61155E-09, 4.42866E-09,
     4.13451E-09, 3.94311E-09, 4.32612E-09, 4.26604E-09, 4.19595E-09,
     4.54691E-09, 4.17429E-09, 4.40186E-09, 4.28225E-09, 4.11819E-09,
     4.31715E-09, 4.23351E-09, 4.16070E-09, 3.86750E-09},
    {5.79185E-09, 5.04447E-09, 4.94322E-09, 5.20979E-09, 5.08575E-09,
     4.81222E-09, 4.59891E-09, 4.74947E-09, 4.26017E-09, 4.75171E-09,
     4.63213E-09, 4.46539E-09, 4.74142E-09, 4.39205E-09, 4.48692E-09,
     4.43011E-09, 4.58908E-09, 4.81573E-09, 4.47617E-09, 4.84023E-09,
     4.46559E-09, 4.37532E-09, 4.17540E-09, 4.01940E-09, 4.40073E-09,
     3.84937E-09, 4.11944E-09, 4.20488E-09, 4.13756E-09, 4.38800E-09,
     4.10030E-09, 4.23186E-09, 4.21464E-09, 4.40745E-09},
    {5.00399E-09, 5.16742E-09, 5.14487E-09, 5.29848E-09, 4.59518E-09,
     4.44086E-09, 4.50931E-09, 4.54226E-09, 4.31867E-09, 4.82258E-09,
     4.68248E-09, 4.14061E-09, 4.33824E-09, 4.37979E-09, 4.25463E-09,
     4.23061E-09, 4.11696E-09, 4.33682E-09, 4.27182E-09, 4.26064E-09,
     4.47707E-09, 4.40014E-09, 4.07800E-09, 4.29875E-09, 4.42503E-09,
     4.15108E-09, 4.00849E-09, 4.08402E-09, 3.92458E-09, 3.88091E-09,
     3.99571E-09, 4.28738E-09, 4.07460E-09, 4.01508E-09},
    {5.59984E-09, 5.14971E-09, 4.66262E-09, 4.75866E-09, 4.60326E-09,
     4.86994E-09, 4.93958E-09, 4.98985E-09, 4.45952E-09, 4.90416E-09,
     4.82204E-09, 4.70283E-09, 4.74299E-09, 5.09884E-09, 4.52243E-09,
     4.52458E-09, 4.47263E-09, 4.35002E-09, 4.16659E-09, 4.37818E-09,
     4.06317E-09, 4.33722E-09, 4.21726E-09, 4.46733E-09, 4.66933E-09,
     4.32516E-09, 4.03832E-09, 4.24047E-09, 4.18362E-09, 4.20420E-09,
     4.12959E-09, 3.76263E-09, 4.06552E-09, 4.12740E-09},
    {4.95148E-09, 4.81034E-09, 5.04480E-09, 5.20361E-09, 4.80144E-09,
     4.83645E-09, 4.46995E-09, 4.48054E-09, 4.49759E-09, 4.49255E-09,
     4.33408E-09, 4.56069E-09, 4.25788E-09, 4.60757E-09, 4.59553E-09,
     4.81829E-09, 4.60127E-09, 4.35724E-09, 4.74727E-09, 4.54814E-09,
     4.55562E-09, 4.18031E-09, 4.12863E-09, 4.03505E-09, 4.19177E-09,
     4.10447E-09, 4.24848E-09, 4.00303E-09, 4.33916E-09, 4.11519E-09,
     4.05803E-09, 4.06095E-09, 4.26146E-09, 4.04595E-09},
    {5.23766E-09, 5.35735E-09, 4.90634E-09, 4.54903E-09, 4.56570E-09,
     4.74271E-09, 4.26699E-09, 4.42542E-09, 4.50893E-09, 4.62373E-09,
     4.70189E-09, 4.48373E-09, 4.10044E-09, 4.24632E-09, 4.40938E-09,
     3.98055E-09, 4.17034E-09, 4.38295E-09, 4.13994E-09, 4.35559E-09,
     4.12524E-09, 4.34873E-09, 3.85288E-09, 4.25555E-09, 4.03653E-09,
     4.23819E-09, 4.13400E-09, 4.07032E-09, 4.00031E-09, 4.06522E-09,
     3.98901E-09, 4.12511E-09, 3.65154E-09, 4.01514E-09},
    {5.43478E-09, 4.46412E-09, 4.86622E-09, 4.70647E-09, 4.97451E-09,
     4.97392E-09, 4.91560E-09, 4.61520E-09, 4.43757E-09, 4.83560E-09,
     4.76598E-09, 4.45584E-09, 4.51554E-09, 4.80186E-09, 4.52878E-09,
     4.80071E-09, 4.28864E-09, 4.25388E-09, 4.10979E-09, 4.19830E-09,
     4.18079E-09, 4.18981E-09, 4.20039E-09, 4.48217E-09, 4.22056E-09,
     4.09340E-09, 3.96509E-09, 4.23526E-09, 4.19011E-09, 3.80845E-09,
     3.92967E-09, 4.10911E-09, 4.34193E-09, 4.09332E-09},
    {5.04054E-09, 5.01640E-09, 4.85388E-09, 4.73403E-09, 4.66111E-09,
     4.74333E-09, 4.44476E-09, 4.31129E-09, 4.16274E-09, 4.27801E-09,
     4.29304E-09, 4.12378E-09, 4.35176E-09, 4.47322E-09, 4.23721E-09,
     4.59469E-09, 4.15674E-09, 4.74222E-09, 4.46069E-09, 4.02980E-09,
     4.11095E-09, 4.12333E-09, 4.17916E-09, 3.95944E-09, 4.08074E-09,
     4.05320E-09, 4.40526E-09, 4.36199E-09, 3.98288E-09, 3.99898E-09,
     4.08118E-09, 3.60445E-09, 3.88837E-09, 3.82799E-09},
    {5.42105E-09, 4.91224E-09, 4.59139E-09, 4.70613E-09, 4.72007E-09,
     4.79991E-09, 4.95560E-09, 4.59110E-09, 4.62567E-09, 4.46924E-09,
     4.04265E-09, 4.54012E-09, 4.14689E-09, 4.39337E-09, 3.85212E-09,
     4.10790E-09, 4.06613E-09, 4.12398E-09, 4.06714E-09, 3.98489E-09,
     4.39374E-09, 4.46312E-09, 4.25979E-09, 4.14280E-09, 3.79037E-09,
     4.09667E-09, 3.61541E-09, 4.06661E-09, 3.97743E-09, 4.26665E-09,
     4.08930E-09, 4.25670E-09, 3.95333E-09, 3.81024E-09},
    {4.49556E-09, 4.88050E-09, 4.96777E-09, 4.92225E-09, 4.92543E-09,
     4.71179E-09, 4.47217E-09, 4.45194E-09, 4.37979E-09, 4.13230E-09,
     4.28711E-09, 4.60361E-09, 4.41876E-09, 4.59956E-09, 4.57311E-09,
     4.42184E-09, 4.65711E-09, 4.08345E-09, 4.04058E-09, 3.76432E-09,
     4.03057E-09, 4.10048E-09, 3.96137E-09, 4.42596E-09, 4.21483E-09,
     4.21459E-09, 3.92506E-09, 3.78722E-09, 3.90574E-09, 4.11133E-09,
     4.06306E-09, 3.87032E-09, 3.80214E-09, 3.90324E-09},
    {4.97640E-09, 4.79751E-09, 4.67593E-09, 4.39177E-09, 4.58259E-09,
     4.42526E-09, 4.60114E-09, 4.29919E-09, 4.38671E-09, 4.43364E-09,
     4.50565E-09, 4.24032E-09, 4.11394E-09, 4.29086E-09, 4.12251E-09,
     4.39874E-09, 4.53204E-09, 4.02226E-09, 4.09069E-09, 4.15684E-09,
     4.17466E-09, 4.08351E-09, 3.99818E-09, 3.63871E-09, 3.96732E-09,
     3.77513E-09, 4.09411E-09, 3.96876E-09, 4.02722E-09, 3.69466E-09,
     3.88150E-09, 3.68103E-09, 3.96827E-09, 3.86416E-09},
    {4.58163E-09, 4.53752E-09, 4.85822E-09, 4.61290E-09, 4.49548E-09,
     4.74536E-09, 4.61310E-09, 4.67329E-09, 4.70398E-09, 4.88905E-09,
     4.87274E-09, 4.22850E-09, 4.34402E-09, 4.25098E-09, 4.78433E-09,
     4.10880E-09, 4.15127E-09, 4.01133E-09, 3.91108E-09, 4.04771E-09,
     4.24369E-09, 3.88858E-09, 4.18963E-09, 4.00637E-09, 3.92170E-09,
     3.80209E-09, 3.98874E-09, 3.99799E-09, 4.12878E-09, 4.10261E-09,
     3.81228E-09, 3.90270E-09, 3.65534E-09, 3.88707E-09},
    {4.84224E-09, 4.95403E-09, 4.83267E-09, 4.48725E-09, 4.33226E-09,
     4.15279E-09, 4.37042E-09, 4.27248E-09, 4.22788E-09, 4.25488E-09,
     4.44298E-09, 3.92813E-09, 4.31225E-09, 4.19865E-09, 4.22971E-09,
     4.26738E-09, 4.00264E-09, 4.32550E-09, 4.05743E-09, 3.96338E-09,
     3.67732E-09, 3.90417E-09, 4.18590E-09, 4.15002E-09, 3.84558E-09,
     3.99432E-09, 3.65225E-09, 3.65024E-09, 3.82337E-09, 3.80853E-09,
     4.10238E-09, 4.00590E-09, 3.99419E-09, 3.69936E-09},
    {4.70576E-09, 4.62745E-09, 4.62631E-09, 4.51633E-09, 4.69252E-09,
     4.43463E-09, 4.61132E-09, 4.46579E-09, 4.57189E-09, 4.22508E-09,
     4.22435E-09, 4.12016E-09, 3.99351E-09, 4.16891E-09, 3.95072E-09,
     3.97410E-09, 4.45870E-09, 4.31286E-09, 4.49975E-09, 4.16216E-09,
     3.97265E-09, 3.90759E-09, 3.97706E-09, 4.22462E-09, 3.74722E-09,
     3.88985E-09, 4.26851E-09, 4.07723E-09, 3.68209E-09, 3.68057E-09,
     3.72492E-09, 3.80069E-09, 3.80252E-09, 3.75149E-09},
    {4.90054E-09, 4.94943E-09, 4.78539E-09, 4.55387E-09, 4.57651E-09,
     4.40413E-09, 4.42859E-09, 4.43654E-09, 4.32099E-09, 4.45304E-09,
     4.25873E-09, 4.16049E-09, 4.29245E-09, 4.05269E-09, 4.06407E-09,
     3.94776E-09, 3.74690E-09, 4.14284E-09, 3.98530E-09, 4.17654E-09,
     4.20871E-09, 4.20134E-09, 4.02960E-09, 3.67250E-09, 3.78819E-09,
     4.20205E-09, 4.07037E-09, 3.86733E-09, 3.96331E-09, 4.02297E-09,
     3.77996E-09, 3.61764E-09, 3.60489E-09, 3.45043E-09},
    {4.87017E-09, 4.30145E-09, 4.65025E-09, 4.54303E-09, 4.51026E-09,
     4.16074E-09, 4.25661E-09, 4.33152E-09, 4.01626E-09, 4.12028E-09,
     4.10899E-09, 3.90470E-09, 4.08353E-09, 4.00442E-09, 4.05291E-09,
     3.95705E-09, 4.21568E-09, 4.00058E-09, 3.90411E-09, 3.88869E-09,
     4.18161E-09, 4.39792E-09, 3.92597E-09, 3.91501E-09, 3.86521E-09,
     3.75997E-09, 3.72963E-09, 3.82402E-09, 3.61203E-09, 4.03965E-09,
     3.80113E-09, 4.05278E-09, 3.94531E-09, 3.59068E-09},
    {4.67855E-09, 4.57680E-09, 4.60761E-09, 4.43381E-09, 4.56250E-09,
     4.36044E-09, 4.46634E-09, 4.18346E-09, 4.23642E-09, 4.15111E-09,
     4.01053E-09, 4.26285E-09, 3.94162E-09, 4.14951E-09, 3.81090E-09,
     4.01877E-09, 4.12212E-09, 3.95125E-09, 3.85824E-09, 4.12692E-09,
     4.08799E-09, 3.58902E-09, 3.67588E-09, 3.96714E-09, 4.02113E-09,
     3.95827E-09, 3.38373E-09, 3.65722E-09, 3.79135E-09, 3.60681E-09,
     3.45955E-09, 3.81376E-09, 3.83535E-09, 3.61832E-09},
    {4.61641E-09, 4.45379E-09, 4.33054E-09, 4.00326E-09, 4.29144E-09,
     4.38700E-09, 4.32318E-09, 3.94098E-09, 4.39905E-09, 3.99896E-09,
     3.97711E-09, 4.06115E-09, 4.29894E-09, 4.21940E-09, 4.10241E-09,
     3.92429E-09, 4.19194E-09, 3.77999E-09, 3.85122E-09, 4.06884E-09,
     3.91774E-09, 4.06179E-09, 3.78809E-09, 3.84931E-09, 3.79582E-09,
     3.76779E-09, 3.93624E-09, 3.75978E-09, 3.52066E-09, 3.79396E-09,
     4.15667E-09, 3.52781E-09, 3.78024E-09, 3.93416E-09},
    {4.72712E-09, 4.48888E-09, 4.53349E-09, 4.08213E-09, 4.49639E-09,
     4.37122E-09, 4.20773E-09, 3.92916E-09, 4.21257E-09, 3.86160E-09,
     4.12733E-09, 3.89145E-09, 4.12957E-09, 4.05583E-09, 3.98034E-09,
     3.88741E-09, 3.86269E-09, 4.03134E-09, 3.85015E-09, 3.91821E-09,
     4.01609E-09, 4.11959E-09, 3.97690E-09, 4.24264E-09, 3.65667E-09,
     3.98248E-09, 3.69709E-09, 3.68174E-09, 3.89283E-09, 3.88453E-09,
     3.50563E-09, 3.76336E-09, 3.64322E-09, 3.29605E-09},
    {4.49993E-09, 4.67406E-09, 4.25296E-09, 4.20404E-09, 4.39038E-09,
     4.24256E-09, 3.98225E-09, 4.14469E-09, 4.20417E-09, 3.67633E-09,
     4.26492E-09, 4.12960E-09, 4.03656E-09, 3.75182E-09, 3.77102E-09,
     3.67796E-09, 4.26475E-09, 3.70391E-09, 4.16081E-09, 3.93413E-09,
     3.87882E-09, 3.97552E-09, 3.67809E-09, 3.74762E-09, 4.02317E-09,
     3.89967E-09, 3.69248E-09, 3.76040E-09, 3.59241E-09, 3.35399E-09,
     3.89760E-09, 3.78005E-09, 3.83281E-09, 3.59611E-09},
    {4.46153E-09, 4.50871E-09, 4.47677E-09, 4.37684E-09, 4.32336E-09,
     4.23115E-09, 4.06237E-09, 4.09667E-09, 4.11712E-09, 4.02704E-09,
     4.18442E-09, 4.10384E-09, 4.13742E-09, 3.93139E-09, 4.04840E-09,
     4.02059E-09, 3.86396E-09, 3.86253E-09, 3.94604E-09, 3.77355E-09,
     3.93563E-09, 3.66260E-09, 3.71837E-09, 3.72049E-09, 3.83585E-09,
     3.80363E-09, 4.07733E-09, 3.68532E-09, 3.88174E-09, 3.80152E-09,
     3.42373E-09, 3.59231E-09, 3.23077E-09, 3.84605E-09},
    {4.65309E-09, 4.38971E-09, 4.45278E-09, 4.18053E-09, 4.51237E-09,
     4.37599E-09, 3.91549E-09, 4.11601E-09, 4.12504E-09, 3.98417E-09,
     4.00839E-09, 4.22197E-09, 3.83127E-09, 4.07808E-09, 3.89818E-09,
     3.99644E-09, 3.78506E-09, 3.89323E-09, 3.97134E-09, 3.84792E-09,
     3.72757E-09, 4.31025E-09, 3.70541E-09, 3.88656E-09, 3.97992E-09,
     3.88500E-09, 3.55958E-09, 3.72301E-09, 3.48318E-09, 3.71526E-09,
     3.87343E-09, 3.53169E-09, 3.58815E-09, 3.51457E-09},
    {4.64504E-09, 4.40725E-09, 4.49665E-09, 4.14441E-09, 4.40098E-09,
     4.08968E-09, 3.96640E-09, 4.07142E-09, 4.24237E-09, 4.02006E-09,
     3.73993E-09, 3.69669E-09, 3.72687E-09, 3.76714E-09, 4.00856E-09,
     3.92152E-09, 4.13790E-09, 3.64628E-09, 3.70951E-09, 4.20529E-09,
     4.00749E-09, 3.50687E-09, 3.65648E-09, 3.76413E-09, 3.50618E-09,
     3.49581E-09, 3.73994E-09, 3.63860E-09, 3.72322E-09, 3.56310E-09,
     3.57796E-09, 4.01142E-09, 3.50697E-09, 3.50736E-09},
    {4.25479E-09, 4.54295E-09, 4.28363E-09, 4.34227E-09, 4.27031E-09,
     3.98611E-09, 3.99731E-09, 4.00665E-09, 4.00186E-09, 3.99453E-09,
     3.92239E-09, 3.88009E-09, 4.05123E-09, 3.74254E-09, 3.98843E-09,
     3.95226E-09, 3.90987E-09, 3.95039E-09, 4.03167E-09, 3.73555E-09,
     4.18347E-09, 3.60410E-09, 3.81901E-09, 3.66465E-09, 3.96282E-09,
     3.82050E-09, 3.77291E-09, 3.51284E-09, 3.94647E-09, 3.76549E-09,
     3.74021E-09, 3.48954E-09, 3.57479E-09, 3.75731E-09},
    {4.60037E-09, 4.44364E-09, 4.23258E-09, 4.15332E-09, 4.13942E-09,
     4.11906E-09, 4.32515E-09, 4.25610E-09, 4.12678E-09, 4.10134E-09,
     3.77550E-09, 3.72420E-09, 3.87641E-09, 3.88473E-09, 3.70300E-09,
     3.99921E-09, 3.67942E-09, 3.87573E-09, 3.82358E-09, 3.71347E-09,
     3.57088E-09, 3.63660E-09, 4.11724E-09, 3.63631E-09, 3.67093E-09,
     3.70394E-09, 3.74802E-09, 3.61611E-09, 3.42265E-09, 3.65385E-09,
     3.61989E-09, 3.52414E-09, 3.37294E-09, 3.76511E-09},
    {4.08872E-09, 4.26833E-09, 4.07044E-09, 4.01224E-09, 4.02104E-09,
     3.89076E-09, 3.92710E-09, 3.90607E-09, 3.91562E-09, 3.78491E-09,
     4.02170E-09, 3.72166E-09, 3.96757E-09, 3.75273E-09, 3.89906E-09,
     3.87540E-09, 3.59902E-09, 3.71636E-09, 3.78790E-09, 3.90019E-09,
     3.95432E-09, 3.72290E-09, 3.65911E-09, 3.61676E-09, 3.71042E-09,
     3.74324E-09, 3.75264E-09, 3.85973E-09, 3.50634E-09, 3.61200E-09,
     3.63841E-09, 3.52771E-09, 3.62942E-09, 3.52276E-09},
    {4.22651E-09, 4.65108E-09, 4.30026E-09, 4.21994E-09, 4.17375E-09,
     4.13440E-09, 4.07604E-09, 3.94653E-09, 3.98208E-09, 3.83589E-09,
     3.72160E-09, 3.86629E-09, 3.83200E-09, 3.82488E-09, 4.15555E-09,
     3.83559E-09, 3.60744E-09, 3.46753E-09, 3.71160E-09, 3.79181E-09,
     3.65421E-09, 3.53056E-09, 3.43585E-09, 3.43252E-09, 3.59720E-09,
     3.36908E-09, 3.55479E-09, 3.46860E-09, 3.67118E-09, 3.50769E-09,
     3.50971E-09, 3.62442E-09, 3.76413E-09, 3.59468E-09},
    {4.15822E-09, 4.20968E-09, 4.05435E-09, 4.05161E-09, 4.00219E-09,
     3.99041E-09, 3.86788E-09, 3.85520E-09, 4.11510E-09, 3.99327E-09,
     3.86336E-09, 3.86653E-09, 3.64264E-09, 3.46419E-09, 3.91956E-09,
     3.84519E-09, 3.79532E-09, 3.86398E-09, 3.96666E-09, 3.70503E-09,
     3.75407E-09, 3.57231E-09, 3.76167E-09, 3.64635E-09, 3.45817E-09,
     3.78985E-09, 3.91876E-09, 3.70269E-09, 3.62153E-09, 3.67165E-09,
     3.52519E-09, 3.57248E-09, 3.38750E-09, 3.68491E-09},
    {4.56842E-09, 4.38240E-09, 4.31905E-09, 4.33821E-09, 4.29384E-09,
     4.37604E-09, 4.19393E-09, 4.19073E-09, 3.86099E-09, 3.94648E-09,
     3.71973E-09, 3.72804E-09, 4.29149E-09, 3.80606E-09, 3.68404E-09,
     3.69526E-09, 3.51476E-09, 3.92786E-09, 3.74033E-09, 3.42428E-09,
     3.36155E-09, 3.84101E-09, 3.62674E-09, 3.45068E-09, 3.60224E-09,
     3.53883E-09, 3.53354E-09, 3.36994E-09, 3.20636E-09, 3.50400E-09,
     3.79593E-09, 3.39472E-09, 3.80025E-09, 3.26450E-09},
    {4.15592E-09, 3.83393E-09, 4.02711E-09, 4.02067E-09, 3.64735E-09,
     3.60302E-09, 3.82967E-09, 3.87983E-09, 4.12929E-09, 4.08468E-09,
     3.66763E-09, 3.65480E-09, 3.86827E-09, 3.65668E-09, 3.79512E-09,
     4.00427E-09, 3.82612E-09, 3.58597E-09, 3.64058E-09, 3.62000E-09,
     3.47807E-09, 3.56613E-09, 3.36592E-09, 3.76579E-09, 3.67835E-09,
     3.67782E-09, 3.83363E-09, 3.69986E-09, 3.52367E-09, 3.41077E-09,
     3.17464E-09, 3.67045E-09, 3.29164E-09, 3.69628E-09},
    {4.49048E-09, 4.63050E-09, 4.43109E-09, 4.12684E-09, 4.18888E-09,
     4.07327E-09, 4.26224E-09, 3.77041E-09, 3.59604E-09, 3.51750E-09,
     3.69464E-09, 3.77109E-09, 3.86379E-09, 3.72549E-09, 3.61766E-09,
     3.49249E-09, 3.67352E-09, 3.74921E-09, 3.56770E-09, 3.41800E-09,
     3.42736E-09, 3.64045E-09, 3.55371E-09, 3.23324E-09, 3.59241E-09,
     3.74323E-09, 3.47872E-09, 3.27444E-09, 3.51572E-09, 3.88137E-09,
     3.68765E-09, 3.24670E-09, 3.42490E-09, 3.19897E-09},
    {4.06382E-09, 4.21870E-09, 4.16947E-09, 3.64774E-09, 3.80999E-09,
     3.77301E-09, 3.82959E-09, 3.74398E-09, 3.99685E-09, 3.68585E-09,
     3.66427E-09, 3.40068E-09, 3.70325E-09, 3.90440E-09, 3.81424E-09,
     3.54648E-09, 3.65636E-09, 3.60666E-09, 3.64939E-09, 3.73571E-09,
     3.68161E-09, 3.41201E-09, 3.70754E-09, 3.59616E-09, 3.60235E-09,
     3.47728E-09, 3.47916E-09, 3.47778E-09, 3.40367E-09, 3.42964E-09,
     3.51356E-09, 3.47138E-09, 3.46822E-09, 3.43942E-09},
    {4.47936E-09, 4.47500E-09, 4.25782E-09, 4.37941E-09, 4.31803E-09,
     4.21140E-09, 3.85866E-09, 3.54487E-09, 3.66859E-09, 3.69833E-09,
     3.97739E-09, 3.85348E-09, 3.69229E-09, 3.46267E-09, 3.67692E-09,
     4.06877E-09, 3.66871E-09, 3.57330E-09, 3.61541E-09, 3.50126E-09,
     3.60019E-09, 3.34711E-09, 3.52610E-09, 3.86982E-09, 3.27020E-09,
     3.35708E-09, 3.52475E-09, 3.37580E-09, 3.68955E-09, 3.73378E-09,
     3.48180E-09, 3.37111E-09, 3.22231E-09, 3.29900E-09},
    {3.89374E-09, 4.16587E-09, 3.88940E-09, 4.01049E-09, 3.68576E-09,
     3.76610E-09, 3.86193E-09, 4.00905E-09, 3.96580E-09, 3.88009E-09,
     3.67276E-09, 3.67531E-09, 3.95459E-09, 3.74388E-09, 3.59338E-09,
     3.33673E-09, 3.63358E-09, 3.84644E-09, 3.39907E-09, 3.25549E-09,
     3.26049E-09, 3.61770E-09, 3.42410E-09, 3.19115E-09, 3.30675E-09,
     3.80365E-09, 3.55340E-09, 3.48916E-09, 3.35739E-09, 3.46195E-09,
     3.31533E-09, 3.42615E-09, 3.29082E-09, 3.63707E-09},
    {4.42830E-09, 4.26755E-09, 4.23617E-09, 4.19240E-09, 3.82514E-09,
     3.89279E-09, 3.74883E-09, 3.34018E-09, 3.64779E-09, 3.61434E-09,
     4.11143E-09, 3.61131E-09, 3.45134E-09, 3.51491E-09, 3.70238E-09,
     3.69876E-09, 3.43755E-09, 3.64139E-09, 3.58720E-09, 3.65676E-09,
     3.55432E-09, 3.39061E-09, 3.35689E-09, 3.81481E-09, 3.52012E-09,
     3.12267E-09, 3.21880E-09, 3.38149E-09, 3.44701E-09, 3.39940E-09,
     3.22349E-09, 3.46718E-09, 3.42664E-09, 2.92092E-09},
    {4.12908E-09, 3.88850E-09, 4.07043E-09, 3.81871E-09, 3.53839E-09,
     3.72475E-09, 3.79074E-09, 3.62717E-09, 3.93712E-09, 3.50189E-09,
     3.67893E-09, 3.65071E-09, 3.78454E-09, 3.55483E-09, 3.38834E-09,
     3.33671E-09, 3.82732E-09, 3.42514E-09, 3.36165E-09, 3.61699E-09,
     3.64555E-09, 3.39281E-09, 3.55031E-09, 3.28811E-09, 3.64725E-09,
     3.47760E-09, 3.23121E-09, 3.41295E-09, 3.38829E-09, 3.35329E-09,
     3.23651E-09, 2.96803E-09, 3.46035E-09, 3.53501E-09},
    {4.38455E-09, 4.19742E-09, 4.01805E-09, 4.08464E-09, 3.96256E-09,
     3.80529E-09, 3.59108E-09, 3.45522E-09, 3.44208E-09, 3.87091E-09,
     3.76660E-09, 3.58671E-09, 3.39258E-09, 3.60246E-09, 3.63357E-09,
     3.28896E-09, 3.32283E-09, 3.52373E-09, 3.75904E-09, 3.38730E-09,
     3.40324E-09, 3.36477E-09, 3.31730E-09, 3.40709E-09, 3.34502E-09,
     3.52296E-09, 3.60846E-09, 3.35972E-09, 3.33139E-09, 3.43100E-09,
     3.42811E-09, 3.56795E-09, 3.22411E-09, 3.14786E-09},
    {4.31982E-09, 3.96524E-09, 3.78008E-09, 3.84334E-09, 3.80549E-09,
     3.68928E-09, 3.88524E-09, 3.66868E-09, 3.49594E-09, 3.46888E-09,
     3.58142E-09, 3.70094E-09, 3.40576E-09, 3.62623E-09, 3.39116E-09,
     3.81197E-09, 3.56601E-09, 3.23811E-09, 3.36928E-09, 3.78098E-09,
     3.33910E-09, 3.41219E-09, 3.47051E-09, 3.36895E-09, 3.50379E-09,
     3.11355E-09, 3.29741E-09, 3.56808E-09, 3.51763E-09, 3.13866E-09,
     3.16199E-09, 3.22093E-09, 3.46713E-09, 3.39996E-09},
    {4.21009E-09, 4.17335E-09, 3.87905E-09, 3.91408E-09, 3.75014E-09,
     3.51487E-09, 3.63555E-09, 3.53226E-09, 3.70193E-09, 3.59416E-09,
     3.47481E-09, 3.49300E-09, 3.41592E-09, 3.68173E-09, 3.62775E-09,
     3.48722E-09, 3.51239E-09, 3.56809E-09, 3.46837E-09, 3.28142E-09,
     3.37227E-09, 3.58741E-09, 3.15491E-09, 3.32330E-09, 3.19565E-09,
     3.26776E-09, 3.16570E-09, 2.85905E-09, 3.39893E-09, 3.69154E-09,
     3.22345E-09, 3.33231E-09, 3.26948E-09, 3.42285E-09},
    {3.87010E-09, 3.89590E-09, 3.70632E-09, 3.75433E-09, 3.75088E-09,
     3.65679E-09, 3.87602E-09, 3.75479E-09, 3.59837E-09, 3.39038E-09,
     3.67838E-09, 3.69077E-09, 3.43840E-09, 3.32857E-09, 3.37375E-09,
     3.58771E-09, 3.52592E-09, 3.26351E-09, 3.42253E-09, 3.53583E-09,
     3.19121E-09, 3.34416E-09, 3.68250E-09, 3.44337E-09, 3.49745E-09,
     3.05952E-09, 3.44141E-09, 3.76430E-09, 3.16157E-09, 3.35892E-09,
     3.61291E-09, 3.37365E-09, 3.15079E-09, 3.14614E-09},
    {3.70796E-09, 3.89541E-09, 4.00544E-09, 3.87428E-09, 3.73184E-09,
     3.72020E-09, 3.68155E-09, 3.71176E-09, 3.65914E-09, 3.45258E-09,
     3.60508E-09, 3.51546E-09, 3.76190E-09, 3.64588E-09, 3.56024E-09,
     3.41916E-09, 3.58212E-09, 3.41409E-09, 3.41761E-09, 3.42958E-09,
     3.62348E-09, 3.44156E-09, 3.44829E-09, 3.51866E-09, 3.18730E-09,
     3.32812E-09, 3.08918E-09, 3.32361E-09, 3.34206E-09, 3.26164E-09,
     3.17945E-09, 3.14108E-09, 3.40721E-09, 3.23542E-09},
    {3.83102E-09, 3.74238E-09, 3.72231E-09, 3.64482E-09, 3.73795E-09,
     3.92662E-09, 3.74288E-09, 3.52938E-09, 3.61562E-09, 3.39065E-09,
     3.64988E-09, 3.45843E-09, 3.41450E-09, 3.62338E-09, 3.50196E-09,
     3.22300E-09, 3.36765E-09, 3.33285E-09, 3.59344E-09, 3.20648E-09,
     3.14552E-09, 3.32993E-09, 3.06599E-09, 2.98676E-09, 3.17250E-09,
     3.57010E-09, 3.28003E-09, 3.09278E-09, 3.18057E-09, 3.33103E-09,
     3.22097E-09, 3.02319E-09, 3.19630E-09, 3.31807E-09},
    {4.17755E-09, 4.12310E-09, 3.72562E-09, 3.77170E-09, 3.34015E-09,
     3.75143E-09, 3.92624E-09, 3.56287E-09, 3.50489E-09, 3.40035E-09,
     3.58956E-09, 3.40826E-09, 3.18219E-09, 3.37309E-09, 3.59601E-09,
     3.48285E-09, 3.56986E-09, 3.30707E-09, 3.28790E-09, 3.35234E-09,
     3.18999E-09, 2.98284E-09, 3.25636E-09, 3.23513E-09, 3.37523E-09,
     3.07959E-09, 3.24125E-09, 3.36074E-09, 3.07346E-09, 3.35929E-09,
     3.27346E-09, 3.26028E-09, 2.85469E-09, 3.09165E-09},
    {3.66653E-09, 3.69488E-09, 3.60789E-09, 3.95566E-09, 3.66690E-09,
     3.74122E-09, 3.49492E-09, 3.48161E-09, 3.66688E-09, 3.54248E-09,
     3.47645E-09, 3.42246E-09, 3.17393E-09, 3.22429E-09, 3.51525E-09,
     3.21410E-09, 3.40553E-09, 3.31853E-09, 3.36090E-09, 3.30411E-09,
     3.64512E-09, 3.59303E-09, 3.21425E-09, 3.22202E-09, 3.28632E-09,
     3.18453E-09, 3.23612E-09, 3.15012E-09, 3.39448E-09, 3.24992E-09,
     3.18412E-09, 3.35943E-09, 3.45013E-09, 3.08573E-09},
    {3.98279E-09, 3.83237E-09, 3.82715E-09, 3.71465E-09, 3.46125E-09,
     3.49264E-09, 3.63468E-09, 3.66040E-09, 3.45750E-09, 3.52582E-09,
     3.46141E-09, 3.61991E-09, 3.37352E-09, 3.51976E-09, 3.21287E-09,
     3.50827E-09, 3.22593E-09, 3.39381E-09, 3.37222E-09, 3.34813E-09,
     2.87946E-09, 3.30340E-09, 3.27423E-09, 3.12958E-09, 2.96276E-09,
     3.36959E-09, 3.17346E-09, 3.06110E-09, 3.36827E-09, 3.16204E-09,
     3.21299E-09, 2.93627E-09, 3.11927E-09, 3.38622E-09},
    {3.96790E-09, 3.63440E-09, 3.56912E-09, 3.60746E-09, 3.92936E-09,
     3.48039E-09, 3.60743E-09, 3.47099E-09, 3.18322E-09, 3.57188E-09,
     3.33841E-09, 3.57484E-09, 3.22899E-09, 3.51161E-09, 3.20789E-09,
     3.34422E-09, 3.36054E-09, 3.30495E-09, 3.03163E-09, 3.21599E-09,
     3.46542E-09, 3.13631E-09, 3.23593E-09, 3.29079E-09, 3.34448E-09,
     3.13726E-09, 2.95476E-09, 3.33125E-09, 2.81167E-09, 2.96724E-09,
     3.28004E-09, 3.39266E-09, 3.08743E-09, 2.88559E-09},
    {3.80890E-09, 3.81514E-09, 3.75221E-09, 3.49458E-09, 3.72781E-09,
     3.40240E-09, 3.70509E-09, 3.60109E-09, 3.41006E-09, 3.39859E-09,
     3.67395E-09, 3.36930E-09, 3.28961E-09, 3.60537E-09, 3.26338E-09,
     3.12095E-09, 3.42729E-09, 3.50095E-09, 3.39917E-09, 3.30575E-09,
     3.24969E-09, 3.21100E-09, 3.19709E-09, 3.05334E-09, 3.27171E-09,
     3.08235E-09, 3.17190E-09, 3.10264E-09, 3.79994E-09, 3.32309E-09,
     2.82947E-09, 3.34863E-09, 3.19123E-09, 3.31313E-09},
    {3.61148E-09, 3.58965E-09, 3.61835E-09, 3.46919E-09, 3.78513E-09,
     3.46410E-09, 3.45331E-09, 3.43249E-09, 3.47856E-09, 3.41309E-09,
     3.28416E-09, 3.40874E-09, 3.47953E-09, 3.45312E-09, 3.54616E-09,
     3.27184E-09, 3.15206E-09, 3.21218E-09, 2.87547E-09, 3.37145E-09,
     3.15805E-09, 3.23793E-09, 3.29325E-09, 3.25848E-09, 3.12845E-09,
     3.26782E-09, 3.12693E-09, 2.95582E-09, 2.65824E-09, 3.10984E-09,
     3.44131E-09, 2.83032E-09, 3.10864E-09, 3.19843E-09},
    {3.65790E-09, 3.83594E-09, 3.93284E-09, 3.37900E-09, 3.62819E-09,
     3.07150E-09, 3.75031E-09, 3.58713E-09, 3.12104E-09, 3.60656E-09,
     3.54629E-09, 3.40110E-09, 3.31077E-09, 3.37403E-09, 3.30349E-09,
     3.32241E-09, 3.44110E-09, 3.27761E-09, 3.42825E-09, 3.15402E-09,
     3.03465E-09, 3.05214E-09, 3.23371E-09, 3.17485E-09, 3.38582E-09,
     2.96000E-09, 3.18305E-09, 3.32958E-09, 3.24382E-09, 3.18089E-09,
     3.02864E-09, 3.42215E-09, 2.91368E-09, 3.11104E-09},
    {3.74906E-09, 3.64053E-09, 3.67838E-09, 3.38082E-09, 3.52815E-09,
     3.51550E-09, 3.62600E-09, 3.32643E-09, 3.47192E-09, 3.43312E-09,
     3.34012E-09, 3.60005E-09, 3.23858E-09, 3.23096E-09, 3.27977E-09,
     3.29076E-09, 3.08244E-09, 3.16710E-09, 3.18093E-09, 3.36702E-09,
     3.45259E-09, 3.05220E-09, 3.13528E-09, 3.12782E-09, 3.00710E-09,
     3.14291E-09, 3.06586E-09, 2.91860E-09, 2.96589E-09, 3.09640E-09,
     3.12092E-09, 3.02662E-09, 3.22055E-09, 3.12945E-09},
    {3.73465E-09, 3.62858E-09, 3.81996E-09, 3.45773E-09, 3.47680E-09,
     3.41658E-09, 3.79463E-09, 3.36983E-09, 3.36482E-09, 3.43090E-09,
     3.41576E-09, 2.92444E-09, 3.37690E-09, 3.40860E-09, 3.11734E-09,
     3.21650E-09, 3.17751E-09, 2.98953E-09, 3.01578E-09, 2.95109E-09,
     2.94242E-09, 3.20297E-09, 3.10869E-09, 3.37759E-09, 3.24364E-09,
     3.02741E-09, 3.15728E-09, 3.33297E-09, 2.98097E-09, 3.19006E-09,
     3.20815E-09, 2.94026E-09, 2.91396E-09, 3.19681E-09},
    {3.55448E-09, 3.82365E-09, 3.77023E-09, 3.54411E-09, 3.44673E-09,
     3.61195E-09, 3.49831E-09, 3.44040E-09, 3.44472E-09, 3.35083E-09,
     3.20348E-09, 3.57770E-09, 2.98662E-09, 3.05490E-09, 3.27027E-09,
     3.10726E-09, 3.26472E-09, 3.32547E-09, 3.16559E-09, 3.13502E-09,
     3.33836E-09, 3.18784E-09, 3.08573E-09, 3.00226E-09, 3.11619E-09,
     3.13394E-09, 3.00501E-09, 3.04237E-09, 3.09992E-09, 2.91222E-09,
     3.12195E-09, 3.04388E-09, 3.17636E-09, 3.19535E-09},
    {3.74482E-09, 3.89119E-09, 3.67648E-09, 3.51624E-09, 3.50242E-09,
     3.45721E-09, 3.61531E-09, 3.55143E-09, 3.02836E-09, 3.33717E-09,
     3.25469E-09, 3.09628E-09, 3.43111E-09, 3.08277E-09, 3.13285E-09,
     3.37647E-09, 3.26331E-09, 3.06169E-09, 3.34071E-09, 3.22203E-09,
     3.05185E-09, 3.06592E-09, 3.09975E-09, 3.02939E-09, 2.96968E-09,
     2.99811E-09, 3.19714E-09, 3.05474E-09, 2.92060E-09, 3.13250E-09,
     2.83762E-09, 2.95869E-09, 3.17724E-09, 2.83657E-09},
    {3.61300E-09, 3.55477E-09, 3.42501E-09, 3.66723E-09, 3.51192E-09,
     3.32493E-09, 3.52988E-09, 3.38953E-09, 3.28478E-09, 3.20183E-09,
     3.44502E-09, 3.28436E-09, 3.05306E-09, 3.23919E-09, 3.08409E-09,
     3.13926E-09, 3.20010E-09, 3.19561E-09, 3.00364E-09, 3.30803E-09,
     2.90918E-09, 3.02958E-09, 3.35442E-09, 3.15269E-09, 3.03666E-09,
     2.86106E-09, 2.73848E-09, 2.98170E-09, 2.89732E-09, 3.17232E-09,
     2.98306E-09, 2.95947E-09, 2.87439E-09, 3.30891E-09},
    {3.59943E-09, 3.69958E-09, 3.54566E-09, 3.38497E-09, 3.41067E-09,
     3.68689E-09, 3.28604E-09, 3.26451E-09, 3.40643E-09, 3.18211E-09,
     3.45008E-09, 3.17312E-09, 3.14724E-09, 3.22880E-09, 3.11982E-09,
     3.17123E-09, 3.14023E-09, 3.24788E-09, 3.05425E-09, 3.02741E-09,
     3.31909E-09, 3.05914E-09, 2.61173E-09, 2.96752E-09, 3.16814E-09,
     3.09984E-09, 3.11225E-09, 3.22284E-09, 3.22698E-09, 2.91989E-09,
     3.13723E-09, 3.08814E-09, 3.13653E-09, 2.69271E-09},
    {3.60038E-09, 3.37600E-09, 3.28675E-09, 3.67070E-09, 3.76048E-09,
     3.40885E-09, 3.43851E-09, 3.59388E-09, 3.35264E-09, 3.18270E-09,
     3.33346E-09, 3.12637E-09, 3.10688E-09, 3.24612E-09, 3.22902E-09,
     3.29644E-09, 3.21759E-09, 3.06527E-09, 2.93581E-09, 2.90765E-09,
     2.97283E-09, 2.91559E-09, 3.28168E-09, 2.99335E-09, 2.85923E-09,
     2.97276E-09, 2.87185E-09, 2.82069E-09, 2.77209E-09, 2.86686E-09,
     2.77810E-09, 2.78819E-09, 2.82812E-09, 3.04998E-09},
    {3.14469E-09, 3.58882E-09, 3.70007E-09, 3.48518E-09, 3.47710E-09,
     3.56643E-09, 3.28685E-09, 3.30257E-09, 3.28815E-09, 3.12428E-09,
     3.09240E-09, 3.14207E-09, 3.16161E-09, 2.89315E-09, 3.00571E-09,
     3.20686E-09, 2.86172E-09, 3.18834E-09, 3.11151E-09, 3.28102E-09,
     3.22871E-09, 3.01103E-09, 2.92202E-09, 3.05890E-09, 3.03165E-09,
     3.01126E-09, 3.13093E-09, 2.86616E-09, 3.02132E-09, 3.07154E-09,
     3.16175E-09, 3.04198E-09, 3.11556E-09, 3.05084E-09},
    {3.74808E-09, 3.94128E-09, 3.39123E-09, 3.54339E-09, 3.80357E-09,
     3.30136E-09, 3.10253E-09, 3.40757E-09, 3.13217E-09, 3.47131E-09,
     3.33109E-09, 3.13266E-09, 3.16272E-09, 3.24320E-09, 3.12208E-09,
     2.92022E-09, 3.12591E-09, 2.84464E-09, 3.05082E-09, 2.74852E-09,
     2.96607E-09, 3.07781E-09, 3.01023E-09, 2.80881E-09, 3.17679E-09,
     2.71875E-09, 2.98176E-09, 3.26344E-09, 2.97276E-09, 2.86809E-09,
     2.75822E-09, 2.87744E-09, 2.90118E-09, 2.65247E-09},
    {3.32542E-09, 3.67582E-09, 3.66080E-09, 3.53665E-09, 3.39605E-09,
     3.46777E-09, 3.19817E-09, 3.28103E-09, 3.30493E-09, 3.08283E-09,
     3.09859E-09, 3.40841E-09, 3.26150E-09, 3.03567E-09, 3.27648E-09,
     3.02278E-09, 2.84351E-09, 3.07679E-09, 3.12896E-09, 3.03309E-09,
     2.91377E-09, 2.95421E-09, 2.99414E-09, 3.00104E-09, 2.77722E-09,
     3.14780E-09, 2.98665E-09, 2.73004E-09, 2.84618E-09, 3.11159E-09,
     3.08401E-09, 2.74571E-09, 3.06480E-09, 2.95689E-09},
    {3.62616E-09, 3.81027E-09, 3.48894E-09, 3.32164E-09, 3.77057E-09,
     3.04347E-09, 3.30429E-09, 3.56092E-09, 3.04131E-09, 3.21290E-09,
     3.08084E-09, 3.16590E-09, 3.04609E-09, 3.10606E-09, 3.03590E-09,
     3.10341E-09, 3.22975E-09, 3.09464E-09, 2.89782E-09, 2.95435E-09,
     3.07978E-09, 2.88149E-09, 2.89778E-09, 3.04133E-09, 2.98307E-09,
     2.94002E-09, 2.86217E-09, 2.87460E-09, 2.80692E-09, 2.84402E-09,
     2.92232E-09, 3.02088E-09, 2.67884E-09, 2.87039E-09},
    {3.77203E-09, 3.37599E-09, 3.45641E-09, 3.29793E-09, 3.27622E-09,
     3.55699E-09, 3.55223E-09, 3.12592E-09, 3.47965E-09, 3.11619E-09,
     3.30347E-09, 3.06052E-09, 3.02525E-09, 3.00803E-09, 2.97301E-09,
     2.90544E-09, 2.91628E-09, 2.96938E-09, 3.02462E-09, 2.97675E-09,
     2.83049E-09, 2.97872E-09, 2.88884E-09, 2.80257E-09, 2.97811E-09,
     2.86456E-09, 3.00606E-09, 2.90850E-09, 3.02840E-09, 2.87737E-09,
     2.66651E-09, 2.88192E-09, 2.73342E-09, 2.80051E-09},
    {3.64477E-09, 3.33132E-09, 3.40639E-09, 3.32530E-09, 3.48551E-09,
     3.38562E-09, 3.11440E-09, 3.36224E-09, 3.04057E-09, 3.24022E-09,
     3.11307E-09, 3.03400E-09, 3.27700E-09, 3.02114E-09, 3.26140E-09,
     3.14551E-09, 2.94060E-09, 2.88187E-09, 2.92370E-09, 3.03721E-09,
     3.25466E-09, 2.85954E-09, 2.96656E-09, 3.02509E-09, 2.95949E-09,
     2.86969E-09, 2.93664E-09, 2.77106E-09, 2.92074E-09, 2.84919E-09,
     3.05439E-09, 2.80448E-09, 2.82185E-09, 2.67838E-09}};

static double rainbow_wide_data[91][34] = {
    {3.58685E-10, 3.48228E-10, 3.36051E-10, 3.00770E-10, 3.27365E-10,
     3.25426E-10, 3.29410E-10, 3.29891E-10, 3.29337E-10, 3.20903E-10,
     3.23110E-10, 3.54515E-10, 3.30589E-10, 3.43912E-10, 3.13041E-10,
     3.24819E-10, 3.26589E-10, 3.12378E-10, 3.17057E-10, 3.22773E-10,
     3.09205E-10, 3.55955E-10, 3.06838E-10, 3.46165E-10, 2.92362E-10,
     3.18249E-10, 3.38138E-10, 3.27013E-10, 3.42300E-10, 3.33269E-10,
     3.29835E-10, 3.11932E-10, 3.23791E-10, 3.28900E-10},
    {3.46730E-10, 3.33070E-10, 3.40391E-10, 3.39684E-10, 3.02997E-10,
     3.25524E-10, 3.37724E-10, 3.11956E-10, 3.23188E-10, 3.34740E-10,
     3.16331E-10, 3.08275E-10, 3.25791E-10, 3.09820E-10, 3.23866E-10,
     3.14202E-10, 3.31176E-10, 3.28228E-10, 3.25235E-10, 3.11229E-10,
     3.11559E-10, 3.16401E-10, 3.19367E-10, 2.99843E-10, 3.65472E-10,
     3.42237E-10, 3.36735E-10, 3.24541E-10, 3.20638E-10, 3.12622E-10,
     3.32340E-10, 3.15966E-10, 3.13152E-10, 2.91126E-10},
    {3.29307E-10, 3.23245E-10, 3.10160E-10, 3.19065E-10, 3.30134E-10,
     3.45120E-10, 3.05475E-10, 3.14601E-10, 3.24693E-10, 3.12801E-10,
     3.09091E-10, 3.19933E-10, 3.02480E-10, 3.07783E-10, 3.15119E-10,
     3.21244E-10, 3.04207E-10, 3.10850E-10, 2.96702E-10, 3.09690E-10,
     3.38474E-10, 3.10609E-10, 3.23369E-10, 3.15099E-10, 2.95861E-10,
     3.00802E-10, 3.01893E-10, 3.16779E-10, 3.13484E-10, 3.29617E-10,
     3.21617E-10, 3.03396E-10, 2.98076E-10, 3.16989E-10},
    {3.23952E-10, 3.14357E-10, 3.19273E-10, 3.25873E-10, 2.90621E-10,
     2.99393E-10, 3.38477E-10, 3.15932E-10, 3.11309E-10, 3.29370E-10,
     3.19260E-10, 3.10605E-10, 3.15300E-10, 3.14637E-10, 3.25020E-10,
     2.90167E-10, 3.20963E-10, 3.14472E-10, 3.31691E-10, 3.13662E-10,
     2.85348E-10, 3.03382E-10, 3.04277E-10, 3.10642E-10, 3.18413E-10,
     2.93136E-10, 3.02539E-10, 2.96251E-10, 2.96788E-10, 2.97326E-10,
     3.01310E-10, 3.09585E-10, 3.09961E-10, 3.31116E-10},
    {2.99852E-10, 3.31802E-10, 3.19487E-10, 3.36276E-10, 3.33945E-10,
     3.30521E-10, 3.04542E-10, 3.04772E-10, 3.06935E-10, 3.07582E-10,
     3.01868E-10, 3.10440E-10, 2.96502E-10, 3.14261E-10, 2.90297E-10,
     3.12040E-10, 2.82911E-10, 2.82676E-10, 2.99603E-10, 2.89590E-10,
     2.64620E-10, 2.86230E-10, 2.98817E-10, 3.09549E-10, 3.31665E-10,
     3.21248E-10, 3.53984E-10, 2.98758E-10, 3.18712E-10, 3.10399E-10,
     2.94761E-10, 2.97672E-10, 3.06054E-10, 2.85166E-10},
    {3.01645E-10, 3.35572E-10, 3.06371E-10, 2.99680E-10, 3.35027E-10,
     3.18705E-10, 2.93376E-10, 2.99485E-10, 3.02771E-10, 2.97583E-10,
     2.95222E-10, 3.10867E-10, 2.96096E-10, 2.87267E-10, 2.88418E-10,
     3.07695E-10, 2.94054E-10, 2.79852E-10, 2.93163E-10, 2.84085E-10,
     3.08501E-10, 2.91788E-10, 3.01975E-10, 2.90052E-10, 2.89794E-10,
     3.24008E-10, 3.01035E-10, 3.08041E-10, 3.04459E-10, 3.07396E-10,
     3.09624E-10, 2.75622E-10, 2.94416E-10, 2.65147E-10},
    {3.07432E-10, 3.16411E-10, 3.10969E-10, 2.98061E-10, 3.27681E-10,
     3.12279E-10, 2.96549E-10, 3.09033E-10, 3.00781E-10, 2.85745E-10,
     2.90348E-10, 3.04691E-10, 2.88300E-10, 2.80092E-10, 2.85096E-10,
     3.07384E-10, 2.96304E-10, 2.78748E-10, 2.99997E-10, 2.92518E-10,
     3.10272E-10, 2.91171E-10, 3.02946E-10, 2.87873E-10, 2.75116E-10,
     3.15171E-10, 2.80060E-10, 3.11283E-10, 2.95524E-10, 2.89408E-10,
     3.04938E-10, 2.74599E-10, 2.92219E-10, 2.54633E-10},
    {2.89737E-10, 3.18382E-10, 2.97577E-10, 3.11131E-10, 3.29241E-10,
     3.17599E-10, 2.84529E-10, 2.90239E-10, 3.01851E-10, 2.97815E-10,
     2.88195E-10, 2.96156E-10, 2.87920E-10, 2.88308E-10, 2.71102E-10,
     3.01292E-10, 2.86407E-10, 2.75411E-10, 2.86128E-10, 2.85831E-10,
     3.10324E-10, 2.82623E-10, 3.04791E-10, 2.74617E-10, 2.71354E-10,
     3.05843E-10, 2.71613E-10, 2.95851E-10, 2.94576E-10, 3.03772E-10,
     2.89179E-10, 2.56453E-10, 2.82777E-10, 2.69623E-10},
    {3.20158E-10, 3.01964E-10, 3.17837E-10, 3.29137E-10, 2.91981E-10,
     2.89485E-10, 3.00032E-10, 2.95577E-10, 3.00947E-10, 2.96596E-10,
     2.88755E-10, 3.01472E-10, 2.89486E-10, 2.92008E-10, 2.66976E-10,
     3.01097E-10, 2.78396E-10, 2.71732E-10, 2.75735E-10, 2.71247E-10,
     2.79638E-10, 2.74487E-10, 2.99032E-10, 2.76611E-10, 2.85751E-10,
     3.11100E-10, 2.89119E-10, 3.06906E-10, 2.99781E-10, 3.06497E-10,
     2.95592E-10, 2.79784E-10, 2.94915E-10, 2.60623E-10},
    {2.95633E-10, 3.07543E-10, 2.87046E-10, 2.87371E-10, 2.81314E-10,
     3.10326E-10, 3.15769E-10, 2.93708E-10, 2.86132E-10, 3.12472E-10,
     3.02811E-10, 2.96925E-10, 3.00083E-10, 3.00382E-10, 2.98672E-10,
     2.74403E-10, 2.85404E-10, 2.83885E-10, 2.91610E-10, 2.85537E-10,
     2.43446E-10, 2.88560E-10, 2.80918E-10, 2.90434E-10, 3.14775E-10,
     3.03955E-10, 3.18380E-10, 2.78513E-10, 3.10067E-10, 2.92136E-10,
     2.91016E-10, 2.93085E-10, 3.04344E-10, 2.68575E-10},
    {3.06149E-10, 3.11689E-10, 3.05688E-10, 3.11225E-10, 3.12584E-10,
     2.83025E-10, 2.84261E-10, 3.19394E-10, 3.05320E-10, 2.71912E-10,
     2.88361E-10, 2.88395E-10, 2.82613E-10, 2.79550E-10, 2.90555E-10,
     2.90884E-10, 2.99020E-10, 3.02881E-10, 3.04710E-10, 2.85530E-10,
     3.08995E-10, 2.94133E-10, 2.83120E-10, 2.87830E-10, 2.76708E-10,
     2.55983E-10, 2.72436E-10, 2.81801E-10, 2.83611E-10, 2.92611E-10,
     2.93051E-10, 3.20413E-10, 3.00788E-10, 2.90346E-10},
    {3.06801E-10, 3.35129E-10, 3.10763E-10, 2.74052E-10, 3.15900E-10,
     3.06567E-10, 3.10745E-10, 2.79437E-10, 2.93008E-10, 3.25240E-10,
     2.87844E-10, 2.81200E-10, 2.92517E-10, 2.78280E-10, 2.95661E-10,
     2.98338E-10, 2.92523E-10, 2.75892E-10, 2.71198E-10, 2.84402E-10,
     2.83217E-10, 2.89105E-10, 2.84685E-10, 2.84703E-10, 2.82967E-10,
     2.78932E-10, 2.82922E-10, 2.83630E-10, 2.95604E-10, 2.93581E-10,
     2.83884E-10, 2.46946E-10, 2.84607E-10, 2.99855E-10},
    {2.72440E-10, 2.97386E-10, 3.03571E-10, 2.93579E-10, 3.18160E-10,
     3.02410E-10, 3.08694E-10, 2.59684E-10, 2.95385E-10, 3.00230E-10,
     2.85702E-10, 3.22560E-10, 2.82434E-10, 3.08661E-10, 2.75019E-10,
     2.82974E-10, 2.60828E-10, 2.97352E-10, 2.87983E-10, 2.86081E-10,
     3.02807E-10, 2.90427E-10, 2.95956E-10, 2.62845E-10, 2.83889E-10,
     2.88594E-10, 2.80259E-10, 2.84804E-10, 2.72159E-10, 2.80743E-10,
     2.95454E-10, 3.10811E-10, 2.99433E-10, 2.45670E-10},
    {3.09179E-10, 2.72577E-10, 3.07573E-10, 2.90050E-10, 3.18490E-10,
     3.12392E-10, 3.06629E-10, 2.73895E-10, 3.14864E-10, 3.14954E-10,
     2.73312E-10, 2.84124E-10, 2.82686E-10, 3.03393E-10, 3.21461E-10,
     2.82441E-10, 2.89591E-10, 2.97454E-10, 2.77805E-10, 2.83345E-10,
     2.74635E-10, 2.91640E-10, 2.90985E-10, 3.04016E-10, 2.92037E-10,
     3.17914E-10, 3.18839E-10, 2.79546E-10, 2.86395E-10, 3.15337E-10,
     3.15073E-10, 2.96179E-10, 2.84643E-10, 3.35565E-10},
    {2.92594E-10, 3.07634E-10, 3.03065E-10, 3.05526E-10, 3.25278E-10,
     3.27991E-10, 3.02854E-10, 2.72545E-10, 3.04302E-10, 3.14483E-10,
     3.05308E-10, 2.64180E-10, 3.01806E-10, 2.71038E-10, 2.91663E-10,
     2.97026E-10, 2.84569E-10, 2.43706E-10, 2.87364E-10, 2.89414E-10,
     2.88939E-10, 3.08668E-10, 2.87532E-10, 2.91165E-10, 2.72371E-10,
     2.92539E-10, 3.14749E-10, 2.72658E-10, 2.90314E-10, 2.88067E-10,
     2.84873E-10, 2.79161E-10, 3.10570E-10, 2.81209E-10},
    {3.02374E-10, 2.89835E-10, 2.81026E-10, 3.15574E-10, 2.83092E-10,
     3.12994E-10, 2.71332E-10, 2.89110E-10, 3.21035E-10, 3.06895E-10,
     3.29668E-10, 2.79304E-10, 3.05842E-10, 2.87618E-10, 2.83210E-10,
     2.73141E-10, 2.84701E-10, 2.84346E-10, 2.87938E-10, 2.91847E-10,
     2.77112E-10, 2.96094E-10, 2.96136E-10, 2.85641E-10, 2.77674E-10,
     2.68352E-10, 2.56310E-10, 2.66178E-10, 3.11052E-10, 2.79443E-10,
     2.98926E-10, 2.76274E-10, 2.75350E-10, 2.72631E-10},
    {3.18540E-10, 2.85636E-10, 2.73990E-10, 2.82878E-10, 2.93816E-10,
     2.83598E-10, 3.03853E-10, 2.79491E-10, 2.62937E-10, 2.75656E-10,
     2.98936E-10, 2.70332E-10, 3.08920E-10, 2.63993E-10, 3.06909E-10,
     2.50477E-10, 3.03740E-10, 3.05995E-10, 3.00272E-10, 3.19829E-10,
     2.94634E-10, 2.77055E-10, 3.09816E-10, 2.74236E-10, 3.24044E-10,
     2.95099E-10, 2.99999E-10, 2.72133E-10, 3.10819E-10, 2.58859E-10,
     2.82328E-10, 2.56948E-10, 2.84453E-10, 2.98576E-10},
    {2.79892E-10, 3.09485E-10, 2.76837E-10, 2.92299E-10, 3.30559E-10,
     3.32267E-10, 3.31119E-10, 3.04955E-10, 2.92547E-10, 2.77493E-10,
     2.63054E-10, 2.93802E-10, 2.95240E-10, 3.01196E-10, 3.08458E-10,
     2.82452E-10, 3.27969E-10, 3.05724E-10, 3.01583E-10, 2.67658E-10,
     3.24318E-10, 2.69576E-10, 3.15081E-10, 3.01536E-10, 3.02518E-10,
     2.75163E-10, 3.05563E-10, 2.79309E-10, 2.60064E-10, 2.64968E-10,
     2.85362E-10, 2.94676E-10, 2.84968E-10, 2.93534E-10},
    {3.20669E-10, 2.91961E-10, 2.97086E-10, 3.22344E-10, 3.06446E-10,
     3.45071E-10, 2.94343E-10, 3.27458E-10, 3.27869E-10, 2.67013E-10,
     3.08422E-10, 3.37380E-10, 2.77146E-10, 3.37878E-10, 2.92804E-10,
     2.74045E-10, 3.22595E-10, 3.21516E-10, 3.44277E-10, 2.89121E-10,
     2.75629E-10, 2.59923E-10, 2.85100E-10, 3.08874E-10, 2.67570E-10,
     3.03730E-10, 3.00070E-10, 2.68527E-10, 2.58228E-10, 2.67559E-10,
     3.11266E-10, 3.11201E-10, 2.74541E-10, 2.78620E-10},
    {3.10932E-10, 3.48905E-10, 3.26176E-10, 3.10123E-10, 3.29341E-10,
     3.08447E-10, 3.16007E-10, 3.04767E-10, 3.09918E-10, 3.48931E-10,
     2.60798E-10, 3.29840E-10, 3.15283E-10, 3.14610E-10, 2.67740E-10,
     3.08940E-10, 3.15363E-10, 2.86642E-10, 3.03157E-10, 3.09603E-10,
     3.02450E-10, 2.76808E-10, 3.20012E-10, 2.96014E-10, 2.78650E-10,
     3.02991E-10, 2.51875E-10, 2.91300E-10, 2.69291E-10, 2.62275E-10,
     3.12491E-10, 2.72236E-10, 2.76776E-10, 2.90291E-10},
    {3.63253E-10, 3.37807E-10, 3.42609E-10, 2.81321E-10, 3.17871E-10,
     3.25150E-10, 3.09758E-10, 3.17003E-10, 3.21659E-10, 3.44845E-10,
     3.54237E-10, 2.93385E-10, 3.35671E-10, 3.40133E-10, 3.13593E-10,
     2.93742E-10, 3.16574E-10, 2.96534E-10, 3.03660E-10, 3.06690E-10,
     3.29260E-10, 3.39141E-10, 2.76694E-10, 2.89162E-10, 2.99620E-10,
     3.01186E-10, 2.76875E-10, 2.82938E-10, 3.03215E-10, 2.77428E-10,
     3.09541E-10, 2.98890E-10, 2.79009E-10, 3.08329E-10},
    {3.55524E-10, 3.54480E-10, 3.47204E-10, 3.48659E-10, 3.48717E-10,
     3.45061E-10, 3.34729E-10, 3.29191E-10, 3.02745E-10, 3.43434E-10,
     3.05470E-10, 3.38449E-10, 3.43425E-10, 3.06256E-10, 3.30995E-10,
     3.14723E-10, 2.86187E-10, 3.05772E-10, 3.35623E-10, 3.17545E-10,
     2.99179E-10, 3.09251E-10, 2.92622E-10, 3.02084E-10, 3.14818E-10,
     2.93816E-10, 3.15972E-10, 2.95354E-10, 3.20613E-10, 2.84314E-10,
     3.06399E-10, 3.15192E-10, 3.07332E-10, 2.59997E-10},
    {3.71394E-10, 3.91114E-10, 3.55637E-10, 3.64466E-10, 3.68488E-10,
     3.82530E-10, 4.17527E-10, 3.24607E-10, 3.91866E-10, 3.08667E-10,
     3.71750E-10, 3.48860E-10, 3.42333E-10, 3.57663E-10, 3.46803E-10,
     3.09449E-10, 3.07643E-10, 3.27493E-10, 3.19092E-10, 3.04244E-10,
     2.98243E-10, 3.40636E-10, 2.92316E-10, 3.04736E-10, 3.02427E-10,
     3.22403E-10, 3.10680E-10, 2.94930E-10, 2.68257E-10, 3.09529E-10,
     3.32824E-10, 3.03208E-10, 3.01293E-10, 2.81832E-10},
    {4.16801E-10, 3.92291E-10, 3.71524E-10, 3.62063E-10, 3.66038E-10,
     3.67138E-10, 3.90156E-10, 3.64979E-10, 3.48705E-10, 3.70795E-10,
     3.09811E-10, 3.85532E-10, 4.04102E-10, 3.12317E-10, 3.55698E-10,
     3.26978E-10, 2.95846E-10, 3.54623E-10, 3.51126E-10, 3.47335E-10,
     3.30299E-10, 3.42317E-10, 3.53349E-10, 3.17396E-10, 3.44435E-10,
     2.86037E-10, 3.45779E-10, 2.75152E-10, 3.31730E-10, 2.95538E-10,
     3.10350E-10, 2.98960E-10, 3.30755E-10, 3.21711E-10},
    {4.46557E-10, 3.93356E-10, 4.25145E-10, 3.96161E-10, 4.60852E-10,
     3.81986E-10, 4.20923E-10, 3.79506E-10, 3.72425E-10, 3.04450E-10,
     3.80645E-10, 3.32313E-10, 3.92541E-10, 3.27408E-10, 3.42805E-10,
     3.42801E-10, 3.01867E-10, 3.21742E-10, 3.67948E-10, 3.34739E-10,
     3.41222E-10, 3.51433E-10, 3.12929E-10, 2.97552E-10, 3.22553E-10,
     3.10115E-10, 3.47253E-10, 3.36598E-10, 3.32390E-10, 3.47696E-10,
     3.70291E-10, 3.29539E-10, 2.85001E-10, 2.98636E-10},
    {4.41422E-10, 4.41656E-10, 4.13359E-10, 4.45025E-10, 4.33780E-10,
     4.07188E-10, 4.29034E-10, 4.13012E-10, 3.54848E-10, 3.60792E-10,
     3.80705E-10, 4.06641E-10, 3.53778E-10, 3.21289E-10, 4.09714E-10,
     3.41550E-10, 3.54331E-10, 3.48047E-10, 3.66661E-10, 3.98453E-10,
     3.67487E-10, 3.73265E-10, 3.32661E-10, 3.32095E-10, 3.65898E-10,
     3.33787E-10, 3.60509E-10, 3.40095E-10, 3.66537E-10, 3.68216E-10,
     3.64260E-10, 3.24311E-10, 3.07382E-10, 3.14707E-10},
    {4.81710E-10, 5.45568E-10, 4.53308E-10, 4.93018E-10, 4.85565E-10,
     4.36401E-10, 4.34232E-10, 4.21804E-10, 4.34454E-10, 3.46431E-10,
     4.16835E-10, 3.87323E-10, 3.79991E-10, 4.28641E-10, 3.93204E-10,
     3.77744E-10, 3.73625E-10, 3.36358E-10, 3.61246E-10, 3.84821E-10,
     3.92486E-10, 3.75077E-10, 3.77753E-10, 3.74138E-10, 3.65872E-10,
     3.72038E-10, 3.94857E-10, 3.51377E-10, 3.44094E-10, 4.02275E-10,
     3.88717E-10, 3.72445E-10, 3.75072E-10, 3.15272E-10},
    {6.22076E-10, 5.42121E-10, 5.24312E-10, 4.85015E-10, 5.07718E-10,
     5.06548E-10, 4.57959E-10, 4.27753E-10, 4.86401E-10, 4.75245E-10,
     4.77905E-10, 4.31577E-10, 3.75158E-10, 4.92864E-10, 4.24874E-10,
     4.58837E-10, 3.86540E-10, 3.87273E-10, 3.93365E-10, 4.50082E-10,
     4.49071E-10, 4.48272E-10, 4.00882E-10, 4.02042E-10, 3.64232E-10,
     4.11441E-10, 4.10632E-10, 3.96944E-10, 3.84081E-10, 3.54549E-10,
     3.99185E-10, 3.44807E-10, 3.79142E-10, 3.94836E-10},
    {6.49813E-10, 6.20604E-10, 6.14930E-10, 5.70420E-10, 5.09748E-10,
     5.57940E-10, 4.97337E-10, 5.25935E-10, 5.00705E-10, 5.05914E-10,
     4.68129E-10, 4.60310E-10, 4.84913E-10, 4.65195E-10, 4.46166E-10,
     4.10196E-10, 4.21033E-10, 4.63041E-10, 4.29916E-10, 4.26550E-10,
     4.58967E-10, 4.58635E-10, 3.63399E-10, 4.67190E-10, 4.83736E-10,
     4.45037E-10, 4.51374E-10, 4.43448E-10, 4.07383E-10, 4.36589E-10,
     4.14759E-10, 3.81882E-10, 4.28427E-10, 3.98232E-10},
    {6.96831E-10, 6.03578E-10, 5.88551E-10, 6.51785E-10, 5.61348E-10,
     6.02022E-10, 5.75572E-10, 5.91100E-10, 4.68160E-10, 5.35249E-10,
     4.81379E-10, 5.54033E-10, 5.30245E-10, 5.16292E-10, 4.79508E-10,
     4.78074E-10, 4.82840E-10, 5.12395E-10, 5.14814E-10, 4.23488E-10,
     5.18191E-10, 4.43485E-10, 4.64248E-10, 4.27485E-10, 4.56926E-10,
     4.85186E-10, 4.52300E-10, 5.10954E-10, 4.76546E-10, 4.75844E-10,
     4.64865E-10, 4.42724E-10, 4.40792E-10, 4.42089E-10},
    {7.53703E-10, 5.99059E-10, 6.21818E-10, 7.16047E-10, 6.81808E-10,
     5.81629E-10, 5.70477E-10, 6.33344E-10, 6.91537E-10, 5.39410E-10,
     5.97890E-10, 5.34078E-10, 5.73758E-10, 5.27641E-10, 5.75378E-10,
     5.30732E-10, 5.80132E-10, 6.37982E-10, 5.54494E-10, 5.43699E-10,
     5.02345E-10, 5.49687E-10, 5.28215E-10, 5.00259E-10, 5.29764E-10,
     5.38405E-10, 4.58416E-10, 4.98222E-10, 5.24476E-10, 5.61160E-10,
     5.18381E-10, 4.43256E-10, 4.47562E-10, 4.62786E-10},
    {8.54952E-10, 8.06637E-10, 7.64932E-10, 7.69104E-10, 7.95178E-10,
     6.28759E-10, 7.01654E-10, 6.59224E-10, 6.80857E-10, 7.27852E-10,
     6.20897E-10, 6.51931E-10, 5.96698E-10, 5.98672E-10, 6.09980E-10,
     5.70340E-10, 5.94486E-10, 6.10457E-10, 6.13080E-10, 5.98938E-10,
     5.55266E-10, 5.66584E-10, 5.34212E-10, 5.74600E-10, 5.42718E-10,
     5.24004E-10, 5.43902E-10, 5.67700E-10, 5.14631E-10, 5.20660E-10,
     5.39691E-10, 5.05057E-10, 5.57009E-10, 5.80932E-10},
    {8.29922E-10, 9.85380E-10, 8.83360E-10, 8.68866E-10, 8.09978E-10,
     8.08904E-10, 8.15376E-10, 7.53826E-10, 6.80519E-10, 7.43133E-10,
     7.29504E-10, 7.38807E-10, 6.01873E-10, 6.43068E-10, 7.07405E-10,
     7.41989E-10, 7.04531E-10, 6.61945E-10, 6.90467E-10, 6.87636E-10,
     6.45882E-10, 6.49404E-10, 7.39061E-10, 6.14499E-10, 6.89294E-10,
     5.39909E-10, 6.72590E-10, 6.66153E-10, 6.56194E-10, 6.08192E-10,
     6.03093E-10, 6.51811E-10, 5.83882E-10, 5.74091E-10},
    {1.07549E-09, 9.56084E-10, 9.79119E-10, 8.69789E-10, 9.08256E-10,
     8.89464E-10, 9.12712E-10, 8.51642E-10, 8.35454E-10, 8.21076E-10,
     7.96480E-10, 8.88444E-10, 7.51972E-10, 7.20796E-10, 7.50396E-10,
     7.62056E-10, 7.28340E-10, 7.47023E-10, 6.62667E-10, 6.85923E-10,
     7.17395E-10, 7.29821E-10, 7.12532E-10, 7.43143E-10, 6.74668E-10,
     7.31830E-10, 7.23234E-10, 6.55142E-10, 6.75906E-10, 7.38319E-10,
     6.09160E-10, 7.21150E-10, 6.74615E-10, 6.58195E-10},
    {9.59254E-10, 1.17360E-09, 1.31587E-09, 1.20980E-09, 1.05657E-09,
     1.11652E-09, 9.70849E-10, 9.09520E-10, 9.75141E-10, 8.13678E-10,
     8.94641E-10, 9.11705E-10, 9.17072E-10, 9.12691E-10, 8.42249E-10,
     9.10008E-10, 8.88289E-10, 7.65813E-10, 8.51719E-10, 8.31097E-10,
     8.36580E-10, 8.29969E-10, 7.68787E-10, 7.21886E-10, 7.48683E-10,
     7.61442E-10, 7.86354E-10, 7.11729E-10, 8.07637E-10, 6.91830E-10,
     7.64928E-10, 7.56352E-10, 7.77751E-10, 7.95521E-10},
    {3.32485E-09, 2.58363E-09, 1.66464E-09, 9.68886E-10, 7.95365E-10,
     8.60587E-10, 1.08232E-09, 1.27756E-09, 1.16758E-09, 1.14453E-09,
     1.18707E-09, 1.12858E-09, 1.09058E-09, 1.07891E-09, 9.61823E-10,
     9.52558E-10, 1.00513E-09, 8.90908E-10, 9.17201E-10, 9.44696E-10,
     8.78162E-10, 8.24116E-10, 9.27840E-10, 8.07246E-10, 8.41975E-10,
     9.21709E-10, 9.18187E-10, 7.95478E-10, 7.97002E-10, 8.22806E-10,
     8.88318E-10, 8.27835E-10, 9.03624E-10, 7.81794E-10},
    {1.03202E-09, 1.60289E-09, 2.34935E-09, 2.71813E-09, 3.19628E-09,
     2.75428E-09, 2.30176E-09, 1.89957E-09, 1.43248E-09, 1.07328E-09,
     8.74565E-10, 7.76578E-10, 7.84878E-10, 8.07341E-10, 9.32872E-10,
     8.96979E-10, 1.04590E-09, 1.05652E-09, 1.08864E-09, 1.09765E-09,
     1.15961E-09, 1.08398E-09, 1.18125E-09, 1.10828E-09, 1.12638E-09,
     1.09552E-09, 1.11576E-09, 9.88642E-10, 1.04800E-09, 1.09921E-09,
     1.04354E-09, 1.07471E-09, 9.77453E-10, 1.00414E-09},
    {2.71640E-10, 3.69277E-10, 4.08691E-10, 6.49086E-10, 9.75487E-10,
     1.32475E-09, 1.75031E-09, 2.18655E-09, 2.81225E-09, 2.88373E-09,
     3.00335E-09, 3.07205E-09, 2.78168E-09, 2.66746E-09, 2.35149E-09,
     2.21970E-09, 1.79642E-09, 1.56945E-09, 1.38233E-09, 1.15101E-09,
     1.08029E-09, 1.02728E-09, 9.20218E-10, 8.99322E-10, 8.44540E-10,
     7.82575E-10, 7.34401E-10, 7.62355E-10, 7.84198E-10, 8.34766E-10,
     7.53880E-10, 9.30411E-10, 7.97927E-10, 8.36549E-10},
    {2.50326E-10, 2.53094E-10, 2.68118E-10, 2.74745E-10, 2.71128E-10,
     3.20044E-10, 3.83590E-10, 4.64719E-10, 6.44239E-10, 7.50905E-10,
     8.84616E-10, 1.24062E-09, 1.56991E-09, 1.58733E-09, 1.88488E-09,
     2.24423E-09, 2.57952E-09, 2.70237E-09, 2.78033E-09, 2.63199E-09,
     2.81563E-09, 2.88171E-09, 2.73484E-09, 2.62242E-09, 2.51868E-09,
     2.68249E-09, 2.66286E-09, 2.61076E-09, 2.19834E-09, 2.32756E-09,
     2.25216E-09, 2.07967E-09, 1.95901E-09, 1.81803E-09},
    {2.38369E-10, 2.38385E-10, 2.54165E-10, 2.46575E-10, 2.48697E-10,
     2.52966E-10, 2.47022E-10, 2.57779E-10, 2.56304E-10, 2.87556E-10,
     3.06895E-10, 3.38503E-10, 3.85337E-10, 4.76767E-10, 4.98399E-10,
     5.68825E-10, 7.29926E-10, 7.78670E-10, 8.87084E-10, 1.08410E-09,
     1.24274E-09, 1.36452E-09, 1.40719E-09, 1.50772E-09, 1.73019E-09,
     1.82531E-09, 2.05629E-09, 2.16509E-09, 2.41075E-09, 2.20514E-09,
     2.48255E-09, 2.66912E-09, 2.53011E-09, 2.49723E-09},
    {2.57218E-10, 2.51372E-10, 2.55654E-10, 2.49380E-10, 2.50266E-10,
     2.50135E-10, 2.56369E-10, 2.45893E-10, 2.68547E-10, 2.51136E-10,
     2.44637E-10, 2.81089E-10, 2.97897E-10, 3.18041E-10, 3.19274E-10,
     3.18116E-10, 3.70621E-10, 3.96197E-10, 3.63440E-10, 4.32165E-10,
     4.86015E-10, 5.37115E-10, 4.81606E-10, 5.67634E-10, 6.02519E-10,
     6.34006E-10, 7.43270E-10, 7.52203E-10, 8.12977E-10, 9.46625E-10,
     9.47281E-10, 1.03670E-09, 7.56571E-10, 9.07722E-10},
    {2.46495E-10, 2.57158E-10, 2.55002E-10, 2.46784E-10, 2.37489E-10,
     2.47844E-10, 2.73978E-10, 2.59631E-10, 2.53421E-10, 2.72125E-10,
     3.29734E-10, 3.58676E-10, 3.45747E-10, 3.42996E-10, 3.46039E-10,
     3.41152E-10, 3.50140E-10, 3.46083E-10, 3.94465E-10, 3.92346E-10,
     3.62426E-10, 3.98499E-10, 3.73425E-10, 3.62454E-10, 3.39445E-10,
     3.42215E-10, 3.75216E-10, 3.41080E-10, 3.48804E-10, 3.64784E-10,
     3.45338E-10, 3.82674E-10, 4.20317E-10, 4.17825E-10},
    {2.58495E-10, 2.52538E-10, 2.55936E-10, 2.49743E-10, 2.63800E-10,
     2.68632E-10, 2.59526E-10, 3.14057E-10, 3.31433E-10, 3.24325E-10,
     3.34252E-10, 3.77638E-10, 3.73841E-10, 3.93756E-10, 3.53855E-10,
     3.62389E-10, 3.86978E-10, 3.58422E-10, 3.26495E-10, 3.29187E-10,
     3.19425E-10, 3.22117E-10, 3.10603E-10, 2.91316E-10, 2.72778E-10,
     2.80638E-10, 2.80675E-10, 2.75909E-10, 2.78184E-10, 2.88372E-10,
     2.63197E-10, 2.73922E-10, 2.42169E-10, 2.44480E-10},
    {2.63834E-10, 2.74028E-10, 2.82642E-10, 2.99477E-10, 3.51074E-10,
     3.43677E-10, 3.44732E-10, 3.55603E-10, 3.92940E-10, 3.93191E-10,
     3.99561E-10, 4.02167E-10, 3.64962E-10, 3.45576E-10, 3.28759E-10,
     3.14492E-10, 3.03894E-10, 3.02681E-10, 2.88552E-10, 2.80674E-10,
     2.64560E-10, 2.72179E-10, 2.62605E-10, 2.56365E-10, 2.82682E-10,
     2.70779E-10, 2.78151E-10, 2.55983E-10, 2.60257E-10, 2.62642E-10,
     2.59753E-10, 2.76654E-10, 2.69687E-10, 2.55705E-10},
    {2.78405E-10, 2.96843E-10, 3.35056E-10, 3.71369E-10, 3.35800E-10,
     3.86913E-10, 3.94067E-10, 3.68234E-10, 3.77412E-10, 3.61826E-10,
     3.04909E-10, 3.15497E-10, 3.08413E-10, 2.83973E-10, 2.74642E-10,
     2.70135E-10, 2.60743E-10, 2.67633E-10, 2.51530E-10, 2.64429E-10,
     2.81432E-10, 2.71998E-10, 2.78325E-10, 2.67287E-10, 3.00782E-10,
     2.75379E-10, 2.74105E-10, 2.79055E-10, 2.73318E-10, 2.53227E-10,
     2.68623E-10, 2.61598E-10, 2.63980E-10, 2.60809E-10},
    {3.39396E-10, 3.43980E-10, 3.65576E-10, 4.33559E-10, 4.18282E-10,
     4.04420E-10, 3.89881E-10, 3.31230E-10, 3.19594E-10, 2.94618E-10,
     2.74799E-10, 2.81176E-10, 2.81976E-10, 2.79892E-10, 2.57734E-10,
     2.75883E-10, 2.82928E-10, 2.65584E-10, 2.90633E-10, 2.92041E-10,
     2.83964E-10, 2.69594E-10, 2.57968E-10, 2.76320E-10, 2.58243E-10,
     2.69847E-10, 2.68060E-10, 2.61713E-10, 2.50726E-10, 2.62328E-10,
     2.51705E-10, 2.49900E-10, 2.52507E-10, 2.61026E-10},
    {4.26705E-10, 4.37379E-10, 4.45864E-10, 4.02138E-10, 3.69453E-10,
     3.34511E-10, 3.20483E-10, 2.95984E-10, 2.70195E-10, 3.12779E-10,
     3.01879E-10, 3.01430E-10, 2.95631E-10, 2.65251E-10, 2.82013E-10,
     2.76271E-10, 3.09762E-10, 2.67767E-10, 2.72407E-10, 2.82152E-10,
     2.71780E-10, 2.67413E-10, 2.69721E-10, 2.57071E-10, 2.56776E-10,
     2.73354E-10, 2.68033E-10, 2.61185E-10, 2.82964E-10, 2.80056E-10,
     2.86726E-10, 2.69515E-10, 2.97307E-10, 2.80698E-10},
    {4.55496E-10, 4.56807E-10, 3.59314E-10, 3.21148E-10, 3.03257E-10,
     2.87184E-10, 3.25562E-10, 3.08160E-10, 3.02232E-10, 2.91889E-10,
     2.94956E-10, 2.92384E-10, 2.92016E-10, 2.77421E-10, 2.87200E-10,
     3.53100E-10, 3.09915E-10, 3.50614E-10, 3.23915E-10, 3.64100E-10,
     4.07215E-10, 4.60236E-10, 4.70318E-10, 4.93464E-10, 6.02819E-10,
     6.32048E-10, 6.95965E-10, 8.65359E-10, 9.42288E-10, 1.01582E-09,
     1.24594E-09, 1.32622E-09, 1.40715E-09, 1.59415E-09},
    {4.36359E-10, 4.16802E-10, 3.39797E-10, 3.41563E-10, 3.34522E-10,
     3.54694E-10, 3.50035E-10, 4.36450E-10, 4.76634E-10, 6.11427E-10,
     8.98177E-10, 1.04916E-09, 1.44298E-09, 1.79539E-09, 2.34707E-09,
     2.95204E-09, 3.93330E-09, 4.66237E-09, 5.50233E-09, 6.58148E-09,
     7.60916E-09, 8.97075E-09, 9.92664E-09, 1.10893E-08, 1.15960E-08,
     1.25643E-08, 1.34208E-08, 1.47667E-08, 1.52043E-08, 1.59599E-08,
     1.64652E-08, 1.71194E-08, 1.73814E-08, 1.81328E-08},
    {5.44551E-10, 9.07059E-10, 1.38372E-09, 2.40977E-09, 4.16826E-09,
     6.60576E-09, 9.47194E-09, 1.29145E-08, 1.67309E-08, 1.86646E-08,
     2.16086E-08, 2.24142E-08, 2.34085E-08, 2.21944E-08, 2.10846E-08,
     1.91808E-08, 1.76435E-08, 1.61110E-08, 1.41889E-08, 1.20416E-08,
     1.12347E-08, 9.32950E-09, 7.66612E-09, 7.23792E-09, 6.32417E-09,
     5.99227E-09, 5.41733E-09, 4.99666E-09, 4.93274E-09, 4.46083E-09,
     4.49826E-09, 4.53885E-09, 4.36552E-09, 4.37964E-09},
    {2.18100E-08, 2.57031E-08, 2.42889E-08, 1.80022E-08, 1.12176E-08,
     6.82462E-09, 5.20552E-09, 5.41789E-09, 6.60177E-09, 7.75777E-09,
     8.46386E-09, 8.83168E-09, 9.25372E-09, 8.73351E-09, 8.53330E-09,
     8.34561E-09, 7.80391E-09, 7.76370E-09, 7.58854E-09, 7.28010E-09,
     7.05268E-09, 6.88015E-09, 6.71986E-09, 6.79214E-09, 6.67338E-09,
     6.43044E-09, 6.70316E-09, 6.47441E-09, 6.28188E-09, 6.49488E-09,
     6.39939E-09, 6.59619E-09, 6.37340E-09, 5.97935E-09},
    {1.01695E-08, 8.94326E-09, 8.06145E-09, 7.78801E-09, 7.21433E-09,
     7.42551E-09, 7.15936E-09, 7.31987E-09, 6.90451E-09, 6.71795E-09,
     6.57535E-09, 6.78637E-09, 6.16969E-09, 6.21162E-09, 6.11878E-09,
     6.10041E-09, 6.09751E-09, 5.93123E-09, 5.99619E-09, 5.71848E-09,
     5.65612E-09, 5.93265E-09, 5.65081E-09, 5.69275E-09, 6.16505E-09,
     5.57741E-09, 5.58328E-09, 5.75233E-09, 5.96873E-09, 5.66767E-09,
     5.62549E-09, 5.59169E-09, 5.49902E-09, 5.44874E-09},
    {7.03498E-09, 6.19562E-09, 6.44971E-09, 6.43163E-09, 6.06871E-09,
     6.13402E-09, 5.62367E-09, 5.75335E-09, 5.71311E-09, 6.40891E-09,
     5.83348E-09, 6.20544E-09, 5.78251E-09, 5.69534E-09, 6.02929E-09,
     5.58617E-09, 5.27219E-09, 5.21124E-09, 5.10468E-09, 5.13360E-09,
     4.97121E-09, 5.08977E-09, 5.27657E-09, 5.09018E-09, 5.20316E-09,
     5.10599E-09, 4.94295E-09, 4.95465E-09, 4.99481E-09, 5.03419E-09,
     4.86110E-09, 4.92689E-09, 5.00087E-09, 4.85332E-09},
    {5.70284E-09, 5.49060E-09, 6.03429E-09, 5.72192E-09, 5.38607E-09,
     5.31193E-09, 4.93998E-09, 5.53538E-09, 5.24603E-09, 5.44191E-09,
     5.03605E-09, 4.91780E-09, 5.58473E-09, 5.29771E-09, 5.12244E-09,
     4.85379E-09, 5.13444E-09, 5.13206E-09, 4.86476E-09, 5.05242E-09,
     4.80585E-09, 4.89912E-09, 4.64457E-09, 4.53317E-09, 4.57344E-09,
     4.56952E-09, 4.35686E-09, 4.54060E-09, 4.21375E-09, 4.33181E-09,
     4.14562E-09, 4.35684E-09, 4.29193E-09, 4.57889E-09},
    {5.79185E-09, 5.04447E-09, 4.94322E-09, 5.20979E-09, 5.08575E-09,
     4.81222E-09, 4.59891E-09, 4.74947E-09, 4.26017E-09, 4.75171E-09,
     4.63213E-09, 4.46539E-09, 4.74142E-09, 4.39205E-09, 4.48692E-09,
     4.43011E-09, 4.58908E-09, 4.81573E-09, 4.47617E-09, 4.84023E-09,
     4.46559E-09, 4.37532E-09, 4.17540E-09, 4.01940E-09, 4.40073E-09,
     3.84937E-09, 4.11944E-09, 4.20488E-09, 4.13756E-09, 4.38800E-09,
     4.10030E-09, 4.23186E-09, 4.21464E-09, 4.40745E-09},
    {4.58163E-09, 4.53752E-09, 4.85822E-09, 4.61290E-09, 4.49548E-09,
     4.74536E-09, 4.61310E-09, 4.67329E-09, 4.70398E-09, 4.88905E-09,
     4.87274E-09, 4.22850E-09, 4.34402E-09, 4.25098E-09, 4.78433E-09,
     4.10880E-09, 4.15127E-09, 4.01133E-09, 3.91108E-09, 4.04771E-09,
     4.24369E-09, 3.88858E-09, 4.18963E-09, 4.00637E-09, 3.92170E-09,
     3.80209E-09, 3.98874E-09, 3.99799E-09, 4.12878E-09, 4.10261E-09,
     3.81228E-09, 3.90270E-09, 3.65534E-09, 3.88707E-09},
    {4.65309E-09, 4.38971E-09, 4.45278E-09, 4.18053E-09, 4.51237E-09,
     4.37599E-09, 3.91549E-09, 4.11601E-09, 4.12504E-09, 3.98417E-09,
     4.00839E-09, 4.22197E-09, 3.83127E-09, 4.07808E-09, 3.89818E-09,
     3.99644E-09, 3.78506E-09, 3.89323E-09, 3.97134E-09, 3.84792E-09,
     3.72757E-09, 4.31025E-09, 3.70541E-09, 3.88656E-09, 3.97992E-09,
     3.88500E-09, 3.55958E-09, 3.72301E-09, 3.48318E-09, 3.71526E-09,
     3.87343E-09, 3.53169E-09, 3.58815E-09, 3.51457E-09},
    {4.06382E-09, 4.21870E-09, 4.16947E-09, 3.64774E-09, 3.80999E-09,
     3.77301E-09, 3.82959E-09, 3.74398E-09, 3.99685E-09, 3.68585E-09,
     3.66427E-09, 3.40068E-09, 3.70325E-09, 3.90440E-09, 3.81424E-09,
     3.54648E-09, 3.65636E-09, 3.60666E-09, 3.64939E-09, 3.73571E-09,
     3.68161E-09, 3.41201E-09, 3.70754E-09, 3.59616E-09, 3.60235E-09,
     3.47728E-09, 3.47916E-09, 3.47778E-09, 3.40367E-09, 3.42964E-09,
     3.51356E-09, 3.47138E-09, 3.46822E-09, 3.43942E-09},
    {3.83102E-09, 3.74238E-09, 3.72231E-09, 3.64482E-09, 3.73795E-09,
     3.92662E-09, 3.74288E-09, 3.52938E-09, 3.61562E-09, 3.39065E-09,
     3.64988E-09, 3.45843E-09, 3.41450E-09, 3.62338E-09, 3.50196E-09,
     3.22300E-09, 3.36765E-09, 3.33285E-09, 3.59344E-09, 3.20648E-09,
     3.14552E-09, 3.32993E-09, 3.06599E-09, 2.98676E-09, 3.17250E-09,
     3.57010E-09, 3.28003E-09, 3.09278E-09, 3.18057E-09, 3.33103E-09,
     3.22097E-09, 3.02319E-09, 3.19630E-09, 3.31807E-09},
    {3.55448E-09, 3.82365E-09, 3.77023E-09, 3.54411E-09, 3.44673E-09,
     3.61195E-09, 3.49831E-09, 3.44040E-09, 3.44472E-09, 3.35083E-09,
     3.20348E-09, 3.57770E-09, 2.98662E-09, 3.05490E-09, 3.27027E-09,
     3.10726E-09, 3.26472E-09, 3.32547E-09, 3.16559E-09, 3.13502E-09,
     3.33836E-09, 3.18784E-09, 3.08573E-09, 3.00226E-09, 3.11619E-09,
     3.13394E-09, 3.00501E-09, 3.04237E-09, 3.09992E-09, 2.91222E-09,
     3.12195E-09, 3.04388E-09, 3.17636E-09, 3.19535E-09},
    {3.64477E-09, 3.33132E-09, 3.40639E-09, 3.32530E-09, 3.48551E-09,
     3.38562E-09, 3.11440E-09, 3.36224E-09, 3.04057E-09, 3.24022E-09,
     3.11307E-09, 3.03400E-09, 3.27700E-09, 3.02114E-09, 3.26140E-09,
     3.14551E-09, 2.94060E-09, 2.88187E-09, 2.92370E-09, 3.03721E-09,
     3.25466E-09, 2.85954E-09, 2.96656E-09, 3.02509E-09, 2.95949E-09,
     2.86969E-09, 2.93664E-09, 2.77106E-09, 2.92074E-09, 2.84919E-09,
     3.05439E-09, 2.80448E-09, 2.82185E-09, 2.67838E-09},
    {3.30662E-09, 3.27168E-09, 3.28157E-09, 2.77232E-09, 3.14555E-09,
     3.18389E-09, 3.03970E-09, 3.21825E-09, 2.80538E-09, 3.05772E-09,
     2.93375E-09, 3.06635E-09, 2.68774E-09, 3.05971E-09, 2.89173E-09,
     2.81846E-09, 2.65906E-09, 2.95880E-09, 2.71155E-09, 2.74190E-09,
     2.78826E-09, 2.76929E-09, 2.89844E-09, 2.58094E-09, 2.82057E-09,
     2.88687E-09, 2.73031E-09, 2.76098E-09, 2.64070E-09, 2.61822E-09,
     2.67997E-09, 2.71932E-09, 2.46885E-09, 2.73956E-09},
    {3.20953E-09, 2.91060E-09, 2.80194E-09, 3.28320E-09, 2.94927E-09,
     2.83102E-09, 3.04144E-09, 2.90547E-09, 2.72572E-09, 2.96416E-09,
     2.75968E-09, 3.00117E-09, 2.57369E-09, 2.69395E-09, 2.67177E-09,
     2.60250E-09, 2.76313E-09, 2.59838E-09, 2.68301E-09, 2.70520E-09,
     2.63082E-09, 2.47586E-09, 2.39961E-09, 2.49427E-09, 2.58726E-09,
     2.58994E-09, 2.45120E-09, 2.44590E-09, 2.58489E-09, 2.57960E-09,
     2.48287E-09, 2.52142E-09, 2.42354E-09, 2.41878E-09},
    {3.03386E-09, 2.79091E-09, 2.89425E-09, 2.87604E-09, 2.78172E-09,
     2.72146E-09, 2.72482E-09, 2.76153E-09, 2.68719E-09, 2.43241E-09,
     2.37496E-09, 2.47001E-09, 2.63254E-09, 2.57869E-09, 2.54210E-09,
     2.53088E-09, 2.43051E-09, 2.56017E-09, 2.35029E-09, 2.44518E-09,
     2.28676E-09, 2.32754E-09, 2.28024E-09, 2.39901E-09, 2.37324E-09,
     2.51339E-09, 2.17065E-09, 2.37694E-09, 2.30302E-09, 2.35938E-09,
     2.25851E-09, 2.43205E-09, 2.37139E-09, 2.21871E-09},
    {2.73833E-09, 2.51146E-09, 2.71111E-09, 2.65966E-09, 2.53667E-09,
     2.75346E-09, 2.47929E-09, 2.47953E-09, 2.42273E-09, 2.44501E-09,
     2.33368E-09, 2.45743E-09, 2.09809E-09, 2.44437E-09, 2.36052E-09,
     2.26545E-09, 2.25157E-09, 2.34407E-09, 2.37578E-09, 2.31100E-09,
     2.15140E-09, 2.23818E-09, 2.12353E-09, 2.23620E-09, 2.33865E-09,
     2.29391E-09, 2.35066E-09, 2.20795E-09, 2.26410E-09, 2.45062E-09,
     2.16320E-09, 2.13634E-09, 2.30212E-09, 2.28901E-09},
    {2.55511E-09, 2.65839E-09, 2.66027E-09, 2.47290E-09, 2.44162E-09,
     2.31990E-09, 2.37280E-09, 2.35216E-09, 2.43152E-09, 2.42900E-09,
     2.34627E-09, 2.24849E-09, 2.18398E-09, 2.25868E-09, 2.15148E-09,
     2.22451E-09, 1.89942E-09, 2.20220E-09, 2.15643E-09, 2.12577E-09,
     2.01858E-09, 2.29838E-09, 2.21316E-09, 2.12005E-09, 2.09728E-09,
     2.13051E-09, 1.96434E-09, 1.95937E-09, 1.91623E-09, 2.12269E-09,
     1.99731E-09, 2.00928E-09, 2.14545E-09, 1.91496E-09},
    {2.22161E-09, 2.43011E-09, 2.46588E-09, 2.44041E-09, 2.38636E-09,
     2.49669E-09, 2.19230E-09, 2.17718E-09, 2.19140E-09, 2.30680E-09,
     2.06163E-09, 2.02264E-09, 2.07872E-09, 2.20687E-09, 2.23874E-09,
     1.91209E-09, 2.00196E-09, 2.15577E-09, 2.07214E-09, 1.86842E-09,
     2.00955E-09, 2.10410E-09, 1.88901E-09, 1.82474E-09, 1.87643E-09,
     1.79047E-09, 1.93683E-09, 1.85285E-09, 2.05139E-09, 1.93112E-09,
     1.79844E-09, 1.93797E-09, 1.83313E-09, 2.01721E-09},
    {2.37460E-09, 2.29967E-09, 1.98510E-09, 2.13284E-09, 2.16225E-09,
     1.96753E-09, 2.03446E-09, 2.00431E-09, 2.09130E-09, 1.99796E-09,
     2.01247E-09, 1.91941E-09, 2.01803E-09, 2.05933E-09, 1.87158E-09,
     1.93564E-09, 1.87610E-09, 1.93344E-09, 1.95802E-09, 1.98673E-09,
     1.61892E-09, 1.82403E-09, 1.84216E-09, 1.72817E-09, 1.98936E-09,
     1.82871E-09, 1.79410E-09, 1.68698E-09, 1.79191E-09, 1.84638E-09,
     1.75140E-09, 1.63210E-09, 2.01253E-09, 1.74593E-09},
    {2.05584E-09, 2.17985E-09, 2.07554E-09, 1.97170E-09, 2.14662E-09,
     1.75998E-09, 1.93239E-09, 2.10388E-09, 1.92537E-09, 1.95285E-09,
     1.91187E-09, 1.75782E-09, 1.82091E-09, 1.79598E-09, 1.88147E-09,
     1.84970E-09, 2.00679E-09, 1.80435E-09, 1.75891E-09, 1.68481E-09,
     1.72894E-09, 1.94358E-09, 1.73044E-09, 1.61284E-09, 1.63127E-09,
     1.84009E-09, 1.82150E-09, 1.73862E-09, 1.65414E-09, 1.85405E-09,
     1.58801E-09, 1.61774E-09, 1.59006E-09, 1.62493E-09},
    {1.92107E-09, 1.96009E-09, 2.06988E-09, 1.89162E-09, 2.03860E-09,
     2.03207E-09, 1.80655E-09, 1.84144E-09, 1.67443E-09, 1.70587E-09,
     1.69269E-09, 1.52390E-09, 1.82051E-09, 1.80532E-09, 1.68407E-09,
     1.70721E-09, 1.62298E-09, 1.66269E-09, 1.69481E-09, 1.81496E-09,
     1.57481E-09, 1.52437E-09, 1.57133E-09, 1.34334E-09, 1.45580E-09,
     1.61527E-09, 1.55020E-09, 1.28157E-09, 1.75582E-09, 1.75105E-09,
     1.53877E-09, 1.59897E-09, 1.84584E-09, 1.66322E-09},
    {2.03728E-09, 1.84365E-09, 1.84509E-09, 1.66601E-09, 1.79749E-09,
     1.86922E-09, 1.77850E-09, 1.74452E-09, 1.77735E-09, 1.82664E-09,
     1.73539E-09, 1.70050E-09, 1.43323E-09, 1.73687E-09, 1.55424E-09,
     1.39929E-09, 1.65296E-09, 1.59727E-09, 1.58225E-09, 1.50678E-09,
     1.62090E-09, 1.53806E-09, 1.33911E-09, 1.59400E-09, 1.53568E-09,
     1.49256E-09, 1.64915E-09, 1.45157E-09, 1.48268E-09, 1.36619E-09,
     1.40873E-09, 1.57344E-09, 1.58409E-09, 1.41932E-09},
    {1.83853E-09, 1.62306E-09, 1.95271E-09, 1.81220E-09, 1.62562E-09,
     1.75715E-09, 1.37083E-09, 1.59625E-09, 1.51202E-09, 1.46641E-09,
     1.42759E-09, 1.59038E-09, 1.46982E-09, 1.66633E-09, 1.44921E-09,
     1.32742E-09, 1.69231E-09, 1.43170E-09, 1.53038E-09, 1.30293E-09,
     1.52816E-09, 1.51349E-09, 1.54401E-09, 1.41071E-09, 1.58143E-09,
     1.51350E-09, 1.31090E-09, 1.29041E-09, 1.46791E-09, 1.62975E-09,
     1.48901E-09, 1.31331E-09, 1.44965E-09, 1.40584E-09},
    {1.65316E-09, 1.57381E-09, 1.43792E-09, 1.45419E-09, 1.71251E-09,
     1.60444E-09, 1.52537E-09, 1.63495E-09, 1.67311E-09, 1.28491E-09,
     1.66458E-09, 1.57553E-09, 1.18507E-09, 1.51499E-09, 1.34074E-09,
     1.32128E-09, 1.45822E-09, 1.41177E-09, 1.36755E-09, 1.47437E-09,
     1.29156E-09, 1.40495E-09, 1.24178E-09, 1.42624E-09, 1.31523E-09,
     1.33823E-09, 1.21013E-09, 1.21623E-09, 1.44477E-09, 1.34663E-09,
     1.54741E-09, 1.32976E-09, 1.56620E-09, 1.20105E-09},
    {1.67900E-09, 1.61794E-09, 1.60414E-09, 1.64283E-09, 1.73466E-09,
     1.66334E-09, 1.38306E-09, 1.59117E-09, 1.56707E-09, 1.37462E-09,
     1.31607E-09, 1.53221E-09, 1.36970E-09, 1.35511E-09, 1.40229E-09,
     1.29571E-09, 1.29149E-09, 1.34261E-09, 1.28652E-09, 1.47264E-09,
     1.30963E-09, 1.27438E-09, 1.40238E-09, 1.36696E-09, 1.37966E-09,
     1.20284E-09, 1.17385E-09, 1.27269E-09, 1.35450E-09, 1.29850E-09,
     1.23112E-09, 1.32808E-09, 1.31878E-09, 1.36504E-09},
    {1.38623E-09, 1.36299E-09, 1.45079E-09, 1.46062E-09, 1.49383E-09,
     1.59841E-09, 1.66210E-09, 1.74851E-09, 1.34270E-09, 1.45296E-09,
     1.34475E-09, 1.46194E-09, 1.27800E-09, 1.41626E-09, 1.18416E-09,
     1.36298E-09, 1.49442E-09, 1.17616E-09, 1.20283E-09, 1.49719E-09,
     1.36459E-09, 1.33076E-09, 1.38684E-09, 1.00852E-09, 1.23914E-09,
     1.38535E-09, 1.14908E-09, 1.22428E-09, 1.18105E-09, 1.28778E-09,
     1.33786E-09, 1.35298E-09, 1.34806E-09, 1.39959E-09},
    {1.30055E-09, 1.44107E-09, 1.40787E-09, 1.36489E-09, 1.31580E-09,
     1.62769E-09, 1.57321E-09, 1.22758E-09, 1.31093E-09, 1.44386E-09,
     1.37141E-09, 1.60619E-09, 1.67757E-09, 1.19364E-09, 1.27072E-09,
     1.17941E-09, 1.29358E-09, 1.33727E-09, 1.22470E-09, 1.24583E-09,
     1.04550E-09, 1.33666E-09, 1.45147E-09, 1.31154E-09, 1.21521E-09,
     8.98034E-10, 1.19445E-09, 1.10739E-09, 1.23424E-09, 1.07038E-09,
     1.17537E-09, 1.27615E-09, 1.23657E-09, 1.20620E-09},
    {1.28211E-09, 1.40089E-09, 1.40949E-09, 1.54033E-09, 1.39881E-09,
     1.35293E-09, 1.33491E-09, 1.29690E-09, 1.23172E-09, 1.40601E-09,
     1.29532E-09, 1.49248E-09, 1.27389E-09, 1.20614E-09, 1.24129E-09,
     1.39532E-09, 1.21918E-09, 1.43127E-09, 1.33570E-09, 1.19689E-09,
     1.08165E-09, 1.28754E-09, 1.35972E-09, 1.22478E-09, 1.61262E-09,
     1.30363E-09, 1.25680E-09, 1.21464E-09, 1.06806E-09, 1.22825E-09,
     1.20234E-09, 1.25104E-09, 1.09473E-09, 9.66746E-10},
    {1.31272E-09, 1.21047E-09, 1.24446E-09, 1.45188E-09, 1.45124E-09,
     1.48599E-09, 1.27742E-09, 1.25855E-09, 1.16568E-09, 1.24740E-09,
     1.26566E-09, 1.35371E-09, 1.29136E-09, 1.33666E-09, 1.23218E-09,
     1.43855E-09, 1.35510E-09, 1.28158E-09, 1.34194E-09, 1.06142E-09,
     1.28098E-09, 1.17199E-09, 1.15820E-09, 1.13288E-09, 1.28084E-09,
     1.23296E-09, 1.23982E-09, 1.19765E-09, 1.14710E-09, 1.24350E-09,
     1.19648E-09, 1.17817E-09, 1.09129E-09, 1.28457E-09},
    {1.27848E-09, 1.22709E-09, 1.40405E-09, 1.23677E-09, 1.22819E-09,
     1.34245E-09, 1.32723E-09, 1.23053E-09, 1.19735E-09, 1.36349E-09,
     1.27285E-09, 1.21659E-09, 1.35410E-09, 1.27995E-09, 1.01762E-09,
     1.18275E-09, 1.42866E-09, 1.17880E-09, 1.23388E-09, 1.33376E-09,
     1.13633E-09, 9.07141E-10, 1.26915E-09, 1.16713E-09, 1.09136E-09,
     1.12741E-09, 1.18772E-09, 1.09974E-09, 1.31771E-09, 1.20973E-09,
     1.10954E-09, 1.05519E-09, 1.11468E-09, 1.20236E-09},
    {1.32717E-09, 1.20480E-09, 1.17538E-09, 9.30257E-10, 1.23675E-09,
     1.26332E-09, 1.26204E-09, 1.18236E-09, 1.14303E-09, 1.27181E-09,
     1.30307E-09, 1.38705E-09, 1.29672E-09, 1.15373E-09, 1.11321E-09,
     1.19786E-09, 1.38280E-09, 1.24815E-09, 1.27881E-09, 1.26601E-09,
     1.13237E-09, 1.20529E-09, 1.32717E-09, 9.77996E-10, 1.18139E-09,
     1.11114E-09, 1.10476E-09, 1.29040E-09, 1.05250E-09, 1.22770E-09,
     1.11197E-09, 1.01842E-09, 1.06475E-09, 1.38297E-09},
    {1.30547E-09, 1.21256E-09, 1.18300E-09, 1.27371E-09, 1.18057E-09,
     1.30787E-09, 1.24565E-09, 1.39504E-09, 1.24139E-09, 1.16420E-09,
     1.25764E-09, 1.36461E-09, 1.16327E-09, 1.15590E-09, 1.22052E-09,
     1.35808E-09, 1.18403E-09, 1.06913E-09, 1.24756E-09, 1.27053E-09,
     1.25324E-09, 1.35748E-09, 1.15850E-09, 1.16892E-09, 1.34298E-09,
     1.31602E-09, 1.20162E-09, 9.33081E-10, 1.21515E-09, 1.24667E-09,
     1.08223E-09, 1.14209E-09, 1.04194E-09, 1.11115E-09},
    {1.31119E-09, 1.24303E-09, 1.31459E-09, 1.36295E-09, 1.28235E-09,
     1.02387E-09, 1.06042E-09, 1.21972E-09, 1.10686E-09, 1.17153E-09,
     9.81337E-10, 1.05572E-09, 1.26287E-09, 1.31568E-09, 1.04834E-09,
     1.27953E-09, 9.96168E-10, 8.82039E-10, 1.01258E-09, 1.22901E-09,
     1.27153E-09, 1.23589E-09, 1.25819E-09, 1.29529E-09, 1.08922E-09,
     1.14254E-09, 1.24594E-09, 1.11729E-09, 1.43107E-09, 1.12737E-09,
     1.24914E-09, 1.23119E-09, 1.31992E-09, 1.19272E-09},
    {1.09473E-09, 1.19644E-09, 1.59213E-09, 1.13890E-09, 1.32707E-09,
     1.32416E-09, 1.22552E-09, 1.23620E-09, 1.15423E-09, 8.28194E-10,
     1.19349E-09, 1.28821E-09, 1.38548E-09, 1.07632E-09, 1.30499E-09,
     1.23665E-09, 1.16666E-09, 9.29924E-10, 1.21559E-09, 1.30043E-09,
     1.18772E-09, 1.22821E-09, 1.20447E-09, 1.27892E-09, 1.17956E-09,
     1.17379E-09, 1.19731E-09, 1.35084E-09, 1.24757E-09, 1.14003E-09,
     1.00314E-09, 1.18057E-09, 1.15196E-09, 1.08770E-09},
    {1.15841E-09, 1.26046E-09, 1.22003E-09, 1.39348E-09, 1.23939E-09,
     1.16915E-09, 1.15167E-09, 1.17795E-09, 1.16217E-09, 1.15080E-09,
     1.13030E-09, 1.17637E-09, 9.34988E-10, 1.22686E-09, 1.19302E-09,
     1.36164E-09, 1.32538E-09, 1.04068E-09, 1.48034E-09, 1.18211E-09,
     1.15993E-09, 1.16498E-09, 1.04435E-09, 1.33342E-09, 1.06445E-09,
     1.09859E-09, 1.19835E-09, 1.10790E-09, 1.25316E-09, 1.14823E-09,
     1.12278E-09, 1.11293E-09, 9.46756E-10, 1.25684E-09},
    {1.35698E-09, 1.14165E-09, 1.05699E-09, 1.19235E-09, 1.34021E-09,
     1.17699E-09, 1.06249E-09, 1.04811E-09, 1.19010E-09, 1.29425E-09,
     1.14121E-09, 1.09728E-09, 9.85209E-10, 9.82224E-10, 1.21431E-09,
     1.13923E-09, 1.11800E-09, 1.28158E-09, 1.16302E-09, 1.10484E-09,
     1.40579E-09, 1.23132E-09, 1.12691E-09, 1.12768E-09, 1.18179E-09,
     1.31357E-09, 1.29561E-09, 1.26691E-09, 1.11512E-09, 1.13015E-09,
     1.14760E-09, 1.15231E-09, 1.02675E-09, 1.10158E-09},
    {1.16805E-09, 1.20725E-09, 1.21867E-09, 1.27664E-09, 1.08217E-09,
     1.24474E-09, 1.15033E-09, 1.14011E-09, 1.26229E-09, 1.07423E-09,
     1.25211E-09, 1.02370E-09, 1.18076E-09, 1.07317E-09, 1.11096E-09,
     1.21904E-09, 1.01583E-09, 1.21590E-09, 1.08577E-09, 1.34619E-09,
     1.20762E-09, 1.11539E-09, 1.05995E-09, 1.13273E-09, 1.03651E-09,
     1.05954E-09, 1.25460E-09, 1.18630E-09, 1.00652E-09, 1.27853E-09,
     1.24334E-09, 1.15740E-09, 1.01476E-09, 1.13601E-09},
    {1.13991E-09, 1.29438E-09, 1.28014E-09, 1.37676E-09, 1.13093E-09,
     1.03577E-09, 1.12128E-09, 1.18905E-09, 1.05721E-09, 1.12919E-09,
     1.24365E-09, 1.10802E-09, 1.22001E-09, 1.22307E-09, 1.13094E-09,
     1.16410E-09, 1.16356E-09, 1.26466E-09, 1.04467E-09, 1.25001E-09,
     1.18197E-09, 1.14845E-09, 1.06366E-09, 1.17919E-09, 1.06941E-09,
     1.03864E-09, 1.27783E-09, 1.28631E-09, 9.74651E-10, 1.28291E-09,
     1.15604E-09, 1.17496E-09, 1.07405E-09, 1.11327E-09},
    {1.25372E-09, 1.57935E-09, 1.38437E-09, 1.12077E-09, 1.16441E-09,
     1.34858E-09, 1.23633E-09, 1.23952E-09, 1.10280E-09, 1.12534E-09,
     1.13914E-09, 1.21035E-09, 1.40884E-09, 1.23972E-09, 1.07802E-09,
     1.06849E-09, 1.21101E-09, 1.08547E-09, 9.84790E-10, 1.19477E-09,
     1.08026E-09, 1.11663E-09, 1.23391E-09, 1.26804E-09, 1.16605E-09,
     1.27231E-09, 1.07258E-09, 1.02469E-09, 1.31144E-09, 1.13534E-09,
     1.06823E-09, 1.28839E-09, 1.36300E-09, 1.12797E-09},
    {1.47726E-09, 1.29642E-09, 1.43943E-09, 1.38570E-09, 1.29390E-09,
     1.31315E-09, 1.12651E-09, 1.07814E-09, 1.27962E-09, 1.19741E-09,
     1.31568E-09, 1.11357E-09, 9.25486E-10, 1.21353E-09, 1.21551E-09,
     1.12670E-09, 1.17301E-09, 1.11065E-09, 1.24645E-09, 1.10648E-09,
     1.03766E-09, 1.18218E-09, 1.22401E-09, 1.26606E-09, 1.21581E-09,
     1.08261E-09, 1.17670E-09, 1.47508E-09, 1.28636E-09, 1.30428E-09,
     1.26426E-09, 1.20142E-09, 1.20540E-09, 1.15966E-09},
    {1.55196E-09, 1.72826E-09, 1.39075E-09, 1.22035E-09, 1.37236E-09,
     1.23199E-09, 1.59750E-09, 1.34399E-09, 1.33099E-09, 1.32939E-09,
     1.29529E-09, 1.16705E-09, 1.34977E-09, 1.22333E-09, 1.20613E-09,
     1.19837E-09, 1.16493E-09, 1.11246E-09, 1.11140E-09, 1.08754E-09,
     1.20761E-09, 1.32138E-09, 1.13682E-09, 1.11049E-09, 1.26474E-09,
     1.53680E-09, 1.16970E-09, 1.20852E-09, 1.34354E-09, 1.29367E-09,
     1.54055E-09, 1.31050E-09, 1.47461E-09, 1.48155E-09},
    {2.97957E-08, 2.75986E-08, 1.31254E-08, 1.22182E-08, 1.96989E-08,
     1.61060E-08, 1.43338E-08, 1.35019E-08, 1.05553E-08, 1.11994E-08,
     7.81866E-09, 8.74047E-09, 7.67589E-09, 6.55686E-09, 9.00865E-09,
     6.24369E-09, 5.69923E-09, 8.04124E-09, 8.86564E-09, 1.07740E-08,
     1.13368E-08, 1.26940E-08, 1.35118E-08, 1.51252E-08, 1.75241E-08,
     1.73859E-08, 2.64666E-08, 2.07919E-08, 2.29295E-08, 3.24361E-08,
     2.30237E-08, 3.27267E-08, 2.64257E-08, 2.78786E-08}};
#endif