// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.7
// source: google/cloud/kms/v1/service.proto

package kmspb

import (
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	KeyManagementService_ListKeyRings_FullMethodName                  = "/google.cloud.kms.v1.KeyManagementService/ListKeyRings"
	KeyManagementService_ListCryptoKeys_FullMethodName                = "/google.cloud.kms.v1.KeyManagementService/ListCryptoKeys"
	KeyManagementService_ListCryptoKeyVersions_FullMethodName         = "/google.cloud.kms.v1.KeyManagementService/ListCryptoKeyVersions"
	KeyManagementService_ListImportJobs_FullMethodName                = "/google.cloud.kms.v1.KeyManagementService/ListImportJobs"
	KeyManagementService_GetKeyRing_FullMethodName                    = "/google.cloud.kms.v1.KeyManagementService/GetKeyRing"
	KeyManagementService_GetCryptoKey_FullMethodName                  = "/google.cloud.kms.v1.KeyManagementService/GetCryptoKey"
	KeyManagementService_GetCryptoKeyVersion_FullMethodName           = "/google.cloud.kms.v1.KeyManagementService/GetCryptoKeyVersion"
	KeyManagementService_GetPublicKey_FullMethodName                  = "/google.cloud.kms.v1.KeyManagementService/GetPublicKey"
	KeyManagementService_GetImportJob_FullMethodName                  = "/google.cloud.kms.v1.KeyManagementService/GetImportJob"
	KeyManagementService_CreateKeyRing_FullMethodName                 = "/google.cloud.kms.v1.KeyManagementService/CreateKeyRing"
	KeyManagementService_CreateCryptoKey_FullMethodName               = "/google.cloud.kms.v1.KeyManagementService/CreateCryptoKey"
	KeyManagementService_CreateCryptoKeyVersion_FullMethodName        = "/google.cloud.kms.v1.KeyManagementService/CreateCryptoKeyVersion"
	KeyManagementService_ImportCryptoKeyVersion_FullMethodName        = "/google.cloud.kms.v1.KeyManagementService/ImportCryptoKeyVersion"
	KeyManagementService_CreateImportJob_FullMethodName               = "/google.cloud.kms.v1.KeyManagementService/CreateImportJob"
	KeyManagementService_UpdateCryptoKey_FullMethodName               = "/google.cloud.kms.v1.KeyManagementService/UpdateCryptoKey"
	KeyManagementService_UpdateCryptoKeyVersion_FullMethodName        = "/google.cloud.kms.v1.KeyManagementService/UpdateCryptoKeyVersion"
	KeyManagementService_UpdateCryptoKeyPrimaryVersion_FullMethodName = "/google.cloud.kms.v1.KeyManagementService/UpdateCryptoKeyPrimaryVersion"
	KeyManagementService_DestroyCryptoKeyVersion_FullMethodName       = "/google.cloud.kms.v1.KeyManagementService/DestroyCryptoKeyVersion"
	KeyManagementService_RestoreCryptoKeyVersion_FullMethodName       = "/google.cloud.kms.v1.KeyManagementService/RestoreCryptoKeyVersion"
	KeyManagementService_Encrypt_FullMethodName                       = "/google.cloud.kms.v1.KeyManagementService/Encrypt"
	KeyManagementService_Decrypt_FullMethodName                       = "/google.cloud.kms.v1.KeyManagementService/Decrypt"
	KeyManagementService_RawEncrypt_FullMethodName                    = "/google.cloud.kms.v1.KeyManagementService/RawEncrypt"
	KeyManagementService_RawDecrypt_FullMethodName                    = "/google.cloud.kms.v1.KeyManagementService/RawDecrypt"
	KeyManagementService_AsymmetricSign_FullMethodName                = "/google.cloud.kms.v1.KeyManagementService/AsymmetricSign"
	KeyManagementService_AsymmetricDecrypt_FullMethodName             = "/google.cloud.kms.v1.KeyManagementService/AsymmetricDecrypt"
	KeyManagementService_MacSign_FullMethodName                       = "/google.cloud.kms.v1.KeyManagementService/MacSign"
	KeyManagementService_MacVerify_FullMethodName                     = "/google.cloud.kms.v1.KeyManagementService/MacVerify"
	KeyManagementService_Decapsulate_FullMethodName                   = "/google.cloud.kms.v1.KeyManagementService/Decapsulate"
	KeyManagementService_GenerateRandomBytes_FullMethodName           = "/google.cloud.kms.v1.KeyManagementService/GenerateRandomBytes"
)

// KeyManagementServiceClient is the client API for KeyManagementService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type KeyManagementServiceClient interface {
	// Lists [KeyRings][google.cloud.kms.v1.KeyRing].
	ListKeyRings(ctx context.Context, in *ListKeyRingsRequest, opts ...grpc.CallOption) (*ListKeyRingsResponse, error)
	// Lists [CryptoKeys][google.cloud.kms.v1.CryptoKey].
	ListCryptoKeys(ctx context.Context, in *ListCryptoKeysRequest, opts ...grpc.CallOption) (*ListCryptoKeysResponse, error)
	// Lists [CryptoKeyVersions][google.cloud.kms.v1.CryptoKeyVersion].
	ListCryptoKeyVersions(ctx context.Context, in *ListCryptoKeyVersionsRequest, opts ...grpc.CallOption) (*ListCryptoKeyVersionsResponse, error)
	// Lists [ImportJobs][google.cloud.kms.v1.ImportJob].
	ListImportJobs(ctx context.Context, in *ListImportJobsRequest, opts ...grpc.CallOption) (*ListImportJobsResponse, error)
	// Returns metadata for a given [KeyRing][google.cloud.kms.v1.KeyRing].
	GetKeyRing(ctx context.Context, in *GetKeyRingRequest, opts ...grpc.CallOption) (*KeyRing, error)
	// Returns metadata for a given [CryptoKey][google.cloud.kms.v1.CryptoKey], as
	// well as its [primary][google.cloud.kms.v1.CryptoKey.primary]
	// [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion].
	GetCryptoKey(ctx context.Context, in *GetCryptoKeyRequest, opts ...grpc.CallOption) (*CryptoKey, error)
	// Returns metadata for a given
	// [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion].
	GetCryptoKeyVersion(ctx context.Context, in *GetCryptoKeyVersionRequest, opts ...grpc.CallOption) (*CryptoKeyVersion, error)
	// Returns the public key for the given
	// [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion]. The
	// [CryptoKey.purpose][google.cloud.kms.v1.CryptoKey.purpose] must be
	// [ASYMMETRIC_SIGN][google.cloud.kms.v1.CryptoKey.CryptoKeyPurpose.ASYMMETRIC_SIGN]
	// or
	// [ASYMMETRIC_DECRYPT][google.cloud.kms.v1.CryptoKey.CryptoKeyPurpose.ASYMMETRIC_DECRYPT].
	GetPublicKey(ctx context.Context, in *GetPublicKeyRequest, opts ...grpc.CallOption) (*PublicKey, error)
	// Returns metadata for a given [ImportJob][google.cloud.kms.v1.ImportJob].
	GetImportJob(ctx context.Context, in *GetImportJobRequest, opts ...grpc.CallOption) (*ImportJob, error)
	// Create a new [KeyRing][google.cloud.kms.v1.KeyRing] in a given Project and
	// Location.
	CreateKeyRing(ctx context.Context, in *CreateKeyRingRequest, opts ...grpc.CallOption) (*KeyRing, error)
	// Create a new [CryptoKey][google.cloud.kms.v1.CryptoKey] within a
	// [KeyRing][google.cloud.kms.v1.KeyRing].
	//
	// [CryptoKey.purpose][google.cloud.kms.v1.CryptoKey.purpose] and
	// [CryptoKey.version_template.algorithm][google.cloud.kms.v1.CryptoKeyVersionTemplate.algorithm]
	// are required.
	CreateCryptoKey(ctx context.Context, in *CreateCryptoKeyRequest, opts ...grpc.CallOption) (*CryptoKey, error)
	// Create a new [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] in a
	// [CryptoKey][google.cloud.kms.v1.CryptoKey].
	//
	// The server will assign the next sequential id. If unset,
	// [state][google.cloud.kms.v1.CryptoKeyVersion.state] will be set to
	// [ENABLED][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.ENABLED].
	CreateCryptoKeyVersion(ctx context.Context, in *CreateCryptoKeyVersionRequest, opts ...grpc.CallOption) (*CryptoKeyVersion, error)
	// Import wrapped key material into a
	// [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion].
	//
	// All requests must specify a [CryptoKey][google.cloud.kms.v1.CryptoKey]. If
	// a [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] is additionally
	// specified in the request, key material will be reimported into that
	// version. Otherwise, a new version will be created, and will be assigned the
	// next sequential id within the [CryptoKey][google.cloud.kms.v1.CryptoKey].
	ImportCryptoKeyVersion(ctx context.Context, in *ImportCryptoKeyVersionRequest, opts ...grpc.CallOption) (*CryptoKeyVersion, error)
	// Create a new [ImportJob][google.cloud.kms.v1.ImportJob] within a
	// [KeyRing][google.cloud.kms.v1.KeyRing].
	//
	// [ImportJob.import_method][google.cloud.kms.v1.ImportJob.import_method] is
	// required.
	CreateImportJob(ctx context.Context, in *CreateImportJobRequest, opts ...grpc.CallOption) (*ImportJob, error)
	// Update a [CryptoKey][google.cloud.kms.v1.CryptoKey].
	UpdateCryptoKey(ctx context.Context, in *UpdateCryptoKeyRequest, opts ...grpc.CallOption) (*CryptoKey, error)
	// Update a [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion]'s
	// metadata.
	//
	// [state][google.cloud.kms.v1.CryptoKeyVersion.state] may be changed between
	// [ENABLED][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.ENABLED]
	// and
	// [DISABLED][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.DISABLED]
	// using this method. See
	// [DestroyCryptoKeyVersion][google.cloud.kms.v1.KeyManagementService.DestroyCryptoKeyVersion]
	// and
	// [RestoreCryptoKeyVersion][google.cloud.kms.v1.KeyManagementService.RestoreCryptoKeyVersion]
	// to move between other states.
	UpdateCryptoKeyVersion(ctx context.Context, in *UpdateCryptoKeyVersionRequest, opts ...grpc.CallOption) (*CryptoKeyVersion, error)
	// Update the version of a [CryptoKey][google.cloud.kms.v1.CryptoKey] that
	// will be used in
	// [Encrypt][google.cloud.kms.v1.KeyManagementService.Encrypt].
	//
	// Returns an error if called on a key whose purpose is not
	// [ENCRYPT_DECRYPT][google.cloud.kms.v1.CryptoKey.CryptoKeyPurpose.ENCRYPT_DECRYPT].
	UpdateCryptoKeyPrimaryVersion(ctx context.Context, in *UpdateCryptoKeyPrimaryVersionRequest, opts ...grpc.CallOption) (*CryptoKey, error)
	// Schedule a [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] for
	// destruction.
	//
	// Upon calling this method,
	// [CryptoKeyVersion.state][google.cloud.kms.v1.CryptoKeyVersion.state] will
	// be set to
	// [DESTROY_SCHEDULED][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.DESTROY_SCHEDULED],
	// and [destroy_time][google.cloud.kms.v1.CryptoKeyVersion.destroy_time] will
	// be set to the time
	// [destroy_scheduled_duration][google.cloud.kms.v1.CryptoKey.destroy_scheduled_duration]
	// in the future. At that time, the
	// [state][google.cloud.kms.v1.CryptoKeyVersion.state] will automatically
	// change to
	// [DESTROYED][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.DESTROYED],
	// and the key material will be irrevocably destroyed.
	//
	// Before the
	// [destroy_time][google.cloud.kms.v1.CryptoKeyVersion.destroy_time] is
	// reached,
	// [RestoreCryptoKeyVersion][google.cloud.kms.v1.KeyManagementService.RestoreCryptoKeyVersion]
	// may be called to reverse the process.
	DestroyCryptoKeyVersion(ctx context.Context, in *DestroyCryptoKeyVersionRequest, opts ...grpc.CallOption) (*CryptoKeyVersion, error)
	// Restore a [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] in the
	// [DESTROY_SCHEDULED][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.DESTROY_SCHEDULED]
	// state.
	//
	// Upon restoration of the CryptoKeyVersion,
	// [state][google.cloud.kms.v1.CryptoKeyVersion.state] will be set to
	// [DISABLED][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.DISABLED],
	// and [destroy_time][google.cloud.kms.v1.CryptoKeyVersion.destroy_time] will
	// be cleared.
	RestoreCryptoKeyVersion(ctx context.Context, in *RestoreCryptoKeyVersionRequest, opts ...grpc.CallOption) (*CryptoKeyVersion, error)
	// Encrypts data, so that it can only be recovered by a call to
	// [Decrypt][google.cloud.kms.v1.KeyManagementService.Decrypt]. The
	// [CryptoKey.purpose][google.cloud.kms.v1.CryptoKey.purpose] must be
	// [ENCRYPT_DECRYPT][google.cloud.kms.v1.CryptoKey.CryptoKeyPurpose.ENCRYPT_DECRYPT].
	Encrypt(ctx context.Context, in *EncryptRequest, opts ...grpc.CallOption) (*EncryptResponse, error)
	// Decrypts data that was protected by
	// [Encrypt][google.cloud.kms.v1.KeyManagementService.Encrypt]. The
	// [CryptoKey.purpose][google.cloud.kms.v1.CryptoKey.purpose] must be
	// [ENCRYPT_DECRYPT][google.cloud.kms.v1.CryptoKey.CryptoKeyPurpose.ENCRYPT_DECRYPT].
	Decrypt(ctx context.Context, in *DecryptRequest, opts ...grpc.CallOption) (*DecryptResponse, error)
	// Encrypts data using portable cryptographic primitives. Most users should
	// choose [Encrypt][google.cloud.kms.v1.KeyManagementService.Encrypt] and
	// [Decrypt][google.cloud.kms.v1.KeyManagementService.Decrypt] rather than
	// their raw counterparts. The
	// [CryptoKey.purpose][google.cloud.kms.v1.CryptoKey.purpose] must be
	// [RAW_ENCRYPT_DECRYPT][google.cloud.kms.v1.CryptoKey.CryptoKeyPurpose.RAW_ENCRYPT_DECRYPT].
	RawEncrypt(ctx context.Context, in *RawEncryptRequest, opts ...grpc.CallOption) (*RawEncryptResponse, error)
	// Decrypts data that was originally encrypted using a raw cryptographic
	// mechanism. The [CryptoKey.purpose][google.cloud.kms.v1.CryptoKey.purpose]
	// must be
	// [RAW_ENCRYPT_DECRYPT][google.cloud.kms.v1.CryptoKey.CryptoKeyPurpose.RAW_ENCRYPT_DECRYPT].
	RawDecrypt(ctx context.Context, in *RawDecryptRequest, opts ...grpc.CallOption) (*RawDecryptResponse, error)
	// Signs data using a [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion]
	// with [CryptoKey.purpose][google.cloud.kms.v1.CryptoKey.purpose]
	// ASYMMETRIC_SIGN, producing a signature that can be verified with the public
	// key retrieved from
	// [GetPublicKey][google.cloud.kms.v1.KeyManagementService.GetPublicKey].
	AsymmetricSign(ctx context.Context, in *AsymmetricSignRequest, opts ...grpc.CallOption) (*AsymmetricSignResponse, error)
	// Decrypts data that was encrypted with a public key retrieved from
	// [GetPublicKey][google.cloud.kms.v1.KeyManagementService.GetPublicKey]
	// corresponding to a [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion]
	// with [CryptoKey.purpose][google.cloud.kms.v1.CryptoKey.purpose]
	// ASYMMETRIC_DECRYPT.
	AsymmetricDecrypt(ctx context.Context, in *AsymmetricDecryptRequest, opts ...grpc.CallOption) (*AsymmetricDecryptResponse, error)
	// Signs data using a [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion]
	// with [CryptoKey.purpose][google.cloud.kms.v1.CryptoKey.purpose] MAC,
	// producing a tag that can be verified by another source with the same key.
	MacSign(ctx context.Context, in *MacSignRequest, opts ...grpc.CallOption) (*MacSignResponse, error)
	// Verifies MAC tag using a
	// [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] with
	// [CryptoKey.purpose][google.cloud.kms.v1.CryptoKey.purpose] MAC, and returns
	// a response that indicates whether or not the verification was successful.
	MacVerify(ctx context.Context, in *MacVerifyRequest, opts ...grpc.CallOption) (*MacVerifyResponse, error)
	// Decapsulates data that was encapsulated with a public key retrieved from
	// [GetPublicKey][google.cloud.kms.v1.KeyManagementService.GetPublicKey]
	// corresponding to a [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion]
	// with [CryptoKey.purpose][google.cloud.kms.v1.CryptoKey.purpose]
	// KEY_ENCAPSULATION.
	Decapsulate(ctx context.Context, in *DecapsulateRequest, opts ...grpc.CallOption) (*DecapsulateResponse, error)
	// Generate random bytes using the Cloud KMS randomness source in the provided
	// location.
	GenerateRandomBytes(ctx context.Context, in *GenerateRandomBytesRequest, opts ...grpc.CallOption) (*GenerateRandomBytesResponse, error)
}

type keyManagementServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewKeyManagementServiceClient(cc grpc.ClientConnInterface) KeyManagementServiceClient {
	return &keyManagementServiceClient{cc}
}

func (c *keyManagementServiceClient) ListKeyRings(ctx context.Context, in *ListKeyRingsRequest, opts ...grpc.CallOption) (*ListKeyRingsResponse, error) {
	out := new(ListKeyRingsResponse)
	err := c.cc.Invoke(ctx, KeyManagementService_ListKeyRings_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *keyManagementServiceClient) ListCryptoKeys(ctx context.Context, in *ListCryptoKeysRequest, opts ...grpc.CallOption) (*ListCryptoKeysResponse, error) {
	out := new(ListCryptoKeysResponse)
	err := c.cc.Invoke(ctx, KeyManagementService_ListCryptoKeys_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *keyManagementServiceClient) ListCryptoKeyVersions(ctx context.Context, in *ListCryptoKeyVersionsRequest, opts ...grpc.CallOption) (*ListCryptoKeyVersionsResponse, error) {
	out := new(ListCryptoKeyVersionsResponse)
	err := c.cc.Invoke(ctx, KeyManagementService_ListCryptoKeyVersions_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *keyManagementServiceClient) ListImportJobs(ctx context.Context, in *ListImportJobsRequest, opts ...grpc.CallOption) (*ListImportJobsResponse, error) {
	out := new(ListImportJobsResponse)
	err := c.cc.Invoke(ctx, KeyManagementService_ListImportJobs_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *keyManagementServiceClient) GetKeyRing(ctx context.Context, in *GetKeyRingRequest, opts ...grpc.CallOption) (*KeyRing, error) {
	out := new(KeyRing)
	err := c.cc.Invoke(ctx, KeyManagementService_GetKeyRing_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *keyManagementServiceClient) GetCryptoKey(ctx context.Context, in *GetCryptoKeyRequest, opts ...grpc.CallOption) (*CryptoKey, error) {
	out := new(CryptoKey)
	err := c.cc.Invoke(ctx, KeyManagementService_GetCryptoKey_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *keyManagementServiceClient) GetCryptoKeyVersion(ctx context.Context, in *GetCryptoKeyVersionRequest, opts ...grpc.CallOption) (*CryptoKeyVersion, error) {
	out := new(CryptoKeyVersion)
	err := c.cc.Invoke(ctx, KeyManagementService_GetCryptoKeyVersion_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *keyManagementServiceClient) GetPublicKey(ctx context.Context, in *GetPublicKeyRequest, opts ...grpc.CallOption) (*PublicKey, error) {
	out := new(PublicKey)
	err := c.cc.Invoke(ctx, KeyManagementService_GetPublicKey_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *keyManagementServiceClient) GetImportJob(ctx context.Context, in *GetImportJobRequest, opts ...grpc.CallOption) (*ImportJob, error) {
	out := new(ImportJob)
	err := c.cc.Invoke(ctx, KeyManagementService_GetImportJob_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *keyManagementServiceClient) CreateKeyRing(ctx context.Context, in *CreateKeyRingRequest, opts ...grpc.CallOption) (*KeyRing, error) {
	out := new(KeyRing)
	err := c.cc.Invoke(ctx, KeyManagementService_CreateKeyRing_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *keyManagementServiceClient) CreateCryptoKey(ctx context.Context, in *CreateCryptoKeyRequest, opts ...grpc.CallOption) (*CryptoKey, error) {
	out := new(CryptoKey)
	err := c.cc.Invoke(ctx, KeyManagementService_CreateCryptoKey_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *keyManagementServiceClient) CreateCryptoKeyVersion(ctx context.Context, in *CreateCryptoKeyVersionRequest, opts ...grpc.CallOption) (*CryptoKeyVersion, error) {
	out := new(CryptoKeyVersion)
	err := c.cc.Invoke(ctx, KeyManagementService_CreateCryptoKeyVersion_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *keyManagementServiceClient) ImportCryptoKeyVersion(ctx context.Context, in *ImportCryptoKeyVersionRequest, opts ...grpc.CallOption) (*CryptoKeyVersion, error) {
	out := new(CryptoKeyVersion)
	err := c.cc.Invoke(ctx, KeyManagementService_ImportCryptoKeyVersion_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *keyManagementServiceClient) CreateImportJob(ctx context.Context, in *CreateImportJobRequest, opts ...grpc.CallOption) (*ImportJob, error) {
	out := new(ImportJob)
	err := c.cc.Invoke(ctx, KeyManagementService_CreateImportJob_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *keyManagementServiceClient) UpdateCryptoKey(ctx context.Context, in *UpdateCryptoKeyRequest, opts ...grpc.CallOption) (*CryptoKey, error) {
	out := new(CryptoKey)
	err := c.cc.Invoke(ctx, KeyManagementService_UpdateCryptoKey_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *keyManagementServiceClient) UpdateCryptoKeyVersion(ctx context.Context, in *UpdateCryptoKeyVersionRequest, opts ...grpc.CallOption) (*CryptoKeyVersion, error) {
	out := new(CryptoKeyVersion)
	err := c.cc.Invoke(ctx, KeyManagementService_UpdateCryptoKeyVersion_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *keyManagementServiceClient) UpdateCryptoKeyPrimaryVersion(ctx context.Context, in *UpdateCryptoKeyPrimaryVersionRequest, opts ...grpc.CallOption) (*CryptoKey, error) {
	out := new(CryptoKey)
	err := c.cc.Invoke(ctx, KeyManagementService_UpdateCryptoKeyPrimaryVersion_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *keyManagementServiceClient) DestroyCryptoKeyVersion(ctx context.Context, in *DestroyCryptoKeyVersionRequest, opts ...grpc.CallOption) (*CryptoKeyVersion, error) {
	out := new(CryptoKeyVersion)
	err := c.cc.Invoke(ctx, KeyManagementService_DestroyCryptoKeyVersion_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *keyManagementServiceClient) RestoreCryptoKeyVersion(ctx context.Context, in *RestoreCryptoKeyVersionRequest, opts ...grpc.CallOption) (*CryptoKeyVersion, error) {
	out := new(CryptoKeyVersion)
	err := c.cc.Invoke(ctx, KeyManagementService_RestoreCryptoKeyVersion_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *keyManagementServiceClient) Encrypt(ctx context.Context, in *EncryptRequest, opts ...grpc.CallOption) (*EncryptResponse, error) {
	out := new(EncryptResponse)
	err := c.cc.Invoke(ctx, KeyManagementService_Encrypt_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *keyManagementServiceClient) Decrypt(ctx context.Context, in *DecryptRequest, opts ...grpc.CallOption) (*DecryptResponse, error) {
	out := new(DecryptResponse)
	err := c.cc.Invoke(ctx, KeyManagementService_Decrypt_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *keyManagementServiceClient) RawEncrypt(ctx context.Context, in *RawEncryptRequest, opts ...grpc.CallOption) (*RawEncryptResponse, error) {
	out := new(RawEncryptResponse)
	err := c.cc.Invoke(ctx, KeyManagementService_RawEncrypt_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *keyManagementServiceClient) RawDecrypt(ctx context.Context, in *RawDecryptRequest, opts ...grpc.CallOption) (*RawDecryptResponse, error) {
	out := new(RawDecryptResponse)
	err := c.cc.Invoke(ctx, KeyManagementService_RawDecrypt_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *keyManagementServiceClient) AsymmetricSign(ctx context.Context, in *AsymmetricSignRequest, opts ...grpc.CallOption) (*AsymmetricSignResponse, error) {
	out := new(AsymmetricSignResponse)
	err := c.cc.Invoke(ctx, KeyManagementService_AsymmetricSign_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *keyManagementServiceClient) AsymmetricDecrypt(ctx context.Context, in *AsymmetricDecryptRequest, opts ...grpc.CallOption) (*AsymmetricDecryptResponse, error) {
	out := new(AsymmetricDecryptResponse)
	err := c.cc.Invoke(ctx, KeyManagementService_AsymmetricDecrypt_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *keyManagementServiceClient) MacSign(ctx context.Context, in *MacSignRequest, opts ...grpc.CallOption) (*MacSignResponse, error) {
	out := new(MacSignResponse)
	err := c.cc.Invoke(ctx, KeyManagementService_MacSign_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *keyManagementServiceClient) MacVerify(ctx context.Context, in *MacVerifyRequest, opts ...grpc.CallOption) (*MacVerifyResponse, error) {
	out := new(MacVerifyResponse)
	err := c.cc.Invoke(ctx, KeyManagementService_MacVerify_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *keyManagementServiceClient) Decapsulate(ctx context.Context, in *DecapsulateRequest, opts ...grpc.CallOption) (*DecapsulateResponse, error) {
	out := new(DecapsulateResponse)
	err := c.cc.Invoke(ctx, KeyManagementService_Decapsulate_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *keyManagementServiceClient) GenerateRandomBytes(ctx context.Context, in *GenerateRandomBytesRequest, opts ...grpc.CallOption) (*GenerateRandomBytesResponse, error) {
	out := new(GenerateRandomBytesResponse)
	err := c.cc.Invoke(ctx, KeyManagementService_GenerateRandomBytes_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// KeyManagementServiceServer is the server API for KeyManagementService service.
// All implementations should embed UnimplementedKeyManagementServiceServer
// for forward compatibility
type KeyManagementServiceServer interface {
	// Lists [KeyRings][google.cloud.kms.v1.KeyRing].
	ListKeyRings(context.Context, *ListKeyRingsRequest) (*ListKeyRingsResponse, error)
	// Lists [CryptoKeys][google.cloud.kms.v1.CryptoKey].
	ListCryptoKeys(context.Context, *ListCryptoKeysRequest) (*ListCryptoKeysResponse, error)
	// Lists [CryptoKeyVersions][google.cloud.kms.v1.CryptoKeyVersion].
	ListCryptoKeyVersions(context.Context, *ListCryptoKeyVersionsRequest) (*ListCryptoKeyVersionsResponse, error)
	// Lists [ImportJobs][google.cloud.kms.v1.ImportJob].
	ListImportJobs(context.Context, *ListImportJobsRequest) (*ListImportJobsResponse, error)
	// Returns metadata for a given [KeyRing][google.cloud.kms.v1.KeyRing].
	GetKeyRing(context.Context, *GetKeyRingRequest) (*KeyRing, error)
	// Returns metadata for a given [CryptoKey][google.cloud.kms.v1.CryptoKey], as
	// well as its [primary][google.cloud.kms.v1.CryptoKey.primary]
	// [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion].
	GetCryptoKey(context.Context, *GetCryptoKeyRequest) (*CryptoKey, error)
	// Returns metadata for a given
	// [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion].
	GetCryptoKeyVersion(context.Context, *GetCryptoKeyVersionRequest) (*CryptoKeyVersion, error)
	// Returns the public key for the given
	// [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion]. The
	// [CryptoKey.purpose][google.cloud.kms.v1.CryptoKey.purpose] must be
	// [ASYMMETRIC_SIGN][google.cloud.kms.v1.CryptoKey.CryptoKeyPurpose.ASYMMETRIC_SIGN]
	// or
	// [ASYMMETRIC_DECRYPT][google.cloud.kms.v1.CryptoKey.CryptoKeyPurpose.ASYMMETRIC_DECRYPT].
	GetPublicKey(context.Context, *GetPublicKeyRequest) (*PublicKey, error)
	// Returns metadata for a given [ImportJob][google.cloud.kms.v1.ImportJob].
	GetImportJob(context.Context, *GetImportJobRequest) (*ImportJob, error)
	// Create a new [KeyRing][google.cloud.kms.v1.KeyRing] in a given Project and
	// Location.
	CreateKeyRing(context.Context, *CreateKeyRingRequest) (*KeyRing, error)
	// Create a new [CryptoKey][google.cloud.kms.v1.CryptoKey] within a
	// [KeyRing][google.cloud.kms.v1.KeyRing].
	//
	// [CryptoKey.purpose][google.cloud.kms.v1.CryptoKey.purpose] and
	// [CryptoKey.version_template.algorithm][google.cloud.kms.v1.CryptoKeyVersionTemplate.algorithm]
	// are required.
	CreateCryptoKey(context.Context, *CreateCryptoKeyRequest) (*CryptoKey, error)
	// Create a new [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] in a
	// [CryptoKey][google.cloud.kms.v1.CryptoKey].
	//
	// The server will assign the next sequential id. If unset,
	// [state][google.cloud.kms.v1.CryptoKeyVersion.state] will be set to
	// [ENABLED][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.ENABLED].
	CreateCryptoKeyVersion(context.Context, *CreateCryptoKeyVersionRequest) (*CryptoKeyVersion, error)
	// Import wrapped key material into a
	// [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion].
	//
	// All requests must specify a [CryptoKey][google.cloud.kms.v1.CryptoKey]. If
	// a [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] is additionally
	// specified in the request, key material will be reimported into that
	// version. Otherwise, a new version will be created, and will be assigned the
	// next sequential id within the [CryptoKey][google.cloud.kms.v1.CryptoKey].
	ImportCryptoKeyVersion(context.Context, *ImportCryptoKeyVersionRequest) (*CryptoKeyVersion, error)
	// Create a new [ImportJob][google.cloud.kms.v1.ImportJob] within a
	// [KeyRing][google.cloud.kms.v1.KeyRing].
	//
	// [ImportJob.import_method][google.cloud.kms.v1.ImportJob.import_method] is
	// required.
	CreateImportJob(context.Context, *CreateImportJobRequest) (*ImportJob, error)
	// Update a [CryptoKey][google.cloud.kms.v1.CryptoKey].
	UpdateCryptoKey(context.Context, *UpdateCryptoKeyRequest) (*CryptoKey, error)
	// Update a [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion]'s
	// metadata.
	//
	// [state][google.cloud.kms.v1.CryptoKeyVersion.state] may be changed between
	// [ENABLED][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.ENABLED]
	// and
	// [DISABLED][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.DISABLED]
	// using this method. See
	// [DestroyCryptoKeyVersion][google.cloud.kms.v1.KeyManagementService.DestroyCryptoKeyVersion]
	// and
	// [RestoreCryptoKeyVersion][google.cloud.kms.v1.KeyManagementService.RestoreCryptoKeyVersion]
	// to move between other states.
	UpdateCryptoKeyVersion(context.Context, *UpdateCryptoKeyVersionRequest) (*CryptoKeyVersion, error)
	// Update the version of a [CryptoKey][google.cloud.kms.v1.CryptoKey] that
	// will be used in
	// [Encrypt][google.cloud.kms.v1.KeyManagementService.Encrypt].
	//
	// Returns an error if called on a key whose purpose is not
	// [ENCRYPT_DECRYPT][google.cloud.kms.v1.CryptoKey.CryptoKeyPurpose.ENCRYPT_DECRYPT].
	UpdateCryptoKeyPrimaryVersion(context.Context, *UpdateCryptoKeyPrimaryVersionRequest) (*CryptoKey, error)
	// Schedule a [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] for
	// destruction.
	//
	// Upon calling this method,
	// [CryptoKeyVersion.state][google.cloud.kms.v1.CryptoKeyVersion.state] will
	// be set to
	// [DESTROY_SCHEDULED][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.DESTROY_SCHEDULED],
	// and [destroy_time][google.cloud.kms.v1.CryptoKeyVersion.destroy_time] will
	// be set to the time
	// [destroy_scheduled_duration][google.cloud.kms.v1.CryptoKey.destroy_scheduled_duration]
	// in the future. At that time, the
	// [state][google.cloud.kms.v1.CryptoKeyVersion.state] will automatically
	// change to
	// [DESTROYED][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.DESTROYED],
	// and the key material will be irrevocably destroyed.
	//
	// Before the
	// [destroy_time][google.cloud.kms.v1.CryptoKeyVersion.destroy_time] is
	// reached,
	// [RestoreCryptoKeyVersion][google.cloud.kms.v1.KeyManagementService.RestoreCryptoKeyVersion]
	// may be called to reverse the process.
	DestroyCryptoKeyVersion(context.Context, *DestroyCryptoKeyVersionRequest) (*CryptoKeyVersion, error)
	// Restore a [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] in the
	// [DESTROY_SCHEDULED][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.DESTROY_SCHEDULED]
	// state.
	//
	// Upon restoration of the CryptoKeyVersion,
	// [state][google.cloud.kms.v1.CryptoKeyVersion.state] will be set to
	// [DISABLED][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.DISABLED],
	// and [destroy_time][google.cloud.kms.v1.CryptoKeyVersion.destroy_time] will
	// be cleared.
	RestoreCryptoKeyVersion(context.Context, *RestoreCryptoKeyVersionRequest) (*CryptoKeyVersion, error)
	// Encrypts data, so that it can only be recovered by a call to
	// [Decrypt][google.cloud.kms.v1.KeyManagementService.Decrypt]. The
	// [CryptoKey.purpose][google.cloud.kms.v1.CryptoKey.purpose] must be
	// [ENCRYPT_DECRYPT][google.cloud.kms.v1.CryptoKey.CryptoKeyPurpose.ENCRYPT_DECRYPT].
	Encrypt(context.Context, *EncryptRequest) (*EncryptResponse, error)
	// Decrypts data that was protected by
	// [Encrypt][google.cloud.kms.v1.KeyManagementService.Encrypt]. The
	// [CryptoKey.purpose][google.cloud.kms.v1.CryptoKey.purpose] must be
	// [ENCRYPT_DECRYPT][google.cloud.kms.v1.CryptoKey.CryptoKeyPurpose.ENCRYPT_DECRYPT].
	Decrypt(context.Context, *DecryptRequest) (*DecryptResponse, error)
	// Encrypts data using portable cryptographic primitives. Most users should
	// choose [Encrypt][google.cloud.kms.v1.KeyManagementService.Encrypt] and
	// [Decrypt][google.cloud.kms.v1.KeyManagementService.Decrypt] rather than
	// their raw counterparts. The
	// [CryptoKey.purpose][google.cloud.kms.v1.CryptoKey.purpose] must be
	// [RAW_ENCRYPT_DECRYPT][google.cloud.kms.v1.CryptoKey.CryptoKeyPurpose.RAW_ENCRYPT_DECRYPT].
	RawEncrypt(context.Context, *RawEncryptRequest) (*RawEncryptResponse, error)
	// Decrypts data that was originally encrypted using a raw cryptographic
	// mechanism. The [CryptoKey.purpose][google.cloud.kms.v1.CryptoKey.purpose]
	// must be
	// [RAW_ENCRYPT_DECRYPT][google.cloud.kms.v1.CryptoKey.CryptoKeyPurpose.RAW_ENCRYPT_DECRYPT].
	RawDecrypt(context.Context, *RawDecryptRequest) (*RawDecryptResponse, error)
	// Signs data using a [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion]
	// with [CryptoKey.purpose][google.cloud.kms.v1.CryptoKey.purpose]
	// ASYMMETRIC_SIGN, producing a signature that can be verified with the public
	// key retrieved from
	// [GetPublicKey][google.cloud.kms.v1.KeyManagementService.GetPublicKey].
	AsymmetricSign(context.Context, *AsymmetricSignRequest) (*AsymmetricSignResponse, error)
	// Decrypts data that was encrypted with a public key retrieved from
	// [GetPublicKey][google.cloud.kms.v1.KeyManagementService.GetPublicKey]
	// corresponding to a [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion]
	// with [CryptoKey.purpose][google.cloud.kms.v1.CryptoKey.purpose]
	// ASYMMETRIC_DECRYPT.
	AsymmetricDecrypt(context.Context, *AsymmetricDecryptRequest) (*AsymmetricDecryptResponse, error)
	// Signs data using a [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion]
	// with [CryptoKey.purpose][google.cloud.kms.v1.CryptoKey.purpose] MAC,
	// producing a tag that can be verified by another source with the same key.
	MacSign(context.Context, *MacSignRequest) (*MacSignResponse, error)
	// Verifies MAC tag using a
	// [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] with
	// [CryptoKey.purpose][google.cloud.kms.v1.CryptoKey.purpose] MAC, and returns
	// a response that indicates whether or not the verification was successful.
	MacVerify(context.Context, *MacVerifyRequest) (*MacVerifyResponse, error)
	// Decapsulates data that was encapsulated with a public key retrieved from
	// [GetPublicKey][google.cloud.kms.v1.KeyManagementService.GetPublicKey]
	// corresponding to a [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion]
	// with [CryptoKey.purpose][google.cloud.kms.v1.CryptoKey.purpose]
	// KEY_ENCAPSULATION.
	Decapsulate(context.Context, *DecapsulateRequest) (*DecapsulateResponse, error)
	// Generate random bytes using the Cloud KMS randomness source in the provided
	// location.
	GenerateRandomBytes(context.Context, *GenerateRandomBytesRequest) (*GenerateRandomBytesResponse, error)
}

// UnimplementedKeyManagementServiceServer should be embedded to have forward compatible implementations.
type UnimplementedKeyManagementServiceServer struct {
}

func (UnimplementedKeyManagementServiceServer) ListKeyRings(context.Context, *ListKeyRingsRequest) (*ListKeyRingsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListKeyRings not implemented")
}
func (UnimplementedKeyManagementServiceServer) ListCryptoKeys(context.Context, *ListCryptoKeysRequest) (*ListCryptoKeysResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListCryptoKeys not implemented")
}
func (UnimplementedKeyManagementServiceServer) ListCryptoKeyVersions(context.Context, *ListCryptoKeyVersionsRequest) (*ListCryptoKeyVersionsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListCryptoKeyVersions not implemented")
}
func (UnimplementedKeyManagementServiceServer) ListImportJobs(context.Context, *ListImportJobsRequest) (*ListImportJobsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListImportJobs not implemented")
}
func (UnimplementedKeyManagementServiceServer) GetKeyRing(context.Context, *GetKeyRingRequest) (*KeyRing, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetKeyRing not implemented")
}
func (UnimplementedKeyManagementServiceServer) GetCryptoKey(context.Context, *GetCryptoKeyRequest) (*CryptoKey, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetCryptoKey not implemented")
}
func (UnimplementedKeyManagementServiceServer) GetCryptoKeyVersion(context.Context, *GetCryptoKeyVersionRequest) (*CryptoKeyVersion, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetCryptoKeyVersion not implemented")
}
func (UnimplementedKeyManagementServiceServer) GetPublicKey(context.Context, *GetPublicKeyRequest) (*PublicKey, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetPublicKey not implemented")
}
func (UnimplementedKeyManagementServiceServer) GetImportJob(context.Context, *GetImportJobRequest) (*ImportJob, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetImportJob not implemented")
}
func (UnimplementedKeyManagementServiceServer) CreateKeyRing(context.Context, *CreateKeyRingRequest) (*KeyRing, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateKeyRing not implemented")
}
func (UnimplementedKeyManagementServiceServer) CreateCryptoKey(context.Context, *CreateCryptoKeyRequest) (*CryptoKey, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateCryptoKey not implemented")
}
func (UnimplementedKeyManagementServiceServer) CreateCryptoKeyVersion(context.Context, *CreateCryptoKeyVersionRequest) (*CryptoKeyVersion, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateCryptoKeyVersion not implemented")
}
func (UnimplementedKeyManagementServiceServer) ImportCryptoKeyVersion(context.Context, *ImportCryptoKeyVersionRequest) (*CryptoKeyVersion, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ImportCryptoKeyVersion not implemented")
}
func (UnimplementedKeyManagementServiceServer) CreateImportJob(context.Context, *CreateImportJobRequest) (*ImportJob, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateImportJob not implemented")
}
func (UnimplementedKeyManagementServiceServer) UpdateCryptoKey(context.Context, *UpdateCryptoKeyRequest) (*CryptoKey, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateCryptoKey not implemented")
}
func (UnimplementedKeyManagementServiceServer) UpdateCryptoKeyVersion(context.Context, *UpdateCryptoKeyVersionRequest) (*CryptoKeyVersion, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateCryptoKeyVersion not implemented")
}
func (UnimplementedKeyManagementServiceServer) UpdateCryptoKeyPrimaryVersion(context.Context, *UpdateCryptoKeyPrimaryVersionRequest) (*CryptoKey, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateCryptoKeyPrimaryVersion not implemented")
}
func (UnimplementedKeyManagementServiceServer) DestroyCryptoKeyVersion(context.Context, *DestroyCryptoKeyVersionRequest) (*CryptoKeyVersion, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DestroyCryptoKeyVersion not implemented")
}
func (UnimplementedKeyManagementServiceServer) RestoreCryptoKeyVersion(context.Context, *RestoreCryptoKeyVersionRequest) (*CryptoKeyVersion, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RestoreCryptoKeyVersion not implemented")
}
func (UnimplementedKeyManagementServiceServer) Encrypt(context.Context, *EncryptRequest) (*EncryptResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Encrypt not implemented")
}
func (UnimplementedKeyManagementServiceServer) Decrypt(context.Context, *DecryptRequest) (*DecryptResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Decrypt not implemented")
}
func (UnimplementedKeyManagementServiceServer) RawEncrypt(context.Context, *RawEncryptRequest) (*RawEncryptResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RawEncrypt not implemented")
}
func (UnimplementedKeyManagementServiceServer) RawDecrypt(context.Context, *RawDecryptRequest) (*RawDecryptResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RawDecrypt not implemented")
}
func (UnimplementedKeyManagementServiceServer) AsymmetricSign(context.Context, *AsymmetricSignRequest) (*AsymmetricSignResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method AsymmetricSign not implemented")
}
func (UnimplementedKeyManagementServiceServer) AsymmetricDecrypt(context.Context, *AsymmetricDecryptRequest) (*AsymmetricDecryptResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method AsymmetricDecrypt not implemented")
}
func (UnimplementedKeyManagementServiceServer) MacSign(context.Context, *MacSignRequest) (*MacSignResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method MacSign not implemented")
}
func (UnimplementedKeyManagementServiceServer) MacVerify(context.Context, *MacVerifyRequest) (*MacVerifyResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method MacVerify not implemented")
}
func (UnimplementedKeyManagementServiceServer) Decapsulate(context.Context, *DecapsulateRequest) (*DecapsulateResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Decapsulate not implemented")
}
func (UnimplementedKeyManagementServiceServer) GenerateRandomBytes(context.Context, *GenerateRandomBytesRequest) (*GenerateRandomBytesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GenerateRandomBytes not implemented")
}

// UnsafeKeyManagementServiceServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to KeyManagementServiceServer will
// result in compilation errors.
type UnsafeKeyManagementServiceServer interface {
	mustEmbedUnimplementedKeyManagementServiceServer()
}

func RegisterKeyManagementServiceServer(s grpc.ServiceRegistrar, srv KeyManagementServiceServer) {
	s.RegisterService(&KeyManagementService_ServiceDesc, srv)
}

func _KeyManagementService_ListKeyRings_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListKeyRingsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(KeyManagementServiceServer).ListKeyRings(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: KeyManagementService_ListKeyRings_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(KeyManagementServiceServer).ListKeyRings(ctx, req.(*ListKeyRingsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _KeyManagementService_ListCryptoKeys_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListCryptoKeysRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(KeyManagementServiceServer).ListCryptoKeys(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: KeyManagementService_ListCryptoKeys_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(KeyManagementServiceServer).ListCryptoKeys(ctx, req.(*ListCryptoKeysRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _KeyManagementService_ListCryptoKeyVersions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListCryptoKeyVersionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(KeyManagementServiceServer).ListCryptoKeyVersions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: KeyManagementService_ListCryptoKeyVersions_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(KeyManagementServiceServer).ListCryptoKeyVersions(ctx, req.(*ListCryptoKeyVersionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _KeyManagementService_ListImportJobs_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListImportJobsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(KeyManagementServiceServer).ListImportJobs(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: KeyManagementService_ListImportJobs_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(KeyManagementServiceServer).ListImportJobs(ctx, req.(*ListImportJobsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _KeyManagementService_GetKeyRing_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetKeyRingRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(KeyManagementServiceServer).GetKeyRing(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: KeyManagementService_GetKeyRing_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(KeyManagementServiceServer).GetKeyRing(ctx, req.(*GetKeyRingRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _KeyManagementService_GetCryptoKey_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetCryptoKeyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(KeyManagementServiceServer).GetCryptoKey(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: KeyManagementService_GetCryptoKey_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(KeyManagementServiceServer).GetCryptoKey(ctx, req.(*GetCryptoKeyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _KeyManagementService_GetCryptoKeyVersion_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetCryptoKeyVersionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(KeyManagementServiceServer).GetCryptoKeyVersion(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: KeyManagementService_GetCryptoKeyVersion_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(KeyManagementServiceServer).GetCryptoKeyVersion(ctx, req.(*GetCryptoKeyVersionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _KeyManagementService_GetPublicKey_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetPublicKeyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(KeyManagementServiceServer).GetPublicKey(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: KeyManagementService_GetPublicKey_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(KeyManagementServiceServer).GetPublicKey(ctx, req.(*GetPublicKeyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _KeyManagementService_GetImportJob_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetImportJobRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(KeyManagementServiceServer).GetImportJob(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: KeyManagementService_GetImportJob_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(KeyManagementServiceServer).GetImportJob(ctx, req.(*GetImportJobRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _KeyManagementService_CreateKeyRing_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateKeyRingRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(KeyManagementServiceServer).CreateKeyRing(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: KeyManagementService_CreateKeyRing_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(KeyManagementServiceServer).CreateKeyRing(ctx, req.(*CreateKeyRingRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _KeyManagementService_CreateCryptoKey_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateCryptoKeyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(KeyManagementServiceServer).CreateCryptoKey(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: KeyManagementService_CreateCryptoKey_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(KeyManagementServiceServer).CreateCryptoKey(ctx, req.(*CreateCryptoKeyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _KeyManagementService_CreateCryptoKeyVersion_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateCryptoKeyVersionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(KeyManagementServiceServer).CreateCryptoKeyVersion(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: KeyManagementService_CreateCryptoKeyVersion_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(KeyManagementServiceServer).CreateCryptoKeyVersion(ctx, req.(*CreateCryptoKeyVersionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _KeyManagementService_ImportCryptoKeyVersion_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ImportCryptoKeyVersionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(KeyManagementServiceServer).ImportCryptoKeyVersion(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: KeyManagementService_ImportCryptoKeyVersion_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(KeyManagementServiceServer).ImportCryptoKeyVersion(ctx, req.(*ImportCryptoKeyVersionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _KeyManagementService_CreateImportJob_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateImportJobRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(KeyManagementServiceServer).CreateImportJob(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: KeyManagementService_CreateImportJob_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(KeyManagementServiceServer).CreateImportJob(ctx, req.(*CreateImportJobRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _KeyManagementService_UpdateCryptoKey_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateCryptoKeyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(KeyManagementServiceServer).UpdateCryptoKey(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: KeyManagementService_UpdateCryptoKey_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(KeyManagementServiceServer).UpdateCryptoKey(ctx, req.(*UpdateCryptoKeyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _KeyManagementService_UpdateCryptoKeyVersion_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateCryptoKeyVersionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(KeyManagementServiceServer).UpdateCryptoKeyVersion(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: KeyManagementService_UpdateCryptoKeyVersion_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(KeyManagementServiceServer).UpdateCryptoKeyVersion(ctx, req.(*UpdateCryptoKeyVersionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _KeyManagementService_UpdateCryptoKeyPrimaryVersion_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateCryptoKeyPrimaryVersionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(KeyManagementServiceServer).UpdateCryptoKeyPrimaryVersion(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: KeyManagementService_UpdateCryptoKeyPrimaryVersion_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(KeyManagementServiceServer).UpdateCryptoKeyPrimaryVersion(ctx, req.(*UpdateCryptoKeyPrimaryVersionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _KeyManagementService_DestroyCryptoKeyVersion_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DestroyCryptoKeyVersionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(KeyManagementServiceServer).DestroyCryptoKeyVersion(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: KeyManagementService_DestroyCryptoKeyVersion_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(KeyManagementServiceServer).DestroyCryptoKeyVersion(ctx, req.(*DestroyCryptoKeyVersionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _KeyManagementService_RestoreCryptoKeyVersion_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RestoreCryptoKeyVersionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(KeyManagementServiceServer).RestoreCryptoKeyVersion(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: KeyManagementService_RestoreCryptoKeyVersion_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(KeyManagementServiceServer).RestoreCryptoKeyVersion(ctx, req.(*RestoreCryptoKeyVersionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _KeyManagementService_Encrypt_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(EncryptRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(KeyManagementServiceServer).Encrypt(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: KeyManagementService_Encrypt_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(KeyManagementServiceServer).Encrypt(ctx, req.(*EncryptRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _KeyManagementService_Decrypt_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DecryptRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(KeyManagementServiceServer).Decrypt(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: KeyManagementService_Decrypt_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(KeyManagementServiceServer).Decrypt(ctx, req.(*DecryptRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _KeyManagementService_RawEncrypt_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RawEncryptRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(KeyManagementServiceServer).RawEncrypt(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: KeyManagementService_RawEncrypt_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(KeyManagementServiceServer).RawEncrypt(ctx, req.(*RawEncryptRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _KeyManagementService_RawDecrypt_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RawDecryptRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(KeyManagementServiceServer).RawDecrypt(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: KeyManagementService_RawDecrypt_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(KeyManagementServiceServer).RawDecrypt(ctx, req.(*RawDecryptRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _KeyManagementService_AsymmetricSign_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AsymmetricSignRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(KeyManagementServiceServer).AsymmetricSign(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: KeyManagementService_AsymmetricSign_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(KeyManagementServiceServer).AsymmetricSign(ctx, req.(*AsymmetricSignRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _KeyManagementService_AsymmetricDecrypt_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AsymmetricDecryptRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(KeyManagementServiceServer).AsymmetricDecrypt(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: KeyManagementService_AsymmetricDecrypt_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(KeyManagementServiceServer).AsymmetricDecrypt(ctx, req.(*AsymmetricDecryptRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _KeyManagementService_MacSign_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(MacSignRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(KeyManagementServiceServer).MacSign(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: KeyManagementService_MacSign_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(KeyManagementServiceServer).MacSign(ctx, req.(*MacSignRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _KeyManagementService_MacVerify_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(MacVerifyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(KeyManagementServiceServer).MacVerify(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: KeyManagementService_MacVerify_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(KeyManagementServiceServer).MacVerify(ctx, req.(*MacVerifyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _KeyManagementService_Decapsulate_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DecapsulateRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(KeyManagementServiceServer).Decapsulate(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: KeyManagementService_Decapsulate_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(KeyManagementServiceServer).Decapsulate(ctx, req.(*DecapsulateRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _KeyManagementService_GenerateRandomBytes_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GenerateRandomBytesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(KeyManagementServiceServer).GenerateRandomBytes(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: KeyManagementService_GenerateRandomBytes_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(KeyManagementServiceServer).GenerateRandomBytes(ctx, req.(*GenerateRandomBytesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// KeyManagementService_ServiceDesc is the grpc.ServiceDesc for KeyManagementService service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var KeyManagementService_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.kms.v1.KeyManagementService",
	HandlerType: (*KeyManagementServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ListKeyRings",
			Handler:    _KeyManagementService_ListKeyRings_Handler,
		},
		{
			MethodName: "ListCryptoKeys",
			Handler:    _KeyManagementService_ListCryptoKeys_Handler,
		},
		{
			MethodName: "ListCryptoKeyVersions",
			Handler:    _KeyManagementService_ListCryptoKeyVersions_Handler,
		},
		{
			MethodName: "ListImportJobs",
			Handler:    _KeyManagementService_ListImportJobs_Handler,
		},
		{
			MethodName: "GetKeyRing",
			Handler:    _KeyManagementService_GetKeyRing_Handler,
		},
		{
			MethodName: "GetCryptoKey",
			Handler:    _KeyManagementService_GetCryptoKey_Handler,
		},
		{
			MethodName: "GetCryptoKeyVersion",
			Handler:    _KeyManagementService_GetCryptoKeyVersion_Handler,
		},
		{
			MethodName: "GetPublicKey",
			Handler:    _KeyManagementService_GetPublicKey_Handler,
		},
		{
			MethodName: "GetImportJob",
			Handler:    _KeyManagementService_GetImportJob_Handler,
		},
		{
			MethodName: "CreateKeyRing",
			Handler:    _KeyManagementService_CreateKeyRing_Handler,
		},
		{
			MethodName: "CreateCryptoKey",
			Handler:    _KeyManagementService_CreateCryptoKey_Handler,
		},
		{
			MethodName: "CreateCryptoKeyVersion",
			Handler:    _KeyManagementService_CreateCryptoKeyVersion_Handler,
		},
		{
			MethodName: "ImportCryptoKeyVersion",
			Handler:    _KeyManagementService_ImportCryptoKeyVersion_Handler,
		},
		{
			MethodName: "CreateImportJob",
			Handler:    _KeyManagementService_CreateImportJob_Handler,
		},
		{
			MethodName: "UpdateCryptoKey",
			Handler:    _KeyManagementService_UpdateCryptoKey_Handler,
		},
		{
			MethodName: "UpdateCryptoKeyVersion",
			Handler:    _KeyManagementService_UpdateCryptoKeyVersion_Handler,
		},
		{
			MethodName: "UpdateCryptoKeyPrimaryVersion",
			Handler:    _KeyManagementService_UpdateCryptoKeyPrimaryVersion_Handler,
		},
		{
			MethodName: "DestroyCryptoKeyVersion",
			Handler:    _KeyManagementService_DestroyCryptoKeyVersion_Handler,
		},
		{
			MethodName: "RestoreCryptoKeyVersion",
			Handler:    _KeyManagementService_RestoreCryptoKeyVersion_Handler,
		},
		{
			MethodName: "Encrypt",
			Handler:    _KeyManagementService_Encrypt_Handler,
		},
		{
			MethodName: "Decrypt",
			Handler:    _KeyManagementService_Decrypt_Handler,
		},
		{
			MethodName: "RawEncrypt",
			Handler:    _KeyManagementService_RawEncrypt_Handler,
		},
		{
			MethodName: "RawDecrypt",
			Handler:    _KeyManagementService_RawDecrypt_Handler,
		},
		{
			MethodName: "AsymmetricSign",
			Handler:    _KeyManagementService_AsymmetricSign_Handler,
		},
		{
			MethodName: "AsymmetricDecrypt",
			Handler:    _KeyManagementService_AsymmetricDecrypt_Handler,
		},
		{
			MethodName: "MacSign",
			Handler:    _KeyManagementService_MacSign_Handler,
		},
		{
			MethodName: "MacVerify",
			Handler:    _KeyManagementService_MacVerify_Handler,
		},
		{
			MethodName: "Decapsulate",
			Handler:    _KeyManagementService_Decapsulate_Handler,
		},
		{
			MethodName: "GenerateRandomBytes",
			Handler:    _KeyManagementService_GenerateRandomBytes_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/kms/v1/service.proto",
}
