// Code generated by protoc-gen-go. DO NOT EDIT.
// source: plugins/device/proto/device.proto

package proto

import (
	context "context"
	fmt "fmt"
	proto "github.com/golang/protobuf/proto"
	duration "github.com/golang/protobuf/ptypes/duration"
	timestamp "github.com/golang/protobuf/ptypes/timestamp"
	proto1 "github.com/hashicorp/nomad/plugins/shared/structs/proto"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	math "math"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// FingerprintRequest is used to request for devices to be fingerprinted.
type FingerprintRequest struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *FingerprintRequest) Reset()         { *m = FingerprintRequest{} }
func (m *FingerprintRequest) String() string { return proto.CompactTextString(m) }
func (*FingerprintRequest) ProtoMessage()    {}
func (*FingerprintRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_5edb0c35c07fa415, []int{0}
}

func (m *FingerprintRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_FingerprintRequest.Unmarshal(m, b)
}
func (m *FingerprintRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_FingerprintRequest.Marshal(b, m, deterministic)
}
func (m *FingerprintRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_FingerprintRequest.Merge(m, src)
}
func (m *FingerprintRequest) XXX_Size() int {
	return xxx_messageInfo_FingerprintRequest.Size(m)
}
func (m *FingerprintRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_FingerprintRequest.DiscardUnknown(m)
}

var xxx_messageInfo_FingerprintRequest proto.InternalMessageInfo

// FingerprintResponse returns a set of detected devices.
type FingerprintResponse struct {
	// device_group is a group of devices that share a vendor, device_type, and
	// device_name. This is returned as a set so that a single plugin could
	// potentially detect several device types and models.
	DeviceGroup          []*DeviceGroup `protobuf:"bytes,1,rep,name=device_group,json=deviceGroup,proto3" json:"device_group,omitempty"`
	XXX_NoUnkeyedLiteral struct{}       `json:"-"`
	XXX_unrecognized     []byte         `json:"-"`
	XXX_sizecache        int32          `json:"-"`
}

func (m *FingerprintResponse) Reset()         { *m = FingerprintResponse{} }
func (m *FingerprintResponse) String() string { return proto.CompactTextString(m) }
func (*FingerprintResponse) ProtoMessage()    {}
func (*FingerprintResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_5edb0c35c07fa415, []int{1}
}

func (m *FingerprintResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_FingerprintResponse.Unmarshal(m, b)
}
func (m *FingerprintResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_FingerprintResponse.Marshal(b, m, deterministic)
}
func (m *FingerprintResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_FingerprintResponse.Merge(m, src)
}
func (m *FingerprintResponse) XXX_Size() int {
	return xxx_messageInfo_FingerprintResponse.Size(m)
}
func (m *FingerprintResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_FingerprintResponse.DiscardUnknown(m)
}

var xxx_messageInfo_FingerprintResponse proto.InternalMessageInfo

func (m *FingerprintResponse) GetDeviceGroup() []*DeviceGroup {
	if m != nil {
		return m.DeviceGroup
	}
	return nil
}

// DeviceGroup is a group of devices that share a vendor, device type and name.
type DeviceGroup struct {
	// vendor is the name of the vendor of the device
	Vendor string `protobuf:"bytes,1,opt,name=vendor,proto3" json:"vendor,omitempty"`
	// device_type is the type of the device (gpu, fpga, etc).
	DeviceType string `protobuf:"bytes,2,opt,name=device_type,json=deviceType,proto3" json:"device_type,omitempty"`
	// device_name is the name of the device.
	DeviceName string `protobuf:"bytes,3,opt,name=device_name,json=deviceName,proto3" json:"device_name,omitempty"`
	// devices is the set of devices detected by the plugin.
	Devices []*DetectedDevice `protobuf:"bytes,4,rep,name=devices,proto3" json:"devices,omitempty"`
	// attributes allows adding attributes to be used for constraints or
	// affinities.
	Attributes           map[string]*proto1.Attribute `protobuf:"bytes,5,rep,name=attributes,proto3" json:"attributes,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	XXX_NoUnkeyedLiteral struct{}                     `json:"-"`
	XXX_unrecognized     []byte                       `json:"-"`
	XXX_sizecache        int32                        `json:"-"`
}

func (m *DeviceGroup) Reset()         { *m = DeviceGroup{} }
func (m *DeviceGroup) String() string { return proto.CompactTextString(m) }
func (*DeviceGroup) ProtoMessage()    {}
func (*DeviceGroup) Descriptor() ([]byte, []int) {
	return fileDescriptor_5edb0c35c07fa415, []int{2}
}

func (m *DeviceGroup) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeviceGroup.Unmarshal(m, b)
}
func (m *DeviceGroup) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeviceGroup.Marshal(b, m, deterministic)
}
func (m *DeviceGroup) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeviceGroup.Merge(m, src)
}
func (m *DeviceGroup) XXX_Size() int {
	return xxx_messageInfo_DeviceGroup.Size(m)
}
func (m *DeviceGroup) XXX_DiscardUnknown() {
	xxx_messageInfo_DeviceGroup.DiscardUnknown(m)
}

var xxx_messageInfo_DeviceGroup proto.InternalMessageInfo

func (m *DeviceGroup) GetVendor() string {
	if m != nil {
		return m.Vendor
	}
	return ""
}

func (m *DeviceGroup) GetDeviceType() string {
	if m != nil {
		return m.DeviceType
	}
	return ""
}

func (m *DeviceGroup) GetDeviceName() string {
	if m != nil {
		return m.DeviceName
	}
	return ""
}

func (m *DeviceGroup) GetDevices() []*DetectedDevice {
	if m != nil {
		return m.Devices
	}
	return nil
}

func (m *DeviceGroup) GetAttributes() map[string]*proto1.Attribute {
	if m != nil {
		return m.Attributes
	}
	return nil
}

// DetectedDevice is a single detected device.
type DetectedDevice struct {
	// ID is the ID of the device. This ID is used during allocation and must be
	// stable across restarts of the device driver.
	// buf:lint:ignore FIELD_LOWER_SNAKE_CASE
	ID string `protobuf:"bytes,1,opt,name=ID,proto3" json:"ID,omitempty"`
	// Health of the device.
	Healthy bool `protobuf:"varint,2,opt,name=healthy,proto3" json:"healthy,omitempty"`
	// health_description allows the device plugin to optionally
	// annotate the health field with a human readable reason.
	HealthDescription string `protobuf:"bytes,3,opt,name=health_description,json=healthDescription,proto3" json:"health_description,omitempty"`
	// hw_locality is optionally set to expose hardware locality information for
	// more optimal placement decisions.
	HwLocality           *DeviceLocality `protobuf:"bytes,4,opt,name=hw_locality,json=hwLocality,proto3" json:"hw_locality,omitempty"`
	XXX_NoUnkeyedLiteral struct{}        `json:"-"`
	XXX_unrecognized     []byte          `json:"-"`
	XXX_sizecache        int32           `json:"-"`
}

func (m *DetectedDevice) Reset()         { *m = DetectedDevice{} }
func (m *DetectedDevice) String() string { return proto.CompactTextString(m) }
func (*DetectedDevice) ProtoMessage()    {}
func (*DetectedDevice) Descriptor() ([]byte, []int) {
	return fileDescriptor_5edb0c35c07fa415, []int{3}
}

func (m *DetectedDevice) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DetectedDevice.Unmarshal(m, b)
}
func (m *DetectedDevice) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DetectedDevice.Marshal(b, m, deterministic)
}
func (m *DetectedDevice) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DetectedDevice.Merge(m, src)
}
func (m *DetectedDevice) XXX_Size() int {
	return xxx_messageInfo_DetectedDevice.Size(m)
}
func (m *DetectedDevice) XXX_DiscardUnknown() {
	xxx_messageInfo_DetectedDevice.DiscardUnknown(m)
}

var xxx_messageInfo_DetectedDevice proto.InternalMessageInfo

func (m *DetectedDevice) GetID() string {
	if m != nil {
		return m.ID
	}
	return ""
}

func (m *DetectedDevice) GetHealthy() bool {
	if m != nil {
		return m.Healthy
	}
	return false
}

func (m *DetectedDevice) GetHealthDescription() string {
	if m != nil {
		return m.HealthDescription
	}
	return ""
}

func (m *DetectedDevice) GetHwLocality() *DeviceLocality {
	if m != nil {
		return m.HwLocality
	}
	return nil
}

// DeviceLocality is used to expose HW locality information about a device.
type DeviceLocality struct {
	// pci_bus_id is the PCI bus ID for the device. If reported, it
	// allows Nomad to make NUMA aware optimizations.
	PciBusId             string   `protobuf:"bytes,1,opt,name=pci_bus_id,json=pciBusId,proto3" json:"pci_bus_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeviceLocality) Reset()         { *m = DeviceLocality{} }
func (m *DeviceLocality) String() string { return proto.CompactTextString(m) }
func (*DeviceLocality) ProtoMessage()    {}
func (*DeviceLocality) Descriptor() ([]byte, []int) {
	return fileDescriptor_5edb0c35c07fa415, []int{4}
}

func (m *DeviceLocality) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeviceLocality.Unmarshal(m, b)
}
func (m *DeviceLocality) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeviceLocality.Marshal(b, m, deterministic)
}
func (m *DeviceLocality) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeviceLocality.Merge(m, src)
}
func (m *DeviceLocality) XXX_Size() int {
	return xxx_messageInfo_DeviceLocality.Size(m)
}
func (m *DeviceLocality) XXX_DiscardUnknown() {
	xxx_messageInfo_DeviceLocality.DiscardUnknown(m)
}

var xxx_messageInfo_DeviceLocality proto.InternalMessageInfo

func (m *DeviceLocality) GetPciBusId() string {
	if m != nil {
		return m.PciBusId
	}
	return ""
}

// ReserveRequest is used to ask the device driver for information on
// how to allocate the requested devices.
type ReserveRequest struct {
	// device_ids are the requested devices.
	DeviceIds            []string `protobuf:"bytes,1,rep,name=device_ids,json=deviceIds,proto3" json:"device_ids,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ReserveRequest) Reset()         { *m = ReserveRequest{} }
func (m *ReserveRequest) String() string { return proto.CompactTextString(m) }
func (*ReserveRequest) ProtoMessage()    {}
func (*ReserveRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_5edb0c35c07fa415, []int{5}
}

func (m *ReserveRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ReserveRequest.Unmarshal(m, b)
}
func (m *ReserveRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ReserveRequest.Marshal(b, m, deterministic)
}
func (m *ReserveRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ReserveRequest.Merge(m, src)
}
func (m *ReserveRequest) XXX_Size() int {
	return xxx_messageInfo_ReserveRequest.Size(m)
}
func (m *ReserveRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ReserveRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ReserveRequest proto.InternalMessageInfo

func (m *ReserveRequest) GetDeviceIds() []string {
	if m != nil {
		return m.DeviceIds
	}
	return nil
}

// ReserveResponse informs Nomad how to expose the requested devices
// to the task.
type ReserveResponse struct {
	// container_res contains information on how to mount the device
	// into a task isolated using container technologies (where the
	// host is shared)
	ContainerRes         *ContainerReservation `protobuf:"bytes,1,opt,name=container_res,json=containerRes,proto3" json:"container_res,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *ReserveResponse) Reset()         { *m = ReserveResponse{} }
func (m *ReserveResponse) String() string { return proto.CompactTextString(m) }
func (*ReserveResponse) ProtoMessage()    {}
func (*ReserveResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_5edb0c35c07fa415, []int{6}
}

func (m *ReserveResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ReserveResponse.Unmarshal(m, b)
}
func (m *ReserveResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ReserveResponse.Marshal(b, m, deterministic)
}
func (m *ReserveResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ReserveResponse.Merge(m, src)
}
func (m *ReserveResponse) XXX_Size() int {
	return xxx_messageInfo_ReserveResponse.Size(m)
}
func (m *ReserveResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ReserveResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ReserveResponse proto.InternalMessageInfo

func (m *ReserveResponse) GetContainerRes() *ContainerReservation {
	if m != nil {
		return m.ContainerRes
	}
	return nil
}

// ContainerReservation returns how to mount the device into a
// container that shares the host OS.
type ContainerReservation struct {
	// List of environment variable to be set
	Envs map[string]string `protobuf:"bytes,1,rep,name=envs,proto3" json:"envs,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Mounts for the task.
	Mounts []*Mount `protobuf:"bytes,2,rep,name=mounts,proto3" json:"mounts,omitempty"`
	// Devices for the task.
	Devices              []*DeviceSpec `protobuf:"bytes,3,rep,name=devices,proto3" json:"devices,omitempty"`
	XXX_NoUnkeyedLiteral struct{}      `json:"-"`
	XXX_unrecognized     []byte        `json:"-"`
	XXX_sizecache        int32         `json:"-"`
}

func (m *ContainerReservation) Reset()         { *m = ContainerReservation{} }
func (m *ContainerReservation) String() string { return proto.CompactTextString(m) }
func (*ContainerReservation) ProtoMessage()    {}
func (*ContainerReservation) Descriptor() ([]byte, []int) {
	return fileDescriptor_5edb0c35c07fa415, []int{7}
}

func (m *ContainerReservation) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ContainerReservation.Unmarshal(m, b)
}
func (m *ContainerReservation) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ContainerReservation.Marshal(b, m, deterministic)
}
func (m *ContainerReservation) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ContainerReservation.Merge(m, src)
}
func (m *ContainerReservation) XXX_Size() int {
	return xxx_messageInfo_ContainerReservation.Size(m)
}
func (m *ContainerReservation) XXX_DiscardUnknown() {
	xxx_messageInfo_ContainerReservation.DiscardUnknown(m)
}

var xxx_messageInfo_ContainerReservation proto.InternalMessageInfo

func (m *ContainerReservation) GetEnvs() map[string]string {
	if m != nil {
		return m.Envs
	}
	return nil
}

func (m *ContainerReservation) GetMounts() []*Mount {
	if m != nil {
		return m.Mounts
	}
	return nil
}

func (m *ContainerReservation) GetDevices() []*DeviceSpec {
	if m != nil {
		return m.Devices
	}
	return nil
}

// Mount specifies a host volume to mount into a task.
// where device library or tools are installed on host and task
type Mount struct {
	// Path of the mount within the task.
	TaskPath string `protobuf:"bytes,1,opt,name=task_path,json=taskPath,proto3" json:"task_path,omitempty"`
	// Path of the mount on the host.
	HostPath string `protobuf:"bytes,2,opt,name=host_path,json=hostPath,proto3" json:"host_path,omitempty"`
	// If set, the mount is read-only.
	ReadOnly             bool     `protobuf:"varint,3,opt,name=read_only,json=readOnly,proto3" json:"read_only,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Mount) Reset()         { *m = Mount{} }
func (m *Mount) String() string { return proto.CompactTextString(m) }
func (*Mount) ProtoMessage()    {}
func (*Mount) Descriptor() ([]byte, []int) {
	return fileDescriptor_5edb0c35c07fa415, []int{8}
}

func (m *Mount) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Mount.Unmarshal(m, b)
}
func (m *Mount) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Mount.Marshal(b, m, deterministic)
}
func (m *Mount) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Mount.Merge(m, src)
}
func (m *Mount) XXX_Size() int {
	return xxx_messageInfo_Mount.Size(m)
}
func (m *Mount) XXX_DiscardUnknown() {
	xxx_messageInfo_Mount.DiscardUnknown(m)
}

var xxx_messageInfo_Mount proto.InternalMessageInfo

func (m *Mount) GetTaskPath() string {
	if m != nil {
		return m.TaskPath
	}
	return ""
}

func (m *Mount) GetHostPath() string {
	if m != nil {
		return m.HostPath
	}
	return ""
}

func (m *Mount) GetReadOnly() bool {
	if m != nil {
		return m.ReadOnly
	}
	return false
}

// DeviceSpec specifies a host device to mount into a task.
type DeviceSpec struct {
	// Path of the device within the task.
	TaskPath string `protobuf:"bytes,1,opt,name=task_path,json=taskPath,proto3" json:"task_path,omitempty"`
	// Path of the device on the host.
	HostPath string `protobuf:"bytes,2,opt,name=host_path,json=hostPath,proto3" json:"host_path,omitempty"`
	// Cgroups permissions of the device, candidates are one or more of
	// * r - allows task to read from the specified device.
	// * w - allows task to write to the specified device.
	// * m - allows task to create device files that do not yet exist
	Permissions          string   `protobuf:"bytes,3,opt,name=permissions,proto3" json:"permissions,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeviceSpec) Reset()         { *m = DeviceSpec{} }
func (m *DeviceSpec) String() string { return proto.CompactTextString(m) }
func (*DeviceSpec) ProtoMessage()    {}
func (*DeviceSpec) Descriptor() ([]byte, []int) {
	return fileDescriptor_5edb0c35c07fa415, []int{9}
}

func (m *DeviceSpec) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeviceSpec.Unmarshal(m, b)
}
func (m *DeviceSpec) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeviceSpec.Marshal(b, m, deterministic)
}
func (m *DeviceSpec) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeviceSpec.Merge(m, src)
}
func (m *DeviceSpec) XXX_Size() int {
	return xxx_messageInfo_DeviceSpec.Size(m)
}
func (m *DeviceSpec) XXX_DiscardUnknown() {
	xxx_messageInfo_DeviceSpec.DiscardUnknown(m)
}

var xxx_messageInfo_DeviceSpec proto.InternalMessageInfo

func (m *DeviceSpec) GetTaskPath() string {
	if m != nil {
		return m.TaskPath
	}
	return ""
}

func (m *DeviceSpec) GetHostPath() string {
	if m != nil {
		return m.HostPath
	}
	return ""
}

func (m *DeviceSpec) GetPermissions() string {
	if m != nil {
		return m.Permissions
	}
	return ""
}

// StatsRequest is used to parameterize the retrieval of statistics.
type StatsRequest struct {
	// collection_interval is the duration in which to collect statistics.
	CollectionInterval   *duration.Duration `protobuf:"bytes,1,opt,name=collection_interval,json=collectionInterval,proto3" json:"collection_interval,omitempty"`
	XXX_NoUnkeyedLiteral struct{}           `json:"-"`
	XXX_unrecognized     []byte             `json:"-"`
	XXX_sizecache        int32              `json:"-"`
}

func (m *StatsRequest) Reset()         { *m = StatsRequest{} }
func (m *StatsRequest) String() string { return proto.CompactTextString(m) }
func (*StatsRequest) ProtoMessage()    {}
func (*StatsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_5edb0c35c07fa415, []int{10}
}

func (m *StatsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StatsRequest.Unmarshal(m, b)
}
func (m *StatsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StatsRequest.Marshal(b, m, deterministic)
}
func (m *StatsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StatsRequest.Merge(m, src)
}
func (m *StatsRequest) XXX_Size() int {
	return xxx_messageInfo_StatsRequest.Size(m)
}
func (m *StatsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_StatsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_StatsRequest proto.InternalMessageInfo

func (m *StatsRequest) GetCollectionInterval() *duration.Duration {
	if m != nil {
		return m.CollectionInterval
	}
	return nil
}

// StatsResponse returns the statistics for each device group.
type StatsResponse struct {
	// groups contains statistics for each device group.
	Groups               []*DeviceGroupStats `protobuf:"bytes,1,rep,name=groups,proto3" json:"groups,omitempty"`
	XXX_NoUnkeyedLiteral struct{}            `json:"-"`
	XXX_unrecognized     []byte              `json:"-"`
	XXX_sizecache        int32               `json:"-"`
}

func (m *StatsResponse) Reset()         { *m = StatsResponse{} }
func (m *StatsResponse) String() string { return proto.CompactTextString(m) }
func (*StatsResponse) ProtoMessage()    {}
func (*StatsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_5edb0c35c07fa415, []int{11}
}

func (m *StatsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StatsResponse.Unmarshal(m, b)
}
func (m *StatsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StatsResponse.Marshal(b, m, deterministic)
}
func (m *StatsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StatsResponse.Merge(m, src)
}
func (m *StatsResponse) XXX_Size() int {
	return xxx_messageInfo_StatsResponse.Size(m)
}
func (m *StatsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_StatsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_StatsResponse proto.InternalMessageInfo

func (m *StatsResponse) GetGroups() []*DeviceGroupStats {
	if m != nil {
		return m.Groups
	}
	return nil
}

// DeviceGroupStats contains statistics for each device of a particular
// device group, identified by the vendor, type and name of the device.
type DeviceGroupStats struct {
	Vendor string `protobuf:"bytes,1,opt,name=vendor,proto3" json:"vendor,omitempty"`
	Type   string `protobuf:"bytes,2,opt,name=type,proto3" json:"type,omitempty"`
	Name   string `protobuf:"bytes,3,opt,name=name,proto3" json:"name,omitempty"`
	// instance_stats is a mapping of each device ID to its statistics.
	InstanceStats        map[string]*DeviceStats `protobuf:"bytes,4,rep,name=instance_stats,json=instanceStats,proto3" json:"instance_stats,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	XXX_NoUnkeyedLiteral struct{}                `json:"-"`
	XXX_unrecognized     []byte                  `json:"-"`
	XXX_sizecache        int32                   `json:"-"`
}

func (m *DeviceGroupStats) Reset()         { *m = DeviceGroupStats{} }
func (m *DeviceGroupStats) String() string { return proto.CompactTextString(m) }
func (*DeviceGroupStats) ProtoMessage()    {}
func (*DeviceGroupStats) Descriptor() ([]byte, []int) {
	return fileDescriptor_5edb0c35c07fa415, []int{12}
}

func (m *DeviceGroupStats) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeviceGroupStats.Unmarshal(m, b)
}
func (m *DeviceGroupStats) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeviceGroupStats.Marshal(b, m, deterministic)
}
func (m *DeviceGroupStats) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeviceGroupStats.Merge(m, src)
}
func (m *DeviceGroupStats) XXX_Size() int {
	return xxx_messageInfo_DeviceGroupStats.Size(m)
}
func (m *DeviceGroupStats) XXX_DiscardUnknown() {
	xxx_messageInfo_DeviceGroupStats.DiscardUnknown(m)
}

var xxx_messageInfo_DeviceGroupStats proto.InternalMessageInfo

func (m *DeviceGroupStats) GetVendor() string {
	if m != nil {
		return m.Vendor
	}
	return ""
}

func (m *DeviceGroupStats) GetType() string {
	if m != nil {
		return m.Type
	}
	return ""
}

func (m *DeviceGroupStats) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *DeviceGroupStats) GetInstanceStats() map[string]*DeviceStats {
	if m != nil {
		return m.InstanceStats
	}
	return nil
}

// DeviceStats is the statistics for an individual device
type DeviceStats struct {
	// summary exposes a single summary metric that should be the most
	// informative to users.
	Summary *proto1.StatValue `protobuf:"bytes,1,opt,name=summary,proto3" json:"summary,omitempty"`
	// stats contains the verbose statistics for the device.
	Stats *proto1.StatObject `protobuf:"bytes,2,opt,name=stats,proto3" json:"stats,omitempty"`
	// timestamp is the time the statistics were collected.
	Timestamp            *timestamp.Timestamp `protobuf:"bytes,3,opt,name=timestamp,proto3" json:"timestamp,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *DeviceStats) Reset()         { *m = DeviceStats{} }
func (m *DeviceStats) String() string { return proto.CompactTextString(m) }
func (*DeviceStats) ProtoMessage()    {}
func (*DeviceStats) Descriptor() ([]byte, []int) {
	return fileDescriptor_5edb0c35c07fa415, []int{13}
}

func (m *DeviceStats) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeviceStats.Unmarshal(m, b)
}
func (m *DeviceStats) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeviceStats.Marshal(b, m, deterministic)
}
func (m *DeviceStats) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeviceStats.Merge(m, src)
}
func (m *DeviceStats) XXX_Size() int {
	return xxx_messageInfo_DeviceStats.Size(m)
}
func (m *DeviceStats) XXX_DiscardUnknown() {
	xxx_messageInfo_DeviceStats.DiscardUnknown(m)
}

var xxx_messageInfo_DeviceStats proto.InternalMessageInfo

func (m *DeviceStats) GetSummary() *proto1.StatValue {
	if m != nil {
		return m.Summary
	}
	return nil
}

func (m *DeviceStats) GetStats() *proto1.StatObject {
	if m != nil {
		return m.Stats
	}
	return nil
}

func (m *DeviceStats) GetTimestamp() *timestamp.Timestamp {
	if m != nil {
		return m.Timestamp
	}
	return nil
}

func init() {
	proto.RegisterType((*FingerprintRequest)(nil), "hashicorp.nomad.plugins.device.FingerprintRequest")
	proto.RegisterType((*FingerprintResponse)(nil), "hashicorp.nomad.plugins.device.FingerprintResponse")
	proto.RegisterType((*DeviceGroup)(nil), "hashicorp.nomad.plugins.device.DeviceGroup")
	proto.RegisterMapType((map[string]*proto1.Attribute)(nil), "hashicorp.nomad.plugins.device.DeviceGroup.AttributesEntry")
	proto.RegisterType((*DetectedDevice)(nil), "hashicorp.nomad.plugins.device.DetectedDevice")
	proto.RegisterType((*DeviceLocality)(nil), "hashicorp.nomad.plugins.device.DeviceLocality")
	proto.RegisterType((*ReserveRequest)(nil), "hashicorp.nomad.plugins.device.ReserveRequest")
	proto.RegisterType((*ReserveResponse)(nil), "hashicorp.nomad.plugins.device.ReserveResponse")
	proto.RegisterType((*ContainerReservation)(nil), "hashicorp.nomad.plugins.device.ContainerReservation")
	proto.RegisterMapType((map[string]string)(nil), "hashicorp.nomad.plugins.device.ContainerReservation.EnvsEntry")
	proto.RegisterType((*Mount)(nil), "hashicorp.nomad.plugins.device.Mount")
	proto.RegisterType((*DeviceSpec)(nil), "hashicorp.nomad.plugins.device.DeviceSpec")
	proto.RegisterType((*StatsRequest)(nil), "hashicorp.nomad.plugins.device.StatsRequest")
	proto.RegisterType((*StatsResponse)(nil), "hashicorp.nomad.plugins.device.StatsResponse")
	proto.RegisterType((*DeviceGroupStats)(nil), "hashicorp.nomad.plugins.device.DeviceGroupStats")
	proto.RegisterMapType((map[string]*DeviceStats)(nil), "hashicorp.nomad.plugins.device.DeviceGroupStats.InstanceStatsEntry")
	proto.RegisterType((*DeviceStats)(nil), "hashicorp.nomad.plugins.device.DeviceStats")
}

func init() {
	proto.RegisterFile("plugins/device/proto/device.proto", fileDescriptor_5edb0c35c07fa415)
}

var fileDescriptor_5edb0c35c07fa415 = []byte{
	// 965 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xa4, 0x56, 0xef, 0x8e, 0xdb, 0x44,
	0x10, 0x27, 0xc9, 0xe5, 0x92, 0x4c, 0xee, 0xae, 0x65, 0x7b, 0x42, 0xc6, 0x40, 0x7b, 0x58, 0x42,
	0x3a, 0x41, 0xeb, 0x94, 0x14, 0x89, 0x0a, 0x04, 0x52, 0xdb, 0x94, 0x5e, 0xf8, 0xd3, 0xab, 0xb6,
	0x15, 0x52, 0x8b, 0x84, 0xb5, 0x67, 0x2f, 0xf1, 0xb6, 0xf6, 0xda, 0xec, 0xae, 0x53, 0x99, 0x4f,
	0x3c, 0x0e, 0x5f, 0x78, 0x01, 0x1e, 0x86, 0x0f, 0x3c, 0x09, 0xf2, 0xee, 0x3a, 0xf1, 0xfd, 0xe9,
	0x25, 0x81, 0x4f, 0xde, 0x9d, 0x99, 0xdf, 0xcc, 0xec, 0xcc, 0x6f, 0x67, 0x0d, 0x1f, 0xe6, 0x49,
	0x31, 0x63, 0x5c, 0x8e, 0x22, 0x3a, 0x67, 0x21, 0x1d, 0xe5, 0x22, 0x53, 0x99, 0xdd, 0xf8, 0x7a,
	0x83, 0xae, 0xc7, 0x44, 0xc6, 0x2c, 0xcc, 0x44, 0xee, 0xf3, 0x2c, 0x25, 0x91, 0x6f, 0x21, 0xbe,
	0xb1, 0x72, 0x6f, 0xcc, 0xb2, 0x6c, 0x96, 0x58, 0xe8, 0x49, 0xf1, 0xcb, 0x48, 0xb1, 0x94, 0x4a,
	0x45, 0xd2, 0xdc, 0x38, 0x70, 0xaf, 0x9f, 0x35, 0x88, 0x0a, 0x41, 0x14, 0xcb, 0xb8, 0xd5, 0xdf,
	0xac, 0x73, 0x90, 0x31, 0x11, 0x34, 0x1a, 0x49, 0x25, 0x8a, 0x50, 0x49, 0x9b, 0x0b, 0x51, 0x4a,
	0xb0, 0x93, 0x42, 0xd9, 0x74, 0xdc, 0xc3, 0x4b, 0xad, 0xa5, 0x22, 0x4a, 0x1a, 0x4b, 0x6f, 0x1f,
	0xd0, 0x37, 0x8c, 0xcf, 0xa8, 0xc8, 0x05, 0xe3, 0x0a, 0xd3, 0x5f, 0x0b, 0x2a, 0x95, 0x47, 0xe1,
	0xda, 0x29, 0xa9, 0xcc, 0x33, 0x2e, 0x29, 0x7a, 0x0c, 0x3b, 0xe6, 0x3c, 0xc1, 0x4c, 0x64, 0x45,
	0xee, 0xb4, 0x0e, 0x3a, 0x87, 0xc3, 0xf1, 0x27, 0xfe, 0xe5, 0x87, 0xf7, 0x27, 0xfa, 0xf3, 0xa8,
	0x82, 0xe0, 0x61, 0xb4, 0xdc, 0x78, 0xbf, 0x77, 0x60, 0xd8, 0x50, 0xa2, 0x77, 0x60, 0x7b, 0x4e,
	0x79, 0x94, 0x09, 0xa7, 0x75, 0xd0, 0x3a, 0x1c, 0x60, 0xbb, 0x43, 0x37, 0xc0, 0xc2, 0x02, 0x55,
	0xe6, 0xd4, 0x69, 0x6b, 0x25, 0x18, 0xd1, 0xb3, 0x32, 0xa7, 0x0d, 0x03, 0x4e, 0x52, 0xea, 0x74,
	0x9a, 0x06, 0x8f, 0x49, 0x4a, 0xd1, 0x11, 0xf4, 0xcc, 0x4e, 0x3a, 0x5b, 0x3a, 0x69, 0x7f, 0x75,
	0xd2, 0x8a, 0x86, 0x8a, 0x46, 0x26, 0x3f, 0x5c, 0xc3, 0xd1, 0x4f, 0x00, 0x8b, 0x6a, 0x4b, 0xa7,
	0xab, 0x9d, 0x7d, 0xb9, 0x41, 0x05, 0xfc, 0x7b, 0x0b, 0xf4, 0x43, 0xae, 0x44, 0x89, 0x1b, 0xee,
	0xdc, 0x1c, 0xae, 0x9c, 0x51, 0xa3, 0xab, 0xd0, 0x79, 0x45, 0x4b, 0x5b, 0x90, 0x6a, 0x89, 0x1e,
	0x41, 0x77, 0x4e, 0x92, 0xc2, 0xd4, 0x61, 0x38, 0xfe, 0xf4, 0x8d, 0xc1, 0x4d, 0xf3, 0x7d, 0xdb,
	0xfc, 0x65, 0x60, 0x6c, 0xf0, 0x5f, 0xb4, 0xef, 0xb6, 0xbc, 0xbf, 0x5a, 0xb0, 0x77, 0xfa, 0xa8,
	0x68, 0x0f, 0xda, 0xd3, 0x89, 0x0d, 0xd8, 0x9e, 0x4e, 0x90, 0x03, 0xbd, 0x98, 0x92, 0x44, 0xc5,
	0xa5, 0x8e, 0xd8, 0xc7, 0xf5, 0x16, 0xdd, 0x02, 0x64, 0x96, 0x41, 0x44, 0x65, 0x28, 0x58, 0x5e,
	0x11, 0xd6, 0x56, 0xff, 0x6d, 0xa3, 0x99, 0x2c, 0x15, 0xe8, 0x18, 0x86, 0xf1, 0xeb, 0x20, 0xc9,
	0x42, 0x92, 0x30, 0x55, 0x3a, 0x5b, 0x3a, 0x7d, 0x7f, 0xbd, 0xda, 0x7d, 0x6f, 0x51, 0x18, 0xe2,
	0xd7, 0xf5, 0xda, 0xf3, 0xab, 0xdc, 0x9b, 0x5a, 0xf4, 0x3e, 0x40, 0x1e, 0xb2, 0xe0, 0xa4, 0x90,
	0x01, 0x8b, 0xec, 0x19, 0xfa, 0x79, 0xc8, 0xee, 0x17, 0x72, 0x1a, 0x79, 0x23, 0xd8, 0xc3, 0x54,
	0x52, 0x31, 0xa7, 0x96, 0xe8, 0xe8, 0x03, 0xb0, 0x2c, 0x09, 0x58, 0x24, 0x35, 0x9f, 0x07, 0x78,
	0x60, 0x24, 0xd3, 0x48, 0x7a, 0x09, 0x5c, 0x59, 0x00, 0xec, 0x1d, 0x78, 0x0e, 0xbb, 0x61, 0xc6,
	0x15, 0x61, 0x9c, 0x8a, 0x40, 0x50, 0xa9, 0x83, 0x0c, 0xc7, 0x9f, 0xad, 0x3a, 0xc6, 0x83, 0x1a,
	0x64, 0x1c, 0xea, 0xbb, 0x8d, 0x77, 0xc2, 0x86, 0xd4, 0xfb, 0xa3, 0x0d, 0xfb, 0x17, 0x99, 0x21,
	0x0c, 0x5b, 0x94, 0xcf, 0xa5, 0xbd, 0x6f, 0x5f, 0xff, 0x97, 0x50, 0xfe, 0x43, 0x3e, 0xb7, 0x84,
	0xd3, 0xbe, 0xd0, 0x57, 0xb0, 0x9d, 0x66, 0x05, 0x57, 0xd2, 0x69, 0x6b, 0xaf, 0x1f, 0xad, 0xf2,
	0xfa, 0x43, 0x65, 0x8d, 0x2d, 0x08, 0x4d, 0x96, 0x17, 0xaa, 0xa3, 0xf1, 0x1f, 0xaf, 0xd7, 0xc7,
	0xa7, 0x39, 0x0d, 0x17, 0x97, 0xc9, 0xfd, 0x1c, 0x06, 0x8b, 0xbc, 0x2e, 0x60, 0xfa, 0x7e, 0x93,
	0xe9, 0x83, 0x26, 0x6d, 0x7f, 0x86, 0xae, 0xce, 0x07, 0xbd, 0x07, 0x03, 0x45, 0xe4, 0xab, 0x20,
	0x27, 0x2a, 0xae, 0xfb, 0x5d, 0x09, 0x9e, 0x10, 0x15, 0x57, 0xca, 0x38, 0x93, 0xca, 0x28, 0x8d,
	0x8f, 0x7e, 0x25, 0xa8, 0x95, 0x82, 0x92, 0x28, 0xc8, 0x78, 0x52, 0x6a, 0xce, 0xf6, 0x71, 0xbf,
	0x12, 0x1c, 0xf3, 0xa4, 0xf4, 0x62, 0x80, 0x65, 0xbe, 0xff, 0x23, 0xc8, 0x01, 0x0c, 0x73, 0x2a,
	0x52, 0x26, 0x25, 0xcb, 0xb8, 0xb4, 0x57, 0xa3, 0x29, 0xf2, 0x5e, 0xc0, 0xce, 0xd3, 0x6a, 0x1e,
	0xd7, 0x8c, 0xfc, 0x16, 0xae, 0x85, 0x59, 0x92, 0xd0, 0xb0, 0xea, 0x5a, 0xc0, 0xb8, 0xaa, 0x3a,
	0x98, 0x58, 0x96, 0xbd, 0xeb, 0x9b, 0x67, 0xc2, 0xaf, 0x9f, 0x09, 0x7f, 0x62, 0x9f, 0x09, 0x8c,
	0x96, 0xa8, 0xa9, 0x05, 0x79, 0xcf, 0x61, 0xd7, 0xfa, 0xb6, 0xe4, 0x3d, 0x82, 0x6d, 0x3d, 0xb9,
	0x6b, 0x2a, 0xdd, 0xde, 0x60, 0x70, 0x19, 0x4f, 0x16, 0xef, 0xfd, 0xd9, 0x86, 0xab, 0x67, 0x95,
	0x6f, 0x9c, 0xdf, 0x08, 0xb6, 0x1a, 0x83, 0x5b, 0xaf, 0x2b, 0x59, 0x63, 0x56, 0xeb, 0x35, 0x7a,
	0x09, 0x7b, 0x8c, 0x4b, 0x45, 0x78, 0x48, 0x03, 0xfd, 0x48, 0xd9, 0x61, 0xfd, 0x60, 0xd3, 0x34,
	0xfd, 0xa9, 0x75, 0xa3, 0x77, 0x86, 0xf6, 0xbb, 0xac, 0x29, 0x73, 0x53, 0x40, 0xe7, 0x8d, 0x2e,
	0xe0, 0xe0, 0xbd, 0xd3, 0xd3, 0x76, 0xcd, 0xc7, 0xce, 0x14, 0xab, 0x41, 0xd8, 0xbf, 0x5b, 0xf5,
	0x53, 0x67, 0x4a, 0xf5, 0x1d, 0xf4, 0x64, 0x91, 0xa6, 0x44, 0x94, 0xb6, 0xb5, 0x6b, 0x8f, 0xf1,
	0x0a, 0xff, 0x63, 0xe5, 0x17, 0xd7, 0x1e, 0xd0, 0x11, 0x74, 0x4d, 0xb9, 0x4c, 0x8e, 0xe3, 0x4d,
	0x5c, 0x1d, 0x9f, 0xbc, 0xa4, 0xa1, 0xc2, 0xc6, 0x01, 0xba, 0x0b, 0x83, 0xc5, 0x9f, 0x89, 0x6e,
	0xcd, 0x70, 0xec, 0x9e, 0xe3, 0xdc, 0xb3, 0xda, 0x02, 0x2f, 0x8d, 0xc7, 0xff, 0xb4, 0x61, 0xc7,
	0x1c, 0xf0, 0x89, 0x0e, 0x86, 0x7e, 0x83, 0x61, 0xe3, 0x1f, 0x02, 0x8d, 0x57, 0x15, 0xee, 0xfc,
	0x6f, 0x88, 0x7b, 0x67, 0x23, 0x8c, 0xe1, 0xb8, 0xf7, 0xd6, 0xed, 0x16, 0x4a, 0xa0, 0x67, 0xe7,
	0x36, 0x5a, 0xf9, 0xbe, 0x9c, 0x7e, 0x11, 0xdc, 0xd1, 0xda, 0xf6, 0x75, 0x3c, 0x14, 0x43, 0xd7,
	0x34, 0xf5, 0xe6, 0x2a, 0x6c, 0xf3, 0xa6, 0xbb, 0xb7, 0xd6, 0xb4, 0x5e, 0x9e, 0xeb, 0x7e, 0xef,
	0x45, 0xd7, 0x74, 0x61, 0x5b, 0x7f, 0xee, 0xfc, 0x1b, 0x00, 0x00, 0xff, 0xff, 0x11, 0xd4, 0x56,
	0x04, 0x9b, 0x0a, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// DevicePluginClient is the client API for DevicePlugin service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type DevicePluginClient interface {
	// Fingerprint allows the device plugin to return a set of
	// detected devices and provide a mechanism to update the state of
	// the device.
	Fingerprint(ctx context.Context, in *FingerprintRequest, opts ...grpc.CallOption) (DevicePlugin_FingerprintClient, error)
	// Reserve is called by the client before starting an allocation
	// that requires access to the plugin’s devices. The plugin can use
	// this to run any setup steps and provides the mounting details to
	// the Nomad client
	Reserve(ctx context.Context, in *ReserveRequest, opts ...grpc.CallOption) (*ReserveResponse, error)
	// Stats returns a stream of device statistics.
	Stats(ctx context.Context, in *StatsRequest, opts ...grpc.CallOption) (DevicePlugin_StatsClient, error)
}

type devicePluginClient struct {
	cc grpc.ClientConnInterface
}

func NewDevicePluginClient(cc grpc.ClientConnInterface) DevicePluginClient {
	return &devicePluginClient{cc}
}

func (c *devicePluginClient) Fingerprint(ctx context.Context, in *FingerprintRequest, opts ...grpc.CallOption) (DevicePlugin_FingerprintClient, error) {
	stream, err := c.cc.NewStream(ctx, &_DevicePlugin_serviceDesc.Streams[0], "/hashicorp.nomad.plugins.device.DevicePlugin/Fingerprint", opts...)
	if err != nil {
		return nil, err
	}
	x := &devicePluginFingerprintClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type DevicePlugin_FingerprintClient interface {
	Recv() (*FingerprintResponse, error)
	grpc.ClientStream
}

type devicePluginFingerprintClient struct {
	grpc.ClientStream
}

func (x *devicePluginFingerprintClient) Recv() (*FingerprintResponse, error) {
	m := new(FingerprintResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *devicePluginClient) Reserve(ctx context.Context, in *ReserveRequest, opts ...grpc.CallOption) (*ReserveResponse, error) {
	out := new(ReserveResponse)
	err := c.cc.Invoke(ctx, "/hashicorp.nomad.plugins.device.DevicePlugin/Reserve", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *devicePluginClient) Stats(ctx context.Context, in *StatsRequest, opts ...grpc.CallOption) (DevicePlugin_StatsClient, error) {
	stream, err := c.cc.NewStream(ctx, &_DevicePlugin_serviceDesc.Streams[1], "/hashicorp.nomad.plugins.device.DevicePlugin/Stats", opts...)
	if err != nil {
		return nil, err
	}
	x := &devicePluginStatsClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type DevicePlugin_StatsClient interface {
	Recv() (*StatsResponse, error)
	grpc.ClientStream
}

type devicePluginStatsClient struct {
	grpc.ClientStream
}

func (x *devicePluginStatsClient) Recv() (*StatsResponse, error) {
	m := new(StatsResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

// DevicePluginServer is the server API for DevicePlugin service.
type DevicePluginServer interface {
	// Fingerprint allows the device plugin to return a set of
	// detected devices and provide a mechanism to update the state of
	// the device.
	Fingerprint(*FingerprintRequest, DevicePlugin_FingerprintServer) error
	// Reserve is called by the client before starting an allocation
	// that requires access to the plugin’s devices. The plugin can use
	// this to run any setup steps and provides the mounting details to
	// the Nomad client
	Reserve(context.Context, *ReserveRequest) (*ReserveResponse, error)
	// Stats returns a stream of device statistics.
	Stats(*StatsRequest, DevicePlugin_StatsServer) error
}

// UnimplementedDevicePluginServer can be embedded to have forward compatible implementations.
type UnimplementedDevicePluginServer struct {
}

func (*UnimplementedDevicePluginServer) Fingerprint(req *FingerprintRequest, srv DevicePlugin_FingerprintServer) error {
	return status.Errorf(codes.Unimplemented, "method Fingerprint not implemented")
}
func (*UnimplementedDevicePluginServer) Reserve(ctx context.Context, req *ReserveRequest) (*ReserveResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Reserve not implemented")
}
func (*UnimplementedDevicePluginServer) Stats(req *StatsRequest, srv DevicePlugin_StatsServer) error {
	return status.Errorf(codes.Unimplemented, "method Stats not implemented")
}

func RegisterDevicePluginServer(s *grpc.Server, srv DevicePluginServer) {
	s.RegisterService(&_DevicePlugin_serviceDesc, srv)
}

func _DevicePlugin_Fingerprint_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(FingerprintRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(DevicePluginServer).Fingerprint(m, &devicePluginFingerprintServer{stream})
}

type DevicePlugin_FingerprintServer interface {
	Send(*FingerprintResponse) error
	grpc.ServerStream
}

type devicePluginFingerprintServer struct {
	grpc.ServerStream
}

func (x *devicePluginFingerprintServer) Send(m *FingerprintResponse) error {
	return x.ServerStream.SendMsg(m)
}

func _DevicePlugin_Reserve_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ReserveRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DevicePluginServer).Reserve(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/hashicorp.nomad.plugins.device.DevicePlugin/Reserve",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DevicePluginServer).Reserve(ctx, req.(*ReserveRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DevicePlugin_Stats_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(StatsRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(DevicePluginServer).Stats(m, &devicePluginStatsServer{stream})
}

type DevicePlugin_StatsServer interface {
	Send(*StatsResponse) error
	grpc.ServerStream
}

type devicePluginStatsServer struct {
	grpc.ServerStream
}

func (x *devicePluginStatsServer) Send(m *StatsResponse) error {
	return x.ServerStream.SendMsg(m)
}

var _DevicePlugin_serviceDesc = grpc.ServiceDesc{
	ServiceName: "hashicorp.nomad.plugins.device.DevicePlugin",
	HandlerType: (*DevicePluginServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "Reserve",
			Handler:    _DevicePlugin_Reserve_Handler,
		},
	},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "Fingerprint",
			Handler:       _DevicePlugin_Fingerprint_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "Stats",
			Handler:       _DevicePlugin_Stats_Handler,
			ServerStreams: true,
		},
	},
	Metadata: "plugins/device/proto/device.proto",
}
