/*
  SPDX-FileCopyrightText: 2025-2026 Laurent Montel <montel@kde.org>

  SPDX-License-Identifier: GPL-2.0-or-later
*/
#pragma once
#include "textautogeneratemessagewaitingansweranimation.h"
#include "textautogeneratetext_export.h"
#include <QAbstractTextDocumentLayout>
#include <QString>
#include <QStyleOptionViewItem>
class QTextDocument;
class QPoint;
namespace TextAutoGenerateText
{
class TextAutoGenerateListViewTextSelection;
namespace TextAutoGenerateDelegateUtils
{
[[nodiscard]] bool generateToolTip(const QTextDocument *doc, const QPoint &pos, QString &formattedTooltip);

void generateToolTip(const QString &toolTip, const QString &href, QString &formattedTooltip);

[[nodiscard]] TEXTAUTOGENERATETEXT_EXPORT QList<QAbstractTextDocumentLayout::Selection>
selection(TextAutoGenerateListViewTextSelection *selection, QTextDocument *doc, const QModelIndex &index, const QStyleOptionViewItem &option);

TEXTAUTOGENERATETEXT_EXPORT void setClipboardSelection(TextAutoGenerateListViewTextSelection *selection);

[[nodiscard]] int spacingText();
[[nodiscard]] int roundRectValue();
[[nodiscard]] int marginText();
[[nodiscard]] int rightIndent();
[[nodiscard]] int leftLLMIndent();
[[nodiscard]] int leftUserIndent();
[[nodiscard]] int iconSpacing();
[[nodiscard]] QSize progressIndicatorSize();

struct IndexScaleAndOpacities {
    QPersistentModelIndex index;
    QList<TextAutoGenerateMessageWaitingAnswerAnimation::ScaleAndOpacity> scaleAndOpacities;
};
}
}
