/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by applyconfiguration-gen. DO NOT EDIT.

package v1

import (
	apisv1 "sigs.k8s.io/gateway-api/apis/v1"
)

// BackendRefApplyConfiguration represents a declarative configuration of the BackendRef type for use
// with apply.
type BackendRefApplyConfiguration struct {
	BackendObjectReferenceApplyConfiguration `json:",inline"`
	Weight                                   *int32 `json:"weight,omitempty"`
}

// BackendRefApplyConfiguration constructs a declarative configuration of the BackendRef type for use with
// apply.
func BackendRef() *BackendRefApplyConfiguration {
	return &BackendRefApplyConfiguration{}
}

// WithGroup sets the Group field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Group field is set to the value of the last call.
func (b *BackendRefApplyConfiguration) WithGroup(value apisv1.Group) *BackendRefApplyConfiguration {
	b.BackendObjectReferenceApplyConfiguration.Group = &value
	return b
}

// WithKind sets the Kind field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Kind field is set to the value of the last call.
func (b *BackendRefApplyConfiguration) WithKind(value apisv1.Kind) *BackendRefApplyConfiguration {
	b.BackendObjectReferenceApplyConfiguration.Kind = &value
	return b
}

// WithName sets the Name field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Name field is set to the value of the last call.
func (b *BackendRefApplyConfiguration) WithName(value apisv1.ObjectName) *BackendRefApplyConfiguration {
	b.BackendObjectReferenceApplyConfiguration.Name = &value
	return b
}

// WithNamespace sets the Namespace field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Namespace field is set to the value of the last call.
func (b *BackendRefApplyConfiguration) WithNamespace(value apisv1.Namespace) *BackendRefApplyConfiguration {
	b.BackendObjectReferenceApplyConfiguration.Namespace = &value
	return b
}

// WithPort sets the Port field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Port field is set to the value of the last call.
func (b *BackendRefApplyConfiguration) WithPort(value int32) *BackendRefApplyConfiguration {
	b.BackendObjectReferenceApplyConfiguration.Port = &value
	return b
}

// WithWeight sets the Weight field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Weight field is set to the value of the last call.
func (b *BackendRefApplyConfiguration) WithWeight(value int32) *BackendRefApplyConfiguration {
	b.Weight = &value
	return b
}
