{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- The @PangoAttrFontFeatures@ structure is used to represent OpenType
-- font features as an attribute.
-- 
-- /Since: 1.38/

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Pango.Structs.AttrFontFeatures
    ( 

-- * Exported types
    AttrFontFeatures(..)                    ,
    newZeroAttrFontFeatures                 ,


 -- * Methods

#if defined(ENABLE_OVERLOADING)
    ResolveAttrFontFeaturesMethod           ,
#endif

-- ** new #method:new#

    attrFontFeaturesNew                     ,




 -- * Properties


-- ** attr #attr:attr#
-- | the common portion of the attribute

#if defined(ENABLE_OVERLOADING)
    attrFontFeatures_attr                   ,
#endif
    getAttrFontFeaturesAttr                 ,


-- ** features #attr:features#
-- | the features, as a string in CSS syntax

#if defined(ENABLE_OVERLOADING)
    attrFontFeatures_features               ,
#endif
    clearAttrFontFeaturesFeatures           ,
    getAttrFontFeaturesFeatures             ,
    setAttrFontFeaturesFeatures             ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.Pango.Callbacks as Pango.Callbacks
import {-# SOURCE #-} qualified GI.Pango.Enums as Pango.Enums
import {-# SOURCE #-} qualified GI.Pango.Flags as Pango.Flags
import {-# SOURCE #-} qualified GI.Pango.Structs.AttrClass as Pango.AttrClass
import {-# SOURCE #-} qualified GI.Pango.Structs.AttrColor as Pango.AttrColor
import {-# SOURCE #-} qualified GI.Pango.Structs.AttrFloat as Pango.AttrFloat
import {-# SOURCE #-} qualified GI.Pango.Structs.AttrFontDesc as Pango.AttrFontDesc
import {-# SOURCE #-} qualified GI.Pango.Structs.AttrInt as Pango.AttrInt
import {-# SOURCE #-} qualified GI.Pango.Structs.AttrLanguage as Pango.AttrLanguage
import {-# SOURCE #-} qualified GI.Pango.Structs.AttrShape as Pango.AttrShape
import {-# SOURCE #-} qualified GI.Pango.Structs.AttrSize as Pango.AttrSize
import {-# SOURCE #-} qualified GI.Pango.Structs.AttrString as Pango.AttrString
import {-# SOURCE #-} qualified GI.Pango.Structs.Attribute as Pango.Attribute
import {-# SOURCE #-} qualified GI.Pango.Structs.Color as Pango.Color
import {-# SOURCE #-} qualified GI.Pango.Structs.FontDescription as Pango.FontDescription
import {-# SOURCE #-} qualified GI.Pango.Structs.Language as Pango.Language
import {-# SOURCE #-} qualified GI.Pango.Structs.Rectangle as Pango.Rectangle

#else
import {-# SOURCE #-} qualified GI.Pango.Structs.Attribute as Pango.Attribute

#endif

-- | Memory-managed wrapper type.
newtype AttrFontFeatures = AttrFontFeatures (SP.ManagedPtr AttrFontFeatures)
    deriving (Eq)

instance SP.ManagedPtrNewtype AttrFontFeatures where
    toManagedPtr (AttrFontFeatures p) = p

instance BoxedPtr AttrFontFeatures where
    boxedPtrCopy = \p -> B.ManagedPtr.withManagedPtr p (copyBytes 24 >=> B.ManagedPtr.wrapPtr AttrFontFeatures)
    boxedPtrFree = \x -> SP.withManagedPtr x SP.freeMem
instance CallocPtr AttrFontFeatures where
    boxedPtrCalloc = callocBytes 24


-- | Construct a t'AttrFontFeatures' struct initialized to zero.
newZeroAttrFontFeatures :: MonadIO m => m AttrFontFeatures
newZeroAttrFontFeatures = liftIO $ boxedPtrCalloc >>= wrapPtr AttrFontFeatures

instance tag ~ 'AttrSet => Constructible AttrFontFeatures tag where
    new _ attrs = do
        o <- newZeroAttrFontFeatures
        GI.Attributes.set o attrs
        return o


-- | Get the value of the “@attr@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' attrFontFeatures #attr
-- @
getAttrFontFeaturesAttr :: MonadIO m => AttrFontFeatures -> m Pango.Attribute.Attribute
getAttrFontFeaturesAttr s = liftIO $ withManagedPtr s $ \ptr -> do
    let val = ptr `plusPtr` 0 :: (Ptr Pango.Attribute.Attribute)
    val' <- (newBoxed Pango.Attribute.Attribute) val
    return val'

#if defined(ENABLE_OVERLOADING)
data AttrFontFeaturesAttrFieldInfo
instance AttrInfo AttrFontFeaturesAttrFieldInfo where
    type AttrBaseTypeConstraint AttrFontFeaturesAttrFieldInfo = (~) AttrFontFeatures
    type AttrAllowedOps AttrFontFeaturesAttrFieldInfo = '[ 'AttrGet]
    type AttrSetTypeConstraint AttrFontFeaturesAttrFieldInfo = (~) (Ptr Pango.Attribute.Attribute)
    type AttrTransferTypeConstraint AttrFontFeaturesAttrFieldInfo = (~)(Ptr Pango.Attribute.Attribute)
    type AttrTransferType AttrFontFeaturesAttrFieldInfo = (Ptr Pango.Attribute.Attribute)
    type AttrGetType AttrFontFeaturesAttrFieldInfo = Pango.Attribute.Attribute
    type AttrLabel AttrFontFeaturesAttrFieldInfo = "attr"
    type AttrOrigin AttrFontFeaturesAttrFieldInfo = AttrFontFeatures
    attrGet = getAttrFontFeaturesAttr
    attrSet = undefined
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Pango.Structs.AttrFontFeatures.attr"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-pango-1.0.30/docs/GI-Pango-Structs-AttrFontFeatures.html#g:attr:attr"
        })

attrFontFeatures_attr :: AttrLabelProxy "attr"
attrFontFeatures_attr = AttrLabelProxy

#endif


-- | Get the value of the “@features@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' attrFontFeatures #features
-- @
getAttrFontFeaturesFeatures :: MonadIO m => AttrFontFeatures -> m (Maybe T.Text)
getAttrFontFeaturesFeatures s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 16) :: IO CString
    result <- SP.convertIfNonNull val $ \val' -> do
        val'' <- cstringToText val'
        return val''
    return result

-- | Set the value of the “@features@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' attrFontFeatures [ #features 'Data.GI.Base.Attributes.:=' value ]
-- @
setAttrFontFeaturesFeatures :: MonadIO m => AttrFontFeatures -> CString -> m ()
setAttrFontFeaturesFeatures s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 16) (val :: CString)

-- | Set the value of the “@features@” field to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #features
-- @
clearAttrFontFeaturesFeatures :: MonadIO m => AttrFontFeatures -> m ()
clearAttrFontFeaturesFeatures s = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 16) (FP.nullPtr :: CString)

#if defined(ENABLE_OVERLOADING)
data AttrFontFeaturesFeaturesFieldInfo
instance AttrInfo AttrFontFeaturesFeaturesFieldInfo where
    type AttrBaseTypeConstraint AttrFontFeaturesFeaturesFieldInfo = (~) AttrFontFeatures
    type AttrAllowedOps AttrFontFeaturesFeaturesFieldInfo = '[ 'AttrSet, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint AttrFontFeaturesFeaturesFieldInfo = (~) CString
    type AttrTransferTypeConstraint AttrFontFeaturesFeaturesFieldInfo = (~)CString
    type AttrTransferType AttrFontFeaturesFeaturesFieldInfo = CString
    type AttrGetType AttrFontFeaturesFeaturesFieldInfo = Maybe T.Text
    type AttrLabel AttrFontFeaturesFeaturesFieldInfo = "features"
    type AttrOrigin AttrFontFeaturesFeaturesFieldInfo = AttrFontFeatures
    attrGet = getAttrFontFeaturesFeatures
    attrSet = setAttrFontFeaturesFeatures
    attrConstruct = undefined
    attrClear = clearAttrFontFeaturesFeatures
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Pango.Structs.AttrFontFeatures.features"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-pango-1.0.30/docs/GI-Pango-Structs-AttrFontFeatures.html#g:attr:features"
        })

attrFontFeatures_features :: AttrLabelProxy "features"
attrFontFeatures_features = AttrLabelProxy

#endif



#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList AttrFontFeatures
type instance O.AttributeList AttrFontFeatures = AttrFontFeaturesAttributeList
type AttrFontFeaturesAttributeList = ('[ '("attr", AttrFontFeaturesAttrFieldInfo), '("features", AttrFontFeaturesFeaturesFieldInfo)] :: [(Symbol, DK.Type)])
#endif

-- method AttrFontFeatures::new
-- method type : MemberFunction
-- Args: [ Arg
--           { argCName = "features"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "a string with OpenType font features, with the syntax of the [CSS\nfont-feature-settings property](https://www.w3.org/TR/css-fonts-4/#font-rend-desc)"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Pango" , name = "Attribute" })
-- throws : False
-- Skip return : False

foreign import ccall "pango_attr_font_features_new" pango_attr_font_features_new :: 
    CString ->                              -- features : TBasicType TUTF8
    IO (Ptr Pango.Attribute.Attribute)

-- | Create a new font features tag attribute.
-- 
-- You can use this attribute to select OpenType font features like small-caps,
-- alternative glyphs, ligatures, etc. for fonts that support them.
-- 
-- /Since: 1.38/
attrFontFeaturesNew ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    T.Text
    -- ^ /@features@/: a string with OpenType font features, with the syntax of the <https://www.w3.org/TR/css-fonts-4/#font-rend-desc CSS
    -- font-feature-settings property>
    -> m Pango.Attribute.Attribute
    -- ^ __Returns:__ the newly allocated
    --   @PangoAttribute@, which should be freed with
    --   'GI.Pango.Structs.Attribute.attributeDestroy'
attrFontFeaturesNew features = liftIO $ do
    features' <- textToCString features
    result <- pango_attr_font_features_new features'
    checkUnexpectedReturnNULL "attrFontFeaturesNew" result
    result' <- (wrapBoxed Pango.Attribute.Attribute) result
    freeMem features'
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

#if defined(ENABLE_OVERLOADING)
type family ResolveAttrFontFeaturesMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveAttrFontFeaturesMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveAttrFontFeaturesMethod t AttrFontFeatures, O.OverloadedMethod info AttrFontFeatures p) => OL.IsLabel t (AttrFontFeatures -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveAttrFontFeaturesMethod t AttrFontFeatures, O.OverloadedMethod info AttrFontFeatures p, R.HasField t AttrFontFeatures p) => R.HasField t AttrFontFeatures p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveAttrFontFeaturesMethod t AttrFontFeatures, O.OverloadedMethodInfo info AttrFontFeatures) => OL.IsLabel t (O.MethodProxy info AttrFontFeatures) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif


