// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"encoding/binary"
	"fmt"
	"math"
	"sync"

	"go.opentelemetry.io/collector/pdata/internal/json"
	"go.opentelemetry.io/collector/pdata/internal/proto"
)

func (m *HistogramDataPoint) GetSum_() any {
	if m != nil {
		return m.Sum_
	}
	return nil
}

type HistogramDataPoint_Sum struct {
	Sum float64
}

func (m *HistogramDataPoint) GetSum() float64 {
	if v, ok := m.GetSum_().(*HistogramDataPoint_Sum); ok {
		return v.Sum
	}
	return float64(0)
}

func (m *HistogramDataPoint) GetMin_() any {
	if m != nil {
		return m.Min_
	}
	return nil
}

type HistogramDataPoint_Min struct {
	Min float64
}

func (m *HistogramDataPoint) GetMin() float64 {
	if v, ok := m.GetMin_().(*HistogramDataPoint_Min); ok {
		return v.Min
	}
	return float64(0)
}

func (m *HistogramDataPoint) GetMax_() any {
	if m != nil {
		return m.Max_
	}
	return nil
}

type HistogramDataPoint_Max struct {
	Max float64
}

func (m *HistogramDataPoint) GetMax() float64 {
	if v, ok := m.GetMax_().(*HistogramDataPoint_Max); ok {
		return v.Max
	}
	return float64(0)
}

// HistogramDataPoint is a single data point in a timeseries that describes the time-varying values of a Histogram of values.
type HistogramDataPoint struct {
	Attributes        []KeyValue
	StartTimeUnixNano uint64
	TimeUnixNano      uint64
	Count             uint64
	Sum_              any
	BucketCounts      []uint64
	ExplicitBounds    []float64
	Exemplars         []Exemplar
	Flags             uint32
	Min_              any
	Max_              any
}

var (
	protoPoolHistogramDataPoint = sync.Pool{
		New: func() any {
			return &HistogramDataPoint{}
		},
	}
	ProtoPoolHistogramDataPoint_Sum = sync.Pool{
		New: func() any {
			return &HistogramDataPoint_Sum{}
		},
	}

	ProtoPoolHistogramDataPoint_Min = sync.Pool{
		New: func() any {
			return &HistogramDataPoint_Min{}
		},
	}

	ProtoPoolHistogramDataPoint_Max = sync.Pool{
		New: func() any {
			return &HistogramDataPoint_Max{}
		},
	}
)

func NewHistogramDataPoint() *HistogramDataPoint {
	if !UseProtoPooling.IsEnabled() {
		return &HistogramDataPoint{}
	}
	return protoPoolHistogramDataPoint.Get().(*HistogramDataPoint)
}

func DeleteHistogramDataPoint(orig *HistogramDataPoint, nullable bool) {
	if orig == nil {
		return
	}

	if !UseProtoPooling.IsEnabled() {
		orig.Reset()
		return
	}

	for i := range orig.Attributes {
		DeleteKeyValue(&orig.Attributes[i], false)
	}
	switch ov := orig.Sum_.(type) {
	case *HistogramDataPoint_Sum:
		if UseProtoPooling.IsEnabled() {
			ov.Sum = float64(0)
			ProtoPoolHistogramDataPoint_Sum.Put(ov)
		}

	}
	for i := range orig.Exemplars {
		DeleteExemplar(&orig.Exemplars[i], false)
	}
	switch ov := orig.Min_.(type) {
	case *HistogramDataPoint_Min:
		if UseProtoPooling.IsEnabled() {
			ov.Min = float64(0)
			ProtoPoolHistogramDataPoint_Min.Put(ov)
		}

	}
	switch ov := orig.Max_.(type) {
	case *HistogramDataPoint_Max:
		if UseProtoPooling.IsEnabled() {
			ov.Max = float64(0)
			ProtoPoolHistogramDataPoint_Max.Put(ov)
		}

	}

	orig.Reset()
	if nullable {
		protoPoolHistogramDataPoint.Put(orig)
	}
}

func CopyHistogramDataPoint(dest, src *HistogramDataPoint) *HistogramDataPoint {
	// If copying to same object, just return.
	if src == dest {
		return dest
	}

	if src == nil {
		return nil
	}

	if dest == nil {
		dest = NewHistogramDataPoint()
	}
	dest.Attributes = CopyKeyValueSlice(dest.Attributes, src.Attributes)

	dest.StartTimeUnixNano = src.StartTimeUnixNano

	dest.TimeUnixNano = src.TimeUnixNano

	dest.Count = src.Count

	switch t := src.Sum_.(type) {
	case *HistogramDataPoint_Sum:
		var ov *HistogramDataPoint_Sum
		if !UseProtoPooling.IsEnabled() {
			ov = &HistogramDataPoint_Sum{}
		} else {
			ov = ProtoPoolHistogramDataPoint_Sum.Get().(*HistogramDataPoint_Sum)
		}
		ov.Sum = t.Sum
		dest.Sum_ = ov
	default:
		dest.Sum_ = nil
	}

	dest.BucketCounts = append(dest.BucketCounts[:0], src.BucketCounts...)
	dest.ExplicitBounds = append(dest.ExplicitBounds[:0], src.ExplicitBounds...)
	dest.Exemplars = CopyExemplarSlice(dest.Exemplars, src.Exemplars)

	dest.Flags = src.Flags

	switch t := src.Min_.(type) {
	case *HistogramDataPoint_Min:
		var ov *HistogramDataPoint_Min
		if !UseProtoPooling.IsEnabled() {
			ov = &HistogramDataPoint_Min{}
		} else {
			ov = ProtoPoolHistogramDataPoint_Min.Get().(*HistogramDataPoint_Min)
		}
		ov.Min = t.Min
		dest.Min_ = ov
	default:
		dest.Min_ = nil
	}

	switch t := src.Max_.(type) {
	case *HistogramDataPoint_Max:
		var ov *HistogramDataPoint_Max
		if !UseProtoPooling.IsEnabled() {
			ov = &HistogramDataPoint_Max{}
		} else {
			ov = ProtoPoolHistogramDataPoint_Max.Get().(*HistogramDataPoint_Max)
		}
		ov.Max = t.Max
		dest.Max_ = ov
	default:
		dest.Max_ = nil
	}

	return dest
}

func CopyHistogramDataPointSlice(dest, src []HistogramDataPoint) []HistogramDataPoint {
	var newDest []HistogramDataPoint
	if cap(dest) < len(src) {
		newDest = make([]HistogramDataPoint, len(src))
	} else {
		newDest = dest[:len(src)]
		// Cleanup the rest of the elements so GC can free the memory.
		// This can happen when len(src) < len(dest) < cap(dest).
		for i := len(src); i < len(dest); i++ {
			DeleteHistogramDataPoint(&dest[i], false)
		}
	}
	for i := range src {
		CopyHistogramDataPoint(&newDest[i], &src[i])
	}
	return newDest
}

func CopyHistogramDataPointPtrSlice(dest, src []*HistogramDataPoint) []*HistogramDataPoint {
	var newDest []*HistogramDataPoint
	if cap(dest) < len(src) {
		newDest = make([]*HistogramDataPoint, len(src))
		// Copy old pointers to re-use.
		copy(newDest, dest)
		// Add new pointers for missing elements from len(dest) to len(srt).
		for i := len(dest); i < len(src); i++ {
			newDest[i] = NewHistogramDataPoint()
		}
	} else {
		newDest = dest[:len(src)]
		// Cleanup the rest of the elements so GC can free the memory.
		// This can happen when len(src) < len(dest) < cap(dest).
		for i := len(src); i < len(dest); i++ {
			DeleteHistogramDataPoint(dest[i], true)
			dest[i] = nil
		}
		// Add new pointers for missing elements.
		// This can happen when len(dest) < len(src) < cap(dest).
		for i := len(dest); i < len(src); i++ {
			newDest[i] = NewHistogramDataPoint()
		}
	}
	for i := range src {
		CopyHistogramDataPoint(newDest[i], src[i])
	}
	return newDest
}

func (orig *HistogramDataPoint) Reset() {
	*orig = HistogramDataPoint{}
}

// MarshalJSON marshals all properties from the current struct to the destination stream.
func (orig *HistogramDataPoint) MarshalJSON(dest *json.Stream) {
	dest.WriteObjectStart()
	if len(orig.Attributes) > 0 {
		dest.WriteObjectField("attributes")
		dest.WriteArrayStart()
		orig.Attributes[0].MarshalJSON(dest)
		for i := 1; i < len(orig.Attributes); i++ {
			dest.WriteMore()
			orig.Attributes[i].MarshalJSON(dest)
		}
		dest.WriteArrayEnd()
	}
	if orig.StartTimeUnixNano != uint64(0) {
		dest.WriteObjectField("startTimeUnixNano")
		dest.WriteUint64(orig.StartTimeUnixNano)
	}
	if orig.TimeUnixNano != uint64(0) {
		dest.WriteObjectField("timeUnixNano")
		dest.WriteUint64(orig.TimeUnixNano)
	}
	if orig.Count != uint64(0) {
		dest.WriteObjectField("count")
		dest.WriteUint64(orig.Count)
	}
	if orig, ok := orig.Sum_.(*HistogramDataPoint_Sum); ok {
		dest.WriteObjectField("sum")
		dest.WriteFloat64(orig.Sum)
	}
	if len(orig.BucketCounts) > 0 {
		dest.WriteObjectField("bucketCounts")
		dest.WriteArrayStart()
		dest.WriteUint64(orig.BucketCounts[0])
		for i := 1; i < len(orig.BucketCounts); i++ {
			dest.WriteMore()
			dest.WriteUint64(orig.BucketCounts[i])
		}
		dest.WriteArrayEnd()
	}
	if len(orig.ExplicitBounds) > 0 {
		dest.WriteObjectField("explicitBounds")
		dest.WriteArrayStart()
		dest.WriteFloat64(orig.ExplicitBounds[0])
		for i := 1; i < len(orig.ExplicitBounds); i++ {
			dest.WriteMore()
			dest.WriteFloat64(orig.ExplicitBounds[i])
		}
		dest.WriteArrayEnd()
	}
	if len(orig.Exemplars) > 0 {
		dest.WriteObjectField("exemplars")
		dest.WriteArrayStart()
		orig.Exemplars[0].MarshalJSON(dest)
		for i := 1; i < len(orig.Exemplars); i++ {
			dest.WriteMore()
			orig.Exemplars[i].MarshalJSON(dest)
		}
		dest.WriteArrayEnd()
	}
	if orig.Flags != uint32(0) {
		dest.WriteObjectField("flags")
		dest.WriteUint32(orig.Flags)
	}
	if orig, ok := orig.Min_.(*HistogramDataPoint_Min); ok {
		dest.WriteObjectField("min")
		dest.WriteFloat64(orig.Min)
	}
	if orig, ok := orig.Max_.(*HistogramDataPoint_Max); ok {
		dest.WriteObjectField("max")
		dest.WriteFloat64(orig.Max)
	}
	dest.WriteObjectEnd()
}

// UnmarshalJSON unmarshals all properties from the current struct from the source iterator.
func (orig *HistogramDataPoint) UnmarshalJSON(iter *json.Iterator) {
	for f := iter.ReadObject(); f != ""; f = iter.ReadObject() {
		switch f {
		case "attributes":
			for iter.ReadArray() {
				orig.Attributes = append(orig.Attributes, KeyValue{})
				orig.Attributes[len(orig.Attributes)-1].UnmarshalJSON(iter)
			}

		case "startTimeUnixNano", "start_time_unix_nano":
			orig.StartTimeUnixNano = iter.ReadUint64()
		case "timeUnixNano", "time_unix_nano":
			orig.TimeUnixNano = iter.ReadUint64()
		case "count":
			orig.Count = iter.ReadUint64()
		case "sum":
			{
				var ov *HistogramDataPoint_Sum
				if !UseProtoPooling.IsEnabled() {
					ov = &HistogramDataPoint_Sum{}
				} else {
					ov = ProtoPoolHistogramDataPoint_Sum.Get().(*HistogramDataPoint_Sum)
				}
				ov.Sum = iter.ReadFloat64()
				orig.Sum_ = ov
			}

		case "bucketCounts", "bucket_counts":
			for iter.ReadArray() {
				orig.BucketCounts = append(orig.BucketCounts, iter.ReadUint64())
			}

		case "explicitBounds", "explicit_bounds":
			for iter.ReadArray() {
				orig.ExplicitBounds = append(orig.ExplicitBounds, iter.ReadFloat64())
			}

		case "exemplars":
			for iter.ReadArray() {
				orig.Exemplars = append(orig.Exemplars, Exemplar{})
				orig.Exemplars[len(orig.Exemplars)-1].UnmarshalJSON(iter)
			}

		case "flags":
			orig.Flags = iter.ReadUint32()
		case "min":
			{
				var ov *HistogramDataPoint_Min
				if !UseProtoPooling.IsEnabled() {
					ov = &HistogramDataPoint_Min{}
				} else {
					ov = ProtoPoolHistogramDataPoint_Min.Get().(*HistogramDataPoint_Min)
				}
				ov.Min = iter.ReadFloat64()
				orig.Min_ = ov
			}

		case "max":
			{
				var ov *HistogramDataPoint_Max
				if !UseProtoPooling.IsEnabled() {
					ov = &HistogramDataPoint_Max{}
				} else {
					ov = ProtoPoolHistogramDataPoint_Max.Get().(*HistogramDataPoint_Max)
				}
				ov.Max = iter.ReadFloat64()
				orig.Max_ = ov
			}

		default:
			iter.Skip()
		}
	}
}

func (orig *HistogramDataPoint) SizeProto() int {
	var n int
	var l int
	_ = l
	for i := range orig.Attributes {
		l = orig.Attributes[i].SizeProto()
		n += 1 + proto.Sov(uint64(l)) + l
	}
	if orig.StartTimeUnixNano != 0 {
		n += 9
	}
	if orig.TimeUnixNano != 0 {
		n += 9
	}
	if orig.Count != 0 {
		n += 9
	}
	if orig, ok := orig.Sum_.(*HistogramDataPoint_Sum); ok {
		_ = orig
		n += 9
	}
	l = len(orig.BucketCounts)
	if l > 0 {
		l *= 8
		n += 1 + proto.Sov(uint64(l)) + l
	}
	l = len(orig.ExplicitBounds)
	if l > 0 {
		l *= 8
		n += 1 + proto.Sov(uint64(l)) + l
	}
	for i := range orig.Exemplars {
		l = orig.Exemplars[i].SizeProto()
		n += 1 + proto.Sov(uint64(l)) + l
	}
	if orig.Flags != 0 {
		n += 1 + proto.Sov(uint64(orig.Flags))
	}
	if orig, ok := orig.Min_.(*HistogramDataPoint_Min); ok {
		_ = orig
		n += 9
	}
	if orig, ok := orig.Max_.(*HistogramDataPoint_Max); ok {
		_ = orig
		n += 9
	}
	return n
}

func (orig *HistogramDataPoint) MarshalProto(buf []byte) int {
	pos := len(buf)
	var l int
	_ = l
	for i := len(orig.Attributes) - 1; i >= 0; i-- {
		l = orig.Attributes[i].MarshalProto(buf[:pos])
		pos -= l
		pos = proto.EncodeVarint(buf, pos, uint64(l))
		pos--
		buf[pos] = 0x4a
	}
	if orig.StartTimeUnixNano != 0 {
		pos -= 8
		binary.LittleEndian.PutUint64(buf[pos:], uint64(orig.StartTimeUnixNano))
		pos--
		buf[pos] = 0x11
	}
	if orig.TimeUnixNano != 0 {
		pos -= 8
		binary.LittleEndian.PutUint64(buf[pos:], uint64(orig.TimeUnixNano))
		pos--
		buf[pos] = 0x19
	}
	if orig.Count != 0 {
		pos -= 8
		binary.LittleEndian.PutUint64(buf[pos:], uint64(orig.Count))
		pos--
		buf[pos] = 0x21
	}
	if orig, ok := orig.Sum_.(*HistogramDataPoint_Sum); ok {
		pos -= 8
		binary.LittleEndian.PutUint64(buf[pos:], math.Float64bits(orig.Sum))
		pos--
		buf[pos] = 0x29
	}
	l = len(orig.BucketCounts)
	if l > 0 {
		for i := l - 1; i >= 0; i-- {
			pos -= 8
			binary.LittleEndian.PutUint64(buf[pos:], uint64(orig.BucketCounts[i]))
		}
		pos = proto.EncodeVarint(buf, pos, uint64(l*8))
		pos--
		buf[pos] = 0x32
	}
	l = len(orig.ExplicitBounds)
	if l > 0 {
		for i := l - 1; i >= 0; i-- {
			pos -= 8
			binary.LittleEndian.PutUint64(buf[pos:], math.Float64bits(orig.ExplicitBounds[i]))
		}
		pos = proto.EncodeVarint(buf, pos, uint64(l*8))
		pos--
		buf[pos] = 0x3a
	}
	for i := len(orig.Exemplars) - 1; i >= 0; i-- {
		l = orig.Exemplars[i].MarshalProto(buf[:pos])
		pos -= l
		pos = proto.EncodeVarint(buf, pos, uint64(l))
		pos--
		buf[pos] = 0x42
	}
	if orig.Flags != 0 {
		pos = proto.EncodeVarint(buf, pos, uint64(orig.Flags))
		pos--
		buf[pos] = 0x50
	}
	if orig, ok := orig.Min_.(*HistogramDataPoint_Min); ok {
		pos -= 8
		binary.LittleEndian.PutUint64(buf[pos:], math.Float64bits(orig.Min))
		pos--
		buf[pos] = 0x59
	}
	if orig, ok := orig.Max_.(*HistogramDataPoint_Max); ok {
		pos -= 8
		binary.LittleEndian.PutUint64(buf[pos:], math.Float64bits(orig.Max))
		pos--
		buf[pos] = 0x61
	}
	return len(buf) - pos
}

func (orig *HistogramDataPoint) UnmarshalProto(buf []byte) error {
	var err error
	var fieldNum int32
	var wireType proto.WireType

	l := len(buf)
	pos := 0
	for pos < l {
		// If in a group parsing, move to the next tag.
		fieldNum, wireType, pos, err = proto.ConsumeTag(buf, pos)
		if err != nil {
			return err
		}
		switch fieldNum {

		case 9:
			if wireType != proto.WireTypeLen {
				return fmt.Errorf("proto: wrong wireType = %d for field Attributes", wireType)
			}
			var length int
			length, pos, err = proto.ConsumeLen(buf, pos)
			if err != nil {
				return err
			}
			startPos := pos - length
			orig.Attributes = append(orig.Attributes, KeyValue{})
			err = orig.Attributes[len(orig.Attributes)-1].UnmarshalProto(buf[startPos:pos])
			if err != nil {
				return err
			}

		case 2:
			if wireType != proto.WireTypeI64 {
				return fmt.Errorf("proto: wrong wireType = %d for field StartTimeUnixNano", wireType)
			}
			var num uint64
			num, pos, err = proto.ConsumeI64(buf, pos)
			if err != nil {
				return err
			}

			orig.StartTimeUnixNano = uint64(num)

		case 3:
			if wireType != proto.WireTypeI64 {
				return fmt.Errorf("proto: wrong wireType = %d for field TimeUnixNano", wireType)
			}
			var num uint64
			num, pos, err = proto.ConsumeI64(buf, pos)
			if err != nil {
				return err
			}

			orig.TimeUnixNano = uint64(num)

		case 4:
			if wireType != proto.WireTypeI64 {
				return fmt.Errorf("proto: wrong wireType = %d for field Count", wireType)
			}
			var num uint64
			num, pos, err = proto.ConsumeI64(buf, pos)
			if err != nil {
				return err
			}

			orig.Count = uint64(num)

		case 5:
			if wireType != proto.WireTypeI64 {
				return fmt.Errorf("proto: wrong wireType = %d for field Sum", wireType)
			}
			var num uint64
			num, pos, err = proto.ConsumeI64(buf, pos)
			if err != nil {
				return err
			}
			var ov *HistogramDataPoint_Sum
			if !UseProtoPooling.IsEnabled() {
				ov = &HistogramDataPoint_Sum{}
			} else {
				ov = ProtoPoolHistogramDataPoint_Sum.Get().(*HistogramDataPoint_Sum)
			}
			ov.Sum = math.Float64frombits(num)
			orig.Sum_ = ov
		case 6:
			switch wireType {
			case proto.WireTypeLen:
				var length int
				length, pos, err = proto.ConsumeLen(buf, pos)
				if err != nil {
					return err
				}
				startPos := pos - length
				size := length / 8
				orig.BucketCounts = make([]uint64, size)
				var num uint64
				for i := 0; i < size; i++ {
					num, startPos, err = proto.ConsumeI64(buf[:pos], startPos)
					if err != nil {
						return err
					}
					orig.BucketCounts[i] = uint64(num)
				}
				if startPos != pos {
					return fmt.Errorf("proto: invalid field len = %d for field BucketCounts", pos-startPos)
				}
			case proto.WireTypeI64:
				var num uint64
				num, pos, err = proto.ConsumeI64(buf, pos)
				if err != nil {
					return err
				}
				orig.BucketCounts = append(orig.BucketCounts, uint64(num))
			default:
				return fmt.Errorf("proto: wrong wireType = %d for field BucketCounts", wireType)
			}
		case 7:
			switch wireType {
			case proto.WireTypeLen:
				var length int
				length, pos, err = proto.ConsumeLen(buf, pos)
				if err != nil {
					return err
				}
				startPos := pos - length
				size := length / 8
				orig.ExplicitBounds = make([]float64, size)
				var num uint64
				for i := 0; i < size; i++ {
					num, startPos, err = proto.ConsumeI64(buf[:pos], startPos)
					if err != nil {
						return err
					}
					orig.ExplicitBounds[i] = math.Float64frombits(num)
				}
				if startPos != pos {
					return fmt.Errorf("proto: invalid field len = %d for field ExplicitBounds", pos-startPos)
				}
			case proto.WireTypeI64:
				var num uint64
				num, pos, err = proto.ConsumeI64(buf, pos)
				if err != nil {
					return err
				}
				orig.ExplicitBounds = append(orig.ExplicitBounds, math.Float64frombits(num))
			default:
				return fmt.Errorf("proto: wrong wireType = %d for field ExplicitBounds", wireType)
			}

		case 8:
			if wireType != proto.WireTypeLen {
				return fmt.Errorf("proto: wrong wireType = %d for field Exemplars", wireType)
			}
			var length int
			length, pos, err = proto.ConsumeLen(buf, pos)
			if err != nil {
				return err
			}
			startPos := pos - length
			orig.Exemplars = append(orig.Exemplars, Exemplar{})
			err = orig.Exemplars[len(orig.Exemplars)-1].UnmarshalProto(buf[startPos:pos])
			if err != nil {
				return err
			}

		case 10:
			if wireType != proto.WireTypeVarint {
				return fmt.Errorf("proto: wrong wireType = %d for field Flags", wireType)
			}
			var num uint64
			num, pos, err = proto.ConsumeVarint(buf, pos)
			if err != nil {
				return err
			}

			orig.Flags = uint32(num)

		case 11:
			if wireType != proto.WireTypeI64 {
				return fmt.Errorf("proto: wrong wireType = %d for field Min", wireType)
			}
			var num uint64
			num, pos, err = proto.ConsumeI64(buf, pos)
			if err != nil {
				return err
			}
			var ov *HistogramDataPoint_Min
			if !UseProtoPooling.IsEnabled() {
				ov = &HistogramDataPoint_Min{}
			} else {
				ov = ProtoPoolHistogramDataPoint_Min.Get().(*HistogramDataPoint_Min)
			}
			ov.Min = math.Float64frombits(num)
			orig.Min_ = ov

		case 12:
			if wireType != proto.WireTypeI64 {
				return fmt.Errorf("proto: wrong wireType = %d for field Max", wireType)
			}
			var num uint64
			num, pos, err = proto.ConsumeI64(buf, pos)
			if err != nil {
				return err
			}
			var ov *HistogramDataPoint_Max
			if !UseProtoPooling.IsEnabled() {
				ov = &HistogramDataPoint_Max{}
			} else {
				ov = ProtoPoolHistogramDataPoint_Max.Get().(*HistogramDataPoint_Max)
			}
			ov.Max = math.Float64frombits(num)
			orig.Max_ = ov
		default:
			pos, err = proto.ConsumeUnknown(buf, pos, wireType)
			if err != nil {
				return err
			}
		}
	}
	return nil
}

func GenTestHistogramDataPoint() *HistogramDataPoint {
	orig := NewHistogramDataPoint()
	orig.Attributes = []KeyValue{{}, *GenTestKeyValue()}
	orig.StartTimeUnixNano = uint64(13)
	orig.TimeUnixNano = uint64(13)
	orig.Count = uint64(13)
	orig.Sum_ = &HistogramDataPoint_Sum{Sum: float64(3.1415926)}
	orig.BucketCounts = []uint64{uint64(0), uint64(13)}
	orig.ExplicitBounds = []float64{float64(0), float64(3.1415926)}
	orig.Exemplars = []Exemplar{{}, *GenTestExemplar()}
	orig.Flags = uint32(13)
	orig.Min_ = &HistogramDataPoint_Min{Min: float64(3.1415926)}
	orig.Max_ = &HistogramDataPoint_Max{Max: float64(3.1415926)}
	return orig
}

func GenTestHistogramDataPointPtrSlice() []*HistogramDataPoint {
	orig := make([]*HistogramDataPoint, 5)
	orig[0] = NewHistogramDataPoint()
	orig[1] = GenTestHistogramDataPoint()
	orig[2] = NewHistogramDataPoint()
	orig[3] = GenTestHistogramDataPoint()
	orig[4] = NewHistogramDataPoint()
	return orig
}

func GenTestHistogramDataPointSlice() []HistogramDataPoint {
	orig := make([]HistogramDataPoint, 5)
	orig[1] = *GenTestHistogramDataPoint()
	orig[3] = *GenTestHistogramDataPoint()
	return orig
}
