/*
 * Copyright 2020 Free Software Foundation, Inc.
 *
 * This file is part of GNU Radio
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 *
 */
#include "pydoc_macros.h"
#define D(...) DOC(gr, filter, __VA_ARGS__)
/*
  This file contains placeholders for docstrings for the Python bindings.
  Do not edit! These were automatically extracted during the binding process
  and will be overwritten during the build process
 */


static const char* __doc_gr_filter_pfb_synthesizer_ccf = R"doc(Polyphase synthesis filterbank with gr_complex input, gr_complex output and float taps.

The PFB synthesis filterbank combines multiple baseband signals into a single channelized signal. Each input stream is, essentially, modulated onto an output channel according the the channel mapping (see set_channel_map for details).


Setting this filterbank up means selecting the number of output channels, the prototype filter, and whether to handle channels at 2x the sample rate (this is generally used only for reconstruction filtering).


The number of channels sets the maximum number of channels to use, but not all input streams must be connected. For M total channels, we can connect inputs 0 to N where N < M-1. Because of the way GNU Radio handles stream connections, we must connect the channels consecutively, and so we must use the set_channel_map if the desired output channels are not the same as the the default mapping. This features gives us the flexibility to output to any given channel. Generally, we try to not use the channels at the edge of the spectrum to avoid issues with filtering and roll-off of the transmitter or receiver.


When using the 2x sample rate mode, we specify the number of channels that will be used. However, the actual output signal will be twice this number of channels. This is mainly important to know when setting the channel map. For M channels, the channel mapping can specy from 0 to 2M-1 channels to output onto.


For more details about this and the concepts of reconstruction filtering, see:

Constructor Specific Documentation:

Build the polyphase synthesis filterbank.

Args:
    numchans : (unsigned integer) Specifies the number of channels
    taps : (vector/list of floats) The prototype filter to populate the filterbank.
    twox : (bool) use 2x oversampling or not (default is no))doc";


static const char* __doc_gr_filter_pfb_synthesizer_ccf_pfb_synthesizer_ccf_0 =
    R"doc()doc";


static const char* __doc_gr_filter_pfb_synthesizer_ccf_pfb_synthesizer_ccf_1 =
    R"doc()doc";


static const char* __doc_gr_filter_pfb_synthesizer_ccf_make = R"doc(Polyphase synthesis filterbank with gr_complex input, gr_complex output and float taps.

The PFB synthesis filterbank combines multiple baseband signals into a single channelized signal. Each input stream is, essentially, modulated onto an output channel according the the channel mapping (see set_channel_map for details).


Setting this filterbank up means selecting the number of output channels, the prototype filter, and whether to handle channels at 2x the sample rate (this is generally used only for reconstruction filtering).


The number of channels sets the maximum number of channels to use, but not all input streams must be connected. For M total channels, we can connect inputs 0 to N where N < M-1. Because of the way GNU Radio handles stream connections, we must connect the channels consecutively, and so we must use the set_channel_map if the desired output channels are not the same as the the default mapping. This features gives us the flexibility to output to any given channel. Generally, we try to not use the channels at the edge of the spectrum to avoid issues with filtering and roll-off of the transmitter or receiver.


When using the 2x sample rate mode, we specify the number of channels that will be used. However, the actual output signal will be twice this number of channels. This is mainly important to know when setting the channel map. For M channels, the channel mapping can specy from 0 to 2M-1 channels to output onto.


For more details about this and the concepts of reconstruction filtering, see:

Constructor Specific Documentation:

Build the polyphase synthesis filterbank.

Args:
    numchans : (unsigned integer) Specifies the number of channels
    taps : (vector/list of floats) The prototype filter to populate the filterbank.
    twox : (bool) use 2x oversampling or not (default is no))doc";


static const char* __doc_gr_filter_pfb_synthesizer_ccf_set_taps = R"doc(Resets the filterbank's filter taps with the new prototype filter)doc";


static const char* __doc_gr_filter_pfb_synthesizer_ccf_print_taps = R"doc(Print all of the filterbank taps to screen.)doc";


static const char* __doc_gr_filter_pfb_synthesizer_ccf_taps = R"doc(Return a vector<vector<>> of the filterbank taps)doc";


static const char* __doc_gr_filter_pfb_synthesizer_ccf_set_channel_map = R"doc(Set the channel map. Channels are numbers as: 


So input stream 0 goes to channel 0, etc. Setting a new channel map allows the user to specify where in frequency he/she wants the input stream to go. This is especially useful to avoid putting signals into the channels on the edge of the spectrum which can either wrap around (in the case of odd number of channels) and be affected by filter rolloff in the transmitter.


The map must be at least the number of streams being sent to the block. Less and the algorithm will not have enough data to properly setup the buffers. Any more channels specified will be ignored.)doc";


static const char* __doc_gr_filter_pfb_synthesizer_ccf_channel_map = R"doc(Gets the current channel map.)doc";
