/*
 * Copyright 2020 Free Software Foundation, Inc.
 *
 * This file is part of GNU Radio
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 *
 */
#include "pydoc_macros.h"
#define D(...) DOC(gr, digital, __VA_ARGS__)
/*
  This file contains placeholders for docstrings for the Python bindings.
  Do not edit! These were automatically extracted during the binding process
  and will be overwritten during the build process
 */


static const char* __doc_gr_digital_diff_encoder_bb = R"doc(Differential decoder: y[0] = (x[0] + y[-1]) % M.

Uses current and previous symbols and the alphabet modulus to perform differential encoding.

Constructor Specific Documentation:

Make a differential encoder block.

Args:
    modulus : Modulus of code's alphabet
    coding : Differential coding type)doc";


static const char* __doc_gr_digital_diff_encoder_bb_diff_encoder_bb = R"doc()doc";


static const char* __doc_gr_digital_diff_encoder_bb_make = R"doc(Differential decoder: y[0] = (x[0] + y[-1]) % M.

Uses current and previous symbols and the alphabet modulus to perform differential encoding.

Constructor Specific Documentation:

Make a differential encoder block.

Args:
    modulus : Modulus of code's alphabet
    coding : Differential coding type)doc";
