/* minefield.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from minefield.vala, do not modify */

/*
 * Copyright (C) 2011-2012 Robert Ancell
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */

#include <glib-object.h>
#include <glib.h>
#include <string.h>
#include <float.h>
#include <math.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

typedef enum  {
	FLAG_TYPE_NONE,
	FLAG_TYPE_FLAG,
	FLAG_TYPE_MAYBE
} FlagType;

#define TYPE_FLAG_TYPE (flag_type_get_type ())

#define TYPE_LOCATION (location_get_type ())
#define LOCATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LOCATION, Location))
#define LOCATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_LOCATION, LocationClass))
#define IS_LOCATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LOCATION))
#define IS_LOCATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_LOCATION))
#define LOCATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_LOCATION, LocationClass))

typedef struct _Location Location;
typedef struct _LocationClass LocationClass;
typedef struct _LocationPrivate LocationPrivate;
enum  {
	LOCATION_0_PROPERTY,
	LOCATION_NUM_PROPERTIES
};
static GParamSpec* location_properties[LOCATION_NUM_PROPERTIES];

#define TYPE_NEIGHBOUR (neighbour_get_type ())
typedef struct _Neighbour Neighbour;

#define TYPE_MINEFIELD (minefield_get_type ())
#define MINEFIELD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MINEFIELD, Minefield))
#define MINEFIELD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MINEFIELD, MinefieldClass))
#define IS_MINEFIELD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MINEFIELD))
#define IS_MINEFIELD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MINEFIELD))
#define MINEFIELD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MINEFIELD, MinefieldClass))

typedef struct _Minefield Minefield;
typedef struct _MinefieldClass MinefieldClass;
typedef struct _MinefieldPrivate MinefieldPrivate;
enum  {
	MINEFIELD_0_PROPERTY,
	MINEFIELD_N_CLEARED_PROPERTY,
	MINEFIELD_IS_COMPLETE_PROPERTY,
	MINEFIELD_N_FLAGS_PROPERTY,
	MINEFIELD_USE_AUTOFLAG_PROPERTY,
	MINEFIELD_ELAPSED_PROPERTY,
	MINEFIELD_PAUSED_PROPERTY,
	MINEFIELD_NUM_PROPERTIES
};
static GParamSpec* minefield_properties[MINEFIELD_NUM_PROPERTIES];
#define _g_timer_destroy0(var) ((var == NULL) ? NULL : (var = (g_timer_destroy (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
enum  {
	MINEFIELD_CLOCK_STARTED_SIGNAL,
	MINEFIELD_PAUSED_CHANGED_SIGNAL,
	MINEFIELD_TICK_SIGNAL,
	MINEFIELD_REDRAW_SECTOR_SIGNAL,
	MINEFIELD_MARKS_CHANGED_SIGNAL,
	MINEFIELD_EXPLODE_SIGNAL,
	MINEFIELD_CLEARED_SIGNAL,
	MINEFIELD_NUM_SIGNALS
};
static guint minefield_signals[MINEFIELD_NUM_SIGNALS] = {0};

struct _Location {
	GObject parent_instance;
	LocationPrivate * priv;
	gboolean has_mine;
	gboolean cleared;
	FlagType flag;
	gint adjacent_mines;
};

struct _LocationClass {
	GObjectClass parent_class;
};

struct _Neighbour {
	gint x;
	gint y;
};

struct _Minefield {
	GObject parent_instance;
	MinefieldPrivate * priv;
	guint width;
	guint height;
	guint n_mines;
	Location** locations;
	gint locations_length1;
	gint locations_length2;
	gboolean exploded;
	gboolean placed_mines;
	gboolean _use_autoflag;
};

struct _MinefieldClass {
	GObjectClass parent_class;
};

struct _MinefieldPrivate {
	guint _n_cleared;
	guint _n_flags;
	gdouble clock_elapsed;
	GTimer* clock;
	guint clock_timeout;
	gboolean _paused;
};

static gpointer location_parent_class = NULL;
static gint Minefield_private_offset;
static gpointer minefield_parent_class = NULL;

VALA_EXTERN GType flag_type_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType location_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Location, g_object_unref)
VALA_EXTERN Location* location_new (void);
VALA_EXTERN Location* location_construct (GType object_type);
static void location_finalize (GObject * obj);
static GType location_get_type_once (void);
VALA_EXTERN GType neighbour_get_type (void) G_GNUC_CONST ;
VALA_EXTERN Neighbour* neighbour_dup (const Neighbour* self);
VALA_EXTERN void neighbour_free (Neighbour* self);
VALA_EXTERN GType minefield_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Minefield, g_object_unref)
VALA_EXTERN Minefield* minefield_new (guint width,
                          guint height,
                          guint n_mines);
VALA_EXTERN Minefield* minefield_construct (GType object_type,
                                guint width,
                                guint height,
                                guint n_mines);
VALA_EXTERN gboolean minefield_is_clock_started (Minefield* self);
VALA_EXTERN gdouble minefield_get_elapsed (Minefield* self);
VALA_EXTERN gboolean minefield_has_mine (Minefield* self,
                             guint x,
                             guint y);
VALA_EXTERN gboolean minefield_is_cleared (Minefield* self,
                               guint x,
                               guint y);
VALA_EXTERN gboolean minefield_is_location (Minefield* self,
                                gint x,
                                gint y);
VALA_EXTERN void minefield_multi_release (Minefield* self,
                              guint x,
                              guint y);
VALA_EXTERN FlagType minefield_get_flag (Minefield* self,
                             guint x,
                             guint y);
VALA_EXTERN guint minefield_get_n_adjacent_mines (Minefield* self,
                                      guint x,
                                      guint y);
VALA_EXTERN gboolean minefield_get_use_autoflag (Minefield* self);
VALA_EXTERN void minefield_clear_mine (Minefield* self,
                           guint x,
                           guint y);
VALA_EXTERN void minefield_set_flag (Minefield* self,
                         guint x,
                         guint y,
                         FlagType flag);
static void minefield_place_mines (Minefield* self,
                            guint x,
                            guint y);
static void minefield_start_clock (Minefield* self);
static void minefield_clear_mines_recursive (Minefield* self,
                                      guint x,
                                      guint y);
static void minefield_stop_clock (Minefield* self);
VALA_EXTERN gboolean minefield_get_is_complete (Minefield* self);
VALA_EXTERN gboolean minefield_has_flag_warning (Minefield* self,
                                     guint x,
                                     guint y);
static void minefield_start_timer (Minefield* self);
static gboolean minefield_timeout_cb (Minefield* self);
static gboolean _minefield_timeout_cb_gsource_func (gpointer self);
static void minefield_continue_clock (Minefield* self);
VALA_EXTERN guint minefield_get_n_cleared (Minefield* self);
VALA_EXTERN guint minefield_get_n_flags (Minefield* self);
VALA_EXTERN void minefield_set_use_autoflag (Minefield* self,
                                 gboolean value);
VALA_EXTERN gboolean minefield_get_paused (Minefield* self);
VALA_EXTERN void minefield_set_paused (Minefield* self,
                           gboolean value);
static void g_cclosure_user_marshal_VOID__UINT_UINT (GClosure * closure,
                                              GValue * return_value,
                                              guint n_param_values,
                                              const GValue * param_values,
                                              gpointer invocation_hint,
                                              gpointer marshal_data);
static void minefield_finalize (GObject * obj);
static GType minefield_get_type_once (void);
static void _vala_minefield_get_property (GObject * object,
                                   guint property_id,
                                   GValue * value,
                                   GParamSpec * pspec);
static void _vala_minefield_set_property (GObject * object,
                                   guint property_id,
                                   const GValue * value,
                                   GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

const Neighbour neighbour_map[8] = {{-1, 1}, {0, 1}, {1, 1}, {1, 0}, {1, -1}, {0, -1}, {-1, -1}, {-1, 0}};

static GType
flag_type_get_type_once (void)
{
	static const GEnumValue values[] = {{FLAG_TYPE_NONE, "FLAG_TYPE_NONE", "none"}, {FLAG_TYPE_FLAG, "FLAG_TYPE_FLAG", "flag"}, {FLAG_TYPE_MAYBE, "FLAG_TYPE_MAYBE", "maybe"}, {0, NULL, NULL}};
	GType flag_type_type_id;
	flag_type_type_id = g_enum_register_static ("FlagType", values);
	return flag_type_type_id;
}

GType
flag_type_get_type (void)
{
	static volatile gsize flag_type_type_id__once = 0;
	if (g_once_init_enter (&flag_type_type_id__once)) {
		GType flag_type_type_id;
		flag_type_type_id = flag_type_get_type_once ();
		g_once_init_leave (&flag_type_type_id__once, flag_type_type_id);
	}
	return flag_type_type_id__once;
}

Location*
location_construct (GType object_type)
{
	Location * self = NULL;
	self = (Location*) g_object_new (object_type, NULL);
	return self;
}

Location*
location_new (void)
{
	return location_construct (TYPE_LOCATION);
}

static void
location_class_init (LocationClass * klass,
                     gpointer klass_data)
{
	location_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = location_finalize;
}

static void
location_instance_init (Location * self,
                        gpointer klass)
{
	self->has_mine = FALSE;
	self->cleared = FALSE;
	self->flag = FLAG_TYPE_NONE;
	self->adjacent_mines = 0;
}

static void
location_finalize (GObject * obj)
{
	Location * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_LOCATION, Location);
	G_OBJECT_CLASS (location_parent_class)->finalize (obj);
}

static GType
location_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (LocationClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) location_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Location), 0, (GInstanceInitFunc) location_instance_init, NULL };
	GType location_type_id;
	location_type_id = g_type_register_static (G_TYPE_OBJECT, "Location", &g_define_type_info, 0);
	return location_type_id;
}

GType
location_get_type (void)
{
	static volatile gsize location_type_id__once = 0;
	if (g_once_init_enter (&location_type_id__once)) {
		GType location_type_id;
		location_type_id = location_get_type_once ();
		g_once_init_leave (&location_type_id__once, location_type_id);
	}
	return location_type_id__once;
}

Neighbour*
neighbour_dup (const Neighbour* self)
{
	Neighbour* dup;
	dup = g_new0 (Neighbour, 1);
	memcpy (dup, self, sizeof (Neighbour));
	return dup;
}

void
neighbour_free (Neighbour* self)
{
	g_free (self);
}

static GType
neighbour_get_type_once (void)
{
	GType neighbour_type_id;
	neighbour_type_id = g_boxed_type_register_static ("Neighbour", (GBoxedCopyFunc) neighbour_dup, (GBoxedFreeFunc) neighbour_free);
	return neighbour_type_id;
}

GType
neighbour_get_type (void)
{
	static volatile gsize neighbour_type_id__once = 0;
	if (g_once_init_enter (&neighbour_type_id__once)) {
		GType neighbour_type_id;
		neighbour_type_id = neighbour_get_type_once ();
		g_once_init_leave (&neighbour_type_id__once, neighbour_type_id);
	}
	return neighbour_type_id__once;
}

static inline gpointer
minefield_get_instance_private (Minefield* self)
{
	return G_STRUCT_MEMBER_P (self, Minefield_private_offset);
}

Minefield*
minefield_construct (GType object_type,
                     guint width,
                     guint height,
                     guint n_mines)
{
	Minefield * self = NULL;
	Location** _tmp0_;
	self = (Minefield*) g_object_new (object_type, NULL);
	_tmp0_ = g_new0 (Location*, (width * height) + 1);
	self->locations = (_vala_array_free (self->locations, self->locations_length1 * self->locations_length2, (GDestroyNotify) g_object_unref), NULL);
	self->locations = _tmp0_;
	self->locations_length1 = width;
	self->locations_length2 = height;
	{
		gint x = 0;
		x = 0;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				if (!_tmp1_) {
					gint _tmp2_;
					_tmp2_ = x;
					x = _tmp2_ + 1;
				}
				_tmp1_ = FALSE;
				if (!(((guint) x) < width)) {
					break;
				}
				{
					gint y = 0;
					y = 0;
					{
						gboolean _tmp3_ = FALSE;
						_tmp3_ = TRUE;
						while (TRUE) {
							Location** _tmp5_;
							gint _tmp5__length1;
							gint _tmp5__length2;
							Location* _tmp6_;
							if (!_tmp3_) {
								gint _tmp4_;
								_tmp4_ = y;
								y = _tmp4_ + 1;
							}
							_tmp3_ = FALSE;
							if (!(((guint) y) < height)) {
								break;
							}
							_tmp5_ = self->locations;
							_tmp5__length1 = self->locations_length1;
							_tmp5__length2 = self->locations_length2;
							_tmp6_ = location_new ();
							_g_object_unref0 (_tmp5_[(x * _tmp5__length2) + y]);
							_tmp5_[(x * _tmp5__length2) + y] = _tmp6_;
						}
					}
				}
			}
		}
	}
	self->width = width;
	self->height = height;
	self->n_mines = n_mines;
	return self;
}

Minefield*
minefield_new (guint width,
               guint height,
               guint n_mines)
{
	return minefield_construct (TYPE_MINEFIELD, width, height, n_mines);
}

gboolean
minefield_is_clock_started (Minefield* self)
{
	gdouble _tmp0_;
	gdouble _tmp1_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = minefield_get_elapsed (self);
	_tmp1_ = _tmp0_;
	result = _tmp1_ > ((gdouble) 0);
	return result;
}

gboolean
minefield_has_mine (Minefield* self,
                    guint x,
                    guint y)
{
	Location** _tmp0_;
	gint _tmp0__length1;
	gint _tmp0__length2;
	Location* _tmp1_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->locations;
	_tmp0__length1 = self->locations_length1;
	_tmp0__length2 = self->locations_length2;
	_tmp1_ = _tmp0_[(x * _tmp0__length2) + y];
	result = _tmp1_->has_mine;
	return result;
}

gboolean
minefield_is_cleared (Minefield* self,
                      guint x,
                      guint y)
{
	Location** _tmp0_;
	gint _tmp0__length1;
	gint _tmp0__length2;
	Location* _tmp1_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->locations;
	_tmp0__length1 = self->locations_length1;
	_tmp0__length2 = self->locations_length2;
	_tmp1_ = _tmp0_[(x * _tmp0__length2) + y];
	result = _tmp1_->cleared;
	return result;
}

gboolean
minefield_is_location (Minefield* self,
                       gint x,
                       gint y)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	if (x >= 0) {
		_tmp2_ = y >= 0;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		_tmp1_ = ((guint) x) < self->width;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		_tmp0_ = ((guint) y) < self->height;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

void
minefield_multi_release (Minefield* self,
                         guint x,
                         guint y)
{
	gboolean _tmp0_ = FALSE;
	guint n_mines = 0U;
	guint n_flags = 0U;
	guint n_unknown = 0U;
	gboolean do_clear = FALSE;
	g_return_if_fail (self != NULL);
	if (!minefield_is_cleared (self, x, y)) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = minefield_get_flag (self, x, y) == FLAG_TYPE_FLAG;
	}
	if (_tmp0_) {
		return;
	}
	n_mines = minefield_get_n_adjacent_mines (self, x, y);
	n_flags = (guint) 0;
	n_unknown = (guint) 0;
	{
		Neighbour* neighbour_collection = NULL;
		gint neighbour_collection_length1 = 0;
		gint _neighbour_collection_size_ = 0;
		gint neighbour_it = 0;
		neighbour_collection = neighbour_map;
		neighbour_collection_length1 = G_N_ELEMENTS (neighbour_map);
		for (neighbour_it = 0; neighbour_it < neighbour_collection_length1; neighbour_it = neighbour_it + 1) {
			Neighbour neighbour = {0};
			neighbour = neighbour_collection[neighbour_it];
			{
				gint nx = 0;
				Neighbour _tmp1_;
				gint ny = 0;
				Neighbour _tmp2_;
				_tmp1_ = neighbour;
				nx = ((gint) x) + _tmp1_.x;
				_tmp2_ = neighbour;
				ny = ((gint) y) + _tmp2_.y;
				if (!minefield_is_location (self, nx, ny)) {
					continue;
				}
				if (minefield_get_flag (self, (guint) nx, (guint) ny) == FLAG_TYPE_FLAG) {
					guint _tmp3_;
					_tmp3_ = n_flags;
					n_flags = _tmp3_ + 1;
				}
				if (!minefield_is_cleared (self, (guint) nx, (guint) ny)) {
					guint _tmp4_;
					_tmp4_ = n_unknown;
					n_unknown = _tmp4_ + 1;
				}
			}
		}
	}
	do_clear = FALSE;
	if (n_mines == n_flags) {
		do_clear = TRUE;
	} else {
		gboolean _tmp5_ = FALSE;
		gboolean _tmp6_;
		gboolean _tmp7_;
		_tmp6_ = minefield_get_use_autoflag (self);
		_tmp7_ = _tmp6_;
		if (_tmp7_) {
			_tmp5_ = n_unknown == n_mines;
		} else {
			_tmp5_ = FALSE;
		}
		if (_tmp5_) {
			do_clear = FALSE;
		} else {
			return;
		}
	}
	{
		Neighbour* neighbour_collection = NULL;
		gint neighbour_collection_length1 = 0;
		gint _neighbour_collection_size_ = 0;
		gint neighbour_it = 0;
		neighbour_collection = neighbour_map;
		neighbour_collection_length1 = G_N_ELEMENTS (neighbour_map);
		for (neighbour_it = 0; neighbour_it < neighbour_collection_length1; neighbour_it = neighbour_it + 1) {
			Neighbour neighbour = {0};
			neighbour = neighbour_collection[neighbour_it];
			{
				gint nx = 0;
				Neighbour _tmp8_;
				gint ny = 0;
				Neighbour _tmp9_;
				gboolean _tmp10_ = FALSE;
				_tmp8_ = neighbour;
				nx = ((gint) x) + _tmp8_.x;
				_tmp9_ = neighbour;
				ny = ((gint) y) + _tmp9_.y;
				if (!minefield_is_location (self, nx, ny)) {
					continue;
				}
				if (do_clear) {
					_tmp10_ = minefield_get_flag (self, (guint) nx, (guint) ny) != FLAG_TYPE_FLAG;
				} else {
					_tmp10_ = FALSE;
				}
				if (_tmp10_) {
					GTimer* _tmp11_;
					minefield_clear_mine (self, (guint) nx, (guint) ny);
					_tmp11_ = self->priv->clock;
					if (_tmp11_ == NULL) {
						return;
					}
				} else {
					minefield_set_flag (self, (guint) nx, (guint) ny, FLAG_TYPE_FLAG);
				}
			}
		}
	}
}

void
minefield_clear_mine (Minefield* self,
                      guint x,
                      guint y)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp2_ = FALSE;
	Location** _tmp3_;
	gint _tmp3__length1;
	gint _tmp3__length2;
	Location* _tmp4_;
	Location** _tmp7_;
	gint _tmp7__length1;
	gint _tmp7__length2;
	Location* _tmp8_;
	gboolean _tmp9_ = FALSE;
	gboolean _tmp10_;
	gboolean _tmp11_;
	g_return_if_fail (self != NULL);
	if (!self->placed_mines) {
		minefield_place_mines (self, x, y);
		self->placed_mines = TRUE;
	}
	if (!self->exploded) {
		GTimer* _tmp1_;
		_tmp1_ = self->priv->clock;
		_tmp0_ = _tmp1_ == NULL;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		minefield_start_clock (self);
	}
	_tmp3_ = self->locations;
	_tmp3__length1 = self->locations_length1;
	_tmp3__length2 = self->locations_length2;
	_tmp4_ = _tmp3_[(x * _tmp3__length2) + y];
	if (_tmp4_->cleared) {
		_tmp2_ = TRUE;
	} else {
		Location** _tmp5_;
		gint _tmp5__length1;
		gint _tmp5__length2;
		Location* _tmp6_;
		_tmp5_ = self->locations;
		_tmp5__length1 = self->locations_length1;
		_tmp5__length2 = self->locations_length2;
		_tmp6_ = _tmp5_[(x * _tmp5__length2) + y];
		_tmp2_ = _tmp6_->flag == FLAG_TYPE_FLAG;
	}
	if (_tmp2_) {
		return;
	}
	minefield_clear_mines_recursive (self, x, y);
	_tmp7_ = self->locations;
	_tmp7__length1 = self->locations_length1;
	_tmp7__length2 = self->locations_length2;
	_tmp8_ = _tmp7_[(x * _tmp7__length2) + y];
	if (_tmp8_->has_mine) {
		if (!self->exploded) {
			self->exploded = TRUE;
			minefield_stop_clock (self);
			g_signal_emit (self, minefield_signals[MINEFIELD_EXPLODE_SIGNAL], 0);
		}
		return;
	}
	_tmp10_ = minefield_get_is_complete (self);
	_tmp11_ = _tmp10_;
	if (_tmp11_) {
		_tmp9_ = !self->exploded;
	} else {
		_tmp9_ = FALSE;
	}
	if (_tmp9_) {
		minefield_stop_clock (self);
		{
			gint tx = 0;
			tx = 0;
			{
				gboolean _tmp12_ = FALSE;
				_tmp12_ = TRUE;
				while (TRUE) {
					if (!_tmp12_) {
						gint _tmp13_;
						_tmp13_ = tx;
						tx = _tmp13_ + 1;
					}
					_tmp12_ = FALSE;
					if (!(((guint) tx) < self->width)) {
						break;
					}
					{
						gint ty = 0;
						ty = 0;
						{
							gboolean _tmp14_ = FALSE;
							_tmp14_ = TRUE;
							while (TRUE) {
								if (!_tmp14_) {
									gint _tmp15_;
									_tmp15_ = ty;
									ty = _tmp15_ + 1;
								}
								_tmp14_ = FALSE;
								if (!(((guint) ty) < self->height)) {
									break;
								}
								if (minefield_has_mine (self, (guint) tx, (guint) ty)) {
									minefield_set_flag (self, (guint) tx, (guint) ty, FLAG_TYPE_FLAG);
								}
							}
						}
					}
				}
			}
		}
		g_signal_emit (self, minefield_signals[MINEFIELD_CLEARED_SIGNAL], 0);
	}
}

static void
minefield_clear_mines_recursive (Minefield* self,
                                 guint x,
                                 guint y)
{
	Location** _tmp0_;
	gint _tmp0__length1;
	gint _tmp0__length2;
	Location* _tmp1_;
	Location** _tmp2_;
	gint _tmp2__length1;
	gint _tmp2__length2;
	Location* _tmp3_;
	guint _tmp4_;
	Location** _tmp5_;
	gint _tmp5__length1;
	gint _tmp5__length2;
	Location* _tmp6_;
	Location** _tmp8_;
	gint _tmp8__length1;
	gint _tmp8__length2;
	Location* _tmp9_;
	gboolean _tmp10_ = FALSE;
	Location** _tmp11_;
	gint _tmp11__length1;
	gint _tmp11__length2;
	Location* _tmp12_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->locations;
	_tmp0__length1 = self->locations_length1;
	_tmp0__length2 = self->locations_length2;
	_tmp1_ = _tmp0_[(x * _tmp0__length2) + y];
	if (_tmp1_->cleared) {
		return;
	}
	_tmp2_ = self->locations;
	_tmp2__length1 = self->locations_length1;
	_tmp2__length2 = self->locations_length2;
	_tmp3_ = _tmp2_[(x * _tmp2__length2) + y];
	_tmp3_->cleared = TRUE;
	_tmp4_ = self->priv->_n_cleared;
	self->priv->_n_cleared = _tmp4_ + 1;
	_tmp5_ = self->locations;
	_tmp5__length1 = self->locations_length1;
	_tmp5__length2 = self->locations_length2;
	_tmp6_ = _tmp5_[(x * _tmp5__length2) + y];
	if (_tmp6_->flag == FLAG_TYPE_FLAG) {
		guint _tmp7_;
		_tmp7_ = self->priv->_n_flags;
		self->priv->_n_flags = _tmp7_ - 1;
	}
	_tmp8_ = self->locations;
	_tmp8__length1 = self->locations_length1;
	_tmp8__length2 = self->locations_length2;
	_tmp9_ = _tmp8_[(x * _tmp8__length2) + y];
	_tmp9_->flag = FLAG_TYPE_NONE;
	g_signal_emit (self, minefield_signals[MINEFIELD_REDRAW_SECTOR_SIGNAL], 0, x, y);
	g_signal_emit (self, minefield_signals[MINEFIELD_MARKS_CHANGED_SIGNAL], 0);
	_tmp11_ = self->locations;
	_tmp11__length1 = self->locations_length1;
	_tmp11__length2 = self->locations_length2;
	_tmp12_ = _tmp11_[(x * _tmp11__length2) + y];
	if (!_tmp12_->has_mine) {
		_tmp10_ = minefield_get_n_adjacent_mines (self, x, y) == ((guint) 0);
	} else {
		_tmp10_ = FALSE;
	}
	if (_tmp10_) {
		{
			Neighbour* neighbour_collection = NULL;
			gint neighbour_collection_length1 = 0;
			gint _neighbour_collection_size_ = 0;
			gint neighbour_it = 0;
			neighbour_collection = neighbour_map;
			neighbour_collection_length1 = G_N_ELEMENTS (neighbour_map);
			for (neighbour_it = 0; neighbour_it < neighbour_collection_length1; neighbour_it = neighbour_it + 1) {
				Neighbour neighbour = {0};
				neighbour = neighbour_collection[neighbour_it];
				{
					gint nx = 0;
					Neighbour _tmp13_;
					gint ny = 0;
					Neighbour _tmp14_;
					_tmp13_ = neighbour;
					nx = ((gint) x) + _tmp13_.x;
					_tmp14_ = neighbour;
					ny = ((gint) y) + _tmp14_.y;
					if (minefield_is_location (self, nx, ny)) {
						minefield_clear_mines_recursive (self, (guint) nx, (guint) ny);
					}
				}
			}
		}
	}
}

void
minefield_set_flag (Minefield* self,
                    guint x,
                    guint y,
                    FlagType flag)
{
	gboolean _tmp0_ = FALSE;
	Location** _tmp1_;
	gint _tmp1__length1;
	gint _tmp1__length2;
	Location* _tmp2_;
	Location** _tmp9_;
	gint _tmp9__length1;
	gint _tmp9__length2;
	Location* _tmp10_;
	g_return_if_fail (self != NULL);
	_tmp1_ = self->locations;
	_tmp1__length1 = self->locations_length1;
	_tmp1__length2 = self->locations_length2;
	_tmp2_ = _tmp1_[(x * _tmp1__length2) + y];
	if (_tmp2_->cleared) {
		_tmp0_ = TRUE;
	} else {
		Location** _tmp3_;
		gint _tmp3__length1;
		gint _tmp3__length2;
		Location* _tmp4_;
		_tmp3_ = self->locations;
		_tmp3__length1 = self->locations_length1;
		_tmp3__length2 = self->locations_length2;
		_tmp4_ = _tmp3_[(x * _tmp3__length2) + y];
		_tmp0_ = _tmp4_->flag == flag;
	}
	if (_tmp0_) {
		return;
	}
	if (flag == FLAG_TYPE_FLAG) {
		guint _tmp5_;
		_tmp5_ = self->priv->_n_flags;
		self->priv->_n_flags = _tmp5_ + 1;
	} else {
		Location** _tmp6_;
		gint _tmp6__length1;
		gint _tmp6__length2;
		Location* _tmp7_;
		_tmp6_ = self->locations;
		_tmp6__length1 = self->locations_length1;
		_tmp6__length2 = self->locations_length2;
		_tmp7_ = _tmp6_[(x * _tmp6__length2) + y];
		if (_tmp7_->flag == FLAG_TYPE_FLAG) {
			guint _tmp8_;
			_tmp8_ = self->priv->_n_flags;
			self->priv->_n_flags = _tmp8_ - 1;
		}
	}
	_tmp9_ = self->locations;
	_tmp9__length1 = self->locations_length1;
	_tmp9__length2 = self->locations_length2;
	_tmp10_ = _tmp9_[(x * _tmp9__length2) + y];
	_tmp10_->flag = flag;
	g_signal_emit (self, minefield_signals[MINEFIELD_REDRAW_SECTOR_SIGNAL], 0, x, y);
	g_signal_emit (self, minefield_signals[MINEFIELD_MARKS_CHANGED_SIGNAL], 0);
}

FlagType
minefield_get_flag (Minefield* self,
                    guint x,
                    guint y)
{
	Location** _tmp0_;
	gint _tmp0__length1;
	gint _tmp0__length2;
	Location* _tmp1_;
	FlagType result;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->locations;
	_tmp0__length1 = self->locations_length1;
	_tmp0__length2 = self->locations_length2;
	_tmp1_ = _tmp0_[(x * _tmp0__length2) + y];
	result = _tmp1_->flag;
	return result;
}

guint
minefield_get_n_adjacent_mines (Minefield* self,
                                guint x,
                                guint y)
{
	Location** _tmp0_;
	gint _tmp0__length1;
	gint _tmp0__length2;
	Location* _tmp1_;
	guint result;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = self->locations;
	_tmp0__length1 = self->locations_length1;
	_tmp0__length2 = self->locations_length2;
	_tmp1_ = _tmp0_[(x * _tmp0__length2) + y];
	result = (guint) _tmp1_->adjacent_mines;
	return result;
}

gboolean
minefield_has_flag_warning (Minefield* self,
                            guint x,
                            guint y)
{
	guint n_mines = 0U;
	guint n_flags = 0U;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	if (!minefield_is_cleared (self, x, y)) {
		result = FALSE;
		return result;
	}
	n_mines = (guint) 0;
	n_flags = (guint) 0;
	{
		Neighbour* neighbour_collection = NULL;
		gint neighbour_collection_length1 = 0;
		gint _neighbour_collection_size_ = 0;
		gint neighbour_it = 0;
		neighbour_collection = neighbour_map;
		neighbour_collection_length1 = G_N_ELEMENTS (neighbour_map);
		for (neighbour_it = 0; neighbour_it < neighbour_collection_length1; neighbour_it = neighbour_it + 1) {
			Neighbour neighbour = {0};
			neighbour = neighbour_collection[neighbour_it];
			{
				gint nx = 0;
				Neighbour _tmp0_;
				gint ny = 0;
				Neighbour _tmp1_;
				_tmp0_ = neighbour;
				nx = ((gint) x) + _tmp0_.x;
				_tmp1_ = neighbour;
				ny = ((gint) y) + _tmp1_.y;
				if (!minefield_is_location (self, nx, ny)) {
					continue;
				}
				if (minefield_has_mine (self, (guint) nx, (guint) ny)) {
					guint _tmp2_;
					_tmp2_ = n_mines;
					n_mines = _tmp2_ + 1;
				}
				if (minefield_get_flag (self, (guint) nx, (guint) ny) == FLAG_TYPE_FLAG) {
					guint _tmp3_;
					_tmp3_ = n_flags;
					n_flags = _tmp3_ + 1;
				}
			}
		}
	}
	result = n_flags > n_mines;
	return result;
}

static void
minefield_place_mines (Minefield* self,
                       guint x,
                       guint y)
{
	g_return_if_fail (self != NULL);
	{
		gint n = 0;
		n = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint32 rx = 0;
				gint32 ry = 0;
				gboolean _tmp1_ = FALSE;
				Location** _tmp2_;
				gint _tmp2__length1;
				gint _tmp2__length2;
				Location* _tmp3_;
				if (!_tmp0_) {
				}
				_tmp0_ = FALSE;
				if (!(((guint) n) < self->n_mines)) {
					break;
				}
				rx = g_random_int_range ((gint32) 0, (gint32) self->width);
				ry = g_random_int_range ((gint32) 0, (gint32) self->height);
				if (((guint) rx) == x) {
					_tmp1_ = ((guint) ry) == y;
				} else {
					_tmp1_ = FALSE;
				}
				if (_tmp1_) {
					continue;
				}
				_tmp2_ = self->locations;
				_tmp2__length1 = self->locations_length1;
				_tmp2__length2 = self->locations_length2;
				_tmp3_ = _tmp2_[(rx * _tmp2__length2) + ry];
				if (!_tmp3_->has_mine) {
					gboolean adj_found = FALSE;
					adj_found = FALSE;
					{
						Neighbour* neighbour_collection = NULL;
						gint neighbour_collection_length1 = 0;
						gint _neighbour_collection_size_ = 0;
						gint neighbour_it = 0;
						neighbour_collection = neighbour_map;
						neighbour_collection_length1 = G_N_ELEMENTS (neighbour_map);
						for (neighbour_it = 0; neighbour_it < neighbour_collection_length1; neighbour_it = neighbour_it + 1) {
							Neighbour neighbour = {0};
							neighbour = neighbour_collection[neighbour_it];
							{
								gboolean _tmp4_ = FALSE;
								Neighbour _tmp5_;
								_tmp5_ = neighbour;
								if (((guint) rx) == (x + _tmp5_.x)) {
									Neighbour _tmp6_;
									_tmp6_ = neighbour;
									_tmp4_ = ((guint) ry) == (y + _tmp6_.y);
								} else {
									_tmp4_ = FALSE;
								}
								if (_tmp4_) {
									adj_found = TRUE;
									break;
								}
							}
						}
					}
					if (!adj_found) {
						Location** _tmp7_;
						gint _tmp7__length1;
						gint _tmp7__length2;
						Location* _tmp8_;
						gint _tmp9_;
						_tmp7_ = self->locations;
						_tmp7__length1 = self->locations_length1;
						_tmp7__length2 = self->locations_length2;
						_tmp8_ = _tmp7_[(rx * _tmp7__length2) + ry];
						_tmp8_->has_mine = TRUE;
						_tmp9_ = n;
						n = _tmp9_ + 1;
						{
							Neighbour* neighbour_collection = NULL;
							gint neighbour_collection_length1 = 0;
							gint _neighbour_collection_size_ = 0;
							gint neighbour_it = 0;
							neighbour_collection = neighbour_map;
							neighbour_collection_length1 = G_N_ELEMENTS (neighbour_map);
							for (neighbour_it = 0; neighbour_it < neighbour_collection_length1; neighbour_it = neighbour_it + 1) {
								Neighbour neighbour = {0};
								neighbour = neighbour_collection[neighbour_it];
								{
									gint32 nx = 0;
									Neighbour _tmp10_;
									gint32 ny = 0;
									Neighbour _tmp11_;
									_tmp10_ = neighbour;
									nx = rx + _tmp10_.x;
									_tmp11_ = neighbour;
									ny = ry + _tmp11_.y;
									if (minefield_is_location (self, (gint) nx, (gint) ny)) {
										Location** _tmp12_;
										gint _tmp12__length1;
										gint _tmp12__length2;
										Location* _tmp13_;
										gint _tmp14_;
										_tmp12_ = self->locations;
										_tmp12__length1 = self->locations_length1;
										_tmp12__length2 = self->locations_length2;
										_tmp13_ = _tmp12_[(nx * _tmp12__length2) + ny];
										_tmp14_ = _tmp13_->adjacent_mines;
										_tmp13_->adjacent_mines = _tmp14_ + 1;
									}
								}
							}
						}
					}
				}
			}
		}
	}
}

static gboolean
_minefield_timeout_cb_gsource_func (gpointer self)
{
	gboolean result;
	result = minefield_timeout_cb ((Minefield*) self);
	return result;
}

static void
minefield_start_timer (Minefield* self)
{
	g_return_if_fail (self != NULL);
	if (self->priv->clock_timeout != ((guint) 0)) {
		g_source_remove (self->priv->clock_timeout);
	}
	self->priv->clock_timeout = (guint) 0;
	self->priv->clock_timeout = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 500, _minefield_timeout_cb_gsource_func, g_object_ref (self), g_object_unref);
}

static void
minefield_start_clock (Minefield* self)
{
	GTimer* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->clock;
	if (_tmp0_ == NULL) {
		GTimer* _tmp1_;
		_tmp1_ = g_timer_new ();
		_g_timer_destroy0 (self->priv->clock);
		self->priv->clock = _tmp1_;
	}
	g_signal_emit (self, minefield_signals[MINEFIELD_CLOCK_STARTED_SIGNAL], 0);
	g_signal_emit (self, minefield_signals[MINEFIELD_TICK_SIGNAL], 0);
	minefield_start_timer (self);
}

static void
minefield_stop_clock (Minefield* self)
{
	GTimer* _tmp0_;
	GTimer* _tmp1_;
	GTimer* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->clock;
	if (_tmp0_ == NULL) {
		return;
	}
	_tmp1_ = self->priv->clock;
	self->priv->clock_elapsed = self->priv->clock_elapsed + g_timer_elapsed (_tmp1_, NULL);
	if (self->priv->clock_timeout != ((guint) 0)) {
		g_source_remove (self->priv->clock_timeout);
	}
	self->priv->clock_timeout = (guint) 0;
	_tmp2_ = self->priv->clock;
	g_timer_stop (_tmp2_);
	_g_timer_destroy0 (self->priv->clock);
	self->priv->clock = NULL;
	g_signal_emit (self, minefield_signals[MINEFIELD_TICK_SIGNAL], 0);
}

static void
minefield_continue_clock (Minefield* self)
{
	GTimer* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->clock;
	if (_tmp0_ == NULL) {
		GTimer* _tmp1_;
		_tmp1_ = g_timer_new ();
		_g_timer_destroy0 (self->priv->clock);
		self->priv->clock = _tmp1_;
	} else {
		GTimer* _tmp2_;
		_tmp2_ = self->priv->clock;
		g_timer_continue (_tmp2_);
	}
	g_signal_emit (self, minefield_signals[MINEFIELD_TICK_SIGNAL], 0);
	minefield_start_timer (self);
}

static gboolean
minefield_timeout_cb (Minefield* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_signal_emit (self, minefield_signals[MINEFIELD_TICK_SIGNAL], 0);
	result = TRUE;
	return result;
}

guint
minefield_get_n_cleared (Minefield* self)
{
	guint result;
	g_return_val_if_fail (self != NULL, 0U);
	result = self->priv->_n_cleared;
	return result;
}

gboolean
minefield_get_is_complete (Minefield* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_n_cleared == ((self->width * self->height) - self->n_mines);
	return result;
}

guint
minefield_get_n_flags (Minefield* self)
{
	guint result;
	g_return_val_if_fail (self != NULL, 0U);
	result = self->priv->_n_flags;
	return result;
}

gboolean
minefield_get_use_autoflag (Minefield* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->_use_autoflag;
	return result;
}

void
minefield_set_use_autoflag (Minefield* self,
                            gboolean value)
{
	g_return_if_fail (self != NULL);
	self->_use_autoflag = value;
	g_object_notify_by_pspec ((GObject *) self, minefield_properties[MINEFIELD_USE_AUTOFLAG_PROPERTY]);
}

gdouble
minefield_get_elapsed (Minefield* self)
{
	gdouble result;
	gdouble _tmp0_ = 0.0;
	GTimer* _tmp1_;
	g_return_val_if_fail (self != NULL, 0.0);
	_tmp1_ = self->priv->clock;
	if (_tmp1_ == NULL) {
		_tmp0_ = 0.0;
	} else {
		GTimer* _tmp2_;
		_tmp2_ = self->priv->clock;
		_tmp0_ = g_timer_elapsed (_tmp2_, NULL);
	}
	result = self->priv->clock_elapsed + _tmp0_;
	return result;
}

gboolean
minefield_get_paused (Minefield* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_paused;
	return result;
}

void
minefield_set_paused (Minefield* self,
                      gboolean value)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp1_ = minefield_get_is_complete (self);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = self->exploded;
	}
	if (_tmp0_) {
		return;
	}
	if (value) {
		_tmp3_ = !self->priv->_paused;
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		minefield_stop_clock (self);
	} else {
		gboolean _tmp4_ = FALSE;
		if (!value) {
			_tmp4_ = self->priv->_paused;
		} else {
			_tmp4_ = FALSE;
		}
		if (_tmp4_) {
			minefield_continue_clock (self);
		}
	}
	self->priv->_paused = value;
	g_signal_emit (self, minefield_signals[MINEFIELD_PAUSED_CHANGED_SIGNAL], 0);
	g_object_notify_by_pspec ((GObject *) self, minefield_properties[MINEFIELD_PAUSED_PROPERTY]);
}

static void
g_cclosure_user_marshal_VOID__UINT_UINT (GClosure * closure,
                                         GValue * return_value,
                                         guint n_param_values,
                                         const GValue * param_values,
                                         gpointer invocation_hint,
                                         gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__UINT_UINT) (gpointer data1, guint arg_1, guint arg_2, gpointer data2);
	register GMarshalFunc_VOID__UINT_UINT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__UINT_UINT) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_uint (param_values + 1), g_value_get_uint (param_values + 2), data2);
}

static void
minefield_class_init (MinefieldClass * klass,
                      gpointer klass_data)
{
	minefield_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &Minefield_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_minefield_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_minefield_set_property;
	G_OBJECT_CLASS (klass)->finalize = minefield_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), MINEFIELD_N_CLEARED_PROPERTY, minefield_properties[MINEFIELD_N_CLEARED_PROPERTY] = g_param_spec_uint ("n-cleared", "n-cleared", "n-cleared", 0, G_MAXUINT, 0U, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MINEFIELD_IS_COMPLETE_PROPERTY, minefield_properties[MINEFIELD_IS_COMPLETE_PROPERTY] = g_param_spec_boolean ("is-complete", "is-complete", "is-complete", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MINEFIELD_N_FLAGS_PROPERTY, minefield_properties[MINEFIELD_N_FLAGS_PROPERTY] = g_param_spec_uint ("n-flags", "n-flags", "n-flags", 0, G_MAXUINT, 0U, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MINEFIELD_USE_AUTOFLAG_PROPERTY, minefield_properties[MINEFIELD_USE_AUTOFLAG_PROPERTY] = g_param_spec_boolean ("use-autoflag", "use-autoflag", "use-autoflag", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MINEFIELD_ELAPSED_PROPERTY, minefield_properties[MINEFIELD_ELAPSED_PROPERTY] = g_param_spec_double ("elapsed", "elapsed", "elapsed", -G_MAXDOUBLE, G_MAXDOUBLE, 0.0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MINEFIELD_PAUSED_PROPERTY, minefield_properties[MINEFIELD_PAUSED_PROPERTY] = g_param_spec_boolean ("paused", "paused", "paused", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	minefield_signals[MINEFIELD_CLOCK_STARTED_SIGNAL] = g_signal_new ("clock-started", TYPE_MINEFIELD, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	minefield_signals[MINEFIELD_PAUSED_CHANGED_SIGNAL] = g_signal_new ("paused-changed", TYPE_MINEFIELD, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	minefield_signals[MINEFIELD_TICK_SIGNAL] = g_signal_new ("tick", TYPE_MINEFIELD, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	minefield_signals[MINEFIELD_REDRAW_SECTOR_SIGNAL] = g_signal_new ("redraw-sector", TYPE_MINEFIELD, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__UINT_UINT, G_TYPE_NONE, 2, G_TYPE_UINT, G_TYPE_UINT);
	minefield_signals[MINEFIELD_MARKS_CHANGED_SIGNAL] = g_signal_new ("marks-changed", TYPE_MINEFIELD, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	minefield_signals[MINEFIELD_EXPLODE_SIGNAL] = g_signal_new ("explode", TYPE_MINEFIELD, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	minefield_signals[MINEFIELD_CLEARED_SIGNAL] = g_signal_new ("cleared", TYPE_MINEFIELD, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
minefield_instance_init (Minefield * self,
                         gpointer klass)
{
	self->priv = minefield_get_instance_private (self);
	self->width = (guint) 0;
	self->height = (guint) 0;
	self->n_mines = (guint) 0;
	self->exploded = FALSE;
	self->placed_mines = FALSE;
	self->priv->_n_cleared = (guint) 0;
	self->priv->_n_flags = (guint) 0;
	self->priv->_paused = FALSE;
}

static void
minefield_finalize (GObject * obj)
{
	Minefield * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_MINEFIELD, Minefield);
	self->locations = (_vala_array_free (self->locations, self->locations_length1 * self->locations_length2, (GDestroyNotify) g_object_unref), NULL);
	_g_timer_destroy0 (self->priv->clock);
	G_OBJECT_CLASS (minefield_parent_class)->finalize (obj);
}

static GType
minefield_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (MinefieldClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) minefield_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Minefield), 0, (GInstanceInitFunc) minefield_instance_init, NULL };
	GType minefield_type_id;
	minefield_type_id = g_type_register_static (G_TYPE_OBJECT, "Minefield", &g_define_type_info, 0);
	Minefield_private_offset = g_type_add_instance_private (minefield_type_id, sizeof (MinefieldPrivate));
	return minefield_type_id;
}

GType
minefield_get_type (void)
{
	static volatile gsize minefield_type_id__once = 0;
	if (g_once_init_enter (&minefield_type_id__once)) {
		GType minefield_type_id;
		minefield_type_id = minefield_get_type_once ();
		g_once_init_leave (&minefield_type_id__once, minefield_type_id);
	}
	return minefield_type_id__once;
}

static void
_vala_minefield_get_property (GObject * object,
                              guint property_id,
                              GValue * value,
                              GParamSpec * pspec)
{
	Minefield * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_MINEFIELD, Minefield);
	switch (property_id) {
		case MINEFIELD_N_CLEARED_PROPERTY:
		g_value_set_uint (value, minefield_get_n_cleared (self));
		break;
		case MINEFIELD_IS_COMPLETE_PROPERTY:
		g_value_set_boolean (value, minefield_get_is_complete (self));
		break;
		case MINEFIELD_N_FLAGS_PROPERTY:
		g_value_set_uint (value, minefield_get_n_flags (self));
		break;
		case MINEFIELD_USE_AUTOFLAG_PROPERTY:
		g_value_set_boolean (value, minefield_get_use_autoflag (self));
		break;
		case MINEFIELD_ELAPSED_PROPERTY:
		g_value_set_double (value, minefield_get_elapsed (self));
		break;
		case MINEFIELD_PAUSED_PROPERTY:
		g_value_set_boolean (value, minefield_get_paused (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_minefield_set_property (GObject * object,
                              guint property_id,
                              const GValue * value,
                              GParamSpec * pspec)
{
	Minefield * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_MINEFIELD, Minefield);
	switch (property_id) {
		case MINEFIELD_USE_AUTOFLAG_PROPERTY:
		minefield_set_use_autoflag (self, g_value_get_boolean (value));
		break;
		case MINEFIELD_PAUSED_PROPERTY:
		minefield_set_paused (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

