/*
 * UAE - The portable Amiga emulator.
 *
 * This file was generated by genlinetoscr. Don't edit.
 */

static int NOINLINE __attribute__((__unused__)) linetoscr_16(int spix, int dpix, int dpix_end)
{
    uae_u16 *buf = (uae_u16 *) xlinebuffer;

    if (bplham) {
        int rem;
        if (((uintptr_t)&buf[dpix]) & 2) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            spix_val = ham_linebuf[spix];
            dpix_val = xcolors[spix_val];
            spix++;
            buf[dpix++] = dpix_val;
        }
        if (dpix >= dpix_end)
            return spix;
        rem = (((uintptr_t)&buf[dpix_end]) & 2);
        if (rem)
            dpix_end--;
        while (dpix < dpix_end) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = ham_linebuf[spix];
            dpix_val = xcolors[spix_val];
            spix++;
            out_val = dpix_val;
            spix_val = ham_linebuf[spix];
            dpix_val = xcolors[spix_val];
            spix++;
            out_val = (out_val & 0xFFFF) | (dpix_val << 16);
            *((uae_u32 *)&buf[dpix]) = out_val;
            dpix += 2;
        }
        if (rem) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            spix_val = ham_linebuf[spix];
            dpix_val = xcolors[spix_val];
            spix++;
            buf[dpix++] = dpix_val;
        }
    } else if (bpldualpf) {
        int *lookup = bpldualpfpri ? dblpf_ind2 : dblpf_ind1;
        int rem;
        if (((uintptr_t)&buf[dpix]) & 2) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            spix_val = pixdata.apixels[spix];
            dpix_val = colors_for_drawing.acolors[lookup[spix_val]];
            spix++;
            buf[dpix++] = dpix_val;
        }
        if (dpix >= dpix_end)
            return spix;
        rem = (((uintptr_t)&buf[dpix_end]) & 2);
        if (rem)
            dpix_end--;
        while (dpix < dpix_end) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix];
            dpix_val = colors_for_drawing.acolors[lookup[spix_val]];
            spix++;
            out_val = dpix_val;
            spix_val = pixdata.apixels[spix];
            dpix_val = colors_for_drawing.acolors[lookup[spix_val]];
            spix++;
            out_val = (out_val & 0xFFFF) | (dpix_val << 16);
            *((uae_u32 *)&buf[dpix]) = out_val;
            dpix += 2;
        }
        if (rem) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            spix_val = pixdata.apixels[spix];
            dpix_val = colors_for_drawing.acolors[lookup[spix_val]];
            spix++;
            buf[dpix++] = dpix_val;
        }
    } else if (bplehb) {
        int rem;
        if (((uintptr_t)&buf[dpix]) & 2) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            spix_val = pixdata.apixels[spix];
            if (spix_val <= 31)
                dpix_val = colors_for_drawing.acolors[spix_val];
            else
                dpix_val = xcolors[(colors_for_drawing.color_regs_ecs[spix_val - 32] >> 1) & 0x777];
            spix++;
            buf[dpix++] = dpix_val;
        }
        if (dpix >= dpix_end)
            return spix;
        rem = (((uintptr_t)&buf[dpix_end]) & 2);
        if (rem)
            dpix_end--;
        while (dpix < dpix_end) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix];
            if (spix_val <= 31)
                dpix_val = colors_for_drawing.acolors[spix_val];
            else
                dpix_val = xcolors[(colors_for_drawing.color_regs_ecs[spix_val - 32] >> 1) & 0x777];
            spix++;
            out_val = dpix_val;
            spix_val = pixdata.apixels[spix];
            if (spix_val <= 31)
                dpix_val = colors_for_drawing.acolors[spix_val];
            else
                dpix_val = xcolors[(colors_for_drawing.color_regs_ecs[spix_val - 32] >> 1) & 0x777];
            spix++;
            out_val = (out_val & 0xFFFF) | (dpix_val << 16);
            *((uae_u32 *)&buf[dpix]) = out_val;
            dpix += 2;
        }
        if (rem) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            spix_val = pixdata.apixels[spix];
            if (spix_val <= 31)
                dpix_val = colors_for_drawing.acolors[spix_val];
            else
                dpix_val = xcolors[(colors_for_drawing.color_regs_ecs[spix_val - 32] >> 1) & 0x777];
            spix++;
            buf[dpix++] = dpix_val;
        }
    } else {
        int rem;
        if (((uintptr_t)&buf[dpix]) & 2) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            spix_val = pixdata.apixels[spix];
            dpix_val = colors_for_drawing.acolors[spix_val];
            spix++;
            buf[dpix++] = dpix_val;
        }
        if (dpix >= dpix_end)
            return spix;
        rem = (((uintptr_t)&buf[dpix_end]) & 2);
        if (rem)
            dpix_end--;
        while (dpix < dpix_end) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix];
            dpix_val = colors_for_drawing.acolors[spix_val];
            spix++;
            out_val = dpix_val;
            spix_val = pixdata.apixels[spix];
            dpix_val = colors_for_drawing.acolors[spix_val];
            spix++;
            out_val = (out_val & 0xFFFF) | (dpix_val << 16);
            *((uae_u32 *)&buf[dpix]) = out_val;
            dpix += 2;
        }
        if (rem) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            spix_val = pixdata.apixels[spix];
            dpix_val = colors_for_drawing.acolors[spix_val];
            spix++;
            buf[dpix++] = dpix_val;
        }
    }

    return spix;
}

static int NOINLINE __attribute__((__unused__)) linetoscr_16_genlock(int spix, int dpix, int dpix_end)
{
    uae_u16 *buf = (uae_u16 *) xlinebuffer;
    uae_u8 *genlock_buf = xlinebuffer_genlock;

    if (bplham) {
        int rem;
        if (((uintptr_t)&buf[dpix]) & 2) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            spix_val = ham_linebuf[spix];
            dpix_val = xcolors[spix_val];
            spix++;
            buf[dpix++] = dpix_val;
        }
        if (dpix >= dpix_end)
            return spix;
        rem = (((uintptr_t)&buf[dpix_end]) & 2);
        if (rem)
            dpix_end--;
        while (dpix < dpix_end) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = ham_linebuf[spix];
            dpix_val = xcolors[spix_val];
            spix++;
            out_val = dpix_val;
            genlock_buf[dpix] = get_genlock_transparency(spix_val & 15);
            spix_val = ham_linebuf[spix];
            dpix_val = xcolors[spix_val];
            spix++;
            out_val = (out_val & 0xFFFF) | (dpix_val << 16);
            *((uae_u32 *)&buf[dpix]) = out_val;
            dpix += 2;
        }
        if (rem) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            spix_val = ham_linebuf[spix];
            dpix_val = xcolors[spix_val];
            spix++;
            buf[dpix++] = dpix_val;
        }
    } else if (bpldualpf) {
        int *lookup = bpldualpfpri ? dblpf_ind2 : dblpf_ind1;
        int rem;
        if (((uintptr_t)&buf[dpix]) & 2) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            spix_val = pixdata.apixels[spix];
            dpix_val = colors_for_drawing.acolors[lookup[spix_val]];
            spix++;
            buf[dpix++] = dpix_val;
        }
        if (dpix >= dpix_end)
            return spix;
        rem = (((uintptr_t)&buf[dpix_end]) & 2);
        if (rem)
            dpix_end--;
        while (dpix < dpix_end) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix];
            dpix_val = colors_for_drawing.acolors[lookup[spix_val]];
            spix++;
            out_val = dpix_val;
            genlock_buf[dpix] = get_genlock_transparency(lookup[spix_val]);
            spix_val = pixdata.apixels[spix];
            dpix_val = colors_for_drawing.acolors[lookup[spix_val]];
            spix++;
            out_val = (out_val & 0xFFFF) | (dpix_val << 16);
            *((uae_u32 *)&buf[dpix]) = out_val;
            dpix += 2;
        }
        if (rem) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            spix_val = pixdata.apixels[spix];
            dpix_val = colors_for_drawing.acolors[lookup[spix_val]];
            spix++;
            buf[dpix++] = dpix_val;
        }
    } else if (bplehb) {
        int rem;
        if (((uintptr_t)&buf[dpix]) & 2) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            spix_val = pixdata.apixels[spix];
            if (spix_val <= 31)
                dpix_val = colors_for_drawing.acolors[spix_val];
            else
                dpix_val = xcolors[(colors_for_drawing.color_regs_ecs[spix_val - 32] >> 1) & 0x777];
            spix++;
            buf[dpix++] = dpix_val;
        }
        if (dpix >= dpix_end)
            return spix;
        rem = (((uintptr_t)&buf[dpix_end]) & 2);
        if (rem)
            dpix_end--;
        while (dpix < dpix_end) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix];
            if (spix_val <= 31)
                dpix_val = colors_for_drawing.acolors[spix_val];
            else
                dpix_val = xcolors[(colors_for_drawing.color_regs_ecs[spix_val - 32] >> 1) & 0x777];
            spix++;
            out_val = dpix_val;
            genlock_buf[dpix] = get_genlock_transparency(spix_val & 31);
            spix_val = pixdata.apixels[spix];
            if (spix_val <= 31)
                dpix_val = colors_for_drawing.acolors[spix_val];
            else
                dpix_val = xcolors[(colors_for_drawing.color_regs_ecs[spix_val - 32] >> 1) & 0x777];
            spix++;
            out_val = (out_val & 0xFFFF) | (dpix_val << 16);
            *((uae_u32 *)&buf[dpix]) = out_val;
            dpix += 2;
        }
        if (rem) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            spix_val = pixdata.apixels[spix];
            if (spix_val <= 31)
                dpix_val = colors_for_drawing.acolors[spix_val];
            else
                dpix_val = xcolors[(colors_for_drawing.color_regs_ecs[spix_val - 32] >> 1) & 0x777];
            spix++;
            buf[dpix++] = dpix_val;
        }
    } else {
        int rem;
        if (((uintptr_t)&buf[dpix]) & 2) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            spix_val = pixdata.apixels[spix];
            dpix_val = colors_for_drawing.acolors[spix_val];
            spix++;
            buf[dpix++] = dpix_val;
        }
        if (dpix >= dpix_end)
            return spix;
        rem = (((uintptr_t)&buf[dpix_end]) & 2);
        if (rem)
            dpix_end--;
        while (dpix < dpix_end) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix];
            dpix_val = colors_for_drawing.acolors[spix_val];
            spix++;
            out_val = dpix_val;
            genlock_buf[dpix] = get_genlock_transparency(spix_val);
            spix_val = pixdata.apixels[spix];
            dpix_val = colors_for_drawing.acolors[spix_val];
            spix++;
            out_val = (out_val & 0xFFFF) | (dpix_val << 16);
            *((uae_u32 *)&buf[dpix]) = out_val;
            dpix += 2;
        }
        if (rem) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            spix_val = pixdata.apixels[spix];
            dpix_val = colors_for_drawing.acolors[spix_val];
            spix++;
            buf[dpix++] = dpix_val;
        }
    }

    return spix;
}

static int NOINLINE __attribute__((__unused__)) linetoscr_16_stretch1(int spix, int dpix, int dpix_end)
{
    uae_u16 *buf = (uae_u16 *) xlinebuffer;

    if (bplham) {
        while (dpix < dpix_end) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = ham_linebuf[spix];
            dpix_val = xcolors[spix_val];
            spix++;
            out_val = dpix_val;
            *((uae_u32 *)&buf[dpix]) = out_val;
            dpix += 2;
        }
    } else if (bpldualpf) {
        int *lookup = bpldualpfpri ? dblpf_ind2 : dblpf_ind1;
        while (dpix < dpix_end) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix];
            dpix_val = colors_for_drawing.acolors[lookup[spix_val]];
            spix++;
            out_val = dpix_val;
            *((uae_u32 *)&buf[dpix]) = out_val;
            dpix += 2;
        }
    } else if (bplehb) {
        while (dpix < dpix_end) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix];
            if (spix_val <= 31)
                dpix_val = colors_for_drawing.acolors[spix_val];
            else
                dpix_val = xcolors[(colors_for_drawing.color_regs_ecs[spix_val - 32] >> 1) & 0x777];
            spix++;
            out_val = dpix_val;
            *((uae_u32 *)&buf[dpix]) = out_val;
            dpix += 2;
        }
    } else {
        while (dpix < dpix_end) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix];
            dpix_val = colors_for_drawing.acolors[spix_val];
            spix++;
            out_val = dpix_val;
            *((uae_u32 *)&buf[dpix]) = out_val;
            dpix += 2;
        }
    }

    return spix;
}

static int NOINLINE __attribute__((__unused__)) linetoscr_16_stretch1_genlock(int spix, int dpix, int dpix_end)
{
    uae_u16 *buf = (uae_u16 *) xlinebuffer;
    uae_u8 *genlock_buf = xlinebuffer_genlock;

    if (bplham) {
        while (dpix < dpix_end) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = ham_linebuf[spix];
            dpix_val = xcolors[spix_val];
            spix++;
            out_val = dpix_val;
            genlock_buf[dpix] = get_genlock_transparency(spix_val & 15);
            genlock_buf[dpix + 1] = get_genlock_transparency(spix_val & 15);
            *((uae_u32 *)&buf[dpix]) = out_val;
            dpix += 2;
        }
    } else if (bpldualpf) {
        int *lookup = bpldualpfpri ? dblpf_ind2 : dblpf_ind1;
        while (dpix < dpix_end) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix];
            dpix_val = colors_for_drawing.acolors[lookup[spix_val]];
            spix++;
            out_val = dpix_val;
            genlock_buf[dpix] = get_genlock_transparency(lookup[spix_val]);
            genlock_buf[dpix + 1] = get_genlock_transparency(lookup[spix_val]);
            *((uae_u32 *)&buf[dpix]) = out_val;
            dpix += 2;
        }
    } else if (bplehb) {
        while (dpix < dpix_end) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix];
            if (spix_val <= 31)
                dpix_val = colors_for_drawing.acolors[spix_val];
            else
                dpix_val = xcolors[(colors_for_drawing.color_regs_ecs[spix_val - 32] >> 1) & 0x777];
            spix++;
            out_val = dpix_val;
            genlock_buf[dpix] = get_genlock_transparency(spix_val & 31);
            genlock_buf[dpix + 1] = get_genlock_transparency(spix_val & 31);
            *((uae_u32 *)&buf[dpix]) = out_val;
            dpix += 2;
        }
    } else {
        while (dpix < dpix_end) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix];
            dpix_val = colors_for_drawing.acolors[spix_val];
            spix++;
            out_val = dpix_val;
            genlock_buf[dpix] = get_genlock_transparency(spix_val);
            genlock_buf[dpix + 1] = get_genlock_transparency(spix_val);
            *((uae_u32 *)&buf[dpix]) = out_val;
            dpix += 2;
        }
    }

    return spix;
}

static int NOINLINE __attribute__((__unused__)) linetoscr_16_stretch2(int spix, int dpix, int dpix_end)
{
    uae_u16 *buf = (uae_u16 *) xlinebuffer;

    if (bplham) {
        while (dpix < dpix_end) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = ham_linebuf[spix];
            dpix_val = xcolors[spix_val];
            spix++;
            out_val = dpix_val;
            *((uae_u32 *)&buf[dpix]) = out_val;
            dpix += 2;
            *((uae_u32 *)&buf[dpix]) = out_val;
            dpix += 2;
        }
    } else if (bpldualpf) {
        int *lookup = bpldualpfpri ? dblpf_ind2 : dblpf_ind1;
        while (dpix < dpix_end) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix];
            dpix_val = colors_for_drawing.acolors[lookup[spix_val]];
            spix++;
            out_val = dpix_val;
            *((uae_u32 *)&buf[dpix]) = out_val;
            dpix += 2;
            *((uae_u32 *)&buf[dpix]) = out_val;
            dpix += 2;
        }
    } else if (bplehb) {
        while (dpix < dpix_end) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix];
            if (spix_val <= 31)
                dpix_val = colors_for_drawing.acolors[spix_val];
            else
                dpix_val = xcolors[(colors_for_drawing.color_regs_ecs[spix_val - 32] >> 1) & 0x777];
            spix++;
            out_val = dpix_val;
            *((uae_u32 *)&buf[dpix]) = out_val;
            dpix += 2;
            *((uae_u32 *)&buf[dpix]) = out_val;
            dpix += 2;
        }
    } else {
        while (dpix < dpix_end) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix];
            dpix_val = colors_for_drawing.acolors[spix_val];
            spix++;
            out_val = dpix_val;
            *((uae_u32 *)&buf[dpix]) = out_val;
            dpix += 2;
            *((uae_u32 *)&buf[dpix]) = out_val;
            dpix += 2;
        }
    }

    return spix;
}

static int NOINLINE __attribute__((__unused__)) linetoscr_16_stretch2_genlock(int spix, int dpix, int dpix_end)
{
    uae_u16 *buf = (uae_u16 *) xlinebuffer;
    uae_u8 *genlock_buf = xlinebuffer_genlock;

    if (bplham) {
        while (dpix < dpix_end) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = ham_linebuf[spix];
            dpix_val = xcolors[spix_val];
            spix++;
            out_val = dpix_val;
            genlock_buf[dpix] = get_genlock_transparency(spix_val & 15);
            genlock_buf[dpix + 1] = get_genlock_transparency(spix_val & 15);
            genlock_buf[dpix + 2] = get_genlock_transparency(spix_val & 15);
            genlock_buf[dpix + 3] = get_genlock_transparency(spix_val & 15);
            *((uae_u32 *)&buf[dpix]) = out_val;
            dpix += 2;
            *((uae_u32 *)&buf[dpix]) = out_val;
            dpix += 2;
        }
    } else if (bpldualpf) {
        int *lookup = bpldualpfpri ? dblpf_ind2 : dblpf_ind1;
        while (dpix < dpix_end) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix];
            dpix_val = colors_for_drawing.acolors[lookup[spix_val]];
            spix++;
            out_val = dpix_val;
            genlock_buf[dpix] = get_genlock_transparency(lookup[spix_val]);
            genlock_buf[dpix + 1] = get_genlock_transparency(lookup[spix_val]);
            genlock_buf[dpix + 2] = get_genlock_transparency(lookup[spix_val]);
            genlock_buf[dpix + 3] = get_genlock_transparency(lookup[spix_val]);
            *((uae_u32 *)&buf[dpix]) = out_val;
            dpix += 2;
            *((uae_u32 *)&buf[dpix]) = out_val;
            dpix += 2;
        }
    } else if (bplehb) {
        while (dpix < dpix_end) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix];
            if (spix_val <= 31)
                dpix_val = colors_for_drawing.acolors[spix_val];
            else
                dpix_val = xcolors[(colors_for_drawing.color_regs_ecs[spix_val - 32] >> 1) & 0x777];
            spix++;
            out_val = dpix_val;
            genlock_buf[dpix] = get_genlock_transparency(spix_val & 31);
            genlock_buf[dpix + 1] = get_genlock_transparency(spix_val & 31);
            genlock_buf[dpix + 2] = get_genlock_transparency(spix_val & 31);
            genlock_buf[dpix + 3] = get_genlock_transparency(spix_val & 31);
            *((uae_u32 *)&buf[dpix]) = out_val;
            dpix += 2;
            *((uae_u32 *)&buf[dpix]) = out_val;
            dpix += 2;
        }
    } else {
        while (dpix < dpix_end) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix];
            dpix_val = colors_for_drawing.acolors[spix_val];
            spix++;
            out_val = dpix_val;
            genlock_buf[dpix] = get_genlock_transparency(spix_val);
            genlock_buf[dpix + 1] = get_genlock_transparency(spix_val);
            genlock_buf[dpix + 2] = get_genlock_transparency(spix_val);
            genlock_buf[dpix + 3] = get_genlock_transparency(spix_val);
            *((uae_u32 *)&buf[dpix]) = out_val;
            dpix += 2;
            *((uae_u32 *)&buf[dpix]) = out_val;
            dpix += 2;
        }
    }

    return spix;
}

static int NOINLINE __attribute__((__unused__)) linetoscr_16_shrink1(int spix, int dpix, int dpix_end)
{
    uae_u16 *buf = (uae_u16 *) xlinebuffer;

    if (bplham) {
        int rem;
        if (((uintptr_t)&buf[dpix]) & 2) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            spix_val = ham_linebuf[spix];
            dpix_val = xcolors[spix_val];
            spix += 2;
            buf[dpix++] = dpix_val;
        }
        if (dpix >= dpix_end)
            return spix;
        rem = (((uintptr_t)&buf[dpix_end]) & 2);
        if (rem)
            dpix_end--;
        while (dpix < dpix_end) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = ham_linebuf[spix];
            dpix_val = xcolors[spix_val];
            spix += 2;
            out_val = dpix_val;
            spix_val = ham_linebuf[spix];
            dpix_val = xcolors[spix_val];
            spix += 2;
            out_val = (out_val & 0xFFFF) | (dpix_val << 16);
            *((uae_u32 *)&buf[dpix]) = out_val;
            dpix += 2;
        }
        if (rem) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            spix_val = ham_linebuf[spix];
            dpix_val = xcolors[spix_val];
            spix += 2;
            buf[dpix++] = dpix_val;
        }
    } else if (bpldualpf) {
        int *lookup = bpldualpfpri ? dblpf_ind2 : dblpf_ind1;
        int rem;
        if (((uintptr_t)&buf[dpix]) & 2) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            spix_val = pixdata.apixels[spix];
            dpix_val = colors_for_drawing.acolors[lookup[spix_val]];
            spix += 2;
            buf[dpix++] = dpix_val;
        }
        if (dpix >= dpix_end)
            return spix;
        rem = (((uintptr_t)&buf[dpix_end]) & 2);
        if (rem)
            dpix_end--;
        while (dpix < dpix_end) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix];
            dpix_val = colors_for_drawing.acolors[lookup[spix_val]];
            spix += 2;
            out_val = dpix_val;
            spix_val = pixdata.apixels[spix];
            dpix_val = colors_for_drawing.acolors[lookup[spix_val]];
            spix += 2;
            out_val = (out_val & 0xFFFF) | (dpix_val << 16);
            *((uae_u32 *)&buf[dpix]) = out_val;
            dpix += 2;
        }
        if (rem) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            spix_val = pixdata.apixels[spix];
            dpix_val = colors_for_drawing.acolors[lookup[spix_val]];
            spix += 2;
            buf[dpix++] = dpix_val;
        }
    } else if (bplehb) {
        int rem;
        if (((uintptr_t)&buf[dpix]) & 2) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            spix_val = pixdata.apixels[spix];
            if (spix_val <= 31)
                dpix_val = colors_for_drawing.acolors[spix_val];
            else
                dpix_val = xcolors[(colors_for_drawing.color_regs_ecs[spix_val - 32] >> 1) & 0x777];
            spix += 2;
            buf[dpix++] = dpix_val;
        }
        if (dpix >= dpix_end)
            return spix;
        rem = (((uintptr_t)&buf[dpix_end]) & 2);
        if (rem)
            dpix_end--;
        while (dpix < dpix_end) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix];
            if (spix_val <= 31)
                dpix_val = colors_for_drawing.acolors[spix_val];
            else
                dpix_val = xcolors[(colors_for_drawing.color_regs_ecs[spix_val - 32] >> 1) & 0x777];
            spix += 2;
            out_val = dpix_val;
            spix_val = pixdata.apixels[spix];
            if (spix_val <= 31)
                dpix_val = colors_for_drawing.acolors[spix_val];
            else
                dpix_val = xcolors[(colors_for_drawing.color_regs_ecs[spix_val - 32] >> 1) & 0x777];
            spix += 2;
            out_val = (out_val & 0xFFFF) | (dpix_val << 16);
            *((uae_u32 *)&buf[dpix]) = out_val;
            dpix += 2;
        }
        if (rem) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            spix_val = pixdata.apixels[spix];
            if (spix_val <= 31)
                dpix_val = colors_for_drawing.acolors[spix_val];
            else
                dpix_val = xcolors[(colors_for_drawing.color_regs_ecs[spix_val - 32] >> 1) & 0x777];
            spix += 2;
            buf[dpix++] = dpix_val;
        }
    } else {
        int rem;
        if (((uintptr_t)&buf[dpix]) & 2) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            spix_val = pixdata.apixels[spix];
            dpix_val = colors_for_drawing.acolors[spix_val];
            spix += 2;
            buf[dpix++] = dpix_val;
        }
        if (dpix >= dpix_end)
            return spix;
        rem = (((uintptr_t)&buf[dpix_end]) & 2);
        if (rem)
            dpix_end--;
        while (dpix < dpix_end) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix];
            dpix_val = colors_for_drawing.acolors[spix_val];
            spix += 2;
            out_val = dpix_val;
            spix_val = pixdata.apixels[spix];
            dpix_val = colors_for_drawing.acolors[spix_val];
            spix += 2;
            out_val = (out_val & 0xFFFF) | (dpix_val << 16);
            *((uae_u32 *)&buf[dpix]) = out_val;
            dpix += 2;
        }
        if (rem) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            spix_val = pixdata.apixels[spix];
            dpix_val = colors_for_drawing.acolors[spix_val];
            spix += 2;
            buf[dpix++] = dpix_val;
        }
    }

    return spix;
}

static int NOINLINE __attribute__((__unused__)) linetoscr_16_shrink1_genlock(int spix, int dpix, int dpix_end)
{
    uae_u16 *buf = (uae_u16 *) xlinebuffer;
    uae_u8 *genlock_buf = xlinebuffer_genlock;

    if (bplham) {
        int rem;
        if (((uintptr_t)&buf[dpix]) & 2) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            spix_val = ham_linebuf[spix];
            dpix_val = xcolors[spix_val];
            spix += 2;
            buf[dpix++] = dpix_val;
        }
        if (dpix >= dpix_end)
            return spix;
        rem = (((uintptr_t)&buf[dpix_end]) & 2);
        if (rem)
            dpix_end--;
        while (dpix < dpix_end) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = ham_linebuf[spix];
            dpix_val = xcolors[spix_val];
            spix += 2;
            out_val = dpix_val;
            genlock_buf[dpix] = get_genlock_transparency(spix_val & 15);
            spix_val = ham_linebuf[spix];
            dpix_val = xcolors[spix_val];
            spix += 2;
            out_val = (out_val & 0xFFFF) | (dpix_val << 16);
            *((uae_u32 *)&buf[dpix]) = out_val;
            dpix += 2;
        }
        if (rem) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            spix_val = ham_linebuf[spix];
            dpix_val = xcolors[spix_val];
            spix += 2;
            buf[dpix++] = dpix_val;
        }
    } else if (bpldualpf) {
        int *lookup = bpldualpfpri ? dblpf_ind2 : dblpf_ind1;
        int rem;
        if (((uintptr_t)&buf[dpix]) & 2) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            spix_val = pixdata.apixels[spix];
            dpix_val = colors_for_drawing.acolors[lookup[spix_val]];
            spix += 2;
            buf[dpix++] = dpix_val;
        }
        if (dpix >= dpix_end)
            return spix;
        rem = (((uintptr_t)&buf[dpix_end]) & 2);
        if (rem)
            dpix_end--;
        while (dpix < dpix_end) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix];
            dpix_val = colors_for_drawing.acolors[lookup[spix_val]];
            spix += 2;
            out_val = dpix_val;
            genlock_buf[dpix] = get_genlock_transparency(lookup[spix_val]);
            spix_val = pixdata.apixels[spix];
            dpix_val = colors_for_drawing.acolors[lookup[spix_val]];
            spix += 2;
            out_val = (out_val & 0xFFFF) | (dpix_val << 16);
            *((uae_u32 *)&buf[dpix]) = out_val;
            dpix += 2;
        }
        if (rem) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            spix_val = pixdata.apixels[spix];
            dpix_val = colors_for_drawing.acolors[lookup[spix_val]];
            spix += 2;
            buf[dpix++] = dpix_val;
        }
    } else if (bplehb) {
        int rem;
        if (((uintptr_t)&buf[dpix]) & 2) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            spix_val = pixdata.apixels[spix];
            if (spix_val <= 31)
                dpix_val = colors_for_drawing.acolors[spix_val];
            else
                dpix_val = xcolors[(colors_for_drawing.color_regs_ecs[spix_val - 32] >> 1) & 0x777];
            spix += 2;
            buf[dpix++] = dpix_val;
        }
        if (dpix >= dpix_end)
            return spix;
        rem = (((uintptr_t)&buf[dpix_end]) & 2);
        if (rem)
            dpix_end--;
        while (dpix < dpix_end) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix];
            if (spix_val <= 31)
                dpix_val = colors_for_drawing.acolors[spix_val];
            else
                dpix_val = xcolors[(colors_for_drawing.color_regs_ecs[spix_val - 32] >> 1) & 0x777];
            spix += 2;
            out_val = dpix_val;
            genlock_buf[dpix] = get_genlock_transparency(spix_val & 31);
            spix_val = pixdata.apixels[spix];
            if (spix_val <= 31)
                dpix_val = colors_for_drawing.acolors[spix_val];
            else
                dpix_val = xcolors[(colors_for_drawing.color_regs_ecs[spix_val - 32] >> 1) & 0x777];
            spix += 2;
            out_val = (out_val & 0xFFFF) | (dpix_val << 16);
            *((uae_u32 *)&buf[dpix]) = out_val;
            dpix += 2;
        }
        if (rem) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            spix_val = pixdata.apixels[spix];
            if (spix_val <= 31)
                dpix_val = colors_for_drawing.acolors[spix_val];
            else
                dpix_val = xcolors[(colors_for_drawing.color_regs_ecs[spix_val - 32] >> 1) & 0x777];
            spix += 2;
            buf[dpix++] = dpix_val;
        }
    } else {
        int rem;
        if (((uintptr_t)&buf[dpix]) & 2) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            spix_val = pixdata.apixels[spix];
            dpix_val = colors_for_drawing.acolors[spix_val];
            spix += 2;
            buf[dpix++] = dpix_val;
        }
        if (dpix >= dpix_end)
            return spix;
        rem = (((uintptr_t)&buf[dpix_end]) & 2);
        if (rem)
            dpix_end--;
        while (dpix < dpix_end) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix];
            dpix_val = colors_for_drawing.acolors[spix_val];
            spix += 2;
            out_val = dpix_val;
            genlock_buf[dpix] = get_genlock_transparency(spix_val);
            spix_val = pixdata.apixels[spix];
            dpix_val = colors_for_drawing.acolors[spix_val];
            spix += 2;
            out_val = (out_val & 0xFFFF) | (dpix_val << 16);
            *((uae_u32 *)&buf[dpix]) = out_val;
            dpix += 2;
        }
        if (rem) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            spix_val = pixdata.apixels[spix];
            dpix_val = colors_for_drawing.acolors[spix_val];
            spix += 2;
            buf[dpix++] = dpix_val;
        }
    }

    return spix;
}

static int NOINLINE __attribute__((__unused__)) linetoscr_16_shrink1f(int spix, int dpix, int dpix_end)
{
    uae_u16 *buf = (uae_u16 *) xlinebuffer;

    if (bplham) {
        int rem;
        if (((uintptr_t)&buf[dpix]) & 2) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            spix_val = ham_linebuf[spix];
            dpix_val = xcolors[spix_val];
            {
            uae_u32 tmp_val;
            spix++;
            tmp_val = dpix_val;
            spix_val = ham_linebuf[spix];
            dpix_val = xcolors[spix_val];
            dpix_val = merge_2pixel16 (dpix_val, tmp_val);
            spix++;
            }
            buf[dpix++] = dpix_val;
        }
        if (dpix >= dpix_end)
            return spix;
        rem = (((uintptr_t)&buf[dpix_end]) & 2);
        if (rem)
            dpix_end--;
        while (dpix < dpix_end) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = ham_linebuf[spix];
            dpix_val = xcolors[spix_val];
            {
            uae_u32 tmp_val;
            spix++;
            tmp_val = dpix_val;
            spix_val = ham_linebuf[spix];
            dpix_val = xcolors[spix_val];
            dpix_val = merge_2pixel16 (dpix_val, tmp_val);
            spix++;
            }
            out_val = dpix_val;
            spix_val = ham_linebuf[spix];
            dpix_val = xcolors[spix_val];
            {
            uae_u32 tmp_val;
            spix++;
            tmp_val = dpix_val;
            spix_val = ham_linebuf[spix];
            dpix_val = xcolors[spix_val];
            dpix_val = merge_2pixel16 (dpix_val, tmp_val);
            spix++;
            }
            out_val = (out_val & 0xFFFF) | (dpix_val << 16);
            *((uae_u32 *)&buf[dpix]) = out_val;
            dpix += 2;
        }
        if (rem) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            spix_val = ham_linebuf[spix];
            dpix_val = xcolors[spix_val];
            {
            uae_u32 tmp_val;
            spix++;
            tmp_val = dpix_val;
            spix_val = ham_linebuf[spix];
            dpix_val = xcolors[spix_val];
            dpix_val = merge_2pixel16 (dpix_val, tmp_val);
            spix++;
            }
            buf[dpix++] = dpix_val;
        }
    } else if (bpldualpf) {
        int *lookup = bpldualpfpri ? dblpf_ind2 : dblpf_ind1;
        int rem;
        if (((uintptr_t)&buf[dpix]) & 2) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            spix_val = pixdata.apixels[spix];
            dpix_val = colors_for_drawing.acolors[lookup[spix_val]];
            {
            uae_u32 tmp_val;
            spix++;
            tmp_val = dpix_val;
            spix_val = pixdata.apixels[spix];
            dpix_val = colors_for_drawing.acolors[lookup[spix_val]];
            dpix_val = merge_2pixel16 (dpix_val, tmp_val);
            spix++;
            }
            buf[dpix++] = dpix_val;
        }
        if (dpix >= dpix_end)
            return spix;
        rem = (((uintptr_t)&buf[dpix_end]) & 2);
        if (rem)
            dpix_end--;
        while (dpix < dpix_end) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix];
            dpix_val = colors_for_drawing.acolors[lookup[spix_val]];
            {
            uae_u32 tmp_val;
            spix++;
            tmp_val = dpix_val;
            spix_val = pixdata.apixels[spix];
            dpix_val = colors_for_drawing.acolors[lookup[spix_val]];
            dpix_val = merge_2pixel16 (dpix_val, tmp_val);
            spix++;
            }
            out_val = dpix_val;
            spix_val = pixdata.apixels[spix];
            dpix_val = colors_for_drawing.acolors[lookup[spix_val]];
            {
            uae_u32 tmp_val;
            spix++;
            tmp_val = dpix_val;
            spix_val = pixdata.apixels[spix];
            dpix_val = colors_for_drawing.acolors[lookup[spix_val]];
            dpix_val = merge_2pixel16 (dpix_val, tmp_val);
            spix++;
            }
            out_val = (out_val & 0xFFFF) | (dpix_val << 16);
            *((uae_u32 *)&buf[dpix]) = out_val;
            dpix += 2;
        }
        if (rem) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            spix_val = pixdata.apixels[spix];
            dpix_val = colors_for_drawing.acolors[lookup[spix_val]];
            {
            uae_u32 tmp_val;
            spix++;
            tmp_val = dpix_val;
            spix_val = pixdata.apixels[spix];
            dpix_val = colors_for_drawing.acolors[lookup[spix_val]];
            dpix_val = merge_2pixel16 (dpix_val, tmp_val);
            spix++;
            }
            buf[dpix++] = dpix_val;
        }
    } else if (bplehb) {
        int rem;
        if (((uintptr_t)&buf[dpix]) & 2) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            spix_val = pixdata.apixels[spix];
            if (spix_val <= 31)
                dpix_val = colors_for_drawing.acolors[spix_val];
            else
                dpix_val = xcolors[(colors_for_drawing.color_regs_ecs[spix_val - 32] >> 1) & 0x777];
            {
            uae_u32 tmp_val;
            spix++;
            tmp_val = dpix_val;
            spix_val = pixdata.apixels[spix];
            if (spix_val <= 31)
                dpix_val = colors_for_drawing.acolors[spix_val];
            else
                dpix_val = xcolors[(colors_for_drawing.color_regs_ecs[spix_val - 32] >> 1) & 0x777];
            dpix_val = merge_2pixel16 (dpix_val, tmp_val);
            spix++;
            }
            buf[dpix++] = dpix_val;
        }
        if (dpix >= dpix_end)
            return spix;
        rem = (((uintptr_t)&buf[dpix_end]) & 2);
        if (rem)
            dpix_end--;
        while (dpix < dpix_end) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix];
            if (spix_val <= 31)
                dpix_val = colors_for_drawing.acolors[spix_val];
            else
                dpix_val = xcolors[(colors_for_drawing.color_regs_ecs[spix_val - 32] >> 1) & 0x777];
            {
            uae_u32 tmp_val;
            spix++;
            tmp_val = dpix_val;
            spix_val = pixdata.apixels[spix];
            if (spix_val <= 31)
                dpix_val = colors_for_drawing.acolors[spix_val];
            else
                dpix_val = xcolors[(colors_for_drawing.color_regs_ecs[spix_val - 32] >> 1) & 0x777];
            dpix_val = merge_2pixel16 (dpix_val, tmp_val);
            spix++;
            }
            out_val = dpix_val;
            spix_val = pixdata.apixels[spix];
            if (spix_val <= 31)
                dpix_val = colors_for_drawing.acolors[spix_val];
            else
                dpix_val = xcolors[(colors_for_drawing.color_regs_ecs[spix_val - 32] >> 1) & 0x777];
            {
            uae_u32 tmp_val;
            spix++;
            tmp_val = dpix_val;
            spix_val = pixdata.apixels[spix];
            if (spix_val <= 31)
                dpix_val = colors_for_drawing.acolors[spix_val];
            else
                dpix_val = xcolors[(colors_for_drawing.color_regs_ecs[spix_val - 32] >> 1) & 0x777];
            dpix_val = merge_2pixel16 (dpix_val, tmp_val);
            spix++;
            }
            out_val = (out_val & 0xFFFF) | (dpix_val << 16);
            *((uae_u32 *)&buf[dpix]) = out_val;
            dpix += 2;
        }
        if (rem) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            spix_val = pixdata.apixels[spix];
            if (spix_val <= 31)
                dpix_val = colors_for_drawing.acolors[spix_val];
            else
                dpix_val = xcolors[(colors_for_drawing.color_regs_ecs[spix_val - 32] >> 1) & 0x777];
            {
            uae_u32 tmp_val;
            spix++;
            tmp_val = dpix_val;
            spix_val = pixdata.apixels[spix];
            if (spix_val <= 31)
                dpix_val = colors_for_drawing.acolors[spix_val];
            else
                dpix_val = xcolors[(colors_for_drawing.color_regs_ecs[spix_val - 32] >> 1) & 0x777];
            dpix_val = merge_2pixel16 (dpix_val, tmp_val);
            spix++;
            }
            buf[dpix++] = dpix_val;
        }
    } else {
        int rem;
        if (((uintptr_t)&buf[dpix]) & 2) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            spix_val = pixdata.apixels[spix];
            dpix_val = colors_for_drawing.acolors[spix_val];
            {
            uae_u32 tmp_val;
            spix++;
            tmp_val = dpix_val;
            spix_val = pixdata.apixels[spix];
            dpix_val = colors_for_drawing.acolors[spix_val];
            dpix_val = merge_2pixel16 (dpix_val, tmp_val);
            spix++;
            }
            buf[dpix++] = dpix_val;
        }
        if (dpix >= dpix_end)
            return spix;
        rem = (((uintptr_t)&buf[dpix_end]) & 2);
        if (rem)
            dpix_end--;
        while (dpix < dpix_end) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix];
            dpix_val = colors_for_drawing.acolors[spix_val];
            {
            uae_u32 tmp_val;
            spix++;
            tmp_val = dpix_val;
            spix_val = pixdata.apixels[spix];
            dpix_val = colors_for_drawing.acolors[spix_val];
            dpix_val = merge_2pixel16 (dpix_val, tmp_val);
            spix++;
            }
            out_val = dpix_val;
            spix_val = pixdata.apixels[spix];
            dpix_val = colors_for_drawing.acolors[spix_val];
            {
            uae_u32 tmp_val;
            spix++;
            tmp_val = dpix_val;
            spix_val = pixdata.apixels[spix];
            dpix_val = colors_for_drawing.acolors[spix_val];
            dpix_val = merge_2pixel16 (dpix_val, tmp_val);
            spix++;
            }
            out_val = (out_val & 0xFFFF) | (dpix_val << 16);
            *((uae_u32 *)&buf[dpix]) = out_val;
            dpix += 2;
        }
        if (rem) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            spix_val = pixdata.apixels[spix];
            dpix_val = colors_for_drawing.acolors[spix_val];
            {
            uae_u32 tmp_val;
            spix++;
            tmp_val = dpix_val;
            spix_val = pixdata.apixels[spix];
            dpix_val = colors_for_drawing.acolors[spix_val];
            dpix_val = merge_2pixel16 (dpix_val, tmp_val);
            spix++;
            }
            buf[dpix++] = dpix_val;
        }
    }

    return spix;
}

static int NOINLINE __attribute__((__unused__)) linetoscr_16_shrink1f_genlock(int spix, int dpix, int dpix_end)
{
    uae_u16 *buf = (uae_u16 *) xlinebuffer;
    uae_u8 *genlock_buf = xlinebuffer_genlock;

    if (bplham) {
        int rem;
        if (((uintptr_t)&buf[dpix]) & 2) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            spix_val = ham_linebuf[spix];
            dpix_val = xcolors[spix_val];
            {
            uae_u32 tmp_val;
            spix++;
            tmp_val = dpix_val;
            spix_val = ham_linebuf[spix];
            dpix_val = xcolors[spix_val];
            dpix_val = merge_2pixel16 (dpix_val, tmp_val);
            spix++;
            }
            buf[dpix++] = dpix_val;
        }
        if (dpix >= dpix_end)
            return spix;
        rem = (((uintptr_t)&buf[dpix_end]) & 2);
        if (rem)
            dpix_end--;
        while (dpix < dpix_end) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = ham_linebuf[spix];
            dpix_val = xcolors[spix_val];
            {
            uae_u32 tmp_val;
            spix++;
            tmp_val = dpix_val;
            spix_val = ham_linebuf[spix];
            dpix_val = xcolors[spix_val];
            dpix_val = merge_2pixel16 (dpix_val, tmp_val);
            spix++;
            }
            out_val = dpix_val;
            genlock_buf[dpix] = get_genlock_transparency(spix_val & 15);
            spix_val = ham_linebuf[spix];
            dpix_val = xcolors[spix_val];
            {
            uae_u32 tmp_val;
            spix++;
            tmp_val = dpix_val;
            spix_val = ham_linebuf[spix];
            dpix_val = xcolors[spix_val];
            dpix_val = merge_2pixel16 (dpix_val, tmp_val);
            spix++;
            }
            out_val = (out_val & 0xFFFF) | (dpix_val << 16);
            *((uae_u32 *)&buf[dpix]) = out_val;
            dpix += 2;
        }
        if (rem) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            spix_val = ham_linebuf[spix];
            dpix_val = xcolors[spix_val];
            {
            uae_u32 tmp_val;
            spix++;
            tmp_val = dpix_val;
            spix_val = ham_linebuf[spix];
            dpix_val = xcolors[spix_val];
            dpix_val = merge_2pixel16 (dpix_val, tmp_val);
            spix++;
            }
            buf[dpix++] = dpix_val;
        }
    } else if (bpldualpf) {
        int *lookup = bpldualpfpri ? dblpf_ind2 : dblpf_ind1;
        int rem;
        if (((uintptr_t)&buf[dpix]) & 2) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            spix_val = pixdata.apixels[spix];
            dpix_val = colors_for_drawing.acolors[lookup[spix_val]];
            {
            uae_u32 tmp_val;
            spix++;
            tmp_val = dpix_val;
            spix_val = pixdata.apixels[spix];
            dpix_val = colors_for_drawing.acolors[lookup[spix_val]];
            dpix_val = merge_2pixel16 (dpix_val, tmp_val);
            spix++;
            }
            buf[dpix++] = dpix_val;
        }
        if (dpix >= dpix_end)
            return spix;
        rem = (((uintptr_t)&buf[dpix_end]) & 2);
        if (rem)
            dpix_end--;
        while (dpix < dpix_end) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix];
            dpix_val = colors_for_drawing.acolors[lookup[spix_val]];
            {
            uae_u32 tmp_val;
            spix++;
            tmp_val = dpix_val;
            spix_val = pixdata.apixels[spix];
            dpix_val = colors_for_drawing.acolors[lookup[spix_val]];
            dpix_val = merge_2pixel16 (dpix_val, tmp_val);
            spix++;
            }
            out_val = dpix_val;
            genlock_buf[dpix] = get_genlock_transparency(lookup[spix_val]);
            spix_val = pixdata.apixels[spix];
            dpix_val = colors_for_drawing.acolors[lookup[spix_val]];
            {
            uae_u32 tmp_val;
            spix++;
            tmp_val = dpix_val;
            spix_val = pixdata.apixels[spix];
            dpix_val = colors_for_drawing.acolors[lookup[spix_val]];
            dpix_val = merge_2pixel16 (dpix_val, tmp_val);
            spix++;
            }
            out_val = (out_val & 0xFFFF) | (dpix_val << 16);
            *((uae_u32 *)&buf[dpix]) = out_val;
            dpix += 2;
        }
        if (rem) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            spix_val = pixdata.apixels[spix];
            dpix_val = colors_for_drawing.acolors[lookup[spix_val]];
            {
            uae_u32 tmp_val;
            spix++;
            tmp_val = dpix_val;
            spix_val = pixdata.apixels[spix];
            dpix_val = colors_for_drawing.acolors[lookup[spix_val]];
            dpix_val = merge_2pixel16 (dpix_val, tmp_val);
            spix++;
            }
            buf[dpix++] = dpix_val;
        }
    } else if (bplehb) {
        int rem;
        if (((uintptr_t)&buf[dpix]) & 2) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            spix_val = pixdata.apixels[spix];
            if (spix_val <= 31)
                dpix_val = colors_for_drawing.acolors[spix_val];
            else
                dpix_val = xcolors[(colors_for_drawing.color_regs_ecs[spix_val - 32] >> 1) & 0x777];
            {
            uae_u32 tmp_val;
            spix++;
            tmp_val = dpix_val;
            spix_val = pixdata.apixels[spix];
            if (spix_val <= 31)
                dpix_val = colors_for_drawing.acolors[spix_val];
            else
                dpix_val = xcolors[(colors_for_drawing.color_regs_ecs[spix_val - 32] >> 1) & 0x777];
            dpix_val = merge_2pixel16 (dpix_val, tmp_val);
            spix++;
            }
            buf[dpix++] = dpix_val;
        }
        if (dpix >= dpix_end)
            return spix;
        rem = (((uintptr_t)&buf[dpix_end]) & 2);
        if (rem)
            dpix_end--;
        while (dpix < dpix_end) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix];
            if (spix_val <= 31)
                dpix_val = colors_for_drawing.acolors[spix_val];
            else
                dpix_val = xcolors[(colors_for_drawing.color_regs_ecs[spix_val - 32] >> 1) & 0x777];
            {
            uae_u32 tmp_val;
            spix++;
            tmp_val = dpix_val;
            spix_val = pixdata.apixels[spix];
            if (spix_val <= 31)
                dpix_val = colors_for_drawing.acolors[spix_val];
            else
                dpix_val = xcolors[(colors_for_drawing.color_regs_ecs[spix_val - 32] >> 1) & 0x777];
            dpix_val = merge_2pixel16 (dpix_val, tmp_val);
            spix++;
            }
            out_val = dpix_val;
            genlock_buf[dpix] = get_genlock_transparency(spix_val & 31);
            spix_val = pixdata.apixels[spix];
            if (spix_val <= 31)
                dpix_val = colors_for_drawing.acolors[spix_val];
            else
                dpix_val = xcolors[(colors_for_drawing.color_regs_ecs[spix_val - 32] >> 1) & 0x777];
            {
            uae_u32 tmp_val;
            spix++;
            tmp_val = dpix_val;
            spix_val = pixdata.apixels[spix];
            if (spix_val <= 31)
                dpix_val = colors_for_drawing.acolors[spix_val];
            else
                dpix_val = xcolors[(colors_for_drawing.color_regs_ecs[spix_val - 32] >> 1) & 0x777];
            dpix_val = merge_2pixel16 (dpix_val, tmp_val);
            spix++;
            }
            out_val = (out_val & 0xFFFF) | (dpix_val << 16);
            *((uae_u32 *)&buf[dpix]) = out_val;
            dpix += 2;
        }
        if (rem) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            spix_val = pixdata.apixels[spix];
            if (spix_val <= 31)
                dpix_val = colors_for_drawing.acolors[spix_val];
            else
                dpix_val = xcolors[(colors_for_drawing.color_regs_ecs[spix_val - 32] >> 1) & 0x777];
            {
            uae_u32 tmp_val;
            spix++;
            tmp_val = dpix_val;
            spix_val = pixdata.apixels[spix];
            if (spix_val <= 31)
                dpix_val = colors_for_drawing.acolors[spix_val];
            else
                dpix_val = xcolors[(colors_for_drawing.color_regs_ecs[spix_val - 32] >> 1) & 0x777];
            dpix_val = merge_2pixel16 (dpix_val, tmp_val);
            spix++;
            }
            buf[dpix++] = dpix_val;
        }
    } else {
        int rem;
        if (((uintptr_t)&buf[dpix]) & 2) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            spix_val = pixdata.apixels[spix];
            dpix_val = colors_for_drawing.acolors[spix_val];
            {
            uae_u32 tmp_val;
            spix++;
            tmp_val = dpix_val;
            spix_val = pixdata.apixels[spix];
            dpix_val = colors_for_drawing.acolors[spix_val];
            dpix_val = merge_2pixel16 (dpix_val, tmp_val);
            spix++;
            }
            buf[dpix++] = dpix_val;
        }
        if (dpix >= dpix_end)
            return spix;
        rem = (((uintptr_t)&buf[dpix_end]) & 2);
        if (rem)
            dpix_end--;
        while (dpix < dpix_end) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix];
            dpix_val = colors_for_drawing.acolors[spix_val];
            {
            uae_u32 tmp_val;
            spix++;
            tmp_val = dpix_val;
            spix_val = pixdata.apixels[spix];
            dpix_val = colors_for_drawing.acolors[spix_val];
            dpix_val = merge_2pixel16 (dpix_val, tmp_val);
            spix++;
            }
            out_val = dpix_val;
            genlock_buf[dpix] = get_genlock_transparency(spix_val);
            spix_val = pixdata.apixels[spix];
            dpix_val = colors_for_drawing.acolors[spix_val];
            {
            uae_u32 tmp_val;
            spix++;
            tmp_val = dpix_val;
            spix_val = pixdata.apixels[spix];
            dpix_val = colors_for_drawing.acolors[spix_val];
            dpix_val = merge_2pixel16 (dpix_val, tmp_val);
            spix++;
            }
            out_val = (out_val & 0xFFFF) | (dpix_val << 16);
            *((uae_u32 *)&buf[dpix]) = out_val;
            dpix += 2;
        }
        if (rem) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            spix_val = pixdata.apixels[spix];
            dpix_val = colors_for_drawing.acolors[spix_val];
            {
            uae_u32 tmp_val;
            spix++;
            tmp_val = dpix_val;
            spix_val = pixdata.apixels[spix];
            dpix_val = colors_for_drawing.acolors[spix_val];
            dpix_val = merge_2pixel16 (dpix_val, tmp_val);
            spix++;
            }
            buf[dpix++] = dpix_val;
        }
    }

    return spix;
}

static int NOINLINE __attribute__((__unused__)) linetoscr_16_shrink2(int spix, int dpix, int dpix_end)
{
    uae_u16 *buf = (uae_u16 *) xlinebuffer;

    if (bplham) {
        int rem;
        if (((uintptr_t)&buf[dpix]) & 2) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            spix_val = ham_linebuf[spix];
            dpix_val = xcolors[spix_val];
            spix += 4;
            buf[dpix++] = dpix_val;
        }
        if (dpix >= dpix_end)
            return spix;
        rem = (((uintptr_t)&buf[dpix_end]) & 2);
        if (rem)
            dpix_end--;
        while (dpix < dpix_end) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = ham_linebuf[spix];
            dpix_val = xcolors[spix_val];
            spix += 4;
            out_val = dpix_val;
            spix_val = ham_linebuf[spix];
            dpix_val = xcolors[spix_val];
            spix += 4;
            out_val = (out_val & 0xFFFF) | (dpix_val << 16);
            *((uae_u32 *)&buf[dpix]) = out_val;
            dpix += 2;
        }
        if (rem) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            spix_val = ham_linebuf[spix];
            dpix_val = xcolors[spix_val];
            spix += 4;
            buf[dpix++] = dpix_val;
        }
    } else if (bpldualpf) {
        int *lookup = bpldualpfpri ? dblpf_ind2 : dblpf_ind1;
        int rem;
        if (((uintptr_t)&buf[dpix]) & 2) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            spix_val = pixdata.apixels[spix];
            dpix_val = colors_for_drawing.acolors[lookup[spix_val]];
            spix += 4;
            buf[dpix++] = dpix_val;
        }
        if (dpix >= dpix_end)
            return spix;
        rem = (((uintptr_t)&buf[dpix_end]) & 2);
        if (rem)
            dpix_end--;
        while (dpix < dpix_end) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix];
            dpix_val = colors_for_drawing.acolors[lookup[spix_val]];
            spix += 4;
            out_val = dpix_val;
            spix_val = pixdata.apixels[spix];
            dpix_val = colors_for_drawing.acolors[lookup[spix_val]];
            spix += 4;
            out_val = (out_val & 0xFFFF) | (dpix_val << 16);
            *((uae_u32 *)&buf[dpix]) = out_val;
            dpix += 2;
        }
        if (rem) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            spix_val = pixdata.apixels[spix];
            dpix_val = colors_for_drawing.acolors[lookup[spix_val]];
            spix += 4;
            buf[dpix++] = dpix_val;
        }
    } else if (bplehb) {
        int rem;
        if (((uintptr_t)&buf[dpix]) & 2) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            spix_val = pixdata.apixels[spix];
            if (spix_val <= 31)
                dpix_val = colors_for_drawing.acolors[spix_val];
            else
                dpix_val = xcolors[(colors_for_drawing.color_regs_ecs[spix_val - 32] >> 1) & 0x777];
            spix += 4;
            buf[dpix++] = dpix_val;
        }
        if (dpix >= dpix_end)
            return spix;
        rem = (((uintptr_t)&buf[dpix_end]) & 2);
        if (rem)
            dpix_end--;
        while (dpix < dpix_end) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix];
            if (spix_val <= 31)
                dpix_val = colors_for_drawing.acolors[spix_val];
            else
                dpix_val = xcolors[(colors_for_drawing.color_regs_ecs[spix_val - 32] >> 1) & 0x777];
            spix += 4;
            out_val = dpix_val;
            spix_val = pixdata.apixels[spix];
            if (spix_val <= 31)
                dpix_val = colors_for_drawing.acolors[spix_val];
            else
                dpix_val = xcolors[(colors_for_drawing.color_regs_ecs[spix_val - 32] >> 1) & 0x777];
            spix += 4;
            out_val = (out_val & 0xFFFF) | (dpix_val << 16);
            *((uae_u32 *)&buf[dpix]) = out_val;
            dpix += 2;
        }
        if (rem) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            spix_val = pixdata.apixels[spix];
            if (spix_val <= 31)
                dpix_val = colors_for_drawing.acolors[spix_val];
            else
                dpix_val = xcolors[(colors_for_drawing.color_regs_ecs[spix_val - 32] >> 1) & 0x777];
            spix += 4;
            buf[dpix++] = dpix_val;
        }
    } else {
        int rem;
        if (((uintptr_t)&buf[dpix]) & 2) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            spix_val = pixdata.apixels[spix];
            dpix_val = colors_for_drawing.acolors[spix_val];
            spix += 4;
            buf[dpix++] = dpix_val;
        }
        if (dpix >= dpix_end)
            return spix;
        rem = (((uintptr_t)&buf[dpix_end]) & 2);
        if (rem)
            dpix_end--;
        while (dpix < dpix_end) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix];
            dpix_val = colors_for_drawing.acolors[spix_val];
            spix += 4;
            out_val = dpix_val;
            spix_val = pixdata.apixels[spix];
            dpix_val = colors_for_drawing.acolors[spix_val];
            spix += 4;
            out_val = (out_val & 0xFFFF) | (dpix_val << 16);
            *((uae_u32 *)&buf[dpix]) = out_val;
            dpix += 2;
        }
        if (rem) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            spix_val = pixdata.apixels[spix];
            dpix_val = colors_for_drawing.acolors[spix_val];
            spix += 4;
            buf[dpix++] = dpix_val;
        }
    }

    return spix;
}

static int NOINLINE __attribute__((__unused__)) linetoscr_16_shrink2_genlock(int spix, int dpix, int dpix_end)
{
    uae_u16 *buf = (uae_u16 *) xlinebuffer;
    uae_u8 *genlock_buf = xlinebuffer_genlock;

    if (bplham) {
        int rem;
        if (((uintptr_t)&buf[dpix]) & 2) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            spix_val = ham_linebuf[spix];
            dpix_val = xcolors[spix_val];
            spix += 4;
            buf[dpix++] = dpix_val;
        }
        if (dpix >= dpix_end)
            return spix;
        rem = (((uintptr_t)&buf[dpix_end]) & 2);
        if (rem)
            dpix_end--;
        while (dpix < dpix_end) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = ham_linebuf[spix];
            dpix_val = xcolors[spix_val];
            spix += 4;
            out_val = dpix_val;
            genlock_buf[dpix] = get_genlock_transparency(spix_val & 15);
            spix_val = ham_linebuf[spix];
            dpix_val = xcolors[spix_val];
            spix += 4;
            out_val = (out_val & 0xFFFF) | (dpix_val << 16);
            *((uae_u32 *)&buf[dpix]) = out_val;
            dpix += 2;
        }
        if (rem) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            spix_val = ham_linebuf[spix];
            dpix_val = xcolors[spix_val];
            spix += 4;
            buf[dpix++] = dpix_val;
        }
    } else if (bpldualpf) {
        int *lookup = bpldualpfpri ? dblpf_ind2 : dblpf_ind1;
        int rem;
        if (((uintptr_t)&buf[dpix]) & 2) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            spix_val = pixdata.apixels[spix];
            dpix_val = colors_for_drawing.acolors[lookup[spix_val]];
            spix += 4;
            buf[dpix++] = dpix_val;
        }
        if (dpix >= dpix_end)
            return spix;
        rem = (((uintptr_t)&buf[dpix_end]) & 2);
        if (rem)
            dpix_end--;
        while (dpix < dpix_end) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix];
            dpix_val = colors_for_drawing.acolors[lookup[spix_val]];
            spix += 4;
            out_val = dpix_val;
            genlock_buf[dpix] = get_genlock_transparency(lookup[spix_val]);
            spix_val = pixdata.apixels[spix];
            dpix_val = colors_for_drawing.acolors[lookup[spix_val]];
            spix += 4;
            out_val = (out_val & 0xFFFF) | (dpix_val << 16);
            *((uae_u32 *)&buf[dpix]) = out_val;
            dpix += 2;
        }
        if (rem) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            spix_val = pixdata.apixels[spix];
            dpix_val = colors_for_drawing.acolors[lookup[spix_val]];
            spix += 4;
            buf[dpix++] = dpix_val;
        }
    } else if (bplehb) {
        int rem;
        if (((uintptr_t)&buf[dpix]) & 2) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            spix_val = pixdata.apixels[spix];
            if (spix_val <= 31)
                dpix_val = colors_for_drawing.acolors[spix_val];
            else
                dpix_val = xcolors[(colors_for_drawing.color_regs_ecs[spix_val - 32] >> 1) & 0x777];
            spix += 4;
            buf[dpix++] = dpix_val;
        }
        if (dpix >= dpix_end)
            return spix;
        rem = (((uintptr_t)&buf[dpix_end]) & 2);
        if (rem)
            dpix_end--;
        while (dpix < dpix_end) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix];
            if (spix_val <= 31)
                dpix_val = colors_for_drawing.acolors[spix_val];
            else
                dpix_val = xcolors[(colors_for_drawing.color_regs_ecs[spix_val - 32] >> 1) & 0x777];
            spix += 4;
            out_val = dpix_val;
            genlock_buf[dpix] = get_genlock_transparency(spix_val & 31);
            spix_val = pixdata.apixels[spix];
            if (spix_val <= 31)
                dpix_val = colors_for_drawing.acolors[spix_val];
            else
                dpix_val = xcolors[(colors_for_drawing.color_regs_ecs[spix_val - 32] >> 1) & 0x777];
            spix += 4;
            out_val = (out_val & 0xFFFF) | (dpix_val << 16);
            *((uae_u32 *)&buf[dpix]) = out_val;
            dpix += 2;
        }
        if (rem) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            spix_val = pixdata.apixels[spix];
            if (spix_val <= 31)
                dpix_val = colors_for_drawing.acolors[spix_val];
            else
                dpix_val = xcolors[(colors_for_drawing.color_regs_ecs[spix_val - 32] >> 1) & 0x777];
            spix += 4;
            buf[dpix++] = dpix_val;
        }
    } else {
        int rem;
        if (((uintptr_t)&buf[dpix]) & 2) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            spix_val = pixdata.apixels[spix];
            dpix_val = colors_for_drawing.acolors[spix_val];
            spix += 4;
            buf[dpix++] = dpix_val;
        }
        if (dpix >= dpix_end)
            return spix;
        rem = (((uintptr_t)&buf[dpix_end]) & 2);
        if (rem)
            dpix_end--;
        while (dpix < dpix_end) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix];
            dpix_val = colors_for_drawing.acolors[spix_val];
            spix += 4;
            out_val = dpix_val;
            genlock_buf[dpix] = get_genlock_transparency(spix_val);
            spix_val = pixdata.apixels[spix];
            dpix_val = colors_for_drawing.acolors[spix_val];
            spix += 4;
            out_val = (out_val & 0xFFFF) | (dpix_val << 16);
            *((uae_u32 *)&buf[dpix]) = out_val;
            dpix += 2;
        }
        if (rem) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            spix_val = pixdata.apixels[spix];
            dpix_val = colors_for_drawing.acolors[spix_val];
            spix += 4;
            buf[dpix++] = dpix_val;
        }
    }

    return spix;
}

static int NOINLINE __attribute__((__unused__)) linetoscr_16_shrink2f(int spix, int dpix, int dpix_end)
{
    uae_u16 *buf = (uae_u16 *) xlinebuffer;

    if (bplham) {
        int rem;
        if (((uintptr_t)&buf[dpix]) & 2) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            spix_val = ham_linebuf[spix];
            dpix_val = xcolors[spix_val];
            {
            uae_u32 tmp_val, tmp_val2, tmp_val3;
            spix++;
            tmp_val = dpix_val;
            spix_val = ham_linebuf[spix];
            dpix_val = xcolors[spix_val];
            spix++;
            tmp_val2 = dpix_val;
            spix_val = ham_linebuf[spix];
            dpix_val = xcolors[spix_val];
            spix++;
            tmp_val3 = dpix_val;
            spix_val = ham_linebuf[spix];
            dpix_val = xcolors[spix_val];
            tmp_val = merge_2pixel16 (tmp_val, tmp_val2);
            tmp_val2 = merge_2pixel16 (tmp_val3, dpix_val);
            dpix_val = merge_2pixel16 (tmp_val, tmp_val2);
            spix++;
            }
            buf[dpix++] = dpix_val;
        }
        if (dpix >= dpix_end)
            return spix;
        rem = (((uintptr_t)&buf[dpix_end]) & 2);
        if (rem)
            dpix_end--;
        while (dpix < dpix_end) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = ham_linebuf[spix];
            dpix_val = xcolors[spix_val];
            {
            uae_u32 tmp_val, tmp_val2, tmp_val3;
            spix++;
            tmp_val = dpix_val;
            spix_val = ham_linebuf[spix];
            dpix_val = xcolors[spix_val];
            spix++;
            tmp_val2 = dpix_val;
            spix_val = ham_linebuf[spix];
            dpix_val = xcolors[spix_val];
            spix++;
            tmp_val3 = dpix_val;
            spix_val = ham_linebuf[spix];
            dpix_val = xcolors[spix_val];
            tmp_val = merge_2pixel16 (tmp_val, tmp_val2);
            tmp_val2 = merge_2pixel16 (tmp_val3, dpix_val);
            dpix_val = merge_2pixel16 (tmp_val, tmp_val2);
            spix++;
            }
            out_val = dpix_val;
            spix_val = ham_linebuf[spix];
            dpix_val = xcolors[spix_val];
            {
            uae_u32 tmp_val, tmp_val2, tmp_val3;
            spix++;
            tmp_val = dpix_val;
            spix_val = ham_linebuf[spix];
            dpix_val = xcolors[spix_val];
            spix++;
            tmp_val2 = dpix_val;
            spix_val = ham_linebuf[spix];
            dpix_val = xcolors[spix_val];
            spix++;
            tmp_val3 = dpix_val;
            spix_val = ham_linebuf[spix];
            dpix_val = xcolors[spix_val];
            tmp_val = merge_2pixel16 (tmp_val, tmp_val2);
            tmp_val2 = merge_2pixel16 (tmp_val3, dpix_val);
            dpix_val = merge_2pixel16 (tmp_val, tmp_val2);
            spix++;
            }
            out_val = (out_val & 0xFFFF) | (dpix_val << 16);
            *((uae_u32 *)&buf[dpix]) = out_val;
            dpix += 2;
        }
        if (rem) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            spix_val = ham_linebuf[spix];
            dpix_val = xcolors[spix_val];
            {
            uae_u32 tmp_val, tmp_val2, tmp_val3;
            spix++;
            tmp_val = dpix_val;
            spix_val = ham_linebuf[spix];
            dpix_val = xcolors[spix_val];
            spix++;
            tmp_val2 = dpix_val;
            spix_val = ham_linebuf[spix];
            dpix_val = xcolors[spix_val];
            spix++;
            tmp_val3 = dpix_val;
            spix_val = ham_linebuf[spix];
            dpix_val = xcolors[spix_val];
            tmp_val = merge_2pixel16 (tmp_val, tmp_val2);
            tmp_val2 = merge_2pixel16 (tmp_val3, dpix_val);
            dpix_val = merge_2pixel16 (tmp_val, tmp_val2);
            spix++;
            }
            buf[dpix++] = dpix_val;
        }
    } else if (bpldualpf) {
        int *lookup = bpldualpfpri ? dblpf_ind2 : dblpf_ind1;
        int rem;
        if (((uintptr_t)&buf[dpix]) & 2) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            spix_val = pixdata.apixels[spix];
            dpix_val = colors_for_drawing.acolors[lookup[spix_val]];
            {
            uae_u32 tmp_val, tmp_val2, tmp_val3;
            spix++;
            tmp_val = dpix_val;
            spix_val = pixdata.apixels[spix];
            dpix_val = colors_for_drawing.acolors[lookup[spix_val]];
            spix++;
            tmp_val2 = dpix_val;
            spix_val = pixdata.apixels[spix];
            dpix_val = colors_for_drawing.acolors[lookup[spix_val]];
            spix++;
            tmp_val3 = dpix_val;
            spix_val = pixdata.apixels[spix];
            dpix_val = colors_for_drawing.acolors[lookup[spix_val]];
            tmp_val = merge_2pixel16 (tmp_val, tmp_val2);
            tmp_val2 = merge_2pixel16 (tmp_val3, dpix_val);
            dpix_val = merge_2pixel16 (tmp_val, tmp_val2);
            spix++;
            }
            buf[dpix++] = dpix_val;
        }
        if (dpix >= dpix_end)
            return spix;
        rem = (((uintptr_t)&buf[dpix_end]) & 2);
        if (rem)
            dpix_end--;
        while (dpix < dpix_end) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix];
            dpix_val = colors_for_drawing.acolors[lookup[spix_val]];
            {
            uae_u32 tmp_val, tmp_val2, tmp_val3;
            spix++;
            tmp_val = dpix_val;
            spix_val = pixdata.apixels[spix];
            dpix_val = colors_for_drawing.acolors[lookup[spix_val]];
            spix++;
            tmp_val2 = dpix_val;
            spix_val = pixdata.apixels[spix];
            dpix_val = colors_for_drawing.acolors[lookup[spix_val]];
            spix++;
            tmp_val3 = dpix_val;
            spix_val = pixdata.apixels[spix];
            dpix_val = colors_for_drawing.acolors[lookup[spix_val]];
            tmp_val = merge_2pixel16 (tmp_val, tmp_val2);
            tmp_val2 = merge_2pixel16 (tmp_val3, dpix_val);
            dpix_val = merge_2pixel16 (tmp_val, tmp_val2);
            spix++;
            }
            out_val = dpix_val;
            spix_val = pixdata.apixels[spix];
            dpix_val = colors_for_drawing.acolors[lookup[spix_val]];
            {
            uae_u32 tmp_val, tmp_val2, tmp_val3;
            spix++;
            tmp_val = dpix_val;
            spix_val = pixdata.apixels[spix];
            dpix_val = colors_for_drawing.acolors[lookup[spix_val]];
            spix++;
            tmp_val2 = dpix_val;
            spix_val = pixdata.apixels[spix];
            dpix_val = colors_for_drawing.acolors[lookup[spix_val]];
            spix++;
            tmp_val3 = dpix_val;
            spix_val = pixdata.apixels[spix];
            dpix_val = colors_for_drawing.acolors[lookup[spix_val]];
            tmp_val = merge_2pixel16 (tmp_val, tmp_val2);
            tmp_val2 = merge_2pixel16 (tmp_val3, dpix_val);
            dpix_val = merge_2pixel16 (tmp_val, tmp_val2);
            spix++;
            }
            out_val = (out_val & 0xFFFF) | (dpix_val << 16);
            *((uae_u32 *)&buf[dpix]) = out_val;
            dpix += 2;
        }
        if (rem) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            spix_val = pixdata.apixels[spix];
            dpix_val = colors_for_drawing.acolors[lookup[spix_val]];
            {
            uae_u32 tmp_val, tmp_val2, tmp_val3;
            spix++;
            tmp_val = dpix_val;
            spix_val = pixdata.apixels[spix];
            dpix_val = colors_for_drawing.acolors[lookup[spix_val]];
            spix++;
            tmp_val2 = dpix_val;
            spix_val = pixdata.apixels[spix];
            dpix_val = colors_for_drawing.acolors[lookup[spix_val]];
            spix++;
            tmp_val3 = dpix_val;
            spix_val = pixdata.apixels[spix];
            dpix_val = colors_for_drawing.acolors[lookup[spix_val]];
            tmp_val = merge_2pixel16 (tmp_val, tmp_val2);
            tmp_val2 = merge_2pixel16 (tmp_val3, dpix_val);
            dpix_val = merge_2pixel16 (tmp_val, tmp_val2);
            spix++;
            }
            buf[dpix++] = dpix_val;
        }
    } else if (bplehb) {
        int rem;
        if (((uintptr_t)&buf[dpix]) & 2) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            spix_val = pixdata.apixels[spix];
            if (spix_val <= 31)
                dpix_val = colors_for_drawing.acolors[spix_val];
            else
                dpix_val = xcolors[(colors_for_drawing.color_regs_ecs[spix_val - 32] >> 1) & 0x777];
            {
            uae_u32 tmp_val, tmp_val2, tmp_val3;
            spix++;
            tmp_val = dpix_val;
            spix_val = pixdata.apixels[spix];
            if (spix_val <= 31)
                dpix_val = colors_for_drawing.acolors[spix_val];
            else
                dpix_val = xcolors[(colors_for_drawing.color_regs_ecs[spix_val - 32] >> 1) & 0x777];
            spix++;
            tmp_val2 = dpix_val;
            spix_val = pixdata.apixels[spix];
            if (spix_val <= 31)
                dpix_val = colors_for_drawing.acolors[spix_val];
            else
                dpix_val = xcolors[(colors_for_drawing.color_regs_ecs[spix_val - 32] >> 1) & 0x777];
            spix++;
            tmp_val3 = dpix_val;
            spix_val = pixdata.apixels[spix];
            if (spix_val <= 31)
                dpix_val = colors_for_drawing.acolors[spix_val];
            else
                dpix_val = xcolors[(colors_for_drawing.color_regs_ecs[spix_val - 32] >> 1) & 0x777];
            tmp_val = merge_2pixel16 (tmp_val, tmp_val2);
            tmp_val2 = merge_2pixel16 (tmp_val3, dpix_val);
            dpix_val = merge_2pixel16 (tmp_val, tmp_val2);
            spix++;
            }
            buf[dpix++] = dpix_val;
        }
        if (dpix >= dpix_end)
            return spix;
        rem = (((uintptr_t)&buf[dpix_end]) & 2);
        if (rem)
            dpix_end--;
        while (dpix < dpix_end) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix];
            if (spix_val <= 31)
                dpix_val = colors_for_drawing.acolors[spix_val];
            else
                dpix_val = xcolors[(colors_for_drawing.color_regs_ecs[spix_val - 32] >> 1) & 0x777];
            {
            uae_u32 tmp_val, tmp_val2, tmp_val3;
            spix++;
            tmp_val = dpix_val;
            spix_val = pixdata.apixels[spix];
            if (spix_val <= 31)
                dpix_val = colors_for_drawing.acolors[spix_val];
            else
                dpix_val = xcolors[(colors_for_drawing.color_regs_ecs[spix_val - 32] >> 1) & 0x777];
            spix++;
            tmp_val2 = dpix_val;
            spix_val = pixdata.apixels[spix];
            if (spix_val <= 31)
                dpix_val = colors_for_drawing.acolors[spix_val];
            else
                dpix_val = xcolors[(colors_for_drawing.color_regs_ecs[spix_val - 32] >> 1) & 0x777];
            spix++;
            tmp_val3 = dpix_val;
            spix_val = pixdata.apixels[spix];
            if (spix_val <= 31)
                dpix_val = colors_for_drawing.acolors[spix_val];
            else
                dpix_val = xcolors[(colors_for_drawing.color_regs_ecs[spix_val - 32] >> 1) & 0x777];
            tmp_val = merge_2pixel16 (tmp_val, tmp_val2);
            tmp_val2 = merge_2pixel16 (tmp_val3, dpix_val);
            dpix_val = merge_2pixel16 (tmp_val, tmp_val2);
            spix++;
            }
            out_val = dpix_val;
            spix_val = pixdata.apixels[spix];
            if (spix_val <= 31)
                dpix_val = colors_for_drawing.acolors[spix_val];
            else
                dpix_val = xcolors[(colors_for_drawing.color_regs_ecs[spix_val - 32] >> 1) & 0x777];
            {
            uae_u32 tmp_val, tmp_val2, tmp_val3;
            spix++;
            tmp_val = dpix_val;
            spix_val = pixdata.apixels[spix];
            if (spix_val <= 31)
                dpix_val = colors_for_drawing.acolors[spix_val];
            else
                dpix_val = xcolors[(colors_for_drawing.color_regs_ecs[spix_val - 32] >> 1) & 0x777];
            spix++;
            tmp_val2 = dpix_val;
            spix_val = pixdata.apixels[spix];
            if (spix_val <= 31)
                dpix_val = colors_for_drawing.acolors[spix_val];
            else
                dpix_val = xcolors[(colors_for_drawing.color_regs_ecs[spix_val - 32] >> 1) & 0x777];
            spix++;
            tmp_val3 = dpix_val;
            spix_val = pixdata.apixels[spix];
            if (spix_val <= 31)
                dpix_val = colors_for_drawing.acolors[spix_val];
            else
                dpix_val = xcolors[(colors_for_drawing.color_regs_ecs[spix_val - 32] >> 1) & 0x777];
            tmp_val = merge_2pixel16 (tmp_val, tmp_val2);
            tmp_val2 = merge_2pixel16 (tmp_val3, dpix_val);
            dpix_val = merge_2pixel16 (tmp_val, tmp_val2);
            spix++;
            }
            out_val = (out_val & 0xFFFF) | (dpix_val << 16);
            *((uae_u32 *)&buf[dpix]) = out_val;
            dpix += 2;
        }
        if (rem) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            spix_val = pixdata.apixels[spix];
            if (spix_val <= 31)
                dpix_val = colors_for_drawing.acolors[spix_val];
            else
                dpix_val = xcolors[(colors_for_drawing.color_regs_ecs[spix_val - 32] >> 1) & 0x777];
            {
            uae_u32 tmp_val, tmp_val2, tmp_val3;
            spix++;
            tmp_val = dpix_val;
            spix_val = pixdata.apixels[spix];
            if (spix_val <= 31)
                dpix_val = colors_for_drawing.acolors[spix_val];
            else
                dpix_val = xcolors[(colors_for_drawing.color_regs_ecs[spix_val - 32] >> 1) & 0x777];
            spix++;
            tmp_val2 = dpix_val;
            spix_val = pixdata.apixels[spix];
            if (spix_val <= 31)
                dpix_val = colors_for_drawing.acolors[spix_val];
            else
                dpix_val = xcolors[(colors_for_drawing.color_regs_ecs[spix_val - 32] >> 1) & 0x777];
            spix++;
            tmp_val3 = dpix_val;
            spix_val = pixdata.apixels[spix];
            if (spix_val <= 31)
                dpix_val = colors_for_drawing.acolors[spix_val];
            else
                dpix_val = xcolors[(colors_for_drawing.color_regs_ecs[spix_val - 32] >> 1) & 0x777];
            tmp_val = merge_2pixel16 (tmp_val, tmp_val2);
            tmp_val2 = merge_2pixel16 (tmp_val3, dpix_val);
            dpix_val = merge_2pixel16 (tmp_val, tmp_val2);
            spix++;
            }
            buf[dpix++] = dpix_val;
        }
    } else {
        int rem;
        if (((uintptr_t)&buf[dpix]) & 2) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            spix_val = pixdata.apixels[spix];
            dpix_val = colors_for_drawing.acolors[spix_val];
            {
            uae_u32 tmp_val, tmp_val2, tmp_val3;
            spix++;
            tmp_val = dpix_val;
            spix_val = pixdata.apixels[spix];
            dpix_val = colors_for_drawing.acolors[spix_val];
            spix++;
            tmp_val2 = dpix_val;
            spix_val = pixdata.apixels[spix];
            dpix_val = colors_for_drawing.acolors[spix_val];
            spix++;
            tmp_val3 = dpix_val;
            spix_val = pixdata.apixels[spix];
            dpix_val = colors_for_drawing.acolors[spix_val];
            tmp_val = merge_2pixel16 (tmp_val, tmp_val2);
            tmp_val2 = merge_2pixel16 (tmp_val3, dpix_val);
            dpix_val = merge_2pixel16 (tmp_val, tmp_val2);
            spix++;
            }
            buf[dpix++] = dpix_val;
        }
        if (dpix >= dpix_end)
            return spix;
        rem = (((uintptr_t)&buf[dpix_end]) & 2);
        if (rem)
            dpix_end--;
        while (dpix < dpix_end) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix];
            dpix_val = colors_for_drawing.acolors[spix_val];
            {
            uae_u32 tmp_val, tmp_val2, tmp_val3;
            spix++;
            tmp_val = dpix_val;
            spix_val = pixdata.apixels[spix];
            dpix_val = colors_for_drawing.acolors[spix_val];
            spix++;
            tmp_val2 = dpix_val;
            spix_val = pixdata.apixels[spix];
            dpix_val = colors_for_drawing.acolors[spix_val];
            spix++;
            tmp_val3 = dpix_val;
            spix_val = pixdata.apixels[spix];
            dpix_val = colors_for_drawing.acolors[spix_val];
            tmp_val = merge_2pixel16 (tmp_val, tmp_val2);
            tmp_val2 = merge_2pixel16 (tmp_val3, dpix_val);
            dpix_val = merge_2pixel16 (tmp_val, tmp_val2);
            spix++;
            }
            out_val = dpix_val;
            spix_val = pixdata.apixels[spix];
            dpix_val = colors_for_drawing.acolors[spix_val];
            {
            uae_u32 tmp_val, tmp_val2, tmp_val3;
            spix++;
            tmp_val = dpix_val;
            spix_val = pixdata.apixels[spix];
            dpix_val = colors_for_drawing.acolors[spix_val];
            spix++;
            tmp_val2 = dpix_val;
            spix_val = pixdata.apixels[spix];
            dpix_val = colors_for_drawing.acolors[spix_val];
            spix++;
            tmp_val3 = dpix_val;
            spix_val = pixdata.apixels[spix];
            dpix_val = colors_for_drawing.acolors[spix_val];
            tmp_val = merge_2pixel16 (tmp_val, tmp_val2);
            tmp_val2 = merge_2pixel16 (tmp_val3, dpix_val);
            dpix_val = merge_2pixel16 (tmp_val, tmp_val2);
            spix++;
            }
            out_val = (out_val & 0xFFFF) | (dpix_val << 16);
            *((uae_u32 *)&buf[dpix]) = out_val;
            dpix += 2;
        }
        if (rem) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            spix_val = pixdata.apixels[spix];
            dpix_val = colors_for_drawing.acolors[spix_val];
            {
            uae_u32 tmp_val, tmp_val2, tmp_val3;
            spix++;
            tmp_val = dpix_val;
            spix_val = pixdata.apixels[spix];
            dpix_val = colors_for_drawing.acolors[spix_val];
            spix++;
            tmp_val2 = dpix_val;
            spix_val = pixdata.apixels[spix];
            dpix_val = colors_for_drawing.acolors[spix_val];
            spix++;
            tmp_val3 = dpix_val;
            spix_val = pixdata.apixels[spix];
            dpix_val = colors_for_drawing.acolors[spix_val];
            tmp_val = merge_2pixel16 (tmp_val, tmp_val2);
            tmp_val2 = merge_2pixel16 (tmp_val3, dpix_val);
            dpix_val = merge_2pixel16 (tmp_val, tmp_val2);
            spix++;
            }
            buf[dpix++] = dpix_val;
        }
    }

    return spix;
}

static int NOINLINE __attribute__((__unused__)) linetoscr_16_shrink2f_genlock(int spix, int dpix, int dpix_end)
{
    uae_u16 *buf = (uae_u16 *) xlinebuffer;
    uae_u8 *genlock_buf = xlinebuffer_genlock;

    if (bplham) {
        int rem;
        if (((uintptr_t)&buf[dpix]) & 2) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            spix_val = ham_linebuf[spix];
            dpix_val = xcolors[spix_val];
            {
            uae_u32 tmp_val, tmp_val2, tmp_val3;
            spix++;
            tmp_val = dpix_val;
            spix_val = ham_linebuf[spix];
            dpix_val = xcolors[spix_val];
            spix++;
            tmp_val2 = dpix_val;
            spix_val = ham_linebuf[spix];
            dpix_val = xcolors[spix_val];
            spix++;
            tmp_val3 = dpix_val;
            spix_val = ham_linebuf[spix];
            dpix_val = xcolors[spix_val];
            tmp_val = merge_2pixel16 (tmp_val, tmp_val2);
            tmp_val2 = merge_2pixel16 (tmp_val3, dpix_val);
            dpix_val = merge_2pixel16 (tmp_val, tmp_val2);
            spix++;
            }
            buf[dpix++] = dpix_val;
        }
        if (dpix >= dpix_end)
            return spix;
        rem = (((uintptr_t)&buf[dpix_end]) & 2);
        if (rem)
            dpix_end--;
        while (dpix < dpix_end) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = ham_linebuf[spix];
            dpix_val = xcolors[spix_val];
            {
            uae_u32 tmp_val, tmp_val2, tmp_val3;
            spix++;
            tmp_val = dpix_val;
            spix_val = ham_linebuf[spix];
            dpix_val = xcolors[spix_val];
            spix++;
            tmp_val2 = dpix_val;
            spix_val = ham_linebuf[spix];
            dpix_val = xcolors[spix_val];
            spix++;
            tmp_val3 = dpix_val;
            spix_val = ham_linebuf[spix];
            dpix_val = xcolors[spix_val];
            tmp_val = merge_2pixel16 (tmp_val, tmp_val2);
            tmp_val2 = merge_2pixel16 (tmp_val3, dpix_val);
            dpix_val = merge_2pixel16 (tmp_val, tmp_val2);
            spix++;
            }
            out_val = dpix_val;
            genlock_buf[dpix] = get_genlock_transparency(spix_val & 15);
            spix_val = ham_linebuf[spix];
            dpix_val = xcolors[spix_val];
            {
            uae_u32 tmp_val, tmp_val2, tmp_val3;
            spix++;
            tmp_val = dpix_val;
            spix_val = ham_linebuf[spix];
            dpix_val = xcolors[spix_val];
            spix++;
            tmp_val2 = dpix_val;
            spix_val = ham_linebuf[spix];
            dpix_val = xcolors[spix_val];
            spix++;
            tmp_val3 = dpix_val;
            spix_val = ham_linebuf[spix];
            dpix_val = xcolors[spix_val];
            tmp_val = merge_2pixel16 (tmp_val, tmp_val2);
            tmp_val2 = merge_2pixel16 (tmp_val3, dpix_val);
            dpix_val = merge_2pixel16 (tmp_val, tmp_val2);
            spix++;
            }
            out_val = (out_val & 0xFFFF) | (dpix_val << 16);
            *((uae_u32 *)&buf[dpix]) = out_val;
            dpix += 2;
        }
        if (rem) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            spix_val = ham_linebuf[spix];
            dpix_val = xcolors[spix_val];
            {
            uae_u32 tmp_val, tmp_val2, tmp_val3;
            spix++;
            tmp_val = dpix_val;
            spix_val = ham_linebuf[spix];
            dpix_val = xcolors[spix_val];
            spix++;
            tmp_val2 = dpix_val;
            spix_val = ham_linebuf[spix];
            dpix_val = xcolors[spix_val];
            spix++;
            tmp_val3 = dpix_val;
            spix_val = ham_linebuf[spix];
            dpix_val = xcolors[spix_val];
            tmp_val = merge_2pixel16 (tmp_val, tmp_val2);
            tmp_val2 = merge_2pixel16 (tmp_val3, dpix_val);
            dpix_val = merge_2pixel16 (tmp_val, tmp_val2);
            spix++;
            }
            buf[dpix++] = dpix_val;
        }
    } else if (bpldualpf) {
        int *lookup = bpldualpfpri ? dblpf_ind2 : dblpf_ind1;
        int rem;
        if (((uintptr_t)&buf[dpix]) & 2) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            spix_val = pixdata.apixels[spix];
            dpix_val = colors_for_drawing.acolors[lookup[spix_val]];
            {
            uae_u32 tmp_val, tmp_val2, tmp_val3;
            spix++;
            tmp_val = dpix_val;
            spix_val = pixdata.apixels[spix];
            dpix_val = colors_for_drawing.acolors[lookup[spix_val]];
            spix++;
            tmp_val2 = dpix_val;
            spix_val = pixdata.apixels[spix];
            dpix_val = colors_for_drawing.acolors[lookup[spix_val]];
            spix++;
            tmp_val3 = dpix_val;
            spix_val = pixdata.apixels[spix];
            dpix_val = colors_for_drawing.acolors[lookup[spix_val]];
            tmp_val = merge_2pixel16 (tmp_val, tmp_val2);
            tmp_val2 = merge_2pixel16 (tmp_val3, dpix_val);
            dpix_val = merge_2pixel16 (tmp_val, tmp_val2);
            spix++;
            }
            buf[dpix++] = dpix_val;
        }
        if (dpix >= dpix_end)
            return spix;
        rem = (((uintptr_t)&buf[dpix_end]) & 2);
        if (rem)
            dpix_end--;
        while (dpix < dpix_end) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix];
            dpix_val = colors_for_drawing.acolors[lookup[spix_val]];
            {
            uae_u32 tmp_val, tmp_val2, tmp_val3;
            spix++;
            tmp_val = dpix_val;
            spix_val = pixdata.apixels[spix];
            dpix_val = colors_for_drawing.acolors[lookup[spix_val]];
            spix++;
            tmp_val2 = dpix_val;
            spix_val = pixdata.apixels[spix];
            dpix_val = colors_for_drawing.acolors[lookup[spix_val]];
            spix++;
            tmp_val3 = dpix_val;
            spix_val = pixdata.apixels[spix];
            dpix_val = colors_for_drawing.acolors[lookup[spix_val]];
            tmp_val = merge_2pixel16 (tmp_val, tmp_val2);
            tmp_val2 = merge_2pixel16 (tmp_val3, dpix_val);
            dpix_val = merge_2pixel16 (tmp_val, tmp_val2);
            spix++;
            }
            out_val = dpix_val;
            genlock_buf[dpix] = get_genlock_transparency(lookup[spix_val]);
            spix_val = pixdata.apixels[spix];
            dpix_val = colors_for_drawing.acolors[lookup[spix_val]];
            {
            uae_u32 tmp_val, tmp_val2, tmp_val3;
            spix++;
            tmp_val = dpix_val;
            spix_val = pixdata.apixels[spix];
            dpix_val = colors_for_drawing.acolors[lookup[spix_val]];
            spix++;
            tmp_val2 = dpix_val;
            spix_val = pixdata.apixels[spix];
            dpix_val = colors_for_drawing.acolors[lookup[spix_val]];
            spix++;
            tmp_val3 = dpix_val;
            spix_val = pixdata.apixels[spix];
            dpix_val = colors_for_drawing.acolors[lookup[spix_val]];
            tmp_val = merge_2pixel16 (tmp_val, tmp_val2);
            tmp_val2 = merge_2pixel16 (tmp_val3, dpix_val);
            dpix_val = merge_2pixel16 (tmp_val, tmp_val2);
            spix++;
            }
            out_val = (out_val & 0xFFFF) | (dpix_val << 16);
            *((uae_u32 *)&buf[dpix]) = out_val;
            dpix += 2;
        }
        if (rem) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            spix_val = pixdata.apixels[spix];
            dpix_val = colors_for_drawing.acolors[lookup[spix_val]];
            {
            uae_u32 tmp_val, tmp_val2, tmp_val3;
            spix++;
            tmp_val = dpix_val;
            spix_val = pixdata.apixels[spix];
            dpix_val = colors_for_drawing.acolors[lookup[spix_val]];
            spix++;
            tmp_val2 = dpix_val;
            spix_val = pixdata.apixels[spix];
            dpix_val = colors_for_drawing.acolors[lookup[spix_val]];
            spix++;
            tmp_val3 = dpix_val;
            spix_val = pixdata.apixels[spix];
            dpix_val = colors_for_drawing.acolors[lookup[spix_val]];
            tmp_val = merge_2pixel16 (tmp_val, tmp_val2);
            tmp_val2 = merge_2pixel16 (tmp_val3, dpix_val);
            dpix_val = merge_2pixel16 (tmp_val, tmp_val2);
            spix++;
            }
            buf[dpix++] = dpix_val;
        }
    } else if (bplehb) {
        int rem;
        if (((uintptr_t)&buf[dpix]) & 2) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            spix_val = pixdata.apixels[spix];
            if (spix_val <= 31)
                dpix_val = colors_for_drawing.acolors[spix_val];
            else
                dpix_val = xcolors[(colors_for_drawing.color_regs_ecs[spix_val - 32] >> 1) & 0x777];
            {
            uae_u32 tmp_val, tmp_val2, tmp_val3;
            spix++;
            tmp_val = dpix_val;
            spix_val = pixdata.apixels[spix];
            if (spix_val <= 31)
                dpix_val = colors_for_drawing.acolors[spix_val];
            else
                dpix_val = xcolors[(colors_for_drawing.color_regs_ecs[spix_val - 32] >> 1) & 0x777];
            spix++;
            tmp_val2 = dpix_val;
            spix_val = pixdata.apixels[spix];
            if (spix_val <= 31)
                dpix_val = colors_for_drawing.acolors[spix_val];
            else
                dpix_val = xcolors[(colors_for_drawing.color_regs_ecs[spix_val - 32] >> 1) & 0x777];
            spix++;
            tmp_val3 = dpix_val;
            spix_val = pixdata.apixels[spix];
            if (spix_val <= 31)
                dpix_val = colors_for_drawing.acolors[spix_val];
            else
                dpix_val = xcolors[(colors_for_drawing.color_regs_ecs[spix_val - 32] >> 1) & 0x777];
            tmp_val = merge_2pixel16 (tmp_val, tmp_val2);
            tmp_val2 = merge_2pixel16 (tmp_val3, dpix_val);
            dpix_val = merge_2pixel16 (tmp_val, tmp_val2);
            spix++;
            }
            buf[dpix++] = dpix_val;
        }
        if (dpix >= dpix_end)
            return spix;
        rem = (((uintptr_t)&buf[dpix_end]) & 2);
        if (rem)
            dpix_end--;
        while (dpix < dpix_end) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix];
            if (spix_val <= 31)
                dpix_val = colors_for_drawing.acolors[spix_val];
            else
                dpix_val = xcolors[(colors_for_drawing.color_regs_ecs[spix_val - 32] >> 1) & 0x777];
            {
            uae_u32 tmp_val, tmp_val2, tmp_val3;
            spix++;
            tmp_val = dpix_val;
            spix_val = pixdata.apixels[spix];
            if (spix_val <= 31)
                dpix_val = colors_for_drawing.acolors[spix_val];
            else
                dpix_val = xcolors[(colors_for_drawing.color_regs_ecs[spix_val - 32] >> 1) & 0x777];
            spix++;
            tmp_val2 = dpix_val;
            spix_val = pixdata.apixels[spix];
            if (spix_val <= 31)
                dpix_val = colors_for_drawing.acolors[spix_val];
            else
                dpix_val = xcolors[(colors_for_drawing.color_regs_ecs[spix_val - 32] >> 1) & 0x777];
            spix++;
            tmp_val3 = dpix_val;
            spix_val = pixdata.apixels[spix];
            if (spix_val <= 31)
                dpix_val = colors_for_drawing.acolors[spix_val];
            else
                dpix_val = xcolors[(colors_for_drawing.color_regs_ecs[spix_val - 32] >> 1) & 0x777];
            tmp_val = merge_2pixel16 (tmp_val, tmp_val2);
            tmp_val2 = merge_2pixel16 (tmp_val3, dpix_val);
            dpix_val = merge_2pixel16 (tmp_val, tmp_val2);
            spix++;
            }
            out_val = dpix_val;
            genlock_buf[dpix] = get_genlock_transparency(spix_val & 31);
            spix_val = pixdata.apixels[spix];
            if (spix_val <= 31)
                dpix_val = colors_for_drawing.acolors[spix_val];
            else
                dpix_val = xcolors[(colors_for_drawing.color_regs_ecs[spix_val - 32] >> 1) & 0x777];
            {
            uae_u32 tmp_val, tmp_val2, tmp_val3;
            spix++;
            tmp_val = dpix_val;
            spix_val = pixdata.apixels[spix];
            if (spix_val <= 31)
                dpix_val = colors_for_drawing.acolors[spix_val];
            else
                dpix_val = xcolors[(colors_for_drawing.color_regs_ecs[spix_val - 32] >> 1) & 0x777];
            spix++;
            tmp_val2 = dpix_val;
            spix_val = pixdata.apixels[spix];
            if (spix_val <= 31)
                dpix_val = colors_for_drawing.acolors[spix_val];
            else
                dpix_val = xcolors[(colors_for_drawing.color_regs_ecs[spix_val - 32] >> 1) & 0x777];
            spix++;
            tmp_val3 = dpix_val;
            spix_val = pixdata.apixels[spix];
            if (spix_val <= 31)
                dpix_val = colors_for_drawing.acolors[spix_val];
            else
                dpix_val = xcolors[(colors_for_drawing.color_regs_ecs[spix_val - 32] >> 1) & 0x777];
            tmp_val = merge_2pixel16 (tmp_val, tmp_val2);
            tmp_val2 = merge_2pixel16 (tmp_val3, dpix_val);
            dpix_val = merge_2pixel16 (tmp_val, tmp_val2);
            spix++;
            }
            out_val = (out_val & 0xFFFF) | (dpix_val << 16);
            *((uae_u32 *)&buf[dpix]) = out_val;
            dpix += 2;
        }
        if (rem) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            spix_val = pixdata.apixels[spix];
            if (spix_val <= 31)
                dpix_val = colors_for_drawing.acolors[spix_val];
            else
                dpix_val = xcolors[(colors_for_drawing.color_regs_ecs[spix_val - 32] >> 1) & 0x777];
            {
            uae_u32 tmp_val, tmp_val2, tmp_val3;
            spix++;
            tmp_val = dpix_val;
            spix_val = pixdata.apixels[spix];
            if (spix_val <= 31)
                dpix_val = colors_for_drawing.acolors[spix_val];
            else
                dpix_val = xcolors[(colors_for_drawing.color_regs_ecs[spix_val - 32] >> 1) & 0x777];
            spix++;
            tmp_val2 = dpix_val;
            spix_val = pixdata.apixels[spix];
            if (spix_val <= 31)
                dpix_val = colors_for_drawing.acolors[spix_val];
            else
                dpix_val = xcolors[(colors_for_drawing.color_regs_ecs[spix_val - 32] >> 1) & 0x777];
            spix++;
            tmp_val3 = dpix_val;
            spix_val = pixdata.apixels[spix];
            if (spix_val <= 31)
                dpix_val = colors_for_drawing.acolors[spix_val];
            else
                dpix_val = xcolors[(colors_for_drawing.color_regs_ecs[spix_val - 32] >> 1) & 0x777];
            tmp_val = merge_2pixel16 (tmp_val, tmp_val2);
            tmp_val2 = merge_2pixel16 (tmp_val3, dpix_val);
            dpix_val = merge_2pixel16 (tmp_val, tmp_val2);
            spix++;
            }
            buf[dpix++] = dpix_val;
        }
    } else {
        int rem;
        if (((uintptr_t)&buf[dpix]) & 2) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            spix_val = pixdata.apixels[spix];
            dpix_val = colors_for_drawing.acolors[spix_val];
            {
            uae_u32 tmp_val, tmp_val2, tmp_val3;
            spix++;
            tmp_val = dpix_val;
            spix_val = pixdata.apixels[spix];
            dpix_val = colors_for_drawing.acolors[spix_val];
            spix++;
            tmp_val2 = dpix_val;
            spix_val = pixdata.apixels[spix];
            dpix_val = colors_for_drawing.acolors[spix_val];
            spix++;
            tmp_val3 = dpix_val;
            spix_val = pixdata.apixels[spix];
            dpix_val = colors_for_drawing.acolors[spix_val];
            tmp_val = merge_2pixel16 (tmp_val, tmp_val2);
            tmp_val2 = merge_2pixel16 (tmp_val3, dpix_val);
            dpix_val = merge_2pixel16 (tmp_val, tmp_val2);
            spix++;
            }
            buf[dpix++] = dpix_val;
        }
        if (dpix >= dpix_end)
            return spix;
        rem = (((uintptr_t)&buf[dpix_end]) & 2);
        if (rem)
            dpix_end--;
        while (dpix < dpix_end) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix];
            dpix_val = colors_for_drawing.acolors[spix_val];
            {
            uae_u32 tmp_val, tmp_val2, tmp_val3;
            spix++;
            tmp_val = dpix_val;
            spix_val = pixdata.apixels[spix];
            dpix_val = colors_for_drawing.acolors[spix_val];
            spix++;
            tmp_val2 = dpix_val;
            spix_val = pixdata.apixels[spix];
            dpix_val = colors_for_drawing.acolors[spix_val];
            spix++;
            tmp_val3 = dpix_val;
            spix_val = pixdata.apixels[spix];
            dpix_val = colors_for_drawing.acolors[spix_val];
            tmp_val = merge_2pixel16 (tmp_val, tmp_val2);
            tmp_val2 = merge_2pixel16 (tmp_val3, dpix_val);
            dpix_val = merge_2pixel16 (tmp_val, tmp_val2);
            spix++;
            }
            out_val = dpix_val;
            genlock_buf[dpix] = get_genlock_transparency(spix_val);
            spix_val = pixdata.apixels[spix];
            dpix_val = colors_for_drawing.acolors[spix_val];
            {
            uae_u32 tmp_val, tmp_val2, tmp_val3;
            spix++;
            tmp_val = dpix_val;
            spix_val = pixdata.apixels[spix];
            dpix_val = colors_for_drawing.acolors[spix_val];
            spix++;
            tmp_val2 = dpix_val;
            spix_val = pixdata.apixels[spix];
            dpix_val = colors_for_drawing.acolors[spix_val];
            spix++;
            tmp_val3 = dpix_val;
            spix_val = pixdata.apixels[spix];
            dpix_val = colors_for_drawing.acolors[spix_val];
            tmp_val = merge_2pixel16 (tmp_val, tmp_val2);
            tmp_val2 = merge_2pixel16 (tmp_val3, dpix_val);
            dpix_val = merge_2pixel16 (tmp_val, tmp_val2);
            spix++;
            }
            out_val = (out_val & 0xFFFF) | (dpix_val << 16);
            *((uae_u32 *)&buf[dpix]) = out_val;
            dpix += 2;
        }
        if (rem) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            spix_val = pixdata.apixels[spix];
            dpix_val = colors_for_drawing.acolors[spix_val];
            {
            uae_u32 tmp_val, tmp_val2, tmp_val3;
            spix++;
            tmp_val = dpix_val;
            spix_val = pixdata.apixels[spix];
            dpix_val = colors_for_drawing.acolors[spix_val];
            spix++;
            tmp_val2 = dpix_val;
            spix_val = pixdata.apixels[spix];
            dpix_val = colors_for_drawing.acolors[spix_val];
            spix++;
            tmp_val3 = dpix_val;
            spix_val = pixdata.apixels[spix];
            dpix_val = colors_for_drawing.acolors[spix_val];
            tmp_val = merge_2pixel16 (tmp_val, tmp_val2);
            tmp_val2 = merge_2pixel16 (tmp_val3, dpix_val);
            dpix_val = merge_2pixel16 (tmp_val, tmp_val2);
            spix++;
            }
            buf[dpix++] = dpix_val;
        }
    }

    return spix;
}

static int NOINLINE __attribute__((__unused__)) linetoscr_16_spr(int spix, int dpix, int dpix_end)
{
    uae_u16 *buf = (uae_u16 *) xlinebuffer;
    uae_u8 sprcol;

    if (bplham) {
        while (dpix < dpix_end) {
            uae_u32 sprpix_val;
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = ham_linebuf[spix];
            dpix_val = xcolors[spix_val];
            sprpix_val = pixdata.apixels[spix];
            spix++;
            out_val = dpix_val;
            if (spritepixels[dpix].data) {
                sprcol = render_sprites (dpix, 0, sprpix_val, 0);
                if (sprcol) {
                    uae_u32 spcol = colors_for_drawing.acolors[sprcol];
                    out_val = spcol;
                }
            }
            buf[dpix++] = out_val;
        }
    } else if (bpldualpf) {
        int *lookup = bpldualpfpri ? dblpf_ind2 : dblpf_ind1;
        while (dpix < dpix_end) {
            uae_u32 sprpix_val;
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix];
            sprpix_val = spix_val;
            dpix_val = colors_for_drawing.acolors[lookup[spix_val]];
            spix++;
            out_val = dpix_val;
            if (spritepixels[dpix].data) {
                sprcol = render_sprites (dpix, 1, sprpix_val, 0);
                if (sprcol) {
                    uae_u32 spcol = colors_for_drawing.acolors[sprcol];
                    out_val = spcol;
                }
            }
            buf[dpix++] = out_val;
        }
    } else if (bplehb) {
        while (dpix < dpix_end) {
            uae_u32 sprpix_val;
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix];
            sprpix_val = spix_val;
            if (spix_val <= 31)
                dpix_val = colors_for_drawing.acolors[spix_val];
            else
                dpix_val = xcolors[(colors_for_drawing.color_regs_ecs[spix_val - 32] >> 1) & 0x777];
            spix++;
            out_val = dpix_val;
            if (spritepixels[dpix].data) {
                sprcol = render_sprites (dpix, 0, sprpix_val, 0);
                if (sprcol) {
                    uae_u32 spcol = colors_for_drawing.acolors[sprcol];
                    out_val = spcol;
                }
            }
            buf[dpix++] = out_val;
        }
    } else {
        while (dpix < dpix_end) {
            uae_u32 sprpix_val;
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix];
            sprpix_val = spix_val;
            dpix_val = colors_for_drawing.acolors[spix_val];
            spix++;
            out_val = dpix_val;
            if (spritepixels[dpix].data) {
                sprcol = render_sprites (dpix, 0, sprpix_val, 0);
                if (sprcol) {
                    uae_u32 spcol = colors_for_drawing.acolors[sprcol];
                    out_val = spcol;
                }
            }
            buf[dpix++] = out_val;
        }
    }

    return spix;
}

static int NOINLINE __attribute__((__unused__)) linetoscr_16_spr_genlock(int spix, int dpix, int dpix_end)
{
    uae_u16 *buf = (uae_u16 *) xlinebuffer;
    uae_u8 *genlock_buf = xlinebuffer_genlock;
    uae_u8 sprcol;

    if (bplham) {
        while (dpix < dpix_end) {
            uae_u32 sprpix_val;
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = ham_linebuf[spix];
            dpix_val = xcolors[spix_val];
            sprpix_val = pixdata.apixels[spix];
            spix++;
            out_val = dpix_val;
            genlock_buf[dpix] = get_genlock_transparency(spix_val & 15);
            if (spritepixels[dpix].data) {
                sprcol = render_sprites (dpix, 0, sprpix_val, 0);
                    genlock_buf[dpix] = get_genlock_transparency(sprcol);
                if (sprcol) {
                    uae_u32 spcol = colors_for_drawing.acolors[sprcol];
                    out_val = spcol;
                }
            }
            buf[dpix++] = out_val;
        }
    } else if (bpldualpf) {
        int *lookup = bpldualpfpri ? dblpf_ind2 : dblpf_ind1;
        while (dpix < dpix_end) {
            uae_u32 sprpix_val;
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix];
            sprpix_val = spix_val;
            dpix_val = colors_for_drawing.acolors[lookup[spix_val]];
            spix++;
            out_val = dpix_val;
            genlock_buf[dpix] = get_genlock_transparency(lookup[spix_val]);
            if (spritepixels[dpix].data) {
                sprcol = render_sprites (dpix, 1, sprpix_val, 0);
                    genlock_buf[dpix] = get_genlock_transparency(sprcol);
                if (sprcol) {
                    uae_u32 spcol = colors_for_drawing.acolors[sprcol];
                    out_val = spcol;
                }
            }
            buf[dpix++] = out_val;
        }
    } else if (bplehb) {
        while (dpix < dpix_end) {
            uae_u32 sprpix_val;
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix];
            sprpix_val = spix_val;
            if (spix_val <= 31)
                dpix_val = colors_for_drawing.acolors[spix_val];
            else
                dpix_val = xcolors[(colors_for_drawing.color_regs_ecs[spix_val - 32] >> 1) & 0x777];
            spix++;
            out_val = dpix_val;
            genlock_buf[dpix] = get_genlock_transparency(spix_val & 31);
            if (spritepixels[dpix].data) {
                sprcol = render_sprites (dpix, 0, sprpix_val, 0);
                    genlock_buf[dpix] = get_genlock_transparency(sprcol);
                if (sprcol) {
                    uae_u32 spcol = colors_for_drawing.acolors[sprcol];
                    out_val = spcol;
                }
            }
            buf[dpix++] = out_val;
        }
    } else {
        while (dpix < dpix_end) {
            uae_u32 sprpix_val;
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix];
            sprpix_val = spix_val;
            dpix_val = colors_for_drawing.acolors[spix_val];
            spix++;
            out_val = dpix_val;
            genlock_buf[dpix] = get_genlock_transparency(spix_val);
            if (spritepixels[dpix].data) {
                sprcol = render_sprites (dpix, 0, sprpix_val, 0);
                    genlock_buf[dpix] = get_genlock_transparency(sprcol);
                if (sprcol) {
                    uae_u32 spcol = colors_for_drawing.acolors[sprcol];
                    out_val = spcol;
                }
            }
            buf[dpix++] = out_val;
        }
    }

    return spix;
}

static int NOINLINE __attribute__((__unused__)) linetoscr_16_stretch1_spr(int spix, int dpix, int dpix_end)
{
    uae_u16 *buf = (uae_u16 *) xlinebuffer;
    uae_u8 sprcol;

    if (bplham) {
        while (dpix < dpix_end) {
            uae_u32 sprpix_val;
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = ham_linebuf[spix];
            dpix_val = xcolors[spix_val];
            sprpix_val = pixdata.apixels[spix];
            spix++;
            out_val = dpix_val;
            if (spritepixels[dpix].data) {
                sprcol = render_sprites (dpix, 0, sprpix_val, 0);
                if (sprcol) {
                    uae_u32 spcol = colors_for_drawing.acolors[sprcol];
                    out_val = spcol;
                }
            }
            buf[dpix++] = out_val;
            buf[dpix++] = out_val;
        }
    } else if (bpldualpf) {
        int *lookup = bpldualpfpri ? dblpf_ind2 : dblpf_ind1;
        while (dpix < dpix_end) {
            uae_u32 sprpix_val;
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix];
            sprpix_val = spix_val;
            dpix_val = colors_for_drawing.acolors[lookup[spix_val]];
            spix++;
            out_val = dpix_val;
            if (spritepixels[dpix].data) {
                sprcol = render_sprites (dpix, 1, sprpix_val, 0);
                if (sprcol) {
                    uae_u32 spcol = colors_for_drawing.acolors[sprcol];
                    out_val = spcol;
                }
            }
            buf[dpix++] = out_val;
            buf[dpix++] = out_val;
        }
    } else if (bplehb) {
        while (dpix < dpix_end) {
            uae_u32 sprpix_val;
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix];
            sprpix_val = spix_val;
            if (spix_val <= 31)
                dpix_val = colors_for_drawing.acolors[spix_val];
            else
                dpix_val = xcolors[(colors_for_drawing.color_regs_ecs[spix_val - 32] >> 1) & 0x777];
            spix++;
            out_val = dpix_val;
            if (spritepixels[dpix].data) {
                sprcol = render_sprites (dpix, 0, sprpix_val, 0);
                if (sprcol) {
                    uae_u32 spcol = colors_for_drawing.acolors[sprcol];
                    out_val = spcol;
                }
            }
            buf[dpix++] = out_val;
            buf[dpix++] = out_val;
        }
    } else {
        while (dpix < dpix_end) {
            uae_u32 sprpix_val;
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix];
            sprpix_val = spix_val;
            dpix_val = colors_for_drawing.acolors[spix_val];
            spix++;
            out_val = dpix_val;
            if (spritepixels[dpix].data) {
                sprcol = render_sprites (dpix, 0, sprpix_val, 0);
                if (sprcol) {
                    uae_u32 spcol = colors_for_drawing.acolors[sprcol];
                    out_val = spcol;
                }
            }
            buf[dpix++] = out_val;
            buf[dpix++] = out_val;
        }
    }

    return spix;
}

static int NOINLINE __attribute__((__unused__)) linetoscr_16_stretch1_spr_genlock(int spix, int dpix, int dpix_end)
{
    uae_u16 *buf = (uae_u16 *) xlinebuffer;
    uae_u8 *genlock_buf = xlinebuffer_genlock;
    uae_u8 sprcol;

    if (bplham) {
        while (dpix < dpix_end) {
            uae_u32 sprpix_val;
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = ham_linebuf[spix];
            dpix_val = xcolors[spix_val];
            sprpix_val = pixdata.apixels[spix];
            spix++;
            out_val = dpix_val;
            genlock_buf[dpix] = get_genlock_transparency(spix_val & 15);
            genlock_buf[dpix + 1] = get_genlock_transparency(spix_val & 15);
            if (spritepixels[dpix].data) {
                sprcol = render_sprites (dpix, 0, sprpix_val, 0);
                    genlock_buf[dpix] = get_genlock_transparency(sprcol);
                if (sprcol) {
                    uae_u32 spcol = colors_for_drawing.acolors[sprcol];
                    out_val = spcol;
                }
            }
            buf[dpix++] = out_val;
            buf[dpix++] = out_val;
        }
    } else if (bpldualpf) {
        int *lookup = bpldualpfpri ? dblpf_ind2 : dblpf_ind1;
        while (dpix < dpix_end) {
            uae_u32 sprpix_val;
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix];
            sprpix_val = spix_val;
            dpix_val = colors_for_drawing.acolors[lookup[spix_val]];
            spix++;
            out_val = dpix_val;
            genlock_buf[dpix] = get_genlock_transparency(lookup[spix_val]);
            genlock_buf[dpix + 1] = get_genlock_transparency(lookup[spix_val]);
            if (spritepixels[dpix].data) {
                sprcol = render_sprites (dpix, 1, sprpix_val, 0);
                    genlock_buf[dpix] = get_genlock_transparency(sprcol);
                if (sprcol) {
                    uae_u32 spcol = colors_for_drawing.acolors[sprcol];
                    out_val = spcol;
                }
            }
            buf[dpix++] = out_val;
            buf[dpix++] = out_val;
        }
    } else if (bplehb) {
        while (dpix < dpix_end) {
            uae_u32 sprpix_val;
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix];
            sprpix_val = spix_val;
            if (spix_val <= 31)
                dpix_val = colors_for_drawing.acolors[spix_val];
            else
                dpix_val = xcolors[(colors_for_drawing.color_regs_ecs[spix_val - 32] >> 1) & 0x777];
            spix++;
            out_val = dpix_val;
            genlock_buf[dpix] = get_genlock_transparency(spix_val & 31);
            genlock_buf[dpix + 1] = get_genlock_transparency(spix_val & 31);
            if (spritepixels[dpix].data) {
                sprcol = render_sprites (dpix, 0, sprpix_val, 0);
                    genlock_buf[dpix] = get_genlock_transparency(sprcol);
                if (sprcol) {
                    uae_u32 spcol = colors_for_drawing.acolors[sprcol];
                    out_val = spcol;
                }
            }
            buf[dpix++] = out_val;
            buf[dpix++] = out_val;
        }
    } else {
        while (dpix < dpix_end) {
            uae_u32 sprpix_val;
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix];
            sprpix_val = spix_val;
            dpix_val = colors_for_drawing.acolors[spix_val];
            spix++;
            out_val = dpix_val;
            genlock_buf[dpix] = get_genlock_transparency(spix_val);
            genlock_buf[dpix + 1] = get_genlock_transparency(spix_val);
            if (spritepixels[dpix].data) {
                sprcol = render_sprites (dpix, 0, sprpix_val, 0);
                    genlock_buf[dpix] = get_genlock_transparency(sprcol);
                if (sprcol) {
                    uae_u32 spcol = colors_for_drawing.acolors[sprcol];
                    out_val = spcol;
                }
            }
            buf[dpix++] = out_val;
            buf[dpix++] = out_val;
        }
    }

    return spix;
}

static int NOINLINE __attribute__((__unused__)) linetoscr_16_stretch2_spr(int spix, int dpix, int dpix_end)
{
    uae_u16 *buf = (uae_u16 *) xlinebuffer;
    uae_u8 sprcol;

    if (bplham) {
        while (dpix < dpix_end) {
            uae_u32 sprpix_val;
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = ham_linebuf[spix];
            dpix_val = xcolors[spix_val];
            sprpix_val = pixdata.apixels[spix];
            spix++;
            out_val = dpix_val;
            if (spritepixels[dpix].data) {
                sprcol = render_sprites (dpix, 0, sprpix_val, 0);
                if (sprcol) {
                    uae_u32 spcol = colors_for_drawing.acolors[sprcol];
                    out_val = spcol;
                }
            }
            buf[dpix++] = out_val;
            buf[dpix++] = out_val;
            buf[dpix++] = out_val;
            buf[dpix++] = out_val;
        }
    } else if (bpldualpf) {
        int *lookup = bpldualpfpri ? dblpf_ind2 : dblpf_ind1;
        while (dpix < dpix_end) {
            uae_u32 sprpix_val;
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix];
            sprpix_val = spix_val;
            dpix_val = colors_for_drawing.acolors[lookup[spix_val]];
            spix++;
            out_val = dpix_val;
            if (spritepixels[dpix].data) {
                sprcol = render_sprites (dpix, 1, sprpix_val, 0);
                if (sprcol) {
                    uae_u32 spcol = colors_for_drawing.acolors[sprcol];
                    out_val = spcol;
                }
            }
            buf[dpix++] = out_val;
            buf[dpix++] = out_val;
            buf[dpix++] = out_val;
            buf[dpix++] = out_val;
        }
    } else if (bplehb) {
        while (dpix < dpix_end) {
            uae_u32 sprpix_val;
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix];
            sprpix_val = spix_val;
            if (spix_val <= 31)
                dpix_val = colors_for_drawing.acolors[spix_val];
            else
                dpix_val = xcolors[(colors_for_drawing.color_regs_ecs[spix_val - 32] >> 1) & 0x777];
            spix++;
            out_val = dpix_val;
            if (spritepixels[dpix].data) {
                sprcol = render_sprites (dpix, 0, sprpix_val, 0);
                if (sprcol) {
                    uae_u32 spcol = colors_for_drawing.acolors[sprcol];
                    out_val = spcol;
                }
            }
            buf[dpix++] = out_val;
            buf[dpix++] = out_val;
            buf[dpix++] = out_val;
            buf[dpix++] = out_val;
        }
    } else {
        while (dpix < dpix_end) {
            uae_u32 sprpix_val;
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix];
            sprpix_val = spix_val;
            dpix_val = colors_for_drawing.acolors[spix_val];
            spix++;
            out_val = dpix_val;
            if (spritepixels[dpix].data) {
                sprcol = render_sprites (dpix, 0, sprpix_val, 0);
                if (sprcol) {
                    uae_u32 spcol = colors_for_drawing.acolors[sprcol];
                    out_val = spcol;
                }
            }
            buf[dpix++] = out_val;
            buf[dpix++] = out_val;
            buf[dpix++] = out_val;
            buf[dpix++] = out_val;
        }
    }

    return spix;
}

static int NOINLINE __attribute__((__unused__)) linetoscr_16_stretch2_spr_genlock(int spix, int dpix, int dpix_end)
{
    uae_u16 *buf = (uae_u16 *) xlinebuffer;
    uae_u8 *genlock_buf = xlinebuffer_genlock;
    uae_u8 sprcol;

    if (bplham) {
        while (dpix < dpix_end) {
            uae_u32 sprpix_val;
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = ham_linebuf[spix];
            dpix_val = xcolors[spix_val];
            sprpix_val = pixdata.apixels[spix];
            spix++;
            out_val = dpix_val;
            genlock_buf[dpix] = get_genlock_transparency(spix_val & 15);
            genlock_buf[dpix + 1] = get_genlock_transparency(spix_val & 15);
            genlock_buf[dpix + 2] = get_genlock_transparency(spix_val & 15);
            genlock_buf[dpix + 3] = get_genlock_transparency(spix_val & 15);
            if (spritepixels[dpix].data) {
                sprcol = render_sprites (dpix, 0, sprpix_val, 0);
                    genlock_buf[dpix] = get_genlock_transparency(sprcol);
                if (sprcol) {
                    uae_u32 spcol = colors_for_drawing.acolors[sprcol];
                    out_val = spcol;
                }
            }
            buf[dpix++] = out_val;
            buf[dpix++] = out_val;
            buf[dpix++] = out_val;
            buf[dpix++] = out_val;
        }
    } else if (bpldualpf) {
        int *lookup = bpldualpfpri ? dblpf_ind2 : dblpf_ind1;
        while (dpix < dpix_end) {
            uae_u32 sprpix_val;
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix];
            sprpix_val = spix_val;
            dpix_val = colors_for_drawing.acolors[lookup[spix_val]];
            spix++;
            out_val = dpix_val;
            genlock_buf[dpix] = get_genlock_transparency(lookup[spix_val]);
            genlock_buf[dpix + 1] = get_genlock_transparency(lookup[spix_val]);
            genlock_buf[dpix + 2] = get_genlock_transparency(lookup[spix_val]);
            genlock_buf[dpix + 3] = get_genlock_transparency(lookup[spix_val]);
            if (spritepixels[dpix].data) {
                sprcol = render_sprites (dpix, 1, sprpix_val, 0);
                    genlock_buf[dpix] = get_genlock_transparency(sprcol);
                if (sprcol) {
                    uae_u32 spcol = colors_for_drawing.acolors[sprcol];
                    out_val = spcol;
                }
            }
            buf[dpix++] = out_val;
            buf[dpix++] = out_val;
            buf[dpix++] = out_val;
            buf[dpix++] = out_val;
        }
    } else if (bplehb) {
        while (dpix < dpix_end) {
            uae_u32 sprpix_val;
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix];
            sprpix_val = spix_val;
            if (spix_val <= 31)
                dpix_val = colors_for_drawing.acolors[spix_val];
            else
                dpix_val = xcolors[(colors_for_drawing.color_regs_ecs[spix_val - 32] >> 1) & 0x777];
            spix++;
            out_val = dpix_val;
            genlock_buf[dpix] = get_genlock_transparency(spix_val & 31);
            genlock_buf[dpix + 1] = get_genlock_transparency(spix_val & 31);
            genlock_buf[dpix + 2] = get_genlock_transparency(spix_val & 31);
            genlock_buf[dpix + 3] = get_genlock_transparency(spix_val & 31);
            if (spritepixels[dpix].data) {
                sprcol = render_sprites (dpix, 0, sprpix_val, 0);
                    genlock_buf[dpix] = get_genlock_transparency(sprcol);
                if (sprcol) {
                    uae_u32 spcol = colors_for_drawing.acolors[sprcol];
                    out_val = spcol;
                }
            }
            buf[dpix++] = out_val;
            buf[dpix++] = out_val;
            buf[dpix++] = out_val;
            buf[dpix++] = out_val;
        }
    } else {
        while (dpix < dpix_end) {
            uae_u32 sprpix_val;
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix];
            sprpix_val = spix_val;
            dpix_val = colors_for_drawing.acolors[spix_val];
            spix++;
            out_val = dpix_val;
            genlock_buf[dpix] = get_genlock_transparency(spix_val);
            genlock_buf[dpix + 1] = get_genlock_transparency(spix_val);
            genlock_buf[dpix + 2] = get_genlock_transparency(spix_val);
            genlock_buf[dpix + 3] = get_genlock_transparency(spix_val);
            if (spritepixels[dpix].data) {
                sprcol = render_sprites (dpix, 0, sprpix_val, 0);
                    genlock_buf[dpix] = get_genlock_transparency(sprcol);
                if (sprcol) {
                    uae_u32 spcol = colors_for_drawing.acolors[sprcol];
                    out_val = spcol;
                }
            }
            buf[dpix++] = out_val;
            buf[dpix++] = out_val;
            buf[dpix++] = out_val;
            buf[dpix++] = out_val;
        }
    }

    return spix;
}

static int NOINLINE __attribute__((__unused__)) linetoscr_16_shrink1_spr(int spix, int dpix, int dpix_end)
{
    uae_u16 *buf = (uae_u16 *) xlinebuffer;
    uae_u8 sprcol;

    if (bplham) {
        while (dpix < dpix_end) {
            uae_u32 sprpix_val;
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = ham_linebuf[spix];
            dpix_val = xcolors[spix_val];
            sprpix_val = pixdata.apixels[spix];
            spix += 2;
            out_val = dpix_val;
            if (spritepixels[dpix].data) {
                sprcol = render_sprites (dpix, 0, sprpix_val, 0);
                if (sprcol) {
                    uae_u32 spcol = colors_for_drawing.acolors[sprcol];
                    out_val = spcol;
                }
            }
            buf[dpix++] = out_val;
        }
    } else if (bpldualpf) {
        int *lookup = bpldualpfpri ? dblpf_ind2 : dblpf_ind1;
        while (dpix < dpix_end) {
            uae_u32 sprpix_val;
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix];
            sprpix_val = spix_val;
            dpix_val = colors_for_drawing.acolors[lookup[spix_val]];
            spix += 2;
            out_val = dpix_val;
            if (spritepixels[dpix].data) {
                sprcol = render_sprites (dpix, 1, sprpix_val, 0);
                if (sprcol) {
                    uae_u32 spcol = colors_for_drawing.acolors[sprcol];
                    out_val = spcol;
                }
            }
            buf[dpix++] = out_val;
        }
    } else if (bplehb) {
        while (dpix < dpix_end) {
            uae_u32 sprpix_val;
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix];
            sprpix_val = spix_val;
            if (spix_val <= 31)
                dpix_val = colors_for_drawing.acolors[spix_val];
            else
                dpix_val = xcolors[(colors_for_drawing.color_regs_ecs[spix_val - 32] >> 1) & 0x777];
            spix += 2;
            out_val = dpix_val;
            if (spritepixels[dpix].data) {
                sprcol = render_sprites (dpix, 0, sprpix_val, 0);
                if (sprcol) {
                    uae_u32 spcol = colors_for_drawing.acolors[sprcol];
                    out_val = spcol;
                }
            }
            buf[dpix++] = out_val;
        }
    } else {
        while (dpix < dpix_end) {
            uae_u32 sprpix_val;
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix];
            sprpix_val = spix_val;
            dpix_val = colors_for_drawing.acolors[spix_val];
            spix += 2;
            out_val = dpix_val;
            if (spritepixels[dpix].data) {
                sprcol = render_sprites (dpix, 0, sprpix_val, 0);
                if (sprcol) {
                    uae_u32 spcol = colors_for_drawing.acolors[sprcol];
                    out_val = spcol;
                }
            }
            buf[dpix++] = out_val;
        }
    }

    return spix;
}

static int NOINLINE __attribute__((__unused__)) linetoscr_16_shrink1_spr_genlock(int spix, int dpix, int dpix_end)
{
    uae_u16 *buf = (uae_u16 *) xlinebuffer;
    uae_u8 *genlock_buf = xlinebuffer_genlock;
    uae_u8 sprcol;

    if (bplham) {
        while (dpix < dpix_end) {
            uae_u32 sprpix_val;
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = ham_linebuf[spix];
            dpix_val = xcolors[spix_val];
            sprpix_val = pixdata.apixels[spix];
            spix += 2;
            out_val = dpix_val;
            genlock_buf[dpix] = get_genlock_transparency(spix_val & 15);
            if (spritepixels[dpix].data) {
                sprcol = render_sprites (dpix, 0, sprpix_val, 0);
                    genlock_buf[dpix] = get_genlock_transparency(sprcol);
                if (sprcol) {
                    uae_u32 spcol = colors_for_drawing.acolors[sprcol];
                    out_val = spcol;
                }
            }
            buf[dpix++] = out_val;
        }
    } else if (bpldualpf) {
        int *lookup = bpldualpfpri ? dblpf_ind2 : dblpf_ind1;
        while (dpix < dpix_end) {
            uae_u32 sprpix_val;
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix];
            sprpix_val = spix_val;
            dpix_val = colors_for_drawing.acolors[lookup[spix_val]];
            spix += 2;
            out_val = dpix_val;
            genlock_buf[dpix] = get_genlock_transparency(lookup[spix_val]);
            if (spritepixels[dpix].data) {
                sprcol = render_sprites (dpix, 1, sprpix_val, 0);
                    genlock_buf[dpix] = get_genlock_transparency(sprcol);
                if (sprcol) {
                    uae_u32 spcol = colors_for_drawing.acolors[sprcol];
                    out_val = spcol;
                }
            }
            buf[dpix++] = out_val;
        }
    } else if (bplehb) {
        while (dpix < dpix_end) {
            uae_u32 sprpix_val;
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix];
            sprpix_val = spix_val;
            if (spix_val <= 31)
                dpix_val = colors_for_drawing.acolors[spix_val];
            else
                dpix_val = xcolors[(colors_for_drawing.color_regs_ecs[spix_val - 32] >> 1) & 0x777];
            spix += 2;
            out_val = dpix_val;
            genlock_buf[dpix] = get_genlock_transparency(spix_val & 31);
            if (spritepixels[dpix].data) {
                sprcol = render_sprites (dpix, 0, sprpix_val, 0);
                    genlock_buf[dpix] = get_genlock_transparency(sprcol);
                if (sprcol) {
                    uae_u32 spcol = colors_for_drawing.acolors[sprcol];
                    out_val = spcol;
                }
            }
            buf[dpix++] = out_val;
        }
    } else {
        while (dpix < dpix_end) {
            uae_u32 sprpix_val;
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix];
            sprpix_val = spix_val;
            dpix_val = colors_for_drawing.acolors[spix_val];
            spix += 2;
            out_val = dpix_val;
            genlock_buf[dpix] = get_genlock_transparency(spix_val);
            if (spritepixels[dpix].data) {
                sprcol = render_sprites (dpix, 0, sprpix_val, 0);
                    genlock_buf[dpix] = get_genlock_transparency(sprcol);
                if (sprcol) {
                    uae_u32 spcol = colors_for_drawing.acolors[sprcol];
                    out_val = spcol;
                }
            }
            buf[dpix++] = out_val;
        }
    }

    return spix;
}

static int NOINLINE __attribute__((__unused__)) linetoscr_16_shrink1f_spr(int spix, int dpix, int dpix_end)
{
    uae_u16 *buf = (uae_u16 *) xlinebuffer;
    uae_u8 sprcol;

    if (bplham) {
        while (dpix < dpix_end) {
            uae_u32 sprpix_val;
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = ham_linebuf[spix];
            dpix_val = xcolors[spix_val];
            sprpix_val = pixdata.apixels[spix];
            {
            uae_u32 tmp_val;
            spix++;
            tmp_val = dpix_val;
            spix_val = ham_linebuf[spix];
            dpix_val = xcolors[spix_val];
            sprpix_val = pixdata.apixels[spix];
            dpix_val = merge_2pixel16 (dpix_val, tmp_val);
            spix++;
            }
            out_val = dpix_val;
            if (spritepixels[dpix].data) {
                sprcol = render_sprites (dpix, 0, sprpix_val, 0);
                if (sprcol) {
                    uae_u32 spcol = colors_for_drawing.acolors[sprcol];
                    out_val = spcol;
                }
            }
            buf[dpix++] = out_val;
        }
    } else if (bpldualpf) {
        int *lookup = bpldualpfpri ? dblpf_ind2 : dblpf_ind1;
        while (dpix < dpix_end) {
            uae_u32 sprpix_val;
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix];
            sprpix_val = spix_val;
            dpix_val = colors_for_drawing.acolors[lookup[spix_val]];
            {
            uae_u32 tmp_val;
            spix++;
            tmp_val = dpix_val;
            spix_val = pixdata.apixels[spix];
            sprpix_val = spix_val;
            dpix_val = colors_for_drawing.acolors[lookup[spix_val]];
            dpix_val = merge_2pixel16 (dpix_val, tmp_val);
            spix++;
            }
            out_val = dpix_val;
            if (spritepixels[dpix].data) {
                sprcol = render_sprites (dpix, 1, sprpix_val, 0);
                if (sprcol) {
                    uae_u32 spcol = colors_for_drawing.acolors[sprcol];
                    out_val = spcol;
                }
            }
            buf[dpix++] = out_val;
        }
    } else if (bplehb) {
        while (dpix < dpix_end) {
            uae_u32 sprpix_val;
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix];
            sprpix_val = spix_val;
            if (spix_val <= 31)
                dpix_val = colors_for_drawing.acolors[spix_val];
            else
                dpix_val = xcolors[(colors_for_drawing.color_regs_ecs[spix_val - 32] >> 1) & 0x777];
            {
            uae_u32 tmp_val;
            spix++;
            tmp_val = dpix_val;
            spix_val = pixdata.apixels[spix];
            sprpix_val = spix_val;
            if (spix_val <= 31)
                dpix_val = colors_for_drawing.acolors[spix_val];
            else
                dpix_val = xcolors[(colors_for_drawing.color_regs_ecs[spix_val - 32] >> 1) & 0x777];
            dpix_val = merge_2pixel16 (dpix_val, tmp_val);
            spix++;
            }
            out_val = dpix_val;
            if (spritepixels[dpix].data) {
                sprcol = render_sprites (dpix, 0, sprpix_val, 0);
                if (sprcol) {
                    uae_u32 spcol = colors_for_drawing.acolors[sprcol];
                    out_val = spcol;
                }
            }
            buf[dpix++] = out_val;
        }
    } else {
        while (dpix < dpix_end) {
            uae_u32 sprpix_val;
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix];
            sprpix_val = spix_val;
            dpix_val = colors_for_drawing.acolors[spix_val];
            {
            uae_u32 tmp_val;
            spix++;
            tmp_val = dpix_val;
            spix_val = pixdata.apixels[spix];
            sprpix_val = spix_val;
            dpix_val = colors_for_drawing.acolors[spix_val];
            dpix_val = merge_2pixel16 (dpix_val, tmp_val);
            spix++;
            }
            out_val = dpix_val;
            if (spritepixels[dpix].data) {
                sprcol = render_sprites (dpix, 0, sprpix_val, 0);
                if (sprcol) {
                    uae_u32 spcol = colors_for_drawing.acolors[sprcol];
                    out_val = spcol;
                }
            }
            buf[dpix++] = out_val;
        }
    }

    return spix;
}

static int NOINLINE __attribute__((__unused__)) linetoscr_16_shrink1f_spr_genlock(int spix, int dpix, int dpix_end)
{
    uae_u16 *buf = (uae_u16 *) xlinebuffer;
    uae_u8 *genlock_buf = xlinebuffer_genlock;
    uae_u8 sprcol;

    if (bplham) {
        while (dpix < dpix_end) {
            uae_u32 sprpix_val;
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = ham_linebuf[spix];
            dpix_val = xcolors[spix_val];
            sprpix_val = pixdata.apixels[spix];
            {
            uae_u32 tmp_val;
            spix++;
            tmp_val = dpix_val;
            spix_val = ham_linebuf[spix];
            dpix_val = xcolors[spix_val];
            sprpix_val = pixdata.apixels[spix];
            dpix_val = merge_2pixel16 (dpix_val, tmp_val);
            spix++;
            }
            out_val = dpix_val;
            genlock_buf[dpix] = get_genlock_transparency(spix_val & 15);
            if (spritepixels[dpix].data) {
                sprcol = render_sprites (dpix, 0, sprpix_val, 0);
                    genlock_buf[dpix] = get_genlock_transparency(sprcol);
                if (sprcol) {
                    uae_u32 spcol = colors_for_drawing.acolors[sprcol];
                    out_val = spcol;
                }
            }
            buf[dpix++] = out_val;
        }
    } else if (bpldualpf) {
        int *lookup = bpldualpfpri ? dblpf_ind2 : dblpf_ind1;
        while (dpix < dpix_end) {
            uae_u32 sprpix_val;
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix];
            sprpix_val = spix_val;
            dpix_val = colors_for_drawing.acolors[lookup[spix_val]];
            {
            uae_u32 tmp_val;
            spix++;
            tmp_val = dpix_val;
            spix_val = pixdata.apixels[spix];
            sprpix_val = spix_val;
            dpix_val = colors_for_drawing.acolors[lookup[spix_val]];
            dpix_val = merge_2pixel16 (dpix_val, tmp_val);
            spix++;
            }
            out_val = dpix_val;
            genlock_buf[dpix] = get_genlock_transparency(lookup[spix_val]);
            if (spritepixels[dpix].data) {
                sprcol = render_sprites (dpix, 1, sprpix_val, 0);
                    genlock_buf[dpix] = get_genlock_transparency(sprcol);
                if (sprcol) {
                    uae_u32 spcol = colors_for_drawing.acolors[sprcol];
                    out_val = spcol;
                }
            }
            buf[dpix++] = out_val;
        }
    } else if (bplehb) {
        while (dpix < dpix_end) {
            uae_u32 sprpix_val;
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix];
            sprpix_val = spix_val;
            if (spix_val <= 31)
                dpix_val = colors_for_drawing.acolors[spix_val];
            else
                dpix_val = xcolors[(colors_for_drawing.color_regs_ecs[spix_val - 32] >> 1) & 0x777];
            {
            uae_u32 tmp_val;
            spix++;
            tmp_val = dpix_val;
            spix_val = pixdata.apixels[spix];
            sprpix_val = spix_val;
            if (spix_val <= 31)
                dpix_val = colors_for_drawing.acolors[spix_val];
            else
                dpix_val = xcolors[(colors_for_drawing.color_regs_ecs[spix_val - 32] >> 1) & 0x777];
            dpix_val = merge_2pixel16 (dpix_val, tmp_val);
            spix++;
            }
            out_val = dpix_val;
            genlock_buf[dpix] = get_genlock_transparency(spix_val & 31);
            if (spritepixels[dpix].data) {
                sprcol = render_sprites (dpix, 0, sprpix_val, 0);
                    genlock_buf[dpix] = get_genlock_transparency(sprcol);
                if (sprcol) {
                    uae_u32 spcol = colors_for_drawing.acolors[sprcol];
                    out_val = spcol;
                }
            }
            buf[dpix++] = out_val;
        }
    } else {
        while (dpix < dpix_end) {
            uae_u32 sprpix_val;
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix];
            sprpix_val = spix_val;
            dpix_val = colors_for_drawing.acolors[spix_val];
            {
            uae_u32 tmp_val;
            spix++;
            tmp_val = dpix_val;
            spix_val = pixdata.apixels[spix];
            sprpix_val = spix_val;
            dpix_val = colors_for_drawing.acolors[spix_val];
            dpix_val = merge_2pixel16 (dpix_val, tmp_val);
            spix++;
            }
            out_val = dpix_val;
            genlock_buf[dpix] = get_genlock_transparency(spix_val);
            if (spritepixels[dpix].data) {
                sprcol = render_sprites (dpix, 0, sprpix_val, 0);
                    genlock_buf[dpix] = get_genlock_transparency(sprcol);
                if (sprcol) {
                    uae_u32 spcol = colors_for_drawing.acolors[sprcol];
                    out_val = spcol;
                }
            }
            buf[dpix++] = out_val;
        }
    }

    return spix;
}

static int NOINLINE __attribute__((__unused__)) linetoscr_16_shrink2_spr(int spix, int dpix, int dpix_end)
{
    uae_u16 *buf = (uae_u16 *) xlinebuffer;
    uae_u8 sprcol;

    if (bplham) {
        while (dpix < dpix_end) {
            uae_u32 sprpix_val;
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = ham_linebuf[spix];
            dpix_val = xcolors[spix_val];
            sprpix_val = pixdata.apixels[spix];
            spix += 4;
            out_val = dpix_val;
            if (spritepixels[dpix].data) {
                sprcol = render_sprites (dpix, 0, sprpix_val, 0);
                if (sprcol) {
                    uae_u32 spcol = colors_for_drawing.acolors[sprcol];
                    out_val = spcol;
                }
            }
            buf[dpix++] = out_val;
        }
    } else if (bpldualpf) {
        int *lookup = bpldualpfpri ? dblpf_ind2 : dblpf_ind1;
        while (dpix < dpix_end) {
            uae_u32 sprpix_val;
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix];
            sprpix_val = spix_val;
            dpix_val = colors_for_drawing.acolors[lookup[spix_val]];
            spix += 4;
            out_val = dpix_val;
            if (spritepixels[dpix].data) {
                sprcol = render_sprites (dpix, 1, sprpix_val, 0);
                if (sprcol) {
                    uae_u32 spcol = colors_for_drawing.acolors[sprcol];
                    out_val = spcol;
                }
            }
            buf[dpix++] = out_val;
        }
    } else if (bplehb) {
        while (dpix < dpix_end) {
            uae_u32 sprpix_val;
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix];
            sprpix_val = spix_val;
            if (spix_val <= 31)
                dpix_val = colors_for_drawing.acolors[spix_val];
            else
                dpix_val = xcolors[(colors_for_drawing.color_regs_ecs[spix_val - 32] >> 1) & 0x777];
            spix += 4;
            out_val = dpix_val;
            if (spritepixels[dpix].data) {
                sprcol = render_sprites (dpix, 0, sprpix_val, 0);
                if (sprcol) {
                    uae_u32 spcol = colors_for_drawing.acolors[sprcol];
                    out_val = spcol;
                }
            }
            buf[dpix++] = out_val;
        }
    } else {
        while (dpix < dpix_end) {
            uae_u32 sprpix_val;
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix];
            sprpix_val = spix_val;
            dpix_val = colors_for_drawing.acolors[spix_val];
            spix += 4;
            out_val = dpix_val;
            if (spritepixels[dpix].data) {
                sprcol = render_sprites (dpix, 0, sprpix_val, 0);
                if (sprcol) {
                    uae_u32 spcol = colors_for_drawing.acolors[sprcol];
                    out_val = spcol;
                }
            }
            buf[dpix++] = out_val;
        }
    }

    return spix;
}

static int NOINLINE __attribute__((__unused__)) linetoscr_16_shrink2_spr_genlock(int spix, int dpix, int dpix_end)
{
    uae_u16 *buf = (uae_u16 *) xlinebuffer;
    uae_u8 *genlock_buf = xlinebuffer_genlock;
    uae_u8 sprcol;

    if (bplham) {
        while (dpix < dpix_end) {
            uae_u32 sprpix_val;
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = ham_linebuf[spix];
            dpix_val = xcolors[spix_val];
            sprpix_val = pixdata.apixels[spix];
            spix += 4;
            out_val = dpix_val;
            genlock_buf[dpix] = get_genlock_transparency(spix_val & 15);
            if (spritepixels[dpix].data) {
                sprcol = render_sprites (dpix, 0, sprpix_val, 0);
                    genlock_buf[dpix] = get_genlock_transparency(sprcol);
                if (sprcol) {
                    uae_u32 spcol = colors_for_drawing.acolors[sprcol];
                    out_val = spcol;
                }
            }
            buf[dpix++] = out_val;
        }
    } else if (bpldualpf) {
        int *lookup = bpldualpfpri ? dblpf_ind2 : dblpf_ind1;
        while (dpix < dpix_end) {
            uae_u32 sprpix_val;
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix];
            sprpix_val = spix_val;
            dpix_val = colors_for_drawing.acolors[lookup[spix_val]];
            spix += 4;
            out_val = dpix_val;
            genlock_buf[dpix] = get_genlock_transparency(lookup[spix_val]);
            if (spritepixels[dpix].data) {
                sprcol = render_sprites (dpix, 1, sprpix_val, 0);
                    genlock_buf[dpix] = get_genlock_transparency(sprcol);
                if (sprcol) {
                    uae_u32 spcol = colors_for_drawing.acolors[sprcol];
                    out_val = spcol;
                }
            }
            buf[dpix++] = out_val;
        }
    } else if (bplehb) {
        while (dpix < dpix_end) {
            uae_u32 sprpix_val;
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix];
            sprpix_val = spix_val;
            if (spix_val <= 31)
                dpix_val = colors_for_drawing.acolors[spix_val];
            else
                dpix_val = xcolors[(colors_for_drawing.color_regs_ecs[spix_val - 32] >> 1) & 0x777];
            spix += 4;
            out_val = dpix_val;
            genlock_buf[dpix] = get_genlock_transparency(spix_val & 31);
            if (spritepixels[dpix].data) {
                sprcol = render_sprites (dpix, 0, sprpix_val, 0);
                    genlock_buf[dpix] = get_genlock_transparency(sprcol);
                if (sprcol) {
                    uae_u32 spcol = colors_for_drawing.acolors[sprcol];
                    out_val = spcol;
                }
            }
            buf[dpix++] = out_val;
        }
    } else {
        while (dpix < dpix_end) {
            uae_u32 sprpix_val;
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix];
            sprpix_val = spix_val;
            dpix_val = colors_for_drawing.acolors[spix_val];
            spix += 4;
            out_val = dpix_val;
            genlock_buf[dpix] = get_genlock_transparency(spix_val);
            if (spritepixels[dpix].data) {
                sprcol = render_sprites (dpix, 0, sprpix_val, 0);
                    genlock_buf[dpix] = get_genlock_transparency(sprcol);
                if (sprcol) {
                    uae_u32 spcol = colors_for_drawing.acolors[sprcol];
                    out_val = spcol;
                }
            }
            buf[dpix++] = out_val;
        }
    }

    return spix;
}

static int NOINLINE __attribute__((__unused__)) linetoscr_16_shrink2f_spr(int spix, int dpix, int dpix_end)
{
    uae_u16 *buf = (uae_u16 *) xlinebuffer;
    uae_u8 sprcol;

    if (bplham) {
        while (dpix < dpix_end) {
            uae_u32 sprpix_val;
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = ham_linebuf[spix];
            dpix_val = xcolors[spix_val];
            sprpix_val = pixdata.apixels[spix];
            {
            uae_u32 tmp_val, tmp_val2, tmp_val3;
            spix++;
            tmp_val = dpix_val;
            spix_val = ham_linebuf[spix];
            dpix_val = xcolors[spix_val];
            sprpix_val = pixdata.apixels[spix];
            spix++;
            tmp_val2 = dpix_val;
            spix_val = ham_linebuf[spix];
            dpix_val = xcolors[spix_val];
            sprpix_val = pixdata.apixels[spix];
            spix++;
            tmp_val3 = dpix_val;
            spix_val = ham_linebuf[spix];
            dpix_val = xcolors[spix_val];
            sprpix_val = pixdata.apixels[spix];
            tmp_val = merge_2pixel16 (tmp_val, tmp_val2);
            tmp_val2 = merge_2pixel16 (tmp_val3, dpix_val);
            dpix_val = merge_2pixel16 (tmp_val, tmp_val2);
            spix++;
            }
            out_val = dpix_val;
            if (spritepixels[dpix].data) {
                sprcol = render_sprites (dpix, 0, sprpix_val, 0);
                if (sprcol) {
                    uae_u32 spcol = colors_for_drawing.acolors[sprcol];
                    out_val = spcol;
                }
            }
            buf[dpix++] = out_val;
        }
    } else if (bpldualpf) {
        int *lookup = bpldualpfpri ? dblpf_ind2 : dblpf_ind1;
        while (dpix < dpix_end) {
            uae_u32 sprpix_val;
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix];
            sprpix_val = spix_val;
            dpix_val = colors_for_drawing.acolors[lookup[spix_val]];
            {
            uae_u32 tmp_val, tmp_val2, tmp_val3;
            spix++;
            tmp_val = dpix_val;
            spix_val = pixdata.apixels[spix];
            sprpix_val = spix_val;
            dpix_val = colors_for_drawing.acolors[lookup[spix_val]];
            spix++;
            tmp_val2 = dpix_val;
            spix_val = pixdata.apixels[spix];
            sprpix_val = spix_val;
            dpix_val = colors_for_drawing.acolors[lookup[spix_val]];
            spix++;
            tmp_val3 = dpix_val;
            spix_val = pixdata.apixels[spix];
            sprpix_val = spix_val;
            dpix_val = colors_for_drawing.acolors[lookup[spix_val]];
            tmp_val = merge_2pixel16 (tmp_val, tmp_val2);
            tmp_val2 = merge_2pixel16 (tmp_val3, dpix_val);
            dpix_val = merge_2pixel16 (tmp_val, tmp_val2);
            spix++;
            }
            out_val = dpix_val;
            if (spritepixels[dpix].data) {
                sprcol = render_sprites (dpix, 1, sprpix_val, 0);
                if (sprcol) {
                    uae_u32 spcol = colors_for_drawing.acolors[sprcol];
                    out_val = spcol;
                }
            }
            buf[dpix++] = out_val;
        }
    } else if (bplehb) {
        while (dpix < dpix_end) {
            uae_u32 sprpix_val;
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix];
            sprpix_val = spix_val;
            if (spix_val <= 31)
                dpix_val = colors_for_drawing.acolors[spix_val];
            else
                dpix_val = xcolors[(colors_for_drawing.color_regs_ecs[spix_val - 32] >> 1) & 0x777];
            {
            uae_u32 tmp_val, tmp_val2, tmp_val3;
            spix++;
            tmp_val = dpix_val;
            spix_val = pixdata.apixels[spix];
            sprpix_val = spix_val;
            if (spix_val <= 31)
                dpix_val = colors_for_drawing.acolors[spix_val];
            else
                dpix_val = xcolors[(colors_for_drawing.color_regs_ecs[spix_val - 32] >> 1) & 0x777];
            spix++;
            tmp_val2 = dpix_val;
            spix_val = pixdata.apixels[spix];
            sprpix_val = spix_val;
            if (spix_val <= 31)
                dpix_val = colors_for_drawing.acolors[spix_val];
            else
                dpix_val = xcolors[(colors_for_drawing.color_regs_ecs[spix_val - 32] >> 1) & 0x777];
            spix++;
            tmp_val3 = dpix_val;
            spix_val = pixdata.apixels[spix];
            sprpix_val = spix_val;
            if (spix_val <= 31)
                dpix_val = colors_for_drawing.acolors[spix_val];
            else
                dpix_val = xcolors[(colors_for_drawing.color_regs_ecs[spix_val - 32] >> 1) & 0x777];
            tmp_val = merge_2pixel16 (tmp_val, tmp_val2);
            tmp_val2 = merge_2pixel16 (tmp_val3, dpix_val);
            dpix_val = merge_2pixel16 (tmp_val, tmp_val2);
            spix++;
            }
            out_val = dpix_val;
            if (spritepixels[dpix].data) {
                sprcol = render_sprites (dpix, 0, sprpix_val, 0);
                if (sprcol) {
                    uae_u32 spcol = colors_for_drawing.acolors[sprcol];
                    out_val = spcol;
                }
            }
            buf[dpix++] = out_val;
        }
    } else {
        while (dpix < dpix_end) {
            uae_u32 sprpix_val;
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix];
            sprpix_val = spix_val;
            dpix_val = colors_for_drawing.acolors[spix_val];
            {
            uae_u32 tmp_val, tmp_val2, tmp_val3;
            spix++;
            tmp_val = dpix_val;
            spix_val = pixdata.apixels[spix];
            sprpix_val = spix_val;
            dpix_val = colors_for_drawing.acolors[spix_val];
            spix++;
            tmp_val2 = dpix_val;
            spix_val = pixdata.apixels[spix];
            sprpix_val = spix_val;
            dpix_val = colors_for_drawing.acolors[spix_val];
            spix++;
            tmp_val3 = dpix_val;
            spix_val = pixdata.apixels[spix];
            sprpix_val = spix_val;
            dpix_val = colors_for_drawing.acolors[spix_val];
            tmp_val = merge_2pixel16 (tmp_val, tmp_val2);
            tmp_val2 = merge_2pixel16 (tmp_val3, dpix_val);
            dpix_val = merge_2pixel16 (tmp_val, tmp_val2);
            spix++;
            }
            out_val = dpix_val;
            if (spritepixels[dpix].data) {
                sprcol = render_sprites (dpix, 0, sprpix_val, 0);
                if (sprcol) {
                    uae_u32 spcol = colors_for_drawing.acolors[sprcol];
                    out_val = spcol;
                }
            }
            buf[dpix++] = out_val;
        }
    }

    return spix;
}

static int NOINLINE __attribute__((__unused__)) linetoscr_16_shrink2f_spr_genlock(int spix, int dpix, int dpix_end)
{
    uae_u16 *buf = (uae_u16 *) xlinebuffer;
    uae_u8 *genlock_buf = xlinebuffer_genlock;
    uae_u8 sprcol;

    if (bplham) {
        while (dpix < dpix_end) {
            uae_u32 sprpix_val;
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = ham_linebuf[spix];
            dpix_val = xcolors[spix_val];
            sprpix_val = pixdata.apixels[spix];
            {
            uae_u32 tmp_val, tmp_val2, tmp_val3;
            spix++;
            tmp_val = dpix_val;
            spix_val = ham_linebuf[spix];
            dpix_val = xcolors[spix_val];
            sprpix_val = pixdata.apixels[spix];
            spix++;
            tmp_val2 = dpix_val;
            spix_val = ham_linebuf[spix];
            dpix_val = xcolors[spix_val];
            sprpix_val = pixdata.apixels[spix];
            spix++;
            tmp_val3 = dpix_val;
            spix_val = ham_linebuf[spix];
            dpix_val = xcolors[spix_val];
            sprpix_val = pixdata.apixels[spix];
            tmp_val = merge_2pixel16 (tmp_val, tmp_val2);
            tmp_val2 = merge_2pixel16 (tmp_val3, dpix_val);
            dpix_val = merge_2pixel16 (tmp_val, tmp_val2);
            spix++;
            }
            out_val = dpix_val;
            genlock_buf[dpix] = get_genlock_transparency(spix_val & 15);
            if (spritepixels[dpix].data) {
                sprcol = render_sprites (dpix, 0, sprpix_val, 0);
                    genlock_buf[dpix] = get_genlock_transparency(sprcol);
                if (sprcol) {
                    uae_u32 spcol = colors_for_drawing.acolors[sprcol];
                    out_val = spcol;
                }
            }
            buf[dpix++] = out_val;
        }
    } else if (bpldualpf) {
        int *lookup = bpldualpfpri ? dblpf_ind2 : dblpf_ind1;
        while (dpix < dpix_end) {
            uae_u32 sprpix_val;
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix];
            sprpix_val = spix_val;
            dpix_val = colors_for_drawing.acolors[lookup[spix_val]];
            {
            uae_u32 tmp_val, tmp_val2, tmp_val3;
            spix++;
            tmp_val = dpix_val;
            spix_val = pixdata.apixels[spix];
            sprpix_val = spix_val;
            dpix_val = colors_for_drawing.acolors[lookup[spix_val]];
            spix++;
            tmp_val2 = dpix_val;
            spix_val = pixdata.apixels[spix];
            sprpix_val = spix_val;
            dpix_val = colors_for_drawing.acolors[lookup[spix_val]];
            spix++;
            tmp_val3 = dpix_val;
            spix_val = pixdata.apixels[spix];
            sprpix_val = spix_val;
            dpix_val = colors_for_drawing.acolors[lookup[spix_val]];
            tmp_val = merge_2pixel16 (tmp_val, tmp_val2);
            tmp_val2 = merge_2pixel16 (tmp_val3, dpix_val);
            dpix_val = merge_2pixel16 (tmp_val, tmp_val2);
            spix++;
            }
            out_val = dpix_val;
            genlock_buf[dpix] = get_genlock_transparency(lookup[spix_val]);
            if (spritepixels[dpix].data) {
                sprcol = render_sprites (dpix, 1, sprpix_val, 0);
                    genlock_buf[dpix] = get_genlock_transparency(sprcol);
                if (sprcol) {
                    uae_u32 spcol = colors_for_drawing.acolors[sprcol];
                    out_val = spcol;
                }
            }
            buf[dpix++] = out_val;
        }
    } else if (bplehb) {
        while (dpix < dpix_end) {
            uae_u32 sprpix_val;
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix];
            sprpix_val = spix_val;
            if (spix_val <= 31)
                dpix_val = colors_for_drawing.acolors[spix_val];
            else
                dpix_val = xcolors[(colors_for_drawing.color_regs_ecs[spix_val - 32] >> 1) & 0x777];
            {
            uae_u32 tmp_val, tmp_val2, tmp_val3;
            spix++;
            tmp_val = dpix_val;
            spix_val = pixdata.apixels[spix];
            sprpix_val = spix_val;
            if (spix_val <= 31)
                dpix_val = colors_for_drawing.acolors[spix_val];
            else
                dpix_val = xcolors[(colors_for_drawing.color_regs_ecs[spix_val - 32] >> 1) & 0x777];
            spix++;
            tmp_val2 = dpix_val;
            spix_val = pixdata.apixels[spix];
            sprpix_val = spix_val;
            if (spix_val <= 31)
                dpix_val = colors_for_drawing.acolors[spix_val];
            else
                dpix_val = xcolors[(colors_for_drawing.color_regs_ecs[spix_val - 32] >> 1) & 0x777];
            spix++;
            tmp_val3 = dpix_val;
            spix_val = pixdata.apixels[spix];
            sprpix_val = spix_val;
            if (spix_val <= 31)
                dpix_val = colors_for_drawing.acolors[spix_val];
            else
                dpix_val = xcolors[(colors_for_drawing.color_regs_ecs[spix_val - 32] >> 1) & 0x777];
            tmp_val = merge_2pixel16 (tmp_val, tmp_val2);
            tmp_val2 = merge_2pixel16 (tmp_val3, dpix_val);
            dpix_val = merge_2pixel16 (tmp_val, tmp_val2);
            spix++;
            }
            out_val = dpix_val;
            genlock_buf[dpix] = get_genlock_transparency(spix_val & 31);
            if (spritepixels[dpix].data) {
                sprcol = render_sprites (dpix, 0, sprpix_val, 0);
                    genlock_buf[dpix] = get_genlock_transparency(sprcol);
                if (sprcol) {
                    uae_u32 spcol = colors_for_drawing.acolors[sprcol];
                    out_val = spcol;
                }
            }
            buf[dpix++] = out_val;
        }
    } else {
        while (dpix < dpix_end) {
            uae_u32 sprpix_val;
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix];
            sprpix_val = spix_val;
            dpix_val = colors_for_drawing.acolors[spix_val];
            {
            uae_u32 tmp_val, tmp_val2, tmp_val3;
            spix++;
            tmp_val = dpix_val;
            spix_val = pixdata.apixels[spix];
            sprpix_val = spix_val;
            dpix_val = colors_for_drawing.acolors[spix_val];
            spix++;
            tmp_val2 = dpix_val;
            spix_val = pixdata.apixels[spix];
            sprpix_val = spix_val;
            dpix_val = colors_for_drawing.acolors[spix_val];
            spix++;
            tmp_val3 = dpix_val;
            spix_val = pixdata.apixels[spix];
            sprpix_val = spix_val;
            dpix_val = colors_for_drawing.acolors[spix_val];
            tmp_val = merge_2pixel16 (tmp_val, tmp_val2);
            tmp_val2 = merge_2pixel16 (tmp_val3, dpix_val);
            dpix_val = merge_2pixel16 (tmp_val, tmp_val2);
            spix++;
            }
            out_val = dpix_val;
            genlock_buf[dpix] = get_genlock_transparency(spix_val);
            if (spritepixels[dpix].data) {
                sprcol = render_sprites (dpix, 0, sprpix_val, 0);
                    genlock_buf[dpix] = get_genlock_transparency(sprcol);
                if (sprcol) {
                    uae_u32 spcol = colors_for_drawing.acolors[sprcol];
                    out_val = spcol;
                }
            }
            buf[dpix++] = out_val;
        }
    }

    return spix;
}

#ifdef AGA
static int NOINLINE __attribute__((__unused__)) linetoscr_16_aga_spronly(int spix, int dpix, int dpix_end)
{
    uae_u16 *buf = (uae_u16 *) xlinebuffer;
    uae_u8 sprcol;

    if (1) {
        while (dpix < dpix_end) {
            uae_u32 sprpix_val;
            uae_u32 out_val;
        
            sprpix_val = 0;
            spix++;
            out_val = colors_for_drawing.acolors[0];
            if (spritepixels[dpix].data) {
                sprcol = render_sprites (dpix + 0, 0, sprpix_val, 1);
                if (sprcol) {
                    out_val = colors_for_drawing.acolors[sprcol];
                }
            }
            buf[dpix++] = out_val;
        }
    }

    return spix;
}
#endif

#ifdef AGA
static int NOINLINE __attribute__((__unused__)) linetoscr_16_stretch1_aga_spronly(int spix, int dpix, int dpix_end)
{
    uae_u16 *buf = (uae_u16 *) xlinebuffer;
    uae_u8 sprcol;

    if (1) {
        while (dpix < dpix_end) {
            uae_u32 sprpix_val;
            uae_u32 out_val;
        
            sprpix_val = 0;
            spix++;
            out_val = colors_for_drawing.acolors[0];
            {
            uae_u32 out_val1 = out_val;
            uae_u32 out_val2 = out_val;
            if (spritepixels[dpix + 0].data) {
                sprcol = render_sprites (dpix + 0, 0, sprpix_val, 1);
                if (sprcol) {
                    out_val1 = colors_for_drawing.acolors[sprcol];
                }
            }
            if (spritepixels[dpix + 1].data) {
                sprcol = render_sprites (dpix + 1, 0, sprpix_val, 1);
                if (sprcol) {
                    out_val2 = colors_for_drawing.acolors[sprcol];
                }
            }
            buf[dpix++] = out_val1;
            buf[dpix++] = out_val2;
            }
        }
    }

    return spix;
}
#endif

#ifdef AGA
static int NOINLINE __attribute__((__unused__)) linetoscr_16_stretch2_aga_spronly(int spix, int dpix, int dpix_end)
{
    uae_u16 *buf = (uae_u16 *) xlinebuffer;
    uae_u8 sprcol;

    if (1) {
        while (dpix < dpix_end) {
            uae_u32 sprpix_val;
            uae_u32 out_val;
        
            sprpix_val = 0;
            spix++;
            out_val = colors_for_drawing.acolors[0];
            {
            uae_u32 out_val1 = out_val;
            uae_u32 out_val2 = out_val;
            uae_u32 out_val3 = out_val;
            uae_u32 out_val4 = out_val;
            if (spritepixels[dpix + 0].data) {
                sprcol = render_sprites (dpix + 0, 0, sprpix_val, 1);
                if (sprcol) {
                    out_val1 = colors_for_drawing.acolors[sprcol];
                }
            }
            if (spritepixels[dpix + 1].data) {
                sprcol = render_sprites (dpix + 1, 0, sprpix_val, 1);
                if (sprcol) {
                    out_val2 = colors_for_drawing.acolors[sprcol];
                }
            }
            if (spritepixels[dpix + 2].data) {
                sprcol = render_sprites (dpix + 2, 0, sprpix_val, 1);
                if (sprcol) {
                    out_val3 = colors_for_drawing.acolors[sprcol];
                }
            }
            if (spritepixels[dpix + 3].data) {
                sprcol = render_sprites (dpix + 3, 0, sprpix_val, 1);
                if (sprcol) {
                    out_val4 = colors_for_drawing.acolors[sprcol];
                }
            }
            buf[dpix++] = out_val1;
            buf[dpix++] = out_val2;
            buf[dpix++] = out_val3;
            buf[dpix++] = out_val4;
            }
        }
    }

    return spix;
}
#endif

#ifdef AGA
static int NOINLINE __attribute__((__unused__)) linetoscr_16_shrink1_aga_spronly(int spix, int dpix, int dpix_end)
{
    uae_u16 *buf = (uae_u16 *) xlinebuffer;
    uae_u8 sprcol;

    if (1) {
        while (dpix < dpix_end) {
            uae_u32 sprpix_val;
            uae_u32 out_val;
        
            sprpix_val = 0;
            spix++;
            out_val = colors_for_drawing.acolors[0];
            if (spritepixels[dpix].data) {
                sprcol = render_sprites (dpix + 0, 0, sprpix_val, 1);
                if (sprcol) {
                    out_val = colors_for_drawing.acolors[sprcol];
                }
            }
            buf[dpix++] = out_val;
        }
    }

    return spix;
}
#endif

#ifdef AGA
static int NOINLINE __attribute__((__unused__)) linetoscr_16_shrink1f_aga_spronly(int spix, int dpix, int dpix_end)
{
    uae_u16 *buf = (uae_u16 *) xlinebuffer;
    uae_u8 sprcol;

    if (1) {
        while (dpix < dpix_end) {
            uae_u32 sprpix_val;
            uae_u32 out_val;
        
            sprpix_val = 0;
            spix++;
            out_val = colors_for_drawing.acolors[0];
            if (spritepixels[dpix].data) {
                sprcol = render_sprites (dpix + 0, 0, sprpix_val, 1);
                if (sprcol) {
                    out_val = colors_for_drawing.acolors[sprcol];
                }
            }
            buf[dpix++] = out_val;
        }
    }

    return spix;
}
#endif

#ifdef AGA
static int NOINLINE __attribute__((__unused__)) linetoscr_16_shrink2_aga_spronly(int spix, int dpix, int dpix_end)
{
    uae_u16 *buf = (uae_u16 *) xlinebuffer;
    uae_u8 sprcol;

    if (1) {
        while (dpix < dpix_end) {
            uae_u32 sprpix_val;
            uae_u32 out_val;
        
            sprpix_val = 0;
            spix++;
            out_val = colors_for_drawing.acolors[0];
            if (spritepixels[dpix].data) {
                sprcol = render_sprites (dpix + 0, 0, sprpix_val, 1);
                if (sprcol) {
                    out_val = colors_for_drawing.acolors[sprcol];
                }
            }
            buf[dpix++] = out_val;
        }
    }

    return spix;
}
#endif

#ifdef AGA
static int NOINLINE __attribute__((__unused__)) linetoscr_16_shrink2f_aga_spronly(int spix, int dpix, int dpix_end)
{
    uae_u16 *buf = (uae_u16 *) xlinebuffer;
    uae_u8 sprcol;

    if (1) {
        while (dpix < dpix_end) {
            uae_u32 sprpix_val;
            uae_u32 out_val;
        
            sprpix_val = 0;
            spix++;
            out_val = colors_for_drawing.acolors[0];
            if (spritepixels[dpix].data) {
                sprcol = render_sprites (dpix + 0, 0, sprpix_val, 1);
                if (sprcol) {
                    out_val = colors_for_drawing.acolors[sprcol];
                }
            }
            buf[dpix++] = out_val;
        }
    }

    return spix;
}
#endif

#ifdef AGA
static int NOINLINE __attribute__((__unused__)) linetoscr_16_aga(int spix, int dpix, int dpix_end)
{
    uae_u16 *buf = (uae_u16 *) xlinebuffer;
    uae_u8 xor_val = bplxor;

    if (bplham) {
        int rem;
        if (((uintptr_t)&buf[dpix]) & 2) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            spix_val = pixdata.apixels[spix] ^ xor_val;
            spix_val = ham_linebuf[spix];
            dpix_val = CONVERT_RGB (spix_val);
            spix++;
            buf[dpix++] = dpix_val;
        }
        if (dpix >= dpix_end)
            return spix;
        rem = (((uintptr_t)&buf[dpix_end]) & 2);
        if (rem)
            dpix_end--;
        while (dpix < dpix_end) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix] ^ xor_val;
            spix_val = ham_linebuf[spix];
            dpix_val = CONVERT_RGB (spix_val);
            spix++;
            out_val = dpix_val;
            spix_val = pixdata.apixels[spix] ^ xor_val;
            spix_val = ham_linebuf[spix];
            dpix_val = CONVERT_RGB (spix_val);
            spix++;
            out_val = (out_val & 0xFFFF) | (dpix_val << 16);
            *((uae_u32 *)&buf[dpix]) = out_val;
            dpix += 2;
        }
        if (rem) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            spix_val = pixdata.apixels[spix] ^ xor_val;
            spix_val = ham_linebuf[spix];
            dpix_val = CONVERT_RGB (spix_val);
            spix++;
            buf[dpix++] = dpix_val;
        }
    } else if (bpldualpf) {
        int *lookup    = bpldualpfpri ? dblpf_ind2_aga : dblpf_ind1_aga;
        int *lookup_no = bpldualpfpri ? dblpf_2nd2     : dblpf_2nd1;
        int rem;
        if (((uintptr_t)&buf[dpix]) & 2) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            spix_val = pixdata.apixels[spix];
            {
                uae_u8 val = lookup[spix_val];
                if (lookup_no[spix_val])
                    val += dblpfofs[bpldualpf2of];
                val ^= xor_val;
                dpix_val = colors_for_drawing.acolors[val];
            }
            spix++;
            buf[dpix++] = dpix_val;
        }
        if (dpix >= dpix_end)
            return spix;
        rem = (((uintptr_t)&buf[dpix_end]) & 2);
        if (rem)
            dpix_end--;
        while (dpix < dpix_end) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix];
            {
                uae_u8 val = lookup[spix_val];
                if (lookup_no[spix_val])
                    val += dblpfofs[bpldualpf2of];
                val ^= xor_val;
                dpix_val = colors_for_drawing.acolors[val];
            }
            spix++;
            out_val = dpix_val;
            spix_val = pixdata.apixels[spix];
            {
                uae_u8 val = lookup[spix_val];
                if (lookup_no[spix_val])
                    val += dblpfofs[bpldualpf2of];
                val ^= xor_val;
                dpix_val = colors_for_drawing.acolors[val];
            }
            spix++;
            out_val = (out_val & 0xFFFF) | (dpix_val << 16);
            *((uae_u32 *)&buf[dpix]) = out_val;
            dpix += 2;
        }
        if (rem) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            spix_val = pixdata.apixels[spix];
            {
                uae_u8 val = lookup[spix_val];
                if (lookup_no[spix_val])
                    val += dblpfofs[bpldualpf2of];
                val ^= xor_val;
                dpix_val = colors_for_drawing.acolors[val];
            }
            spix++;
            buf[dpix++] = dpix_val;
        }
    } else if (bplehb) {
        int rem;
        if (((uintptr_t)&buf[dpix]) & 2) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            spix_val = pixdata.apixels[spix] ^ xor_val;
            if (spix_val >= 32 && spix_val < 64) {
                unsigned int c = (colors_for_drawing.color_regs_aga[spix_val - 32] >> 1) & 0x7F7F7F;
                dpix_val = CONVERT_RGB (c);
            } else
                dpix_val = colors_for_drawing.acolors[spix_val];
            spix++;
            buf[dpix++] = dpix_val;
        }
        if (dpix >= dpix_end)
            return spix;
        rem = (((uintptr_t)&buf[dpix_end]) & 2);
        if (rem)
            dpix_end--;
        while (dpix < dpix_end) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix] ^ xor_val;
            if (spix_val >= 32 && spix_val < 64) {
                unsigned int c = (colors_for_drawing.color_regs_aga[spix_val - 32] >> 1) & 0x7F7F7F;
                dpix_val = CONVERT_RGB (c);
            } else
                dpix_val = colors_for_drawing.acolors[spix_val];
            spix++;
            out_val = dpix_val;
            spix_val = pixdata.apixels[spix] ^ xor_val;
            if (spix_val >= 32 && spix_val < 64) {
                unsigned int c = (colors_for_drawing.color_regs_aga[spix_val - 32] >> 1) & 0x7F7F7F;
                dpix_val = CONVERT_RGB (c);
            } else
                dpix_val = colors_for_drawing.acolors[spix_val];
            spix++;
            out_val = (out_val & 0xFFFF) | (dpix_val << 16);
            *((uae_u32 *)&buf[dpix]) = out_val;
            dpix += 2;
        }
        if (rem) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            spix_val = pixdata.apixels[spix] ^ xor_val;
            if (spix_val >= 32 && spix_val < 64) {
                unsigned int c = (colors_for_drawing.color_regs_aga[spix_val - 32] >> 1) & 0x7F7F7F;
                dpix_val = CONVERT_RGB (c);
            } else
                dpix_val = colors_for_drawing.acolors[spix_val];
            spix++;
            buf[dpix++] = dpix_val;
        }
    } else {
        int rem;
        if (((uintptr_t)&buf[dpix]) & 2) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            spix_val = pixdata.apixels[spix] ^ xor_val;
            dpix_val = colors_for_drawing.acolors[spix_val];
            spix++;
            buf[dpix++] = dpix_val;
        }
        if (dpix >= dpix_end)
            return spix;
        rem = (((uintptr_t)&buf[dpix_end]) & 2);
        if (rem)
            dpix_end--;
        while (dpix < dpix_end) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix] ^ xor_val;
            dpix_val = colors_for_drawing.acolors[spix_val];
            spix++;
            out_val = dpix_val;
            spix_val = pixdata.apixels[spix] ^ xor_val;
            dpix_val = colors_for_drawing.acolors[spix_val];
            spix++;
            out_val = (out_val & 0xFFFF) | (dpix_val << 16);
            *((uae_u32 *)&buf[dpix]) = out_val;
            dpix += 2;
        }
        if (rem) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            spix_val = pixdata.apixels[spix] ^ xor_val;
            dpix_val = colors_for_drawing.acolors[spix_val];
            spix++;
            buf[dpix++] = dpix_val;
        }
    }

    return spix;
}
#endif

#ifdef AGA
static int NOINLINE __attribute__((__unused__)) linetoscr_16_aga_genlock(int spix, int dpix, int dpix_end)
{
    uae_u16 *buf = (uae_u16 *) xlinebuffer;
    uae_u8 *genlock_buf = xlinebuffer_genlock;
    uae_u8 xor_val = bplxor;

    if (bplham) {
        int rem;
        if (((uintptr_t)&buf[dpix]) & 2) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            spix_val = pixdata.apixels[spix] ^ xor_val;
            spix_val = ham_linebuf[spix];
            dpix_val = CONVERT_RGB (spix_val);
            spix++;
            buf[dpix++] = dpix_val;
        }
        if (dpix >= dpix_end)
            return spix;
        rem = (((uintptr_t)&buf[dpix_end]) & 2);
        if (rem)
            dpix_end--;
        while (dpix < dpix_end) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix] ^ xor_val;
            spix_val = ham_linebuf[spix];
            dpix_val = CONVERT_RGB (spix_val);
            spix++;
            out_val = dpix_val;
            genlock_buf[dpix] = get_genlock_transparency((spix_val >> 2) & 63);
            spix_val = pixdata.apixels[spix] ^ xor_val;
            spix_val = ham_linebuf[spix];
            dpix_val = CONVERT_RGB (spix_val);
            spix++;
            out_val = (out_val & 0xFFFF) | (dpix_val << 16);
            *((uae_u32 *)&buf[dpix]) = out_val;
            dpix += 2;
        }
        if (rem) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            spix_val = pixdata.apixels[spix] ^ xor_val;
            spix_val = ham_linebuf[spix];
            dpix_val = CONVERT_RGB (spix_val);
            spix++;
            buf[dpix++] = dpix_val;
        }
    } else if (bpldualpf) {
        int *lookup    = bpldualpfpri ? dblpf_ind2_aga : dblpf_ind1_aga;
        int *lookup_no = bpldualpfpri ? dblpf_2nd2     : dblpf_2nd1;
        int rem;
        if (((uintptr_t)&buf[dpix]) & 2) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            spix_val = pixdata.apixels[spix];
            {
                uae_u8 val = lookup[spix_val];
                if (lookup_no[spix_val])
                    val += dblpfofs[bpldualpf2of];
                val ^= xor_val;
                dpix_val = colors_for_drawing.acolors[val];
            }
            spix++;
            buf[dpix++] = dpix_val;
        }
        if (dpix >= dpix_end)
            return spix;
        rem = (((uintptr_t)&buf[dpix_end]) & 2);
        if (rem)
            dpix_end--;
        while (dpix < dpix_end) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix];
            {
                uae_u8 val = lookup[spix_val];
                if (lookup_no[spix_val])
                    val += dblpfofs[bpldualpf2of];
                val ^= xor_val;
                dpix_val = colors_for_drawing.acolors[val];
            }
            spix++;
            out_val = dpix_val;
            genlock_buf[dpix] = get_genlock_transparency(lookup[spix_val]);
            spix_val = pixdata.apixels[spix];
            {
                uae_u8 val = lookup[spix_val];
                if (lookup_no[spix_val])
                    val += dblpfofs[bpldualpf2of];
                val ^= xor_val;
                dpix_val = colors_for_drawing.acolors[val];
            }
            spix++;
            out_val = (out_val & 0xFFFF) | (dpix_val << 16);
            *((uae_u32 *)&buf[dpix]) = out_val;
            dpix += 2;
        }
        if (rem) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            spix_val = pixdata.apixels[spix];
            {
                uae_u8 val = lookup[spix_val];
                if (lookup_no[spix_val])
                    val += dblpfofs[bpldualpf2of];
                val ^= xor_val;
                dpix_val = colors_for_drawing.acolors[val];
            }
            spix++;
            buf[dpix++] = dpix_val;
        }
    } else if (bplehb) {
        int rem;
        if (((uintptr_t)&buf[dpix]) & 2) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            spix_val = pixdata.apixels[spix] ^ xor_val;
            if (spix_val >= 32 && spix_val < 64) {
                unsigned int c = (colors_for_drawing.color_regs_aga[spix_val - 32] >> 1) & 0x7F7F7F;
                dpix_val = CONVERT_RGB (c);
            } else
                dpix_val = colors_for_drawing.acolors[spix_val];
            spix++;
            buf[dpix++] = dpix_val;
        }
        if (dpix >= dpix_end)
            return spix;
        rem = (((uintptr_t)&buf[dpix_end]) & 2);
        if (rem)
            dpix_end--;
        while (dpix < dpix_end) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix] ^ xor_val;
            if (spix_val >= 32 && spix_val < 64) {
                unsigned int c = (colors_for_drawing.color_regs_aga[spix_val - 32] >> 1) & 0x7F7F7F;
                dpix_val = CONVERT_RGB (c);
            } else
                dpix_val = colors_for_drawing.acolors[spix_val];
            spix++;
            out_val = dpix_val;
            genlock_buf[dpix] = get_genlock_transparency(spix_val & 31);
            spix_val = pixdata.apixels[spix] ^ xor_val;
            if (spix_val >= 32 && spix_val < 64) {
                unsigned int c = (colors_for_drawing.color_regs_aga[spix_val - 32] >> 1) & 0x7F7F7F;
                dpix_val = CONVERT_RGB (c);
            } else
                dpix_val = colors_for_drawing.acolors[spix_val];
            spix++;
            out_val = (out_val & 0xFFFF) | (dpix_val << 16);
            *((uae_u32 *)&buf[dpix]) = out_val;
            dpix += 2;
        }
        if (rem) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            spix_val = pixdata.apixels[spix] ^ xor_val;
            if (spix_val >= 32 && spix_val < 64) {
                unsigned int c = (colors_for_drawing.color_regs_aga[spix_val - 32] >> 1) & 0x7F7F7F;
                dpix_val = CONVERT_RGB (c);
            } else
                dpix_val = colors_for_drawing.acolors[spix_val];
            spix++;
            buf[dpix++] = dpix_val;
        }
    } else {
        int rem;
        if (((uintptr_t)&buf[dpix]) & 2) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            spix_val = pixdata.apixels[spix] ^ xor_val;
            dpix_val = colors_for_drawing.acolors[spix_val];
            spix++;
            buf[dpix++] = dpix_val;
        }
        if (dpix >= dpix_end)
            return spix;
        rem = (((uintptr_t)&buf[dpix_end]) & 2);
        if (rem)
            dpix_end--;
        while (dpix < dpix_end) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix] ^ xor_val;
            dpix_val = colors_for_drawing.acolors[spix_val];
            spix++;
            out_val = dpix_val;
            genlock_buf[dpix] = get_genlock_transparency(spix_val);
            spix_val = pixdata.apixels[spix] ^ xor_val;
            dpix_val = colors_for_drawing.acolors[spix_val];
            spix++;
            out_val = (out_val & 0xFFFF) | (dpix_val << 16);
            *((uae_u32 *)&buf[dpix]) = out_val;
            dpix += 2;
        }
        if (rem) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            spix_val = pixdata.apixels[spix] ^ xor_val;
            dpix_val = colors_for_drawing.acolors[spix_val];
            spix++;
            buf[dpix++] = dpix_val;
        }
    }

    return spix;
}
#endif

#ifdef AGA
static int NOINLINE __attribute__((__unused__)) linetoscr_16_stretch1_aga(int spix, int dpix, int dpix_end)
{
    uae_u16 *buf = (uae_u16 *) xlinebuffer;
    uae_u8 xor_val = bplxor;

    if (bplham) {
        while (dpix < dpix_end) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix] ^ xor_val;
            spix_val = ham_linebuf[spix];
            dpix_val = CONVERT_RGB (spix_val);
            spix++;
            out_val = dpix_val;
            *((uae_u32 *)&buf[dpix]) = out_val;
            dpix += 2;
        }
    } else if (bpldualpf) {
        int *lookup    = bpldualpfpri ? dblpf_ind2_aga : dblpf_ind1_aga;
        int *lookup_no = bpldualpfpri ? dblpf_2nd2     : dblpf_2nd1;
        while (dpix < dpix_end) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix];
            {
                uae_u8 val = lookup[spix_val];
                if (lookup_no[spix_val])
                    val += dblpfofs[bpldualpf2of];
                val ^= xor_val;
                dpix_val = colors_for_drawing.acolors[val];
            }
            spix++;
            out_val = dpix_val;
            *((uae_u32 *)&buf[dpix]) = out_val;
            dpix += 2;
        }
    } else if (bplehb) {
        while (dpix < dpix_end) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix] ^ xor_val;
            if (spix_val >= 32 && spix_val < 64) {
                unsigned int c = (colors_for_drawing.color_regs_aga[spix_val - 32] >> 1) & 0x7F7F7F;
                dpix_val = CONVERT_RGB (c);
            } else
                dpix_val = colors_for_drawing.acolors[spix_val];
            spix++;
            out_val = dpix_val;
            *((uae_u32 *)&buf[dpix]) = out_val;
            dpix += 2;
        }
    } else {
        while (dpix < dpix_end) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix] ^ xor_val;
            dpix_val = colors_for_drawing.acolors[spix_val];
            spix++;
            out_val = dpix_val;
            *((uae_u32 *)&buf[dpix]) = out_val;
            dpix += 2;
        }
    }

    return spix;
}
#endif

#ifdef AGA
static int NOINLINE __attribute__((__unused__)) linetoscr_16_stretch1_aga_genlock(int spix, int dpix, int dpix_end)
{
    uae_u16 *buf = (uae_u16 *) xlinebuffer;
    uae_u8 *genlock_buf = xlinebuffer_genlock;
    uae_u8 xor_val = bplxor;

    if (bplham) {
        while (dpix < dpix_end) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix] ^ xor_val;
            spix_val = ham_linebuf[spix];
            dpix_val = CONVERT_RGB (spix_val);
            spix++;
            out_val = dpix_val;
            genlock_buf[dpix] = get_genlock_transparency((spix_val >> 2) & 63);
            genlock_buf[dpix + 1] = get_genlock_transparency((spix_val >> 2) & 63);
            *((uae_u32 *)&buf[dpix]) = out_val;
            dpix += 2;
        }
    } else if (bpldualpf) {
        int *lookup    = bpldualpfpri ? dblpf_ind2_aga : dblpf_ind1_aga;
        int *lookup_no = bpldualpfpri ? dblpf_2nd2     : dblpf_2nd1;
        while (dpix < dpix_end) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix];
            {
                uae_u8 val = lookup[spix_val];
                if (lookup_no[spix_val])
                    val += dblpfofs[bpldualpf2of];
                val ^= xor_val;
                dpix_val = colors_for_drawing.acolors[val];
            }
            spix++;
            out_val = dpix_val;
            genlock_buf[dpix] = get_genlock_transparency(lookup[spix_val]);
            genlock_buf[dpix + 1] = get_genlock_transparency(lookup[spix_val]);
            *((uae_u32 *)&buf[dpix]) = out_val;
            dpix += 2;
        }
    } else if (bplehb) {
        while (dpix < dpix_end) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix] ^ xor_val;
            if (spix_val >= 32 && spix_val < 64) {
                unsigned int c = (colors_for_drawing.color_regs_aga[spix_val - 32] >> 1) & 0x7F7F7F;
                dpix_val = CONVERT_RGB (c);
            } else
                dpix_val = colors_for_drawing.acolors[spix_val];
            spix++;
            out_val = dpix_val;
            genlock_buf[dpix] = get_genlock_transparency(spix_val & 31);
            genlock_buf[dpix + 1] = get_genlock_transparency(spix_val & 31);
            *((uae_u32 *)&buf[dpix]) = out_val;
            dpix += 2;
        }
    } else {
        while (dpix < dpix_end) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix] ^ xor_val;
            dpix_val = colors_for_drawing.acolors[spix_val];
            spix++;
            out_val = dpix_val;
            genlock_buf[dpix] = get_genlock_transparency(spix_val);
            genlock_buf[dpix + 1] = get_genlock_transparency(spix_val);
            *((uae_u32 *)&buf[dpix]) = out_val;
            dpix += 2;
        }
    }

    return spix;
}
#endif

#ifdef AGA
static int NOINLINE __attribute__((__unused__)) linetoscr_16_stretch2_aga(int spix, int dpix, int dpix_end)
{
    uae_u16 *buf = (uae_u16 *) xlinebuffer;
    uae_u8 xor_val = bplxor;

    if (bplham) {
        while (dpix < dpix_end) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix] ^ xor_val;
            spix_val = ham_linebuf[spix];
            dpix_val = CONVERT_RGB (spix_val);
            spix++;
            out_val = dpix_val;
            *((uae_u32 *)&buf[dpix]) = out_val;
            dpix += 2;
            *((uae_u32 *)&buf[dpix]) = out_val;
            dpix += 2;
        }
    } else if (bpldualpf) {
        int *lookup    = bpldualpfpri ? dblpf_ind2_aga : dblpf_ind1_aga;
        int *lookup_no = bpldualpfpri ? dblpf_2nd2     : dblpf_2nd1;
        while (dpix < dpix_end) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix];
            {
                uae_u8 val = lookup[spix_val];
                if (lookup_no[spix_val])
                    val += dblpfofs[bpldualpf2of];
                val ^= xor_val;
                dpix_val = colors_for_drawing.acolors[val];
            }
            spix++;
            out_val = dpix_val;
            *((uae_u32 *)&buf[dpix]) = out_val;
            dpix += 2;
            *((uae_u32 *)&buf[dpix]) = out_val;
            dpix += 2;
        }
    } else if (bplehb) {
        while (dpix < dpix_end) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix] ^ xor_val;
            if (spix_val >= 32 && spix_val < 64) {
                unsigned int c = (colors_for_drawing.color_regs_aga[spix_val - 32] >> 1) & 0x7F7F7F;
                dpix_val = CONVERT_RGB (c);
            } else
                dpix_val = colors_for_drawing.acolors[spix_val];
            spix++;
            out_val = dpix_val;
            *((uae_u32 *)&buf[dpix]) = out_val;
            dpix += 2;
            *((uae_u32 *)&buf[dpix]) = out_val;
            dpix += 2;
        }
    } else {
        while (dpix < dpix_end) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix] ^ xor_val;
            dpix_val = colors_for_drawing.acolors[spix_val];
            spix++;
            out_val = dpix_val;
            *((uae_u32 *)&buf[dpix]) = out_val;
            dpix += 2;
            *((uae_u32 *)&buf[dpix]) = out_val;
            dpix += 2;
        }
    }

    return spix;
}
#endif

#ifdef AGA
static int NOINLINE __attribute__((__unused__)) linetoscr_16_stretch2_aga_genlock(int spix, int dpix, int dpix_end)
{
    uae_u16 *buf = (uae_u16 *) xlinebuffer;
    uae_u8 *genlock_buf = xlinebuffer_genlock;
    uae_u8 xor_val = bplxor;

    if (bplham) {
        while (dpix < dpix_end) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix] ^ xor_val;
            spix_val = ham_linebuf[spix];
            dpix_val = CONVERT_RGB (spix_val);
            spix++;
            out_val = dpix_val;
            genlock_buf[dpix] = get_genlock_transparency((spix_val >> 2) & 63);
            genlock_buf[dpix + 1] = get_genlock_transparency((spix_val >> 2) & 63);
            genlock_buf[dpix + 2] = get_genlock_transparency((spix_val >> 2) & 63);
            genlock_buf[dpix + 3] = get_genlock_transparency((spix_val >> 2) & 63);
            *((uae_u32 *)&buf[dpix]) = out_val;
            dpix += 2;
            *((uae_u32 *)&buf[dpix]) = out_val;
            dpix += 2;
        }
    } else if (bpldualpf) {
        int *lookup    = bpldualpfpri ? dblpf_ind2_aga : dblpf_ind1_aga;
        int *lookup_no = bpldualpfpri ? dblpf_2nd2     : dblpf_2nd1;
        while (dpix < dpix_end) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix];
            {
                uae_u8 val = lookup[spix_val];
                if (lookup_no[spix_val])
                    val += dblpfofs[bpldualpf2of];
                val ^= xor_val;
                dpix_val = colors_for_drawing.acolors[val];
            }
            spix++;
            out_val = dpix_val;
            genlock_buf[dpix] = get_genlock_transparency(lookup[spix_val]);
            genlock_buf[dpix + 1] = get_genlock_transparency(lookup[spix_val]);
            genlock_buf[dpix + 2] = get_genlock_transparency(lookup[spix_val]);
            genlock_buf[dpix + 3] = get_genlock_transparency(lookup[spix_val]);
            *((uae_u32 *)&buf[dpix]) = out_val;
            dpix += 2;
            *((uae_u32 *)&buf[dpix]) = out_val;
            dpix += 2;
        }
    } else if (bplehb) {
        while (dpix < dpix_end) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix] ^ xor_val;
            if (spix_val >= 32 && spix_val < 64) {
                unsigned int c = (colors_for_drawing.color_regs_aga[spix_val - 32] >> 1) & 0x7F7F7F;
                dpix_val = CONVERT_RGB (c);
            } else
                dpix_val = colors_for_drawing.acolors[spix_val];
            spix++;
            out_val = dpix_val;
            genlock_buf[dpix] = get_genlock_transparency(spix_val & 31);
            genlock_buf[dpix + 1] = get_genlock_transparency(spix_val & 31);
            genlock_buf[dpix + 2] = get_genlock_transparency(spix_val & 31);
            genlock_buf[dpix + 3] = get_genlock_transparency(spix_val & 31);
            *((uae_u32 *)&buf[dpix]) = out_val;
            dpix += 2;
            *((uae_u32 *)&buf[dpix]) = out_val;
            dpix += 2;
        }
    } else {
        while (dpix < dpix_end) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix] ^ xor_val;
            dpix_val = colors_for_drawing.acolors[spix_val];
            spix++;
            out_val = dpix_val;
            genlock_buf[dpix] = get_genlock_transparency(spix_val);
            genlock_buf[dpix + 1] = get_genlock_transparency(spix_val);
            genlock_buf[dpix + 2] = get_genlock_transparency(spix_val);
            genlock_buf[dpix + 3] = get_genlock_transparency(spix_val);
            *((uae_u32 *)&buf[dpix]) = out_val;
            dpix += 2;
            *((uae_u32 *)&buf[dpix]) = out_val;
            dpix += 2;
        }
    }

    return spix;
}
#endif

#ifdef AGA
static int NOINLINE __attribute__((__unused__)) linetoscr_16_shrink1_aga(int spix, int dpix, int dpix_end)
{
    uae_u16 *buf = (uae_u16 *) xlinebuffer;
    uae_u8 xor_val = bplxor;

    if (bplham) {
        int rem;
        if (((uintptr_t)&buf[dpix]) & 2) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            spix_val = pixdata.apixels[spix] ^ xor_val;
            spix_val = ham_linebuf[spix];
            dpix_val = CONVERT_RGB (spix_val);
            spix += 2;
            buf[dpix++] = dpix_val;
        }
        if (dpix >= dpix_end)
            return spix;
        rem = (((uintptr_t)&buf[dpix_end]) & 2);
        if (rem)
            dpix_end--;
        while (dpix < dpix_end) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix] ^ xor_val;
            spix_val = ham_linebuf[spix];
            dpix_val = CONVERT_RGB (spix_val);
            spix += 2;
            out_val = dpix_val;
            spix_val = pixdata.apixels[spix] ^ xor_val;
            spix_val = ham_linebuf[spix];
            dpix_val = CONVERT_RGB (spix_val);
            spix += 2;
            out_val = (out_val & 0xFFFF) | (dpix_val << 16);
            *((uae_u32 *)&buf[dpix]) = out_val;
            dpix += 2;
        }
        if (rem) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            spix_val = pixdata.apixels[spix] ^ xor_val;
            spix_val = ham_linebuf[spix];
            dpix_val = CONVERT_RGB (spix_val);
            spix += 2;
            buf[dpix++] = dpix_val;
        }
    } else if (bpldualpf) {
        int *lookup    = bpldualpfpri ? dblpf_ind2_aga : dblpf_ind1_aga;
        int *lookup_no = bpldualpfpri ? dblpf_2nd2     : dblpf_2nd1;
        int rem;
        if (((uintptr_t)&buf[dpix]) & 2) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            spix_val = pixdata.apixels[spix];
            {
                uae_u8 val = lookup[spix_val];
                if (lookup_no[spix_val])
                    val += dblpfofs[bpldualpf2of];
                val ^= xor_val;
                dpix_val = colors_for_drawing.acolors[val];
            }
            spix += 2;
            buf[dpix++] = dpix_val;
        }
        if (dpix >= dpix_end)
            return spix;
        rem = (((uintptr_t)&buf[dpix_end]) & 2);
        if (rem)
            dpix_end--;
        while (dpix < dpix_end) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix];
            {
                uae_u8 val = lookup[spix_val];
                if (lookup_no[spix_val])
                    val += dblpfofs[bpldualpf2of];
                val ^= xor_val;
                dpix_val = colors_for_drawing.acolors[val];
            }
            spix += 2;
            out_val = dpix_val;
            spix_val = pixdata.apixels[spix];
            {
                uae_u8 val = lookup[spix_val];
                if (lookup_no[spix_val])
                    val += dblpfofs[bpldualpf2of];
                val ^= xor_val;
                dpix_val = colors_for_drawing.acolors[val];
            }
            spix += 2;
            out_val = (out_val & 0xFFFF) | (dpix_val << 16);
            *((uae_u32 *)&buf[dpix]) = out_val;
            dpix += 2;
        }
        if (rem) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            spix_val = pixdata.apixels[spix];
            {
                uae_u8 val = lookup[spix_val];
                if (lookup_no[spix_val])
                    val += dblpfofs[bpldualpf2of];
                val ^= xor_val;
                dpix_val = colors_for_drawing.acolors[val];
            }
            spix += 2;
            buf[dpix++] = dpix_val;
        }
    } else if (bplehb) {
        int rem;
        if (((uintptr_t)&buf[dpix]) & 2) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            spix_val = pixdata.apixels[spix] ^ xor_val;
            if (spix_val >= 32 && spix_val < 64) {
                unsigned int c = (colors_for_drawing.color_regs_aga[spix_val - 32] >> 1) & 0x7F7F7F;
                dpix_val = CONVERT_RGB (c);
            } else
                dpix_val = colors_for_drawing.acolors[spix_val];
            spix += 2;
            buf[dpix++] = dpix_val;
        }
        if (dpix >= dpix_end)
            return spix;
        rem = (((uintptr_t)&buf[dpix_end]) & 2);
        if (rem)
            dpix_end--;
        while (dpix < dpix_end) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix] ^ xor_val;
            if (spix_val >= 32 && spix_val < 64) {
                unsigned int c = (colors_for_drawing.color_regs_aga[spix_val - 32] >> 1) & 0x7F7F7F;
                dpix_val = CONVERT_RGB (c);
            } else
                dpix_val = colors_for_drawing.acolors[spix_val];
            spix += 2;
            out_val = dpix_val;
            spix_val = pixdata.apixels[spix] ^ xor_val;
            if (spix_val >= 32 && spix_val < 64) {
                unsigned int c = (colors_for_drawing.color_regs_aga[spix_val - 32] >> 1) & 0x7F7F7F;
                dpix_val = CONVERT_RGB (c);
            } else
                dpix_val = colors_for_drawing.acolors[spix_val];
            spix += 2;
            out_val = (out_val & 0xFFFF) | (dpix_val << 16);
            *((uae_u32 *)&buf[dpix]) = out_val;
            dpix += 2;
        }
        if (rem) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            spix_val = pixdata.apixels[spix] ^ xor_val;
            if (spix_val >= 32 && spix_val < 64) {
                unsigned int c = (colors_for_drawing.color_regs_aga[spix_val - 32] >> 1) & 0x7F7F7F;
                dpix_val = CONVERT_RGB (c);
            } else
                dpix_val = colors_for_drawing.acolors[spix_val];
            spix += 2;
            buf[dpix++] = dpix_val;
        }
    } else {
        int rem;
        if (((uintptr_t)&buf[dpix]) & 2) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            spix_val = pixdata.apixels[spix] ^ xor_val;
            dpix_val = colors_for_drawing.acolors[spix_val];
            spix += 2;
            buf[dpix++] = dpix_val;
        }
        if (dpix >= dpix_end)
            return spix;
        rem = (((uintptr_t)&buf[dpix_end]) & 2);
        if (rem)
            dpix_end--;
        while (dpix < dpix_end) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix] ^ xor_val;
            dpix_val = colors_for_drawing.acolors[spix_val];
            spix += 2;
            out_val = dpix_val;
            spix_val = pixdata.apixels[spix] ^ xor_val;
            dpix_val = colors_for_drawing.acolors[spix_val];
            spix += 2;
            out_val = (out_val & 0xFFFF) | (dpix_val << 16);
            *((uae_u32 *)&buf[dpix]) = out_val;
            dpix += 2;
        }
        if (rem) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            spix_val = pixdata.apixels[spix] ^ xor_val;
            dpix_val = colors_for_drawing.acolors[spix_val];
            spix += 2;
            buf[dpix++] = dpix_val;
        }
    }

    return spix;
}
#endif

#ifdef AGA
static int NOINLINE __attribute__((__unused__)) linetoscr_16_shrink1_aga_genlock(int spix, int dpix, int dpix_end)
{
    uae_u16 *buf = (uae_u16 *) xlinebuffer;
    uae_u8 *genlock_buf = xlinebuffer_genlock;
    uae_u8 xor_val = bplxor;

    if (bplham) {
        int rem;
        if (((uintptr_t)&buf[dpix]) & 2) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            spix_val = pixdata.apixels[spix] ^ xor_val;
            spix_val = ham_linebuf[spix];
            dpix_val = CONVERT_RGB (spix_val);
            spix += 2;
            buf[dpix++] = dpix_val;
        }
        if (dpix >= dpix_end)
            return spix;
        rem = (((uintptr_t)&buf[dpix_end]) & 2);
        if (rem)
            dpix_end--;
        while (dpix < dpix_end) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix] ^ xor_val;
            spix_val = ham_linebuf[spix];
            dpix_val = CONVERT_RGB (spix_val);
            spix += 2;
            out_val = dpix_val;
            genlock_buf[dpix] = get_genlock_transparency((spix_val >> 2) & 63);
            spix_val = pixdata.apixels[spix] ^ xor_val;
            spix_val = ham_linebuf[spix];
            dpix_val = CONVERT_RGB (spix_val);
            spix += 2;
            out_val = (out_val & 0xFFFF) | (dpix_val << 16);
            *((uae_u32 *)&buf[dpix]) = out_val;
            dpix += 2;
        }
        if (rem) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            spix_val = pixdata.apixels[spix] ^ xor_val;
            spix_val = ham_linebuf[spix];
            dpix_val = CONVERT_RGB (spix_val);
            spix += 2;
            buf[dpix++] = dpix_val;
        }
    } else if (bpldualpf) {
        int *lookup    = bpldualpfpri ? dblpf_ind2_aga : dblpf_ind1_aga;
        int *lookup_no = bpldualpfpri ? dblpf_2nd2     : dblpf_2nd1;
        int rem;
        if (((uintptr_t)&buf[dpix]) & 2) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            spix_val = pixdata.apixels[spix];
            {
                uae_u8 val = lookup[spix_val];
                if (lookup_no[spix_val])
                    val += dblpfofs[bpldualpf2of];
                val ^= xor_val;
                dpix_val = colors_for_drawing.acolors[val];
            }
            spix += 2;
            buf[dpix++] = dpix_val;
        }
        if (dpix >= dpix_end)
            return spix;
        rem = (((uintptr_t)&buf[dpix_end]) & 2);
        if (rem)
            dpix_end--;
        while (dpix < dpix_end) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix];
            {
                uae_u8 val = lookup[spix_val];
                if (lookup_no[spix_val])
                    val += dblpfofs[bpldualpf2of];
                val ^= xor_val;
                dpix_val = colors_for_drawing.acolors[val];
            }
            spix += 2;
            out_val = dpix_val;
            genlock_buf[dpix] = get_genlock_transparency(lookup[spix_val]);
            spix_val = pixdata.apixels[spix];
            {
                uae_u8 val = lookup[spix_val];
                if (lookup_no[spix_val])
                    val += dblpfofs[bpldualpf2of];
                val ^= xor_val;
                dpix_val = colors_for_drawing.acolors[val];
            }
            spix += 2;
            out_val = (out_val & 0xFFFF) | (dpix_val << 16);
            *((uae_u32 *)&buf[dpix]) = out_val;
            dpix += 2;
        }
        if (rem) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            spix_val = pixdata.apixels[spix];
            {
                uae_u8 val = lookup[spix_val];
                if (lookup_no[spix_val])
                    val += dblpfofs[bpldualpf2of];
                val ^= xor_val;
                dpix_val = colors_for_drawing.acolors[val];
            }
            spix += 2;
            buf[dpix++] = dpix_val;
        }
    } else if (bplehb) {
        int rem;
        if (((uintptr_t)&buf[dpix]) & 2) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            spix_val = pixdata.apixels[spix] ^ xor_val;
            if (spix_val >= 32 && spix_val < 64) {
                unsigned int c = (colors_for_drawing.color_regs_aga[spix_val - 32] >> 1) & 0x7F7F7F;
                dpix_val = CONVERT_RGB (c);
            } else
                dpix_val = colors_for_drawing.acolors[spix_val];
            spix += 2;
            buf[dpix++] = dpix_val;
        }
        if (dpix >= dpix_end)
            return spix;
        rem = (((uintptr_t)&buf[dpix_end]) & 2);
        if (rem)
            dpix_end--;
        while (dpix < dpix_end) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix] ^ xor_val;
            if (spix_val >= 32 && spix_val < 64) {
                unsigned int c = (colors_for_drawing.color_regs_aga[spix_val - 32] >> 1) & 0x7F7F7F;
                dpix_val = CONVERT_RGB (c);
            } else
                dpix_val = colors_for_drawing.acolors[spix_val];
            spix += 2;
            out_val = dpix_val;
            genlock_buf[dpix] = get_genlock_transparency(spix_val & 31);
            spix_val = pixdata.apixels[spix] ^ xor_val;
            if (spix_val >= 32 && spix_val < 64) {
                unsigned int c = (colors_for_drawing.color_regs_aga[spix_val - 32] >> 1) & 0x7F7F7F;
                dpix_val = CONVERT_RGB (c);
            } else
                dpix_val = colors_for_drawing.acolors[spix_val];
            spix += 2;
            out_val = (out_val & 0xFFFF) | (dpix_val << 16);
            *((uae_u32 *)&buf[dpix]) = out_val;
            dpix += 2;
        }
        if (rem) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            spix_val = pixdata.apixels[spix] ^ xor_val;
            if (spix_val >= 32 && spix_val < 64) {
                unsigned int c = (colors_for_drawing.color_regs_aga[spix_val - 32] >> 1) & 0x7F7F7F;
                dpix_val = CONVERT_RGB (c);
            } else
                dpix_val = colors_for_drawing.acolors[spix_val];
            spix += 2;
            buf[dpix++] = dpix_val;
        }
    } else {
        int rem;
        if (((uintptr_t)&buf[dpix]) & 2) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            spix_val = pixdata.apixels[spix] ^ xor_val;
            dpix_val = colors_for_drawing.acolors[spix_val];
            spix += 2;
            buf[dpix++] = dpix_val;
        }
        if (dpix >= dpix_end)
            return spix;
        rem = (((uintptr_t)&buf[dpix_end]) & 2);
        if (rem)
            dpix_end--;
        while (dpix < dpix_end) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix] ^ xor_val;
            dpix_val = colors_for_drawing.acolors[spix_val];
            spix += 2;
            out_val = dpix_val;
            genlock_buf[dpix] = get_genlock_transparency(spix_val);
            spix_val = pixdata.apixels[spix] ^ xor_val;
            dpix_val = colors_for_drawing.acolors[spix_val];
            spix += 2;
            out_val = (out_val & 0xFFFF) | (dpix_val << 16);
            *((uae_u32 *)&buf[dpix]) = out_val;
            dpix += 2;
        }
        if (rem) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            spix_val = pixdata.apixels[spix] ^ xor_val;
            dpix_val = colors_for_drawing.acolors[spix_val];
            spix += 2;
            buf[dpix++] = dpix_val;
        }
    }

    return spix;
}
#endif

#ifdef AGA
static int NOINLINE __attribute__((__unused__)) linetoscr_16_shrink1f_aga(int spix, int dpix, int dpix_end)
{
    uae_u16 *buf = (uae_u16 *) xlinebuffer;
    uae_u8 xor_val = bplxor;

    if (bplham) {
        int rem;
        if (((uintptr_t)&buf[dpix]) & 2) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            spix_val = pixdata.apixels[spix] ^ xor_val;
            spix_val = ham_linebuf[spix];
            dpix_val = CONVERT_RGB (spix_val);
            {
            uae_u32 tmp_val;
            spix++;
            tmp_val = dpix_val;
            spix_val = pixdata.apixels[spix] ^ xor_val;
            spix_val = ham_linebuf[spix];
            dpix_val = CONVERT_RGB (spix_val);
            dpix_val = merge_2pixel16 (dpix_val, tmp_val);
            spix++;
            }
            buf[dpix++] = dpix_val;
        }
        if (dpix >= dpix_end)
            return spix;
        rem = (((uintptr_t)&buf[dpix_end]) & 2);
        if (rem)
            dpix_end--;
        while (dpix < dpix_end) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix] ^ xor_val;
            spix_val = ham_linebuf[spix];
            dpix_val = CONVERT_RGB (spix_val);
            {
            uae_u32 tmp_val;
            spix++;
            tmp_val = dpix_val;
            spix_val = pixdata.apixels[spix] ^ xor_val;
            spix_val = ham_linebuf[spix];
            dpix_val = CONVERT_RGB (spix_val);
            dpix_val = merge_2pixel16 (dpix_val, tmp_val);
            spix++;
            }
            out_val = dpix_val;
            spix_val = pixdata.apixels[spix] ^ xor_val;
            spix_val = ham_linebuf[spix];
            dpix_val = CONVERT_RGB (spix_val);
            {
            uae_u32 tmp_val;
            spix++;
            tmp_val = dpix_val;
            spix_val = pixdata.apixels[spix] ^ xor_val;
            spix_val = ham_linebuf[spix];
            dpix_val = CONVERT_RGB (spix_val);
            dpix_val = merge_2pixel16 (dpix_val, tmp_val);
            spix++;
            }
            out_val = (out_val & 0xFFFF) | (dpix_val << 16);
            *((uae_u32 *)&buf[dpix]) = out_val;
            dpix += 2;
        }
        if (rem) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            spix_val = pixdata.apixels[spix] ^ xor_val;
            spix_val = ham_linebuf[spix];
            dpix_val = CONVERT_RGB (spix_val);
            {
            uae_u32 tmp_val;
            spix++;
            tmp_val = dpix_val;
            spix_val = pixdata.apixels[spix] ^ xor_val;
            spix_val = ham_linebuf[spix];
            dpix_val = CONVERT_RGB (spix_val);
            dpix_val = merge_2pixel16 (dpix_val, tmp_val);
            spix++;
            }
            buf[dpix++] = dpix_val;
        }
    } else if (bpldualpf) {
        int *lookup    = bpldualpfpri ? dblpf_ind2_aga : dblpf_ind1_aga;
        int *lookup_no = bpldualpfpri ? dblpf_2nd2     : dblpf_2nd1;
        int rem;
        if (((uintptr_t)&buf[dpix]) & 2) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            spix_val = pixdata.apixels[spix];
            {
                uae_u8 val = lookup[spix_val];
                if (lookup_no[spix_val])
                    val += dblpfofs[bpldualpf2of];
                val ^= xor_val;
                dpix_val = colors_for_drawing.acolors[val];
            }
            {
            uae_u32 tmp_val;
            spix++;
            tmp_val = dpix_val;
            spix_val = pixdata.apixels[spix];
            {
                uae_u8 val = lookup[spix_val];
                if (lookup_no[spix_val])
                    val += dblpfofs[bpldualpf2of];
                val ^= xor_val;
                dpix_val = colors_for_drawing.acolors[val];
            }
            dpix_val = merge_2pixel16 (dpix_val, tmp_val);
            spix++;
            }
            buf[dpix++] = dpix_val;
        }
        if (dpix >= dpix_end)
            return spix;
        rem = (((uintptr_t)&buf[dpix_end]) & 2);
        if (rem)
            dpix_end--;
        while (dpix < dpix_end) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix];
            {
                uae_u8 val = lookup[spix_val];
                if (lookup_no[spix_val])
                    val += dblpfofs[bpldualpf2of];
                val ^= xor_val;
                dpix_val = colors_for_drawing.acolors[val];
            }
            {
            uae_u32 tmp_val;
            spix++;
            tmp_val = dpix_val;
            spix_val = pixdata.apixels[spix];
            {
                uae_u8 val = lookup[spix_val];
                if (lookup_no[spix_val])
                    val += dblpfofs[bpldualpf2of];
                val ^= xor_val;
                dpix_val = colors_for_drawing.acolors[val];
            }
            dpix_val = merge_2pixel16 (dpix_val, tmp_val);
            spix++;
            }
            out_val = dpix_val;
            spix_val = pixdata.apixels[spix];
            {
                uae_u8 val = lookup[spix_val];
                if (lookup_no[spix_val])
                    val += dblpfofs[bpldualpf2of];
                val ^= xor_val;
                dpix_val = colors_for_drawing.acolors[val];
            }
            {
            uae_u32 tmp_val;
            spix++;
            tmp_val = dpix_val;
            spix_val = pixdata.apixels[spix];
            {
                uae_u8 val = lookup[spix_val];
                if (lookup_no[spix_val])
                    val += dblpfofs[bpldualpf2of];
                val ^= xor_val;
                dpix_val = colors_for_drawing.acolors[val];
            }
            dpix_val = merge_2pixel16 (dpix_val, tmp_val);
            spix++;
            }
            out_val = (out_val & 0xFFFF) | (dpix_val << 16);
            *((uae_u32 *)&buf[dpix]) = out_val;
            dpix += 2;
        }
        if (rem) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            spix_val = pixdata.apixels[spix];
            {
                uae_u8 val = lookup[spix_val];
                if (lookup_no[spix_val])
                    val += dblpfofs[bpldualpf2of];
                val ^= xor_val;
                dpix_val = colors_for_drawing.acolors[val];
            }
            {
            uae_u32 tmp_val;
            spix++;
            tmp_val = dpix_val;
            spix_val = pixdata.apixels[spix];
            {
                uae_u8 val = lookup[spix_val];
                if (lookup_no[spix_val])
                    val += dblpfofs[bpldualpf2of];
                val ^= xor_val;
                dpix_val = colors_for_drawing.acolors[val];
            }
            dpix_val = merge_2pixel16 (dpix_val, tmp_val);
            spix++;
            }
            buf[dpix++] = dpix_val;
        }
    } else if (bplehb) {
        int rem;
        if (((uintptr_t)&buf[dpix]) & 2) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            spix_val = pixdata.apixels[spix] ^ xor_val;
            if (spix_val >= 32 && spix_val < 64) {
                unsigned int c = (colors_for_drawing.color_regs_aga[spix_val - 32] >> 1) & 0x7F7F7F;
                dpix_val = CONVERT_RGB (c);
            } else
                dpix_val = colors_for_drawing.acolors[spix_val];
            {
            uae_u32 tmp_val;
            spix++;
            tmp_val = dpix_val;
            spix_val = pixdata.apixels[spix] ^ xor_val;
            if (spix_val >= 32 && spix_val < 64) {
                unsigned int c = (colors_for_drawing.color_regs_aga[spix_val - 32] >> 1) & 0x7F7F7F;
                dpix_val = CONVERT_RGB (c);
            } else
                dpix_val = colors_for_drawing.acolors[spix_val];
            dpix_val = merge_2pixel16 (dpix_val, tmp_val);
            spix++;
            }
            buf[dpix++] = dpix_val;
        }
        if (dpix >= dpix_end)
            return spix;
        rem = (((uintptr_t)&buf[dpix_end]) & 2);
        if (rem)
            dpix_end--;
        while (dpix < dpix_end) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix] ^ xor_val;
            if (spix_val >= 32 && spix_val < 64) {
                unsigned int c = (colors_for_drawing.color_regs_aga[spix_val - 32] >> 1) & 0x7F7F7F;
                dpix_val = CONVERT_RGB (c);
            } else
                dpix_val = colors_for_drawing.acolors[spix_val];
            {
            uae_u32 tmp_val;
            spix++;
            tmp_val = dpix_val;
            spix_val = pixdata.apixels[spix] ^ xor_val;
            if (spix_val >= 32 && spix_val < 64) {
                unsigned int c = (colors_for_drawing.color_regs_aga[spix_val - 32] >> 1) & 0x7F7F7F;
                dpix_val = CONVERT_RGB (c);
            } else
                dpix_val = colors_for_drawing.acolors[spix_val];
            dpix_val = merge_2pixel16 (dpix_val, tmp_val);
            spix++;
            }
            out_val = dpix_val;
            spix_val = pixdata.apixels[spix] ^ xor_val;
            if (spix_val >= 32 && spix_val < 64) {
                unsigned int c = (colors_for_drawing.color_regs_aga[spix_val - 32] >> 1) & 0x7F7F7F;
                dpix_val = CONVERT_RGB (c);
            } else
                dpix_val = colors_for_drawing.acolors[spix_val];
            {
            uae_u32 tmp_val;
            spix++;
            tmp_val = dpix_val;
            spix_val = pixdata.apixels[spix] ^ xor_val;
            if (spix_val >= 32 && spix_val < 64) {
                unsigned int c = (colors_for_drawing.color_regs_aga[spix_val - 32] >> 1) & 0x7F7F7F;
                dpix_val = CONVERT_RGB (c);
            } else
                dpix_val = colors_for_drawing.acolors[spix_val];
            dpix_val = merge_2pixel16 (dpix_val, tmp_val);
            spix++;
            }
            out_val = (out_val & 0xFFFF) | (dpix_val << 16);
            *((uae_u32 *)&buf[dpix]) = out_val;
            dpix += 2;
        }
        if (rem) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            spix_val = pixdata.apixels[spix] ^ xor_val;
            if (spix_val >= 32 && spix_val < 64) {
                unsigned int c = (colors_for_drawing.color_regs_aga[spix_val - 32] >> 1) & 0x7F7F7F;
                dpix_val = CONVERT_RGB (c);
            } else
                dpix_val = colors_for_drawing.acolors[spix_val];
            {
            uae_u32 tmp_val;
            spix++;
            tmp_val = dpix_val;
            spix_val = pixdata.apixels[spix] ^ xor_val;
            if (spix_val >= 32 && spix_val < 64) {
                unsigned int c = (colors_for_drawing.color_regs_aga[spix_val - 32] >> 1) & 0x7F7F7F;
                dpix_val = CONVERT_RGB (c);
            } else
                dpix_val = colors_for_drawing.acolors[spix_val];
            dpix_val = merge_2pixel16 (dpix_val, tmp_val);
            spix++;
            }
            buf[dpix++] = dpix_val;
        }
    } else {
        int rem;
        if (((uintptr_t)&buf[dpix]) & 2) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            spix_val = pixdata.apixels[spix] ^ xor_val;
            dpix_val = colors_for_drawing.acolors[spix_val];
            {
            uae_u32 tmp_val;
            spix++;
            tmp_val = dpix_val;
            spix_val = pixdata.apixels[spix] ^ xor_val;
            dpix_val = colors_for_drawing.acolors[spix_val];
            dpix_val = merge_2pixel16 (dpix_val, tmp_val);
            spix++;
            }
            buf[dpix++] = dpix_val;
        }
        if (dpix >= dpix_end)
            return spix;
        rem = (((uintptr_t)&buf[dpix_end]) & 2);
        if (rem)
            dpix_end--;
        while (dpix < dpix_end) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix] ^ xor_val;
            dpix_val = colors_for_drawing.acolors[spix_val];
            {
            uae_u32 tmp_val;
            spix++;
            tmp_val = dpix_val;
            spix_val = pixdata.apixels[spix] ^ xor_val;
            dpix_val = colors_for_drawing.acolors[spix_val];
            dpix_val = merge_2pixel16 (dpix_val, tmp_val);
            spix++;
            }
            out_val = dpix_val;
            spix_val = pixdata.apixels[spix] ^ xor_val;
            dpix_val = colors_for_drawing.acolors[spix_val];
            {
            uae_u32 tmp_val;
            spix++;
            tmp_val = dpix_val;
            spix_val = pixdata.apixels[spix] ^ xor_val;
            dpix_val = colors_for_drawing.acolors[spix_val];
            dpix_val = merge_2pixel16 (dpix_val, tmp_val);
            spix++;
            }
            out_val = (out_val & 0xFFFF) | (dpix_val << 16);
            *((uae_u32 *)&buf[dpix]) = out_val;
            dpix += 2;
        }
        if (rem) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            spix_val = pixdata.apixels[spix] ^ xor_val;
            dpix_val = colors_for_drawing.acolors[spix_val];
            {
            uae_u32 tmp_val;
            spix++;
            tmp_val = dpix_val;
            spix_val = pixdata.apixels[spix] ^ xor_val;
            dpix_val = colors_for_drawing.acolors[spix_val];
            dpix_val = merge_2pixel16 (dpix_val, tmp_val);
            spix++;
            }
            buf[dpix++] = dpix_val;
        }
    }

    return spix;
}
#endif

#ifdef AGA
static int NOINLINE __attribute__((__unused__)) linetoscr_16_shrink1f_aga_genlock(int spix, int dpix, int dpix_end)
{
    uae_u16 *buf = (uae_u16 *) xlinebuffer;
    uae_u8 *genlock_buf = xlinebuffer_genlock;
    uae_u8 xor_val = bplxor;

    if (bplham) {
        int rem;
        if (((uintptr_t)&buf[dpix]) & 2) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            spix_val = pixdata.apixels[spix] ^ xor_val;
            spix_val = ham_linebuf[spix];
            dpix_val = CONVERT_RGB (spix_val);
            {
            uae_u32 tmp_val;
            spix++;
            tmp_val = dpix_val;
            spix_val = pixdata.apixels[spix] ^ xor_val;
            spix_val = ham_linebuf[spix];
            dpix_val = CONVERT_RGB (spix_val);
            dpix_val = merge_2pixel16 (dpix_val, tmp_val);
            spix++;
            }
            buf[dpix++] = dpix_val;
        }
        if (dpix >= dpix_end)
            return spix;
        rem = (((uintptr_t)&buf[dpix_end]) & 2);
        if (rem)
            dpix_end--;
        while (dpix < dpix_end) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix] ^ xor_val;
            spix_val = ham_linebuf[spix];
            dpix_val = CONVERT_RGB (spix_val);
            {
            uae_u32 tmp_val;
            spix++;
            tmp_val = dpix_val;
            spix_val = pixdata.apixels[spix] ^ xor_val;
            spix_val = ham_linebuf[spix];
            dpix_val = CONVERT_RGB (spix_val);
            dpix_val = merge_2pixel16 (dpix_val, tmp_val);
            spix++;
            }
            out_val = dpix_val;
            genlock_buf[dpix] = get_genlock_transparency((spix_val >> 2) & 63);
            spix_val = pixdata.apixels[spix] ^ xor_val;
            spix_val = ham_linebuf[spix];
            dpix_val = CONVERT_RGB (spix_val);
            {
            uae_u32 tmp_val;
            spix++;
            tmp_val = dpix_val;
            spix_val = pixdata.apixels[spix] ^ xor_val;
            spix_val = ham_linebuf[spix];
            dpix_val = CONVERT_RGB (spix_val);
            dpix_val = merge_2pixel16 (dpix_val, tmp_val);
            spix++;
            }
            out_val = (out_val & 0xFFFF) | (dpix_val << 16);
            *((uae_u32 *)&buf[dpix]) = out_val;
            dpix += 2;
        }
        if (rem) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            spix_val = pixdata.apixels[spix] ^ xor_val;
            spix_val = ham_linebuf[spix];
            dpix_val = CONVERT_RGB (spix_val);
            {
            uae_u32 tmp_val;
            spix++;
            tmp_val = dpix_val;
            spix_val = pixdata.apixels[spix] ^ xor_val;
            spix_val = ham_linebuf[spix];
            dpix_val = CONVERT_RGB (spix_val);
            dpix_val = merge_2pixel16 (dpix_val, tmp_val);
            spix++;
            }
            buf[dpix++] = dpix_val;
        }
    } else if (bpldualpf) {
        int *lookup    = bpldualpfpri ? dblpf_ind2_aga : dblpf_ind1_aga;
        int *lookup_no = bpldualpfpri ? dblpf_2nd2     : dblpf_2nd1;
        int rem;
        if (((uintptr_t)&buf[dpix]) & 2) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            spix_val = pixdata.apixels[spix];
            {
                uae_u8 val = lookup[spix_val];
                if (lookup_no[spix_val])
                    val += dblpfofs[bpldualpf2of];
                val ^= xor_val;
                dpix_val = colors_for_drawing.acolors[val];
            }
            {
            uae_u32 tmp_val;
            spix++;
            tmp_val = dpix_val;
            spix_val = pixdata.apixels[spix];
            {
                uae_u8 val = lookup[spix_val];
                if (lookup_no[spix_val])
                    val += dblpfofs[bpldualpf2of];
                val ^= xor_val;
                dpix_val = colors_for_drawing.acolors[val];
            }
            dpix_val = merge_2pixel16 (dpix_val, tmp_val);
            spix++;
            }
            buf[dpix++] = dpix_val;
        }
        if (dpix >= dpix_end)
            return spix;
        rem = (((uintptr_t)&buf[dpix_end]) & 2);
        if (rem)
            dpix_end--;
        while (dpix < dpix_end) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix];
            {
                uae_u8 val = lookup[spix_val];
                if (lookup_no[spix_val])
                    val += dblpfofs[bpldualpf2of];
                val ^= xor_val;
                dpix_val = colors_for_drawing.acolors[val];
            }
            {
            uae_u32 tmp_val;
            spix++;
            tmp_val = dpix_val;
            spix_val = pixdata.apixels[spix];
            {
                uae_u8 val = lookup[spix_val];
                if (lookup_no[spix_val])
                    val += dblpfofs[bpldualpf2of];
                val ^= xor_val;
                dpix_val = colors_for_drawing.acolors[val];
            }
            dpix_val = merge_2pixel16 (dpix_val, tmp_val);
            spix++;
            }
            out_val = dpix_val;
            genlock_buf[dpix] = get_genlock_transparency(lookup[spix_val]);
            spix_val = pixdata.apixels[spix];
            {
                uae_u8 val = lookup[spix_val];
                if (lookup_no[spix_val])
                    val += dblpfofs[bpldualpf2of];
                val ^= xor_val;
                dpix_val = colors_for_drawing.acolors[val];
            }
            {
            uae_u32 tmp_val;
            spix++;
            tmp_val = dpix_val;
            spix_val = pixdata.apixels[spix];
            {
                uae_u8 val = lookup[spix_val];
                if (lookup_no[spix_val])
                    val += dblpfofs[bpldualpf2of];
                val ^= xor_val;
                dpix_val = colors_for_drawing.acolors[val];
            }
            dpix_val = merge_2pixel16 (dpix_val, tmp_val);
            spix++;
            }
            out_val = (out_val & 0xFFFF) | (dpix_val << 16);
            *((uae_u32 *)&buf[dpix]) = out_val;
            dpix += 2;
        }
        if (rem) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            spix_val = pixdata.apixels[spix];
            {
                uae_u8 val = lookup[spix_val];
                if (lookup_no[spix_val])
                    val += dblpfofs[bpldualpf2of];
                val ^= xor_val;
                dpix_val = colors_for_drawing.acolors[val];
            }
            {
            uae_u32 tmp_val;
            spix++;
            tmp_val = dpix_val;
            spix_val = pixdata.apixels[spix];
            {
                uae_u8 val = lookup[spix_val];
                if (lookup_no[spix_val])
                    val += dblpfofs[bpldualpf2of];
                val ^= xor_val;
                dpix_val = colors_for_drawing.acolors[val];
            }
            dpix_val = merge_2pixel16 (dpix_val, tmp_val);
            spix++;
            }
            buf[dpix++] = dpix_val;
        }
    } else if (bplehb) {
        int rem;
        if (((uintptr_t)&buf[dpix]) & 2) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            spix_val = pixdata.apixels[spix] ^ xor_val;
            if (spix_val >= 32 && spix_val < 64) {
                unsigned int c = (colors_for_drawing.color_regs_aga[spix_val - 32] >> 1) & 0x7F7F7F;
                dpix_val = CONVERT_RGB (c);
            } else
                dpix_val = colors_for_drawing.acolors[spix_val];
            {
            uae_u32 tmp_val;
            spix++;
            tmp_val = dpix_val;
            spix_val = pixdata.apixels[spix] ^ xor_val;
            if (spix_val >= 32 && spix_val < 64) {
                unsigned int c = (colors_for_drawing.color_regs_aga[spix_val - 32] >> 1) & 0x7F7F7F;
                dpix_val = CONVERT_RGB (c);
            } else
                dpix_val = colors_for_drawing.acolors[spix_val];
            dpix_val = merge_2pixel16 (dpix_val, tmp_val);
            spix++;
            }
            buf[dpix++] = dpix_val;
        }
        if (dpix >= dpix_end)
            return spix;
        rem = (((uintptr_t)&buf[dpix_end]) & 2);
        if (rem)
            dpix_end--;
        while (dpix < dpix_end) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix] ^ xor_val;
            if (spix_val >= 32 && spix_val < 64) {
                unsigned int c = (colors_for_drawing.color_regs_aga[spix_val - 32] >> 1) & 0x7F7F7F;
                dpix_val = CONVERT_RGB (c);
            } else
                dpix_val = colors_for_drawing.acolors[spix_val];
            {
            uae_u32 tmp_val;
            spix++;
            tmp_val = dpix_val;
            spix_val = pixdata.apixels[spix] ^ xor_val;
            if (spix_val >= 32 && spix_val < 64) {
                unsigned int c = (colors_for_drawing.color_regs_aga[spix_val - 32] >> 1) & 0x7F7F7F;
                dpix_val = CONVERT_RGB (c);
            } else
                dpix_val = colors_for_drawing.acolors[spix_val];
            dpix_val = merge_2pixel16 (dpix_val, tmp_val);
            spix++;
            }
            out_val = dpix_val;
            genlock_buf[dpix] = get_genlock_transparency(spix_val & 31);
            spix_val = pixdata.apixels[spix] ^ xor_val;
            if (spix_val >= 32 && spix_val < 64) {
                unsigned int c = (colors_for_drawing.color_regs_aga[spix_val - 32] >> 1) & 0x7F7F7F;
                dpix_val = CONVERT_RGB (c);
            } else
                dpix_val = colors_for_drawing.acolors[spix_val];
            {
            uae_u32 tmp_val;
            spix++;
            tmp_val = dpix_val;
            spix_val = pixdata.apixels[spix] ^ xor_val;
            if (spix_val >= 32 && spix_val < 64) {
                unsigned int c = (colors_for_drawing.color_regs_aga[spix_val - 32] >> 1) & 0x7F7F7F;
                dpix_val = CONVERT_RGB (c);
            } else
                dpix_val = colors_for_drawing.acolors[spix_val];
            dpix_val = merge_2pixel16 (dpix_val, tmp_val);
            spix++;
            }
            out_val = (out_val & 0xFFFF) | (dpix_val << 16);
            *((uae_u32 *)&buf[dpix]) = out_val;
            dpix += 2;
        }
        if (rem) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            spix_val = pixdata.apixels[spix] ^ xor_val;
            if (spix_val >= 32 && spix_val < 64) {
                unsigned int c = (colors_for_drawing.color_regs_aga[spix_val - 32] >> 1) & 0x7F7F7F;
                dpix_val = CONVERT_RGB (c);
            } else
                dpix_val = colors_for_drawing.acolors[spix_val];
            {
            uae_u32 tmp_val;
            spix++;
            tmp_val = dpix_val;
            spix_val = pixdata.apixels[spix] ^ xor_val;
            if (spix_val >= 32 && spix_val < 64) {
                unsigned int c = (colors_for_drawing.color_regs_aga[spix_val - 32] >> 1) & 0x7F7F7F;
                dpix_val = CONVERT_RGB (c);
            } else
                dpix_val = colors_for_drawing.acolors[spix_val];
            dpix_val = merge_2pixel16 (dpix_val, tmp_val);
            spix++;
            }
            buf[dpix++] = dpix_val;
        }
    } else {
        int rem;
        if (((uintptr_t)&buf[dpix]) & 2) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            spix_val = pixdata.apixels[spix] ^ xor_val;
            dpix_val = colors_for_drawing.acolors[spix_val];
            {
            uae_u32 tmp_val;
            spix++;
            tmp_val = dpix_val;
            spix_val = pixdata.apixels[spix] ^ xor_val;
            dpix_val = colors_for_drawing.acolors[spix_val];
            dpix_val = merge_2pixel16 (dpix_val, tmp_val);
            spix++;
            }
            buf[dpix++] = dpix_val;
        }
        if (dpix >= dpix_end)
            return spix;
        rem = (((uintptr_t)&buf[dpix_end]) & 2);
        if (rem)
            dpix_end--;
        while (dpix < dpix_end) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix] ^ xor_val;
            dpix_val = colors_for_drawing.acolors[spix_val];
            {
            uae_u32 tmp_val;
            spix++;
            tmp_val = dpix_val;
            spix_val = pixdata.apixels[spix] ^ xor_val;
            dpix_val = colors_for_drawing.acolors[spix_val];
            dpix_val = merge_2pixel16 (dpix_val, tmp_val);
            spix++;
            }
            out_val = dpix_val;
            genlock_buf[dpix] = get_genlock_transparency(spix_val);
            spix_val = pixdata.apixels[spix] ^ xor_val;
            dpix_val = colors_for_drawing.acolors[spix_val];
            {
            uae_u32 tmp_val;
            spix++;
            tmp_val = dpix_val;
            spix_val = pixdata.apixels[spix] ^ xor_val;
            dpix_val = colors_for_drawing.acolors[spix_val];
            dpix_val = merge_2pixel16 (dpix_val, tmp_val);
            spix++;
            }
            out_val = (out_val & 0xFFFF) | (dpix_val << 16);
            *((uae_u32 *)&buf[dpix]) = out_val;
            dpix += 2;
        }
        if (rem) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            spix_val = pixdata.apixels[spix] ^ xor_val;
            dpix_val = colors_for_drawing.acolors[spix_val];
            {
            uae_u32 tmp_val;
            spix++;
            tmp_val = dpix_val;
            spix_val = pixdata.apixels[spix] ^ xor_val;
            dpix_val = colors_for_drawing.acolors[spix_val];
            dpix_val = merge_2pixel16 (dpix_val, tmp_val);
            spix++;
            }
            buf[dpix++] = dpix_val;
        }
    }

    return spix;
}
#endif

#ifdef AGA
static int NOINLINE __attribute__((__unused__)) linetoscr_16_shrink2_aga(int spix, int dpix, int dpix_end)
{
    uae_u16 *buf = (uae_u16 *) xlinebuffer;
    uae_u8 xor_val = bplxor;

    if (bplham) {
        int rem;
        if (((uintptr_t)&buf[dpix]) & 2) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            spix_val = pixdata.apixels[spix] ^ xor_val;
            spix_val = ham_linebuf[spix];
            dpix_val = CONVERT_RGB (spix_val);
            spix += 4;
            buf[dpix++] = dpix_val;
        }
        if (dpix >= dpix_end)
            return spix;
        rem = (((uintptr_t)&buf[dpix_end]) & 2);
        if (rem)
            dpix_end--;
        while (dpix < dpix_end) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix] ^ xor_val;
            spix_val = ham_linebuf[spix];
            dpix_val = CONVERT_RGB (spix_val);
            spix += 4;
            out_val = dpix_val;
            spix_val = pixdata.apixels[spix] ^ xor_val;
            spix_val = ham_linebuf[spix];
            dpix_val = CONVERT_RGB (spix_val);
            spix += 4;
            out_val = (out_val & 0xFFFF) | (dpix_val << 16);
            *((uae_u32 *)&buf[dpix]) = out_val;
            dpix += 2;
        }
        if (rem) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            spix_val = pixdata.apixels[spix] ^ xor_val;
            spix_val = ham_linebuf[spix];
            dpix_val = CONVERT_RGB (spix_val);
            spix += 4;
            buf[dpix++] = dpix_val;
        }
    } else if (bpldualpf) {
        int *lookup    = bpldualpfpri ? dblpf_ind2_aga : dblpf_ind1_aga;
        int *lookup_no = bpldualpfpri ? dblpf_2nd2     : dblpf_2nd1;
        int rem;
        if (((uintptr_t)&buf[dpix]) & 2) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            spix_val = pixdata.apixels[spix];
            {
                uae_u8 val = lookup[spix_val];
                if (lookup_no[spix_val])
                    val += dblpfofs[bpldualpf2of];
                val ^= xor_val;
                dpix_val = colors_for_drawing.acolors[val];
            }
            spix += 4;
            buf[dpix++] = dpix_val;
        }
        if (dpix >= dpix_end)
            return spix;
        rem = (((uintptr_t)&buf[dpix_end]) & 2);
        if (rem)
            dpix_end--;
        while (dpix < dpix_end) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix];
            {
                uae_u8 val = lookup[spix_val];
                if (lookup_no[spix_val])
                    val += dblpfofs[bpldualpf2of];
                val ^= xor_val;
                dpix_val = colors_for_drawing.acolors[val];
            }
            spix += 4;
            out_val = dpix_val;
            spix_val = pixdata.apixels[spix];
            {
                uae_u8 val = lookup[spix_val];
                if (lookup_no[spix_val])
                    val += dblpfofs[bpldualpf2of];
                val ^= xor_val;
                dpix_val = colors_for_drawing.acolors[val];
            }
            spix += 4;
            out_val = (out_val & 0xFFFF) | (dpix_val << 16);
            *((uae_u32 *)&buf[dpix]) = out_val;
            dpix += 2;
        }
        if (rem) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            spix_val = pixdata.apixels[spix];
            {
                uae_u8 val = lookup[spix_val];
                if (lookup_no[spix_val])
                    val += dblpfofs[bpldualpf2of];
                val ^= xor_val;
                dpix_val = colors_for_drawing.acolors[val];
            }
            spix += 4;
            buf[dpix++] = dpix_val;
        }
    } else if (bplehb) {
        int rem;
        if (((uintptr_t)&buf[dpix]) & 2) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            spix_val = pixdata.apixels[spix] ^ xor_val;
            if (spix_val >= 32 && spix_val < 64) {
                unsigned int c = (colors_for_drawing.color_regs_aga[spix_val - 32] >> 1) & 0x7F7F7F;
                dpix_val = CONVERT_RGB (c);
            } else
                dpix_val = colors_for_drawing.acolors[spix_val];
            spix += 4;
            buf[dpix++] = dpix_val;
        }
        if (dpix >= dpix_end)
            return spix;
        rem = (((uintptr_t)&buf[dpix_end]) & 2);
        if (rem)
            dpix_end--;
        while (dpix < dpix_end) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix] ^ xor_val;
            if (spix_val >= 32 && spix_val < 64) {
                unsigned int c = (colors_for_drawing.color_regs_aga[spix_val - 32] >> 1) & 0x7F7F7F;
                dpix_val = CONVERT_RGB (c);
            } else
                dpix_val = colors_for_drawing.acolors[spix_val];
            spix += 4;
            out_val = dpix_val;
            spix_val = pixdata.apixels[spix] ^ xor_val;
            if (spix_val >= 32 && spix_val < 64) {
                unsigned int c = (colors_for_drawing.color_regs_aga[spix_val - 32] >> 1) & 0x7F7F7F;
                dpix_val = CONVERT_RGB (c);
            } else
                dpix_val = colors_for_drawing.acolors[spix_val];
            spix += 4;
            out_val = (out_val & 0xFFFF) | (dpix_val << 16);
            *((uae_u32 *)&buf[dpix]) = out_val;
            dpix += 2;
        }
        if (rem) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            spix_val = pixdata.apixels[spix] ^ xor_val;
            if (spix_val >= 32 && spix_val < 64) {
                unsigned int c = (colors_for_drawing.color_regs_aga[spix_val - 32] >> 1) & 0x7F7F7F;
                dpix_val = CONVERT_RGB (c);
            } else
                dpix_val = colors_for_drawing.acolors[spix_val];
            spix += 4;
            buf[dpix++] = dpix_val;
        }
    } else {
        int rem;
        if (((uintptr_t)&buf[dpix]) & 2) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            spix_val = pixdata.apixels[spix] ^ xor_val;
            dpix_val = colors_for_drawing.acolors[spix_val];
            spix += 4;
            buf[dpix++] = dpix_val;
        }
        if (dpix >= dpix_end)
            return spix;
        rem = (((uintptr_t)&buf[dpix_end]) & 2);
        if (rem)
            dpix_end--;
        while (dpix < dpix_end) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix] ^ xor_val;
            dpix_val = colors_for_drawing.acolors[spix_val];
            spix += 4;
            out_val = dpix_val;
            spix_val = pixdata.apixels[spix] ^ xor_val;
            dpix_val = colors_for_drawing.acolors[spix_val];
            spix += 4;
            out_val = (out_val & 0xFFFF) | (dpix_val << 16);
            *((uae_u32 *)&buf[dpix]) = out_val;
            dpix += 2;
        }
        if (rem) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            spix_val = pixdata.apixels[spix] ^ xor_val;
            dpix_val = colors_for_drawing.acolors[spix_val];
            spix += 4;
            buf[dpix++] = dpix_val;
        }
    }

    return spix;
}
#endif

#ifdef AGA
static int NOINLINE __attribute__((__unused__)) linetoscr_16_shrink2_aga_genlock(int spix, int dpix, int dpix_end)
{
    uae_u16 *buf = (uae_u16 *) xlinebuffer;
    uae_u8 *genlock_buf = xlinebuffer_genlock;
    uae_u8 xor_val = bplxor;

    if (bplham) {
        int rem;
        if (((uintptr_t)&buf[dpix]) & 2) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            spix_val = pixdata.apixels[spix] ^ xor_val;
            spix_val = ham_linebuf[spix];
            dpix_val = CONVERT_RGB (spix_val);
            spix += 4;
            buf[dpix++] = dpix_val;
        }
        if (dpix >= dpix_end)
            return spix;
        rem = (((uintptr_t)&buf[dpix_end]) & 2);
        if (rem)
            dpix_end--;
        while (dpix < dpix_end) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix] ^ xor_val;
            spix_val = ham_linebuf[spix];
            dpix_val = CONVERT_RGB (spix_val);
            spix += 4;
            out_val = dpix_val;
            genlock_buf[dpix] = get_genlock_transparency((spix_val >> 2) & 63);
            spix_val = pixdata.apixels[spix] ^ xor_val;
            spix_val = ham_linebuf[spix];
            dpix_val = CONVERT_RGB (spix_val);
            spix += 4;
            out_val = (out_val & 0xFFFF) | (dpix_val << 16);
            *((uae_u32 *)&buf[dpix]) = out_val;
            dpix += 2;
        }
        if (rem) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            spix_val = pixdata.apixels[spix] ^ xor_val;
            spix_val = ham_linebuf[spix];
            dpix_val = CONVERT_RGB (spix_val);
            spix += 4;
            buf[dpix++] = dpix_val;
        }
    } else if (bpldualpf) {
        int *lookup    = bpldualpfpri ? dblpf_ind2_aga : dblpf_ind1_aga;
        int *lookup_no = bpldualpfpri ? dblpf_2nd2     : dblpf_2nd1;
        int rem;
        if (((uintptr_t)&buf[dpix]) & 2) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            spix_val = pixdata.apixels[spix];
            {
                uae_u8 val = lookup[spix_val];
                if (lookup_no[spix_val])
                    val += dblpfofs[bpldualpf2of];
                val ^= xor_val;
                dpix_val = colors_for_drawing.acolors[val];
            }
            spix += 4;
            buf[dpix++] = dpix_val;
        }
        if (dpix >= dpix_end)
            return spix;
        rem = (((uintptr_t)&buf[dpix_end]) & 2);
        if (rem)
            dpix_end--;
        while (dpix < dpix_end) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix];
            {
                uae_u8 val = lookup[spix_val];
                if (lookup_no[spix_val])
                    val += dblpfofs[bpldualpf2of];
                val ^= xor_val;
                dpix_val = colors_for_drawing.acolors[val];
            }
            spix += 4;
            out_val = dpix_val;
            genlock_buf[dpix] = get_genlock_transparency(lookup[spix_val]);
            spix_val = pixdata.apixels[spix];
            {
                uae_u8 val = lookup[spix_val];
                if (lookup_no[spix_val])
                    val += dblpfofs[bpldualpf2of];
                val ^= xor_val;
                dpix_val = colors_for_drawing.acolors[val];
            }
            spix += 4;
            out_val = (out_val & 0xFFFF) | (dpix_val << 16);
            *((uae_u32 *)&buf[dpix]) = out_val;
            dpix += 2;
        }
        if (rem) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            spix_val = pixdata.apixels[spix];
            {
                uae_u8 val = lookup[spix_val];
                if (lookup_no[spix_val])
                    val += dblpfofs[bpldualpf2of];
                val ^= xor_val;
                dpix_val = colors_for_drawing.acolors[val];
            }
            spix += 4;
            buf[dpix++] = dpix_val;
        }
    } else if (bplehb) {
        int rem;
        if (((uintptr_t)&buf[dpix]) & 2) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            spix_val = pixdata.apixels[spix] ^ xor_val;
            if (spix_val >= 32 && spix_val < 64) {
                unsigned int c = (colors_for_drawing.color_regs_aga[spix_val - 32] >> 1) & 0x7F7F7F;
                dpix_val = CONVERT_RGB (c);
            } else
                dpix_val = colors_for_drawing.acolors[spix_val];
            spix += 4;
            buf[dpix++] = dpix_val;
        }
        if (dpix >= dpix_end)
            return spix;
        rem = (((uintptr_t)&buf[dpix_end]) & 2);
        if (rem)
            dpix_end--;
        while (dpix < dpix_end) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix] ^ xor_val;
            if (spix_val >= 32 && spix_val < 64) {
                unsigned int c = (colors_for_drawing.color_regs_aga[spix_val - 32] >> 1) & 0x7F7F7F;
                dpix_val = CONVERT_RGB (c);
            } else
                dpix_val = colors_for_drawing.acolors[spix_val];
            spix += 4;
            out_val = dpix_val;
            genlock_buf[dpix] = get_genlock_transparency(spix_val & 31);
            spix_val = pixdata.apixels[spix] ^ xor_val;
            if (spix_val >= 32 && spix_val < 64) {
                unsigned int c = (colors_for_drawing.color_regs_aga[spix_val - 32] >> 1) & 0x7F7F7F;
                dpix_val = CONVERT_RGB (c);
            } else
                dpix_val = colors_for_drawing.acolors[spix_val];
            spix += 4;
            out_val = (out_val & 0xFFFF) | (dpix_val << 16);
            *((uae_u32 *)&buf[dpix]) = out_val;
            dpix += 2;
        }
        if (rem) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            spix_val = pixdata.apixels[spix] ^ xor_val;
            if (spix_val >= 32 && spix_val < 64) {
                unsigned int c = (colors_for_drawing.color_regs_aga[spix_val - 32] >> 1) & 0x7F7F7F;
                dpix_val = CONVERT_RGB (c);
            } else
                dpix_val = colors_for_drawing.acolors[spix_val];
            spix += 4;
            buf[dpix++] = dpix_val;
        }
    } else {
        int rem;
        if (((uintptr_t)&buf[dpix]) & 2) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            spix_val = pixdata.apixels[spix] ^ xor_val;
            dpix_val = colors_for_drawing.acolors[spix_val];
            spix += 4;
            buf[dpix++] = dpix_val;
        }
        if (dpix >= dpix_end)
            return spix;
        rem = (((uintptr_t)&buf[dpix_end]) & 2);
        if (rem)
            dpix_end--;
        while (dpix < dpix_end) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix] ^ xor_val;
            dpix_val = colors_for_drawing.acolors[spix_val];
            spix += 4;
            out_val = dpix_val;
            genlock_buf[dpix] = get_genlock_transparency(spix_val);
            spix_val = pixdata.apixels[spix] ^ xor_val;
            dpix_val = colors_for_drawing.acolors[spix_val];
            spix += 4;
            out_val = (out_val & 0xFFFF) | (dpix_val << 16);
            *((uae_u32 *)&buf[dpix]) = out_val;
            dpix += 2;
        }
        if (rem) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            spix_val = pixdata.apixels[spix] ^ xor_val;
            dpix_val = colors_for_drawing.acolors[spix_val];
            spix += 4;
            buf[dpix++] = dpix_val;
        }
    }

    return spix;
}
#endif

#ifdef AGA
static int NOINLINE __attribute__((__unused__)) linetoscr_16_shrink2f_aga(int spix, int dpix, int dpix_end)
{
    uae_u16 *buf = (uae_u16 *) xlinebuffer;
    uae_u8 xor_val = bplxor;

    if (bplham) {
        int rem;
        if (((uintptr_t)&buf[dpix]) & 2) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            spix_val = pixdata.apixels[spix] ^ xor_val;
            spix_val = ham_linebuf[spix];
            dpix_val = CONVERT_RGB (spix_val);
            {
            uae_u32 tmp_val, tmp_val2, tmp_val3;
            spix++;
            tmp_val = dpix_val;
            spix_val = pixdata.apixels[spix] ^ xor_val;
            spix_val = ham_linebuf[spix];
            dpix_val = CONVERT_RGB (spix_val);
            spix++;
            tmp_val2 = dpix_val;
            spix_val = pixdata.apixels[spix] ^ xor_val;
            spix_val = ham_linebuf[spix];
            dpix_val = CONVERT_RGB (spix_val);
            spix++;
            tmp_val3 = dpix_val;
            spix_val = pixdata.apixels[spix] ^ xor_val;
            spix_val = ham_linebuf[spix];
            dpix_val = CONVERT_RGB (spix_val);
            tmp_val = merge_2pixel16 (tmp_val, tmp_val2);
            tmp_val2 = merge_2pixel16 (tmp_val3, dpix_val);
            dpix_val = merge_2pixel16 (tmp_val, tmp_val2);
            spix++;
            }
            buf[dpix++] = dpix_val;
        }
        if (dpix >= dpix_end)
            return spix;
        rem = (((uintptr_t)&buf[dpix_end]) & 2);
        if (rem)
            dpix_end--;
        while (dpix < dpix_end) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix] ^ xor_val;
            spix_val = ham_linebuf[spix];
            dpix_val = CONVERT_RGB (spix_val);
            {
            uae_u32 tmp_val, tmp_val2, tmp_val3;
            spix++;
            tmp_val = dpix_val;
            spix_val = pixdata.apixels[spix] ^ xor_val;
            spix_val = ham_linebuf[spix];
            dpix_val = CONVERT_RGB (spix_val);
            spix++;
            tmp_val2 = dpix_val;
            spix_val = pixdata.apixels[spix] ^ xor_val;
            spix_val = ham_linebuf[spix];
            dpix_val = CONVERT_RGB (spix_val);
            spix++;
            tmp_val3 = dpix_val;
            spix_val = pixdata.apixels[spix] ^ xor_val;
            spix_val = ham_linebuf[spix];
            dpix_val = CONVERT_RGB (spix_val);
            tmp_val = merge_2pixel16 (tmp_val, tmp_val2);
            tmp_val2 = merge_2pixel16 (tmp_val3, dpix_val);
            dpix_val = merge_2pixel16 (tmp_val, tmp_val2);
            spix++;
            }
            out_val = dpix_val;
            spix_val = pixdata.apixels[spix] ^ xor_val;
            spix_val = ham_linebuf[spix];
            dpix_val = CONVERT_RGB (spix_val);
            {
            uae_u32 tmp_val, tmp_val2, tmp_val3;
            spix++;
            tmp_val = dpix_val;
            spix_val = pixdata.apixels[spix] ^ xor_val;
            spix_val = ham_linebuf[spix];
            dpix_val = CONVERT_RGB (spix_val);
            spix++;
            tmp_val2 = dpix_val;
            spix_val = pixdata.apixels[spix] ^ xor_val;
            spix_val = ham_linebuf[spix];
            dpix_val = CONVERT_RGB (spix_val);
            spix++;
            tmp_val3 = dpix_val;
            spix_val = pixdata.apixels[spix] ^ xor_val;
            spix_val = ham_linebuf[spix];
            dpix_val = CONVERT_RGB (spix_val);
            tmp_val = merge_2pixel16 (tmp_val, tmp_val2);
            tmp_val2 = merge_2pixel16 (tmp_val3, dpix_val);
            dpix_val = merge_2pixel16 (tmp_val, tmp_val2);
            spix++;
            }
            out_val = (out_val & 0xFFFF) | (dpix_val << 16);
            *((uae_u32 *)&buf[dpix]) = out_val;
            dpix += 2;
        }
        if (rem) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            spix_val = pixdata.apixels[spix] ^ xor_val;
            spix_val = ham_linebuf[spix];
            dpix_val = CONVERT_RGB (spix_val);
            {
            uae_u32 tmp_val, tmp_val2, tmp_val3;
            spix++;
            tmp_val = dpix_val;
            spix_val = pixdata.apixels[spix] ^ xor_val;
            spix_val = ham_linebuf[spix];
            dpix_val = CONVERT_RGB (spix_val);
            spix++;
            tmp_val2 = dpix_val;
            spix_val = pixdata.apixels[spix] ^ xor_val;
            spix_val = ham_linebuf[spix];
            dpix_val = CONVERT_RGB (spix_val);
            spix++;
            tmp_val3 = dpix_val;
            spix_val = pixdata.apixels[spix] ^ xor_val;
            spix_val = ham_linebuf[spix];
            dpix_val = CONVERT_RGB (spix_val);
            tmp_val = merge_2pixel16 (tmp_val, tmp_val2);
            tmp_val2 = merge_2pixel16 (tmp_val3, dpix_val);
            dpix_val = merge_2pixel16 (tmp_val, tmp_val2);
            spix++;
            }
            buf[dpix++] = dpix_val;
        }
    } else if (bpldualpf) {
        int *lookup    = bpldualpfpri ? dblpf_ind2_aga : dblpf_ind1_aga;
        int *lookup_no = bpldualpfpri ? dblpf_2nd2     : dblpf_2nd1;
        int rem;
        if (((uintptr_t)&buf[dpix]) & 2) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            spix_val = pixdata.apixels[spix];
            {
                uae_u8 val = lookup[spix_val];
                if (lookup_no[spix_val])
                    val += dblpfofs[bpldualpf2of];
                val ^= xor_val;
                dpix_val = colors_for_drawing.acolors[val];
            }
            {
            uae_u32 tmp_val, tmp_val2, tmp_val3;
            spix++;
            tmp_val = dpix_val;
            spix_val = pixdata.apixels[spix];
            {
                uae_u8 val = lookup[spix_val];
                if (lookup_no[spix_val])
                    val += dblpfofs[bpldualpf2of];
                val ^= xor_val;
                dpix_val = colors_for_drawing.acolors[val];
            }
            spix++;
            tmp_val2 = dpix_val;
            spix_val = pixdata.apixels[spix];
            {
                uae_u8 val = lookup[spix_val];
                if (lookup_no[spix_val])
                    val += dblpfofs[bpldualpf2of];
                val ^= xor_val;
                dpix_val = colors_for_drawing.acolors[val];
            }
            spix++;
            tmp_val3 = dpix_val;
            spix_val = pixdata.apixels[spix];
            {
                uae_u8 val = lookup[spix_val];
                if (lookup_no[spix_val])
                    val += dblpfofs[bpldualpf2of];
                val ^= xor_val;
                dpix_val = colors_for_drawing.acolors[val];
            }
            tmp_val = merge_2pixel16 (tmp_val, tmp_val2);
            tmp_val2 = merge_2pixel16 (tmp_val3, dpix_val);
            dpix_val = merge_2pixel16 (tmp_val, tmp_val2);
            spix++;
            }
            buf[dpix++] = dpix_val;
        }
        if (dpix >= dpix_end)
            return spix;
        rem = (((uintptr_t)&buf[dpix_end]) & 2);
        if (rem)
            dpix_end--;
        while (dpix < dpix_end) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix];
            {
                uae_u8 val = lookup[spix_val];
                if (lookup_no[spix_val])
                    val += dblpfofs[bpldualpf2of];
                val ^= xor_val;
                dpix_val = colors_for_drawing.acolors[val];
            }
            {
            uae_u32 tmp_val, tmp_val2, tmp_val3;
            spix++;
            tmp_val = dpix_val;
            spix_val = pixdata.apixels[spix];
            {
                uae_u8 val = lookup[spix_val];
                if (lookup_no[spix_val])
                    val += dblpfofs[bpldualpf2of];
                val ^= xor_val;
                dpix_val = colors_for_drawing.acolors[val];
            }
            spix++;
            tmp_val2 = dpix_val;
            spix_val = pixdata.apixels[spix];
            {
                uae_u8 val = lookup[spix_val];
                if (lookup_no[spix_val])
                    val += dblpfofs[bpldualpf2of];
                val ^= xor_val;
                dpix_val = colors_for_drawing.acolors[val];
            }
            spix++;
            tmp_val3 = dpix_val;
            spix_val = pixdata.apixels[spix];
            {
                uae_u8 val = lookup[spix_val];
                if (lookup_no[spix_val])
                    val += dblpfofs[bpldualpf2of];
                val ^= xor_val;
                dpix_val = colors_for_drawing.acolors[val];
            }
            tmp_val = merge_2pixel16 (tmp_val, tmp_val2);
            tmp_val2 = merge_2pixel16 (tmp_val3, dpix_val);
            dpix_val = merge_2pixel16 (tmp_val, tmp_val2);
            spix++;
            }
            out_val = dpix_val;
            spix_val = pixdata.apixels[spix];
            {
                uae_u8 val = lookup[spix_val];
                if (lookup_no[spix_val])
                    val += dblpfofs[bpldualpf2of];
                val ^= xor_val;
                dpix_val = colors_for_drawing.acolors[val];
            }
            {
            uae_u32 tmp_val, tmp_val2, tmp_val3;
            spix++;
            tmp_val = dpix_val;
            spix_val = pixdata.apixels[spix];
            {
                uae_u8 val = lookup[spix_val];
                if (lookup_no[spix_val])
                    val += dblpfofs[bpldualpf2of];
                val ^= xor_val;
                dpix_val = colors_for_drawing.acolors[val];
            }
            spix++;
            tmp_val2 = dpix_val;
            spix_val = pixdata.apixels[spix];
            {
                uae_u8 val = lookup[spix_val];
                if (lookup_no[spix_val])
                    val += dblpfofs[bpldualpf2of];
                val ^= xor_val;
                dpix_val = colors_for_drawing.acolors[val];
            }
            spix++;
            tmp_val3 = dpix_val;
            spix_val = pixdata.apixels[spix];
            {
                uae_u8 val = lookup[spix_val];
                if (lookup_no[spix_val])
                    val += dblpfofs[bpldualpf2of];
                val ^= xor_val;
                dpix_val = colors_for_drawing.acolors[val];
            }
            tmp_val = merge_2pixel16 (tmp_val, tmp_val2);
            tmp_val2 = merge_2pixel16 (tmp_val3, dpix_val);
            dpix_val = merge_2pixel16 (tmp_val, tmp_val2);
            spix++;
            }
            out_val = (out_val & 0xFFFF) | (dpix_val << 16);
            *((uae_u32 *)&buf[dpix]) = out_val;
            dpix += 2;
        }
        if (rem) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            spix_val = pixdata.apixels[spix];
            {
                uae_u8 val = lookup[spix_val];
                if (lookup_no[spix_val])
                    val += dblpfofs[bpldualpf2of];
                val ^= xor_val;
                dpix_val = colors_for_drawing.acolors[val];
            }
            {
            uae_u32 tmp_val, tmp_val2, tmp_val3;
            spix++;
            tmp_val = dpix_val;
            spix_val = pixdata.apixels[spix];
            {
                uae_u8 val = lookup[spix_val];
                if (lookup_no[spix_val])
                    val += dblpfofs[bpldualpf2of];
                val ^= xor_val;
                dpix_val = colors_for_drawing.acolors[val];
            }
            spix++;
            tmp_val2 = dpix_val;
            spix_val = pixdata.apixels[spix];
            {
                uae_u8 val = lookup[spix_val];
                if (lookup_no[spix_val])
                    val += dblpfofs[bpldualpf2of];
                val ^= xor_val;
                dpix_val = colors_for_drawing.acolors[val];
            }
            spix++;
            tmp_val3 = dpix_val;
            spix_val = pixdata.apixels[spix];
            {
                uae_u8 val = lookup[spix_val];
                if (lookup_no[spix_val])
                    val += dblpfofs[bpldualpf2of];
                val ^= xor_val;
                dpix_val = colors_for_drawing.acolors[val];
            }
            tmp_val = merge_2pixel16 (tmp_val, tmp_val2);
            tmp_val2 = merge_2pixel16 (tmp_val3, dpix_val);
            dpix_val = merge_2pixel16 (tmp_val, tmp_val2);
            spix++;
            }
            buf[dpix++] = dpix_val;
        }
    } else if (bplehb) {
        int rem;
        if (((uintptr_t)&buf[dpix]) & 2) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            spix_val = pixdata.apixels[spix] ^ xor_val;
            if (spix_val >= 32 && spix_val < 64) {
                unsigned int c = (colors_for_drawing.color_regs_aga[spix_val - 32] >> 1) & 0x7F7F7F;
                dpix_val = CONVERT_RGB (c);
            } else
                dpix_val = colors_for_drawing.acolors[spix_val];
            {
            uae_u32 tmp_val, tmp_val2, tmp_val3;
            spix++;
            tmp_val = dpix_val;
            spix_val = pixdata.apixels[spix] ^ xor_val;
            if (spix_val >= 32 && spix_val < 64) {
                unsigned int c = (colors_for_drawing.color_regs_aga[spix_val - 32] >> 1) & 0x7F7F7F;
                dpix_val = CONVERT_RGB (c);
            } else
                dpix_val = colors_for_drawing.acolors[spix_val];
            spix++;
            tmp_val2 = dpix_val;
            spix_val = pixdata.apixels[spix] ^ xor_val;
            if (spix_val >= 32 && spix_val < 64) {
                unsigned int c = (colors_for_drawing.color_regs_aga[spix_val - 32] >> 1) & 0x7F7F7F;
                dpix_val = CONVERT_RGB (c);
            } else
                dpix_val = colors_for_drawing.acolors[spix_val];
            spix++;
            tmp_val3 = dpix_val;
            spix_val = pixdata.apixels[spix] ^ xor_val;
            if (spix_val >= 32 && spix_val < 64) {
                unsigned int c = (colors_for_drawing.color_regs_aga[spix_val - 32] >> 1) & 0x7F7F7F;
                dpix_val = CONVERT_RGB (c);
            } else
                dpix_val = colors_for_drawing.acolors[spix_val];
            tmp_val = merge_2pixel16 (tmp_val, tmp_val2);
            tmp_val2 = merge_2pixel16 (tmp_val3, dpix_val);
            dpix_val = merge_2pixel16 (tmp_val, tmp_val2);
            spix++;
            }
            buf[dpix++] = dpix_val;
        }
        if (dpix >= dpix_end)
            return spix;
        rem = (((uintptr_t)&buf[dpix_end]) & 2);
        if (rem)
            dpix_end--;
        while (dpix < dpix_end) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix] ^ xor_val;
            if (spix_val >= 32 && spix_val < 64) {
                unsigned int c = (colors_for_drawing.color_regs_aga[spix_val - 32] >> 1) & 0x7F7F7F;
                dpix_val = CONVERT_RGB (c);
            } else
                dpix_val = colors_for_drawing.acolors[spix_val];
            {
            uae_u32 tmp_val, tmp_val2, tmp_val3;
            spix++;
            tmp_val = dpix_val;
            spix_val = pixdata.apixels[spix] ^ xor_val;
            if (spix_val >= 32 && spix_val < 64) {
                unsigned int c = (colors_for_drawing.color_regs_aga[spix_val - 32] >> 1) & 0x7F7F7F;
                dpix_val = CONVERT_RGB (c);
            } else
                dpix_val = colors_for_drawing.acolors[spix_val];
            spix++;
            tmp_val2 = dpix_val;
            spix_val = pixdata.apixels[spix] ^ xor_val;
            if (spix_val >= 32 && spix_val < 64) {
                unsigned int c = (colors_for_drawing.color_regs_aga[spix_val - 32] >> 1) & 0x7F7F7F;
                dpix_val = CONVERT_RGB (c);
            } else
                dpix_val = colors_for_drawing.acolors[spix_val];
            spix++;
            tmp_val3 = dpix_val;
            spix_val = pixdata.apixels[spix] ^ xor_val;
            if (spix_val >= 32 && spix_val < 64) {
                unsigned int c = (colors_for_drawing.color_regs_aga[spix_val - 32] >> 1) & 0x7F7F7F;
                dpix_val = CONVERT_RGB (c);
            } else
                dpix_val = colors_for_drawing.acolors[spix_val];
            tmp_val = merge_2pixel16 (tmp_val, tmp_val2);
            tmp_val2 = merge_2pixel16 (tmp_val3, dpix_val);
            dpix_val = merge_2pixel16 (tmp_val, tmp_val2);
            spix++;
            }
            out_val = dpix_val;
            spix_val = pixdata.apixels[spix] ^ xor_val;
            if (spix_val >= 32 && spix_val < 64) {
                unsigned int c = (colors_for_drawing.color_regs_aga[spix_val - 32] >> 1) & 0x7F7F7F;
                dpix_val = CONVERT_RGB (c);
            } else
                dpix_val = colors_for_drawing.acolors[spix_val];
            {
            uae_u32 tmp_val, tmp_val2, tmp_val3;
            spix++;
            tmp_val = dpix_val;
            spix_val = pixdata.apixels[spix] ^ xor_val;
            if (spix_val >= 32 && spix_val < 64) {
                unsigned int c = (colors_for_drawing.color_regs_aga[spix_val - 32] >> 1) & 0x7F7F7F;
                dpix_val = CONVERT_RGB (c);
            } else
                dpix_val = colors_for_drawing.acolors[spix_val];
            spix++;
            tmp_val2 = dpix_val;
            spix_val = pixdata.apixels[spix] ^ xor_val;
            if (spix_val >= 32 && spix_val < 64) {
                unsigned int c = (colors_for_drawing.color_regs_aga[spix_val - 32] >> 1) & 0x7F7F7F;
                dpix_val = CONVERT_RGB (c);
            } else
                dpix_val = colors_for_drawing.acolors[spix_val];
            spix++;
            tmp_val3 = dpix_val;
            spix_val = pixdata.apixels[spix] ^ xor_val;
            if (spix_val >= 32 && spix_val < 64) {
                unsigned int c = (colors_for_drawing.color_regs_aga[spix_val - 32] >> 1) & 0x7F7F7F;
                dpix_val = CONVERT_RGB (c);
            } else
                dpix_val = colors_for_drawing.acolors[spix_val];
            tmp_val = merge_2pixel16 (tmp_val, tmp_val2);
            tmp_val2 = merge_2pixel16 (tmp_val3, dpix_val);
            dpix_val = merge_2pixel16 (tmp_val, tmp_val2);
            spix++;
            }
            out_val = (out_val & 0xFFFF) | (dpix_val << 16);
            *((uae_u32 *)&buf[dpix]) = out_val;
            dpix += 2;
        }
        if (rem) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            spix_val = pixdata.apixels[spix] ^ xor_val;
            if (spix_val >= 32 && spix_val < 64) {
                unsigned int c = (colors_for_drawing.color_regs_aga[spix_val - 32] >> 1) & 0x7F7F7F;
                dpix_val = CONVERT_RGB (c);
            } else
                dpix_val = colors_for_drawing.acolors[spix_val];
            {
            uae_u32 tmp_val, tmp_val2, tmp_val3;
            spix++;
            tmp_val = dpix_val;
            spix_val = pixdata.apixels[spix] ^ xor_val;
            if (spix_val >= 32 && spix_val < 64) {
                unsigned int c = (colors_for_drawing.color_regs_aga[spix_val - 32] >> 1) & 0x7F7F7F;
                dpix_val = CONVERT_RGB (c);
            } else
                dpix_val = colors_for_drawing.acolors[spix_val];
            spix++;
            tmp_val2 = dpix_val;
            spix_val = pixdata.apixels[spix] ^ xor_val;
            if (spix_val >= 32 && spix_val < 64) {
                unsigned int c = (colors_for_drawing.color_regs_aga[spix_val - 32] >> 1) & 0x7F7F7F;
                dpix_val = CONVERT_RGB (c);
            } else
                dpix_val = colors_for_drawing.acolors[spix_val];
            spix++;
            tmp_val3 = dpix_val;
            spix_val = pixdata.apixels[spix] ^ xor_val;
            if (spix_val >= 32 && spix_val < 64) {
                unsigned int c = (colors_for_drawing.color_regs_aga[spix_val - 32] >> 1) & 0x7F7F7F;
                dpix_val = CONVERT_RGB (c);
            } else
                dpix_val = colors_for_drawing.acolors[spix_val];
            tmp_val = merge_2pixel16 (tmp_val, tmp_val2);
            tmp_val2 = merge_2pixel16 (tmp_val3, dpix_val);
            dpix_val = merge_2pixel16 (tmp_val, tmp_val2);
            spix++;
            }
            buf[dpix++] = dpix_val;
        }
    } else {
        int rem;
        if (((uintptr_t)&buf[dpix]) & 2) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            spix_val = pixdata.apixels[spix] ^ xor_val;
            dpix_val = colors_for_drawing.acolors[spix_val];
            {
            uae_u32 tmp_val, tmp_val2, tmp_val3;
            spix++;
            tmp_val = dpix_val;
            spix_val = pixdata.apixels[spix] ^ xor_val;
            dpix_val = colors_for_drawing.acolors[spix_val];
            spix++;
            tmp_val2 = dpix_val;
            spix_val = pixdata.apixels[spix] ^ xor_val;
            dpix_val = colors_for_drawing.acolors[spix_val];
            spix++;
            tmp_val3 = dpix_val;
            spix_val = pixdata.apixels[spix] ^ xor_val;
            dpix_val = colors_for_drawing.acolors[spix_val];
            tmp_val = merge_2pixel16 (tmp_val, tmp_val2);
            tmp_val2 = merge_2pixel16 (tmp_val3, dpix_val);
            dpix_val = merge_2pixel16 (tmp_val, tmp_val2);
            spix++;
            }
            buf[dpix++] = dpix_val;
        }
        if (dpix >= dpix_end)
            return spix;
        rem = (((uintptr_t)&buf[dpix_end]) & 2);
        if (rem)
            dpix_end--;
        while (dpix < dpix_end) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix] ^ xor_val;
            dpix_val = colors_for_drawing.acolors[spix_val];
            {
            uae_u32 tmp_val, tmp_val2, tmp_val3;
            spix++;
            tmp_val = dpix_val;
            spix_val = pixdata.apixels[spix] ^ xor_val;
            dpix_val = colors_for_drawing.acolors[spix_val];
            spix++;
            tmp_val2 = dpix_val;
            spix_val = pixdata.apixels[spix] ^ xor_val;
            dpix_val = colors_for_drawing.acolors[spix_val];
            spix++;
            tmp_val3 = dpix_val;
            spix_val = pixdata.apixels[spix] ^ xor_val;
            dpix_val = colors_for_drawing.acolors[spix_val];
            tmp_val = merge_2pixel16 (tmp_val, tmp_val2);
            tmp_val2 = merge_2pixel16 (tmp_val3, dpix_val);
            dpix_val = merge_2pixel16 (tmp_val, tmp_val2);
            spix++;
            }
            out_val = dpix_val;
            spix_val = pixdata.apixels[spix] ^ xor_val;
            dpix_val = colors_for_drawing.acolors[spix_val];
            {
            uae_u32 tmp_val, tmp_val2, tmp_val3;
            spix++;
            tmp_val = dpix_val;
            spix_val = pixdata.apixels[spix] ^ xor_val;
            dpix_val = colors_for_drawing.acolors[spix_val];
            spix++;
            tmp_val2 = dpix_val;
            spix_val = pixdata.apixels[spix] ^ xor_val;
            dpix_val = colors_for_drawing.acolors[spix_val];
            spix++;
            tmp_val3 = dpix_val;
            spix_val = pixdata.apixels[spix] ^ xor_val;
            dpix_val = colors_for_drawing.acolors[spix_val];
            tmp_val = merge_2pixel16 (tmp_val, tmp_val2);
            tmp_val2 = merge_2pixel16 (tmp_val3, dpix_val);
            dpix_val = merge_2pixel16 (tmp_val, tmp_val2);
            spix++;
            }
            out_val = (out_val & 0xFFFF) | (dpix_val << 16);
            *((uae_u32 *)&buf[dpix]) = out_val;
            dpix += 2;
        }
        if (rem) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            spix_val = pixdata.apixels[spix] ^ xor_val;
            dpix_val = colors_for_drawing.acolors[spix_val];
            {
            uae_u32 tmp_val, tmp_val2, tmp_val3;
            spix++;
            tmp_val = dpix_val;
            spix_val = pixdata.apixels[spix] ^ xor_val;
            dpix_val = colors_for_drawing.acolors[spix_val];
            spix++;
            tmp_val2 = dpix_val;
            spix_val = pixdata.apixels[spix] ^ xor_val;
            dpix_val = colors_for_drawing.acolors[spix_val];
            spix++;
            tmp_val3 = dpix_val;
            spix_val = pixdata.apixels[spix] ^ xor_val;
            dpix_val = colors_for_drawing.acolors[spix_val];
            tmp_val = merge_2pixel16 (tmp_val, tmp_val2);
            tmp_val2 = merge_2pixel16 (tmp_val3, dpix_val);
            dpix_val = merge_2pixel16 (tmp_val, tmp_val2);
            spix++;
            }
            buf[dpix++] = dpix_val;
        }
    }

    return spix;
}
#endif

#ifdef AGA
static int NOINLINE __attribute__((__unused__)) linetoscr_16_shrink2f_aga_genlock(int spix, int dpix, int dpix_end)
{
    uae_u16 *buf = (uae_u16 *) xlinebuffer;
    uae_u8 *genlock_buf = xlinebuffer_genlock;
    uae_u8 xor_val = bplxor;

    if (bplham) {
        int rem;
        if (((uintptr_t)&buf[dpix]) & 2) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            spix_val = pixdata.apixels[spix] ^ xor_val;
            spix_val = ham_linebuf[spix];
            dpix_val = CONVERT_RGB (spix_val);
            {
            uae_u32 tmp_val, tmp_val2, tmp_val3;
            spix++;
            tmp_val = dpix_val;
            spix_val = pixdata.apixels[spix] ^ xor_val;
            spix_val = ham_linebuf[spix];
            dpix_val = CONVERT_RGB (spix_val);
            spix++;
            tmp_val2 = dpix_val;
            spix_val = pixdata.apixels[spix] ^ xor_val;
            spix_val = ham_linebuf[spix];
            dpix_val = CONVERT_RGB (spix_val);
            spix++;
            tmp_val3 = dpix_val;
            spix_val = pixdata.apixels[spix] ^ xor_val;
            spix_val = ham_linebuf[spix];
            dpix_val = CONVERT_RGB (spix_val);
            tmp_val = merge_2pixel16 (tmp_val, tmp_val2);
            tmp_val2 = merge_2pixel16 (tmp_val3, dpix_val);
            dpix_val = merge_2pixel16 (tmp_val, tmp_val2);
            spix++;
            }
            buf[dpix++] = dpix_val;
        }
        if (dpix >= dpix_end)
            return spix;
        rem = (((uintptr_t)&buf[dpix_end]) & 2);
        if (rem)
            dpix_end--;
        while (dpix < dpix_end) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix] ^ xor_val;
            spix_val = ham_linebuf[spix];
            dpix_val = CONVERT_RGB (spix_val);
            {
            uae_u32 tmp_val, tmp_val2, tmp_val3;
            spix++;
            tmp_val = dpix_val;
            spix_val = pixdata.apixels[spix] ^ xor_val;
            spix_val = ham_linebuf[spix];
            dpix_val = CONVERT_RGB (spix_val);
            spix++;
            tmp_val2 = dpix_val;
            spix_val = pixdata.apixels[spix] ^ xor_val;
            spix_val = ham_linebuf[spix];
            dpix_val = CONVERT_RGB (spix_val);
            spix++;
            tmp_val3 = dpix_val;
            spix_val = pixdata.apixels[spix] ^ xor_val;
            spix_val = ham_linebuf[spix];
            dpix_val = CONVERT_RGB (spix_val);
            tmp_val = merge_2pixel16 (tmp_val, tmp_val2);
            tmp_val2 = merge_2pixel16 (tmp_val3, dpix_val);
            dpix_val = merge_2pixel16 (tmp_val, tmp_val2);
            spix++;
            }
            out_val = dpix_val;
            genlock_buf[dpix] = get_genlock_transparency((spix_val >> 2) & 63);
            spix_val = pixdata.apixels[spix] ^ xor_val;
            spix_val = ham_linebuf[spix];
            dpix_val = CONVERT_RGB (spix_val);
            {
            uae_u32 tmp_val, tmp_val2, tmp_val3;
            spix++;
            tmp_val = dpix_val;
            spix_val = pixdata.apixels[spix] ^ xor_val;
            spix_val = ham_linebuf[spix];
            dpix_val = CONVERT_RGB (spix_val);
            spix++;
            tmp_val2 = dpix_val;
            spix_val = pixdata.apixels[spix] ^ xor_val;
            spix_val = ham_linebuf[spix];
            dpix_val = CONVERT_RGB (spix_val);
            spix++;
            tmp_val3 = dpix_val;
            spix_val = pixdata.apixels[spix] ^ xor_val;
            spix_val = ham_linebuf[spix];
            dpix_val = CONVERT_RGB (spix_val);
            tmp_val = merge_2pixel16 (tmp_val, tmp_val2);
            tmp_val2 = merge_2pixel16 (tmp_val3, dpix_val);
            dpix_val = merge_2pixel16 (tmp_val, tmp_val2);
            spix++;
            }
            out_val = (out_val & 0xFFFF) | (dpix_val << 16);
            *((uae_u32 *)&buf[dpix]) = out_val;
            dpix += 2;
        }
        if (rem) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            spix_val = pixdata.apixels[spix] ^ xor_val;
            spix_val = ham_linebuf[spix];
            dpix_val = CONVERT_RGB (spix_val);
            {
            uae_u32 tmp_val, tmp_val2, tmp_val3;
            spix++;
            tmp_val = dpix_val;
            spix_val = pixdata.apixels[spix] ^ xor_val;
            spix_val = ham_linebuf[spix];
            dpix_val = CONVERT_RGB (spix_val);
            spix++;
            tmp_val2 = dpix_val;
            spix_val = pixdata.apixels[spix] ^ xor_val;
            spix_val = ham_linebuf[spix];
            dpix_val = CONVERT_RGB (spix_val);
            spix++;
            tmp_val3 = dpix_val;
            spix_val = pixdata.apixels[spix] ^ xor_val;
            spix_val = ham_linebuf[spix];
            dpix_val = CONVERT_RGB (spix_val);
            tmp_val = merge_2pixel16 (tmp_val, tmp_val2);
            tmp_val2 = merge_2pixel16 (tmp_val3, dpix_val);
            dpix_val = merge_2pixel16 (tmp_val, tmp_val2);
            spix++;
            }
            buf[dpix++] = dpix_val;
        }
    } else if (bpldualpf) {
        int *lookup    = bpldualpfpri ? dblpf_ind2_aga : dblpf_ind1_aga;
        int *lookup_no = bpldualpfpri ? dblpf_2nd2     : dblpf_2nd1;
        int rem;
        if (((uintptr_t)&buf[dpix]) & 2) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            spix_val = pixdata.apixels[spix];
            {
                uae_u8 val = lookup[spix_val];
                if (lookup_no[spix_val])
                    val += dblpfofs[bpldualpf2of];
                val ^= xor_val;
                dpix_val = colors_for_drawing.acolors[val];
            }
            {
            uae_u32 tmp_val, tmp_val2, tmp_val3;
            spix++;
            tmp_val = dpix_val;
            spix_val = pixdata.apixels[spix];
            {
                uae_u8 val = lookup[spix_val];
                if (lookup_no[spix_val])
                    val += dblpfofs[bpldualpf2of];
                val ^= xor_val;
                dpix_val = colors_for_drawing.acolors[val];
            }
            spix++;
            tmp_val2 = dpix_val;
            spix_val = pixdata.apixels[spix];
            {
                uae_u8 val = lookup[spix_val];
                if (lookup_no[spix_val])
                    val += dblpfofs[bpldualpf2of];
                val ^= xor_val;
                dpix_val = colors_for_drawing.acolors[val];
            }
            spix++;
            tmp_val3 = dpix_val;
            spix_val = pixdata.apixels[spix];
            {
                uae_u8 val = lookup[spix_val];
                if (lookup_no[spix_val])
                    val += dblpfofs[bpldualpf2of];
                val ^= xor_val;
                dpix_val = colors_for_drawing.acolors[val];
            }
            tmp_val = merge_2pixel16 (tmp_val, tmp_val2);
            tmp_val2 = merge_2pixel16 (tmp_val3, dpix_val);
            dpix_val = merge_2pixel16 (tmp_val, tmp_val2);
            spix++;
            }
            buf[dpix++] = dpix_val;
        }
        if (dpix >= dpix_end)
            return spix;
        rem = (((uintptr_t)&buf[dpix_end]) & 2);
        if (rem)
            dpix_end--;
        while (dpix < dpix_end) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix];
            {
                uae_u8 val = lookup[spix_val];
                if (lookup_no[spix_val])
                    val += dblpfofs[bpldualpf2of];
                val ^= xor_val;
                dpix_val = colors_for_drawing.acolors[val];
            }
            {
            uae_u32 tmp_val, tmp_val2, tmp_val3;
            spix++;
            tmp_val = dpix_val;
            spix_val = pixdata.apixels[spix];
            {
                uae_u8 val = lookup[spix_val];
                if (lookup_no[spix_val])
                    val += dblpfofs[bpldualpf2of];
                val ^= xor_val;
                dpix_val = colors_for_drawing.acolors[val];
            }
            spix++;
            tmp_val2 = dpix_val;
            spix_val = pixdata.apixels[spix];
            {
                uae_u8 val = lookup[spix_val];
                if (lookup_no[spix_val])
                    val += dblpfofs[bpldualpf2of];
                val ^= xor_val;
                dpix_val = colors_for_drawing.acolors[val];
            }
            spix++;
            tmp_val3 = dpix_val;
            spix_val = pixdata.apixels[spix];
            {
                uae_u8 val = lookup[spix_val];
                if (lookup_no[spix_val])
                    val += dblpfofs[bpldualpf2of];
                val ^= xor_val;
                dpix_val = colors_for_drawing.acolors[val];
            }
            tmp_val = merge_2pixel16 (tmp_val, tmp_val2);
            tmp_val2 = merge_2pixel16 (tmp_val3, dpix_val);
            dpix_val = merge_2pixel16 (tmp_val, tmp_val2);
            spix++;
            }
            out_val = dpix_val;
            genlock_buf[dpix] = get_genlock_transparency(lookup[spix_val]);
            spix_val = pixdata.apixels[spix];
            {
                uae_u8 val = lookup[spix_val];
                if (lookup_no[spix_val])
                    val += dblpfofs[bpldualpf2of];
                val ^= xor_val;
                dpix_val = colors_for_drawing.acolors[val];
            }
            {
            uae_u32 tmp_val, tmp_val2, tmp_val3;
            spix++;
            tmp_val = dpix_val;
            spix_val = pixdata.apixels[spix];
            {
                uae_u8 val = lookup[spix_val];
                if (lookup_no[spix_val])
                    val += dblpfofs[bpldualpf2of];
                val ^= xor_val;
                dpix_val = colors_for_drawing.acolors[val];
            }
            spix++;
            tmp_val2 = dpix_val;
            spix_val = pixdata.apixels[spix];
            {
                uae_u8 val = lookup[spix_val];
                if (lookup_no[spix_val])
                    val += dblpfofs[bpldualpf2of];
                val ^= xor_val;
                dpix_val = colors_for_drawing.acolors[val];
            }
            spix++;
            tmp_val3 = dpix_val;
            spix_val = pixdata.apixels[spix];
            {
                uae_u8 val = lookup[spix_val];
                if (lookup_no[spix_val])
                    val += dblpfofs[bpldualpf2of];
                val ^= xor_val;
                dpix_val = colors_for_drawing.acolors[val];
            }
            tmp_val = merge_2pixel16 (tmp_val, tmp_val2);
            tmp_val2 = merge_2pixel16 (tmp_val3, dpix_val);
            dpix_val = merge_2pixel16 (tmp_val, tmp_val2);
            spix++;
            }
            out_val = (out_val & 0xFFFF) | (dpix_val << 16);
            *((uae_u32 *)&buf[dpix]) = out_val;
            dpix += 2;
        }
        if (rem) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            spix_val = pixdata.apixels[spix];
            {
                uae_u8 val = lookup[spix_val];
                if (lookup_no[spix_val])
                    val += dblpfofs[bpldualpf2of];
                val ^= xor_val;
                dpix_val = colors_for_drawing.acolors[val];
            }
            {
            uae_u32 tmp_val, tmp_val2, tmp_val3;
            spix++;
            tmp_val = dpix_val;
            spix_val = pixdata.apixels[spix];
            {
                uae_u8 val = lookup[spix_val];
                if (lookup_no[spix_val])
                    val += dblpfofs[bpldualpf2of];
                val ^= xor_val;
                dpix_val = colors_for_drawing.acolors[val];
            }
            spix++;
            tmp_val2 = dpix_val;
            spix_val = pixdata.apixels[spix];
            {
                uae_u8 val = lookup[spix_val];
                if (lookup_no[spix_val])
                    val += dblpfofs[bpldualpf2of];
                val ^= xor_val;
                dpix_val = colors_for_drawing.acolors[val];
            }
            spix++;
            tmp_val3 = dpix_val;
            spix_val = pixdata.apixels[spix];
            {
                uae_u8 val = lookup[spix_val];
                if (lookup_no[spix_val])
                    val += dblpfofs[bpldualpf2of];
                val ^= xor_val;
                dpix_val = colors_for_drawing.acolors[val];
            }
            tmp_val = merge_2pixel16 (tmp_val, tmp_val2);
            tmp_val2 = merge_2pixel16 (tmp_val3, dpix_val);
            dpix_val = merge_2pixel16 (tmp_val, tmp_val2);
            spix++;
            }
            buf[dpix++] = dpix_val;
        }
    } else if (bplehb) {
        int rem;
        if (((uintptr_t)&buf[dpix]) & 2) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            spix_val = pixdata.apixels[spix] ^ xor_val;
            if (spix_val >= 32 && spix_val < 64) {
                unsigned int c = (colors_for_drawing.color_regs_aga[spix_val - 32] >> 1) & 0x7F7F7F;
                dpix_val = CONVERT_RGB (c);
            } else
                dpix_val = colors_for_drawing.acolors[spix_val];
            {
            uae_u32 tmp_val, tmp_val2, tmp_val3;
            spix++;
            tmp_val = dpix_val;
            spix_val = pixdata.apixels[spix] ^ xor_val;
            if (spix_val >= 32 && spix_val < 64) {
                unsigned int c = (colors_for_drawing.color_regs_aga[spix_val - 32] >> 1) & 0x7F7F7F;
                dpix_val = CONVERT_RGB (c);
            } else
                dpix_val = colors_for_drawing.acolors[spix_val];
            spix++;
            tmp_val2 = dpix_val;
            spix_val = pixdata.apixels[spix] ^ xor_val;
            if (spix_val >= 32 && spix_val < 64) {
                unsigned int c = (colors_for_drawing.color_regs_aga[spix_val - 32] >> 1) & 0x7F7F7F;
                dpix_val = CONVERT_RGB (c);
            } else
                dpix_val = colors_for_drawing.acolors[spix_val];
            spix++;
            tmp_val3 = dpix_val;
            spix_val = pixdata.apixels[spix] ^ xor_val;
            if (spix_val >= 32 && spix_val < 64) {
                unsigned int c = (colors_for_drawing.color_regs_aga[spix_val - 32] >> 1) & 0x7F7F7F;
                dpix_val = CONVERT_RGB (c);
            } else
                dpix_val = colors_for_drawing.acolors[spix_val];
            tmp_val = merge_2pixel16 (tmp_val, tmp_val2);
            tmp_val2 = merge_2pixel16 (tmp_val3, dpix_val);
            dpix_val = merge_2pixel16 (tmp_val, tmp_val2);
            spix++;
            }
            buf[dpix++] = dpix_val;
        }
        if (dpix >= dpix_end)
            return spix;
        rem = (((uintptr_t)&buf[dpix_end]) & 2);
        if (rem)
            dpix_end--;
        while (dpix < dpix_end) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix] ^ xor_val;
            if (spix_val >= 32 && spix_val < 64) {
                unsigned int c = (colors_for_drawing.color_regs_aga[spix_val - 32] >> 1) & 0x7F7F7F;
                dpix_val = CONVERT_RGB (c);
            } else
                dpix_val = colors_for_drawing.acolors[spix_val];
            {
            uae_u32 tmp_val, tmp_val2, tmp_val3;
            spix++;
            tmp_val = dpix_val;
            spix_val = pixdata.apixels[spix] ^ xor_val;
            if (spix_val >= 32 && spix_val < 64) {
                unsigned int c = (colors_for_drawing.color_regs_aga[spix_val - 32] >> 1) & 0x7F7F7F;
                dpix_val = CONVERT_RGB (c);
            } else
                dpix_val = colors_for_drawing.acolors[spix_val];
            spix++;
            tmp_val2 = dpix_val;
            spix_val = pixdata.apixels[spix] ^ xor_val;
            if (spix_val >= 32 && spix_val < 64) {
                unsigned int c = (colors_for_drawing.color_regs_aga[spix_val - 32] >> 1) & 0x7F7F7F;
                dpix_val = CONVERT_RGB (c);
            } else
                dpix_val = colors_for_drawing.acolors[spix_val];
            spix++;
            tmp_val3 = dpix_val;
            spix_val = pixdata.apixels[spix] ^ xor_val;
            if (spix_val >= 32 && spix_val < 64) {
                unsigned int c = (colors_for_drawing.color_regs_aga[spix_val - 32] >> 1) & 0x7F7F7F;
                dpix_val = CONVERT_RGB (c);
            } else
                dpix_val = colors_for_drawing.acolors[spix_val];
            tmp_val = merge_2pixel16 (tmp_val, tmp_val2);
            tmp_val2 = merge_2pixel16 (tmp_val3, dpix_val);
            dpix_val = merge_2pixel16 (tmp_val, tmp_val2);
            spix++;
            }
            out_val = dpix_val;
            genlock_buf[dpix] = get_genlock_transparency(spix_val & 31);
            spix_val = pixdata.apixels[spix] ^ xor_val;
            if (spix_val >= 32 && spix_val < 64) {
                unsigned int c = (colors_for_drawing.color_regs_aga[spix_val - 32] >> 1) & 0x7F7F7F;
                dpix_val = CONVERT_RGB (c);
            } else
                dpix_val = colors_for_drawing.acolors[spix_val];
            {
            uae_u32 tmp_val, tmp_val2, tmp_val3;
            spix++;
            tmp_val = dpix_val;
            spix_val = pixdata.apixels[spix] ^ xor_val;
            if (spix_val >= 32 && spix_val < 64) {
                unsigned int c = (colors_for_drawing.color_regs_aga[spix_val - 32] >> 1) & 0x7F7F7F;
                dpix_val = CONVERT_RGB (c);
            } else
                dpix_val = colors_for_drawing.acolors[spix_val];
            spix++;
            tmp_val2 = dpix_val;
            spix_val = pixdata.apixels[spix] ^ xor_val;
            if (spix_val >= 32 && spix_val < 64) {
                unsigned int c = (colors_for_drawing.color_regs_aga[spix_val - 32] >> 1) & 0x7F7F7F;
                dpix_val = CONVERT_RGB (c);
            } else
                dpix_val = colors_for_drawing.acolors[spix_val];
            spix++;
            tmp_val3 = dpix_val;
            spix_val = pixdata.apixels[spix] ^ xor_val;
            if (spix_val >= 32 && spix_val < 64) {
                unsigned int c = (colors_for_drawing.color_regs_aga[spix_val - 32] >> 1) & 0x7F7F7F;
                dpix_val = CONVERT_RGB (c);
            } else
                dpix_val = colors_for_drawing.acolors[spix_val];
            tmp_val = merge_2pixel16 (tmp_val, tmp_val2);
            tmp_val2 = merge_2pixel16 (tmp_val3, dpix_val);
            dpix_val = merge_2pixel16 (tmp_val, tmp_val2);
            spix++;
            }
            out_val = (out_val & 0xFFFF) | (dpix_val << 16);
            *((uae_u32 *)&buf[dpix]) = out_val;
            dpix += 2;
        }
        if (rem) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            spix_val = pixdata.apixels[spix] ^ xor_val;
            if (spix_val >= 32 && spix_val < 64) {
                unsigned int c = (colors_for_drawing.color_regs_aga[spix_val - 32] >> 1) & 0x7F7F7F;
                dpix_val = CONVERT_RGB (c);
            } else
                dpix_val = colors_for_drawing.acolors[spix_val];
            {
            uae_u32 tmp_val, tmp_val2, tmp_val3;
            spix++;
            tmp_val = dpix_val;
            spix_val = pixdata.apixels[spix] ^ xor_val;
            if (spix_val >= 32 && spix_val < 64) {
                unsigned int c = (colors_for_drawing.color_regs_aga[spix_val - 32] >> 1) & 0x7F7F7F;
                dpix_val = CONVERT_RGB (c);
            } else
                dpix_val = colors_for_drawing.acolors[spix_val];
            spix++;
            tmp_val2 = dpix_val;
            spix_val = pixdata.apixels[spix] ^ xor_val;
            if (spix_val >= 32 && spix_val < 64) {
                unsigned int c = (colors_for_drawing.color_regs_aga[spix_val - 32] >> 1) & 0x7F7F7F;
                dpix_val = CONVERT_RGB (c);
            } else
                dpix_val = colors_for_drawing.acolors[spix_val];
            spix++;
            tmp_val3 = dpix_val;
            spix_val = pixdata.apixels[spix] ^ xor_val;
            if (spix_val >= 32 && spix_val < 64) {
                unsigned int c = (colors_for_drawing.color_regs_aga[spix_val - 32] >> 1) & 0x7F7F7F;
                dpix_val = CONVERT_RGB (c);
            } else
                dpix_val = colors_for_drawing.acolors[spix_val];
            tmp_val = merge_2pixel16 (tmp_val, tmp_val2);
            tmp_val2 = merge_2pixel16 (tmp_val3, dpix_val);
            dpix_val = merge_2pixel16 (tmp_val, tmp_val2);
            spix++;
            }
            buf[dpix++] = dpix_val;
        }
    } else {
        int rem;
        if (((uintptr_t)&buf[dpix]) & 2) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            spix_val = pixdata.apixels[spix] ^ xor_val;
            dpix_val = colors_for_drawing.acolors[spix_val];
            {
            uae_u32 tmp_val, tmp_val2, tmp_val3;
            spix++;
            tmp_val = dpix_val;
            spix_val = pixdata.apixels[spix] ^ xor_val;
            dpix_val = colors_for_drawing.acolors[spix_val];
            spix++;
            tmp_val2 = dpix_val;
            spix_val = pixdata.apixels[spix] ^ xor_val;
            dpix_val = colors_for_drawing.acolors[spix_val];
            spix++;
            tmp_val3 = dpix_val;
            spix_val = pixdata.apixels[spix] ^ xor_val;
            dpix_val = colors_for_drawing.acolors[spix_val];
            tmp_val = merge_2pixel16 (tmp_val, tmp_val2);
            tmp_val2 = merge_2pixel16 (tmp_val3, dpix_val);
            dpix_val = merge_2pixel16 (tmp_val, tmp_val2);
            spix++;
            }
            buf[dpix++] = dpix_val;
        }
        if (dpix >= dpix_end)
            return spix;
        rem = (((uintptr_t)&buf[dpix_end]) & 2);
        if (rem)
            dpix_end--;
        while (dpix < dpix_end) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix] ^ xor_val;
            dpix_val = colors_for_drawing.acolors[spix_val];
            {
            uae_u32 tmp_val, tmp_val2, tmp_val3;
            spix++;
            tmp_val = dpix_val;
            spix_val = pixdata.apixels[spix] ^ xor_val;
            dpix_val = colors_for_drawing.acolors[spix_val];
            spix++;
            tmp_val2 = dpix_val;
            spix_val = pixdata.apixels[spix] ^ xor_val;
            dpix_val = colors_for_drawing.acolors[spix_val];
            spix++;
            tmp_val3 = dpix_val;
            spix_val = pixdata.apixels[spix] ^ xor_val;
            dpix_val = colors_for_drawing.acolors[spix_val];
            tmp_val = merge_2pixel16 (tmp_val, tmp_val2);
            tmp_val2 = merge_2pixel16 (tmp_val3, dpix_val);
            dpix_val = merge_2pixel16 (tmp_val, tmp_val2);
            spix++;
            }
            out_val = dpix_val;
            genlock_buf[dpix] = get_genlock_transparency(spix_val);
            spix_val = pixdata.apixels[spix] ^ xor_val;
            dpix_val = colors_for_drawing.acolors[spix_val];
            {
            uae_u32 tmp_val, tmp_val2, tmp_val3;
            spix++;
            tmp_val = dpix_val;
            spix_val = pixdata.apixels[spix] ^ xor_val;
            dpix_val = colors_for_drawing.acolors[spix_val];
            spix++;
            tmp_val2 = dpix_val;
            spix_val = pixdata.apixels[spix] ^ xor_val;
            dpix_val = colors_for_drawing.acolors[spix_val];
            spix++;
            tmp_val3 = dpix_val;
            spix_val = pixdata.apixels[spix] ^ xor_val;
            dpix_val = colors_for_drawing.acolors[spix_val];
            tmp_val = merge_2pixel16 (tmp_val, tmp_val2);
            tmp_val2 = merge_2pixel16 (tmp_val3, dpix_val);
            dpix_val = merge_2pixel16 (tmp_val, tmp_val2);
            spix++;
            }
            out_val = (out_val & 0xFFFF) | (dpix_val << 16);
            *((uae_u32 *)&buf[dpix]) = out_val;
            dpix += 2;
        }
        if (rem) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            spix_val = pixdata.apixels[spix] ^ xor_val;
            dpix_val = colors_for_drawing.acolors[spix_val];
            {
            uae_u32 tmp_val, tmp_val2, tmp_val3;
            spix++;
            tmp_val = dpix_val;
            spix_val = pixdata.apixels[spix] ^ xor_val;
            dpix_val = colors_for_drawing.acolors[spix_val];
            spix++;
            tmp_val2 = dpix_val;
            spix_val = pixdata.apixels[spix] ^ xor_val;
            dpix_val = colors_for_drawing.acolors[spix_val];
            spix++;
            tmp_val3 = dpix_val;
            spix_val = pixdata.apixels[spix] ^ xor_val;
            dpix_val = colors_for_drawing.acolors[spix_val];
            tmp_val = merge_2pixel16 (tmp_val, tmp_val2);
            tmp_val2 = merge_2pixel16 (tmp_val3, dpix_val);
            dpix_val = merge_2pixel16 (tmp_val, tmp_val2);
            spix++;
            }
            buf[dpix++] = dpix_val;
        }
    }

    return spix;
}
#endif

#ifdef AGA
static int NOINLINE __attribute__((__unused__)) linetoscr_16_aga_spr(int spix, int dpix, int dpix_end)
{
    uae_u16 *buf = (uae_u16 *) xlinebuffer;
    uae_u8 sprcol;
    uae_u8 xor_val = bplxor;

    if (bplham) {
        while (dpix < dpix_end) {
            uae_u32 sprpix_val;
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            sprpix_val = pixdata.apixels[spix];
            spix_val = pixdata.apixels[spix] ^ xor_val;
            spix_val = ham_linebuf[spix];
            dpix_val = CONVERT_RGB (spix_val);
            spix++;
            out_val = dpix_val;
            if (spritepixels[dpix].data) {
                sprcol = render_sprites (dpix + 0, 0, sprpix_val, 1);
                if (sprcol) {
                    out_val = colors_for_drawing.acolors[sprcol];
                }
            }
            buf[dpix++] = out_val;
        }
    } else if (bpldualpf) {
        int *lookup    = bpldualpfpri ? dblpf_ind2_aga : dblpf_ind1_aga;
        int *lookup_no = bpldualpfpri ? dblpf_2nd2     : dblpf_2nd1;
        while (dpix < dpix_end) {
            uae_u32 sprpix_val;
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix];
            sprpix_val = spix_val;
            {
                uae_u8 val = lookup[spix_val];
                if (lookup_no[spix_val])
                    val += dblpfofs[bpldualpf2of];
                val ^= xor_val;
                dpix_val = colors_for_drawing.acolors[val];
            }
            spix++;
            out_val = dpix_val;
            if (spritepixels[dpix].data) {
                sprcol = render_sprites (dpix + 0, 1, sprpix_val, 1);
                if (sprcol) {
                    out_val = colors_for_drawing.acolors[sprcol];
                }
            }
            buf[dpix++] = out_val;
        }
    } else if (bplehb) {
        while (dpix < dpix_end) {
            uae_u32 sprpix_val;
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            sprpix_val = pixdata.apixels[spix];
            spix_val = pixdata.apixels[spix] ^ xor_val;
            if (spix_val >= 32 && spix_val < 64) {
                unsigned int c = (colors_for_drawing.color_regs_aga[spix_val - 32] >> 1) & 0x7F7F7F;
                dpix_val = CONVERT_RGB (c);
            } else
                dpix_val = colors_for_drawing.acolors[spix_val];
            spix++;
            out_val = dpix_val;
            if (spritepixels[dpix].data) {
                sprcol = render_sprites (dpix + 0, 0, sprpix_val, 1);
                if (sprcol) {
                    out_val = colors_for_drawing.acolors[sprcol];
                }
            }
            buf[dpix++] = out_val;
        }
    } else {
        while (dpix < dpix_end) {
            uae_u32 sprpix_val;
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            sprpix_val = pixdata.apixels[spix];
            spix_val = pixdata.apixels[spix] ^ xor_val;
            dpix_val = colors_for_drawing.acolors[spix_val];
            spix++;
            out_val = dpix_val;
            if (spritepixels[dpix].data) {
                sprcol = render_sprites (dpix + 0, 0, sprpix_val, 1);
                if (sprcol) {
                    out_val = colors_for_drawing.acolors[sprcol];
                }
            }
            buf[dpix++] = out_val;
        }
    }

    return spix;
}
#endif

#ifdef AGA
static int NOINLINE __attribute__((__unused__)) linetoscr_16_aga_spr_genlock(int spix, int dpix, int dpix_end)
{
    uae_u16 *buf = (uae_u16 *) xlinebuffer;
    uae_u8 *genlock_buf = xlinebuffer_genlock;
    uae_u8 sprcol;
    uae_u8 xor_val = bplxor;

    if (bplham) {
        while (dpix < dpix_end) {
            uae_u32 sprpix_val;
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            sprpix_val = pixdata.apixels[spix];
            spix_val = pixdata.apixels[spix] ^ xor_val;
            spix_val = ham_linebuf[spix];
            dpix_val = CONVERT_RGB (spix_val);
            spix++;
            out_val = dpix_val;
            genlock_buf[dpix] = get_genlock_transparency((spix_val >> 2) & 63);
            if (spritepixels[dpix].data) {
                sprcol = render_sprites (dpix + 0, 0, sprpix_val, 1);
                if (sprcol) {
                    out_val = colors_for_drawing.acolors[sprcol];
                    genlock_buf[dpix] = get_genlock_transparency(sprcol);
                }
            }
            buf[dpix++] = out_val;
        }
    } else if (bpldualpf) {
        int *lookup    = bpldualpfpri ? dblpf_ind2_aga : dblpf_ind1_aga;
        int *lookup_no = bpldualpfpri ? dblpf_2nd2     : dblpf_2nd1;
        while (dpix < dpix_end) {
            uae_u32 sprpix_val;
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix];
            sprpix_val = spix_val;
            {
                uae_u8 val = lookup[spix_val];
                if (lookup_no[spix_val])
                    val += dblpfofs[bpldualpf2of];
                val ^= xor_val;
                dpix_val = colors_for_drawing.acolors[val];
            }
            spix++;
            out_val = dpix_val;
            genlock_buf[dpix] = get_genlock_transparency(lookup[spix_val]);
            if (spritepixels[dpix].data) {
                sprcol = render_sprites (dpix + 0, 1, sprpix_val, 1);
                if (sprcol) {
                    out_val = colors_for_drawing.acolors[sprcol];
                    genlock_buf[dpix] = get_genlock_transparency(sprcol);
                }
            }
            buf[dpix++] = out_val;
        }
    } else if (bplehb) {
        while (dpix < dpix_end) {
            uae_u32 sprpix_val;
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            sprpix_val = pixdata.apixels[spix];
            spix_val = pixdata.apixels[spix] ^ xor_val;
            if (spix_val >= 32 && spix_val < 64) {
                unsigned int c = (colors_for_drawing.color_regs_aga[spix_val - 32] >> 1) & 0x7F7F7F;
                dpix_val = CONVERT_RGB (c);
            } else
                dpix_val = colors_for_drawing.acolors[spix_val];
            spix++;
            out_val = dpix_val;
            genlock_buf[dpix] = get_genlock_transparency(spix_val & 31);
            if (spritepixels[dpix].data) {
                sprcol = render_sprites (dpix + 0, 0, sprpix_val, 1);
                if (sprcol) {
                    out_val = colors_for_drawing.acolors[sprcol];
                    genlock_buf[dpix] = get_genlock_transparency(sprcol);
                }
            }
            buf[dpix++] = out_val;
        }
    } else {
        while (dpix < dpix_end) {
            uae_u32 sprpix_val;
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            sprpix_val = pixdata.apixels[spix];
            spix_val = pixdata.apixels[spix] ^ xor_val;
            dpix_val = colors_for_drawing.acolors[spix_val];
            spix++;
            out_val = dpix_val;
            genlock_buf[dpix] = get_genlock_transparency(spix_val);
            if (spritepixels[dpix].data) {
                sprcol = render_sprites (dpix + 0, 0, sprpix_val, 1);
                if (sprcol) {
                    out_val = colors_for_drawing.acolors[sprcol];
                    genlock_buf[dpix] = get_genlock_transparency(sprcol);
                }
            }
            buf[dpix++] = out_val;
        }
    }

    return spix;
}
#endif

#ifdef AGA
static int NOINLINE __attribute__((__unused__)) linetoscr_16_stretch1_aga_spr(int spix, int dpix, int dpix_end)
{
    uae_u16 *buf = (uae_u16 *) xlinebuffer;
    uae_u8 sprcol;
    uae_u8 xor_val = bplxor;

    if (bplham) {
        while (dpix < dpix_end) {
            uae_u32 sprpix_val;
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            sprpix_val = pixdata.apixels[spix];
            spix_val = pixdata.apixels[spix] ^ xor_val;
            spix_val = ham_linebuf[spix];
            dpix_val = CONVERT_RGB (spix_val);
            spix++;
            out_val = dpix_val;
            {
            uae_u32 out_val1 = out_val;
            uae_u32 out_val2 = out_val;
            if (spritepixels[dpix + 0].data) {
                sprcol = render_sprites (dpix + 0, 0, sprpix_val, 1);
                if (sprcol) {
                    out_val1 = colors_for_drawing.acolors[sprcol];
                }
            }
            if (spritepixels[dpix + 1].data) {
                sprcol = render_sprites (dpix + 1, 0, sprpix_val, 1);
                if (sprcol) {
                    out_val2 = colors_for_drawing.acolors[sprcol];
                }
            }
            buf[dpix++] = out_val1;
            buf[dpix++] = out_val2;
            }
        }
    } else if (bpldualpf) {
        int *lookup    = bpldualpfpri ? dblpf_ind2_aga : dblpf_ind1_aga;
        int *lookup_no = bpldualpfpri ? dblpf_2nd2     : dblpf_2nd1;
        while (dpix < dpix_end) {
            uae_u32 sprpix_val;
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix];
            sprpix_val = spix_val;
            {
                uae_u8 val = lookup[spix_val];
                if (lookup_no[spix_val])
                    val += dblpfofs[bpldualpf2of];
                val ^= xor_val;
                dpix_val = colors_for_drawing.acolors[val];
            }
            spix++;
            out_val = dpix_val;
            {
            uae_u32 out_val1 = out_val;
            uae_u32 out_val2 = out_val;
            if (spritepixels[dpix + 0].data) {
                sprcol = render_sprites (dpix + 0, 1, sprpix_val, 1);
                if (sprcol) {
                    out_val1 = colors_for_drawing.acolors[sprcol];
                }
            }
            if (spritepixels[dpix + 1].data) {
                sprcol = render_sprites (dpix + 1, 1, sprpix_val, 1);
                if (sprcol) {
                    out_val2 = colors_for_drawing.acolors[sprcol];
                }
            }
            buf[dpix++] = out_val1;
            buf[dpix++] = out_val2;
            }
        }
    } else if (bplehb) {
        while (dpix < dpix_end) {
            uae_u32 sprpix_val;
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            sprpix_val = pixdata.apixels[spix];
            spix_val = pixdata.apixels[spix] ^ xor_val;
            if (spix_val >= 32 && spix_val < 64) {
                unsigned int c = (colors_for_drawing.color_regs_aga[spix_val - 32] >> 1) & 0x7F7F7F;
                dpix_val = CONVERT_RGB (c);
            } else
                dpix_val = colors_for_drawing.acolors[spix_val];
            spix++;
            out_val = dpix_val;
            {
            uae_u32 out_val1 = out_val;
            uae_u32 out_val2 = out_val;
            if (spritepixels[dpix + 0].data) {
                sprcol = render_sprites (dpix + 0, 0, sprpix_val, 1);
                if (sprcol) {
                    out_val1 = colors_for_drawing.acolors[sprcol];
                }
            }
            if (spritepixels[dpix + 1].data) {
                sprcol = render_sprites (dpix + 1, 0, sprpix_val, 1);
                if (sprcol) {
                    out_val2 = colors_for_drawing.acolors[sprcol];
                }
            }
            buf[dpix++] = out_val1;
            buf[dpix++] = out_val2;
            }
        }
    } else {
        while (dpix < dpix_end) {
            uae_u32 sprpix_val;
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            sprpix_val = pixdata.apixels[spix];
            spix_val = pixdata.apixels[spix] ^ xor_val;
            dpix_val = colors_for_drawing.acolors[spix_val];
            spix++;
            out_val = dpix_val;
            {
            uae_u32 out_val1 = out_val;
            uae_u32 out_val2 = out_val;
            if (spritepixels[dpix + 0].data) {
                sprcol = render_sprites (dpix + 0, 0, sprpix_val, 1);
                if (sprcol) {
                    out_val1 = colors_for_drawing.acolors[sprcol];
                }
            }
            if (spritepixels[dpix + 1].data) {
                sprcol = render_sprites (dpix + 1, 0, sprpix_val, 1);
                if (sprcol) {
                    out_val2 = colors_for_drawing.acolors[sprcol];
                }
            }
            buf[dpix++] = out_val1;
            buf[dpix++] = out_val2;
            }
        }
    }

    return spix;
}
#endif

#ifdef AGA
static int NOINLINE __attribute__((__unused__)) linetoscr_16_stretch1_aga_spr_genlock(int spix, int dpix, int dpix_end)
{
    uae_u16 *buf = (uae_u16 *) xlinebuffer;
    uae_u8 *genlock_buf = xlinebuffer_genlock;
    uae_u8 sprcol;
    uae_u8 xor_val = bplxor;

    if (bplham) {
        while (dpix < dpix_end) {
            uae_u32 sprpix_val;
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            sprpix_val = pixdata.apixels[spix];
            spix_val = pixdata.apixels[spix] ^ xor_val;
            spix_val = ham_linebuf[spix];
            dpix_val = CONVERT_RGB (spix_val);
            spix++;
            out_val = dpix_val;
            genlock_buf[dpix] = get_genlock_transparency((spix_val >> 2) & 63);
            genlock_buf[dpix + 1] = get_genlock_transparency((spix_val >> 2) & 63);
            {
            uae_u32 out_val1 = out_val;
            uae_u32 out_val2 = out_val;
            if (spritepixels[dpix + 0].data) {
                sprcol = render_sprites (dpix + 0, 0, sprpix_val, 1);
                if (sprcol) {
                    out_val1 = colors_for_drawing.acolors[sprcol];
                    genlock_buf[dpix] = get_genlock_transparency(sprcol);
                }
            }
            if (spritepixels[dpix + 1].data) {
                sprcol = render_sprites (dpix + 1, 0, sprpix_val, 1);
                if (sprcol) {
                    out_val2 = colors_for_drawing.acolors[sprcol];
                    genlock_buf[dpix + 1] = get_genlock_transparency(sprcol);
                }
            }
            buf[dpix++] = out_val1;
            buf[dpix++] = out_val2;
            }
        }
    } else if (bpldualpf) {
        int *lookup    = bpldualpfpri ? dblpf_ind2_aga : dblpf_ind1_aga;
        int *lookup_no = bpldualpfpri ? dblpf_2nd2     : dblpf_2nd1;
        while (dpix < dpix_end) {
            uae_u32 sprpix_val;
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix];
            sprpix_val = spix_val;
            {
                uae_u8 val = lookup[spix_val];
                if (lookup_no[spix_val])
                    val += dblpfofs[bpldualpf2of];
                val ^= xor_val;
                dpix_val = colors_for_drawing.acolors[val];
            }
            spix++;
            out_val = dpix_val;
            genlock_buf[dpix] = get_genlock_transparency(lookup[spix_val]);
            genlock_buf[dpix + 1] = get_genlock_transparency(lookup[spix_val]);
            {
            uae_u32 out_val1 = out_val;
            uae_u32 out_val2 = out_val;
            if (spritepixels[dpix + 0].data) {
                sprcol = render_sprites (dpix + 0, 1, sprpix_val, 1);
                if (sprcol) {
                    out_val1 = colors_for_drawing.acolors[sprcol];
                    genlock_buf[dpix] = get_genlock_transparency(sprcol);
                }
            }
            if (spritepixels[dpix + 1].data) {
                sprcol = render_sprites (dpix + 1, 1, sprpix_val, 1);
                if (sprcol) {
                    out_val2 = colors_for_drawing.acolors[sprcol];
                    genlock_buf[dpix + 1] = get_genlock_transparency(sprcol);
                }
            }
            buf[dpix++] = out_val1;
            buf[dpix++] = out_val2;
            }
        }
    } else if (bplehb) {
        while (dpix < dpix_end) {
            uae_u32 sprpix_val;
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            sprpix_val = pixdata.apixels[spix];
            spix_val = pixdata.apixels[spix] ^ xor_val;
            if (spix_val >= 32 && spix_val < 64) {
                unsigned int c = (colors_for_drawing.color_regs_aga[spix_val - 32] >> 1) & 0x7F7F7F;
                dpix_val = CONVERT_RGB (c);
            } else
                dpix_val = colors_for_drawing.acolors[spix_val];
            spix++;
            out_val = dpix_val;
            genlock_buf[dpix] = get_genlock_transparency(spix_val & 31);
            genlock_buf[dpix + 1] = get_genlock_transparency(spix_val & 31);
            {
            uae_u32 out_val1 = out_val;
            uae_u32 out_val2 = out_val;
            if (spritepixels[dpix + 0].data) {
                sprcol = render_sprites (dpix + 0, 0, sprpix_val, 1);
                if (sprcol) {
                    out_val1 = colors_for_drawing.acolors[sprcol];
                    genlock_buf[dpix] = get_genlock_transparency(sprcol);
                }
            }
            if (spritepixels[dpix + 1].data) {
                sprcol = render_sprites (dpix + 1, 0, sprpix_val, 1);
                if (sprcol) {
                    out_val2 = colors_for_drawing.acolors[sprcol];
                    genlock_buf[dpix + 1] = get_genlock_transparency(sprcol);
                }
            }
            buf[dpix++] = out_val1;
            buf[dpix++] = out_val2;
            }
        }
    } else {
        while (dpix < dpix_end) {
            uae_u32 sprpix_val;
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            sprpix_val = pixdata.apixels[spix];
            spix_val = pixdata.apixels[spix] ^ xor_val;
            dpix_val = colors_for_drawing.acolors[spix_val];
            spix++;
            out_val = dpix_val;
            genlock_buf[dpix] = get_genlock_transparency(spix_val);
            genlock_buf[dpix + 1] = get_genlock_transparency(spix_val);
            {
            uae_u32 out_val1 = out_val;
            uae_u32 out_val2 = out_val;
            if (spritepixels[dpix + 0].data) {
                sprcol = render_sprites (dpix + 0, 0, sprpix_val, 1);
                if (sprcol) {
                    out_val1 = colors_for_drawing.acolors[sprcol];
                    genlock_buf[dpix] = get_genlock_transparency(sprcol);
                }
            }
            if (spritepixels[dpix + 1].data) {
                sprcol = render_sprites (dpix + 1, 0, sprpix_val, 1);
                if (sprcol) {
                    out_val2 = colors_for_drawing.acolors[sprcol];
                    genlock_buf[dpix + 1] = get_genlock_transparency(sprcol);
                }
            }
            buf[dpix++] = out_val1;
            buf[dpix++] = out_val2;
            }
        }
    }

    return spix;
}
#endif

#ifdef AGA
static int NOINLINE __attribute__((__unused__)) linetoscr_16_stretch2_aga_spr(int spix, int dpix, int dpix_end)
{
    uae_u16 *buf = (uae_u16 *) xlinebuffer;
    uae_u8 sprcol;
    uae_u8 xor_val = bplxor;

    if (bplham) {
        while (dpix < dpix_end) {
            uae_u32 sprpix_val;
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            sprpix_val = pixdata.apixels[spix];
            spix_val = pixdata.apixels[spix] ^ xor_val;
            spix_val = ham_linebuf[spix];
            dpix_val = CONVERT_RGB (spix_val);
            spix++;
            out_val = dpix_val;
            {
            uae_u32 out_val1 = out_val;
            uae_u32 out_val2 = out_val;
            uae_u32 out_val3 = out_val;
            uae_u32 out_val4 = out_val;
            if (spritepixels[dpix + 0].data) {
                sprcol = render_sprites (dpix + 0, 0, sprpix_val, 1);
                if (sprcol) {
                    out_val1 = colors_for_drawing.acolors[sprcol];
                }
            }
            if (spritepixels[dpix + 1].data) {
                sprcol = render_sprites (dpix + 1, 0, sprpix_val, 1);
                if (sprcol) {
                    out_val2 = colors_for_drawing.acolors[sprcol];
                }
            }
            if (spritepixels[dpix + 2].data) {
                sprcol = render_sprites (dpix + 2, 0, sprpix_val, 1);
                if (sprcol) {
                    out_val3 = colors_for_drawing.acolors[sprcol];
                }
            }
            if (spritepixels[dpix + 3].data) {
                sprcol = render_sprites (dpix + 3, 0, sprpix_val, 1);
                if (sprcol) {
                    out_val4 = colors_for_drawing.acolors[sprcol];
                }
            }
            buf[dpix++] = out_val1;
            buf[dpix++] = out_val2;
            buf[dpix++] = out_val3;
            buf[dpix++] = out_val4;
            }
        }
    } else if (bpldualpf) {
        int *lookup    = bpldualpfpri ? dblpf_ind2_aga : dblpf_ind1_aga;
        int *lookup_no = bpldualpfpri ? dblpf_2nd2     : dblpf_2nd1;
        while (dpix < dpix_end) {
            uae_u32 sprpix_val;
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix];
            sprpix_val = spix_val;
            {
                uae_u8 val = lookup[spix_val];
                if (lookup_no[spix_val])
                    val += dblpfofs[bpldualpf2of];
                val ^= xor_val;
                dpix_val = colors_for_drawing.acolors[val];
            }
            spix++;
            out_val = dpix_val;
            {
            uae_u32 out_val1 = out_val;
            uae_u32 out_val2 = out_val;
            uae_u32 out_val3 = out_val;
            uae_u32 out_val4 = out_val;
            if (spritepixels[dpix + 0].data) {
                sprcol = render_sprites (dpix + 0, 1, sprpix_val, 1);
                if (sprcol) {
                    out_val1 = colors_for_drawing.acolors[sprcol];
                }
            }
            if (spritepixels[dpix + 1].data) {
                sprcol = render_sprites (dpix + 1, 1, sprpix_val, 1);
                if (sprcol) {
                    out_val2 = colors_for_drawing.acolors[sprcol];
                }
            }
            if (spritepixels[dpix + 2].data) {
                sprcol = render_sprites (dpix + 2, 1, sprpix_val, 1);
                if (sprcol) {
                    out_val3 = colors_for_drawing.acolors[sprcol];
                }
            }
            if (spritepixels[dpix + 3].data) {
                sprcol = render_sprites (dpix + 3, 1, sprpix_val, 1);
                if (sprcol) {
                    out_val4 = colors_for_drawing.acolors[sprcol];
                }
            }
            buf[dpix++] = out_val1;
            buf[dpix++] = out_val2;
            buf[dpix++] = out_val3;
            buf[dpix++] = out_val4;
            }
        }
    } else if (bplehb) {
        while (dpix < dpix_end) {
            uae_u32 sprpix_val;
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            sprpix_val = pixdata.apixels[spix];
            spix_val = pixdata.apixels[spix] ^ xor_val;
            if (spix_val >= 32 && spix_val < 64) {
                unsigned int c = (colors_for_drawing.color_regs_aga[spix_val - 32] >> 1) & 0x7F7F7F;
                dpix_val = CONVERT_RGB (c);
            } else
                dpix_val = colors_for_drawing.acolors[spix_val];
            spix++;
            out_val = dpix_val;
            {
            uae_u32 out_val1 = out_val;
            uae_u32 out_val2 = out_val;
            uae_u32 out_val3 = out_val;
            uae_u32 out_val4 = out_val;
            if (spritepixels[dpix + 0].data) {
                sprcol = render_sprites (dpix + 0, 0, sprpix_val, 1);
                if (sprcol) {
                    out_val1 = colors_for_drawing.acolors[sprcol];
                }
            }
            if (spritepixels[dpix + 1].data) {
                sprcol = render_sprites (dpix + 1, 0, sprpix_val, 1);
                if (sprcol) {
                    out_val2 = colors_for_drawing.acolors[sprcol];
                }
            }
            if (spritepixels[dpix + 2].data) {
                sprcol = render_sprites (dpix + 2, 0, sprpix_val, 1);
                if (sprcol) {
                    out_val3 = colors_for_drawing.acolors[sprcol];
                }
            }
            if (spritepixels[dpix + 3].data) {
                sprcol = render_sprites (dpix + 3, 0, sprpix_val, 1);
                if (sprcol) {
                    out_val4 = colors_for_drawing.acolors[sprcol];
                }
            }
            buf[dpix++] = out_val1;
            buf[dpix++] = out_val2;
            buf[dpix++] = out_val3;
            buf[dpix++] = out_val4;
            }
        }
    } else {
        while (dpix < dpix_end) {
            uae_u32 sprpix_val;
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            sprpix_val = pixdata.apixels[spix];
            spix_val = pixdata.apixels[spix] ^ xor_val;
            dpix_val = colors_for_drawing.acolors[spix_val];
            spix++;
            out_val = dpix_val;
            {
            uae_u32 out_val1 = out_val;
            uae_u32 out_val2 = out_val;
            uae_u32 out_val3 = out_val;
            uae_u32 out_val4 = out_val;
            if (spritepixels[dpix + 0].data) {
                sprcol = render_sprites (dpix + 0, 0, sprpix_val, 1);
                if (sprcol) {
                    out_val1 = colors_for_drawing.acolors[sprcol];
                }
            }
            if (spritepixels[dpix + 1].data) {
                sprcol = render_sprites (dpix + 1, 0, sprpix_val, 1);
                if (sprcol) {
                    out_val2 = colors_for_drawing.acolors[sprcol];
                }
            }
            if (spritepixels[dpix + 2].data) {
                sprcol = render_sprites (dpix + 2, 0, sprpix_val, 1);
                if (sprcol) {
                    out_val3 = colors_for_drawing.acolors[sprcol];
                }
            }
            if (spritepixels[dpix + 3].data) {
                sprcol = render_sprites (dpix + 3, 0, sprpix_val, 1);
                if (sprcol) {
                    out_val4 = colors_for_drawing.acolors[sprcol];
                }
            }
            buf[dpix++] = out_val1;
            buf[dpix++] = out_val2;
            buf[dpix++] = out_val3;
            buf[dpix++] = out_val4;
            }
        }
    }

    return spix;
}
#endif

#ifdef AGA
static int NOINLINE __attribute__((__unused__)) linetoscr_16_stretch2_aga_spr_genlock(int spix, int dpix, int dpix_end)
{
    uae_u16 *buf = (uae_u16 *) xlinebuffer;
    uae_u8 *genlock_buf = xlinebuffer_genlock;
    uae_u8 sprcol;
    uae_u8 xor_val = bplxor;

    if (bplham) {
        while (dpix < dpix_end) {
            uae_u32 sprpix_val;
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            sprpix_val = pixdata.apixels[spix];
            spix_val = pixdata.apixels[spix] ^ xor_val;
            spix_val = ham_linebuf[spix];
            dpix_val = CONVERT_RGB (spix_val);
            spix++;
            out_val = dpix_val;
            genlock_buf[dpix] = get_genlock_transparency((spix_val >> 2) & 63);
            genlock_buf[dpix + 1] = get_genlock_transparency((spix_val >> 2) & 63);
            genlock_buf[dpix + 2] = get_genlock_transparency((spix_val >> 2) & 63);
            genlock_buf[dpix + 3] = get_genlock_transparency((spix_val >> 2) & 63);
            {
            uae_u32 out_val1 = out_val;
            uae_u32 out_val2 = out_val;
            uae_u32 out_val3 = out_val;
            uae_u32 out_val4 = out_val;
            if (spritepixels[dpix + 0].data) {
                sprcol = render_sprites (dpix + 0, 0, sprpix_val, 1);
                if (sprcol) {
                    out_val1 = colors_for_drawing.acolors[sprcol];
                    genlock_buf[dpix] = get_genlock_transparency(sprcol);
                }
            }
            if (spritepixels[dpix + 1].data) {
                sprcol = render_sprites (dpix + 1, 0, sprpix_val, 1);
                if (sprcol) {
                    out_val2 = colors_for_drawing.acolors[sprcol];
                    genlock_buf[dpix + 1] = get_genlock_transparency(sprcol);
                }
            }
            if (spritepixels[dpix + 2].data) {
                sprcol = render_sprites (dpix + 2, 0, sprpix_val, 1);
                if (sprcol) {
                    out_val3 = colors_for_drawing.acolors[sprcol];
                    genlock_buf[dpix + 2] = get_genlock_transparency(sprcol);
                }
            }
            if (spritepixels[dpix + 3].data) {
                sprcol = render_sprites (dpix + 3, 0, sprpix_val, 1);
                if (sprcol) {
                    out_val4 = colors_for_drawing.acolors[sprcol];
                    genlock_buf[dpix + 3] = get_genlock_transparency(sprcol);
                }
            }
            buf[dpix++] = out_val1;
            buf[dpix++] = out_val2;
            buf[dpix++] = out_val3;
            buf[dpix++] = out_val4;
            }
        }
    } else if (bpldualpf) {
        int *lookup    = bpldualpfpri ? dblpf_ind2_aga : dblpf_ind1_aga;
        int *lookup_no = bpldualpfpri ? dblpf_2nd2     : dblpf_2nd1;
        while (dpix < dpix_end) {
            uae_u32 sprpix_val;
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix];
            sprpix_val = spix_val;
            {
                uae_u8 val = lookup[spix_val];
                if (lookup_no[spix_val])
                    val += dblpfofs[bpldualpf2of];
                val ^= xor_val;
                dpix_val = colors_for_drawing.acolors[val];
            }
            spix++;
            out_val = dpix_val;
            genlock_buf[dpix] = get_genlock_transparency(lookup[spix_val]);
            genlock_buf[dpix + 1] = get_genlock_transparency(lookup[spix_val]);
            genlock_buf[dpix + 2] = get_genlock_transparency(lookup[spix_val]);
            genlock_buf[dpix + 3] = get_genlock_transparency(lookup[spix_val]);
            {
            uae_u32 out_val1 = out_val;
            uae_u32 out_val2 = out_val;
            uae_u32 out_val3 = out_val;
            uae_u32 out_val4 = out_val;
            if (spritepixels[dpix + 0].data) {
                sprcol = render_sprites (dpix + 0, 1, sprpix_val, 1);
                if (sprcol) {
                    out_val1 = colors_for_drawing.acolors[sprcol];
                    genlock_buf[dpix] = get_genlock_transparency(sprcol);
                }
            }
            if (spritepixels[dpix + 1].data) {
                sprcol = render_sprites (dpix + 1, 1, sprpix_val, 1);
                if (sprcol) {
                    out_val2 = colors_for_drawing.acolors[sprcol];
                    genlock_buf[dpix + 1] = get_genlock_transparency(sprcol);
                }
            }
            if (spritepixels[dpix + 2].data) {
                sprcol = render_sprites (dpix + 2, 1, sprpix_val, 1);
                if (sprcol) {
                    out_val3 = colors_for_drawing.acolors[sprcol];
                    genlock_buf[dpix + 2] = get_genlock_transparency(sprcol);
                }
            }
            if (spritepixels[dpix + 3].data) {
                sprcol = render_sprites (dpix + 3, 1, sprpix_val, 1);
                if (sprcol) {
                    out_val4 = colors_for_drawing.acolors[sprcol];
                    genlock_buf[dpix + 3] = get_genlock_transparency(sprcol);
                }
            }
            buf[dpix++] = out_val1;
            buf[dpix++] = out_val2;
            buf[dpix++] = out_val3;
            buf[dpix++] = out_val4;
            }
        }
    } else if (bplehb) {
        while (dpix < dpix_end) {
            uae_u32 sprpix_val;
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            sprpix_val = pixdata.apixels[spix];
            spix_val = pixdata.apixels[spix] ^ xor_val;
            if (spix_val >= 32 && spix_val < 64) {
                unsigned int c = (colors_for_drawing.color_regs_aga[spix_val - 32] >> 1) & 0x7F7F7F;
                dpix_val = CONVERT_RGB (c);
            } else
                dpix_val = colors_for_drawing.acolors[spix_val];
            spix++;
            out_val = dpix_val;
            genlock_buf[dpix] = get_genlock_transparency(spix_val & 31);
            genlock_buf[dpix + 1] = get_genlock_transparency(spix_val & 31);
            genlock_buf[dpix + 2] = get_genlock_transparency(spix_val & 31);
            genlock_buf[dpix + 3] = get_genlock_transparency(spix_val & 31);
            {
            uae_u32 out_val1 = out_val;
            uae_u32 out_val2 = out_val;
            uae_u32 out_val3 = out_val;
            uae_u32 out_val4 = out_val;
            if (spritepixels[dpix + 0].data) {
                sprcol = render_sprites (dpix + 0, 0, sprpix_val, 1);
                if (sprcol) {
                    out_val1 = colors_for_drawing.acolors[sprcol];
                    genlock_buf[dpix] = get_genlock_transparency(sprcol);
                }
            }
            if (spritepixels[dpix + 1].data) {
                sprcol = render_sprites (dpix + 1, 0, sprpix_val, 1);
                if (sprcol) {
                    out_val2 = colors_for_drawing.acolors[sprcol];
                    genlock_buf[dpix + 1] = get_genlock_transparency(sprcol);
                }
            }
            if (spritepixels[dpix + 2].data) {
                sprcol = render_sprites (dpix + 2, 0, sprpix_val, 1);
                if (sprcol) {
                    out_val3 = colors_for_drawing.acolors[sprcol];
                    genlock_buf[dpix + 2] = get_genlock_transparency(sprcol);
                }
            }
            if (spritepixels[dpix + 3].data) {
                sprcol = render_sprites (dpix + 3, 0, sprpix_val, 1);
                if (sprcol) {
                    out_val4 = colors_for_drawing.acolors[sprcol];
                    genlock_buf[dpix + 3] = get_genlock_transparency(sprcol);
                }
            }
            buf[dpix++] = out_val1;
            buf[dpix++] = out_val2;
            buf[dpix++] = out_val3;
            buf[dpix++] = out_val4;
            }
        }
    } else {
        while (dpix < dpix_end) {
            uae_u32 sprpix_val;
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            sprpix_val = pixdata.apixels[spix];
            spix_val = pixdata.apixels[spix] ^ xor_val;
            dpix_val = colors_for_drawing.acolors[spix_val];
            spix++;
            out_val = dpix_val;
            genlock_buf[dpix] = get_genlock_transparency(spix_val);
            genlock_buf[dpix + 1] = get_genlock_transparency(spix_val);
            genlock_buf[dpix + 2] = get_genlock_transparency(spix_val);
            genlock_buf[dpix + 3] = get_genlock_transparency(spix_val);
            {
            uae_u32 out_val1 = out_val;
            uae_u32 out_val2 = out_val;
            uae_u32 out_val3 = out_val;
            uae_u32 out_val4 = out_val;
            if (spritepixels[dpix + 0].data) {
                sprcol = render_sprites (dpix + 0, 0, sprpix_val, 1);
                if (sprcol) {
                    out_val1 = colors_for_drawing.acolors[sprcol];
                    genlock_buf[dpix] = get_genlock_transparency(sprcol);
                }
            }
            if (spritepixels[dpix + 1].data) {
                sprcol = render_sprites (dpix + 1, 0, sprpix_val, 1);
                if (sprcol) {
                    out_val2 = colors_for_drawing.acolors[sprcol];
                    genlock_buf[dpix + 1] = get_genlock_transparency(sprcol);
                }
            }
            if (spritepixels[dpix + 2].data) {
                sprcol = render_sprites (dpix + 2, 0, sprpix_val, 1);
                if (sprcol) {
                    out_val3 = colors_for_drawing.acolors[sprcol];
                    genlock_buf[dpix + 2] = get_genlock_transparency(sprcol);
                }
            }
            if (spritepixels[dpix + 3].data) {
                sprcol = render_sprites (dpix + 3, 0, sprpix_val, 1);
                if (sprcol) {
                    out_val4 = colors_for_drawing.acolors[sprcol];
                    genlock_buf[dpix + 3] = get_genlock_transparency(sprcol);
                }
            }
            buf[dpix++] = out_val1;
            buf[dpix++] = out_val2;
            buf[dpix++] = out_val3;
            buf[dpix++] = out_val4;
            }
        }
    }

    return spix;
}
#endif

#ifdef AGA
static int NOINLINE __attribute__((__unused__)) linetoscr_16_shrink1_aga_spr(int spix, int dpix, int dpix_end)
{
    uae_u16 *buf = (uae_u16 *) xlinebuffer;
    uae_u8 sprcol;
    uae_u8 xor_val = bplxor;

    if (bplham) {
        while (dpix < dpix_end) {
            uae_u32 sprpix_val;
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            sprpix_val = pixdata.apixels[spix];
            spix_val = pixdata.apixels[spix] ^ xor_val;
            spix_val = ham_linebuf[spix];
            dpix_val = CONVERT_RGB (spix_val);
            spix += 2;
            out_val = dpix_val;
            if (spritepixels[dpix].data) {
                sprcol = render_sprites (dpix + 0, 0, sprpix_val, 1);
                if (sprcol) {
                    out_val = colors_for_drawing.acolors[sprcol];
                }
            }
            buf[dpix++] = out_val;
        }
    } else if (bpldualpf) {
        int *lookup    = bpldualpfpri ? dblpf_ind2_aga : dblpf_ind1_aga;
        int *lookup_no = bpldualpfpri ? dblpf_2nd2     : dblpf_2nd1;
        while (dpix < dpix_end) {
            uae_u32 sprpix_val;
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix];
            sprpix_val = spix_val;
            {
                uae_u8 val = lookup[spix_val];
                if (lookup_no[spix_val])
                    val += dblpfofs[bpldualpf2of];
                val ^= xor_val;
                dpix_val = colors_for_drawing.acolors[val];
            }
            spix += 2;
            out_val = dpix_val;
            if (spritepixels[dpix].data) {
                sprcol = render_sprites (dpix + 0, 1, sprpix_val, 1);
                if (sprcol) {
                    out_val = colors_for_drawing.acolors[sprcol];
                }
            }
            buf[dpix++] = out_val;
        }
    } else if (bplehb) {
        while (dpix < dpix_end) {
            uae_u32 sprpix_val;
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            sprpix_val = pixdata.apixels[spix];
            spix_val = pixdata.apixels[spix] ^ xor_val;
            if (spix_val >= 32 && spix_val < 64) {
                unsigned int c = (colors_for_drawing.color_regs_aga[spix_val - 32] >> 1) & 0x7F7F7F;
                dpix_val = CONVERT_RGB (c);
            } else
                dpix_val = colors_for_drawing.acolors[spix_val];
            spix += 2;
            out_val = dpix_val;
            if (spritepixels[dpix].data) {
                sprcol = render_sprites (dpix + 0, 0, sprpix_val, 1);
                if (sprcol) {
                    out_val = colors_for_drawing.acolors[sprcol];
                }
            }
            buf[dpix++] = out_val;
        }
    } else {
        while (dpix < dpix_end) {
            uae_u32 sprpix_val;
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            sprpix_val = pixdata.apixels[spix];
            spix_val = pixdata.apixels[spix] ^ xor_val;
            dpix_val = colors_for_drawing.acolors[spix_val];
            spix += 2;
            out_val = dpix_val;
            if (spritepixels[dpix].data) {
                sprcol = render_sprites (dpix + 0, 0, sprpix_val, 1);
                if (sprcol) {
                    out_val = colors_for_drawing.acolors[sprcol];
                }
            }
            buf[dpix++] = out_val;
        }
    }

    return spix;
}
#endif

#ifdef AGA
static int NOINLINE __attribute__((__unused__)) linetoscr_16_shrink1_aga_spr_genlock(int spix, int dpix, int dpix_end)
{
    uae_u16 *buf = (uae_u16 *) xlinebuffer;
    uae_u8 *genlock_buf = xlinebuffer_genlock;
    uae_u8 sprcol;
    uae_u8 xor_val = bplxor;

    if (bplham) {
        while (dpix < dpix_end) {
            uae_u32 sprpix_val;
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            sprpix_val = pixdata.apixels[spix];
            spix_val = pixdata.apixels[spix] ^ xor_val;
            spix_val = ham_linebuf[spix];
            dpix_val = CONVERT_RGB (spix_val);
            spix += 2;
            out_val = dpix_val;
            genlock_buf[dpix] = get_genlock_transparency((spix_val >> 2) & 63);
            if (spritepixels[dpix].data) {
                sprcol = render_sprites (dpix + 0, 0, sprpix_val, 1);
                if (sprcol) {
                    out_val = colors_for_drawing.acolors[sprcol];
                    genlock_buf[dpix] = get_genlock_transparency(sprcol);
                }
            }
            buf[dpix++] = out_val;
        }
    } else if (bpldualpf) {
        int *lookup    = bpldualpfpri ? dblpf_ind2_aga : dblpf_ind1_aga;
        int *lookup_no = bpldualpfpri ? dblpf_2nd2     : dblpf_2nd1;
        while (dpix < dpix_end) {
            uae_u32 sprpix_val;
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix];
            sprpix_val = spix_val;
            {
                uae_u8 val = lookup[spix_val];
                if (lookup_no[spix_val])
                    val += dblpfofs[bpldualpf2of];
                val ^= xor_val;
                dpix_val = colors_for_drawing.acolors[val];
            }
            spix += 2;
            out_val = dpix_val;
            genlock_buf[dpix] = get_genlock_transparency(lookup[spix_val]);
            if (spritepixels[dpix].data) {
                sprcol = render_sprites (dpix + 0, 1, sprpix_val, 1);
                if (sprcol) {
                    out_val = colors_for_drawing.acolors[sprcol];
                    genlock_buf[dpix] = get_genlock_transparency(sprcol);
                }
            }
            buf[dpix++] = out_val;
        }
    } else if (bplehb) {
        while (dpix < dpix_end) {
            uae_u32 sprpix_val;
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            sprpix_val = pixdata.apixels[spix];
            spix_val = pixdata.apixels[spix] ^ xor_val;
            if (spix_val >= 32 && spix_val < 64) {
                unsigned int c = (colors_for_drawing.color_regs_aga[spix_val - 32] >> 1) & 0x7F7F7F;
                dpix_val = CONVERT_RGB (c);
            } else
                dpix_val = colors_for_drawing.acolors[spix_val];
            spix += 2;
            out_val = dpix_val;
            genlock_buf[dpix] = get_genlock_transparency(spix_val & 31);
            if (spritepixels[dpix].data) {
                sprcol = render_sprites (dpix + 0, 0, sprpix_val, 1);
                if (sprcol) {
                    out_val = colors_for_drawing.acolors[sprcol];
                    genlock_buf[dpix] = get_genlock_transparency(sprcol);
                }
            }
            buf[dpix++] = out_val;
        }
    } else {
        while (dpix < dpix_end) {
            uae_u32 sprpix_val;
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            sprpix_val = pixdata.apixels[spix];
            spix_val = pixdata.apixels[spix] ^ xor_val;
            dpix_val = colors_for_drawing.acolors[spix_val];
            spix += 2;
            out_val = dpix_val;
            genlock_buf[dpix] = get_genlock_transparency(spix_val);
            if (spritepixels[dpix].data) {
                sprcol = render_sprites (dpix + 0, 0, sprpix_val, 1);
                if (sprcol) {
                    out_val = colors_for_drawing.acolors[sprcol];
                    genlock_buf[dpix] = get_genlock_transparency(sprcol);
                }
            }
            buf[dpix++] = out_val;
        }
    }

    return spix;
}
#endif

#ifdef AGA
static int NOINLINE __attribute__((__unused__)) linetoscr_16_shrink1f_aga_spr(int spix, int dpix, int dpix_end)
{
    uae_u16 *buf = (uae_u16 *) xlinebuffer;
    uae_u8 sprcol;
    uae_u8 xor_val = bplxor;

    if (bplham) {
        while (dpix < dpix_end) {
            uae_u32 sprpix_val;
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            sprpix_val = pixdata.apixels[spix];
            spix_val = pixdata.apixels[spix] ^ xor_val;
            spix_val = ham_linebuf[spix];
            dpix_val = CONVERT_RGB (spix_val);
            {
            uae_u32 tmp_val;
            spix++;
            tmp_val = dpix_val;
            sprpix_val = pixdata.apixels[spix];
            spix_val = pixdata.apixels[spix] ^ xor_val;
            spix_val = ham_linebuf[spix];
            dpix_val = CONVERT_RGB (spix_val);
            dpix_val = merge_2pixel16 (dpix_val, tmp_val);
            spix++;
            }
            out_val = dpix_val;
            if (spritepixels[dpix].data) {
                sprcol = render_sprites (dpix + 0, 0, sprpix_val, 1);
                if (sprcol) {
                    out_val = colors_for_drawing.acolors[sprcol];
                }
            }
            buf[dpix++] = out_val;
        }
    } else if (bpldualpf) {
        int *lookup    = bpldualpfpri ? dblpf_ind2_aga : dblpf_ind1_aga;
        int *lookup_no = bpldualpfpri ? dblpf_2nd2     : dblpf_2nd1;
        while (dpix < dpix_end) {
            uae_u32 sprpix_val;
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix];
            sprpix_val = spix_val;
            {
                uae_u8 val = lookup[spix_val];
                if (lookup_no[spix_val])
                    val += dblpfofs[bpldualpf2of];
                val ^= xor_val;
                dpix_val = colors_for_drawing.acolors[val];
            }
            {
            uae_u32 tmp_val;
            spix++;
            tmp_val = dpix_val;
            spix_val = pixdata.apixels[spix];
            sprpix_val = spix_val;
            {
                uae_u8 val = lookup[spix_val];
                if (lookup_no[spix_val])
                    val += dblpfofs[bpldualpf2of];
                val ^= xor_val;
                dpix_val = colors_for_drawing.acolors[val];
            }
            dpix_val = merge_2pixel16 (dpix_val, tmp_val);
            spix++;
            }
            out_val = dpix_val;
            if (spritepixels[dpix].data) {
                sprcol = render_sprites (dpix + 0, 1, sprpix_val, 1);
                if (sprcol) {
                    out_val = colors_for_drawing.acolors[sprcol];
                }
            }
            buf[dpix++] = out_val;
        }
    } else if (bplehb) {
        while (dpix < dpix_end) {
            uae_u32 sprpix_val;
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            sprpix_val = pixdata.apixels[spix];
            spix_val = pixdata.apixels[spix] ^ xor_val;
            if (spix_val >= 32 && spix_val < 64) {
                unsigned int c = (colors_for_drawing.color_regs_aga[spix_val - 32] >> 1) & 0x7F7F7F;
                dpix_val = CONVERT_RGB (c);
            } else
                dpix_val = colors_for_drawing.acolors[spix_val];
            {
            uae_u32 tmp_val;
            spix++;
            tmp_val = dpix_val;
            sprpix_val = pixdata.apixels[spix];
            spix_val = pixdata.apixels[spix] ^ xor_val;
            if (spix_val >= 32 && spix_val < 64) {
                unsigned int c = (colors_for_drawing.color_regs_aga[spix_val - 32] >> 1) & 0x7F7F7F;
                dpix_val = CONVERT_RGB (c);
            } else
                dpix_val = colors_for_drawing.acolors[spix_val];
            dpix_val = merge_2pixel16 (dpix_val, tmp_val);
            spix++;
            }
            out_val = dpix_val;
            if (spritepixels[dpix].data) {
                sprcol = render_sprites (dpix + 0, 0, sprpix_val, 1);
                if (sprcol) {
                    out_val = colors_for_drawing.acolors[sprcol];
                }
            }
            buf[dpix++] = out_val;
        }
    } else {
        while (dpix < dpix_end) {
            uae_u32 sprpix_val;
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            sprpix_val = pixdata.apixels[spix];
            spix_val = pixdata.apixels[spix] ^ xor_val;
            dpix_val = colors_for_drawing.acolors[spix_val];
            {
            uae_u32 tmp_val;
            spix++;
            tmp_val = dpix_val;
            sprpix_val = pixdata.apixels[spix];
            spix_val = pixdata.apixels[spix] ^ xor_val;
            dpix_val = colors_for_drawing.acolors[spix_val];
            dpix_val = merge_2pixel16 (dpix_val, tmp_val);
            spix++;
            }
            out_val = dpix_val;
            if (spritepixels[dpix].data) {
                sprcol = render_sprites (dpix + 0, 0, sprpix_val, 1);
                if (sprcol) {
                    out_val = colors_for_drawing.acolors[sprcol];
                }
            }
            buf[dpix++] = out_val;
        }
    }

    return spix;
}
#endif

#ifdef AGA
static int NOINLINE __attribute__((__unused__)) linetoscr_16_shrink1f_aga_spr_genlock(int spix, int dpix, int dpix_end)
{
    uae_u16 *buf = (uae_u16 *) xlinebuffer;
    uae_u8 *genlock_buf = xlinebuffer_genlock;
    uae_u8 sprcol;
    uae_u8 xor_val = bplxor;

    if (bplham) {
        while (dpix < dpix_end) {
            uae_u32 sprpix_val;
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            sprpix_val = pixdata.apixels[spix];
            spix_val = pixdata.apixels[spix] ^ xor_val;
            spix_val = ham_linebuf[spix];
            dpix_val = CONVERT_RGB (spix_val);
            {
            uae_u32 tmp_val;
            spix++;
            tmp_val = dpix_val;
            sprpix_val = pixdata.apixels[spix];
            spix_val = pixdata.apixels[spix] ^ xor_val;
            spix_val = ham_linebuf[spix];
            dpix_val = CONVERT_RGB (spix_val);
            dpix_val = merge_2pixel16 (dpix_val, tmp_val);
            spix++;
            }
            out_val = dpix_val;
            genlock_buf[dpix] = get_genlock_transparency((spix_val >> 2) & 63);
            if (spritepixels[dpix].data) {
                sprcol = render_sprites (dpix + 0, 0, sprpix_val, 1);
                if (sprcol) {
                    out_val = colors_for_drawing.acolors[sprcol];
                    genlock_buf[dpix] = get_genlock_transparency(sprcol);
                }
            }
            buf[dpix++] = out_val;
        }
    } else if (bpldualpf) {
        int *lookup    = bpldualpfpri ? dblpf_ind2_aga : dblpf_ind1_aga;
        int *lookup_no = bpldualpfpri ? dblpf_2nd2     : dblpf_2nd1;
        while (dpix < dpix_end) {
            uae_u32 sprpix_val;
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix];
            sprpix_val = spix_val;
            {
                uae_u8 val = lookup[spix_val];
                if (lookup_no[spix_val])
                    val += dblpfofs[bpldualpf2of];
                val ^= xor_val;
                dpix_val = colors_for_drawing.acolors[val];
            }
            {
            uae_u32 tmp_val;
            spix++;
            tmp_val = dpix_val;
            spix_val = pixdata.apixels[spix];
            sprpix_val = spix_val;
            {
                uae_u8 val = lookup[spix_val];
                if (lookup_no[spix_val])
                    val += dblpfofs[bpldualpf2of];
                val ^= xor_val;
                dpix_val = colors_for_drawing.acolors[val];
            }
            dpix_val = merge_2pixel16 (dpix_val, tmp_val);
            spix++;
            }
            out_val = dpix_val;
            genlock_buf[dpix] = get_genlock_transparency(lookup[spix_val]);
            if (spritepixels[dpix].data) {
                sprcol = render_sprites (dpix + 0, 1, sprpix_val, 1);
                if (sprcol) {
                    out_val = colors_for_drawing.acolors[sprcol];
                    genlock_buf[dpix] = get_genlock_transparency(sprcol);
                }
            }
            buf[dpix++] = out_val;
        }
    } else if (bplehb) {
        while (dpix < dpix_end) {
            uae_u32 sprpix_val;
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            sprpix_val = pixdata.apixels[spix];
            spix_val = pixdata.apixels[spix] ^ xor_val;
            if (spix_val >= 32 && spix_val < 64) {
                unsigned int c = (colors_for_drawing.color_regs_aga[spix_val - 32] >> 1) & 0x7F7F7F;
                dpix_val = CONVERT_RGB (c);
            } else
                dpix_val = colors_for_drawing.acolors[spix_val];
            {
            uae_u32 tmp_val;
            spix++;
            tmp_val = dpix_val;
            sprpix_val = pixdata.apixels[spix];
            spix_val = pixdata.apixels[spix] ^ xor_val;
            if (spix_val >= 32 && spix_val < 64) {
                unsigned int c = (colors_for_drawing.color_regs_aga[spix_val - 32] >> 1) & 0x7F7F7F;
                dpix_val = CONVERT_RGB (c);
            } else
                dpix_val = colors_for_drawing.acolors[spix_val];
            dpix_val = merge_2pixel16 (dpix_val, tmp_val);
            spix++;
            }
            out_val = dpix_val;
            genlock_buf[dpix] = get_genlock_transparency(spix_val & 31);
            if (spritepixels[dpix].data) {
                sprcol = render_sprites (dpix + 0, 0, sprpix_val, 1);
                if (sprcol) {
                    out_val = colors_for_drawing.acolors[sprcol];
                    genlock_buf[dpix] = get_genlock_transparency(sprcol);
                }
            }
            buf[dpix++] = out_val;
        }
    } else {
        while (dpix < dpix_end) {
            uae_u32 sprpix_val;
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            sprpix_val = pixdata.apixels[spix];
            spix_val = pixdata.apixels[spix] ^ xor_val;
            dpix_val = colors_for_drawing.acolors[spix_val];
            {
            uae_u32 tmp_val;
            spix++;
            tmp_val = dpix_val;
            sprpix_val = pixdata.apixels[spix];
            spix_val = pixdata.apixels[spix] ^ xor_val;
            dpix_val = colors_for_drawing.acolors[spix_val];
            dpix_val = merge_2pixel16 (dpix_val, tmp_val);
            spix++;
            }
            out_val = dpix_val;
            genlock_buf[dpix] = get_genlock_transparency(spix_val);
            if (spritepixels[dpix].data) {
                sprcol = render_sprites (dpix + 0, 0, sprpix_val, 1);
                if (sprcol) {
                    out_val = colors_for_drawing.acolors[sprcol];
                    genlock_buf[dpix] = get_genlock_transparency(sprcol);
                }
            }
            buf[dpix++] = out_val;
        }
    }

    return spix;
}
#endif

#ifdef AGA
static int NOINLINE __attribute__((__unused__)) linetoscr_16_shrink2_aga_spr(int spix, int dpix, int dpix_end)
{
    uae_u16 *buf = (uae_u16 *) xlinebuffer;
    uae_u8 sprcol;
    uae_u8 xor_val = bplxor;

    if (bplham) {
        while (dpix < dpix_end) {
            uae_u32 sprpix_val;
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            sprpix_val = pixdata.apixels[spix];
            spix_val = pixdata.apixels[spix] ^ xor_val;
            spix_val = ham_linebuf[spix];
            dpix_val = CONVERT_RGB (spix_val);
            spix += 4;
            out_val = dpix_val;
            if (spritepixels[dpix].data) {
                sprcol = render_sprites (dpix + 0, 0, sprpix_val, 1);
                if (sprcol) {
                    out_val = colors_for_drawing.acolors[sprcol];
                }
            }
            buf[dpix++] = out_val;
        }
    } else if (bpldualpf) {
        int *lookup    = bpldualpfpri ? dblpf_ind2_aga : dblpf_ind1_aga;
        int *lookup_no = bpldualpfpri ? dblpf_2nd2     : dblpf_2nd1;
        while (dpix < dpix_end) {
            uae_u32 sprpix_val;
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix];
            sprpix_val = spix_val;
            {
                uae_u8 val = lookup[spix_val];
                if (lookup_no[spix_val])
                    val += dblpfofs[bpldualpf2of];
                val ^= xor_val;
                dpix_val = colors_for_drawing.acolors[val];
            }
            spix += 4;
            out_val = dpix_val;
            if (spritepixels[dpix].data) {
                sprcol = render_sprites (dpix + 0, 1, sprpix_val, 1);
                if (sprcol) {
                    out_val = colors_for_drawing.acolors[sprcol];
                }
            }
            buf[dpix++] = out_val;
        }
    } else if (bplehb) {
        while (dpix < dpix_end) {
            uae_u32 sprpix_val;
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            sprpix_val = pixdata.apixels[spix];
            spix_val = pixdata.apixels[spix] ^ xor_val;
            if (spix_val >= 32 && spix_val < 64) {
                unsigned int c = (colors_for_drawing.color_regs_aga[spix_val - 32] >> 1) & 0x7F7F7F;
                dpix_val = CONVERT_RGB (c);
            } else
                dpix_val = colors_for_drawing.acolors[spix_val];
            spix += 4;
            out_val = dpix_val;
            if (spritepixels[dpix].data) {
                sprcol = render_sprites (dpix + 0, 0, sprpix_val, 1);
                if (sprcol) {
                    out_val = colors_for_drawing.acolors[sprcol];
                }
            }
            buf[dpix++] = out_val;
        }
    } else {
        while (dpix < dpix_end) {
            uae_u32 sprpix_val;
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            sprpix_val = pixdata.apixels[spix];
            spix_val = pixdata.apixels[spix] ^ xor_val;
            dpix_val = colors_for_drawing.acolors[spix_val];
            spix += 4;
            out_val = dpix_val;
            if (spritepixels[dpix].data) {
                sprcol = render_sprites (dpix + 0, 0, sprpix_val, 1);
                if (sprcol) {
                    out_val = colors_for_drawing.acolors[sprcol];
                }
            }
            buf[dpix++] = out_val;
        }
    }

    return spix;
}
#endif

#ifdef AGA
static int NOINLINE __attribute__((__unused__)) linetoscr_16_shrink2_aga_spr_genlock(int spix, int dpix, int dpix_end)
{
    uae_u16 *buf = (uae_u16 *) xlinebuffer;
    uae_u8 *genlock_buf = xlinebuffer_genlock;
    uae_u8 sprcol;
    uae_u8 xor_val = bplxor;

    if (bplham) {
        while (dpix < dpix_end) {
            uae_u32 sprpix_val;
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            sprpix_val = pixdata.apixels[spix];
            spix_val = pixdata.apixels[spix] ^ xor_val;
            spix_val = ham_linebuf[spix];
            dpix_val = CONVERT_RGB (spix_val);
            spix += 4;
            out_val = dpix_val;
            genlock_buf[dpix] = get_genlock_transparency((spix_val >> 2) & 63);
            if (spritepixels[dpix].data) {
                sprcol = render_sprites (dpix + 0, 0, sprpix_val, 1);
                if (sprcol) {
                    out_val = colors_for_drawing.acolors[sprcol];
                    genlock_buf[dpix] = get_genlock_transparency(sprcol);
                }
            }
            buf[dpix++] = out_val;
        }
    } else if (bpldualpf) {
        int *lookup    = bpldualpfpri ? dblpf_ind2_aga : dblpf_ind1_aga;
        int *lookup_no = bpldualpfpri ? dblpf_2nd2     : dblpf_2nd1;
        while (dpix < dpix_end) {
            uae_u32 sprpix_val;
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix];
            sprpix_val = spix_val;
            {
                uae_u8 val = lookup[spix_val];
                if (lookup_no[spix_val])
                    val += dblpfofs[bpldualpf2of];
                val ^= xor_val;
                dpix_val = colors_for_drawing.acolors[val];
            }
            spix += 4;
            out_val = dpix_val;
            genlock_buf[dpix] = get_genlock_transparency(lookup[spix_val]);
            if (spritepixels[dpix].data) {
                sprcol = render_sprites (dpix + 0, 1, sprpix_val, 1);
                if (sprcol) {
                    out_val = colors_for_drawing.acolors[sprcol];
                    genlock_buf[dpix] = get_genlock_transparency(sprcol);
                }
            }
            buf[dpix++] = out_val;
        }
    } else if (bplehb) {
        while (dpix < dpix_end) {
            uae_u32 sprpix_val;
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            sprpix_val = pixdata.apixels[spix];
            spix_val = pixdata.apixels[spix] ^ xor_val;
            if (spix_val >= 32 && spix_val < 64) {
                unsigned int c = (colors_for_drawing.color_regs_aga[spix_val - 32] >> 1) & 0x7F7F7F;
                dpix_val = CONVERT_RGB (c);
            } else
                dpix_val = colors_for_drawing.acolors[spix_val];
            spix += 4;
            out_val = dpix_val;
            genlock_buf[dpix] = get_genlock_transparency(spix_val & 31);
            if (spritepixels[dpix].data) {
                sprcol = render_sprites (dpix + 0, 0, sprpix_val, 1);
                if (sprcol) {
                    out_val = colors_for_drawing.acolors[sprcol];
                    genlock_buf[dpix] = get_genlock_transparency(sprcol);
                }
            }
            buf[dpix++] = out_val;
        }
    } else {
        while (dpix < dpix_end) {
            uae_u32 sprpix_val;
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            sprpix_val = pixdata.apixels[spix];
            spix_val = pixdata.apixels[spix] ^ xor_val;
            dpix_val = colors_for_drawing.acolors[spix_val];
            spix += 4;
            out_val = dpix_val;
            genlock_buf[dpix] = get_genlock_transparency(spix_val);
            if (spritepixels[dpix].data) {
                sprcol = render_sprites (dpix + 0, 0, sprpix_val, 1);
                if (sprcol) {
                    out_val = colors_for_drawing.acolors[sprcol];
                    genlock_buf[dpix] = get_genlock_transparency(sprcol);
                }
            }
            buf[dpix++] = out_val;
        }
    }

    return spix;
}
#endif

#ifdef AGA
static int NOINLINE __attribute__((__unused__)) linetoscr_16_shrink2f_aga_spr(int spix, int dpix, int dpix_end)
{
    uae_u16 *buf = (uae_u16 *) xlinebuffer;
    uae_u8 sprcol;
    uae_u8 xor_val = bplxor;

    if (bplham) {
        while (dpix < dpix_end) {
            uae_u32 sprpix_val;
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            sprpix_val = pixdata.apixels[spix];
            spix_val = pixdata.apixels[spix] ^ xor_val;
            spix_val = ham_linebuf[spix];
            dpix_val = CONVERT_RGB (spix_val);
            {
            uae_u32 tmp_val, tmp_val2, tmp_val3;
            spix++;
            tmp_val = dpix_val;
            sprpix_val = pixdata.apixels[spix];
            spix_val = pixdata.apixels[spix] ^ xor_val;
            spix_val = ham_linebuf[spix];
            dpix_val = CONVERT_RGB (spix_val);
            spix++;
            tmp_val2 = dpix_val;
            sprpix_val = pixdata.apixels[spix];
            spix_val = pixdata.apixels[spix] ^ xor_val;
            spix_val = ham_linebuf[spix];
            dpix_val = CONVERT_RGB (spix_val);
            spix++;
            tmp_val3 = dpix_val;
            sprpix_val = pixdata.apixels[spix];
            spix_val = pixdata.apixels[spix] ^ xor_val;
            spix_val = ham_linebuf[spix];
            dpix_val = CONVERT_RGB (spix_val);
            tmp_val = merge_2pixel16 (tmp_val, tmp_val2);
            tmp_val2 = merge_2pixel16 (tmp_val3, dpix_val);
            dpix_val = merge_2pixel16 (tmp_val, tmp_val2);
            spix++;
            }
            out_val = dpix_val;
            if (spritepixels[dpix].data) {
                sprcol = render_sprites (dpix + 0, 0, sprpix_val, 1);
                if (sprcol) {
                    out_val = colors_for_drawing.acolors[sprcol];
                }
            }
            buf[dpix++] = out_val;
        }
    } else if (bpldualpf) {
        int *lookup    = bpldualpfpri ? dblpf_ind2_aga : dblpf_ind1_aga;
        int *lookup_no = bpldualpfpri ? dblpf_2nd2     : dblpf_2nd1;
        while (dpix < dpix_end) {
            uae_u32 sprpix_val;
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix];
            sprpix_val = spix_val;
            {
                uae_u8 val = lookup[spix_val];
                if (lookup_no[spix_val])
                    val += dblpfofs[bpldualpf2of];
                val ^= xor_val;
                dpix_val = colors_for_drawing.acolors[val];
            }
            {
            uae_u32 tmp_val, tmp_val2, tmp_val3;
            spix++;
            tmp_val = dpix_val;
            spix_val = pixdata.apixels[spix];
            sprpix_val = spix_val;
            {
                uae_u8 val = lookup[spix_val];
                if (lookup_no[spix_val])
                    val += dblpfofs[bpldualpf2of];
                val ^= xor_val;
                dpix_val = colors_for_drawing.acolors[val];
            }
            spix++;
            tmp_val2 = dpix_val;
            spix_val = pixdata.apixels[spix];
            sprpix_val = spix_val;
            {
                uae_u8 val = lookup[spix_val];
                if (lookup_no[spix_val])
                    val += dblpfofs[bpldualpf2of];
                val ^= xor_val;
                dpix_val = colors_for_drawing.acolors[val];
            }
            spix++;
            tmp_val3 = dpix_val;
            spix_val = pixdata.apixels[spix];
            sprpix_val = spix_val;
            {
                uae_u8 val = lookup[spix_val];
                if (lookup_no[spix_val])
                    val += dblpfofs[bpldualpf2of];
                val ^= xor_val;
                dpix_val = colors_for_drawing.acolors[val];
            }
            tmp_val = merge_2pixel16 (tmp_val, tmp_val2);
            tmp_val2 = merge_2pixel16 (tmp_val3, dpix_val);
            dpix_val = merge_2pixel16 (tmp_val, tmp_val2);
            spix++;
            }
            out_val = dpix_val;
            if (spritepixels[dpix].data) {
                sprcol = render_sprites (dpix + 0, 1, sprpix_val, 1);
                if (sprcol) {
                    out_val = colors_for_drawing.acolors[sprcol];
                }
            }
            buf[dpix++] = out_val;
        }
    } else if (bplehb) {
        while (dpix < dpix_end) {
            uae_u32 sprpix_val;
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            sprpix_val = pixdata.apixels[spix];
            spix_val = pixdata.apixels[spix] ^ xor_val;
            if (spix_val >= 32 && spix_val < 64) {
                unsigned int c = (colors_for_drawing.color_regs_aga[spix_val - 32] >> 1) & 0x7F7F7F;
                dpix_val = CONVERT_RGB (c);
            } else
                dpix_val = colors_for_drawing.acolors[spix_val];
            {
            uae_u32 tmp_val, tmp_val2, tmp_val3;
            spix++;
            tmp_val = dpix_val;
            sprpix_val = pixdata.apixels[spix];
            spix_val = pixdata.apixels[spix] ^ xor_val;
            if (spix_val >= 32 && spix_val < 64) {
                unsigned int c = (colors_for_drawing.color_regs_aga[spix_val - 32] >> 1) & 0x7F7F7F;
                dpix_val = CONVERT_RGB (c);
            } else
                dpix_val = colors_for_drawing.acolors[spix_val];
            spix++;
            tmp_val2 = dpix_val;
            sprpix_val = pixdata.apixels[spix];
            spix_val = pixdata.apixels[spix] ^ xor_val;
            if (spix_val >= 32 && spix_val < 64) {
                unsigned int c = (colors_for_drawing.color_regs_aga[spix_val - 32] >> 1) & 0x7F7F7F;
                dpix_val = CONVERT_RGB (c);
            } else
                dpix_val = colors_for_drawing.acolors[spix_val];
            spix++;
            tmp_val3 = dpix_val;
            sprpix_val = pixdata.apixels[spix];
            spix_val = pixdata.apixels[spix] ^ xor_val;
            if (spix_val >= 32 && spix_val < 64) {
                unsigned int c = (colors_for_drawing.color_regs_aga[spix_val - 32] >> 1) & 0x7F7F7F;
                dpix_val = CONVERT_RGB (c);
            } else
                dpix_val = colors_for_drawing.acolors[spix_val];
            tmp_val = merge_2pixel16 (tmp_val, tmp_val2);
            tmp_val2 = merge_2pixel16 (tmp_val3, dpix_val);
            dpix_val = merge_2pixel16 (tmp_val, tmp_val2);
            spix++;
            }
            out_val = dpix_val;
            if (spritepixels[dpix].data) {
                sprcol = render_sprites (dpix + 0, 0, sprpix_val, 1);
                if (sprcol) {
                    out_val = colors_for_drawing.acolors[sprcol];
                }
            }
            buf[dpix++] = out_val;
        }
    } else {
        while (dpix < dpix_end) {
            uae_u32 sprpix_val;
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            sprpix_val = pixdata.apixels[spix];
            spix_val = pixdata.apixels[spix] ^ xor_val;
            dpix_val = colors_for_drawing.acolors[spix_val];
            {
            uae_u32 tmp_val, tmp_val2, tmp_val3;
            spix++;
            tmp_val = dpix_val;
            sprpix_val = pixdata.apixels[spix];
            spix_val = pixdata.apixels[spix] ^ xor_val;
            dpix_val = colors_for_drawing.acolors[spix_val];
            spix++;
            tmp_val2 = dpix_val;
            sprpix_val = pixdata.apixels[spix];
            spix_val = pixdata.apixels[spix] ^ xor_val;
            dpix_val = colors_for_drawing.acolors[spix_val];
            spix++;
            tmp_val3 = dpix_val;
            sprpix_val = pixdata.apixels[spix];
            spix_val = pixdata.apixels[spix] ^ xor_val;
            dpix_val = colors_for_drawing.acolors[spix_val];
            tmp_val = merge_2pixel16 (tmp_val, tmp_val2);
            tmp_val2 = merge_2pixel16 (tmp_val3, dpix_val);
            dpix_val = merge_2pixel16 (tmp_val, tmp_val2);
            spix++;
            }
            out_val = dpix_val;
            if (spritepixels[dpix].data) {
                sprcol = render_sprites (dpix + 0, 0, sprpix_val, 1);
                if (sprcol) {
                    out_val = colors_for_drawing.acolors[sprcol];
                }
            }
            buf[dpix++] = out_val;
        }
    }

    return spix;
}
#endif

#ifdef AGA
static int NOINLINE __attribute__((__unused__)) linetoscr_16_shrink2f_aga_spr_genlock(int spix, int dpix, int dpix_end)
{
    uae_u16 *buf = (uae_u16 *) xlinebuffer;
    uae_u8 *genlock_buf = xlinebuffer_genlock;
    uae_u8 sprcol;
    uae_u8 xor_val = bplxor;

    if (bplham) {
        while (dpix < dpix_end) {
            uae_u32 sprpix_val;
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            sprpix_val = pixdata.apixels[spix];
            spix_val = pixdata.apixels[spix] ^ xor_val;
            spix_val = ham_linebuf[spix];
            dpix_val = CONVERT_RGB (spix_val);
            {
            uae_u32 tmp_val, tmp_val2, tmp_val3;
            spix++;
            tmp_val = dpix_val;
            sprpix_val = pixdata.apixels[spix];
            spix_val = pixdata.apixels[spix] ^ xor_val;
            spix_val = ham_linebuf[spix];
            dpix_val = CONVERT_RGB (spix_val);
            spix++;
            tmp_val2 = dpix_val;
            sprpix_val = pixdata.apixels[spix];
            spix_val = pixdata.apixels[spix] ^ xor_val;
            spix_val = ham_linebuf[spix];
            dpix_val = CONVERT_RGB (spix_val);
            spix++;
            tmp_val3 = dpix_val;
            sprpix_val = pixdata.apixels[spix];
            spix_val = pixdata.apixels[spix] ^ xor_val;
            spix_val = ham_linebuf[spix];
            dpix_val = CONVERT_RGB (spix_val);
            tmp_val = merge_2pixel16 (tmp_val, tmp_val2);
            tmp_val2 = merge_2pixel16 (tmp_val3, dpix_val);
            dpix_val = merge_2pixel16 (tmp_val, tmp_val2);
            spix++;
            }
            out_val = dpix_val;
            genlock_buf[dpix] = get_genlock_transparency((spix_val >> 2) & 63);
            if (spritepixels[dpix].data) {
                sprcol = render_sprites (dpix + 0, 0, sprpix_val, 1);
                if (sprcol) {
                    out_val = colors_for_drawing.acolors[sprcol];
                    genlock_buf[dpix] = get_genlock_transparency(sprcol);
                }
            }
            buf[dpix++] = out_val;
        }
    } else if (bpldualpf) {
        int *lookup    = bpldualpfpri ? dblpf_ind2_aga : dblpf_ind1_aga;
        int *lookup_no = bpldualpfpri ? dblpf_2nd2     : dblpf_2nd1;
        while (dpix < dpix_end) {
            uae_u32 sprpix_val;
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix];
            sprpix_val = spix_val;
            {
                uae_u8 val = lookup[spix_val];
                if (lookup_no[spix_val])
                    val += dblpfofs[bpldualpf2of];
                val ^= xor_val;
                dpix_val = colors_for_drawing.acolors[val];
            }
            {
            uae_u32 tmp_val, tmp_val2, tmp_val3;
            spix++;
            tmp_val = dpix_val;
            spix_val = pixdata.apixels[spix];
            sprpix_val = spix_val;
            {
                uae_u8 val = lookup[spix_val];
                if (lookup_no[spix_val])
                    val += dblpfofs[bpldualpf2of];
                val ^= xor_val;
                dpix_val = colors_for_drawing.acolors[val];
            }
            spix++;
            tmp_val2 = dpix_val;
            spix_val = pixdata.apixels[spix];
            sprpix_val = spix_val;
            {
                uae_u8 val = lookup[spix_val];
                if (lookup_no[spix_val])
                    val += dblpfofs[bpldualpf2of];
                val ^= xor_val;
                dpix_val = colors_for_drawing.acolors[val];
            }
            spix++;
            tmp_val3 = dpix_val;
            spix_val = pixdata.apixels[spix];
            sprpix_val = spix_val;
            {
                uae_u8 val = lookup[spix_val];
                if (lookup_no[spix_val])
                    val += dblpfofs[bpldualpf2of];
                val ^= xor_val;
                dpix_val = colors_for_drawing.acolors[val];
            }
            tmp_val = merge_2pixel16 (tmp_val, tmp_val2);
            tmp_val2 = merge_2pixel16 (tmp_val3, dpix_val);
            dpix_val = merge_2pixel16 (tmp_val, tmp_val2);
            spix++;
            }
            out_val = dpix_val;
            genlock_buf[dpix] = get_genlock_transparency(lookup[spix_val]);
            if (spritepixels[dpix].data) {
                sprcol = render_sprites (dpix + 0, 1, sprpix_val, 1);
                if (sprcol) {
                    out_val = colors_for_drawing.acolors[sprcol];
                    genlock_buf[dpix] = get_genlock_transparency(sprcol);
                }
            }
            buf[dpix++] = out_val;
        }
    } else if (bplehb) {
        while (dpix < dpix_end) {
            uae_u32 sprpix_val;
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            sprpix_val = pixdata.apixels[spix];
            spix_val = pixdata.apixels[spix] ^ xor_val;
            if (spix_val >= 32 && spix_val < 64) {
                unsigned int c = (colors_for_drawing.color_regs_aga[spix_val - 32] >> 1) & 0x7F7F7F;
                dpix_val = CONVERT_RGB (c);
            } else
                dpix_val = colors_for_drawing.acolors[spix_val];
            {
            uae_u32 tmp_val, tmp_val2, tmp_val3;
            spix++;
            tmp_val = dpix_val;
            sprpix_val = pixdata.apixels[spix];
            spix_val = pixdata.apixels[spix] ^ xor_val;
            if (spix_val >= 32 && spix_val < 64) {
                unsigned int c = (colors_for_drawing.color_regs_aga[spix_val - 32] >> 1) & 0x7F7F7F;
                dpix_val = CONVERT_RGB (c);
            } else
                dpix_val = colors_for_drawing.acolors[spix_val];
            spix++;
            tmp_val2 = dpix_val;
            sprpix_val = pixdata.apixels[spix];
            spix_val = pixdata.apixels[spix] ^ xor_val;
            if (spix_val >= 32 && spix_val < 64) {
                unsigned int c = (colors_for_drawing.color_regs_aga[spix_val - 32] >> 1) & 0x7F7F7F;
                dpix_val = CONVERT_RGB (c);
            } else
                dpix_val = colors_for_drawing.acolors[spix_val];
            spix++;
            tmp_val3 = dpix_val;
            sprpix_val = pixdata.apixels[spix];
            spix_val = pixdata.apixels[spix] ^ xor_val;
            if (spix_val >= 32 && spix_val < 64) {
                unsigned int c = (colors_for_drawing.color_regs_aga[spix_val - 32] >> 1) & 0x7F7F7F;
                dpix_val = CONVERT_RGB (c);
            } else
                dpix_val = colors_for_drawing.acolors[spix_val];
            tmp_val = merge_2pixel16 (tmp_val, tmp_val2);
            tmp_val2 = merge_2pixel16 (tmp_val3, dpix_val);
            dpix_val = merge_2pixel16 (tmp_val, tmp_val2);
            spix++;
            }
            out_val = dpix_val;
            genlock_buf[dpix] = get_genlock_transparency(spix_val & 31);
            if (spritepixels[dpix].data) {
                sprcol = render_sprites (dpix + 0, 0, sprpix_val, 1);
                if (sprcol) {
                    out_val = colors_for_drawing.acolors[sprcol];
                    genlock_buf[dpix] = get_genlock_transparency(sprcol);
                }
            }
            buf[dpix++] = out_val;
        }
    } else {
        while (dpix < dpix_end) {
            uae_u32 sprpix_val;
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            sprpix_val = pixdata.apixels[spix];
            spix_val = pixdata.apixels[spix] ^ xor_val;
            dpix_val = colors_for_drawing.acolors[spix_val];
            {
            uae_u32 tmp_val, tmp_val2, tmp_val3;
            spix++;
            tmp_val = dpix_val;
            sprpix_val = pixdata.apixels[spix];
            spix_val = pixdata.apixels[spix] ^ xor_val;
            dpix_val = colors_for_drawing.acolors[spix_val];
            spix++;
            tmp_val2 = dpix_val;
            sprpix_val = pixdata.apixels[spix];
            spix_val = pixdata.apixels[spix] ^ xor_val;
            dpix_val = colors_for_drawing.acolors[spix_val];
            spix++;
            tmp_val3 = dpix_val;
            sprpix_val = pixdata.apixels[spix];
            spix_val = pixdata.apixels[spix] ^ xor_val;
            dpix_val = colors_for_drawing.acolors[spix_val];
            tmp_val = merge_2pixel16 (tmp_val, tmp_val2);
            tmp_val2 = merge_2pixel16 (tmp_val3, dpix_val);
            dpix_val = merge_2pixel16 (tmp_val, tmp_val2);
            spix++;
            }
            out_val = dpix_val;
            genlock_buf[dpix] = get_genlock_transparency(spix_val);
            if (spritepixels[dpix].data) {
                sprcol = render_sprites (dpix + 0, 0, sprpix_val, 1);
                if (sprcol) {
                    out_val = colors_for_drawing.acolors[sprcol];
                    genlock_buf[dpix] = get_genlock_transparency(sprcol);
                }
            }
            buf[dpix++] = out_val;
        }
    }

    return spix;
}
#endif

static int NOINLINE __attribute__((__unused__)) linetoscr_32(int spix, int dpix, int dpix_end)
{
    uae_u32 *buf = (uae_u32 *) xlinebuffer;

    if (bplham) {
        while (dpix < dpix_end) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = ham_linebuf[spix];
            dpix_val = xcolors[spix_val];
            spix++;
            out_val = dpix_val;
            buf[dpix++] = out_val;
        }
    } else if (bpldualpf) {
        int *lookup = bpldualpfpri ? dblpf_ind2 : dblpf_ind1;
        while (dpix < dpix_end) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix];
            dpix_val = colors_for_drawing.acolors[lookup[spix_val]];
            spix++;
            out_val = dpix_val;
            buf[dpix++] = out_val;
        }
    } else if (bplehb) {
        while (dpix < dpix_end) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix];
            if (spix_val <= 31)
                dpix_val = colors_for_drawing.acolors[spix_val];
            else
                dpix_val = xcolors[(colors_for_drawing.color_regs_ecs[spix_val - 32] >> 1) & 0x777];
            spix++;
            out_val = dpix_val;
            buf[dpix++] = out_val;
        }
    } else {
        while (dpix < dpix_end) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix];
            dpix_val = colors_for_drawing.acolors[spix_val];
            spix++;
            out_val = dpix_val;
            buf[dpix++] = out_val;
        }
    }

    return spix;
}

static int NOINLINE __attribute__((__unused__)) linetoscr_32_genlock(int spix, int dpix, int dpix_end)
{
    uae_u32 *buf = (uae_u32 *) xlinebuffer;
    uae_u8 *genlock_buf = xlinebuffer_genlock;

    if (bplham) {
        while (dpix < dpix_end) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = ham_linebuf[spix];
            dpix_val = xcolors[spix_val];
            spix++;
            out_val = dpix_val;
            genlock_buf[dpix] = get_genlock_transparency(spix_val & 15);
            buf[dpix++] = out_val;
        }
    } else if (bpldualpf) {
        int *lookup = bpldualpfpri ? dblpf_ind2 : dblpf_ind1;
        while (dpix < dpix_end) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix];
            dpix_val = colors_for_drawing.acolors[lookup[spix_val]];
            spix++;
            out_val = dpix_val;
            genlock_buf[dpix] = get_genlock_transparency(lookup[spix_val]);
            buf[dpix++] = out_val;
        }
    } else if (bplehb) {
        while (dpix < dpix_end) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix];
            if (spix_val <= 31)
                dpix_val = colors_for_drawing.acolors[spix_val];
            else
                dpix_val = xcolors[(colors_for_drawing.color_regs_ecs[spix_val - 32] >> 1) & 0x777];
            spix++;
            out_val = dpix_val;
            genlock_buf[dpix] = get_genlock_transparency(spix_val & 31);
            buf[dpix++] = out_val;
        }
    } else {
        while (dpix < dpix_end) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix];
            dpix_val = colors_for_drawing.acolors[spix_val];
            spix++;
            out_val = dpix_val;
            genlock_buf[dpix] = get_genlock_transparency(spix_val);
            buf[dpix++] = out_val;
        }
    }

    return spix;
}

static int NOINLINE __attribute__((__unused__)) linetoscr_32_stretch1(int spix, int dpix, int dpix_end)
{
    uae_u32 *buf = (uae_u32 *) xlinebuffer;

    if (bplham) {
        while (dpix < dpix_end) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = ham_linebuf[spix];
            dpix_val = xcolors[spix_val];
            spix++;
            out_val = dpix_val;
            buf[dpix++] = out_val;
            buf[dpix++] = out_val;
        }
    } else if (bpldualpf) {
        int *lookup = bpldualpfpri ? dblpf_ind2 : dblpf_ind1;
        while (dpix < dpix_end) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix];
            dpix_val = colors_for_drawing.acolors[lookup[spix_val]];
            spix++;
            out_val = dpix_val;
            buf[dpix++] = out_val;
            buf[dpix++] = out_val;
        }
    } else if (bplehb) {
        while (dpix < dpix_end) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix];
            if (spix_val <= 31)
                dpix_val = colors_for_drawing.acolors[spix_val];
            else
                dpix_val = xcolors[(colors_for_drawing.color_regs_ecs[spix_val - 32] >> 1) & 0x777];
            spix++;
            out_val = dpix_val;
            buf[dpix++] = out_val;
            buf[dpix++] = out_val;
        }
    } else {
        while (dpix < dpix_end) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix];
            dpix_val = colors_for_drawing.acolors[spix_val];
            spix++;
            out_val = dpix_val;
            buf[dpix++] = out_val;
            buf[dpix++] = out_val;
        }
    }

    return spix;
}

static int NOINLINE __attribute__((__unused__)) linetoscr_32_stretch1_genlock(int spix, int dpix, int dpix_end)
{
    uae_u32 *buf = (uae_u32 *) xlinebuffer;
    uae_u8 *genlock_buf = xlinebuffer_genlock;

    if (bplham) {
        while (dpix < dpix_end) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = ham_linebuf[spix];
            dpix_val = xcolors[spix_val];
            spix++;
            out_val = dpix_val;
            genlock_buf[dpix] = get_genlock_transparency(spix_val & 15);
            genlock_buf[dpix + 1] = get_genlock_transparency(spix_val & 15);
            buf[dpix++] = out_val;
            buf[dpix++] = out_val;
        }
    } else if (bpldualpf) {
        int *lookup = bpldualpfpri ? dblpf_ind2 : dblpf_ind1;
        while (dpix < dpix_end) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix];
            dpix_val = colors_for_drawing.acolors[lookup[spix_val]];
            spix++;
            out_val = dpix_val;
            genlock_buf[dpix] = get_genlock_transparency(lookup[spix_val]);
            genlock_buf[dpix + 1] = get_genlock_transparency(lookup[spix_val]);
            buf[dpix++] = out_val;
            buf[dpix++] = out_val;
        }
    } else if (bplehb) {
        while (dpix < dpix_end) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix];
            if (spix_val <= 31)
                dpix_val = colors_for_drawing.acolors[spix_val];
            else
                dpix_val = xcolors[(colors_for_drawing.color_regs_ecs[spix_val - 32] >> 1) & 0x777];
            spix++;
            out_val = dpix_val;
            genlock_buf[dpix] = get_genlock_transparency(spix_val & 31);
            genlock_buf[dpix + 1] = get_genlock_transparency(spix_val & 31);
            buf[dpix++] = out_val;
            buf[dpix++] = out_val;
        }
    } else {
        while (dpix < dpix_end) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix];
            dpix_val = colors_for_drawing.acolors[spix_val];
            spix++;
            out_val = dpix_val;
            genlock_buf[dpix] = get_genlock_transparency(spix_val);
            genlock_buf[dpix + 1] = get_genlock_transparency(spix_val);
            buf[dpix++] = out_val;
            buf[dpix++] = out_val;
        }
    }

    return spix;
}

static int NOINLINE __attribute__((__unused__)) linetoscr_32_stretch2(int spix, int dpix, int dpix_end)
{
    uae_u32 *buf = (uae_u32 *) xlinebuffer;

    if (bplham) {
        while (dpix < dpix_end) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = ham_linebuf[spix];
            dpix_val = xcolors[spix_val];
            spix++;
            out_val = dpix_val;
            buf[dpix++] = out_val;
            buf[dpix++] = out_val;
            buf[dpix++] = out_val;
            buf[dpix++] = out_val;
        }
    } else if (bpldualpf) {
        int *lookup = bpldualpfpri ? dblpf_ind2 : dblpf_ind1;
        while (dpix < dpix_end) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix];
            dpix_val = colors_for_drawing.acolors[lookup[spix_val]];
            spix++;
            out_val = dpix_val;
            buf[dpix++] = out_val;
            buf[dpix++] = out_val;
            buf[dpix++] = out_val;
            buf[dpix++] = out_val;
        }
    } else if (bplehb) {
        while (dpix < dpix_end) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix];
            if (spix_val <= 31)
                dpix_val = colors_for_drawing.acolors[spix_val];
            else
                dpix_val = xcolors[(colors_for_drawing.color_regs_ecs[spix_val - 32] >> 1) & 0x777];
            spix++;
            out_val = dpix_val;
            buf[dpix++] = out_val;
            buf[dpix++] = out_val;
            buf[dpix++] = out_val;
            buf[dpix++] = out_val;
        }
    } else {
        while (dpix < dpix_end) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix];
            dpix_val = colors_for_drawing.acolors[spix_val];
            spix++;
            out_val = dpix_val;
            buf[dpix++] = out_val;
            buf[dpix++] = out_val;
            buf[dpix++] = out_val;
            buf[dpix++] = out_val;
        }
    }

    return spix;
}

static int NOINLINE __attribute__((__unused__)) linetoscr_32_stretch2_genlock(int spix, int dpix, int dpix_end)
{
    uae_u32 *buf = (uae_u32 *) xlinebuffer;
    uae_u8 *genlock_buf = xlinebuffer_genlock;

    if (bplham) {
        while (dpix < dpix_end) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = ham_linebuf[spix];
            dpix_val = xcolors[spix_val];
            spix++;
            out_val = dpix_val;
            genlock_buf[dpix] = get_genlock_transparency(spix_val & 15);
            genlock_buf[dpix + 1] = get_genlock_transparency(spix_val & 15);
            genlock_buf[dpix + 2] = get_genlock_transparency(spix_val & 15);
            genlock_buf[dpix + 3] = get_genlock_transparency(spix_val & 15);
            buf[dpix++] = out_val;
            buf[dpix++] = out_val;
            buf[dpix++] = out_val;
            buf[dpix++] = out_val;
        }
    } else if (bpldualpf) {
        int *lookup = bpldualpfpri ? dblpf_ind2 : dblpf_ind1;
        while (dpix < dpix_end) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix];
            dpix_val = colors_for_drawing.acolors[lookup[spix_val]];
            spix++;
            out_val = dpix_val;
            genlock_buf[dpix] = get_genlock_transparency(lookup[spix_val]);
            genlock_buf[dpix + 1] = get_genlock_transparency(lookup[spix_val]);
            genlock_buf[dpix + 2] = get_genlock_transparency(lookup[spix_val]);
            genlock_buf[dpix + 3] = get_genlock_transparency(lookup[spix_val]);
            buf[dpix++] = out_val;
            buf[dpix++] = out_val;
            buf[dpix++] = out_val;
            buf[dpix++] = out_val;
        }
    } else if (bplehb) {
        while (dpix < dpix_end) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix];
            if (spix_val <= 31)
                dpix_val = colors_for_drawing.acolors[spix_val];
            else
                dpix_val = xcolors[(colors_for_drawing.color_regs_ecs[spix_val - 32] >> 1) & 0x777];
            spix++;
            out_val = dpix_val;
            genlock_buf[dpix] = get_genlock_transparency(spix_val & 31);
            genlock_buf[dpix + 1] = get_genlock_transparency(spix_val & 31);
            genlock_buf[dpix + 2] = get_genlock_transparency(spix_val & 31);
            genlock_buf[dpix + 3] = get_genlock_transparency(spix_val & 31);
            buf[dpix++] = out_val;
            buf[dpix++] = out_val;
            buf[dpix++] = out_val;
            buf[dpix++] = out_val;
        }
    } else {
        while (dpix < dpix_end) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix];
            dpix_val = colors_for_drawing.acolors[spix_val];
            spix++;
            out_val = dpix_val;
            genlock_buf[dpix] = get_genlock_transparency(spix_val);
            genlock_buf[dpix + 1] = get_genlock_transparency(spix_val);
            genlock_buf[dpix + 2] = get_genlock_transparency(spix_val);
            genlock_buf[dpix + 3] = get_genlock_transparency(spix_val);
            buf[dpix++] = out_val;
            buf[dpix++] = out_val;
            buf[dpix++] = out_val;
            buf[dpix++] = out_val;
        }
    }

    return spix;
}

static int NOINLINE __attribute__((__unused__)) linetoscr_32_shrink1(int spix, int dpix, int dpix_end)
{
    uae_u32 *buf = (uae_u32 *) xlinebuffer;

    if (bplham) {
        while (dpix < dpix_end) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = ham_linebuf[spix];
            dpix_val = xcolors[spix_val];
            spix += 2;
            out_val = dpix_val;
            buf[dpix++] = out_val;
        }
    } else if (bpldualpf) {
        int *lookup = bpldualpfpri ? dblpf_ind2 : dblpf_ind1;
        while (dpix < dpix_end) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix];
            dpix_val = colors_for_drawing.acolors[lookup[spix_val]];
            spix += 2;
            out_val = dpix_val;
            buf[dpix++] = out_val;
        }
    } else if (bplehb) {
        while (dpix < dpix_end) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix];
            if (spix_val <= 31)
                dpix_val = colors_for_drawing.acolors[spix_val];
            else
                dpix_val = xcolors[(colors_for_drawing.color_regs_ecs[spix_val - 32] >> 1) & 0x777];
            spix += 2;
            out_val = dpix_val;
            buf[dpix++] = out_val;
        }
    } else {
        while (dpix < dpix_end) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix];
            dpix_val = colors_for_drawing.acolors[spix_val];
            spix += 2;
            out_val = dpix_val;
            buf[dpix++] = out_val;
        }
    }

    return spix;
}

static int NOINLINE __attribute__((__unused__)) linetoscr_32_shrink1_genlock(int spix, int dpix, int dpix_end)
{
    uae_u32 *buf = (uae_u32 *) xlinebuffer;
    uae_u8 *genlock_buf = xlinebuffer_genlock;

    if (bplham) {
        while (dpix < dpix_end) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = ham_linebuf[spix];
            dpix_val = xcolors[spix_val];
            spix += 2;
            out_val = dpix_val;
            genlock_buf[dpix] = get_genlock_transparency(spix_val & 15);
            buf[dpix++] = out_val;
        }
    } else if (bpldualpf) {
        int *lookup = bpldualpfpri ? dblpf_ind2 : dblpf_ind1;
        while (dpix < dpix_end) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix];
            dpix_val = colors_for_drawing.acolors[lookup[spix_val]];
            spix += 2;
            out_val = dpix_val;
            genlock_buf[dpix] = get_genlock_transparency(lookup[spix_val]);
            buf[dpix++] = out_val;
        }
    } else if (bplehb) {
        while (dpix < dpix_end) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix];
            if (spix_val <= 31)
                dpix_val = colors_for_drawing.acolors[spix_val];
            else
                dpix_val = xcolors[(colors_for_drawing.color_regs_ecs[spix_val - 32] >> 1) & 0x777];
            spix += 2;
            out_val = dpix_val;
            genlock_buf[dpix] = get_genlock_transparency(spix_val & 31);
            buf[dpix++] = out_val;
        }
    } else {
        while (dpix < dpix_end) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix];
            dpix_val = colors_for_drawing.acolors[spix_val];
            spix += 2;
            out_val = dpix_val;
            genlock_buf[dpix] = get_genlock_transparency(spix_val);
            buf[dpix++] = out_val;
        }
    }

    return spix;
}

static int NOINLINE __attribute__((__unused__)) linetoscr_32_shrink1f(int spix, int dpix, int dpix_end)
{
    uae_u32 *buf = (uae_u32 *) xlinebuffer;

    if (bplham) {
        while (dpix < dpix_end) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = ham_linebuf[spix];
            dpix_val = xcolors[spix_val];
            {
            uae_u32 tmp_val;
            spix++;
            tmp_val = dpix_val;
            spix_val = ham_linebuf[spix];
            dpix_val = xcolors[spix_val];
            dpix_val = merge_2pixel32 (dpix_val, tmp_val);
            spix++;
            }
            out_val = dpix_val;
            buf[dpix++] = out_val;
        }
    } else if (bpldualpf) {
        int *lookup = bpldualpfpri ? dblpf_ind2 : dblpf_ind1;
        while (dpix < dpix_end) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix];
            dpix_val = colors_for_drawing.acolors[lookup[spix_val]];
            {
            uae_u32 tmp_val;
            spix++;
            tmp_val = dpix_val;
            spix_val = pixdata.apixels[spix];
            dpix_val = colors_for_drawing.acolors[lookup[spix_val]];
            dpix_val = merge_2pixel32 (dpix_val, tmp_val);
            spix++;
            }
            out_val = dpix_val;
            buf[dpix++] = out_val;
        }
    } else if (bplehb) {
        while (dpix < dpix_end) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix];
            if (spix_val <= 31)
                dpix_val = colors_for_drawing.acolors[spix_val];
            else
                dpix_val = xcolors[(colors_for_drawing.color_regs_ecs[spix_val - 32] >> 1) & 0x777];
            {
            uae_u32 tmp_val;
            spix++;
            tmp_val = dpix_val;
            spix_val = pixdata.apixels[spix];
            if (spix_val <= 31)
                dpix_val = colors_for_drawing.acolors[spix_val];
            else
                dpix_val = xcolors[(colors_for_drawing.color_regs_ecs[spix_val - 32] >> 1) & 0x777];
            dpix_val = merge_2pixel32 (dpix_val, tmp_val);
            spix++;
            }
            out_val = dpix_val;
            buf[dpix++] = out_val;
        }
    } else {
        while (dpix < dpix_end) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix];
            dpix_val = colors_for_drawing.acolors[spix_val];
            {
            uae_u32 tmp_val;
            spix++;
            tmp_val = dpix_val;
            spix_val = pixdata.apixels[spix];
            dpix_val = colors_for_drawing.acolors[spix_val];
            dpix_val = merge_2pixel32 (dpix_val, tmp_val);
            spix++;
            }
            out_val = dpix_val;
            buf[dpix++] = out_val;
        }
    }

    return spix;
}

static int NOINLINE __attribute__((__unused__)) linetoscr_32_shrink1f_genlock(int spix, int dpix, int dpix_end)
{
    uae_u32 *buf = (uae_u32 *) xlinebuffer;
    uae_u8 *genlock_buf = xlinebuffer_genlock;

    if (bplham) {
        while (dpix < dpix_end) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = ham_linebuf[spix];
            dpix_val = xcolors[spix_val];
            {
            uae_u32 tmp_val;
            spix++;
            tmp_val = dpix_val;
            spix_val = ham_linebuf[spix];
            dpix_val = xcolors[spix_val];
            dpix_val = merge_2pixel32 (dpix_val, tmp_val);
            spix++;
            }
            out_val = dpix_val;
            genlock_buf[dpix] = get_genlock_transparency(spix_val & 15);
            buf[dpix++] = out_val;
        }
    } else if (bpldualpf) {
        int *lookup = bpldualpfpri ? dblpf_ind2 : dblpf_ind1;
        while (dpix < dpix_end) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix];
            dpix_val = colors_for_drawing.acolors[lookup[spix_val]];
            {
            uae_u32 tmp_val;
            spix++;
            tmp_val = dpix_val;
            spix_val = pixdata.apixels[spix];
            dpix_val = colors_for_drawing.acolors[lookup[spix_val]];
            dpix_val = merge_2pixel32 (dpix_val, tmp_val);
            spix++;
            }
            out_val = dpix_val;
            genlock_buf[dpix] = get_genlock_transparency(lookup[spix_val]);
            buf[dpix++] = out_val;
        }
    } else if (bplehb) {
        while (dpix < dpix_end) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix];
            if (spix_val <= 31)
                dpix_val = colors_for_drawing.acolors[spix_val];
            else
                dpix_val = xcolors[(colors_for_drawing.color_regs_ecs[spix_val - 32] >> 1) & 0x777];
            {
            uae_u32 tmp_val;
            spix++;
            tmp_val = dpix_val;
            spix_val = pixdata.apixels[spix];
            if (spix_val <= 31)
                dpix_val = colors_for_drawing.acolors[spix_val];
            else
                dpix_val = xcolors[(colors_for_drawing.color_regs_ecs[spix_val - 32] >> 1) & 0x777];
            dpix_val = merge_2pixel32 (dpix_val, tmp_val);
            spix++;
            }
            out_val = dpix_val;
            genlock_buf[dpix] = get_genlock_transparency(spix_val & 31);
            buf[dpix++] = out_val;
        }
    } else {
        while (dpix < dpix_end) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix];
            dpix_val = colors_for_drawing.acolors[spix_val];
            {
            uae_u32 tmp_val;
            spix++;
            tmp_val = dpix_val;
            spix_val = pixdata.apixels[spix];
            dpix_val = colors_for_drawing.acolors[spix_val];
            dpix_val = merge_2pixel32 (dpix_val, tmp_val);
            spix++;
            }
            out_val = dpix_val;
            genlock_buf[dpix] = get_genlock_transparency(spix_val);
            buf[dpix++] = out_val;
        }
    }

    return spix;
}

static int NOINLINE __attribute__((__unused__)) linetoscr_32_shrink2(int spix, int dpix, int dpix_end)
{
    uae_u32 *buf = (uae_u32 *) xlinebuffer;

    if (bplham) {
        while (dpix < dpix_end) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = ham_linebuf[spix];
            dpix_val = xcolors[spix_val];
            spix += 4;
            out_val = dpix_val;
            buf[dpix++] = out_val;
        }
    } else if (bpldualpf) {
        int *lookup = bpldualpfpri ? dblpf_ind2 : dblpf_ind1;
        while (dpix < dpix_end) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix];
            dpix_val = colors_for_drawing.acolors[lookup[spix_val]];
            spix += 4;
            out_val = dpix_val;
            buf[dpix++] = out_val;
        }
    } else if (bplehb) {
        while (dpix < dpix_end) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix];
            if (spix_val <= 31)
                dpix_val = colors_for_drawing.acolors[spix_val];
            else
                dpix_val = xcolors[(colors_for_drawing.color_regs_ecs[spix_val - 32] >> 1) & 0x777];
            spix += 4;
            out_val = dpix_val;
            buf[dpix++] = out_val;
        }
    } else {
        while (dpix < dpix_end) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix];
            dpix_val = colors_for_drawing.acolors[spix_val];
            spix += 4;
            out_val = dpix_val;
            buf[dpix++] = out_val;
        }
    }

    return spix;
}

static int NOINLINE __attribute__((__unused__)) linetoscr_32_shrink2_genlock(int spix, int dpix, int dpix_end)
{
    uae_u32 *buf = (uae_u32 *) xlinebuffer;
    uae_u8 *genlock_buf = xlinebuffer_genlock;

    if (bplham) {
        while (dpix < dpix_end) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = ham_linebuf[spix];
            dpix_val = xcolors[spix_val];
            spix += 4;
            out_val = dpix_val;
            genlock_buf[dpix] = get_genlock_transparency(spix_val & 15);
            buf[dpix++] = out_val;
        }
    } else if (bpldualpf) {
        int *lookup = bpldualpfpri ? dblpf_ind2 : dblpf_ind1;
        while (dpix < dpix_end) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix];
            dpix_val = colors_for_drawing.acolors[lookup[spix_val]];
            spix += 4;
            out_val = dpix_val;
            genlock_buf[dpix] = get_genlock_transparency(lookup[spix_val]);
            buf[dpix++] = out_val;
        }
    } else if (bplehb) {
        while (dpix < dpix_end) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix];
            if (spix_val <= 31)
                dpix_val = colors_for_drawing.acolors[spix_val];
            else
                dpix_val = xcolors[(colors_for_drawing.color_regs_ecs[spix_val - 32] >> 1) & 0x777];
            spix += 4;
            out_val = dpix_val;
            genlock_buf[dpix] = get_genlock_transparency(spix_val & 31);
            buf[dpix++] = out_val;
        }
    } else {
        while (dpix < dpix_end) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix];
            dpix_val = colors_for_drawing.acolors[spix_val];
            spix += 4;
            out_val = dpix_val;
            genlock_buf[dpix] = get_genlock_transparency(spix_val);
            buf[dpix++] = out_val;
        }
    }

    return spix;
}

static int NOINLINE __attribute__((__unused__)) linetoscr_32_shrink2f(int spix, int dpix, int dpix_end)
{
    uae_u32 *buf = (uae_u32 *) xlinebuffer;

    if (bplham) {
        while (dpix < dpix_end) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = ham_linebuf[spix];
            dpix_val = xcolors[spix_val];
            {
            uae_u32 tmp_val, tmp_val2, tmp_val3;
            spix++;
            tmp_val = dpix_val;
            spix_val = ham_linebuf[spix];
            dpix_val = xcolors[spix_val];
            spix++;
            tmp_val2 = dpix_val;
            spix_val = ham_linebuf[spix];
            dpix_val = xcolors[spix_val];
            spix++;
            tmp_val3 = dpix_val;
            spix_val = ham_linebuf[spix];
            dpix_val = xcolors[spix_val];
            tmp_val = merge_2pixel32 (tmp_val, tmp_val2);
            tmp_val2 = merge_2pixel32 (tmp_val3, dpix_val);
            dpix_val = merge_2pixel32 (tmp_val, tmp_val2);
            spix++;
            }
            out_val = dpix_val;
            buf[dpix++] = out_val;
        }
    } else if (bpldualpf) {
        int *lookup = bpldualpfpri ? dblpf_ind2 : dblpf_ind1;
        while (dpix < dpix_end) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix];
            dpix_val = colors_for_drawing.acolors[lookup[spix_val]];
            {
            uae_u32 tmp_val, tmp_val2, tmp_val3;
            spix++;
            tmp_val = dpix_val;
            spix_val = pixdata.apixels[spix];
            dpix_val = colors_for_drawing.acolors[lookup[spix_val]];
            spix++;
            tmp_val2 = dpix_val;
            spix_val = pixdata.apixels[spix];
            dpix_val = colors_for_drawing.acolors[lookup[spix_val]];
            spix++;
            tmp_val3 = dpix_val;
            spix_val = pixdata.apixels[spix];
            dpix_val = colors_for_drawing.acolors[lookup[spix_val]];
            tmp_val = merge_2pixel32 (tmp_val, tmp_val2);
            tmp_val2 = merge_2pixel32 (tmp_val3, dpix_val);
            dpix_val = merge_2pixel32 (tmp_val, tmp_val2);
            spix++;
            }
            out_val = dpix_val;
            buf[dpix++] = out_val;
        }
    } else if (bplehb) {
        while (dpix < dpix_end) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix];
            if (spix_val <= 31)
                dpix_val = colors_for_drawing.acolors[spix_val];
            else
                dpix_val = xcolors[(colors_for_drawing.color_regs_ecs[spix_val - 32] >> 1) & 0x777];
            {
            uae_u32 tmp_val, tmp_val2, tmp_val3;
            spix++;
            tmp_val = dpix_val;
            spix_val = pixdata.apixels[spix];
            if (spix_val <= 31)
                dpix_val = colors_for_drawing.acolors[spix_val];
            else
                dpix_val = xcolors[(colors_for_drawing.color_regs_ecs[spix_val - 32] >> 1) & 0x777];
            spix++;
            tmp_val2 = dpix_val;
            spix_val = pixdata.apixels[spix];
            if (spix_val <= 31)
                dpix_val = colors_for_drawing.acolors[spix_val];
            else
                dpix_val = xcolors[(colors_for_drawing.color_regs_ecs[spix_val - 32] >> 1) & 0x777];
            spix++;
            tmp_val3 = dpix_val;
            spix_val = pixdata.apixels[spix];
            if (spix_val <= 31)
                dpix_val = colors_for_drawing.acolors[spix_val];
            else
                dpix_val = xcolors[(colors_for_drawing.color_regs_ecs[spix_val - 32] >> 1) & 0x777];
            tmp_val = merge_2pixel32 (tmp_val, tmp_val2);
            tmp_val2 = merge_2pixel32 (tmp_val3, dpix_val);
            dpix_val = merge_2pixel32 (tmp_val, tmp_val2);
            spix++;
            }
            out_val = dpix_val;
            buf[dpix++] = out_val;
        }
    } else {
        while (dpix < dpix_end) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix];
            dpix_val = colors_for_drawing.acolors[spix_val];
            {
            uae_u32 tmp_val, tmp_val2, tmp_val3;
            spix++;
            tmp_val = dpix_val;
            spix_val = pixdata.apixels[spix];
            dpix_val = colors_for_drawing.acolors[spix_val];
            spix++;
            tmp_val2 = dpix_val;
            spix_val = pixdata.apixels[spix];
            dpix_val = colors_for_drawing.acolors[spix_val];
            spix++;
            tmp_val3 = dpix_val;
            spix_val = pixdata.apixels[spix];
            dpix_val = colors_for_drawing.acolors[spix_val];
            tmp_val = merge_2pixel32 (tmp_val, tmp_val2);
            tmp_val2 = merge_2pixel32 (tmp_val3, dpix_val);
            dpix_val = merge_2pixel32 (tmp_val, tmp_val2);
            spix++;
            }
            out_val = dpix_val;
            buf[dpix++] = out_val;
        }
    }

    return spix;
}

static int NOINLINE __attribute__((__unused__)) linetoscr_32_shrink2f_genlock(int spix, int dpix, int dpix_end)
{
    uae_u32 *buf = (uae_u32 *) xlinebuffer;
    uae_u8 *genlock_buf = xlinebuffer_genlock;

    if (bplham) {
        while (dpix < dpix_end) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = ham_linebuf[spix];
            dpix_val = xcolors[spix_val];
            {
            uae_u32 tmp_val, tmp_val2, tmp_val3;
            spix++;
            tmp_val = dpix_val;
            spix_val = ham_linebuf[spix];
            dpix_val = xcolors[spix_val];
            spix++;
            tmp_val2 = dpix_val;
            spix_val = ham_linebuf[spix];
            dpix_val = xcolors[spix_val];
            spix++;
            tmp_val3 = dpix_val;
            spix_val = ham_linebuf[spix];
            dpix_val = xcolors[spix_val];
            tmp_val = merge_2pixel32 (tmp_val, tmp_val2);
            tmp_val2 = merge_2pixel32 (tmp_val3, dpix_val);
            dpix_val = merge_2pixel32 (tmp_val, tmp_val2);
            spix++;
            }
            out_val = dpix_val;
            genlock_buf[dpix] = get_genlock_transparency(spix_val & 15);
            buf[dpix++] = out_val;
        }
    } else if (bpldualpf) {
        int *lookup = bpldualpfpri ? dblpf_ind2 : dblpf_ind1;
        while (dpix < dpix_end) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix];
            dpix_val = colors_for_drawing.acolors[lookup[spix_val]];
            {
            uae_u32 tmp_val, tmp_val2, tmp_val3;
            spix++;
            tmp_val = dpix_val;
            spix_val = pixdata.apixels[spix];
            dpix_val = colors_for_drawing.acolors[lookup[spix_val]];
            spix++;
            tmp_val2 = dpix_val;
            spix_val = pixdata.apixels[spix];
            dpix_val = colors_for_drawing.acolors[lookup[spix_val]];
            spix++;
            tmp_val3 = dpix_val;
            spix_val = pixdata.apixels[spix];
            dpix_val = colors_for_drawing.acolors[lookup[spix_val]];
            tmp_val = merge_2pixel32 (tmp_val, tmp_val2);
            tmp_val2 = merge_2pixel32 (tmp_val3, dpix_val);
            dpix_val = merge_2pixel32 (tmp_val, tmp_val2);
            spix++;
            }
            out_val = dpix_val;
            genlock_buf[dpix] = get_genlock_transparency(lookup[spix_val]);
            buf[dpix++] = out_val;
        }
    } else if (bplehb) {
        while (dpix < dpix_end) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix];
            if (spix_val <= 31)
                dpix_val = colors_for_drawing.acolors[spix_val];
            else
                dpix_val = xcolors[(colors_for_drawing.color_regs_ecs[spix_val - 32] >> 1) & 0x777];
            {
            uae_u32 tmp_val, tmp_val2, tmp_val3;
            spix++;
            tmp_val = dpix_val;
            spix_val = pixdata.apixels[spix];
            if (spix_val <= 31)
                dpix_val = colors_for_drawing.acolors[spix_val];
            else
                dpix_val = xcolors[(colors_for_drawing.color_regs_ecs[spix_val - 32] >> 1) & 0x777];
            spix++;
            tmp_val2 = dpix_val;
            spix_val = pixdata.apixels[spix];
            if (spix_val <= 31)
                dpix_val = colors_for_drawing.acolors[spix_val];
            else
                dpix_val = xcolors[(colors_for_drawing.color_regs_ecs[spix_val - 32] >> 1) & 0x777];
            spix++;
            tmp_val3 = dpix_val;
            spix_val = pixdata.apixels[spix];
            if (spix_val <= 31)
                dpix_val = colors_for_drawing.acolors[spix_val];
            else
                dpix_val = xcolors[(colors_for_drawing.color_regs_ecs[spix_val - 32] >> 1) & 0x777];
            tmp_val = merge_2pixel32 (tmp_val, tmp_val2);
            tmp_val2 = merge_2pixel32 (tmp_val3, dpix_val);
            dpix_val = merge_2pixel32 (tmp_val, tmp_val2);
            spix++;
            }
            out_val = dpix_val;
            genlock_buf[dpix] = get_genlock_transparency(spix_val & 31);
            buf[dpix++] = out_val;
        }
    } else {
        while (dpix < dpix_end) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix];
            dpix_val = colors_for_drawing.acolors[spix_val];
            {
            uae_u32 tmp_val, tmp_val2, tmp_val3;
            spix++;
            tmp_val = dpix_val;
            spix_val = pixdata.apixels[spix];
            dpix_val = colors_for_drawing.acolors[spix_val];
            spix++;
            tmp_val2 = dpix_val;
            spix_val = pixdata.apixels[spix];
            dpix_val = colors_for_drawing.acolors[spix_val];
            spix++;
            tmp_val3 = dpix_val;
            spix_val = pixdata.apixels[spix];
            dpix_val = colors_for_drawing.acolors[spix_val];
            tmp_val = merge_2pixel32 (tmp_val, tmp_val2);
            tmp_val2 = merge_2pixel32 (tmp_val3, dpix_val);
            dpix_val = merge_2pixel32 (tmp_val, tmp_val2);
            spix++;
            }
            out_val = dpix_val;
            genlock_buf[dpix] = get_genlock_transparency(spix_val);
            buf[dpix++] = out_val;
        }
    }

    return spix;
}

static int NOINLINE __attribute__((__unused__)) linetoscr_32_spr(int spix, int dpix, int dpix_end)
{
    uae_u32 *buf = (uae_u32 *) xlinebuffer;
    uae_u8 sprcol;

    if (bplham) {
        while (dpix < dpix_end) {
            uae_u32 sprpix_val;
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = ham_linebuf[spix];
            dpix_val = xcolors[spix_val];
            sprpix_val = pixdata.apixels[spix];
            spix++;
            out_val = dpix_val;
            if (spritepixels[dpix].data) {
                sprcol = render_sprites (dpix, 0, sprpix_val, 0);
                if (sprcol) {
                    uae_u32 spcol = colors_for_drawing.acolors[sprcol];
                    out_val = spcol;
                }
            }
            buf[dpix++] = out_val;
        }
    } else if (bpldualpf) {
        int *lookup = bpldualpfpri ? dblpf_ind2 : dblpf_ind1;
        while (dpix < dpix_end) {
            uae_u32 sprpix_val;
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix];
            sprpix_val = spix_val;
            dpix_val = colors_for_drawing.acolors[lookup[spix_val]];
            spix++;
            out_val = dpix_val;
            if (spritepixels[dpix].data) {
                sprcol = render_sprites (dpix, 1, sprpix_val, 0);
                if (sprcol) {
                    uae_u32 spcol = colors_for_drawing.acolors[sprcol];
                    out_val = spcol;
                }
            }
            buf[dpix++] = out_val;
        }
    } else if (bplehb) {
        while (dpix < dpix_end) {
            uae_u32 sprpix_val;
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix];
            sprpix_val = spix_val;
            if (spix_val <= 31)
                dpix_val = colors_for_drawing.acolors[spix_val];
            else
                dpix_val = xcolors[(colors_for_drawing.color_regs_ecs[spix_val - 32] >> 1) & 0x777];
            spix++;
            out_val = dpix_val;
            if (spritepixels[dpix].data) {
                sprcol = render_sprites (dpix, 0, sprpix_val, 0);
                if (sprcol) {
                    uae_u32 spcol = colors_for_drawing.acolors[sprcol];
                    out_val = spcol;
                }
            }
            buf[dpix++] = out_val;
        }
    } else {
        while (dpix < dpix_end) {
            uae_u32 sprpix_val;
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix];
            sprpix_val = spix_val;
            dpix_val = colors_for_drawing.acolors[spix_val];
            spix++;
            out_val = dpix_val;
            if (spritepixels[dpix].data) {
                sprcol = render_sprites (dpix, 0, sprpix_val, 0);
                if (sprcol) {
                    uae_u32 spcol = colors_for_drawing.acolors[sprcol];
                    out_val = spcol;
                }
            }
            buf[dpix++] = out_val;
        }
    }

    return spix;
}

static int NOINLINE __attribute__((__unused__)) linetoscr_32_spr_genlock(int spix, int dpix, int dpix_end)
{
    uae_u32 *buf = (uae_u32 *) xlinebuffer;
    uae_u8 *genlock_buf = xlinebuffer_genlock;
    uae_u8 sprcol;

    if (bplham) {
        while (dpix < dpix_end) {
            uae_u32 sprpix_val;
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = ham_linebuf[spix];
            dpix_val = xcolors[spix_val];
            sprpix_val = pixdata.apixels[spix];
            spix++;
            out_val = dpix_val;
            genlock_buf[dpix] = get_genlock_transparency(spix_val & 15);
            if (spritepixels[dpix].data) {
                sprcol = render_sprites (dpix, 0, sprpix_val, 0);
                    genlock_buf[dpix] = get_genlock_transparency(sprcol);
                if (sprcol) {
                    uae_u32 spcol = colors_for_drawing.acolors[sprcol];
                    out_val = spcol;
                }
            }
            buf[dpix++] = out_val;
        }
    } else if (bpldualpf) {
        int *lookup = bpldualpfpri ? dblpf_ind2 : dblpf_ind1;
        while (dpix < dpix_end) {
            uae_u32 sprpix_val;
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix];
            sprpix_val = spix_val;
            dpix_val = colors_for_drawing.acolors[lookup[spix_val]];
            spix++;
            out_val = dpix_val;
            genlock_buf[dpix] = get_genlock_transparency(lookup[spix_val]);
            if (spritepixels[dpix].data) {
                sprcol = render_sprites (dpix, 1, sprpix_val, 0);
                    genlock_buf[dpix] = get_genlock_transparency(sprcol);
                if (sprcol) {
                    uae_u32 spcol = colors_for_drawing.acolors[sprcol];
                    out_val = spcol;
                }
            }
            buf[dpix++] = out_val;
        }
    } else if (bplehb) {
        while (dpix < dpix_end) {
            uae_u32 sprpix_val;
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix];
            sprpix_val = spix_val;
            if (spix_val <= 31)
                dpix_val = colors_for_drawing.acolors[spix_val];
            else
                dpix_val = xcolors[(colors_for_drawing.color_regs_ecs[spix_val - 32] >> 1) & 0x777];
            spix++;
            out_val = dpix_val;
            genlock_buf[dpix] = get_genlock_transparency(spix_val & 31);
            if (spritepixels[dpix].data) {
                sprcol = render_sprites (dpix, 0, sprpix_val, 0);
                    genlock_buf[dpix] = get_genlock_transparency(sprcol);
                if (sprcol) {
                    uae_u32 spcol = colors_for_drawing.acolors[sprcol];
                    out_val = spcol;
                }
            }
            buf[dpix++] = out_val;
        }
    } else {
        while (dpix < dpix_end) {
            uae_u32 sprpix_val;
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix];
            sprpix_val = spix_val;
            dpix_val = colors_for_drawing.acolors[spix_val];
            spix++;
            out_val = dpix_val;
            genlock_buf[dpix] = get_genlock_transparency(spix_val);
            if (spritepixels[dpix].data) {
                sprcol = render_sprites (dpix, 0, sprpix_val, 0);
                    genlock_buf[dpix] = get_genlock_transparency(sprcol);
                if (sprcol) {
                    uae_u32 spcol = colors_for_drawing.acolors[sprcol];
                    out_val = spcol;
                }
            }
            buf[dpix++] = out_val;
        }
    }

    return spix;
}

static int NOINLINE __attribute__((__unused__)) linetoscr_32_stretch1_spr(int spix, int dpix, int dpix_end)
{
    uae_u32 *buf = (uae_u32 *) xlinebuffer;
    uae_u8 sprcol;

    if (bplham) {
        while (dpix < dpix_end) {
            uae_u32 sprpix_val;
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = ham_linebuf[spix];
            dpix_val = xcolors[spix_val];
            sprpix_val = pixdata.apixels[spix];
            spix++;
            out_val = dpix_val;
            if (spritepixels[dpix].data) {
                sprcol = render_sprites (dpix, 0, sprpix_val, 0);
                if (sprcol) {
                    uae_u32 spcol = colors_for_drawing.acolors[sprcol];
                    out_val = spcol;
                }
            }
            buf[dpix++] = out_val;
            buf[dpix++] = out_val;
        }
    } else if (bpldualpf) {
        int *lookup = bpldualpfpri ? dblpf_ind2 : dblpf_ind1;
        while (dpix < dpix_end) {
            uae_u32 sprpix_val;
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix];
            sprpix_val = spix_val;
            dpix_val = colors_for_drawing.acolors[lookup[spix_val]];
            spix++;
            out_val = dpix_val;
            if (spritepixels[dpix].data) {
                sprcol = render_sprites (dpix, 1, sprpix_val, 0);
                if (sprcol) {
                    uae_u32 spcol = colors_for_drawing.acolors[sprcol];
                    out_val = spcol;
                }
            }
            buf[dpix++] = out_val;
            buf[dpix++] = out_val;
        }
    } else if (bplehb) {
        while (dpix < dpix_end) {
            uae_u32 sprpix_val;
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix];
            sprpix_val = spix_val;
            if (spix_val <= 31)
                dpix_val = colors_for_drawing.acolors[spix_val];
            else
                dpix_val = xcolors[(colors_for_drawing.color_regs_ecs[spix_val - 32] >> 1) & 0x777];
            spix++;
            out_val = dpix_val;
            if (spritepixels[dpix].data) {
                sprcol = render_sprites (dpix, 0, sprpix_val, 0);
                if (sprcol) {
                    uae_u32 spcol = colors_for_drawing.acolors[sprcol];
                    out_val = spcol;
                }
            }
            buf[dpix++] = out_val;
            buf[dpix++] = out_val;
        }
    } else {
        while (dpix < dpix_end) {
            uae_u32 sprpix_val;
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix];
            sprpix_val = spix_val;
            dpix_val = colors_for_drawing.acolors[spix_val];
            spix++;
            out_val = dpix_val;
            if (spritepixels[dpix].data) {
                sprcol = render_sprites (dpix, 0, sprpix_val, 0);
                if (sprcol) {
                    uae_u32 spcol = colors_for_drawing.acolors[sprcol];
                    out_val = spcol;
                }
            }
            buf[dpix++] = out_val;
            buf[dpix++] = out_val;
        }
    }

    return spix;
}

static int NOINLINE __attribute__((__unused__)) linetoscr_32_stretch1_spr_genlock(int spix, int dpix, int dpix_end)
{
    uae_u32 *buf = (uae_u32 *) xlinebuffer;
    uae_u8 *genlock_buf = xlinebuffer_genlock;
    uae_u8 sprcol;

    if (bplham) {
        while (dpix < dpix_end) {
            uae_u32 sprpix_val;
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = ham_linebuf[spix];
            dpix_val = xcolors[spix_val];
            sprpix_val = pixdata.apixels[spix];
            spix++;
            out_val = dpix_val;
            genlock_buf[dpix] = get_genlock_transparency(spix_val & 15);
            genlock_buf[dpix + 1] = get_genlock_transparency(spix_val & 15);
            if (spritepixels[dpix].data) {
                sprcol = render_sprites (dpix, 0, sprpix_val, 0);
                    genlock_buf[dpix] = get_genlock_transparency(sprcol);
                if (sprcol) {
                    uae_u32 spcol = colors_for_drawing.acolors[sprcol];
                    out_val = spcol;
                }
            }
            buf[dpix++] = out_val;
            buf[dpix++] = out_val;
        }
    } else if (bpldualpf) {
        int *lookup = bpldualpfpri ? dblpf_ind2 : dblpf_ind1;
        while (dpix < dpix_end) {
            uae_u32 sprpix_val;
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix];
            sprpix_val = spix_val;
            dpix_val = colors_for_drawing.acolors[lookup[spix_val]];
            spix++;
            out_val = dpix_val;
            genlock_buf[dpix] = get_genlock_transparency(lookup[spix_val]);
            genlock_buf[dpix + 1] = get_genlock_transparency(lookup[spix_val]);
            if (spritepixels[dpix].data) {
                sprcol = render_sprites (dpix, 1, sprpix_val, 0);
                    genlock_buf[dpix] = get_genlock_transparency(sprcol);
                if (sprcol) {
                    uae_u32 spcol = colors_for_drawing.acolors[sprcol];
                    out_val = spcol;
                }
            }
            buf[dpix++] = out_val;
            buf[dpix++] = out_val;
        }
    } else if (bplehb) {
        while (dpix < dpix_end) {
            uae_u32 sprpix_val;
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix];
            sprpix_val = spix_val;
            if (spix_val <= 31)
                dpix_val = colors_for_drawing.acolors[spix_val];
            else
                dpix_val = xcolors[(colors_for_drawing.color_regs_ecs[spix_val - 32] >> 1) & 0x777];
            spix++;
            out_val = dpix_val;
            genlock_buf[dpix] = get_genlock_transparency(spix_val & 31);
            genlock_buf[dpix + 1] = get_genlock_transparency(spix_val & 31);
            if (spritepixels[dpix].data) {
                sprcol = render_sprites (dpix, 0, sprpix_val, 0);
                    genlock_buf[dpix] = get_genlock_transparency(sprcol);
                if (sprcol) {
                    uae_u32 spcol = colors_for_drawing.acolors[sprcol];
                    out_val = spcol;
                }
            }
            buf[dpix++] = out_val;
            buf[dpix++] = out_val;
        }
    } else {
        while (dpix < dpix_end) {
            uae_u32 sprpix_val;
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix];
            sprpix_val = spix_val;
            dpix_val = colors_for_drawing.acolors[spix_val];
            spix++;
            out_val = dpix_val;
            genlock_buf[dpix] = get_genlock_transparency(spix_val);
            genlock_buf[dpix + 1] = get_genlock_transparency(spix_val);
            if (spritepixels[dpix].data) {
                sprcol = render_sprites (dpix, 0, sprpix_val, 0);
                    genlock_buf[dpix] = get_genlock_transparency(sprcol);
                if (sprcol) {
                    uae_u32 spcol = colors_for_drawing.acolors[sprcol];
                    out_val = spcol;
                }
            }
            buf[dpix++] = out_val;
            buf[dpix++] = out_val;
        }
    }

    return spix;
}

static int NOINLINE __attribute__((__unused__)) linetoscr_32_stretch2_spr(int spix, int dpix, int dpix_end)
{
    uae_u32 *buf = (uae_u32 *) xlinebuffer;
    uae_u8 sprcol;

    if (bplham) {
        while (dpix < dpix_end) {
            uae_u32 sprpix_val;
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = ham_linebuf[spix];
            dpix_val = xcolors[spix_val];
            sprpix_val = pixdata.apixels[spix];
            spix++;
            out_val = dpix_val;
            if (spritepixels[dpix].data) {
                sprcol = render_sprites (dpix, 0, sprpix_val, 0);
                if (sprcol) {
                    uae_u32 spcol = colors_for_drawing.acolors[sprcol];
                    out_val = spcol;
                }
            }
            buf[dpix++] = out_val;
            buf[dpix++] = out_val;
            buf[dpix++] = out_val;
            buf[dpix++] = out_val;
        }
    } else if (bpldualpf) {
        int *lookup = bpldualpfpri ? dblpf_ind2 : dblpf_ind1;
        while (dpix < dpix_end) {
            uae_u32 sprpix_val;
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix];
            sprpix_val = spix_val;
            dpix_val = colors_for_drawing.acolors[lookup[spix_val]];
            spix++;
            out_val = dpix_val;
            if (spritepixels[dpix].data) {
                sprcol = render_sprites (dpix, 1, sprpix_val, 0);
                if (sprcol) {
                    uae_u32 spcol = colors_for_drawing.acolors[sprcol];
                    out_val = spcol;
                }
            }
            buf[dpix++] = out_val;
            buf[dpix++] = out_val;
            buf[dpix++] = out_val;
            buf[dpix++] = out_val;
        }
    } else if (bplehb) {
        while (dpix < dpix_end) {
            uae_u32 sprpix_val;
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix];
            sprpix_val = spix_val;
            if (spix_val <= 31)
                dpix_val = colors_for_drawing.acolors[spix_val];
            else
                dpix_val = xcolors[(colors_for_drawing.color_regs_ecs[spix_val - 32] >> 1) & 0x777];
            spix++;
            out_val = dpix_val;
            if (spritepixels[dpix].data) {
                sprcol = render_sprites (dpix, 0, sprpix_val, 0);
                if (sprcol) {
                    uae_u32 spcol = colors_for_drawing.acolors[sprcol];
                    out_val = spcol;
                }
            }
            buf[dpix++] = out_val;
            buf[dpix++] = out_val;
            buf[dpix++] = out_val;
            buf[dpix++] = out_val;
        }
    } else {
        while (dpix < dpix_end) {
            uae_u32 sprpix_val;
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix];
            sprpix_val = spix_val;
            dpix_val = colors_for_drawing.acolors[spix_val];
            spix++;
            out_val = dpix_val;
            if (spritepixels[dpix].data) {
                sprcol = render_sprites (dpix, 0, sprpix_val, 0);
                if (sprcol) {
                    uae_u32 spcol = colors_for_drawing.acolors[sprcol];
                    out_val = spcol;
                }
            }
            buf[dpix++] = out_val;
            buf[dpix++] = out_val;
            buf[dpix++] = out_val;
            buf[dpix++] = out_val;
        }
    }

    return spix;
}

static int NOINLINE __attribute__((__unused__)) linetoscr_32_stretch2_spr_genlock(int spix, int dpix, int dpix_end)
{
    uae_u32 *buf = (uae_u32 *) xlinebuffer;
    uae_u8 *genlock_buf = xlinebuffer_genlock;
    uae_u8 sprcol;

    if (bplham) {
        while (dpix < dpix_end) {
            uae_u32 sprpix_val;
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = ham_linebuf[spix];
            dpix_val = xcolors[spix_val];
            sprpix_val = pixdata.apixels[spix];
            spix++;
            out_val = dpix_val;
            genlock_buf[dpix] = get_genlock_transparency(spix_val & 15);
            genlock_buf[dpix + 1] = get_genlock_transparency(spix_val & 15);
            genlock_buf[dpix + 2] = get_genlock_transparency(spix_val & 15);
            genlock_buf[dpix + 3] = get_genlock_transparency(spix_val & 15);
            if (spritepixels[dpix].data) {
                sprcol = render_sprites (dpix, 0, sprpix_val, 0);
                    genlock_buf[dpix] = get_genlock_transparency(sprcol);
                if (sprcol) {
                    uae_u32 spcol = colors_for_drawing.acolors[sprcol];
                    out_val = spcol;
                }
            }
            buf[dpix++] = out_val;
            buf[dpix++] = out_val;
            buf[dpix++] = out_val;
            buf[dpix++] = out_val;
        }
    } else if (bpldualpf) {
        int *lookup = bpldualpfpri ? dblpf_ind2 : dblpf_ind1;
        while (dpix < dpix_end) {
            uae_u32 sprpix_val;
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix];
            sprpix_val = spix_val;
            dpix_val = colors_for_drawing.acolors[lookup[spix_val]];
            spix++;
            out_val = dpix_val;
            genlock_buf[dpix] = get_genlock_transparency(lookup[spix_val]);
            genlock_buf[dpix + 1] = get_genlock_transparency(lookup[spix_val]);
            genlock_buf[dpix + 2] = get_genlock_transparency(lookup[spix_val]);
            genlock_buf[dpix + 3] = get_genlock_transparency(lookup[spix_val]);
            if (spritepixels[dpix].data) {
                sprcol = render_sprites (dpix, 1, sprpix_val, 0);
                    genlock_buf[dpix] = get_genlock_transparency(sprcol);
                if (sprcol) {
                    uae_u32 spcol = colors_for_drawing.acolors[sprcol];
                    out_val = spcol;
                }
            }
            buf[dpix++] = out_val;
            buf[dpix++] = out_val;
            buf[dpix++] = out_val;
            buf[dpix++] = out_val;
        }
    } else if (bplehb) {
        while (dpix < dpix_end) {
            uae_u32 sprpix_val;
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix];
            sprpix_val = spix_val;
            if (spix_val <= 31)
                dpix_val = colors_for_drawing.acolors[spix_val];
            else
                dpix_val = xcolors[(colors_for_drawing.color_regs_ecs[spix_val - 32] >> 1) & 0x777];
            spix++;
            out_val = dpix_val;
            genlock_buf[dpix] = get_genlock_transparency(spix_val & 31);
            genlock_buf[dpix + 1] = get_genlock_transparency(spix_val & 31);
            genlock_buf[dpix + 2] = get_genlock_transparency(spix_val & 31);
            genlock_buf[dpix + 3] = get_genlock_transparency(spix_val & 31);
            if (spritepixels[dpix].data) {
                sprcol = render_sprites (dpix, 0, sprpix_val, 0);
                    genlock_buf[dpix] = get_genlock_transparency(sprcol);
                if (sprcol) {
                    uae_u32 spcol = colors_for_drawing.acolors[sprcol];
                    out_val = spcol;
                }
            }
            buf[dpix++] = out_val;
            buf[dpix++] = out_val;
            buf[dpix++] = out_val;
            buf[dpix++] = out_val;
        }
    } else {
        while (dpix < dpix_end) {
            uae_u32 sprpix_val;
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix];
            sprpix_val = spix_val;
            dpix_val = colors_for_drawing.acolors[spix_val];
            spix++;
            out_val = dpix_val;
            genlock_buf[dpix] = get_genlock_transparency(spix_val);
            genlock_buf[dpix + 1] = get_genlock_transparency(spix_val);
            genlock_buf[dpix + 2] = get_genlock_transparency(spix_val);
            genlock_buf[dpix + 3] = get_genlock_transparency(spix_val);
            if (spritepixels[dpix].data) {
                sprcol = render_sprites (dpix, 0, sprpix_val, 0);
                    genlock_buf[dpix] = get_genlock_transparency(sprcol);
                if (sprcol) {
                    uae_u32 spcol = colors_for_drawing.acolors[sprcol];
                    out_val = spcol;
                }
            }
            buf[dpix++] = out_val;
            buf[dpix++] = out_val;
            buf[dpix++] = out_val;
            buf[dpix++] = out_val;
        }
    }

    return spix;
}

static int NOINLINE __attribute__((__unused__)) linetoscr_32_shrink1_spr(int spix, int dpix, int dpix_end)
{
    uae_u32 *buf = (uae_u32 *) xlinebuffer;
    uae_u8 sprcol;

    if (bplham) {
        while (dpix < dpix_end) {
            uae_u32 sprpix_val;
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = ham_linebuf[spix];
            dpix_val = xcolors[spix_val];
            sprpix_val = pixdata.apixels[spix];
            spix += 2;
            out_val = dpix_val;
            if (spritepixels[dpix].data) {
                sprcol = render_sprites (dpix, 0, sprpix_val, 0);
                if (sprcol) {
                    uae_u32 spcol = colors_for_drawing.acolors[sprcol];
                    out_val = spcol;
                }
            }
            buf[dpix++] = out_val;
        }
    } else if (bpldualpf) {
        int *lookup = bpldualpfpri ? dblpf_ind2 : dblpf_ind1;
        while (dpix < dpix_end) {
            uae_u32 sprpix_val;
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix];
            sprpix_val = spix_val;
            dpix_val = colors_for_drawing.acolors[lookup[spix_val]];
            spix += 2;
            out_val = dpix_val;
            if (spritepixels[dpix].data) {
                sprcol = render_sprites (dpix, 1, sprpix_val, 0);
                if (sprcol) {
                    uae_u32 spcol = colors_for_drawing.acolors[sprcol];
                    out_val = spcol;
                }
            }
            buf[dpix++] = out_val;
        }
    } else if (bplehb) {
        while (dpix < dpix_end) {
            uae_u32 sprpix_val;
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix];
            sprpix_val = spix_val;
            if (spix_val <= 31)
                dpix_val = colors_for_drawing.acolors[spix_val];
            else
                dpix_val = xcolors[(colors_for_drawing.color_regs_ecs[spix_val - 32] >> 1) & 0x777];
            spix += 2;
            out_val = dpix_val;
            if (spritepixels[dpix].data) {
                sprcol = render_sprites (dpix, 0, sprpix_val, 0);
                if (sprcol) {
                    uae_u32 spcol = colors_for_drawing.acolors[sprcol];
                    out_val = spcol;
                }
            }
            buf[dpix++] = out_val;
        }
    } else {
        while (dpix < dpix_end) {
            uae_u32 sprpix_val;
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix];
            sprpix_val = spix_val;
            dpix_val = colors_for_drawing.acolors[spix_val];
            spix += 2;
            out_val = dpix_val;
            if (spritepixels[dpix].data) {
                sprcol = render_sprites (dpix, 0, sprpix_val, 0);
                if (sprcol) {
                    uae_u32 spcol = colors_for_drawing.acolors[sprcol];
                    out_val = spcol;
                }
            }
            buf[dpix++] = out_val;
        }
    }

    return spix;
}

static int NOINLINE __attribute__((__unused__)) linetoscr_32_shrink1_spr_genlock(int spix, int dpix, int dpix_end)
{
    uae_u32 *buf = (uae_u32 *) xlinebuffer;
    uae_u8 *genlock_buf = xlinebuffer_genlock;
    uae_u8 sprcol;

    if (bplham) {
        while (dpix < dpix_end) {
            uae_u32 sprpix_val;
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = ham_linebuf[spix];
            dpix_val = xcolors[spix_val];
            sprpix_val = pixdata.apixels[spix];
            spix += 2;
            out_val = dpix_val;
            genlock_buf[dpix] = get_genlock_transparency(spix_val & 15);
            if (spritepixels[dpix].data) {
                sprcol = render_sprites (dpix, 0, sprpix_val, 0);
                    genlock_buf[dpix] = get_genlock_transparency(sprcol);
                if (sprcol) {
                    uae_u32 spcol = colors_for_drawing.acolors[sprcol];
                    out_val = spcol;
                }
            }
            buf[dpix++] = out_val;
        }
    } else if (bpldualpf) {
        int *lookup = bpldualpfpri ? dblpf_ind2 : dblpf_ind1;
        while (dpix < dpix_end) {
            uae_u32 sprpix_val;
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix];
            sprpix_val = spix_val;
            dpix_val = colors_for_drawing.acolors[lookup[spix_val]];
            spix += 2;
            out_val = dpix_val;
            genlock_buf[dpix] = get_genlock_transparency(lookup[spix_val]);
            if (spritepixels[dpix].data) {
                sprcol = render_sprites (dpix, 1, sprpix_val, 0);
                    genlock_buf[dpix] = get_genlock_transparency(sprcol);
                if (sprcol) {
                    uae_u32 spcol = colors_for_drawing.acolors[sprcol];
                    out_val = spcol;
                }
            }
            buf[dpix++] = out_val;
        }
    } else if (bplehb) {
        while (dpix < dpix_end) {
            uae_u32 sprpix_val;
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix];
            sprpix_val = spix_val;
            if (spix_val <= 31)
                dpix_val = colors_for_drawing.acolors[spix_val];
            else
                dpix_val = xcolors[(colors_for_drawing.color_regs_ecs[spix_val - 32] >> 1) & 0x777];
            spix += 2;
            out_val = dpix_val;
            genlock_buf[dpix] = get_genlock_transparency(spix_val & 31);
            if (spritepixels[dpix].data) {
                sprcol = render_sprites (dpix, 0, sprpix_val, 0);
                    genlock_buf[dpix] = get_genlock_transparency(sprcol);
                if (sprcol) {
                    uae_u32 spcol = colors_for_drawing.acolors[sprcol];
                    out_val = spcol;
                }
            }
            buf[dpix++] = out_val;
        }
    } else {
        while (dpix < dpix_end) {
            uae_u32 sprpix_val;
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix];
            sprpix_val = spix_val;
            dpix_val = colors_for_drawing.acolors[spix_val];
            spix += 2;
            out_val = dpix_val;
            genlock_buf[dpix] = get_genlock_transparency(spix_val);
            if (spritepixels[dpix].data) {
                sprcol = render_sprites (dpix, 0, sprpix_val, 0);
                    genlock_buf[dpix] = get_genlock_transparency(sprcol);
                if (sprcol) {
                    uae_u32 spcol = colors_for_drawing.acolors[sprcol];
                    out_val = spcol;
                }
            }
            buf[dpix++] = out_val;
        }
    }

    return spix;
}

static int NOINLINE __attribute__((__unused__)) linetoscr_32_shrink1f_spr(int spix, int dpix, int dpix_end)
{
    uae_u32 *buf = (uae_u32 *) xlinebuffer;
    uae_u8 sprcol;

    if (bplham) {
        while (dpix < dpix_end) {
            uae_u32 sprpix_val;
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = ham_linebuf[spix];
            dpix_val = xcolors[spix_val];
            sprpix_val = pixdata.apixels[spix];
            {
            uae_u32 tmp_val;
            spix++;
            tmp_val = dpix_val;
            spix_val = ham_linebuf[spix];
            dpix_val = xcolors[spix_val];
            sprpix_val = pixdata.apixels[spix];
            dpix_val = merge_2pixel32 (dpix_val, tmp_val);
            spix++;
            }
            out_val = dpix_val;
            if (spritepixels[dpix].data) {
                sprcol = render_sprites (dpix, 0, sprpix_val, 0);
                if (sprcol) {
                    uae_u32 spcol = colors_for_drawing.acolors[sprcol];
                    out_val = spcol;
                }
            }
            buf[dpix++] = out_val;
        }
    } else if (bpldualpf) {
        int *lookup = bpldualpfpri ? dblpf_ind2 : dblpf_ind1;
        while (dpix < dpix_end) {
            uae_u32 sprpix_val;
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix];
            sprpix_val = spix_val;
            dpix_val = colors_for_drawing.acolors[lookup[spix_val]];
            {
            uae_u32 tmp_val;
            spix++;
            tmp_val = dpix_val;
            spix_val = pixdata.apixels[spix];
            sprpix_val = spix_val;
            dpix_val = colors_for_drawing.acolors[lookup[spix_val]];
            dpix_val = merge_2pixel32 (dpix_val, tmp_val);
            spix++;
            }
            out_val = dpix_val;
            if (spritepixels[dpix].data) {
                sprcol = render_sprites (dpix, 1, sprpix_val, 0);
                if (sprcol) {
                    uae_u32 spcol = colors_for_drawing.acolors[sprcol];
                    out_val = spcol;
                }
            }
            buf[dpix++] = out_val;
        }
    } else if (bplehb) {
        while (dpix < dpix_end) {
            uae_u32 sprpix_val;
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix];
            sprpix_val = spix_val;
            if (spix_val <= 31)
                dpix_val = colors_for_drawing.acolors[spix_val];
            else
                dpix_val = xcolors[(colors_for_drawing.color_regs_ecs[spix_val - 32] >> 1) & 0x777];
            {
            uae_u32 tmp_val;
            spix++;
            tmp_val = dpix_val;
            spix_val = pixdata.apixels[spix];
            sprpix_val = spix_val;
            if (spix_val <= 31)
                dpix_val = colors_for_drawing.acolors[spix_val];
            else
                dpix_val = xcolors[(colors_for_drawing.color_regs_ecs[spix_val - 32] >> 1) & 0x777];
            dpix_val = merge_2pixel32 (dpix_val, tmp_val);
            spix++;
            }
            out_val = dpix_val;
            if (spritepixels[dpix].data) {
                sprcol = render_sprites (dpix, 0, sprpix_val, 0);
                if (sprcol) {
                    uae_u32 spcol = colors_for_drawing.acolors[sprcol];
                    out_val = spcol;
                }
            }
            buf[dpix++] = out_val;
        }
    } else {
        while (dpix < dpix_end) {
            uae_u32 sprpix_val;
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix];
            sprpix_val = spix_val;
            dpix_val = colors_for_drawing.acolors[spix_val];
            {
            uae_u32 tmp_val;
            spix++;
            tmp_val = dpix_val;
            spix_val = pixdata.apixels[spix];
            sprpix_val = spix_val;
            dpix_val = colors_for_drawing.acolors[spix_val];
            dpix_val = merge_2pixel32 (dpix_val, tmp_val);
            spix++;
            }
            out_val = dpix_val;
            if (spritepixels[dpix].data) {
                sprcol = render_sprites (dpix, 0, sprpix_val, 0);
                if (sprcol) {
                    uae_u32 spcol = colors_for_drawing.acolors[sprcol];
                    out_val = spcol;
                }
            }
            buf[dpix++] = out_val;
        }
    }

    return spix;
}

static int NOINLINE __attribute__((__unused__)) linetoscr_32_shrink1f_spr_genlock(int spix, int dpix, int dpix_end)
{
    uae_u32 *buf = (uae_u32 *) xlinebuffer;
    uae_u8 *genlock_buf = xlinebuffer_genlock;
    uae_u8 sprcol;

    if (bplham) {
        while (dpix < dpix_end) {
            uae_u32 sprpix_val;
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = ham_linebuf[spix];
            dpix_val = xcolors[spix_val];
            sprpix_val = pixdata.apixels[spix];
            {
            uae_u32 tmp_val;
            spix++;
            tmp_val = dpix_val;
            spix_val = ham_linebuf[spix];
            dpix_val = xcolors[spix_val];
            sprpix_val = pixdata.apixels[spix];
            dpix_val = merge_2pixel32 (dpix_val, tmp_val);
            spix++;
            }
            out_val = dpix_val;
            genlock_buf[dpix] = get_genlock_transparency(spix_val & 15);
            if (spritepixels[dpix].data) {
                sprcol = render_sprites (dpix, 0, sprpix_val, 0);
                    genlock_buf[dpix] = get_genlock_transparency(sprcol);
                if (sprcol) {
                    uae_u32 spcol = colors_for_drawing.acolors[sprcol];
                    out_val = spcol;
                }
            }
            buf[dpix++] = out_val;
        }
    } else if (bpldualpf) {
        int *lookup = bpldualpfpri ? dblpf_ind2 : dblpf_ind1;
        while (dpix < dpix_end) {
            uae_u32 sprpix_val;
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix];
            sprpix_val = spix_val;
            dpix_val = colors_for_drawing.acolors[lookup[spix_val]];
            {
            uae_u32 tmp_val;
            spix++;
            tmp_val = dpix_val;
            spix_val = pixdata.apixels[spix];
            sprpix_val = spix_val;
            dpix_val = colors_for_drawing.acolors[lookup[spix_val]];
            dpix_val = merge_2pixel32 (dpix_val, tmp_val);
            spix++;
            }
            out_val = dpix_val;
            genlock_buf[dpix] = get_genlock_transparency(lookup[spix_val]);
            if (spritepixels[dpix].data) {
                sprcol = render_sprites (dpix, 1, sprpix_val, 0);
                    genlock_buf[dpix] = get_genlock_transparency(sprcol);
                if (sprcol) {
                    uae_u32 spcol = colors_for_drawing.acolors[sprcol];
                    out_val = spcol;
                }
            }
            buf[dpix++] = out_val;
        }
    } else if (bplehb) {
        while (dpix < dpix_end) {
            uae_u32 sprpix_val;
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix];
            sprpix_val = spix_val;
            if (spix_val <= 31)
                dpix_val = colors_for_drawing.acolors[spix_val];
            else
                dpix_val = xcolors[(colors_for_drawing.color_regs_ecs[spix_val - 32] >> 1) & 0x777];
            {
            uae_u32 tmp_val;
            spix++;
            tmp_val = dpix_val;
            spix_val = pixdata.apixels[spix];
            sprpix_val = spix_val;
            if (spix_val <= 31)
                dpix_val = colors_for_drawing.acolors[spix_val];
            else
                dpix_val = xcolors[(colors_for_drawing.color_regs_ecs[spix_val - 32] >> 1) & 0x777];
            dpix_val = merge_2pixel32 (dpix_val, tmp_val);
            spix++;
            }
            out_val = dpix_val;
            genlock_buf[dpix] = get_genlock_transparency(spix_val & 31);
            if (spritepixels[dpix].data) {
                sprcol = render_sprites (dpix, 0, sprpix_val, 0);
                    genlock_buf[dpix] = get_genlock_transparency(sprcol);
                if (sprcol) {
                    uae_u32 spcol = colors_for_drawing.acolors[sprcol];
                    out_val = spcol;
                }
            }
            buf[dpix++] = out_val;
        }
    } else {
        while (dpix < dpix_end) {
            uae_u32 sprpix_val;
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix];
            sprpix_val = spix_val;
            dpix_val = colors_for_drawing.acolors[spix_val];
            {
            uae_u32 tmp_val;
            spix++;
            tmp_val = dpix_val;
            spix_val = pixdata.apixels[spix];
            sprpix_val = spix_val;
            dpix_val = colors_for_drawing.acolors[spix_val];
            dpix_val = merge_2pixel32 (dpix_val, tmp_val);
            spix++;
            }
            out_val = dpix_val;
            genlock_buf[dpix] = get_genlock_transparency(spix_val);
            if (spritepixels[dpix].data) {
                sprcol = render_sprites (dpix, 0, sprpix_val, 0);
                    genlock_buf[dpix] = get_genlock_transparency(sprcol);
                if (sprcol) {
                    uae_u32 spcol = colors_for_drawing.acolors[sprcol];
                    out_val = spcol;
                }
            }
            buf[dpix++] = out_val;
        }
    }

    return spix;
}

static int NOINLINE __attribute__((__unused__)) linetoscr_32_shrink2_spr(int spix, int dpix, int dpix_end)
{
    uae_u32 *buf = (uae_u32 *) xlinebuffer;
    uae_u8 sprcol;

    if (bplham) {
        while (dpix < dpix_end) {
            uae_u32 sprpix_val;
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = ham_linebuf[spix];
            dpix_val = xcolors[spix_val];
            sprpix_val = pixdata.apixels[spix];
            spix += 4;
            out_val = dpix_val;
            if (spritepixels[dpix].data) {
                sprcol = render_sprites (dpix, 0, sprpix_val, 0);
                if (sprcol) {
                    uae_u32 spcol = colors_for_drawing.acolors[sprcol];
                    out_val = spcol;
                }
            }
            buf[dpix++] = out_val;
        }
    } else if (bpldualpf) {
        int *lookup = bpldualpfpri ? dblpf_ind2 : dblpf_ind1;
        while (dpix < dpix_end) {
            uae_u32 sprpix_val;
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix];
            sprpix_val = spix_val;
            dpix_val = colors_for_drawing.acolors[lookup[spix_val]];
            spix += 4;
            out_val = dpix_val;
            if (spritepixels[dpix].data) {
                sprcol = render_sprites (dpix, 1, sprpix_val, 0);
                if (sprcol) {
                    uae_u32 spcol = colors_for_drawing.acolors[sprcol];
                    out_val = spcol;
                }
            }
            buf[dpix++] = out_val;
        }
    } else if (bplehb) {
        while (dpix < dpix_end) {
            uae_u32 sprpix_val;
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix];
            sprpix_val = spix_val;
            if (spix_val <= 31)
                dpix_val = colors_for_drawing.acolors[spix_val];
            else
                dpix_val = xcolors[(colors_for_drawing.color_regs_ecs[spix_val - 32] >> 1) & 0x777];
            spix += 4;
            out_val = dpix_val;
            if (spritepixels[dpix].data) {
                sprcol = render_sprites (dpix, 0, sprpix_val, 0);
                if (sprcol) {
                    uae_u32 spcol = colors_for_drawing.acolors[sprcol];
                    out_val = spcol;
                }
            }
            buf[dpix++] = out_val;
        }
    } else {
        while (dpix < dpix_end) {
            uae_u32 sprpix_val;
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix];
            sprpix_val = spix_val;
            dpix_val = colors_for_drawing.acolors[spix_val];
            spix += 4;
            out_val = dpix_val;
            if (spritepixels[dpix].data) {
                sprcol = render_sprites (dpix, 0, sprpix_val, 0);
                if (sprcol) {
                    uae_u32 spcol = colors_for_drawing.acolors[sprcol];
                    out_val = spcol;
                }
            }
            buf[dpix++] = out_val;
        }
    }

    return spix;
}

static int NOINLINE __attribute__((__unused__)) linetoscr_32_shrink2_spr_genlock(int spix, int dpix, int dpix_end)
{
    uae_u32 *buf = (uae_u32 *) xlinebuffer;
    uae_u8 *genlock_buf = xlinebuffer_genlock;
    uae_u8 sprcol;

    if (bplham) {
        while (dpix < dpix_end) {
            uae_u32 sprpix_val;
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = ham_linebuf[spix];
            dpix_val = xcolors[spix_val];
            sprpix_val = pixdata.apixels[spix];
            spix += 4;
            out_val = dpix_val;
            genlock_buf[dpix] = get_genlock_transparency(spix_val & 15);
            if (spritepixels[dpix].data) {
                sprcol = render_sprites (dpix, 0, sprpix_val, 0);
                    genlock_buf[dpix] = get_genlock_transparency(sprcol);
                if (sprcol) {
                    uae_u32 spcol = colors_for_drawing.acolors[sprcol];
                    out_val = spcol;
                }
            }
            buf[dpix++] = out_val;
        }
    } else if (bpldualpf) {
        int *lookup = bpldualpfpri ? dblpf_ind2 : dblpf_ind1;
        while (dpix < dpix_end) {
            uae_u32 sprpix_val;
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix];
            sprpix_val = spix_val;
            dpix_val = colors_for_drawing.acolors[lookup[spix_val]];
            spix += 4;
            out_val = dpix_val;
            genlock_buf[dpix] = get_genlock_transparency(lookup[spix_val]);
            if (spritepixels[dpix].data) {
                sprcol = render_sprites (dpix, 1, sprpix_val, 0);
                    genlock_buf[dpix] = get_genlock_transparency(sprcol);
                if (sprcol) {
                    uae_u32 spcol = colors_for_drawing.acolors[sprcol];
                    out_val = spcol;
                }
            }
            buf[dpix++] = out_val;
        }
    } else if (bplehb) {
        while (dpix < dpix_end) {
            uae_u32 sprpix_val;
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix];
            sprpix_val = spix_val;
            if (spix_val <= 31)
                dpix_val = colors_for_drawing.acolors[spix_val];
            else
                dpix_val = xcolors[(colors_for_drawing.color_regs_ecs[spix_val - 32] >> 1) & 0x777];
            spix += 4;
            out_val = dpix_val;
            genlock_buf[dpix] = get_genlock_transparency(spix_val & 31);
            if (spritepixels[dpix].data) {
                sprcol = render_sprites (dpix, 0, sprpix_val, 0);
                    genlock_buf[dpix] = get_genlock_transparency(sprcol);
                if (sprcol) {
                    uae_u32 spcol = colors_for_drawing.acolors[sprcol];
                    out_val = spcol;
                }
            }
            buf[dpix++] = out_val;
        }
    } else {
        while (dpix < dpix_end) {
            uae_u32 sprpix_val;
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix];
            sprpix_val = spix_val;
            dpix_val = colors_for_drawing.acolors[spix_val];
            spix += 4;
            out_val = dpix_val;
            genlock_buf[dpix] = get_genlock_transparency(spix_val);
            if (spritepixels[dpix].data) {
                sprcol = render_sprites (dpix, 0, sprpix_val, 0);
                    genlock_buf[dpix] = get_genlock_transparency(sprcol);
                if (sprcol) {
                    uae_u32 spcol = colors_for_drawing.acolors[sprcol];
                    out_val = spcol;
                }
            }
            buf[dpix++] = out_val;
        }
    }

    return spix;
}

static int NOINLINE __attribute__((__unused__)) linetoscr_32_shrink2f_spr(int spix, int dpix, int dpix_end)
{
    uae_u32 *buf = (uae_u32 *) xlinebuffer;
    uae_u8 sprcol;

    if (bplham) {
        while (dpix < dpix_end) {
            uae_u32 sprpix_val;
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = ham_linebuf[spix];
            dpix_val = xcolors[spix_val];
            sprpix_val = pixdata.apixels[spix];
            {
            uae_u32 tmp_val, tmp_val2, tmp_val3;
            spix++;
            tmp_val = dpix_val;
            spix_val = ham_linebuf[spix];
            dpix_val = xcolors[spix_val];
            sprpix_val = pixdata.apixels[spix];
            spix++;
            tmp_val2 = dpix_val;
            spix_val = ham_linebuf[spix];
            dpix_val = xcolors[spix_val];
            sprpix_val = pixdata.apixels[spix];
            spix++;
            tmp_val3 = dpix_val;
            spix_val = ham_linebuf[spix];
            dpix_val = xcolors[spix_val];
            sprpix_val = pixdata.apixels[spix];
            tmp_val = merge_2pixel32 (tmp_val, tmp_val2);
            tmp_val2 = merge_2pixel32 (tmp_val3, dpix_val);
            dpix_val = merge_2pixel32 (tmp_val, tmp_val2);
            spix++;
            }
            out_val = dpix_val;
            if (spritepixels[dpix].data) {
                sprcol = render_sprites (dpix, 0, sprpix_val, 0);
                if (sprcol) {
                    uae_u32 spcol = colors_for_drawing.acolors[sprcol];
                    out_val = spcol;
                }
            }
            buf[dpix++] = out_val;
        }
    } else if (bpldualpf) {
        int *lookup = bpldualpfpri ? dblpf_ind2 : dblpf_ind1;
        while (dpix < dpix_end) {
            uae_u32 sprpix_val;
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix];
            sprpix_val = spix_val;
            dpix_val = colors_for_drawing.acolors[lookup[spix_val]];
            {
            uae_u32 tmp_val, tmp_val2, tmp_val3;
            spix++;
            tmp_val = dpix_val;
            spix_val = pixdata.apixels[spix];
            sprpix_val = spix_val;
            dpix_val = colors_for_drawing.acolors[lookup[spix_val]];
            spix++;
            tmp_val2 = dpix_val;
            spix_val = pixdata.apixels[spix];
            sprpix_val = spix_val;
            dpix_val = colors_for_drawing.acolors[lookup[spix_val]];
            spix++;
            tmp_val3 = dpix_val;
            spix_val = pixdata.apixels[spix];
            sprpix_val = spix_val;
            dpix_val = colors_for_drawing.acolors[lookup[spix_val]];
            tmp_val = merge_2pixel32 (tmp_val, tmp_val2);
            tmp_val2 = merge_2pixel32 (tmp_val3, dpix_val);
            dpix_val = merge_2pixel32 (tmp_val, tmp_val2);
            spix++;
            }
            out_val = dpix_val;
            if (spritepixels[dpix].data) {
                sprcol = render_sprites (dpix, 1, sprpix_val, 0);
                if (sprcol) {
                    uae_u32 spcol = colors_for_drawing.acolors[sprcol];
                    out_val = spcol;
                }
            }
            buf[dpix++] = out_val;
        }
    } else if (bplehb) {
        while (dpix < dpix_end) {
            uae_u32 sprpix_val;
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix];
            sprpix_val = spix_val;
            if (spix_val <= 31)
                dpix_val = colors_for_drawing.acolors[spix_val];
            else
                dpix_val = xcolors[(colors_for_drawing.color_regs_ecs[spix_val - 32] >> 1) & 0x777];
            {
            uae_u32 tmp_val, tmp_val2, tmp_val3;
            spix++;
            tmp_val = dpix_val;
            spix_val = pixdata.apixels[spix];
            sprpix_val = spix_val;
            if (spix_val <= 31)
                dpix_val = colors_for_drawing.acolors[spix_val];
            else
                dpix_val = xcolors[(colors_for_drawing.color_regs_ecs[spix_val - 32] >> 1) & 0x777];
            spix++;
            tmp_val2 = dpix_val;
            spix_val = pixdata.apixels[spix];
            sprpix_val = spix_val;
            if (spix_val <= 31)
                dpix_val = colors_for_drawing.acolors[spix_val];
            else
                dpix_val = xcolors[(colors_for_drawing.color_regs_ecs[spix_val - 32] >> 1) & 0x777];
            spix++;
            tmp_val3 = dpix_val;
            spix_val = pixdata.apixels[spix];
            sprpix_val = spix_val;
            if (spix_val <= 31)
                dpix_val = colors_for_drawing.acolors[spix_val];
            else
                dpix_val = xcolors[(colors_for_drawing.color_regs_ecs[spix_val - 32] >> 1) & 0x777];
            tmp_val = merge_2pixel32 (tmp_val, tmp_val2);
            tmp_val2 = merge_2pixel32 (tmp_val3, dpix_val);
            dpix_val = merge_2pixel32 (tmp_val, tmp_val2);
            spix++;
            }
            out_val = dpix_val;
            if (spritepixels[dpix].data) {
                sprcol = render_sprites (dpix, 0, sprpix_val, 0);
                if (sprcol) {
                    uae_u32 spcol = colors_for_drawing.acolors[sprcol];
                    out_val = spcol;
                }
            }
            buf[dpix++] = out_val;
        }
    } else {
        while (dpix < dpix_end) {
            uae_u32 sprpix_val;
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix];
            sprpix_val = spix_val;
            dpix_val = colors_for_drawing.acolors[spix_val];
            {
            uae_u32 tmp_val, tmp_val2, tmp_val3;
            spix++;
            tmp_val = dpix_val;
            spix_val = pixdata.apixels[spix];
            sprpix_val = spix_val;
            dpix_val = colors_for_drawing.acolors[spix_val];
            spix++;
            tmp_val2 = dpix_val;
            spix_val = pixdata.apixels[spix];
            sprpix_val = spix_val;
            dpix_val = colors_for_drawing.acolors[spix_val];
            spix++;
            tmp_val3 = dpix_val;
            spix_val = pixdata.apixels[spix];
            sprpix_val = spix_val;
            dpix_val = colors_for_drawing.acolors[spix_val];
            tmp_val = merge_2pixel32 (tmp_val, tmp_val2);
            tmp_val2 = merge_2pixel32 (tmp_val3, dpix_val);
            dpix_val = merge_2pixel32 (tmp_val, tmp_val2);
            spix++;
            }
            out_val = dpix_val;
            if (spritepixels[dpix].data) {
                sprcol = render_sprites (dpix, 0, sprpix_val, 0);
                if (sprcol) {
                    uae_u32 spcol = colors_for_drawing.acolors[sprcol];
                    out_val = spcol;
                }
            }
            buf[dpix++] = out_val;
        }
    }

    return spix;
}

static int NOINLINE __attribute__((__unused__)) linetoscr_32_shrink2f_spr_genlock(int spix, int dpix, int dpix_end)
{
    uae_u32 *buf = (uae_u32 *) xlinebuffer;
    uae_u8 *genlock_buf = xlinebuffer_genlock;
    uae_u8 sprcol;

    if (bplham) {
        while (dpix < dpix_end) {
            uae_u32 sprpix_val;
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = ham_linebuf[spix];
            dpix_val = xcolors[spix_val];
            sprpix_val = pixdata.apixels[spix];
            {
            uae_u32 tmp_val, tmp_val2, tmp_val3;
            spix++;
            tmp_val = dpix_val;
            spix_val = ham_linebuf[spix];
            dpix_val = xcolors[spix_val];
            sprpix_val = pixdata.apixels[spix];
            spix++;
            tmp_val2 = dpix_val;
            spix_val = ham_linebuf[spix];
            dpix_val = xcolors[spix_val];
            sprpix_val = pixdata.apixels[spix];
            spix++;
            tmp_val3 = dpix_val;
            spix_val = ham_linebuf[spix];
            dpix_val = xcolors[spix_val];
            sprpix_val = pixdata.apixels[spix];
            tmp_val = merge_2pixel32 (tmp_val, tmp_val2);
            tmp_val2 = merge_2pixel32 (tmp_val3, dpix_val);
            dpix_val = merge_2pixel32 (tmp_val, tmp_val2);
            spix++;
            }
            out_val = dpix_val;
            genlock_buf[dpix] = get_genlock_transparency(spix_val & 15);
            if (spritepixels[dpix].data) {
                sprcol = render_sprites (dpix, 0, sprpix_val, 0);
                    genlock_buf[dpix] = get_genlock_transparency(sprcol);
                if (sprcol) {
                    uae_u32 spcol = colors_for_drawing.acolors[sprcol];
                    out_val = spcol;
                }
            }
            buf[dpix++] = out_val;
        }
    } else if (bpldualpf) {
        int *lookup = bpldualpfpri ? dblpf_ind2 : dblpf_ind1;
        while (dpix < dpix_end) {
            uae_u32 sprpix_val;
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix];
            sprpix_val = spix_val;
            dpix_val = colors_for_drawing.acolors[lookup[spix_val]];
            {
            uae_u32 tmp_val, tmp_val2, tmp_val3;
            spix++;
            tmp_val = dpix_val;
            spix_val = pixdata.apixels[spix];
            sprpix_val = spix_val;
            dpix_val = colors_for_drawing.acolors[lookup[spix_val]];
            spix++;
            tmp_val2 = dpix_val;
            spix_val = pixdata.apixels[spix];
            sprpix_val = spix_val;
            dpix_val = colors_for_drawing.acolors[lookup[spix_val]];
            spix++;
            tmp_val3 = dpix_val;
            spix_val = pixdata.apixels[spix];
            sprpix_val = spix_val;
            dpix_val = colors_for_drawing.acolors[lookup[spix_val]];
            tmp_val = merge_2pixel32 (tmp_val, tmp_val2);
            tmp_val2 = merge_2pixel32 (tmp_val3, dpix_val);
            dpix_val = merge_2pixel32 (tmp_val, tmp_val2);
            spix++;
            }
            out_val = dpix_val;
            genlock_buf[dpix] = get_genlock_transparency(lookup[spix_val]);
            if (spritepixels[dpix].data) {
                sprcol = render_sprites (dpix, 1, sprpix_val, 0);
                    genlock_buf[dpix] = get_genlock_transparency(sprcol);
                if (sprcol) {
                    uae_u32 spcol = colors_for_drawing.acolors[sprcol];
                    out_val = spcol;
                }
            }
            buf[dpix++] = out_val;
        }
    } else if (bplehb) {
        while (dpix < dpix_end) {
            uae_u32 sprpix_val;
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix];
            sprpix_val = spix_val;
            if (spix_val <= 31)
                dpix_val = colors_for_drawing.acolors[spix_val];
            else
                dpix_val = xcolors[(colors_for_drawing.color_regs_ecs[spix_val - 32] >> 1) & 0x777];
            {
            uae_u32 tmp_val, tmp_val2, tmp_val3;
            spix++;
            tmp_val = dpix_val;
            spix_val = pixdata.apixels[spix];
            sprpix_val = spix_val;
            if (spix_val <= 31)
                dpix_val = colors_for_drawing.acolors[spix_val];
            else
                dpix_val = xcolors[(colors_for_drawing.color_regs_ecs[spix_val - 32] >> 1) & 0x777];
            spix++;
            tmp_val2 = dpix_val;
            spix_val = pixdata.apixels[spix];
            sprpix_val = spix_val;
            if (spix_val <= 31)
                dpix_val = colors_for_drawing.acolors[spix_val];
            else
                dpix_val = xcolors[(colors_for_drawing.color_regs_ecs[spix_val - 32] >> 1) & 0x777];
            spix++;
            tmp_val3 = dpix_val;
            spix_val = pixdata.apixels[spix];
            sprpix_val = spix_val;
            if (spix_val <= 31)
                dpix_val = colors_for_drawing.acolors[spix_val];
            else
                dpix_val = xcolors[(colors_for_drawing.color_regs_ecs[spix_val - 32] >> 1) & 0x777];
            tmp_val = merge_2pixel32 (tmp_val, tmp_val2);
            tmp_val2 = merge_2pixel32 (tmp_val3, dpix_val);
            dpix_val = merge_2pixel32 (tmp_val, tmp_val2);
            spix++;
            }
            out_val = dpix_val;
            genlock_buf[dpix] = get_genlock_transparency(spix_val & 31);
            if (spritepixels[dpix].data) {
                sprcol = render_sprites (dpix, 0, sprpix_val, 0);
                    genlock_buf[dpix] = get_genlock_transparency(sprcol);
                if (sprcol) {
                    uae_u32 spcol = colors_for_drawing.acolors[sprcol];
                    out_val = spcol;
                }
            }
            buf[dpix++] = out_val;
        }
    } else {
        while (dpix < dpix_end) {
            uae_u32 sprpix_val;
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix];
            sprpix_val = spix_val;
            dpix_val = colors_for_drawing.acolors[spix_val];
            {
            uae_u32 tmp_val, tmp_val2, tmp_val3;
            spix++;
            tmp_val = dpix_val;
            spix_val = pixdata.apixels[spix];
            sprpix_val = spix_val;
            dpix_val = colors_for_drawing.acolors[spix_val];
            spix++;
            tmp_val2 = dpix_val;
            spix_val = pixdata.apixels[spix];
            sprpix_val = spix_val;
            dpix_val = colors_for_drawing.acolors[spix_val];
            spix++;
            tmp_val3 = dpix_val;
            spix_val = pixdata.apixels[spix];
            sprpix_val = spix_val;
            dpix_val = colors_for_drawing.acolors[spix_val];
            tmp_val = merge_2pixel32 (tmp_val, tmp_val2);
            tmp_val2 = merge_2pixel32 (tmp_val3, dpix_val);
            dpix_val = merge_2pixel32 (tmp_val, tmp_val2);
            spix++;
            }
            out_val = dpix_val;
            genlock_buf[dpix] = get_genlock_transparency(spix_val);
            if (spritepixels[dpix].data) {
                sprcol = render_sprites (dpix, 0, sprpix_val, 0);
                    genlock_buf[dpix] = get_genlock_transparency(sprcol);
                if (sprcol) {
                    uae_u32 spcol = colors_for_drawing.acolors[sprcol];
                    out_val = spcol;
                }
            }
            buf[dpix++] = out_val;
        }
    }

    return spix;
}

#ifdef AGA
static int NOINLINE __attribute__((__unused__)) linetoscr_32_aga_spronly(int spix, int dpix, int dpix_end)
{
    uae_u32 *buf = (uae_u32 *) xlinebuffer;
    uae_u8 sprcol;

    if (1) {
        while (dpix < dpix_end) {
            uae_u32 sprpix_val;
            uae_u32 out_val;
        
            sprpix_val = 0;
            spix++;
            out_val = colors_for_drawing.acolors[0];
            if (spritepixels[dpix].data) {
                sprcol = render_sprites (dpix + 0, 0, sprpix_val, 1);
                if (sprcol) {
                    out_val = colors_for_drawing.acolors[sprcol];
                }
            }
            buf[dpix++] = out_val;
        }
    }

    return spix;
}
#endif

#ifdef AGA
static int NOINLINE __attribute__((__unused__)) linetoscr_32_stretch1_aga_spronly(int spix, int dpix, int dpix_end)
{
    uae_u32 *buf = (uae_u32 *) xlinebuffer;
    uae_u8 sprcol;

    if (1) {
        while (dpix < dpix_end) {
            uae_u32 sprpix_val;
            uae_u32 out_val;
        
            sprpix_val = 0;
            spix++;
            out_val = colors_for_drawing.acolors[0];
            {
            uae_u32 out_val1 = out_val;
            uae_u32 out_val2 = out_val;
            if (spritepixels[dpix + 0].data) {
                sprcol = render_sprites (dpix + 0, 0, sprpix_val, 1);
                if (sprcol) {
                    out_val1 = colors_for_drawing.acolors[sprcol];
                }
            }
            if (spritepixels[dpix + 1].data) {
                sprcol = render_sprites (dpix + 1, 0, sprpix_val, 1);
                if (sprcol) {
                    out_val2 = colors_for_drawing.acolors[sprcol];
                }
            }
            buf[dpix++] = out_val1;
            buf[dpix++] = out_val2;
            }
        }
    }

    return spix;
}
#endif

#ifdef AGA
static int NOINLINE __attribute__((__unused__)) linetoscr_32_stretch2_aga_spronly(int spix, int dpix, int dpix_end)
{
    uae_u32 *buf = (uae_u32 *) xlinebuffer;
    uae_u8 sprcol;

    if (1) {
        while (dpix < dpix_end) {
            uae_u32 sprpix_val;
            uae_u32 out_val;
        
            sprpix_val = 0;
            spix++;
            out_val = colors_for_drawing.acolors[0];
            {
            uae_u32 out_val1 = out_val;
            uae_u32 out_val2 = out_val;
            uae_u32 out_val3 = out_val;
            uae_u32 out_val4 = out_val;
            if (spritepixels[dpix + 0].data) {
                sprcol = render_sprites (dpix + 0, 0, sprpix_val, 1);
                if (sprcol) {
                    out_val1 = colors_for_drawing.acolors[sprcol];
                }
            }
            if (spritepixels[dpix + 1].data) {
                sprcol = render_sprites (dpix + 1, 0, sprpix_val, 1);
                if (sprcol) {
                    out_val2 = colors_for_drawing.acolors[sprcol];
                }
            }
            if (spritepixels[dpix + 2].data) {
                sprcol = render_sprites (dpix + 2, 0, sprpix_val, 1);
                if (sprcol) {
                    out_val3 = colors_for_drawing.acolors[sprcol];
                }
            }
            if (spritepixels[dpix + 3].data) {
                sprcol = render_sprites (dpix + 3, 0, sprpix_val, 1);
                if (sprcol) {
                    out_val4 = colors_for_drawing.acolors[sprcol];
                }
            }
            buf[dpix++] = out_val1;
            buf[dpix++] = out_val2;
            buf[dpix++] = out_val3;
            buf[dpix++] = out_val4;
            }
        }
    }

    return spix;
}
#endif

#ifdef AGA
static int NOINLINE __attribute__((__unused__)) linetoscr_32_shrink1_aga_spronly(int spix, int dpix, int dpix_end)
{
    uae_u32 *buf = (uae_u32 *) xlinebuffer;
    uae_u8 sprcol;

    if (1) {
        while (dpix < dpix_end) {
            uae_u32 sprpix_val;
            uae_u32 out_val;
        
            sprpix_val = 0;
            spix++;
            out_val = colors_for_drawing.acolors[0];
            if (spritepixels[dpix].data) {
                sprcol = render_sprites (dpix + 0, 0, sprpix_val, 1);
                if (sprcol) {
                    out_val = colors_for_drawing.acolors[sprcol];
                }
            }
            buf[dpix++] = out_val;
        }
    }

    return spix;
}
#endif

#ifdef AGA
static int NOINLINE __attribute__((__unused__)) linetoscr_32_shrink1f_aga_spronly(int spix, int dpix, int dpix_end)
{
    uae_u32 *buf = (uae_u32 *) xlinebuffer;
    uae_u8 sprcol;

    if (1) {
        while (dpix < dpix_end) {
            uae_u32 sprpix_val;
            uae_u32 out_val;
        
            sprpix_val = 0;
            spix++;
            out_val = colors_for_drawing.acolors[0];
            if (spritepixels[dpix].data) {
                sprcol = render_sprites (dpix + 0, 0, sprpix_val, 1);
                if (sprcol) {
                    out_val = colors_for_drawing.acolors[sprcol];
                }
            }
            buf[dpix++] = out_val;
        }
    }

    return spix;
}
#endif

#ifdef AGA
static int NOINLINE __attribute__((__unused__)) linetoscr_32_shrink2_aga_spronly(int spix, int dpix, int dpix_end)
{
    uae_u32 *buf = (uae_u32 *) xlinebuffer;
    uae_u8 sprcol;

    if (1) {
        while (dpix < dpix_end) {
            uae_u32 sprpix_val;
            uae_u32 out_val;
        
            sprpix_val = 0;
            spix++;
            out_val = colors_for_drawing.acolors[0];
            if (spritepixels[dpix].data) {
                sprcol = render_sprites (dpix + 0, 0, sprpix_val, 1);
                if (sprcol) {
                    out_val = colors_for_drawing.acolors[sprcol];
                }
            }
            buf[dpix++] = out_val;
        }
    }

    return spix;
}
#endif

#ifdef AGA
static int NOINLINE __attribute__((__unused__)) linetoscr_32_shrink2f_aga_spronly(int spix, int dpix, int dpix_end)
{
    uae_u32 *buf = (uae_u32 *) xlinebuffer;
    uae_u8 sprcol;

    if (1) {
        while (dpix < dpix_end) {
            uae_u32 sprpix_val;
            uae_u32 out_val;
        
            sprpix_val = 0;
            spix++;
            out_val = colors_for_drawing.acolors[0];
            if (spritepixels[dpix].data) {
                sprcol = render_sprites (dpix + 0, 0, sprpix_val, 1);
                if (sprcol) {
                    out_val = colors_for_drawing.acolors[sprcol];
                }
            }
            buf[dpix++] = out_val;
        }
    }

    return spix;
}
#endif

#ifdef AGA
static int NOINLINE __attribute__((__unused__)) linetoscr_32_aga(int spix, int dpix, int dpix_end)
{
    uae_u32 *buf = (uae_u32 *) xlinebuffer;
    uae_u8 xor_val = bplxor;

    if (bplham) {
        while (dpix < dpix_end) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix] ^ xor_val;
            spix_val = ham_linebuf[spix];
            dpix_val = CONVERT_RGB (spix_val);
            spix++;
            out_val = dpix_val;
            buf[dpix++] = out_val;
        }
    } else if (bpldualpf) {
        int *lookup    = bpldualpfpri ? dblpf_ind2_aga : dblpf_ind1_aga;
        int *lookup_no = bpldualpfpri ? dblpf_2nd2     : dblpf_2nd1;
        while (dpix < dpix_end) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix];
            {
                uae_u8 val = lookup[spix_val];
                if (lookup_no[spix_val])
                    val += dblpfofs[bpldualpf2of];
                val ^= xor_val;
                dpix_val = colors_for_drawing.acolors[val];
            }
            spix++;
            out_val = dpix_val;
            buf[dpix++] = out_val;
        }
    } else if (bplehb) {
        while (dpix < dpix_end) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix] ^ xor_val;
            if (spix_val >= 32 && spix_val < 64) {
                unsigned int c = (colors_for_drawing.color_regs_aga[spix_val - 32] >> 1) & 0x7F7F7F;
                dpix_val = CONVERT_RGB (c);
            } else
                dpix_val = colors_for_drawing.acolors[spix_val];
            spix++;
            out_val = dpix_val;
            buf[dpix++] = out_val;
        }
    } else {
        while (dpix < dpix_end) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix] ^ xor_val;
            dpix_val = colors_for_drawing.acolors[spix_val];
            spix++;
            out_val = dpix_val;
            buf[dpix++] = out_val;
        }
    }

    return spix;
}
#endif

#ifdef AGA
static int NOINLINE __attribute__((__unused__)) linetoscr_32_aga_genlock(int spix, int dpix, int dpix_end)
{
    uae_u32 *buf = (uae_u32 *) xlinebuffer;
    uae_u8 *genlock_buf = xlinebuffer_genlock;
    uae_u8 xor_val = bplxor;

    if (bplham) {
        while (dpix < dpix_end) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix] ^ xor_val;
            spix_val = ham_linebuf[spix];
            dpix_val = CONVERT_RGB (spix_val);
            spix++;
            out_val = dpix_val;
            genlock_buf[dpix] = get_genlock_transparency((spix_val >> 2) & 63);
            buf[dpix++] = out_val;
        }
    } else if (bpldualpf) {
        int *lookup    = bpldualpfpri ? dblpf_ind2_aga : dblpf_ind1_aga;
        int *lookup_no = bpldualpfpri ? dblpf_2nd2     : dblpf_2nd1;
        while (dpix < dpix_end) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix];
            {
                uae_u8 val = lookup[spix_val];
                if (lookup_no[spix_val])
                    val += dblpfofs[bpldualpf2of];
                val ^= xor_val;
                dpix_val = colors_for_drawing.acolors[val];
            }
            spix++;
            out_val = dpix_val;
            genlock_buf[dpix] = get_genlock_transparency(lookup[spix_val]);
            buf[dpix++] = out_val;
        }
    } else if (bplehb) {
        while (dpix < dpix_end) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix] ^ xor_val;
            if (spix_val >= 32 && spix_val < 64) {
                unsigned int c = (colors_for_drawing.color_regs_aga[spix_val - 32] >> 1) & 0x7F7F7F;
                dpix_val = CONVERT_RGB (c);
            } else
                dpix_val = colors_for_drawing.acolors[spix_val];
            spix++;
            out_val = dpix_val;
            genlock_buf[dpix] = get_genlock_transparency(spix_val & 31);
            buf[dpix++] = out_val;
        }
    } else {
        while (dpix < dpix_end) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix] ^ xor_val;
            dpix_val = colors_for_drawing.acolors[spix_val];
            spix++;
            out_val = dpix_val;
            genlock_buf[dpix] = get_genlock_transparency(spix_val);
            buf[dpix++] = out_val;
        }
    }

    return spix;
}
#endif

#ifdef AGA
static int NOINLINE __attribute__((__unused__)) linetoscr_32_stretch1_aga(int spix, int dpix, int dpix_end)
{
    uae_u32 *buf = (uae_u32 *) xlinebuffer;
    uae_u8 xor_val = bplxor;

    if (bplham) {
        while (dpix < dpix_end) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix] ^ xor_val;
            spix_val = ham_linebuf[spix];
            dpix_val = CONVERT_RGB (spix_val);
            spix++;
            out_val = dpix_val;
            buf[dpix++] = out_val;
            buf[dpix++] = out_val;
        }
    } else if (bpldualpf) {
        int *lookup    = bpldualpfpri ? dblpf_ind2_aga : dblpf_ind1_aga;
        int *lookup_no = bpldualpfpri ? dblpf_2nd2     : dblpf_2nd1;
        while (dpix < dpix_end) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix];
            {
                uae_u8 val = lookup[spix_val];
                if (lookup_no[spix_val])
                    val += dblpfofs[bpldualpf2of];
                val ^= xor_val;
                dpix_val = colors_for_drawing.acolors[val];
            }
            spix++;
            out_val = dpix_val;
            buf[dpix++] = out_val;
            buf[dpix++] = out_val;
        }
    } else if (bplehb) {
        while (dpix < dpix_end) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix] ^ xor_val;
            if (spix_val >= 32 && spix_val < 64) {
                unsigned int c = (colors_for_drawing.color_regs_aga[spix_val - 32] >> 1) & 0x7F7F7F;
                dpix_val = CONVERT_RGB (c);
            } else
                dpix_val = colors_for_drawing.acolors[spix_val];
            spix++;
            out_val = dpix_val;
            buf[dpix++] = out_val;
            buf[dpix++] = out_val;
        }
    } else {
        while (dpix < dpix_end) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix] ^ xor_val;
            dpix_val = colors_for_drawing.acolors[spix_val];
            spix++;
            out_val = dpix_val;
            buf[dpix++] = out_val;
            buf[dpix++] = out_val;
        }
    }

    return spix;
}
#endif

#ifdef AGA
static int NOINLINE __attribute__((__unused__)) linetoscr_32_stretch1_aga_genlock(int spix, int dpix, int dpix_end)
{
    uae_u32 *buf = (uae_u32 *) xlinebuffer;
    uae_u8 *genlock_buf = xlinebuffer_genlock;
    uae_u8 xor_val = bplxor;

    if (bplham) {
        while (dpix < dpix_end) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix] ^ xor_val;
            spix_val = ham_linebuf[spix];
            dpix_val = CONVERT_RGB (spix_val);
            spix++;
            out_val = dpix_val;
            genlock_buf[dpix] = get_genlock_transparency((spix_val >> 2) & 63);
            genlock_buf[dpix + 1] = get_genlock_transparency((spix_val >> 2) & 63);
            buf[dpix++] = out_val;
            buf[dpix++] = out_val;
        }
    } else if (bpldualpf) {
        int *lookup    = bpldualpfpri ? dblpf_ind2_aga : dblpf_ind1_aga;
        int *lookup_no = bpldualpfpri ? dblpf_2nd2     : dblpf_2nd1;
        while (dpix < dpix_end) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix];
            {
                uae_u8 val = lookup[spix_val];
                if (lookup_no[spix_val])
                    val += dblpfofs[bpldualpf2of];
                val ^= xor_val;
                dpix_val = colors_for_drawing.acolors[val];
            }
            spix++;
            out_val = dpix_val;
            genlock_buf[dpix] = get_genlock_transparency(lookup[spix_val]);
            genlock_buf[dpix + 1] = get_genlock_transparency(lookup[spix_val]);
            buf[dpix++] = out_val;
            buf[dpix++] = out_val;
        }
    } else if (bplehb) {
        while (dpix < dpix_end) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix] ^ xor_val;
            if (spix_val >= 32 && spix_val < 64) {
                unsigned int c = (colors_for_drawing.color_regs_aga[spix_val - 32] >> 1) & 0x7F7F7F;
                dpix_val = CONVERT_RGB (c);
            } else
                dpix_val = colors_for_drawing.acolors[spix_val];
            spix++;
            out_val = dpix_val;
            genlock_buf[dpix] = get_genlock_transparency(spix_val & 31);
            genlock_buf[dpix + 1] = get_genlock_transparency(spix_val & 31);
            buf[dpix++] = out_val;
            buf[dpix++] = out_val;
        }
    } else {
        while (dpix < dpix_end) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix] ^ xor_val;
            dpix_val = colors_for_drawing.acolors[spix_val];
            spix++;
            out_val = dpix_val;
            genlock_buf[dpix] = get_genlock_transparency(spix_val);
            genlock_buf[dpix + 1] = get_genlock_transparency(spix_val);
            buf[dpix++] = out_val;
            buf[dpix++] = out_val;
        }
    }

    return spix;
}
#endif

#ifdef AGA
static int NOINLINE __attribute__((__unused__)) linetoscr_32_stretch2_aga(int spix, int dpix, int dpix_end)
{
    uae_u32 *buf = (uae_u32 *) xlinebuffer;
    uae_u8 xor_val = bplxor;

    if (bplham) {
        while (dpix < dpix_end) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix] ^ xor_val;
            spix_val = ham_linebuf[spix];
            dpix_val = CONVERT_RGB (spix_val);
            spix++;
            out_val = dpix_val;
            buf[dpix++] = out_val;
            buf[dpix++] = out_val;
            buf[dpix++] = out_val;
            buf[dpix++] = out_val;
        }
    } else if (bpldualpf) {
        int *lookup    = bpldualpfpri ? dblpf_ind2_aga : dblpf_ind1_aga;
        int *lookup_no = bpldualpfpri ? dblpf_2nd2     : dblpf_2nd1;
        while (dpix < dpix_end) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix];
            {
                uae_u8 val = lookup[spix_val];
                if (lookup_no[spix_val])
                    val += dblpfofs[bpldualpf2of];
                val ^= xor_val;
                dpix_val = colors_for_drawing.acolors[val];
            }
            spix++;
            out_val = dpix_val;
            buf[dpix++] = out_val;
            buf[dpix++] = out_val;
            buf[dpix++] = out_val;
            buf[dpix++] = out_val;
        }
    } else if (bplehb) {
        while (dpix < dpix_end) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix] ^ xor_val;
            if (spix_val >= 32 && spix_val < 64) {
                unsigned int c = (colors_for_drawing.color_regs_aga[spix_val - 32] >> 1) & 0x7F7F7F;
                dpix_val = CONVERT_RGB (c);
            } else
                dpix_val = colors_for_drawing.acolors[spix_val];
            spix++;
            out_val = dpix_val;
            buf[dpix++] = out_val;
            buf[dpix++] = out_val;
            buf[dpix++] = out_val;
            buf[dpix++] = out_val;
        }
    } else {
        while (dpix < dpix_end) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix] ^ xor_val;
            dpix_val = colors_for_drawing.acolors[spix_val];
            spix++;
            out_val = dpix_val;
            buf[dpix++] = out_val;
            buf[dpix++] = out_val;
            buf[dpix++] = out_val;
            buf[dpix++] = out_val;
        }
    }

    return spix;
}
#endif

#ifdef AGA
static int NOINLINE __attribute__((__unused__)) linetoscr_32_stretch2_aga_genlock(int spix, int dpix, int dpix_end)
{
    uae_u32 *buf = (uae_u32 *) xlinebuffer;
    uae_u8 *genlock_buf = xlinebuffer_genlock;
    uae_u8 xor_val = bplxor;

    if (bplham) {
        while (dpix < dpix_end) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix] ^ xor_val;
            spix_val = ham_linebuf[spix];
            dpix_val = CONVERT_RGB (spix_val);
            spix++;
            out_val = dpix_val;
            genlock_buf[dpix] = get_genlock_transparency((spix_val >> 2) & 63);
            genlock_buf[dpix + 1] = get_genlock_transparency((spix_val >> 2) & 63);
            genlock_buf[dpix + 2] = get_genlock_transparency((spix_val >> 2) & 63);
            genlock_buf[dpix + 3] = get_genlock_transparency((spix_val >> 2) & 63);
            buf[dpix++] = out_val;
            buf[dpix++] = out_val;
            buf[dpix++] = out_val;
            buf[dpix++] = out_val;
        }
    } else if (bpldualpf) {
        int *lookup    = bpldualpfpri ? dblpf_ind2_aga : dblpf_ind1_aga;
        int *lookup_no = bpldualpfpri ? dblpf_2nd2     : dblpf_2nd1;
        while (dpix < dpix_end) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix];
            {
                uae_u8 val = lookup[spix_val];
                if (lookup_no[spix_val])
                    val += dblpfofs[bpldualpf2of];
                val ^= xor_val;
                dpix_val = colors_for_drawing.acolors[val];
            }
            spix++;
            out_val = dpix_val;
            genlock_buf[dpix] = get_genlock_transparency(lookup[spix_val]);
            genlock_buf[dpix + 1] = get_genlock_transparency(lookup[spix_val]);
            genlock_buf[dpix + 2] = get_genlock_transparency(lookup[spix_val]);
            genlock_buf[dpix + 3] = get_genlock_transparency(lookup[spix_val]);
            buf[dpix++] = out_val;
            buf[dpix++] = out_val;
            buf[dpix++] = out_val;
            buf[dpix++] = out_val;
        }
    } else if (bplehb) {
        while (dpix < dpix_end) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix] ^ xor_val;
            if (spix_val >= 32 && spix_val < 64) {
                unsigned int c = (colors_for_drawing.color_regs_aga[spix_val - 32] >> 1) & 0x7F7F7F;
                dpix_val = CONVERT_RGB (c);
            } else
                dpix_val = colors_for_drawing.acolors[spix_val];
            spix++;
            out_val = dpix_val;
            genlock_buf[dpix] = get_genlock_transparency(spix_val & 31);
            genlock_buf[dpix + 1] = get_genlock_transparency(spix_val & 31);
            genlock_buf[dpix + 2] = get_genlock_transparency(spix_val & 31);
            genlock_buf[dpix + 3] = get_genlock_transparency(spix_val & 31);
            buf[dpix++] = out_val;
            buf[dpix++] = out_val;
            buf[dpix++] = out_val;
            buf[dpix++] = out_val;
        }
    } else {
        while (dpix < dpix_end) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix] ^ xor_val;
            dpix_val = colors_for_drawing.acolors[spix_val];
            spix++;
            out_val = dpix_val;
            genlock_buf[dpix] = get_genlock_transparency(spix_val);
            genlock_buf[dpix + 1] = get_genlock_transparency(spix_val);
            genlock_buf[dpix + 2] = get_genlock_transparency(spix_val);
            genlock_buf[dpix + 3] = get_genlock_transparency(spix_val);
            buf[dpix++] = out_val;
            buf[dpix++] = out_val;
            buf[dpix++] = out_val;
            buf[dpix++] = out_val;
        }
    }

    return spix;
}
#endif

#ifdef AGA
static int NOINLINE __attribute__((__unused__)) linetoscr_32_shrink1_aga(int spix, int dpix, int dpix_end)
{
    uae_u32 *buf = (uae_u32 *) xlinebuffer;
    uae_u8 xor_val = bplxor;

    if (bplham) {
        while (dpix < dpix_end) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix] ^ xor_val;
            spix_val = ham_linebuf[spix];
            dpix_val = CONVERT_RGB (spix_val);
            spix += 2;
            out_val = dpix_val;
            buf[dpix++] = out_val;
        }
    } else if (bpldualpf) {
        int *lookup    = bpldualpfpri ? dblpf_ind2_aga : dblpf_ind1_aga;
        int *lookup_no = bpldualpfpri ? dblpf_2nd2     : dblpf_2nd1;
        while (dpix < dpix_end) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix];
            {
                uae_u8 val = lookup[spix_val];
                if (lookup_no[spix_val])
                    val += dblpfofs[bpldualpf2of];
                val ^= xor_val;
                dpix_val = colors_for_drawing.acolors[val];
            }
            spix += 2;
            out_val = dpix_val;
            buf[dpix++] = out_val;
        }
    } else if (bplehb) {
        while (dpix < dpix_end) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix] ^ xor_val;
            if (spix_val >= 32 && spix_val < 64) {
                unsigned int c = (colors_for_drawing.color_regs_aga[spix_val - 32] >> 1) & 0x7F7F7F;
                dpix_val = CONVERT_RGB (c);
            } else
                dpix_val = colors_for_drawing.acolors[spix_val];
            spix += 2;
            out_val = dpix_val;
            buf[dpix++] = out_val;
        }
    } else {
        while (dpix < dpix_end) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix] ^ xor_val;
            dpix_val = colors_for_drawing.acolors[spix_val];
            spix += 2;
            out_val = dpix_val;
            buf[dpix++] = out_val;
        }
    }

    return spix;
}
#endif

#ifdef AGA
static int NOINLINE __attribute__((__unused__)) linetoscr_32_shrink1_aga_genlock(int spix, int dpix, int dpix_end)
{
    uae_u32 *buf = (uae_u32 *) xlinebuffer;
    uae_u8 *genlock_buf = xlinebuffer_genlock;
    uae_u8 xor_val = bplxor;

    if (bplham) {
        while (dpix < dpix_end) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix] ^ xor_val;
            spix_val = ham_linebuf[spix];
            dpix_val = CONVERT_RGB (spix_val);
            spix += 2;
            out_val = dpix_val;
            genlock_buf[dpix] = get_genlock_transparency((spix_val >> 2) & 63);
            buf[dpix++] = out_val;
        }
    } else if (bpldualpf) {
        int *lookup    = bpldualpfpri ? dblpf_ind2_aga : dblpf_ind1_aga;
        int *lookup_no = bpldualpfpri ? dblpf_2nd2     : dblpf_2nd1;
        while (dpix < dpix_end) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix];
            {
                uae_u8 val = lookup[spix_val];
                if (lookup_no[spix_val])
                    val += dblpfofs[bpldualpf2of];
                val ^= xor_val;
                dpix_val = colors_for_drawing.acolors[val];
            }
            spix += 2;
            out_val = dpix_val;
            genlock_buf[dpix] = get_genlock_transparency(lookup[spix_val]);
            buf[dpix++] = out_val;
        }
    } else if (bplehb) {
        while (dpix < dpix_end) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix] ^ xor_val;
            if (spix_val >= 32 && spix_val < 64) {
                unsigned int c = (colors_for_drawing.color_regs_aga[spix_val - 32] >> 1) & 0x7F7F7F;
                dpix_val = CONVERT_RGB (c);
            } else
                dpix_val = colors_for_drawing.acolors[spix_val];
            spix += 2;
            out_val = dpix_val;
            genlock_buf[dpix] = get_genlock_transparency(spix_val & 31);
            buf[dpix++] = out_val;
        }
    } else {
        while (dpix < dpix_end) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix] ^ xor_val;
            dpix_val = colors_for_drawing.acolors[spix_val];
            spix += 2;
            out_val = dpix_val;
            genlock_buf[dpix] = get_genlock_transparency(spix_val);
            buf[dpix++] = out_val;
        }
    }

    return spix;
}
#endif

#ifdef AGA
static int NOINLINE __attribute__((__unused__)) linetoscr_32_shrink1f_aga(int spix, int dpix, int dpix_end)
{
    uae_u32 *buf = (uae_u32 *) xlinebuffer;
    uae_u8 xor_val = bplxor;

    if (bplham) {
        while (dpix < dpix_end) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix] ^ xor_val;
            spix_val = ham_linebuf[spix];
            dpix_val = CONVERT_RGB (spix_val);
            {
            uae_u32 tmp_val;
            spix++;
            tmp_val = dpix_val;
            spix_val = pixdata.apixels[spix] ^ xor_val;
            spix_val = ham_linebuf[spix];
            dpix_val = CONVERT_RGB (spix_val);
            dpix_val = merge_2pixel32 (dpix_val, tmp_val);
            spix++;
            }
            out_val = dpix_val;
            buf[dpix++] = out_val;
        }
    } else if (bpldualpf) {
        int *lookup    = bpldualpfpri ? dblpf_ind2_aga : dblpf_ind1_aga;
        int *lookup_no = bpldualpfpri ? dblpf_2nd2     : dblpf_2nd1;
        while (dpix < dpix_end) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix];
            {
                uae_u8 val = lookup[spix_val];
                if (lookup_no[spix_val])
                    val += dblpfofs[bpldualpf2of];
                val ^= xor_val;
                dpix_val = colors_for_drawing.acolors[val];
            }
            {
            uae_u32 tmp_val;
            spix++;
            tmp_val = dpix_val;
            spix_val = pixdata.apixels[spix];
            {
                uae_u8 val = lookup[spix_val];
                if (lookup_no[spix_val])
                    val += dblpfofs[bpldualpf2of];
                val ^= xor_val;
                dpix_val = colors_for_drawing.acolors[val];
            }
            dpix_val = merge_2pixel32 (dpix_val, tmp_val);
            spix++;
            }
            out_val = dpix_val;
            buf[dpix++] = out_val;
        }
    } else if (bplehb) {
        while (dpix < dpix_end) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix] ^ xor_val;
            if (spix_val >= 32 && spix_val < 64) {
                unsigned int c = (colors_for_drawing.color_regs_aga[spix_val - 32] >> 1) & 0x7F7F7F;
                dpix_val = CONVERT_RGB (c);
            } else
                dpix_val = colors_for_drawing.acolors[spix_val];
            {
            uae_u32 tmp_val;
            spix++;
            tmp_val = dpix_val;
            spix_val = pixdata.apixels[spix] ^ xor_val;
            if (spix_val >= 32 && spix_val < 64) {
                unsigned int c = (colors_for_drawing.color_regs_aga[spix_val - 32] >> 1) & 0x7F7F7F;
                dpix_val = CONVERT_RGB (c);
            } else
                dpix_val = colors_for_drawing.acolors[spix_val];
            dpix_val = merge_2pixel32 (dpix_val, tmp_val);
            spix++;
            }
            out_val = dpix_val;
            buf[dpix++] = out_val;
        }
    } else {
        while (dpix < dpix_end) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix] ^ xor_val;
            dpix_val = colors_for_drawing.acolors[spix_val];
            {
            uae_u32 tmp_val;
            spix++;
            tmp_val = dpix_val;
            spix_val = pixdata.apixels[spix] ^ xor_val;
            dpix_val = colors_for_drawing.acolors[spix_val];
            dpix_val = merge_2pixel32 (dpix_val, tmp_val);
            spix++;
            }
            out_val = dpix_val;
            buf[dpix++] = out_val;
        }
    }

    return spix;
}
#endif

#ifdef AGA
static int NOINLINE __attribute__((__unused__)) linetoscr_32_shrink1f_aga_genlock(int spix, int dpix, int dpix_end)
{
    uae_u32 *buf = (uae_u32 *) xlinebuffer;
    uae_u8 *genlock_buf = xlinebuffer_genlock;
    uae_u8 xor_val = bplxor;

    if (bplham) {
        while (dpix < dpix_end) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix] ^ xor_val;
            spix_val = ham_linebuf[spix];
            dpix_val = CONVERT_RGB (spix_val);
            {
            uae_u32 tmp_val;
            spix++;
            tmp_val = dpix_val;
            spix_val = pixdata.apixels[spix] ^ xor_val;
            spix_val = ham_linebuf[spix];
            dpix_val = CONVERT_RGB (spix_val);
            dpix_val = merge_2pixel32 (dpix_val, tmp_val);
            spix++;
            }
            out_val = dpix_val;
            genlock_buf[dpix] = get_genlock_transparency((spix_val >> 2) & 63);
            buf[dpix++] = out_val;
        }
    } else if (bpldualpf) {
        int *lookup    = bpldualpfpri ? dblpf_ind2_aga : dblpf_ind1_aga;
        int *lookup_no = bpldualpfpri ? dblpf_2nd2     : dblpf_2nd1;
        while (dpix < dpix_end) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix];
            {
                uae_u8 val = lookup[spix_val];
                if (lookup_no[spix_val])
                    val += dblpfofs[bpldualpf2of];
                val ^= xor_val;
                dpix_val = colors_for_drawing.acolors[val];
            }
            {
            uae_u32 tmp_val;
            spix++;
            tmp_val = dpix_val;
            spix_val = pixdata.apixels[spix];
            {
                uae_u8 val = lookup[spix_val];
                if (lookup_no[spix_val])
                    val += dblpfofs[bpldualpf2of];
                val ^= xor_val;
                dpix_val = colors_for_drawing.acolors[val];
            }
            dpix_val = merge_2pixel32 (dpix_val, tmp_val);
            spix++;
            }
            out_val = dpix_val;
            genlock_buf[dpix] = get_genlock_transparency(lookup[spix_val]);
            buf[dpix++] = out_val;
        }
    } else if (bplehb) {
        while (dpix < dpix_end) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix] ^ xor_val;
            if (spix_val >= 32 && spix_val < 64) {
                unsigned int c = (colors_for_drawing.color_regs_aga[spix_val - 32] >> 1) & 0x7F7F7F;
                dpix_val = CONVERT_RGB (c);
            } else
                dpix_val = colors_for_drawing.acolors[spix_val];
            {
            uae_u32 tmp_val;
            spix++;
            tmp_val = dpix_val;
            spix_val = pixdata.apixels[spix] ^ xor_val;
            if (spix_val >= 32 && spix_val < 64) {
                unsigned int c = (colors_for_drawing.color_regs_aga[spix_val - 32] >> 1) & 0x7F7F7F;
                dpix_val = CONVERT_RGB (c);
            } else
                dpix_val = colors_for_drawing.acolors[spix_val];
            dpix_val = merge_2pixel32 (dpix_val, tmp_val);
            spix++;
            }
            out_val = dpix_val;
            genlock_buf[dpix] = get_genlock_transparency(spix_val & 31);
            buf[dpix++] = out_val;
        }
    } else {
        while (dpix < dpix_end) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix] ^ xor_val;
            dpix_val = colors_for_drawing.acolors[spix_val];
            {
            uae_u32 tmp_val;
            spix++;
            tmp_val = dpix_val;
            spix_val = pixdata.apixels[spix] ^ xor_val;
            dpix_val = colors_for_drawing.acolors[spix_val];
            dpix_val = merge_2pixel32 (dpix_val, tmp_val);
            spix++;
            }
            out_val = dpix_val;
            genlock_buf[dpix] = get_genlock_transparency(spix_val);
            buf[dpix++] = out_val;
        }
    }

    return spix;
}
#endif

#ifdef AGA
static int NOINLINE __attribute__((__unused__)) linetoscr_32_shrink2_aga(int spix, int dpix, int dpix_end)
{
    uae_u32 *buf = (uae_u32 *) xlinebuffer;
    uae_u8 xor_val = bplxor;

    if (bplham) {
        while (dpix < dpix_end) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix] ^ xor_val;
            spix_val = ham_linebuf[spix];
            dpix_val = CONVERT_RGB (spix_val);
            spix += 4;
            out_val = dpix_val;
            buf[dpix++] = out_val;
        }
    } else if (bpldualpf) {
        int *lookup    = bpldualpfpri ? dblpf_ind2_aga : dblpf_ind1_aga;
        int *lookup_no = bpldualpfpri ? dblpf_2nd2     : dblpf_2nd1;
        while (dpix < dpix_end) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix];
            {
                uae_u8 val = lookup[spix_val];
                if (lookup_no[spix_val])
                    val += dblpfofs[bpldualpf2of];
                val ^= xor_val;
                dpix_val = colors_for_drawing.acolors[val];
            }
            spix += 4;
            out_val = dpix_val;
            buf[dpix++] = out_val;
        }
    } else if (bplehb) {
        while (dpix < dpix_end) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix] ^ xor_val;
            if (spix_val >= 32 && spix_val < 64) {
                unsigned int c = (colors_for_drawing.color_regs_aga[spix_val - 32] >> 1) & 0x7F7F7F;
                dpix_val = CONVERT_RGB (c);
            } else
                dpix_val = colors_for_drawing.acolors[spix_val];
            spix += 4;
            out_val = dpix_val;
            buf[dpix++] = out_val;
        }
    } else {
        while (dpix < dpix_end) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix] ^ xor_val;
            dpix_val = colors_for_drawing.acolors[spix_val];
            spix += 4;
            out_val = dpix_val;
            buf[dpix++] = out_val;
        }
    }

    return spix;
}
#endif

#ifdef AGA
static int NOINLINE __attribute__((__unused__)) linetoscr_32_shrink2_aga_genlock(int spix, int dpix, int dpix_end)
{
    uae_u32 *buf = (uae_u32 *) xlinebuffer;
    uae_u8 *genlock_buf = xlinebuffer_genlock;
    uae_u8 xor_val = bplxor;

    if (bplham) {
        while (dpix < dpix_end) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix] ^ xor_val;
            spix_val = ham_linebuf[spix];
            dpix_val = CONVERT_RGB (spix_val);
            spix += 4;
            out_val = dpix_val;
            genlock_buf[dpix] = get_genlock_transparency((spix_val >> 2) & 63);
            buf[dpix++] = out_val;
        }
    } else if (bpldualpf) {
        int *lookup    = bpldualpfpri ? dblpf_ind2_aga : dblpf_ind1_aga;
        int *lookup_no = bpldualpfpri ? dblpf_2nd2     : dblpf_2nd1;
        while (dpix < dpix_end) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix];
            {
                uae_u8 val = lookup[spix_val];
                if (lookup_no[spix_val])
                    val += dblpfofs[bpldualpf2of];
                val ^= xor_val;
                dpix_val = colors_for_drawing.acolors[val];
            }
            spix += 4;
            out_val = dpix_val;
            genlock_buf[dpix] = get_genlock_transparency(lookup[spix_val]);
            buf[dpix++] = out_val;
        }
    } else if (bplehb) {
        while (dpix < dpix_end) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix] ^ xor_val;
            if (spix_val >= 32 && spix_val < 64) {
                unsigned int c = (colors_for_drawing.color_regs_aga[spix_val - 32] >> 1) & 0x7F7F7F;
                dpix_val = CONVERT_RGB (c);
            } else
                dpix_val = colors_for_drawing.acolors[spix_val];
            spix += 4;
            out_val = dpix_val;
            genlock_buf[dpix] = get_genlock_transparency(spix_val & 31);
            buf[dpix++] = out_val;
        }
    } else {
        while (dpix < dpix_end) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix] ^ xor_val;
            dpix_val = colors_for_drawing.acolors[spix_val];
            spix += 4;
            out_val = dpix_val;
            genlock_buf[dpix] = get_genlock_transparency(spix_val);
            buf[dpix++] = out_val;
        }
    }

    return spix;
}
#endif

#ifdef AGA
static int NOINLINE __attribute__((__unused__)) linetoscr_32_shrink2f_aga(int spix, int dpix, int dpix_end)
{
    uae_u32 *buf = (uae_u32 *) xlinebuffer;
    uae_u8 xor_val = bplxor;

    if (bplham) {
        while (dpix < dpix_end) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix] ^ xor_val;
            spix_val = ham_linebuf[spix];
            dpix_val = CONVERT_RGB (spix_val);
            {
            uae_u32 tmp_val, tmp_val2, tmp_val3;
            spix++;
            tmp_val = dpix_val;
            spix_val = pixdata.apixels[spix] ^ xor_val;
            spix_val = ham_linebuf[spix];
            dpix_val = CONVERT_RGB (spix_val);
            spix++;
            tmp_val2 = dpix_val;
            spix_val = pixdata.apixels[spix] ^ xor_val;
            spix_val = ham_linebuf[spix];
            dpix_val = CONVERT_RGB (spix_val);
            spix++;
            tmp_val3 = dpix_val;
            spix_val = pixdata.apixels[spix] ^ xor_val;
            spix_val = ham_linebuf[spix];
            dpix_val = CONVERT_RGB (spix_val);
            tmp_val = merge_2pixel32 (tmp_val, tmp_val2);
            tmp_val2 = merge_2pixel32 (tmp_val3, dpix_val);
            dpix_val = merge_2pixel32 (tmp_val, tmp_val2);
            spix++;
            }
            out_val = dpix_val;
            buf[dpix++] = out_val;
        }
    } else if (bpldualpf) {
        int *lookup    = bpldualpfpri ? dblpf_ind2_aga : dblpf_ind1_aga;
        int *lookup_no = bpldualpfpri ? dblpf_2nd2     : dblpf_2nd1;
        while (dpix < dpix_end) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix];
            {
                uae_u8 val = lookup[spix_val];
                if (lookup_no[spix_val])
                    val += dblpfofs[bpldualpf2of];
                val ^= xor_val;
                dpix_val = colors_for_drawing.acolors[val];
            }
            {
            uae_u32 tmp_val, tmp_val2, tmp_val3;
            spix++;
            tmp_val = dpix_val;
            spix_val = pixdata.apixels[spix];
            {
                uae_u8 val = lookup[spix_val];
                if (lookup_no[spix_val])
                    val += dblpfofs[bpldualpf2of];
                val ^= xor_val;
                dpix_val = colors_for_drawing.acolors[val];
            }
            spix++;
            tmp_val2 = dpix_val;
            spix_val = pixdata.apixels[spix];
            {
                uae_u8 val = lookup[spix_val];
                if (lookup_no[spix_val])
                    val += dblpfofs[bpldualpf2of];
                val ^= xor_val;
                dpix_val = colors_for_drawing.acolors[val];
            }
            spix++;
            tmp_val3 = dpix_val;
            spix_val = pixdata.apixels[spix];
            {
                uae_u8 val = lookup[spix_val];
                if (lookup_no[spix_val])
                    val += dblpfofs[bpldualpf2of];
                val ^= xor_val;
                dpix_val = colors_for_drawing.acolors[val];
            }
            tmp_val = merge_2pixel32 (tmp_val, tmp_val2);
            tmp_val2 = merge_2pixel32 (tmp_val3, dpix_val);
            dpix_val = merge_2pixel32 (tmp_val, tmp_val2);
            spix++;
            }
            out_val = dpix_val;
            buf[dpix++] = out_val;
        }
    } else if (bplehb) {
        while (dpix < dpix_end) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix] ^ xor_val;
            if (spix_val >= 32 && spix_val < 64) {
                unsigned int c = (colors_for_drawing.color_regs_aga[spix_val - 32] >> 1) & 0x7F7F7F;
                dpix_val = CONVERT_RGB (c);
            } else
                dpix_val = colors_for_drawing.acolors[spix_val];
            {
            uae_u32 tmp_val, tmp_val2, tmp_val3;
            spix++;
            tmp_val = dpix_val;
            spix_val = pixdata.apixels[spix] ^ xor_val;
            if (spix_val >= 32 && spix_val < 64) {
                unsigned int c = (colors_for_drawing.color_regs_aga[spix_val - 32] >> 1) & 0x7F7F7F;
                dpix_val = CONVERT_RGB (c);
            } else
                dpix_val = colors_for_drawing.acolors[spix_val];
            spix++;
            tmp_val2 = dpix_val;
            spix_val = pixdata.apixels[spix] ^ xor_val;
            if (spix_val >= 32 && spix_val < 64) {
                unsigned int c = (colors_for_drawing.color_regs_aga[spix_val - 32] >> 1) & 0x7F7F7F;
                dpix_val = CONVERT_RGB (c);
            } else
                dpix_val = colors_for_drawing.acolors[spix_val];
            spix++;
            tmp_val3 = dpix_val;
            spix_val = pixdata.apixels[spix] ^ xor_val;
            if (spix_val >= 32 && spix_val < 64) {
                unsigned int c = (colors_for_drawing.color_regs_aga[spix_val - 32] >> 1) & 0x7F7F7F;
                dpix_val = CONVERT_RGB (c);
            } else
                dpix_val = colors_for_drawing.acolors[spix_val];
            tmp_val = merge_2pixel32 (tmp_val, tmp_val2);
            tmp_val2 = merge_2pixel32 (tmp_val3, dpix_val);
            dpix_val = merge_2pixel32 (tmp_val, tmp_val2);
            spix++;
            }
            out_val = dpix_val;
            buf[dpix++] = out_val;
        }
    } else {
        while (dpix < dpix_end) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix] ^ xor_val;
            dpix_val = colors_for_drawing.acolors[spix_val];
            {
            uae_u32 tmp_val, tmp_val2, tmp_val3;
            spix++;
            tmp_val = dpix_val;
            spix_val = pixdata.apixels[spix] ^ xor_val;
            dpix_val = colors_for_drawing.acolors[spix_val];
            spix++;
            tmp_val2 = dpix_val;
            spix_val = pixdata.apixels[spix] ^ xor_val;
            dpix_val = colors_for_drawing.acolors[spix_val];
            spix++;
            tmp_val3 = dpix_val;
            spix_val = pixdata.apixels[spix] ^ xor_val;
            dpix_val = colors_for_drawing.acolors[spix_val];
            tmp_val = merge_2pixel32 (tmp_val, tmp_val2);
            tmp_val2 = merge_2pixel32 (tmp_val3, dpix_val);
            dpix_val = merge_2pixel32 (tmp_val, tmp_val2);
            spix++;
            }
            out_val = dpix_val;
            buf[dpix++] = out_val;
        }
    }

    return spix;
}
#endif

#ifdef AGA
static int NOINLINE __attribute__((__unused__)) linetoscr_32_shrink2f_aga_genlock(int spix, int dpix, int dpix_end)
{
    uae_u32 *buf = (uae_u32 *) xlinebuffer;
    uae_u8 *genlock_buf = xlinebuffer_genlock;
    uae_u8 xor_val = bplxor;

    if (bplham) {
        while (dpix < dpix_end) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix] ^ xor_val;
            spix_val = ham_linebuf[spix];
            dpix_val = CONVERT_RGB (spix_val);
            {
            uae_u32 tmp_val, tmp_val2, tmp_val3;
            spix++;
            tmp_val = dpix_val;
            spix_val = pixdata.apixels[spix] ^ xor_val;
            spix_val = ham_linebuf[spix];
            dpix_val = CONVERT_RGB (spix_val);
            spix++;
            tmp_val2 = dpix_val;
            spix_val = pixdata.apixels[spix] ^ xor_val;
            spix_val = ham_linebuf[spix];
            dpix_val = CONVERT_RGB (spix_val);
            spix++;
            tmp_val3 = dpix_val;
            spix_val = pixdata.apixels[spix] ^ xor_val;
            spix_val = ham_linebuf[spix];
            dpix_val = CONVERT_RGB (spix_val);
            tmp_val = merge_2pixel32 (tmp_val, tmp_val2);
            tmp_val2 = merge_2pixel32 (tmp_val3, dpix_val);
            dpix_val = merge_2pixel32 (tmp_val, tmp_val2);
            spix++;
            }
            out_val = dpix_val;
            genlock_buf[dpix] = get_genlock_transparency((spix_val >> 2) & 63);
            buf[dpix++] = out_val;
        }
    } else if (bpldualpf) {
        int *lookup    = bpldualpfpri ? dblpf_ind2_aga : dblpf_ind1_aga;
        int *lookup_no = bpldualpfpri ? dblpf_2nd2     : dblpf_2nd1;
        while (dpix < dpix_end) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix];
            {
                uae_u8 val = lookup[spix_val];
                if (lookup_no[spix_val])
                    val += dblpfofs[bpldualpf2of];
                val ^= xor_val;
                dpix_val = colors_for_drawing.acolors[val];
            }
            {
            uae_u32 tmp_val, tmp_val2, tmp_val3;
            spix++;
            tmp_val = dpix_val;
            spix_val = pixdata.apixels[spix];
            {
                uae_u8 val = lookup[spix_val];
                if (lookup_no[spix_val])
                    val += dblpfofs[bpldualpf2of];
                val ^= xor_val;
                dpix_val = colors_for_drawing.acolors[val];
            }
            spix++;
            tmp_val2 = dpix_val;
            spix_val = pixdata.apixels[spix];
            {
                uae_u8 val = lookup[spix_val];
                if (lookup_no[spix_val])
                    val += dblpfofs[bpldualpf2of];
                val ^= xor_val;
                dpix_val = colors_for_drawing.acolors[val];
            }
            spix++;
            tmp_val3 = dpix_val;
            spix_val = pixdata.apixels[spix];
            {
                uae_u8 val = lookup[spix_val];
                if (lookup_no[spix_val])
                    val += dblpfofs[bpldualpf2of];
                val ^= xor_val;
                dpix_val = colors_for_drawing.acolors[val];
            }
            tmp_val = merge_2pixel32 (tmp_val, tmp_val2);
            tmp_val2 = merge_2pixel32 (tmp_val3, dpix_val);
            dpix_val = merge_2pixel32 (tmp_val, tmp_val2);
            spix++;
            }
            out_val = dpix_val;
            genlock_buf[dpix] = get_genlock_transparency(lookup[spix_val]);
            buf[dpix++] = out_val;
        }
    } else if (bplehb) {
        while (dpix < dpix_end) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix] ^ xor_val;
            if (spix_val >= 32 && spix_val < 64) {
                unsigned int c = (colors_for_drawing.color_regs_aga[spix_val - 32] >> 1) & 0x7F7F7F;
                dpix_val = CONVERT_RGB (c);
            } else
                dpix_val = colors_for_drawing.acolors[spix_val];
            {
            uae_u32 tmp_val, tmp_val2, tmp_val3;
            spix++;
            tmp_val = dpix_val;
            spix_val = pixdata.apixels[spix] ^ xor_val;
            if (spix_val >= 32 && spix_val < 64) {
                unsigned int c = (colors_for_drawing.color_regs_aga[spix_val - 32] >> 1) & 0x7F7F7F;
                dpix_val = CONVERT_RGB (c);
            } else
                dpix_val = colors_for_drawing.acolors[spix_val];
            spix++;
            tmp_val2 = dpix_val;
            spix_val = pixdata.apixels[spix] ^ xor_val;
            if (spix_val >= 32 && spix_val < 64) {
                unsigned int c = (colors_for_drawing.color_regs_aga[spix_val - 32] >> 1) & 0x7F7F7F;
                dpix_val = CONVERT_RGB (c);
            } else
                dpix_val = colors_for_drawing.acolors[spix_val];
            spix++;
            tmp_val3 = dpix_val;
            spix_val = pixdata.apixels[spix] ^ xor_val;
            if (spix_val >= 32 && spix_val < 64) {
                unsigned int c = (colors_for_drawing.color_regs_aga[spix_val - 32] >> 1) & 0x7F7F7F;
                dpix_val = CONVERT_RGB (c);
            } else
                dpix_val = colors_for_drawing.acolors[spix_val];
            tmp_val = merge_2pixel32 (tmp_val, tmp_val2);
            tmp_val2 = merge_2pixel32 (tmp_val3, dpix_val);
            dpix_val = merge_2pixel32 (tmp_val, tmp_val2);
            spix++;
            }
            out_val = dpix_val;
            genlock_buf[dpix] = get_genlock_transparency(spix_val & 31);
            buf[dpix++] = out_val;
        }
    } else {
        while (dpix < dpix_end) {
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix] ^ xor_val;
            dpix_val = colors_for_drawing.acolors[spix_val];
            {
            uae_u32 tmp_val, tmp_val2, tmp_val3;
            spix++;
            tmp_val = dpix_val;
            spix_val = pixdata.apixels[spix] ^ xor_val;
            dpix_val = colors_for_drawing.acolors[spix_val];
            spix++;
            tmp_val2 = dpix_val;
            spix_val = pixdata.apixels[spix] ^ xor_val;
            dpix_val = colors_for_drawing.acolors[spix_val];
            spix++;
            tmp_val3 = dpix_val;
            spix_val = pixdata.apixels[spix] ^ xor_val;
            dpix_val = colors_for_drawing.acolors[spix_val];
            tmp_val = merge_2pixel32 (tmp_val, tmp_val2);
            tmp_val2 = merge_2pixel32 (tmp_val3, dpix_val);
            dpix_val = merge_2pixel32 (tmp_val, tmp_val2);
            spix++;
            }
            out_val = dpix_val;
            genlock_buf[dpix] = get_genlock_transparency(spix_val);
            buf[dpix++] = out_val;
        }
    }

    return spix;
}
#endif

#ifdef AGA
static int NOINLINE __attribute__((__unused__)) linetoscr_32_aga_spr(int spix, int dpix, int dpix_end)
{
    uae_u32 *buf = (uae_u32 *) xlinebuffer;
    uae_u8 sprcol;
    uae_u8 xor_val = bplxor;

    if (bplham) {
        while (dpix < dpix_end) {
            uae_u32 sprpix_val;
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            sprpix_val = pixdata.apixels[spix];
            spix_val = pixdata.apixels[spix] ^ xor_val;
            spix_val = ham_linebuf[spix];
            dpix_val = CONVERT_RGB (spix_val);
            spix++;
            out_val = dpix_val;
            if (spritepixels[dpix].data) {
                sprcol = render_sprites (dpix + 0, 0, sprpix_val, 1);
                if (sprcol) {
                    out_val = colors_for_drawing.acolors[sprcol];
                }
            }
            buf[dpix++] = out_val;
        }
    } else if (bpldualpf) {
        int *lookup    = bpldualpfpri ? dblpf_ind2_aga : dblpf_ind1_aga;
        int *lookup_no = bpldualpfpri ? dblpf_2nd2     : dblpf_2nd1;
        while (dpix < dpix_end) {
            uae_u32 sprpix_val;
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix];
            sprpix_val = spix_val;
            {
                uae_u8 val = lookup[spix_val];
                if (lookup_no[spix_val])
                    val += dblpfofs[bpldualpf2of];
                val ^= xor_val;
                dpix_val = colors_for_drawing.acolors[val];
            }
            spix++;
            out_val = dpix_val;
            if (spritepixels[dpix].data) {
                sprcol = render_sprites (dpix + 0, 1, sprpix_val, 1);
                if (sprcol) {
                    out_val = colors_for_drawing.acolors[sprcol];
                }
            }
            buf[dpix++] = out_val;
        }
    } else if (bplehb) {
        while (dpix < dpix_end) {
            uae_u32 sprpix_val;
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            sprpix_val = pixdata.apixels[spix];
            spix_val = pixdata.apixels[spix] ^ xor_val;
            if (spix_val >= 32 && spix_val < 64) {
                unsigned int c = (colors_for_drawing.color_regs_aga[spix_val - 32] >> 1) & 0x7F7F7F;
                dpix_val = CONVERT_RGB (c);
            } else
                dpix_val = colors_for_drawing.acolors[spix_val];
            spix++;
            out_val = dpix_val;
            if (spritepixels[dpix].data) {
                sprcol = render_sprites (dpix + 0, 0, sprpix_val, 1);
                if (sprcol) {
                    out_val = colors_for_drawing.acolors[sprcol];
                }
            }
            buf[dpix++] = out_val;
        }
    } else {
        while (dpix < dpix_end) {
            uae_u32 sprpix_val;
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            sprpix_val = pixdata.apixels[spix];
            spix_val = pixdata.apixels[spix] ^ xor_val;
            dpix_val = colors_for_drawing.acolors[spix_val];
            spix++;
            out_val = dpix_val;
            if (spritepixels[dpix].data) {
                sprcol = render_sprites (dpix + 0, 0, sprpix_val, 1);
                if (sprcol) {
                    out_val = colors_for_drawing.acolors[sprcol];
                }
            }
            buf[dpix++] = out_val;
        }
    }

    return spix;
}
#endif

#ifdef AGA
static int NOINLINE __attribute__((__unused__)) linetoscr_32_aga_spr_genlock(int spix, int dpix, int dpix_end)
{
    uae_u32 *buf = (uae_u32 *) xlinebuffer;
    uae_u8 *genlock_buf = xlinebuffer_genlock;
    uae_u8 sprcol;
    uae_u8 xor_val = bplxor;

    if (bplham) {
        while (dpix < dpix_end) {
            uae_u32 sprpix_val;
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            sprpix_val = pixdata.apixels[spix];
            spix_val = pixdata.apixels[spix] ^ xor_val;
            spix_val = ham_linebuf[spix];
            dpix_val = CONVERT_RGB (spix_val);
            spix++;
            out_val = dpix_val;
            genlock_buf[dpix] = get_genlock_transparency((spix_val >> 2) & 63);
            if (spritepixels[dpix].data) {
                sprcol = render_sprites (dpix + 0, 0, sprpix_val, 1);
                if (sprcol) {
                    out_val = colors_for_drawing.acolors[sprcol];
                    genlock_buf[dpix] = get_genlock_transparency(sprcol);
                }
            }
            buf[dpix++] = out_val;
        }
    } else if (bpldualpf) {
        int *lookup    = bpldualpfpri ? dblpf_ind2_aga : dblpf_ind1_aga;
        int *lookup_no = bpldualpfpri ? dblpf_2nd2     : dblpf_2nd1;
        while (dpix < dpix_end) {
            uae_u32 sprpix_val;
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix];
            sprpix_val = spix_val;
            {
                uae_u8 val = lookup[spix_val];
                if (lookup_no[spix_val])
                    val += dblpfofs[bpldualpf2of];
                val ^= xor_val;
                dpix_val = colors_for_drawing.acolors[val];
            }
            spix++;
            out_val = dpix_val;
            genlock_buf[dpix] = get_genlock_transparency(lookup[spix_val]);
            if (spritepixels[dpix].data) {
                sprcol = render_sprites (dpix + 0, 1, sprpix_val, 1);
                if (sprcol) {
                    out_val = colors_for_drawing.acolors[sprcol];
                    genlock_buf[dpix] = get_genlock_transparency(sprcol);
                }
            }
            buf[dpix++] = out_val;
        }
    } else if (bplehb) {
        while (dpix < dpix_end) {
            uae_u32 sprpix_val;
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            sprpix_val = pixdata.apixels[spix];
            spix_val = pixdata.apixels[spix] ^ xor_val;
            if (spix_val >= 32 && spix_val < 64) {
                unsigned int c = (colors_for_drawing.color_regs_aga[spix_val - 32] >> 1) & 0x7F7F7F;
                dpix_val = CONVERT_RGB (c);
            } else
                dpix_val = colors_for_drawing.acolors[spix_val];
            spix++;
            out_val = dpix_val;
            genlock_buf[dpix] = get_genlock_transparency(spix_val & 31);
            if (spritepixels[dpix].data) {
                sprcol = render_sprites (dpix + 0, 0, sprpix_val, 1);
                if (sprcol) {
                    out_val = colors_for_drawing.acolors[sprcol];
                    genlock_buf[dpix] = get_genlock_transparency(sprcol);
                }
            }
            buf[dpix++] = out_val;
        }
    } else {
        while (dpix < dpix_end) {
            uae_u32 sprpix_val;
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            sprpix_val = pixdata.apixels[spix];
            spix_val = pixdata.apixels[spix] ^ xor_val;
            dpix_val = colors_for_drawing.acolors[spix_val];
            spix++;
            out_val = dpix_val;
            genlock_buf[dpix] = get_genlock_transparency(spix_val);
            if (spritepixels[dpix].data) {
                sprcol = render_sprites (dpix + 0, 0, sprpix_val, 1);
                if (sprcol) {
                    out_val = colors_for_drawing.acolors[sprcol];
                    genlock_buf[dpix] = get_genlock_transparency(sprcol);
                }
            }
            buf[dpix++] = out_val;
        }
    }

    return spix;
}
#endif

#ifdef AGA
static int NOINLINE __attribute__((__unused__)) linetoscr_32_stretch1_aga_spr(int spix, int dpix, int dpix_end)
{
    uae_u32 *buf = (uae_u32 *) xlinebuffer;
    uae_u8 sprcol;
    uae_u8 xor_val = bplxor;

    if (bplham) {
        while (dpix < dpix_end) {
            uae_u32 sprpix_val;
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            sprpix_val = pixdata.apixels[spix];
            spix_val = pixdata.apixels[spix] ^ xor_val;
            spix_val = ham_linebuf[spix];
            dpix_val = CONVERT_RGB (spix_val);
            spix++;
            out_val = dpix_val;
            {
            uae_u32 out_val1 = out_val;
            uae_u32 out_val2 = out_val;
            if (spritepixels[dpix + 0].data) {
                sprcol = render_sprites (dpix + 0, 0, sprpix_val, 1);
                if (sprcol) {
                    out_val1 = colors_for_drawing.acolors[sprcol];
                }
            }
            if (spritepixels[dpix + 1].data) {
                sprcol = render_sprites (dpix + 1, 0, sprpix_val, 1);
                if (sprcol) {
                    out_val2 = colors_for_drawing.acolors[sprcol];
                }
            }
            buf[dpix++] = out_val1;
            buf[dpix++] = out_val2;
            }
        }
    } else if (bpldualpf) {
        int *lookup    = bpldualpfpri ? dblpf_ind2_aga : dblpf_ind1_aga;
        int *lookup_no = bpldualpfpri ? dblpf_2nd2     : dblpf_2nd1;
        while (dpix < dpix_end) {
            uae_u32 sprpix_val;
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix];
            sprpix_val = spix_val;
            {
                uae_u8 val = lookup[spix_val];
                if (lookup_no[spix_val])
                    val += dblpfofs[bpldualpf2of];
                val ^= xor_val;
                dpix_val = colors_for_drawing.acolors[val];
            }
            spix++;
            out_val = dpix_val;
            {
            uae_u32 out_val1 = out_val;
            uae_u32 out_val2 = out_val;
            if (spritepixels[dpix + 0].data) {
                sprcol = render_sprites (dpix + 0, 1, sprpix_val, 1);
                if (sprcol) {
                    out_val1 = colors_for_drawing.acolors[sprcol];
                }
            }
            if (spritepixels[dpix + 1].data) {
                sprcol = render_sprites (dpix + 1, 1, sprpix_val, 1);
                if (sprcol) {
                    out_val2 = colors_for_drawing.acolors[sprcol];
                }
            }
            buf[dpix++] = out_val1;
            buf[dpix++] = out_val2;
            }
        }
    } else if (bplehb) {
        while (dpix < dpix_end) {
            uae_u32 sprpix_val;
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            sprpix_val = pixdata.apixels[spix];
            spix_val = pixdata.apixels[spix] ^ xor_val;
            if (spix_val >= 32 && spix_val < 64) {
                unsigned int c = (colors_for_drawing.color_regs_aga[spix_val - 32] >> 1) & 0x7F7F7F;
                dpix_val = CONVERT_RGB (c);
            } else
                dpix_val = colors_for_drawing.acolors[spix_val];
            spix++;
            out_val = dpix_val;
            {
            uae_u32 out_val1 = out_val;
            uae_u32 out_val2 = out_val;
            if (spritepixels[dpix + 0].data) {
                sprcol = render_sprites (dpix + 0, 0, sprpix_val, 1);
                if (sprcol) {
                    out_val1 = colors_for_drawing.acolors[sprcol];
                }
            }
            if (spritepixels[dpix + 1].data) {
                sprcol = render_sprites (dpix + 1, 0, sprpix_val, 1);
                if (sprcol) {
                    out_val2 = colors_for_drawing.acolors[sprcol];
                }
            }
            buf[dpix++] = out_val1;
            buf[dpix++] = out_val2;
            }
        }
    } else {
        while (dpix < dpix_end) {
            uae_u32 sprpix_val;
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            sprpix_val = pixdata.apixels[spix];
            spix_val = pixdata.apixels[spix] ^ xor_val;
            dpix_val = colors_for_drawing.acolors[spix_val];
            spix++;
            out_val = dpix_val;
            {
            uae_u32 out_val1 = out_val;
            uae_u32 out_val2 = out_val;
            if (spritepixels[dpix + 0].data) {
                sprcol = render_sprites (dpix + 0, 0, sprpix_val, 1);
                if (sprcol) {
                    out_val1 = colors_for_drawing.acolors[sprcol];
                }
            }
            if (spritepixels[dpix + 1].data) {
                sprcol = render_sprites (dpix + 1, 0, sprpix_val, 1);
                if (sprcol) {
                    out_val2 = colors_for_drawing.acolors[sprcol];
                }
            }
            buf[dpix++] = out_val1;
            buf[dpix++] = out_val2;
            }
        }
    }

    return spix;
}
#endif

#ifdef AGA
static int NOINLINE __attribute__((__unused__)) linetoscr_32_stretch1_aga_spr_genlock(int spix, int dpix, int dpix_end)
{
    uae_u32 *buf = (uae_u32 *) xlinebuffer;
    uae_u8 *genlock_buf = xlinebuffer_genlock;
    uae_u8 sprcol;
    uae_u8 xor_val = bplxor;

    if (bplham) {
        while (dpix < dpix_end) {
            uae_u32 sprpix_val;
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            sprpix_val = pixdata.apixels[spix];
            spix_val = pixdata.apixels[spix] ^ xor_val;
            spix_val = ham_linebuf[spix];
            dpix_val = CONVERT_RGB (spix_val);
            spix++;
            out_val = dpix_val;
            genlock_buf[dpix] = get_genlock_transparency((spix_val >> 2) & 63);
            genlock_buf[dpix + 1] = get_genlock_transparency((spix_val >> 2) & 63);
            {
            uae_u32 out_val1 = out_val;
            uae_u32 out_val2 = out_val;
            if (spritepixels[dpix + 0].data) {
                sprcol = render_sprites (dpix + 0, 0, sprpix_val, 1);
                if (sprcol) {
                    out_val1 = colors_for_drawing.acolors[sprcol];
                    genlock_buf[dpix] = get_genlock_transparency(sprcol);
                }
            }
            if (spritepixels[dpix + 1].data) {
                sprcol = render_sprites (dpix + 1, 0, sprpix_val, 1);
                if (sprcol) {
                    out_val2 = colors_for_drawing.acolors[sprcol];
                    genlock_buf[dpix + 1] = get_genlock_transparency(sprcol);
                }
            }
            buf[dpix++] = out_val1;
            buf[dpix++] = out_val2;
            }
        }
    } else if (bpldualpf) {
        int *lookup    = bpldualpfpri ? dblpf_ind2_aga : dblpf_ind1_aga;
        int *lookup_no = bpldualpfpri ? dblpf_2nd2     : dblpf_2nd1;
        while (dpix < dpix_end) {
            uae_u32 sprpix_val;
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix];
            sprpix_val = spix_val;
            {
                uae_u8 val = lookup[spix_val];
                if (lookup_no[spix_val])
                    val += dblpfofs[bpldualpf2of];
                val ^= xor_val;
                dpix_val = colors_for_drawing.acolors[val];
            }
            spix++;
            out_val = dpix_val;
            genlock_buf[dpix] = get_genlock_transparency(lookup[spix_val]);
            genlock_buf[dpix + 1] = get_genlock_transparency(lookup[spix_val]);
            {
            uae_u32 out_val1 = out_val;
            uae_u32 out_val2 = out_val;
            if (spritepixels[dpix + 0].data) {
                sprcol = render_sprites (dpix + 0, 1, sprpix_val, 1);
                if (sprcol) {
                    out_val1 = colors_for_drawing.acolors[sprcol];
                    genlock_buf[dpix] = get_genlock_transparency(sprcol);
                }
            }
            if (spritepixels[dpix + 1].data) {
                sprcol = render_sprites (dpix + 1, 1, sprpix_val, 1);
                if (sprcol) {
                    out_val2 = colors_for_drawing.acolors[sprcol];
                    genlock_buf[dpix + 1] = get_genlock_transparency(sprcol);
                }
            }
            buf[dpix++] = out_val1;
            buf[dpix++] = out_val2;
            }
        }
    } else if (bplehb) {
        while (dpix < dpix_end) {
            uae_u32 sprpix_val;
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            sprpix_val = pixdata.apixels[spix];
            spix_val = pixdata.apixels[spix] ^ xor_val;
            if (spix_val >= 32 && spix_val < 64) {
                unsigned int c = (colors_for_drawing.color_regs_aga[spix_val - 32] >> 1) & 0x7F7F7F;
                dpix_val = CONVERT_RGB (c);
            } else
                dpix_val = colors_for_drawing.acolors[spix_val];
            spix++;
            out_val = dpix_val;
            genlock_buf[dpix] = get_genlock_transparency(spix_val & 31);
            genlock_buf[dpix + 1] = get_genlock_transparency(spix_val & 31);
            {
            uae_u32 out_val1 = out_val;
            uae_u32 out_val2 = out_val;
            if (spritepixels[dpix + 0].data) {
                sprcol = render_sprites (dpix + 0, 0, sprpix_val, 1);
                if (sprcol) {
                    out_val1 = colors_for_drawing.acolors[sprcol];
                    genlock_buf[dpix] = get_genlock_transparency(sprcol);
                }
            }
            if (spritepixels[dpix + 1].data) {
                sprcol = render_sprites (dpix + 1, 0, sprpix_val, 1);
                if (sprcol) {
                    out_val2 = colors_for_drawing.acolors[sprcol];
                    genlock_buf[dpix + 1] = get_genlock_transparency(sprcol);
                }
            }
            buf[dpix++] = out_val1;
            buf[dpix++] = out_val2;
            }
        }
    } else {
        while (dpix < dpix_end) {
            uae_u32 sprpix_val;
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            sprpix_val = pixdata.apixels[spix];
            spix_val = pixdata.apixels[spix] ^ xor_val;
            dpix_val = colors_for_drawing.acolors[spix_val];
            spix++;
            out_val = dpix_val;
            genlock_buf[dpix] = get_genlock_transparency(spix_val);
            genlock_buf[dpix + 1] = get_genlock_transparency(spix_val);
            {
            uae_u32 out_val1 = out_val;
            uae_u32 out_val2 = out_val;
            if (spritepixels[dpix + 0].data) {
                sprcol = render_sprites (dpix + 0, 0, sprpix_val, 1);
                if (sprcol) {
                    out_val1 = colors_for_drawing.acolors[sprcol];
                    genlock_buf[dpix] = get_genlock_transparency(sprcol);
                }
            }
            if (spritepixels[dpix + 1].data) {
                sprcol = render_sprites (dpix + 1, 0, sprpix_val, 1);
                if (sprcol) {
                    out_val2 = colors_for_drawing.acolors[sprcol];
                    genlock_buf[dpix + 1] = get_genlock_transparency(sprcol);
                }
            }
            buf[dpix++] = out_val1;
            buf[dpix++] = out_val2;
            }
        }
    }

    return spix;
}
#endif

#ifdef AGA
static int NOINLINE __attribute__((__unused__)) linetoscr_32_stretch2_aga_spr(int spix, int dpix, int dpix_end)
{
    uae_u32 *buf = (uae_u32 *) xlinebuffer;
    uae_u8 sprcol;
    uae_u8 xor_val = bplxor;

    if (bplham) {
        while (dpix < dpix_end) {
            uae_u32 sprpix_val;
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            sprpix_val = pixdata.apixels[spix];
            spix_val = pixdata.apixels[spix] ^ xor_val;
            spix_val = ham_linebuf[spix];
            dpix_val = CONVERT_RGB (spix_val);
            spix++;
            out_val = dpix_val;
            {
            uae_u32 out_val1 = out_val;
            uae_u32 out_val2 = out_val;
            uae_u32 out_val3 = out_val;
            uae_u32 out_val4 = out_val;
            if (spritepixels[dpix + 0].data) {
                sprcol = render_sprites (dpix + 0, 0, sprpix_val, 1);
                if (sprcol) {
                    out_val1 = colors_for_drawing.acolors[sprcol];
                }
            }
            if (spritepixels[dpix + 1].data) {
                sprcol = render_sprites (dpix + 1, 0, sprpix_val, 1);
                if (sprcol) {
                    out_val2 = colors_for_drawing.acolors[sprcol];
                }
            }
            if (spritepixels[dpix + 2].data) {
                sprcol = render_sprites (dpix + 2, 0, sprpix_val, 1);
                if (sprcol) {
                    out_val3 = colors_for_drawing.acolors[sprcol];
                }
            }
            if (spritepixels[dpix + 3].data) {
                sprcol = render_sprites (dpix + 3, 0, sprpix_val, 1);
                if (sprcol) {
                    out_val4 = colors_for_drawing.acolors[sprcol];
                }
            }
            buf[dpix++] = out_val1;
            buf[dpix++] = out_val2;
            buf[dpix++] = out_val3;
            buf[dpix++] = out_val4;
            }
        }
    } else if (bpldualpf) {
        int *lookup    = bpldualpfpri ? dblpf_ind2_aga : dblpf_ind1_aga;
        int *lookup_no = bpldualpfpri ? dblpf_2nd2     : dblpf_2nd1;
        while (dpix < dpix_end) {
            uae_u32 sprpix_val;
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix];
            sprpix_val = spix_val;
            {
                uae_u8 val = lookup[spix_val];
                if (lookup_no[spix_val])
                    val += dblpfofs[bpldualpf2of];
                val ^= xor_val;
                dpix_val = colors_for_drawing.acolors[val];
            }
            spix++;
            out_val = dpix_val;
            {
            uae_u32 out_val1 = out_val;
            uae_u32 out_val2 = out_val;
            uae_u32 out_val3 = out_val;
            uae_u32 out_val4 = out_val;
            if (spritepixels[dpix + 0].data) {
                sprcol = render_sprites (dpix + 0, 1, sprpix_val, 1);
                if (sprcol) {
                    out_val1 = colors_for_drawing.acolors[sprcol];
                }
            }
            if (spritepixels[dpix + 1].data) {
                sprcol = render_sprites (dpix + 1, 1, sprpix_val, 1);
                if (sprcol) {
                    out_val2 = colors_for_drawing.acolors[sprcol];
                }
            }
            if (spritepixels[dpix + 2].data) {
                sprcol = render_sprites (dpix + 2, 1, sprpix_val, 1);
                if (sprcol) {
                    out_val3 = colors_for_drawing.acolors[sprcol];
                }
            }
            if (spritepixels[dpix + 3].data) {
                sprcol = render_sprites (dpix + 3, 1, sprpix_val, 1);
                if (sprcol) {
                    out_val4 = colors_for_drawing.acolors[sprcol];
                }
            }
            buf[dpix++] = out_val1;
            buf[dpix++] = out_val2;
            buf[dpix++] = out_val3;
            buf[dpix++] = out_val4;
            }
        }
    } else if (bplehb) {
        while (dpix < dpix_end) {
            uae_u32 sprpix_val;
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            sprpix_val = pixdata.apixels[spix];
            spix_val = pixdata.apixels[spix] ^ xor_val;
            if (spix_val >= 32 && spix_val < 64) {
                unsigned int c = (colors_for_drawing.color_regs_aga[spix_val - 32] >> 1) & 0x7F7F7F;
                dpix_val = CONVERT_RGB (c);
            } else
                dpix_val = colors_for_drawing.acolors[spix_val];
            spix++;
            out_val = dpix_val;
            {
            uae_u32 out_val1 = out_val;
            uae_u32 out_val2 = out_val;
            uae_u32 out_val3 = out_val;
            uae_u32 out_val4 = out_val;
            if (spritepixels[dpix + 0].data) {
                sprcol = render_sprites (dpix + 0, 0, sprpix_val, 1);
                if (sprcol) {
                    out_val1 = colors_for_drawing.acolors[sprcol];
                }
            }
            if (spritepixels[dpix + 1].data) {
                sprcol = render_sprites (dpix + 1, 0, sprpix_val, 1);
                if (sprcol) {
                    out_val2 = colors_for_drawing.acolors[sprcol];
                }
            }
            if (spritepixels[dpix + 2].data) {
                sprcol = render_sprites (dpix + 2, 0, sprpix_val, 1);
                if (sprcol) {
                    out_val3 = colors_for_drawing.acolors[sprcol];
                }
            }
            if (spritepixels[dpix + 3].data) {
                sprcol = render_sprites (dpix + 3, 0, sprpix_val, 1);
                if (sprcol) {
                    out_val4 = colors_for_drawing.acolors[sprcol];
                }
            }
            buf[dpix++] = out_val1;
            buf[dpix++] = out_val2;
            buf[dpix++] = out_val3;
            buf[dpix++] = out_val4;
            }
        }
    } else {
        while (dpix < dpix_end) {
            uae_u32 sprpix_val;
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            sprpix_val = pixdata.apixels[spix];
            spix_val = pixdata.apixels[spix] ^ xor_val;
            dpix_val = colors_for_drawing.acolors[spix_val];
            spix++;
            out_val = dpix_val;
            {
            uae_u32 out_val1 = out_val;
            uae_u32 out_val2 = out_val;
            uae_u32 out_val3 = out_val;
            uae_u32 out_val4 = out_val;
            if (spritepixels[dpix + 0].data) {
                sprcol = render_sprites (dpix + 0, 0, sprpix_val, 1);
                if (sprcol) {
                    out_val1 = colors_for_drawing.acolors[sprcol];
                }
            }
            if (spritepixels[dpix + 1].data) {
                sprcol = render_sprites (dpix + 1, 0, sprpix_val, 1);
                if (sprcol) {
                    out_val2 = colors_for_drawing.acolors[sprcol];
                }
            }
            if (spritepixels[dpix + 2].data) {
                sprcol = render_sprites (dpix + 2, 0, sprpix_val, 1);
                if (sprcol) {
                    out_val3 = colors_for_drawing.acolors[sprcol];
                }
            }
            if (spritepixels[dpix + 3].data) {
                sprcol = render_sprites (dpix + 3, 0, sprpix_val, 1);
                if (sprcol) {
                    out_val4 = colors_for_drawing.acolors[sprcol];
                }
            }
            buf[dpix++] = out_val1;
            buf[dpix++] = out_val2;
            buf[dpix++] = out_val3;
            buf[dpix++] = out_val4;
            }
        }
    }

    return spix;
}
#endif

#ifdef AGA
static int NOINLINE __attribute__((__unused__)) linetoscr_32_stretch2_aga_spr_genlock(int spix, int dpix, int dpix_end)
{
    uae_u32 *buf = (uae_u32 *) xlinebuffer;
    uae_u8 *genlock_buf = xlinebuffer_genlock;
    uae_u8 sprcol;
    uae_u8 xor_val = bplxor;

    if (bplham) {
        while (dpix < dpix_end) {
            uae_u32 sprpix_val;
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            sprpix_val = pixdata.apixels[spix];
            spix_val = pixdata.apixels[spix] ^ xor_val;
            spix_val = ham_linebuf[spix];
            dpix_val = CONVERT_RGB (spix_val);
            spix++;
            out_val = dpix_val;
            genlock_buf[dpix] = get_genlock_transparency((spix_val >> 2) & 63);
            genlock_buf[dpix + 1] = get_genlock_transparency((spix_val >> 2) & 63);
            genlock_buf[dpix + 2] = get_genlock_transparency((spix_val >> 2) & 63);
            genlock_buf[dpix + 3] = get_genlock_transparency((spix_val >> 2) & 63);
            {
            uae_u32 out_val1 = out_val;
            uae_u32 out_val2 = out_val;
            uae_u32 out_val3 = out_val;
            uae_u32 out_val4 = out_val;
            if (spritepixels[dpix + 0].data) {
                sprcol = render_sprites (dpix + 0, 0, sprpix_val, 1);
                if (sprcol) {
                    out_val1 = colors_for_drawing.acolors[sprcol];
                    genlock_buf[dpix] = get_genlock_transparency(sprcol);
                }
            }
            if (spritepixels[dpix + 1].data) {
                sprcol = render_sprites (dpix + 1, 0, sprpix_val, 1);
                if (sprcol) {
                    out_val2 = colors_for_drawing.acolors[sprcol];
                    genlock_buf[dpix + 1] = get_genlock_transparency(sprcol);
                }
            }
            if (spritepixels[dpix + 2].data) {
                sprcol = render_sprites (dpix + 2, 0, sprpix_val, 1);
                if (sprcol) {
                    out_val3 = colors_for_drawing.acolors[sprcol];
                    genlock_buf[dpix + 2] = get_genlock_transparency(sprcol);
                }
            }
            if (spritepixels[dpix + 3].data) {
                sprcol = render_sprites (dpix + 3, 0, sprpix_val, 1);
                if (sprcol) {
                    out_val4 = colors_for_drawing.acolors[sprcol];
                    genlock_buf[dpix + 3] = get_genlock_transparency(sprcol);
                }
            }
            buf[dpix++] = out_val1;
            buf[dpix++] = out_val2;
            buf[dpix++] = out_val3;
            buf[dpix++] = out_val4;
            }
        }
    } else if (bpldualpf) {
        int *lookup    = bpldualpfpri ? dblpf_ind2_aga : dblpf_ind1_aga;
        int *lookup_no = bpldualpfpri ? dblpf_2nd2     : dblpf_2nd1;
        while (dpix < dpix_end) {
            uae_u32 sprpix_val;
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix];
            sprpix_val = spix_val;
            {
                uae_u8 val = lookup[spix_val];
                if (lookup_no[spix_val])
                    val += dblpfofs[bpldualpf2of];
                val ^= xor_val;
                dpix_val = colors_for_drawing.acolors[val];
            }
            spix++;
            out_val = dpix_val;
            genlock_buf[dpix] = get_genlock_transparency(lookup[spix_val]);
            genlock_buf[dpix + 1] = get_genlock_transparency(lookup[spix_val]);
            genlock_buf[dpix + 2] = get_genlock_transparency(lookup[spix_val]);
            genlock_buf[dpix + 3] = get_genlock_transparency(lookup[spix_val]);
            {
            uae_u32 out_val1 = out_val;
            uae_u32 out_val2 = out_val;
            uae_u32 out_val3 = out_val;
            uae_u32 out_val4 = out_val;
            if (spritepixels[dpix + 0].data) {
                sprcol = render_sprites (dpix + 0, 1, sprpix_val, 1);
                if (sprcol) {
                    out_val1 = colors_for_drawing.acolors[sprcol];
                    genlock_buf[dpix] = get_genlock_transparency(sprcol);
                }
            }
            if (spritepixels[dpix + 1].data) {
                sprcol = render_sprites (dpix + 1, 1, sprpix_val, 1);
                if (sprcol) {
                    out_val2 = colors_for_drawing.acolors[sprcol];
                    genlock_buf[dpix + 1] = get_genlock_transparency(sprcol);
                }
            }
            if (spritepixels[dpix + 2].data) {
                sprcol = render_sprites (dpix + 2, 1, sprpix_val, 1);
                if (sprcol) {
                    out_val3 = colors_for_drawing.acolors[sprcol];
                    genlock_buf[dpix + 2] = get_genlock_transparency(sprcol);
                }
            }
            if (spritepixels[dpix + 3].data) {
                sprcol = render_sprites (dpix + 3, 1, sprpix_val, 1);
                if (sprcol) {
                    out_val4 = colors_for_drawing.acolors[sprcol];
                    genlock_buf[dpix + 3] = get_genlock_transparency(sprcol);
                }
            }
            buf[dpix++] = out_val1;
            buf[dpix++] = out_val2;
            buf[dpix++] = out_val3;
            buf[dpix++] = out_val4;
            }
        }
    } else if (bplehb) {
        while (dpix < dpix_end) {
            uae_u32 sprpix_val;
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            sprpix_val = pixdata.apixels[spix];
            spix_val = pixdata.apixels[spix] ^ xor_val;
            if (spix_val >= 32 && spix_val < 64) {
                unsigned int c = (colors_for_drawing.color_regs_aga[spix_val - 32] >> 1) & 0x7F7F7F;
                dpix_val = CONVERT_RGB (c);
            } else
                dpix_val = colors_for_drawing.acolors[spix_val];
            spix++;
            out_val = dpix_val;
            genlock_buf[dpix] = get_genlock_transparency(spix_val & 31);
            genlock_buf[dpix + 1] = get_genlock_transparency(spix_val & 31);
            genlock_buf[dpix + 2] = get_genlock_transparency(spix_val & 31);
            genlock_buf[dpix + 3] = get_genlock_transparency(spix_val & 31);
            {
            uae_u32 out_val1 = out_val;
            uae_u32 out_val2 = out_val;
            uae_u32 out_val3 = out_val;
            uae_u32 out_val4 = out_val;
            if (spritepixels[dpix + 0].data) {
                sprcol = render_sprites (dpix + 0, 0, sprpix_val, 1);
                if (sprcol) {
                    out_val1 = colors_for_drawing.acolors[sprcol];
                    genlock_buf[dpix] = get_genlock_transparency(sprcol);
                }
            }
            if (spritepixels[dpix + 1].data) {
                sprcol = render_sprites (dpix + 1, 0, sprpix_val, 1);
                if (sprcol) {
                    out_val2 = colors_for_drawing.acolors[sprcol];
                    genlock_buf[dpix + 1] = get_genlock_transparency(sprcol);
                }
            }
            if (spritepixels[dpix + 2].data) {
                sprcol = render_sprites (dpix + 2, 0, sprpix_val, 1);
                if (sprcol) {
                    out_val3 = colors_for_drawing.acolors[sprcol];
                    genlock_buf[dpix + 2] = get_genlock_transparency(sprcol);
                }
            }
            if (spritepixels[dpix + 3].data) {
                sprcol = render_sprites (dpix + 3, 0, sprpix_val, 1);
                if (sprcol) {
                    out_val4 = colors_for_drawing.acolors[sprcol];
                    genlock_buf[dpix + 3] = get_genlock_transparency(sprcol);
                }
            }
            buf[dpix++] = out_val1;
            buf[dpix++] = out_val2;
            buf[dpix++] = out_val3;
            buf[dpix++] = out_val4;
            }
        }
    } else {
        while (dpix < dpix_end) {
            uae_u32 sprpix_val;
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            sprpix_val = pixdata.apixels[spix];
            spix_val = pixdata.apixels[spix] ^ xor_val;
            dpix_val = colors_for_drawing.acolors[spix_val];
            spix++;
            out_val = dpix_val;
            genlock_buf[dpix] = get_genlock_transparency(spix_val);
            genlock_buf[dpix + 1] = get_genlock_transparency(spix_val);
            genlock_buf[dpix + 2] = get_genlock_transparency(spix_val);
            genlock_buf[dpix + 3] = get_genlock_transparency(spix_val);
            {
            uae_u32 out_val1 = out_val;
            uae_u32 out_val2 = out_val;
            uae_u32 out_val3 = out_val;
            uae_u32 out_val4 = out_val;
            if (spritepixels[dpix + 0].data) {
                sprcol = render_sprites (dpix + 0, 0, sprpix_val, 1);
                if (sprcol) {
                    out_val1 = colors_for_drawing.acolors[sprcol];
                    genlock_buf[dpix] = get_genlock_transparency(sprcol);
                }
            }
            if (spritepixels[dpix + 1].data) {
                sprcol = render_sprites (dpix + 1, 0, sprpix_val, 1);
                if (sprcol) {
                    out_val2 = colors_for_drawing.acolors[sprcol];
                    genlock_buf[dpix + 1] = get_genlock_transparency(sprcol);
                }
            }
            if (spritepixels[dpix + 2].data) {
                sprcol = render_sprites (dpix + 2, 0, sprpix_val, 1);
                if (sprcol) {
                    out_val3 = colors_for_drawing.acolors[sprcol];
                    genlock_buf[dpix + 2] = get_genlock_transparency(sprcol);
                }
            }
            if (spritepixels[dpix + 3].data) {
                sprcol = render_sprites (dpix + 3, 0, sprpix_val, 1);
                if (sprcol) {
                    out_val4 = colors_for_drawing.acolors[sprcol];
                    genlock_buf[dpix + 3] = get_genlock_transparency(sprcol);
                }
            }
            buf[dpix++] = out_val1;
            buf[dpix++] = out_val2;
            buf[dpix++] = out_val3;
            buf[dpix++] = out_val4;
            }
        }
    }

    return spix;
}
#endif

#ifdef AGA
static int NOINLINE __attribute__((__unused__)) linetoscr_32_shrink1_aga_spr(int spix, int dpix, int dpix_end)
{
    uae_u32 *buf = (uae_u32 *) xlinebuffer;
    uae_u8 sprcol;
    uae_u8 xor_val = bplxor;

    if (bplham) {
        while (dpix < dpix_end) {
            uae_u32 sprpix_val;
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            sprpix_val = pixdata.apixels[spix];
            spix_val = pixdata.apixels[spix] ^ xor_val;
            spix_val = ham_linebuf[spix];
            dpix_val = CONVERT_RGB (spix_val);
            spix += 2;
            out_val = dpix_val;
            if (spritepixels[dpix].data) {
                sprcol = render_sprites (dpix + 0, 0, sprpix_val, 1);
                if (sprcol) {
                    out_val = colors_for_drawing.acolors[sprcol];
                }
            }
            buf[dpix++] = out_val;
        }
    } else if (bpldualpf) {
        int *lookup    = bpldualpfpri ? dblpf_ind2_aga : dblpf_ind1_aga;
        int *lookup_no = bpldualpfpri ? dblpf_2nd2     : dblpf_2nd1;
        while (dpix < dpix_end) {
            uae_u32 sprpix_val;
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix];
            sprpix_val = spix_val;
            {
                uae_u8 val = lookup[spix_val];
                if (lookup_no[spix_val])
                    val += dblpfofs[bpldualpf2of];
                val ^= xor_val;
                dpix_val = colors_for_drawing.acolors[val];
            }
            spix += 2;
            out_val = dpix_val;
            if (spritepixels[dpix].data) {
                sprcol = render_sprites (dpix + 0, 1, sprpix_val, 1);
                if (sprcol) {
                    out_val = colors_for_drawing.acolors[sprcol];
                }
            }
            buf[dpix++] = out_val;
        }
    } else if (bplehb) {
        while (dpix < dpix_end) {
            uae_u32 sprpix_val;
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            sprpix_val = pixdata.apixels[spix];
            spix_val = pixdata.apixels[spix] ^ xor_val;
            if (spix_val >= 32 && spix_val < 64) {
                unsigned int c = (colors_for_drawing.color_regs_aga[spix_val - 32] >> 1) & 0x7F7F7F;
                dpix_val = CONVERT_RGB (c);
            } else
                dpix_val = colors_for_drawing.acolors[spix_val];
            spix += 2;
            out_val = dpix_val;
            if (spritepixels[dpix].data) {
                sprcol = render_sprites (dpix + 0, 0, sprpix_val, 1);
                if (sprcol) {
                    out_val = colors_for_drawing.acolors[sprcol];
                }
            }
            buf[dpix++] = out_val;
        }
    } else {
        while (dpix < dpix_end) {
            uae_u32 sprpix_val;
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            sprpix_val = pixdata.apixels[spix];
            spix_val = pixdata.apixels[spix] ^ xor_val;
            dpix_val = colors_for_drawing.acolors[spix_val];
            spix += 2;
            out_val = dpix_val;
            if (spritepixels[dpix].data) {
                sprcol = render_sprites (dpix + 0, 0, sprpix_val, 1);
                if (sprcol) {
                    out_val = colors_for_drawing.acolors[sprcol];
                }
            }
            buf[dpix++] = out_val;
        }
    }

    return spix;
}
#endif

#ifdef AGA
static int NOINLINE __attribute__((__unused__)) linetoscr_32_shrink1_aga_spr_genlock(int spix, int dpix, int dpix_end)
{
    uae_u32 *buf = (uae_u32 *) xlinebuffer;
    uae_u8 *genlock_buf = xlinebuffer_genlock;
    uae_u8 sprcol;
    uae_u8 xor_val = bplxor;

    if (bplham) {
        while (dpix < dpix_end) {
            uae_u32 sprpix_val;
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            sprpix_val = pixdata.apixels[spix];
            spix_val = pixdata.apixels[spix] ^ xor_val;
            spix_val = ham_linebuf[spix];
            dpix_val = CONVERT_RGB (spix_val);
            spix += 2;
            out_val = dpix_val;
            genlock_buf[dpix] = get_genlock_transparency((spix_val >> 2) & 63);
            if (spritepixels[dpix].data) {
                sprcol = render_sprites (dpix + 0, 0, sprpix_val, 1);
                if (sprcol) {
                    out_val = colors_for_drawing.acolors[sprcol];
                    genlock_buf[dpix] = get_genlock_transparency(sprcol);
                }
            }
            buf[dpix++] = out_val;
        }
    } else if (bpldualpf) {
        int *lookup    = bpldualpfpri ? dblpf_ind2_aga : dblpf_ind1_aga;
        int *lookup_no = bpldualpfpri ? dblpf_2nd2     : dblpf_2nd1;
        while (dpix < dpix_end) {
            uae_u32 sprpix_val;
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix];
            sprpix_val = spix_val;
            {
                uae_u8 val = lookup[spix_val];
                if (lookup_no[spix_val])
                    val += dblpfofs[bpldualpf2of];
                val ^= xor_val;
                dpix_val = colors_for_drawing.acolors[val];
            }
            spix += 2;
            out_val = dpix_val;
            genlock_buf[dpix] = get_genlock_transparency(lookup[spix_val]);
            if (spritepixels[dpix].data) {
                sprcol = render_sprites (dpix + 0, 1, sprpix_val, 1);
                if (sprcol) {
                    out_val = colors_for_drawing.acolors[sprcol];
                    genlock_buf[dpix] = get_genlock_transparency(sprcol);
                }
            }
            buf[dpix++] = out_val;
        }
    } else if (bplehb) {
        while (dpix < dpix_end) {
            uae_u32 sprpix_val;
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            sprpix_val = pixdata.apixels[spix];
            spix_val = pixdata.apixels[spix] ^ xor_val;
            if (spix_val >= 32 && spix_val < 64) {
                unsigned int c = (colors_for_drawing.color_regs_aga[spix_val - 32] >> 1) & 0x7F7F7F;
                dpix_val = CONVERT_RGB (c);
            } else
                dpix_val = colors_for_drawing.acolors[spix_val];
            spix += 2;
            out_val = dpix_val;
            genlock_buf[dpix] = get_genlock_transparency(spix_val & 31);
            if (spritepixels[dpix].data) {
                sprcol = render_sprites (dpix + 0, 0, sprpix_val, 1);
                if (sprcol) {
                    out_val = colors_for_drawing.acolors[sprcol];
                    genlock_buf[dpix] = get_genlock_transparency(sprcol);
                }
            }
            buf[dpix++] = out_val;
        }
    } else {
        while (dpix < dpix_end) {
            uae_u32 sprpix_val;
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            sprpix_val = pixdata.apixels[spix];
            spix_val = pixdata.apixels[spix] ^ xor_val;
            dpix_val = colors_for_drawing.acolors[spix_val];
            spix += 2;
            out_val = dpix_val;
            genlock_buf[dpix] = get_genlock_transparency(spix_val);
            if (spritepixels[dpix].data) {
                sprcol = render_sprites (dpix + 0, 0, sprpix_val, 1);
                if (sprcol) {
                    out_val = colors_for_drawing.acolors[sprcol];
                    genlock_buf[dpix] = get_genlock_transparency(sprcol);
                }
            }
            buf[dpix++] = out_val;
        }
    }

    return spix;
}
#endif

#ifdef AGA
static int NOINLINE __attribute__((__unused__)) linetoscr_32_shrink1f_aga_spr(int spix, int dpix, int dpix_end)
{
    uae_u32 *buf = (uae_u32 *) xlinebuffer;
    uae_u8 sprcol;
    uae_u8 xor_val = bplxor;

    if (bplham) {
        while (dpix < dpix_end) {
            uae_u32 sprpix_val;
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            sprpix_val = pixdata.apixels[spix];
            spix_val = pixdata.apixels[spix] ^ xor_val;
            spix_val = ham_linebuf[spix];
            dpix_val = CONVERT_RGB (spix_val);
            {
            uae_u32 tmp_val;
            spix++;
            tmp_val = dpix_val;
            sprpix_val = pixdata.apixels[spix];
            spix_val = pixdata.apixels[spix] ^ xor_val;
            spix_val = ham_linebuf[spix];
            dpix_val = CONVERT_RGB (spix_val);
            dpix_val = merge_2pixel32 (dpix_val, tmp_val);
            spix++;
            }
            out_val = dpix_val;
            if (spritepixels[dpix].data) {
                sprcol = render_sprites (dpix + 0, 0, sprpix_val, 1);
                if (sprcol) {
                    out_val = colors_for_drawing.acolors[sprcol];
                }
            }
            buf[dpix++] = out_val;
        }
    } else if (bpldualpf) {
        int *lookup    = bpldualpfpri ? dblpf_ind2_aga : dblpf_ind1_aga;
        int *lookup_no = bpldualpfpri ? dblpf_2nd2     : dblpf_2nd1;
        while (dpix < dpix_end) {
            uae_u32 sprpix_val;
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix];
            sprpix_val = spix_val;
            {
                uae_u8 val = lookup[spix_val];
                if (lookup_no[spix_val])
                    val += dblpfofs[bpldualpf2of];
                val ^= xor_val;
                dpix_val = colors_for_drawing.acolors[val];
            }
            {
            uae_u32 tmp_val;
            spix++;
            tmp_val = dpix_val;
            spix_val = pixdata.apixels[spix];
            sprpix_val = spix_val;
            {
                uae_u8 val = lookup[spix_val];
                if (lookup_no[spix_val])
                    val += dblpfofs[bpldualpf2of];
                val ^= xor_val;
                dpix_val = colors_for_drawing.acolors[val];
            }
            dpix_val = merge_2pixel32 (dpix_val, tmp_val);
            spix++;
            }
            out_val = dpix_val;
            if (spritepixels[dpix].data) {
                sprcol = render_sprites (dpix + 0, 1, sprpix_val, 1);
                if (sprcol) {
                    out_val = colors_for_drawing.acolors[sprcol];
                }
            }
            buf[dpix++] = out_val;
        }
    } else if (bplehb) {
        while (dpix < dpix_end) {
            uae_u32 sprpix_val;
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            sprpix_val = pixdata.apixels[spix];
            spix_val = pixdata.apixels[spix] ^ xor_val;
            if (spix_val >= 32 && spix_val < 64) {
                unsigned int c = (colors_for_drawing.color_regs_aga[spix_val - 32] >> 1) & 0x7F7F7F;
                dpix_val = CONVERT_RGB (c);
            } else
                dpix_val = colors_for_drawing.acolors[spix_val];
            {
            uae_u32 tmp_val;
            spix++;
            tmp_val = dpix_val;
            sprpix_val = pixdata.apixels[spix];
            spix_val = pixdata.apixels[spix] ^ xor_val;
            if (spix_val >= 32 && spix_val < 64) {
                unsigned int c = (colors_for_drawing.color_regs_aga[spix_val - 32] >> 1) & 0x7F7F7F;
                dpix_val = CONVERT_RGB (c);
            } else
                dpix_val = colors_for_drawing.acolors[spix_val];
            dpix_val = merge_2pixel32 (dpix_val, tmp_val);
            spix++;
            }
            out_val = dpix_val;
            if (spritepixels[dpix].data) {
                sprcol = render_sprites (dpix + 0, 0, sprpix_val, 1);
                if (sprcol) {
                    out_val = colors_for_drawing.acolors[sprcol];
                }
            }
            buf[dpix++] = out_val;
        }
    } else {
        while (dpix < dpix_end) {
            uae_u32 sprpix_val;
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            sprpix_val = pixdata.apixels[spix];
            spix_val = pixdata.apixels[spix] ^ xor_val;
            dpix_val = colors_for_drawing.acolors[spix_val];
            {
            uae_u32 tmp_val;
            spix++;
            tmp_val = dpix_val;
            sprpix_val = pixdata.apixels[spix];
            spix_val = pixdata.apixels[spix] ^ xor_val;
            dpix_val = colors_for_drawing.acolors[spix_val];
            dpix_val = merge_2pixel32 (dpix_val, tmp_val);
            spix++;
            }
            out_val = dpix_val;
            if (spritepixels[dpix].data) {
                sprcol = render_sprites (dpix + 0, 0, sprpix_val, 1);
                if (sprcol) {
                    out_val = colors_for_drawing.acolors[sprcol];
                }
            }
            buf[dpix++] = out_val;
        }
    }

    return spix;
}
#endif

#ifdef AGA
static int NOINLINE __attribute__((__unused__)) linetoscr_32_shrink1f_aga_spr_genlock(int spix, int dpix, int dpix_end)
{
    uae_u32 *buf = (uae_u32 *) xlinebuffer;
    uae_u8 *genlock_buf = xlinebuffer_genlock;
    uae_u8 sprcol;
    uae_u8 xor_val = bplxor;

    if (bplham) {
        while (dpix < dpix_end) {
            uae_u32 sprpix_val;
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            sprpix_val = pixdata.apixels[spix];
            spix_val = pixdata.apixels[spix] ^ xor_val;
            spix_val = ham_linebuf[spix];
            dpix_val = CONVERT_RGB (spix_val);
            {
            uae_u32 tmp_val;
            spix++;
            tmp_val = dpix_val;
            sprpix_val = pixdata.apixels[spix];
            spix_val = pixdata.apixels[spix] ^ xor_val;
            spix_val = ham_linebuf[spix];
            dpix_val = CONVERT_RGB (spix_val);
            dpix_val = merge_2pixel32 (dpix_val, tmp_val);
            spix++;
            }
            out_val = dpix_val;
            genlock_buf[dpix] = get_genlock_transparency((spix_val >> 2) & 63);
            if (spritepixels[dpix].data) {
                sprcol = render_sprites (dpix + 0, 0, sprpix_val, 1);
                if (sprcol) {
                    out_val = colors_for_drawing.acolors[sprcol];
                    genlock_buf[dpix] = get_genlock_transparency(sprcol);
                }
            }
            buf[dpix++] = out_val;
        }
    } else if (bpldualpf) {
        int *lookup    = bpldualpfpri ? dblpf_ind2_aga : dblpf_ind1_aga;
        int *lookup_no = bpldualpfpri ? dblpf_2nd2     : dblpf_2nd1;
        while (dpix < dpix_end) {
            uae_u32 sprpix_val;
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix];
            sprpix_val = spix_val;
            {
                uae_u8 val = lookup[spix_val];
                if (lookup_no[spix_val])
                    val += dblpfofs[bpldualpf2of];
                val ^= xor_val;
                dpix_val = colors_for_drawing.acolors[val];
            }
            {
            uae_u32 tmp_val;
            spix++;
            tmp_val = dpix_val;
            spix_val = pixdata.apixels[spix];
            sprpix_val = spix_val;
            {
                uae_u8 val = lookup[spix_val];
                if (lookup_no[spix_val])
                    val += dblpfofs[bpldualpf2of];
                val ^= xor_val;
                dpix_val = colors_for_drawing.acolors[val];
            }
            dpix_val = merge_2pixel32 (dpix_val, tmp_val);
            spix++;
            }
            out_val = dpix_val;
            genlock_buf[dpix] = get_genlock_transparency(lookup[spix_val]);
            if (spritepixels[dpix].data) {
                sprcol = render_sprites (dpix + 0, 1, sprpix_val, 1);
                if (sprcol) {
                    out_val = colors_for_drawing.acolors[sprcol];
                    genlock_buf[dpix] = get_genlock_transparency(sprcol);
                }
            }
            buf[dpix++] = out_val;
        }
    } else if (bplehb) {
        while (dpix < dpix_end) {
            uae_u32 sprpix_val;
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            sprpix_val = pixdata.apixels[spix];
            spix_val = pixdata.apixels[spix] ^ xor_val;
            if (spix_val >= 32 && spix_val < 64) {
                unsigned int c = (colors_for_drawing.color_regs_aga[spix_val - 32] >> 1) & 0x7F7F7F;
                dpix_val = CONVERT_RGB (c);
            } else
                dpix_val = colors_for_drawing.acolors[spix_val];
            {
            uae_u32 tmp_val;
            spix++;
            tmp_val = dpix_val;
            sprpix_val = pixdata.apixels[spix];
            spix_val = pixdata.apixels[spix] ^ xor_val;
            if (spix_val >= 32 && spix_val < 64) {
                unsigned int c = (colors_for_drawing.color_regs_aga[spix_val - 32] >> 1) & 0x7F7F7F;
                dpix_val = CONVERT_RGB (c);
            } else
                dpix_val = colors_for_drawing.acolors[spix_val];
            dpix_val = merge_2pixel32 (dpix_val, tmp_val);
            spix++;
            }
            out_val = dpix_val;
            genlock_buf[dpix] = get_genlock_transparency(spix_val & 31);
            if (spritepixels[dpix].data) {
                sprcol = render_sprites (dpix + 0, 0, sprpix_val, 1);
                if (sprcol) {
                    out_val = colors_for_drawing.acolors[sprcol];
                    genlock_buf[dpix] = get_genlock_transparency(sprcol);
                }
            }
            buf[dpix++] = out_val;
        }
    } else {
        while (dpix < dpix_end) {
            uae_u32 sprpix_val;
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            sprpix_val = pixdata.apixels[spix];
            spix_val = pixdata.apixels[spix] ^ xor_val;
            dpix_val = colors_for_drawing.acolors[spix_val];
            {
            uae_u32 tmp_val;
            spix++;
            tmp_val = dpix_val;
            sprpix_val = pixdata.apixels[spix];
            spix_val = pixdata.apixels[spix] ^ xor_val;
            dpix_val = colors_for_drawing.acolors[spix_val];
            dpix_val = merge_2pixel32 (dpix_val, tmp_val);
            spix++;
            }
            out_val = dpix_val;
            genlock_buf[dpix] = get_genlock_transparency(spix_val);
            if (spritepixels[dpix].data) {
                sprcol = render_sprites (dpix + 0, 0, sprpix_val, 1);
                if (sprcol) {
                    out_val = colors_for_drawing.acolors[sprcol];
                    genlock_buf[dpix] = get_genlock_transparency(sprcol);
                }
            }
            buf[dpix++] = out_val;
        }
    }

    return spix;
}
#endif

#ifdef AGA
static int NOINLINE __attribute__((__unused__)) linetoscr_32_shrink2_aga_spr(int spix, int dpix, int dpix_end)
{
    uae_u32 *buf = (uae_u32 *) xlinebuffer;
    uae_u8 sprcol;
    uae_u8 xor_val = bplxor;

    if (bplham) {
        while (dpix < dpix_end) {
            uae_u32 sprpix_val;
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            sprpix_val = pixdata.apixels[spix];
            spix_val = pixdata.apixels[spix] ^ xor_val;
            spix_val = ham_linebuf[spix];
            dpix_val = CONVERT_RGB (spix_val);
            spix += 4;
            out_val = dpix_val;
            if (spritepixels[dpix].data) {
                sprcol = render_sprites (dpix + 0, 0, sprpix_val, 1);
                if (sprcol) {
                    out_val = colors_for_drawing.acolors[sprcol];
                }
            }
            buf[dpix++] = out_val;
        }
    } else if (bpldualpf) {
        int *lookup    = bpldualpfpri ? dblpf_ind2_aga : dblpf_ind1_aga;
        int *lookup_no = bpldualpfpri ? dblpf_2nd2     : dblpf_2nd1;
        while (dpix < dpix_end) {
            uae_u32 sprpix_val;
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix];
            sprpix_val = spix_val;
            {
                uae_u8 val = lookup[spix_val];
                if (lookup_no[spix_val])
                    val += dblpfofs[bpldualpf2of];
                val ^= xor_val;
                dpix_val = colors_for_drawing.acolors[val];
            }
            spix += 4;
            out_val = dpix_val;
            if (spritepixels[dpix].data) {
                sprcol = render_sprites (dpix + 0, 1, sprpix_val, 1);
                if (sprcol) {
                    out_val = colors_for_drawing.acolors[sprcol];
                }
            }
            buf[dpix++] = out_val;
        }
    } else if (bplehb) {
        while (dpix < dpix_end) {
            uae_u32 sprpix_val;
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            sprpix_val = pixdata.apixels[spix];
            spix_val = pixdata.apixels[spix] ^ xor_val;
            if (spix_val >= 32 && spix_val < 64) {
                unsigned int c = (colors_for_drawing.color_regs_aga[spix_val - 32] >> 1) & 0x7F7F7F;
                dpix_val = CONVERT_RGB (c);
            } else
                dpix_val = colors_for_drawing.acolors[spix_val];
            spix += 4;
            out_val = dpix_val;
            if (spritepixels[dpix].data) {
                sprcol = render_sprites (dpix + 0, 0, sprpix_val, 1);
                if (sprcol) {
                    out_val = colors_for_drawing.acolors[sprcol];
                }
            }
            buf[dpix++] = out_val;
        }
    } else {
        while (dpix < dpix_end) {
            uae_u32 sprpix_val;
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            sprpix_val = pixdata.apixels[spix];
            spix_val = pixdata.apixels[spix] ^ xor_val;
            dpix_val = colors_for_drawing.acolors[spix_val];
            spix += 4;
            out_val = dpix_val;
            if (spritepixels[dpix].data) {
                sprcol = render_sprites (dpix + 0, 0, sprpix_val, 1);
                if (sprcol) {
                    out_val = colors_for_drawing.acolors[sprcol];
                }
            }
            buf[dpix++] = out_val;
        }
    }

    return spix;
}
#endif

#ifdef AGA
static int NOINLINE __attribute__((__unused__)) linetoscr_32_shrink2_aga_spr_genlock(int spix, int dpix, int dpix_end)
{
    uae_u32 *buf = (uae_u32 *) xlinebuffer;
    uae_u8 *genlock_buf = xlinebuffer_genlock;
    uae_u8 sprcol;
    uae_u8 xor_val = bplxor;

    if (bplham) {
        while (dpix < dpix_end) {
            uae_u32 sprpix_val;
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            sprpix_val = pixdata.apixels[spix];
            spix_val = pixdata.apixels[spix] ^ xor_val;
            spix_val = ham_linebuf[spix];
            dpix_val = CONVERT_RGB (spix_val);
            spix += 4;
            out_val = dpix_val;
            genlock_buf[dpix] = get_genlock_transparency((spix_val >> 2) & 63);
            if (spritepixels[dpix].data) {
                sprcol = render_sprites (dpix + 0, 0, sprpix_val, 1);
                if (sprcol) {
                    out_val = colors_for_drawing.acolors[sprcol];
                    genlock_buf[dpix] = get_genlock_transparency(sprcol);
                }
            }
            buf[dpix++] = out_val;
        }
    } else if (bpldualpf) {
        int *lookup    = bpldualpfpri ? dblpf_ind2_aga : dblpf_ind1_aga;
        int *lookup_no = bpldualpfpri ? dblpf_2nd2     : dblpf_2nd1;
        while (dpix < dpix_end) {
            uae_u32 sprpix_val;
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix];
            sprpix_val = spix_val;
            {
                uae_u8 val = lookup[spix_val];
                if (lookup_no[spix_val])
                    val += dblpfofs[bpldualpf2of];
                val ^= xor_val;
                dpix_val = colors_for_drawing.acolors[val];
            }
            spix += 4;
            out_val = dpix_val;
            genlock_buf[dpix] = get_genlock_transparency(lookup[spix_val]);
            if (spritepixels[dpix].data) {
                sprcol = render_sprites (dpix + 0, 1, sprpix_val, 1);
                if (sprcol) {
                    out_val = colors_for_drawing.acolors[sprcol];
                    genlock_buf[dpix] = get_genlock_transparency(sprcol);
                }
            }
            buf[dpix++] = out_val;
        }
    } else if (bplehb) {
        while (dpix < dpix_end) {
            uae_u32 sprpix_val;
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            sprpix_val = pixdata.apixels[spix];
            spix_val = pixdata.apixels[spix] ^ xor_val;
            if (spix_val >= 32 && spix_val < 64) {
                unsigned int c = (colors_for_drawing.color_regs_aga[spix_val - 32] >> 1) & 0x7F7F7F;
                dpix_val = CONVERT_RGB (c);
            } else
                dpix_val = colors_for_drawing.acolors[spix_val];
            spix += 4;
            out_val = dpix_val;
            genlock_buf[dpix] = get_genlock_transparency(spix_val & 31);
            if (spritepixels[dpix].data) {
                sprcol = render_sprites (dpix + 0, 0, sprpix_val, 1);
                if (sprcol) {
                    out_val = colors_for_drawing.acolors[sprcol];
                    genlock_buf[dpix] = get_genlock_transparency(sprcol);
                }
            }
            buf[dpix++] = out_val;
        }
    } else {
        while (dpix < dpix_end) {
            uae_u32 sprpix_val;
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            sprpix_val = pixdata.apixels[spix];
            spix_val = pixdata.apixels[spix] ^ xor_val;
            dpix_val = colors_for_drawing.acolors[spix_val];
            spix += 4;
            out_val = dpix_val;
            genlock_buf[dpix] = get_genlock_transparency(spix_val);
            if (spritepixels[dpix].data) {
                sprcol = render_sprites (dpix + 0, 0, sprpix_val, 1);
                if (sprcol) {
                    out_val = colors_for_drawing.acolors[sprcol];
                    genlock_buf[dpix] = get_genlock_transparency(sprcol);
                }
            }
            buf[dpix++] = out_val;
        }
    }

    return spix;
}
#endif

#ifdef AGA
static int NOINLINE __attribute__((__unused__)) linetoscr_32_shrink2f_aga_spr(int spix, int dpix, int dpix_end)
{
    uae_u32 *buf = (uae_u32 *) xlinebuffer;
    uae_u8 sprcol;
    uae_u8 xor_val = bplxor;

    if (bplham) {
        while (dpix < dpix_end) {
            uae_u32 sprpix_val;
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            sprpix_val = pixdata.apixels[spix];
            spix_val = pixdata.apixels[spix] ^ xor_val;
            spix_val = ham_linebuf[spix];
            dpix_val = CONVERT_RGB (spix_val);
            {
            uae_u32 tmp_val, tmp_val2, tmp_val3;
            spix++;
            tmp_val = dpix_val;
            sprpix_val = pixdata.apixels[spix];
            spix_val = pixdata.apixels[spix] ^ xor_val;
            spix_val = ham_linebuf[spix];
            dpix_val = CONVERT_RGB (spix_val);
            spix++;
            tmp_val2 = dpix_val;
            sprpix_val = pixdata.apixels[spix];
            spix_val = pixdata.apixels[spix] ^ xor_val;
            spix_val = ham_linebuf[spix];
            dpix_val = CONVERT_RGB (spix_val);
            spix++;
            tmp_val3 = dpix_val;
            sprpix_val = pixdata.apixels[spix];
            spix_val = pixdata.apixels[spix] ^ xor_val;
            spix_val = ham_linebuf[spix];
            dpix_val = CONVERT_RGB (spix_val);
            tmp_val = merge_2pixel32 (tmp_val, tmp_val2);
            tmp_val2 = merge_2pixel32 (tmp_val3, dpix_val);
            dpix_val = merge_2pixel32 (tmp_val, tmp_val2);
            spix++;
            }
            out_val = dpix_val;
            if (spritepixels[dpix].data) {
                sprcol = render_sprites (dpix + 0, 0, sprpix_val, 1);
                if (sprcol) {
                    out_val = colors_for_drawing.acolors[sprcol];
                }
            }
            buf[dpix++] = out_val;
        }
    } else if (bpldualpf) {
        int *lookup    = bpldualpfpri ? dblpf_ind2_aga : dblpf_ind1_aga;
        int *lookup_no = bpldualpfpri ? dblpf_2nd2     : dblpf_2nd1;
        while (dpix < dpix_end) {
            uae_u32 sprpix_val;
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix];
            sprpix_val = spix_val;
            {
                uae_u8 val = lookup[spix_val];
                if (lookup_no[spix_val])
                    val += dblpfofs[bpldualpf2of];
                val ^= xor_val;
                dpix_val = colors_for_drawing.acolors[val];
            }
            {
            uae_u32 tmp_val, tmp_val2, tmp_val3;
            spix++;
            tmp_val = dpix_val;
            spix_val = pixdata.apixels[spix];
            sprpix_val = spix_val;
            {
                uae_u8 val = lookup[spix_val];
                if (lookup_no[spix_val])
                    val += dblpfofs[bpldualpf2of];
                val ^= xor_val;
                dpix_val = colors_for_drawing.acolors[val];
            }
            spix++;
            tmp_val2 = dpix_val;
            spix_val = pixdata.apixels[spix];
            sprpix_val = spix_val;
            {
                uae_u8 val = lookup[spix_val];
                if (lookup_no[spix_val])
                    val += dblpfofs[bpldualpf2of];
                val ^= xor_val;
                dpix_val = colors_for_drawing.acolors[val];
            }
            spix++;
            tmp_val3 = dpix_val;
            spix_val = pixdata.apixels[spix];
            sprpix_val = spix_val;
            {
                uae_u8 val = lookup[spix_val];
                if (lookup_no[spix_val])
                    val += dblpfofs[bpldualpf2of];
                val ^= xor_val;
                dpix_val = colors_for_drawing.acolors[val];
            }
            tmp_val = merge_2pixel32 (tmp_val, tmp_val2);
            tmp_val2 = merge_2pixel32 (tmp_val3, dpix_val);
            dpix_val = merge_2pixel32 (tmp_val, tmp_val2);
            spix++;
            }
            out_val = dpix_val;
            if (spritepixels[dpix].data) {
                sprcol = render_sprites (dpix + 0, 1, sprpix_val, 1);
                if (sprcol) {
                    out_val = colors_for_drawing.acolors[sprcol];
                }
            }
            buf[dpix++] = out_val;
        }
    } else if (bplehb) {
        while (dpix < dpix_end) {
            uae_u32 sprpix_val;
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            sprpix_val = pixdata.apixels[spix];
            spix_val = pixdata.apixels[spix] ^ xor_val;
            if (spix_val >= 32 && spix_val < 64) {
                unsigned int c = (colors_for_drawing.color_regs_aga[spix_val - 32] >> 1) & 0x7F7F7F;
                dpix_val = CONVERT_RGB (c);
            } else
                dpix_val = colors_for_drawing.acolors[spix_val];
            {
            uae_u32 tmp_val, tmp_val2, tmp_val3;
            spix++;
            tmp_val = dpix_val;
            sprpix_val = pixdata.apixels[spix];
            spix_val = pixdata.apixels[spix] ^ xor_val;
            if (spix_val >= 32 && spix_val < 64) {
                unsigned int c = (colors_for_drawing.color_regs_aga[spix_val - 32] >> 1) & 0x7F7F7F;
                dpix_val = CONVERT_RGB (c);
            } else
                dpix_val = colors_for_drawing.acolors[spix_val];
            spix++;
            tmp_val2 = dpix_val;
            sprpix_val = pixdata.apixels[spix];
            spix_val = pixdata.apixels[spix] ^ xor_val;
            if (spix_val >= 32 && spix_val < 64) {
                unsigned int c = (colors_for_drawing.color_regs_aga[spix_val - 32] >> 1) & 0x7F7F7F;
                dpix_val = CONVERT_RGB (c);
            } else
                dpix_val = colors_for_drawing.acolors[spix_val];
            spix++;
            tmp_val3 = dpix_val;
            sprpix_val = pixdata.apixels[spix];
            spix_val = pixdata.apixels[spix] ^ xor_val;
            if (spix_val >= 32 && spix_val < 64) {
                unsigned int c = (colors_for_drawing.color_regs_aga[spix_val - 32] >> 1) & 0x7F7F7F;
                dpix_val = CONVERT_RGB (c);
            } else
                dpix_val = colors_for_drawing.acolors[spix_val];
            tmp_val = merge_2pixel32 (tmp_val, tmp_val2);
            tmp_val2 = merge_2pixel32 (tmp_val3, dpix_val);
            dpix_val = merge_2pixel32 (tmp_val, tmp_val2);
            spix++;
            }
            out_val = dpix_val;
            if (spritepixels[dpix].data) {
                sprcol = render_sprites (dpix + 0, 0, sprpix_val, 1);
                if (sprcol) {
                    out_val = colors_for_drawing.acolors[sprcol];
                }
            }
            buf[dpix++] = out_val;
        }
    } else {
        while (dpix < dpix_end) {
            uae_u32 sprpix_val;
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            sprpix_val = pixdata.apixels[spix];
            spix_val = pixdata.apixels[spix] ^ xor_val;
            dpix_val = colors_for_drawing.acolors[spix_val];
            {
            uae_u32 tmp_val, tmp_val2, tmp_val3;
            spix++;
            tmp_val = dpix_val;
            sprpix_val = pixdata.apixels[spix];
            spix_val = pixdata.apixels[spix] ^ xor_val;
            dpix_val = colors_for_drawing.acolors[spix_val];
            spix++;
            tmp_val2 = dpix_val;
            sprpix_val = pixdata.apixels[spix];
            spix_val = pixdata.apixels[spix] ^ xor_val;
            dpix_val = colors_for_drawing.acolors[spix_val];
            spix++;
            tmp_val3 = dpix_val;
            sprpix_val = pixdata.apixels[spix];
            spix_val = pixdata.apixels[spix] ^ xor_val;
            dpix_val = colors_for_drawing.acolors[spix_val];
            tmp_val = merge_2pixel32 (tmp_val, tmp_val2);
            tmp_val2 = merge_2pixel32 (tmp_val3, dpix_val);
            dpix_val = merge_2pixel32 (tmp_val, tmp_val2);
            spix++;
            }
            out_val = dpix_val;
            if (spritepixels[dpix].data) {
                sprcol = render_sprites (dpix + 0, 0, sprpix_val, 1);
                if (sprcol) {
                    out_val = colors_for_drawing.acolors[sprcol];
                }
            }
            buf[dpix++] = out_val;
        }
    }

    return spix;
}
#endif

#ifdef AGA
static int NOINLINE __attribute__((__unused__)) linetoscr_32_shrink2f_aga_spr_genlock(int spix, int dpix, int dpix_end)
{
    uae_u32 *buf = (uae_u32 *) xlinebuffer;
    uae_u8 *genlock_buf = xlinebuffer_genlock;
    uae_u8 sprcol;
    uae_u8 xor_val = bplxor;

    if (bplham) {
        while (dpix < dpix_end) {
            uae_u32 sprpix_val;
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            sprpix_val = pixdata.apixels[spix];
            spix_val = pixdata.apixels[spix] ^ xor_val;
            spix_val = ham_linebuf[spix];
            dpix_val = CONVERT_RGB (spix_val);
            {
            uae_u32 tmp_val, tmp_val2, tmp_val3;
            spix++;
            tmp_val = dpix_val;
            sprpix_val = pixdata.apixels[spix];
            spix_val = pixdata.apixels[spix] ^ xor_val;
            spix_val = ham_linebuf[spix];
            dpix_val = CONVERT_RGB (spix_val);
            spix++;
            tmp_val2 = dpix_val;
            sprpix_val = pixdata.apixels[spix];
            spix_val = pixdata.apixels[spix] ^ xor_val;
            spix_val = ham_linebuf[spix];
            dpix_val = CONVERT_RGB (spix_val);
            spix++;
            tmp_val3 = dpix_val;
            sprpix_val = pixdata.apixels[spix];
            spix_val = pixdata.apixels[spix] ^ xor_val;
            spix_val = ham_linebuf[spix];
            dpix_val = CONVERT_RGB (spix_val);
            tmp_val = merge_2pixel32 (tmp_val, tmp_val2);
            tmp_val2 = merge_2pixel32 (tmp_val3, dpix_val);
            dpix_val = merge_2pixel32 (tmp_val, tmp_val2);
            spix++;
            }
            out_val = dpix_val;
            genlock_buf[dpix] = get_genlock_transparency((spix_val >> 2) & 63);
            if (spritepixels[dpix].data) {
                sprcol = render_sprites (dpix + 0, 0, sprpix_val, 1);
                if (sprcol) {
                    out_val = colors_for_drawing.acolors[sprcol];
                    genlock_buf[dpix] = get_genlock_transparency(sprcol);
                }
            }
            buf[dpix++] = out_val;
        }
    } else if (bpldualpf) {
        int *lookup    = bpldualpfpri ? dblpf_ind2_aga : dblpf_ind1_aga;
        int *lookup_no = bpldualpfpri ? dblpf_2nd2     : dblpf_2nd1;
        while (dpix < dpix_end) {
            uae_u32 sprpix_val;
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            spix_val = pixdata.apixels[spix];
            sprpix_val = spix_val;
            {
                uae_u8 val = lookup[spix_val];
                if (lookup_no[spix_val])
                    val += dblpfofs[bpldualpf2of];
                val ^= xor_val;
                dpix_val = colors_for_drawing.acolors[val];
            }
            {
            uae_u32 tmp_val, tmp_val2, tmp_val3;
            spix++;
            tmp_val = dpix_val;
            spix_val = pixdata.apixels[spix];
            sprpix_val = spix_val;
            {
                uae_u8 val = lookup[spix_val];
                if (lookup_no[spix_val])
                    val += dblpfofs[bpldualpf2of];
                val ^= xor_val;
                dpix_val = colors_for_drawing.acolors[val];
            }
            spix++;
            tmp_val2 = dpix_val;
            spix_val = pixdata.apixels[spix];
            sprpix_val = spix_val;
            {
                uae_u8 val = lookup[spix_val];
                if (lookup_no[spix_val])
                    val += dblpfofs[bpldualpf2of];
                val ^= xor_val;
                dpix_val = colors_for_drawing.acolors[val];
            }
            spix++;
            tmp_val3 = dpix_val;
            spix_val = pixdata.apixels[spix];
            sprpix_val = spix_val;
            {
                uae_u8 val = lookup[spix_val];
                if (lookup_no[spix_val])
                    val += dblpfofs[bpldualpf2of];
                val ^= xor_val;
                dpix_val = colors_for_drawing.acolors[val];
            }
            tmp_val = merge_2pixel32 (tmp_val, tmp_val2);
            tmp_val2 = merge_2pixel32 (tmp_val3, dpix_val);
            dpix_val = merge_2pixel32 (tmp_val, tmp_val2);
            spix++;
            }
            out_val = dpix_val;
            genlock_buf[dpix] = get_genlock_transparency(lookup[spix_val]);
            if (spritepixels[dpix].data) {
                sprcol = render_sprites (dpix + 0, 1, sprpix_val, 1);
                if (sprcol) {
                    out_val = colors_for_drawing.acolors[sprcol];
                    genlock_buf[dpix] = get_genlock_transparency(sprcol);
                }
            }
            buf[dpix++] = out_val;
        }
    } else if (bplehb) {
        while (dpix < dpix_end) {
            uae_u32 sprpix_val;
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            sprpix_val = pixdata.apixels[spix];
            spix_val = pixdata.apixels[spix] ^ xor_val;
            if (spix_val >= 32 && spix_val < 64) {
                unsigned int c = (colors_for_drawing.color_regs_aga[spix_val - 32] >> 1) & 0x7F7F7F;
                dpix_val = CONVERT_RGB (c);
            } else
                dpix_val = colors_for_drawing.acolors[spix_val];
            {
            uae_u32 tmp_val, tmp_val2, tmp_val3;
            spix++;
            tmp_val = dpix_val;
            sprpix_val = pixdata.apixels[spix];
            spix_val = pixdata.apixels[spix] ^ xor_val;
            if (spix_val >= 32 && spix_val < 64) {
                unsigned int c = (colors_for_drawing.color_regs_aga[spix_val - 32] >> 1) & 0x7F7F7F;
                dpix_val = CONVERT_RGB (c);
            } else
                dpix_val = colors_for_drawing.acolors[spix_val];
            spix++;
            tmp_val2 = dpix_val;
            sprpix_val = pixdata.apixels[spix];
            spix_val = pixdata.apixels[spix] ^ xor_val;
            if (spix_val >= 32 && spix_val < 64) {
                unsigned int c = (colors_for_drawing.color_regs_aga[spix_val - 32] >> 1) & 0x7F7F7F;
                dpix_val = CONVERT_RGB (c);
            } else
                dpix_val = colors_for_drawing.acolors[spix_val];
            spix++;
            tmp_val3 = dpix_val;
            sprpix_val = pixdata.apixels[spix];
            spix_val = pixdata.apixels[spix] ^ xor_val;
            if (spix_val >= 32 && spix_val < 64) {
                unsigned int c = (colors_for_drawing.color_regs_aga[spix_val - 32] >> 1) & 0x7F7F7F;
                dpix_val = CONVERT_RGB (c);
            } else
                dpix_val = colors_for_drawing.acolors[spix_val];
            tmp_val = merge_2pixel32 (tmp_val, tmp_val2);
            tmp_val2 = merge_2pixel32 (tmp_val3, dpix_val);
            dpix_val = merge_2pixel32 (tmp_val, tmp_val2);
            spix++;
            }
            out_val = dpix_val;
            genlock_buf[dpix] = get_genlock_transparency(spix_val & 31);
            if (spritepixels[dpix].data) {
                sprcol = render_sprites (dpix + 0, 0, sprpix_val, 1);
                if (sprcol) {
                    out_val = colors_for_drawing.acolors[sprcol];
                    genlock_buf[dpix] = get_genlock_transparency(sprcol);
                }
            }
            buf[dpix++] = out_val;
        }
    } else {
        while (dpix < dpix_end) {
            uae_u32 sprpix_val;
            uae_u32 spix_val;
            uae_u32 dpix_val;
            uae_u32 out_val;
        
            sprpix_val = pixdata.apixels[spix];
            spix_val = pixdata.apixels[spix] ^ xor_val;
            dpix_val = colors_for_drawing.acolors[spix_val];
            {
            uae_u32 tmp_val, tmp_val2, tmp_val3;
            spix++;
            tmp_val = dpix_val;
            sprpix_val = pixdata.apixels[spix];
            spix_val = pixdata.apixels[spix] ^ xor_val;
            dpix_val = colors_for_drawing.acolors[spix_val];
            spix++;
            tmp_val2 = dpix_val;
            sprpix_val = pixdata.apixels[spix];
            spix_val = pixdata.apixels[spix] ^ xor_val;
            dpix_val = colors_for_drawing.acolors[spix_val];
            spix++;
            tmp_val3 = dpix_val;
            sprpix_val = pixdata.apixels[spix];
            spix_val = pixdata.apixels[spix] ^ xor_val;
            dpix_val = colors_for_drawing.acolors[spix_val];
            tmp_val = merge_2pixel32 (tmp_val, tmp_val2);
            tmp_val2 = merge_2pixel32 (tmp_val3, dpix_val);
            dpix_val = merge_2pixel32 (tmp_val, tmp_val2);
            spix++;
            }
            out_val = dpix_val;
            genlock_buf[dpix] = get_genlock_transparency(spix_val);
            if (spritepixels[dpix].data) {
                sprcol = render_sprites (dpix + 0, 0, sprpix_val, 1);
                if (sprcol) {
                    out_val = colors_for_drawing.acolors[sprcol];
                    genlock_buf[dpix] = get_genlock_transparency(sprcol);
                }
            }
            buf[dpix++] = out_val;
        }
    }

    return spix;
}
#endif

