#ifndef WRITEODFNUMBER_H
#define WRITEODFNUMBER_H
#include "writeodf.h"
namespace writeodf {
class number_am_pm : public OdfWriter {
public:
    number_am_pm(OdfWriter* x) :OdfWriter(x, "number:am-pm", false) {
    }
    number_am_pm(KoXmlWriter* x) :OdfWriter(x, "number:am-pm", false) {
    }
    void addTextNode(const QString& data) {
        OdfWriter::addTextNode(data);
    }
};
class number_currency_symbol : public OdfWriter {
public:
    number_currency_symbol(OdfWriter* x) :OdfWriter(x, "number:currency-symbol", false) {
    }
    number_currency_symbol(KoXmlWriter* x) :OdfWriter(x, "number:currency-symbol", false) {
    }
    void set_number_country(const QString& value) {
        addAttribute("number:country", value);
    }
    void set_number_language(const QString& value) {
        addAttribute("number:language", value);
    }
    void set_number_rfc_language_tag(const QString& value) {
        addAttribute("number:rfc-language-tag", value);
    }
    void set_number_script(const QString& value) {
        addAttribute("number:script", value);
    }
    void addTextNode(const QString& data) {
        OdfWriter::addTextNode(data);
    }
};
class number_embedded_text : public OdfWriter {
public:
    number_embedded_text(OdfWriter* x, qint64 number_position) :OdfWriter(x, "number:embedded-text", false) {
        addAttribute("number:position", number_position);
    }
    number_embedded_text(KoXmlWriter* x, qint64 number_position) :OdfWriter(x, "number:embedded-text", false) {
        addAttribute("number:position", number_position);
    }
    void addTextNode(const QString& data) {
        OdfWriter::addTextNode(data);
    }
};
class number_minutes : public OdfWriter {
public:
    number_minutes(OdfWriter* x) :OdfWriter(x, "number:minutes", false) {
    }
    number_minutes(KoXmlWriter* x) :OdfWriter(x, "number:minutes", false) {
    }
    template<class T>
    void set_number_style(const T& value) {
        addAttribute("number:style", value);
    }
    void addTextNode(const QString& data) {
        OdfWriter::addTextNode(data);
    }
};
class number_text : public OdfWriter {
public:
    number_text(OdfWriter* x) :OdfWriter(x, "number:text", false) {
    }
    number_text(KoXmlWriter* x) :OdfWriter(x, "number:text", false) {
    }
    void addTextNode(const QString& data) {
        OdfWriter::addTextNode(data);
    }
};
class number_boolean : public OdfWriter {
public:
    number_boolean(OdfWriter* x) :OdfWriter(x, "number:boolean", false) {
    }
    number_boolean(KoXmlWriter* x) :OdfWriter(x, "number:boolean", false) {
    }
    void addTextNode(const QString& data) {
        OdfWriter::addTextNode(data);
    }
};
class number_currency_style : public OdfWriter, public group_common_auto_reorder_attlist, public group_common_data_style_attlist, public group_number_and_text, public group_style_map, public group_style_text_properties {
public:
    number_currency_style(OdfWriter* x, const QString& style_name) :OdfWriter(x, "number:currency-style", true), group_common_auto_reorder_attlist(*static_cast<OdfWriter*>(this)), group_common_data_style_attlist(*static_cast<OdfWriter*>(this), style_name), group_number_and_text(*static_cast<OdfWriter*>(this)), group_style_map(*static_cast<OdfWriter*>(this)), group_style_text_properties(*static_cast<OdfWriter*>(this)) {
    }
    number_currency_style(KoXmlWriter* x, const QString& style_name) :OdfWriter(x, "number:currency-style", true), group_common_auto_reorder_attlist(*static_cast<OdfWriter*>(this)), group_common_data_style_attlist(*static_cast<OdfWriter*>(this), style_name), group_number_and_text(*static_cast<OdfWriter*>(this)), group_style_map(*static_cast<OdfWriter*>(this)), group_style_text_properties(*static_cast<OdfWriter*>(this)) {
    }
    number_currency_symbol add_number_currency_symbol();
};
class number_hours : public OdfWriter {
public:
    number_hours(OdfWriter* x) :OdfWriter(x, "number:hours", false) {
    }
    number_hours(KoXmlWriter* x) :OdfWriter(x, "number:hours", false) {
    }
    template<class T>
    void set_number_style(const T& value) {
        addAttribute("number:style", value);
    }
    void addTextNode(const QString& data) {
        OdfWriter::addTextNode(data);
    }
};
class number_percentage_style : public OdfWriter, public group_common_data_style_attlist, public group_number_and_text, public group_style_map, public group_style_text_properties {
public:
    number_percentage_style(OdfWriter* x, const QString& style_name) :OdfWriter(x, "number:percentage-style", true), group_common_data_style_attlist(*static_cast<OdfWriter*>(this), style_name), group_number_and_text(*static_cast<OdfWriter*>(this)), group_style_map(*static_cast<OdfWriter*>(this)), group_style_text_properties(*static_cast<OdfWriter*>(this)) {
    }
    number_percentage_style(KoXmlWriter* x, const QString& style_name) :OdfWriter(x, "number:percentage-style", true), group_common_data_style_attlist(*static_cast<OdfWriter*>(this), style_name), group_number_and_text(*static_cast<OdfWriter*>(this)), group_style_map(*static_cast<OdfWriter*>(this)), group_style_text_properties(*static_cast<OdfWriter*>(this)) {
    }
};
class number_text_content : public OdfWriter {
public:
    number_text_content(OdfWriter* x) :OdfWriter(x, "number:text-content", false) {
    }
    number_text_content(KoXmlWriter* x) :OdfWriter(x, "number:text-content", false) {
    }
    void addTextNode(const QString& data) {
        OdfWriter::addTextNode(data);
    }
};
class number_boolean_style : public OdfWriter, public group_common_data_style_attlist, public group_number_text, public group_style_map, public group_style_text_properties {
public:
    number_boolean_style(OdfWriter* x, const QString& style_name) :OdfWriter(x, "number:boolean-style", true), group_common_data_style_attlist(*static_cast<OdfWriter*>(this), style_name), group_number_text(*static_cast<OdfWriter*>(this)), group_style_map(*static_cast<OdfWriter*>(this)), group_style_text_properties(*static_cast<OdfWriter*>(this)) {
    }
    number_boolean_style(KoXmlWriter* x, const QString& style_name) :OdfWriter(x, "number:boolean-style", true), group_common_data_style_attlist(*static_cast<OdfWriter*>(this), style_name), group_number_text(*static_cast<OdfWriter*>(this)), group_style_map(*static_cast<OdfWriter*>(this)), group_style_text_properties(*static_cast<OdfWriter*>(this)) {
    }
    number_boolean add_number_boolean();
};
class number_day : public OdfWriter, public group_common_calendar_attlist {
public:
    number_day(OdfWriter* x) :OdfWriter(x, "number:day", false), group_common_calendar_attlist(*static_cast<OdfWriter*>(this)) {
    }
    number_day(KoXmlWriter* x) :OdfWriter(x, "number:day", false), group_common_calendar_attlist(*static_cast<OdfWriter*>(this)) {
    }
    template<class T>
    void set_number_style(const T& value) {
        addAttribute("number:style", value);
    }
    void addTextNode(const QString& data) {
        OdfWriter::addTextNode(data);
    }
};
class number_era : public OdfWriter, public group_common_calendar_attlist {
public:
    number_era(OdfWriter* x) :OdfWriter(x, "number:era", false), group_common_calendar_attlist(*static_cast<OdfWriter*>(this)) {
    }
    number_era(KoXmlWriter* x) :OdfWriter(x, "number:era", false), group_common_calendar_attlist(*static_cast<OdfWriter*>(this)) {
    }
    template<class T>
    void set_number_style(const T& value) {
        addAttribute("number:style", value);
    }
    void addTextNode(const QString& data) {
        OdfWriter::addTextNode(data);
    }
};
class number_month : public OdfWriter, public group_common_calendar_attlist {
public:
    number_month(OdfWriter* x) :OdfWriter(x, "number:month", false), group_common_calendar_attlist(*static_cast<OdfWriter*>(this)) {
    }
    number_month(KoXmlWriter* x) :OdfWriter(x, "number:month", false), group_common_calendar_attlist(*static_cast<OdfWriter*>(this)) {
    }
    template<class T>
    void set_calligra_number_length(const T& value) {
        addAttribute("calligra:number-length", value);
    }
    template<class T>
    void set_number_possessive_form(const T& value) {
        addAttribute("number:possessive-form", value);
    }
    template<class T>
    void set_number_style(const T& value) {
        addAttribute("number:style", value);
    }
    template<class T>
    void set_number_textual(const T& value) {
        addAttribute("number:textual", value);
    }
    void addTextNode(const QString& data) {
        OdfWriter::addTextNode(data);
    }
};
class number_number_style : public OdfWriter, public group_common_data_style_attlist, public group_number_number, public group_number_text, public group_style_map, public group_style_text_properties {
public:
    number_number_style(OdfWriter* x, const QString& style_name) :OdfWriter(x, "number:number-style", true), group_common_data_style_attlist(*static_cast<OdfWriter*>(this), style_name), group_number_number(*static_cast<OdfWriter*>(this)), group_number_text(*static_cast<OdfWriter*>(this)), group_style_map(*static_cast<OdfWriter*>(this)), group_style_text_properties(*static_cast<OdfWriter*>(this)) {
    }
    number_number_style(KoXmlWriter* x, const QString& style_name) :OdfWriter(x, "number:number-style", true), group_common_data_style_attlist(*static_cast<OdfWriter*>(this), style_name), group_number_number(*static_cast<OdfWriter*>(this)), group_number_text(*static_cast<OdfWriter*>(this)), group_style_map(*static_cast<OdfWriter*>(this)), group_style_text_properties(*static_cast<OdfWriter*>(this)) {
    }
    number_fraction add_number_fraction();
    number_scientific_number add_number_scientific_number();
};
class number_text_style : public OdfWriter, public group_common_data_style_attlist, public group_number_text, public group_style_map, public group_style_text_properties {
public:
    number_text_style(OdfWriter* x, const QString& style_name) :OdfWriter(x, "number:text-style", true), group_common_data_style_attlist(*static_cast<OdfWriter*>(this), style_name), group_number_text(*static_cast<OdfWriter*>(this)), group_style_map(*static_cast<OdfWriter*>(this)), group_style_text_properties(*static_cast<OdfWriter*>(this)) {
    }
    number_text_style(KoXmlWriter* x, const QString& style_name) :OdfWriter(x, "number:text-style", true), group_common_data_style_attlist(*static_cast<OdfWriter*>(this), style_name), group_number_text(*static_cast<OdfWriter*>(this)), group_style_map(*static_cast<OdfWriter*>(this)), group_style_text_properties(*static_cast<OdfWriter*>(this)) {
    }
    number_text_content add_number_text_content();
};
class number_week_of_year : public OdfWriter, public group_common_calendar_attlist {
public:
    number_week_of_year(OdfWriter* x) :OdfWriter(x, "number:week-of-year", false), group_common_calendar_attlist(*static_cast<OdfWriter*>(this)) {
    }
    number_week_of_year(KoXmlWriter* x) :OdfWriter(x, "number:week-of-year", false), group_common_calendar_attlist(*static_cast<OdfWriter*>(this)) {
    }
    void addTextNode(const QString& data) {
        OdfWriter::addTextNode(data);
    }
};
class number_day_of_week : public OdfWriter, public group_common_calendar_attlist {
public:
    number_day_of_week(OdfWriter* x) :OdfWriter(x, "number:day-of-week", false), group_common_calendar_attlist(*static_cast<OdfWriter*>(this)) {
    }
    number_day_of_week(KoXmlWriter* x) :OdfWriter(x, "number:day-of-week", false), group_common_calendar_attlist(*static_cast<OdfWriter*>(this)) {
    }
    template<class T>
    void set_number_style(const T& value) {
        addAttribute("number:style", value);
    }
    void addTextNode(const QString& data) {
        OdfWriter::addTextNode(data);
    }
};
class number_time_style : public OdfWriter, public group_common_data_style_attlist, public group_common_format_source_attlist, public group_number_am_pm, public group_number_hours, public group_number_minutes, public group_number_seconds, public group_number_text, public group_style_map, public group_style_text_properties {
public:
    number_time_style(OdfWriter* x, const QString& style_name) :OdfWriter(x, "number:time-style", true), group_common_data_style_attlist(*static_cast<OdfWriter*>(this), style_name), group_common_format_source_attlist(*static_cast<OdfWriter*>(this)), group_number_am_pm(*static_cast<OdfWriter*>(this)), group_number_hours(*static_cast<OdfWriter*>(this)), group_number_minutes(*static_cast<OdfWriter*>(this)), group_number_seconds(*static_cast<OdfWriter*>(this)), group_number_text(*static_cast<OdfWriter*>(this)), group_style_map(*static_cast<OdfWriter*>(this)), group_style_text_properties(*static_cast<OdfWriter*>(this)) {
    }
    number_time_style(KoXmlWriter* x, const QString& style_name) :OdfWriter(x, "number:time-style", true), group_common_data_style_attlist(*static_cast<OdfWriter*>(this), style_name), group_common_format_source_attlist(*static_cast<OdfWriter*>(this)), group_number_am_pm(*static_cast<OdfWriter*>(this)), group_number_hours(*static_cast<OdfWriter*>(this)), group_number_minutes(*static_cast<OdfWriter*>(this)), group_number_seconds(*static_cast<OdfWriter*>(this)), group_number_text(*static_cast<OdfWriter*>(this)), group_style_map(*static_cast<OdfWriter*>(this)), group_style_text_properties(*static_cast<OdfWriter*>(this)) {
    }
    template<class T>
    void set_number_truncate_on_overflow(const T& value) {
        addAttribute("number:truncate-on-overflow", value);
    }
};
class number_fraction : public OdfWriter, public group_common_number_attlist {
public:
    number_fraction(OdfWriter* x) :OdfWriter(x, "number:fraction", false), group_common_number_attlist(*static_cast<OdfWriter*>(this)) {
    }
    number_fraction(KoXmlWriter* x) :OdfWriter(x, "number:fraction", false), group_common_number_attlist(*static_cast<OdfWriter*>(this)) {
    }
    void set_number_denominator_value(qint64 value) {
        addAttribute("number:denominator-value", value);
    }
    void set_number_min_denominator_digits(qint64 value) {
        addAttribute("number:min-denominator-digits", value);
    }
    void set_number_min_numerator_digits(qint64 value) {
        addAttribute("number:min-numerator-digits", value);
    }
    void addTextNode(const QString& data) {
        OdfWriter::addTextNode(data);
    }
};
class number_quarter : public OdfWriter, public group_common_calendar_attlist {
public:
    number_quarter(OdfWriter* x) :OdfWriter(x, "number:quarter", false), group_common_calendar_attlist(*static_cast<OdfWriter*>(this)) {
    }
    number_quarter(KoXmlWriter* x) :OdfWriter(x, "number:quarter", false), group_common_calendar_attlist(*static_cast<OdfWriter*>(this)) {
    }
    template<class T>
    void set_number_style(const T& value) {
        addAttribute("number:style", value);
    }
    void addTextNode(const QString& data) {
        OdfWriter::addTextNode(data);
    }
};
class number_seconds : public OdfWriter {
public:
    number_seconds(OdfWriter* x) :OdfWriter(x, "number:seconds", false) {
    }
    number_seconds(KoXmlWriter* x) :OdfWriter(x, "number:seconds", false) {
    }
    void set_number_decimal_places(qint64 value) {
        addAttribute("number:decimal-places", value);
    }
    template<class T>
    void set_number_style(const T& value) {
        addAttribute("number:style", value);
    }
    void addTextNode(const QString& data) {
        OdfWriter::addTextNode(data);
    }
};
class number_number : public OdfWriter, public group_common_decimal_places_attlist, public group_common_number_attlist {
public:
    number_number(OdfWriter* x) :OdfWriter(x, "number:number", true), group_common_decimal_places_attlist(*static_cast<OdfWriter*>(this)), group_common_number_attlist(*static_cast<OdfWriter*>(this)) {
    }
    number_number(KoXmlWriter* x) :OdfWriter(x, "number:number", true), group_common_decimal_places_attlist(*static_cast<OdfWriter*>(this)), group_common_number_attlist(*static_cast<OdfWriter*>(this)) {
    }
    number_embedded_text add_number_embedded_text(qint64 number_position);
    void set_number_decimal_replacement(const QString& value) {
        addAttribute("number:decimal-replacement", value);
    }
    void set_number_display_factor(double value) {
        addAttribute("number:display-factor", value);
    }
};
class number_year : public OdfWriter, public group_common_calendar_attlist {
public:
    number_year(OdfWriter* x) :OdfWriter(x, "number:year", false), group_common_calendar_attlist(*static_cast<OdfWriter*>(this)) {
    }
    number_year(KoXmlWriter* x) :OdfWriter(x, "number:year", false), group_common_calendar_attlist(*static_cast<OdfWriter*>(this)) {
    }
    template<class T>
    void set_number_style(const T& value) {
        addAttribute("number:style", value);
    }
    void addTextNode(const QString& data) {
        OdfWriter::addTextNode(data);
    }
};
class number_scientific_number : public OdfWriter, public group_common_decimal_places_attlist, public group_common_number_attlist {
public:
    number_scientific_number(OdfWriter* x) :OdfWriter(x, "number:scientific-number", false), group_common_decimal_places_attlist(*static_cast<OdfWriter*>(this)), group_common_number_attlist(*static_cast<OdfWriter*>(this)) {
    }
    number_scientific_number(KoXmlWriter* x) :OdfWriter(x, "number:scientific-number", false), group_common_decimal_places_attlist(*static_cast<OdfWriter*>(this)), group_common_number_attlist(*static_cast<OdfWriter*>(this)) {
    }
    void set_number_min_exponent_digits(qint64 value) {
        addAttribute("number:min-exponent-digits", value);
    }
    void addTextNode(const QString& data) {
        OdfWriter::addTextNode(data);
    }
};
class number_date_style : public OdfWriter, public group_common_auto_reorder_attlist, public group_common_data_style_attlist, public group_common_format_source_attlist, public group_number_am_pm, public group_number_hours, public group_number_minutes, public group_number_seconds, public group_number_text, public group_style_map, public group_style_text_properties {
public:
    number_date_style(OdfWriter* x, const QString& style_name) :OdfWriter(x, "number:date-style", true), group_common_auto_reorder_attlist(*static_cast<OdfWriter*>(this)), group_common_data_style_attlist(*static_cast<OdfWriter*>(this), style_name), group_common_format_source_attlist(*static_cast<OdfWriter*>(this)), group_number_am_pm(*static_cast<OdfWriter*>(this)), group_number_hours(*static_cast<OdfWriter*>(this)), group_number_minutes(*static_cast<OdfWriter*>(this)), group_number_seconds(*static_cast<OdfWriter*>(this)), group_number_text(*static_cast<OdfWriter*>(this)), group_style_map(*static_cast<OdfWriter*>(this)), group_style_text_properties(*static_cast<OdfWriter*>(this)) {
    }
    number_date_style(KoXmlWriter* x, const QString& style_name) :OdfWriter(x, "number:date-style", true), group_common_auto_reorder_attlist(*static_cast<OdfWriter*>(this)), group_common_data_style_attlist(*static_cast<OdfWriter*>(this), style_name), group_common_format_source_attlist(*static_cast<OdfWriter*>(this)), group_number_am_pm(*static_cast<OdfWriter*>(this)), group_number_hours(*static_cast<OdfWriter*>(this)), group_number_minutes(*static_cast<OdfWriter*>(this)), group_number_seconds(*static_cast<OdfWriter*>(this)), group_number_text(*static_cast<OdfWriter*>(this)), group_style_map(*static_cast<OdfWriter*>(this)), group_style_text_properties(*static_cast<OdfWriter*>(this)) {
    }
    number_day add_number_day();
    number_day_of_week add_number_day_of_week();
    number_era add_number_era();
    number_month add_number_month();
    number_quarter add_number_quarter();
    number_week_of_year add_number_week_of_year();
    number_year add_number_year();
};
}
inline writeodf::number_am_pm
writeodf::group_number_am_pm::add_number_am_pm() {
    return writeodf::number_am_pm(&xml);
}
inline writeodf::number_hours
writeodf::group_number_hours::add_number_hours() {
    return writeodf::number_hours(&xml);
}
inline writeodf::number_number
writeodf::group_number_number::add_number_number() {
    return writeodf::number_number(&xml);
}
inline writeodf::number_text
writeodf::group_number_text::add_number_text() {
    return writeodf::number_text(&xml);
}
inline writeodf::number_seconds
writeodf::group_number_seconds::add_number_seconds() {
    return writeodf::number_seconds(&xml);
}
inline writeodf::number_currency_symbol
writeodf::number_currency_style::add_number_currency_symbol() {
    return writeodf::number_currency_symbol(this);
}
inline writeodf::number_boolean
writeodf::number_boolean_style::add_number_boolean() {
    return writeodf::number_boolean(this);
}
inline writeodf::number_fraction
writeodf::number_number_style::add_number_fraction() {
    return writeodf::number_fraction(this);
}
inline writeodf::number_scientific_number
writeodf::number_number_style::add_number_scientific_number() {
    return writeodf::number_scientific_number(this);
}
inline writeodf::number_text_content
writeodf::number_text_style::add_number_text_content() {
    return writeodf::number_text_content(this);
}
inline writeodf::number_minutes
writeodf::group_number_minutes::add_number_minutes() {
    return writeodf::number_minutes(&xml);
}
inline writeodf::number_boolean_style
writeodf::group_styles::add_number_boolean_style(const QString& style_name) {
    return writeodf::number_boolean_style(&xml, style_name);
}
inline writeodf::number_currency_style
writeodf::group_styles::add_number_currency_style(const QString& style_name) {
    return writeodf::number_currency_style(&xml, style_name);
}
inline writeodf::number_date_style
writeodf::group_styles::add_number_date_style(const QString& style_name) {
    return writeodf::number_date_style(&xml, style_name);
}
inline writeodf::number_number_style
writeodf::group_styles::add_number_number_style(const QString& style_name) {
    return writeodf::number_number_style(&xml, style_name);
}
inline writeodf::number_percentage_style
writeodf::group_styles::add_number_percentage_style(const QString& style_name) {
    return writeodf::number_percentage_style(&xml, style_name);
}
inline writeodf::number_text_style
writeodf::group_styles::add_number_text_style(const QString& style_name) {
    return writeodf::number_text_style(&xml, style_name);
}
inline writeodf::number_time_style
writeodf::group_styles::add_number_time_style(const QString& style_name) {
    return writeodf::number_time_style(&xml, style_name);
}
inline writeodf::number_embedded_text
writeodf::number_number::add_number_embedded_text(qint64 number_position) {
    return writeodf::number_embedded_text(this, number_position);
}
inline writeodf::number_day
writeodf::number_date_style::add_number_day() {
    return writeodf::number_day(this);
}
inline writeodf::number_day_of_week
writeodf::number_date_style::add_number_day_of_week() {
    return writeodf::number_day_of_week(this);
}
inline writeodf::number_era
writeodf::number_date_style::add_number_era() {
    return writeodf::number_era(this);
}
inline writeodf::number_month
writeodf::number_date_style::add_number_month() {
    return writeodf::number_month(this);
}
inline writeodf::number_quarter
writeodf::number_date_style::add_number_quarter() {
    return writeodf::number_quarter(this);
}
inline writeodf::number_week_of_year
writeodf::number_date_style::add_number_week_of_year() {
    return writeodf::number_week_of_year(this);
}
inline writeodf::number_year
writeodf::number_date_style::add_number_year() {
    return writeodf::number_year(this);
}
#endif
