﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/accessanalyzer/model/GetFindingsStatisticsResult.h>
#include <aws/core/AmazonWebServiceResult.h>
#include <aws/core/utils/StringUtils.h>
#include <aws/core/utils/UnreferencedParam.h>
#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/core/utils/memory/stl/AWSStringStream.h>

#include <utility>

using namespace Aws::AccessAnalyzer::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;
using namespace Aws;

GetFindingsStatisticsResult::GetFindingsStatisticsResult(const Aws::AmazonWebServiceResult<JsonValue>& result) { *this = result; }

GetFindingsStatisticsResult& GetFindingsStatisticsResult::operator=(const Aws::AmazonWebServiceResult<JsonValue>& result) {
  JsonView jsonValue = result.GetPayload().View();
  if (jsonValue.ValueExists("findingsStatistics")) {
    Aws::Utils::Array<JsonView> findingsStatisticsJsonList = jsonValue.GetArray("findingsStatistics");
    for (unsigned findingsStatisticsIndex = 0; findingsStatisticsIndex < findingsStatisticsJsonList.GetLength();
         ++findingsStatisticsIndex) {
      m_findingsStatistics.push_back(findingsStatisticsJsonList[findingsStatisticsIndex].AsObject());
    }
    m_findingsStatisticsHasBeenSet = true;
  }
  if (jsonValue.ValueExists("lastUpdatedAt")) {
    m_lastUpdatedAt = jsonValue.GetString("lastUpdatedAt");
    m_lastUpdatedAtHasBeenSet = true;
  }

  const auto& headers = result.GetHeaderValueCollection();
  const auto& requestIdIter = headers.find("x-amzn-requestid");
  if (requestIdIter != headers.end()) {
    m_requestId = requestIdIter->second;
    m_requestIdHasBeenSet = true;
  }

  return *this;
}
