/**
 * Copyright (c) 1997 Ben Harrison, James E. Wilson, Robert A. Koeneke
 * Copyright (c) 2007-9 Andi Sidwell, Chris Carr, Ed Graham, Erik Osheim
 *
 * This work is free software; you can redistribute it and/or modify it
 * under the terms of either:
 *
 * a) the GNU General Public License as published by the Free Software
 *    Foundation, version 2, or
 *
 * b) the "Angband License":
 *    This software may be copied and distributed for educational, research,
 *    and not for profit purposes provided that this copyright and statement
 *    are included in all such copies.  Other copyrights may also apply.
 */
#ifndef INCLUDED_BORG_CAVE_VIEW_H
#define INCLUDED_BORG_CAVE_VIEW_H

/*
 * must be included before ALLOW_BORG to avoid empty compilation unit
 */
#include "../angband.h"

#ifdef ALLOW_BORG

/*
 * Maximum size of the "view" array
 */
/*#define AUTO_VIEW_MAX 1536*/
#define AUTO_VIEW_MAX 9000

/*
 * Flags for the "info" field of grids
 *
 * Note that some of the flags below are not "perfect", in particular,
 * several of the flags should be treated as "best guesses", see below.
 *
 * The "BORG_MARK" flag means that the grid has been "observed", though
 * the terrain feature may or may not be memorized.  Note the use of the
 * "FEAT_NONE" and "FEAT_FLOOR" feature codes below.
 *
 * The "BORG_GLOW" flag means that a grid is probably "perma-lit", but
 * sometimes it is really only "recently" perma-lit, but was then made
 * dark with a darkness attack, and it is now torch-lit or off-screen.
 *
 * The "BORG_DARK" flag means that a grid is probably not "perma-lit",
 * but sometimes it is really only "recently" dark, but was then made
 * "lite" with a "call lite" spell, and it is now torch-lit or off-screen.
 *
 * The "BORG_LIGHT" flag means that a grid is probably lit by the player
 * torch, but this may not be true if the nearby "BORG_VIEW" flags are
 * not correct, or if the "lite radius" has changed recently.
 *
 * The "BORG_VIEW" flag means that a grid is probably in line of sight
 * of the player, but this may not be true if some of the grids between
 * the player and the grid contain previously unseen walls/doors/etc.
 *
 * The "BORG_TEMP" flag means that a grid has been added to the array
 * "borg_temp_x"/"borg_temp_y", though normally we ignore this flag.
 *
 * The "BORG_XTRA" flag is used for various "extra" purposes, primarily
 * to assist with the "update_view()" code.
 *
 * The "BORG_IGNORE_MAP" flag causes the borg to prefer what it thinks
 * is in a unseen grid to what is returned by map_info().
 */
#define BORG_MARK  0x01 /* observed grid */
#define BORG_GLOW  0x02 /* probably perma-lit */
#define BORG_DARK  0x04 /* probably not perma-lit */
#define BORG_OKAY  0x08 /* on the current panel */
#define BORG_LIGHT 0x10 /* lit by the torch */
#define BORG_VIEW  0x20 /* in line of sight */
#define BORG_TEMP  0x40 /* temporary flag */
#define BORG_XTRA  0x80 /* extra flag */
#define BORG_IGNORE_MAP 0x100 /* ignore unseen grid from map_info() */

/*
 * Maintain a set of grids (viewable grids)
 */

extern int16_t borg_view_n;
extern uint8_t borg_view_y[AUTO_VIEW_MAX];
extern uint8_t borg_view_x[AUTO_VIEW_MAX];

/*
 * Forget the "view"
 */
extern void borg_forget_view(void);

/*
 * Update the "view"
 */
extern void borg_update_view(void);

#endif
#endif
