/* do not edit automatically generated by mc from FifoQueue.  */
/* FifoQueue.mod provides a simple fifo queue.

Copyright (C) 2001-2025 Free Software Foundation, Inc.
Contributed by Gaius Mulley <gaius.mulley@southwales.ac.uk>.

This file is part of GNU Modula-2.

GNU Modula-2 is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 3, or (at your option)
any later version.

GNU Modula-2 is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU Modula-2; see the file COPYING3.  If not see
<http://www.gnu.org/licenses/>.  */

#include "config.h"
#include "system.h"
#include <stdbool.h>
#   if !defined (PROC_D)
#      define PROC_D
       typedef void (*PROC_t) (void);
       typedef struct { PROC_t proc; } PROC;
#   endif

#define _FifoQueue_C

#include "GFifoQueue.h"
#   include "GLists.h"

typedef struct FifoQueue_Fifo_r FifoQueue_Fifo;

struct FifoQueue_Fifo_r {
                          Lists_List Queue;
                          unsigned int Out;
                        };

static FifoQueue_Fifo const_;
static FifoQueue_Fifo subrange;
static FifoQueue_Fifo enumeration;
static FifoQueue_Fifo constructor;

/*
   PutEnumerationIntoFifoQueue - places an enumeration symbol, c,
                                 into a fifo queue.
*/

extern "C" void FifoQueue_PutEnumerationIntoFifoQueue (unsigned int c);

/*
   GetEnumerationFromFifoQueue - retrieves an enumeration symbol,
                                 c, from a fifo queue.
*/

extern "C" void FifoQueue_GetEnumerationFromFifoQueue (unsigned int *c);

/*
   PutSubrangeIntoFifoQueue - places a subrange symbol into a fifo
                              queue.
*/

extern "C" void FifoQueue_PutSubrangeIntoFifoQueue (unsigned int c);

/*
   GetSubrangeFromFifoQueue - retrieves a subrange symbol from a
                              fifo queue.
*/

extern "C" void FifoQueue_GetSubrangeFromFifoQueue (unsigned int *c);

/*
   PutConstIntoFifoQueue - places a constant symbol
                           into a fifo queue.
*/

extern "C" void FifoQueue_PutConstIntoFifoQueue (unsigned int c);

/*
   GetConstFromFifoQueue - retrieves a const symbol
                           from a fifo queue.
*/

extern "C" void FifoQueue_GetConstFromFifoQueue (unsigned int *c);

/*
   PutConstructorIntoFifoQueue - places a constructor symbol
                                 into a fifo queue.
*/

extern "C" void FifoQueue_PutConstructorIntoFifoQueue (unsigned int c);

/*
   GetConstructorFromFifoQueue - retrieves a constructor symbol
                                 from a fifo queue.
*/

extern "C" void FifoQueue_GetConstructorFromFifoQueue (unsigned int *c);

/*
   PutInto - places a CARDINAL number, c, into a fifo queue.
*/

static void PutInto (FifoQueue_Fifo *f, unsigned int c);

/*
   GetFrom - retrieves a CARDINAL number, c, from a fifo queue.
*/

static void GetFrom (FifoQueue_Fifo *f, unsigned int *c);

/*
   Init - initialize the fifo queue.
*/

static void Init (FifoQueue_Fifo *f);


/*
   PutInto - places a CARDINAL number, c, into a fifo queue.
*/

static void PutInto (FifoQueue_Fifo *f, unsigned int c)
{
  Lists_PutItemIntoList ((*f).Queue, c);
}


/*
   GetFrom - retrieves a CARDINAL number, c, from a fifo queue.
*/

static void GetFrom (FifoQueue_Fifo *f, unsigned int *c)
{
  (*f).Out += 1;
  (*c) = static_cast<unsigned int> (Lists_GetItemFromList ((*f).Queue, (*f).Out));
}


/*
   Init - initialize the fifo queue.
*/

static void Init (FifoQueue_Fifo *f)
{
  Lists_InitList (&(*f).Queue);
  (*f).Out = 0;
}


/*
   PutEnumerationIntoFifoQueue - places an enumeration symbol, c,
                                 into a fifo queue.
*/

extern "C" void FifoQueue_PutEnumerationIntoFifoQueue (unsigned int c)
{
  PutInto (&enumeration, c);
}


/*
   GetEnumerationFromFifoQueue - retrieves an enumeration symbol,
                                 c, from a fifo queue.
*/

extern "C" void FifoQueue_GetEnumerationFromFifoQueue (unsigned int *c)
{
  GetFrom (&enumeration, c);
}


/*
   PutSubrangeIntoFifoQueue - places a subrange symbol into a fifo
                              queue.
*/

extern "C" void FifoQueue_PutSubrangeIntoFifoQueue (unsigned int c)
{
  PutInto (&subrange, c);
}


/*
   GetSubrangeFromFifoQueue - retrieves a subrange symbol from a
                              fifo queue.
*/

extern "C" void FifoQueue_GetSubrangeFromFifoQueue (unsigned int *c)
{
  GetFrom (&subrange, c);
}


/*
   PutConstIntoFifoQueue - places a constant symbol
                           into a fifo queue.
*/

extern "C" void FifoQueue_PutConstIntoFifoQueue (unsigned int c)
{
  PutInto (&const_, c);
}


/*
   GetConstFromFifoQueue - retrieves a const symbol
                           from a fifo queue.
*/

extern "C" void FifoQueue_GetConstFromFifoQueue (unsigned int *c)
{
  GetFrom (&const_, c);
}


/*
   PutConstructorIntoFifoQueue - places a constructor symbol
                                 into a fifo queue.
*/

extern "C" void FifoQueue_PutConstructorIntoFifoQueue (unsigned int c)
{
  PutInto (&constructor, c);
}


/*
   GetConstructorFromFifoQueue - retrieves a constructor symbol
                                 from a fifo queue.
*/

extern "C" void FifoQueue_GetConstructorFromFifoQueue (unsigned int *c)
{
  GetFrom (&constructor, c);
}

extern "C" void _M2_FifoQueue_init (__attribute__((unused)) int argc, __attribute__((unused)) char *argv[], __attribute__((unused)) char *envp[])
{
  Init (&const_);
  Init (&enumeration);
  Init (&subrange);
  Init (&constructor);
}

extern "C" void _M2_FifoQueue_fini (__attribute__((unused)) int argc, __attribute__((unused)) char *argv[], __attribute__((unused)) char *envp[])
{
}
